/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.build.aws;

import ai.tock.nlp.build.aws.WorkerOnAwsBatch;
import ai.tock.nlp.build.aws.WorkerOnAwsBatchProperties;
import ai.tock.nlp.build.ondemand.WorkerOnDemand;
import ai.tock.nlp.build.ondemand.WorkerOnDemandStatus;
import ai.tock.nlp.build.ondemand.WorkerOnDemandSummary;
import ai.tock.shared.vertx.VertXsKt;
import com.amazonaws.services.batch.AWSBatch;
import com.amazonaws.services.batch.AWSBatchClientBuilder;
import com.amazonaws.services.batch.model.ContainerOverrides;
import com.amazonaws.services.batch.model.DescribeJobsRequest;
import com.amazonaws.services.batch.model.JobDetail;
import com.amazonaws.services.batch.model.JobStatus;
import com.amazonaws.services.batch.model.JobSummary;
import com.amazonaws.services.batch.model.JobTimeout;
import com.amazonaws.services.batch.model.KeyValuePair;
import com.amazonaws.services.batch.model.ListJobsRequest;
import com.amazonaws.services.batch.model.ListJobsResult;
import com.amazonaws.services.batch.model.SubmitJobRequest;
import io.vertx.core.Vertx;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0014H\u0002J+\u0010\u0018\u001a\u00020\u00192!\u0010\u001a\u001a\u001d\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00190\u001bH\u0016J\b\u0010 \u001a\u00020\u0012H\u0016J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u0006H\u0002J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J*\u0010%\u001a\u0010\u0012\f\u0012\n (*\u0004\u0018\u00010'0'0&*\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007H\u0002J\f\u0010)\u001a\u00020\u0012*\u00020*H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lai/tock/nlp/build/aws/WorkerOnAwsBatch;", "Lai/tock/nlp/build/ondemand/WorkerOnDemand;", "workerOnAwsBatchProperties", "Lai/tock/nlp/build/aws/WorkerOnAwsBatchProperties;", "workerProperties", "", "", "Lai/tock/nlp/build/ondemand/WorkerProperties;", "batchClient", "Lcom/amazonaws/services/batch/AWSBatch;", "(Lai/tock/nlp/build/aws/WorkerOnAwsBatchProperties;Ljava/util/Map;Lcom/amazonaws/services/batch/AWSBatch;)V", "logger", "Lmu/KLogger;", "submitJobRequest", "Lcom/amazonaws/services/batch/model/SubmitJobRequest;", "getSubmitJobRequest", "()Lcom/amazonaws/services/batch/model/SubmitJobRequest;", "workerOnDemandSummary", "Lai/tock/nlp/build/ondemand/WorkerOnDemandSummary;", "jobSummaryByStatus", "Lcom/amazonaws/services/batch/model/JobSummary;", "jobStatus", "Lcom/amazonaws/services/batch/model/JobStatus;", "runningJob", "start", "", "callback", "Lkotlin/Function1;", "Lai/tock/nlp/build/ondemand/WorkerOnDemandStatus;", "Lkotlin/ParameterName;", "name", "status", "summary", "jobId", "jobName", "createdAt", "", "toKeyValuePairs", "", "Lcom/amazonaws/services/batch/model/KeyValuePair;", "kotlin.jvm.PlatformType", "toWorkerOnDemandSummary", "Lcom/amazonaws/services/batch/model/JobDetail;", "tock-nlp-build-model-worker-on-aws-batch"})
public final class WorkerOnAwsBatch
implements WorkerOnDemand {
    @NotNull
    private final WorkerOnAwsBatchProperties workerOnAwsBatchProperties;
    @NotNull
    private final Map<String, String> workerProperties;
    @NotNull
    private final AWSBatch batchClient;
    @NotNull
    private final KLogger logger;
    @NotNull
    private WorkerOnDemandSummary workerOnDemandSummary;

    public WorkerOnAwsBatch(@NotNull WorkerOnAwsBatchProperties workerOnAwsBatchProperties, @NotNull Map<String, String> workerProperties, @NotNull AWSBatch batchClient) {
        Intrinsics.checkNotNullParameter((Object)workerOnAwsBatchProperties, (String)"workerOnAwsBatchProperties");
        Intrinsics.checkNotNullParameter(workerProperties, (String)"workerProperties");
        Intrinsics.checkNotNullParameter((Object)batchClient, (String)"batchClient");
        this.workerOnAwsBatchProperties = workerOnAwsBatchProperties;
        this.workerProperties = workerProperties;
        this.batchClient = batchClient;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.workerOnDemandSummary = new WorkerOnDemandSummary(this.workerOnAwsBatchProperties.getJobName(), null, null, WorkerOnDemandStatus.WAITING, 6, null);
    }

    public /* synthetic */ WorkerOnAwsBatch(WorkerOnAwsBatchProperties workerOnAwsBatchProperties, Map map, AWSBatch aWSBatch, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            AWSBatch aWSBatch2 = AWSBatchClientBuilder.defaultClient();
            Intrinsics.checkNotNullExpressionValue((Object)aWSBatch2, (String)"defaultClient()");
            aWSBatch = aWSBatch2;
        }
        this(workerOnAwsBatchProperties, map, aWSBatch);
    }

    private final SubmitJobRequest getSubmitJobRequest() {
        Collection $this$toTypedArray$iv = this.toKeyValuePairs(this.workerProperties);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        KeyValuePair[] keyValuePairArray = thisCollection$iv.toArray(new KeyValuePair[0]);
        if (keyValuePairArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        KeyValuePair[] keyValuePairArray2 = keyValuePairArray;
        SubmitJobRequest submitJobRequest = new SubmitJobRequest().withJobName(this.workerOnAwsBatchProperties.getJobName()).withJobDefinition(this.workerOnAwsBatchProperties.getJobDefinitionName()).withJobQueue(this.workerOnAwsBatchProperties.getJobQueueName()).withTimeout(new JobTimeout().withAttemptDurationSeconds(Integer.valueOf(this.workerOnAwsBatchProperties.getAttemptDurationSeconds()))).withContainerOverrides(new ContainerOverrides().withEnvironment(Arrays.copyOf(keyValuePairArray2, keyValuePairArray2.length)).withVcpus(Integer.valueOf(this.workerOnAwsBatchProperties.getVcpus())).withMemory(Integer.valueOf(this.workerOnAwsBatchProperties.getMemory())));
        Intrinsics.checkNotNullExpressionValue((Object)submitJobRequest, (String)"SubmitJobRequest()\n     \u2026ies.memory)\n            )");
        return submitJobRequest;
    }

    /*
     * WARNING - void declaration
     */
    private final WorkerOnDemandSummary summary(String jobId) {
        void $this$summary_u24lambda_u2d2_u24lambda_u2d1;
        Object element$iv2;
        WorkerOnAwsBatch workerOnAwsBatch;
        Iterable<Object> iterable;
        block1: {
            void $this$first$iv;
            String[] stringArray = new String[]{jobId};
            stringArray = this.batchClient.describeJobs(new DescribeJobsRequest().withJobs(stringArray));
            boolean bl = false;
            boolean bl2 = false;
            String[] $this$summary_u24lambda_u2d2 = stringArray;
            boolean bl3 = false;
            iterable = $this$summary_u24lambda_u2d2.getJobs();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"jobs");
            iterable = iterable;
            workerOnAwsBatch = this;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                JobDetail it = (JobDetail)element$iv2;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)it.getJobId(), (Object)jobId)) continue;
                break block1;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object object = element$iv2;
        iterable = object;
        boolean bl = false;
        boolean bl5 = false;
        element$iv2 = (JobDetail)iterable;
        boolean bl6 = false;
        this.logger.info((Function0)new Function0<Object>((JobDetail)$this$summary_u24lambda_u2d2_u24lambda_u2d1, jobId){
            final /* synthetic */ JobDetail $this_apply;
            final /* synthetic */ String $jobId;
            {
                this.$this_apply = $receiver;
                this.$jobId = $jobId;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Job " + this.$this_apply.getJobName() + " with id " + this.$jobId + " is " + this.$this_apply.getStatus();
            }
        });
        object = Unit.INSTANCE;
        Iterable<Object> iterable2 = iterable;
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"jobs\n                .fi\u2026atus\" }\n                }");
        return workerOnAwsBatch.toWorkerOnDemandSummary((JobDetail)iterable2);
    }

    private final JobSummary runningJob() {
        JobSummary jobSummary;
        JobSummary jobSummary2;
        JobSummary jobSummary3;
        JobSummary jobSummary4 = this.jobSummaryByStatus(JobStatus.RUNNING);
        JobSummary jobSummary5 = jobSummary4 == null ? ((jobSummary3 = this.jobSummaryByStatus(JobStatus.PENDING)) == null ? ((jobSummary2 = this.jobSummaryByStatus(JobStatus.RUNNABLE)) == null ? ((jobSummary = this.jobSummaryByStatus(JobStatus.SUBMITTED)) == null ? this.jobSummaryByStatus(JobStatus.STARTING) : jobSummary) : jobSummary2) : jobSummary3) : jobSummary4;
        return jobSummary5;
    }

    private final JobSummary jobSummaryByStatus(JobStatus jobStatus) {
        Object v0;
        block1: {
            ListJobsResult listJobsResult = this.batchClient.listJobs(new ListJobsRequest().withJobQueue(this.workerOnAwsBatchProperties.getJobQueueName()).withJobStatus(jobStatus));
            boolean bl = false;
            boolean bl2 = false;
            ListJobsResult $this$jobSummaryByStatus_u24lambda_u2d4 = listJobsResult;
            boolean bl3 = false;
            List list = $this$jobSummaryByStatus_u24lambda_u2d4.getJobSummaryList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"this.jobSummaryList");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JobSummary it = (JobSummary)element$iv;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)it.getJobName(), (Object)this.workerOnAwsBatchProperties.getJobName())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public void start(@NotNull Function1<? super WorkerOnDemandStatus, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.logger.info("WorkerOnAwsBatch starting for " + this.workerProperties.get("TOCK_BUILD_TYPE") + " build type");
        JobSummary jobSummary = this.runningJob();
        String string = jobSummary == null ? null : jobSummary.getJobId();
        String jobId = string == null ? this.batchClient.submitJob(this.getSubmitJobRequest()).getJobId() : string;
        VertXsKt.getVertx().setPeriodic(Duration.ofSeconds(10L).toMillis(), arg_0 -> WorkerOnAwsBatch.start$lambda-6(this, jobId, callback, arg_0));
    }

    @NotNull
    public WorkerOnDemandSummary summary() {
        return this.workerOnDemandSummary;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KeyValuePair> toKeyValuePairs(Map<String, String> $this$toKeyValuePairs) {
        void $this$mapTo$iv$iv;
        Map<String, String> $this$map$iv = $this$toKeyValuePairs;
        boolean $i$f$map = false;
        Map<String, String> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_7.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            KeyValuePair keyValuePair = new KeyValuePair().withName((String)it.getKey()).withValue((String)it.getValue());
            collection.add(keyValuePair);
        }
        return (List)destination$iv$iv;
    }

    private final WorkerOnDemandSummary workerOnDemandSummary(String jobName, String jobId, long createdAt, String status) {
        WorkerOnDemandStatus workerOnDemandStatus;
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(createdAt), TimeZone.getDefault().toZoneId());
        JobStatus jobStatus = JobStatus.fromValue((String)status);
        int n = jobStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$1[jobStatus.ordinal()];
        switch (n) {
            case 1: {
                workerOnDemandStatus = WorkerOnDemandStatus.RUNNING;
                break;
            }
            case 2: {
                workerOnDemandStatus = WorkerOnDemandStatus.RUNNING;
                break;
            }
            case 3: {
                workerOnDemandStatus = WorkerOnDemandStatus.RUNNING;
                break;
            }
            case 4: {
                workerOnDemandStatus = WorkerOnDemandStatus.RUNNING;
                break;
            }
            case 5: {
                workerOnDemandStatus = WorkerOnDemandStatus.RUNNING;
                break;
            }
            case 6: {
                workerOnDemandStatus = WorkerOnDemandStatus.SUCCEEDED;
                break;
            }
            default: {
                workerOnDemandStatus = WorkerOnDemandStatus.FAILED;
            }
        }
        return new WorkerOnDemandSummary(jobName, jobId, localDateTime, workerOnDemandStatus);
    }

    private final WorkerOnDemandSummary toWorkerOnDemandSummary(JobDetail $this$toWorkerOnDemandSummary) {
        Object object = $this$toWorkerOnDemandSummary.getJobName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jobName");
        String string = object;
        object = $this$toWorkerOnDemandSummary.getJobId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jobId");
        String string2 = object;
        object = $this$toWorkerOnDemandSummary.getCreatedAt();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createdAt");
        long l = ((Number)object).longValue();
        object = $this$toWorkerOnDemandSummary.getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"status");
        return this.workerOnDemandSummary(string, string2, l, (String)object);
    }

    private static final void start$lambda-6(WorkerOnAwsBatch this$0, String $jobId, Function1 $callback, Long periodicId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        Intrinsics.checkNotNullExpressionValue((Object)$jobId, (String)"jobId");
        WorkerOnDemandSummary workerOnDemandSummary = this$0.summary($jobId);
        boolean bl = false;
        boolean bl2 = false;
        WorkerOnDemandSummary $this$start_u24lambda_u2d6_u24lambda_u2d5 = workerOnDemandSummary;
        boolean bl3 = false;
        WorkerOnDemandStatus workerOnDemandStatus = $this$start_u24lambda_u2d6_u24lambda_u2d5.getStatus();
        int n = WhenMappings.$EnumSwitchMapping$0[workerOnDemandStatus.ordinal()];
        switch (n) {
            case 1: {
                this$0.logger.info("Job " + $jobId + " succeeded");
                $callback.invoke((Object)WorkerOnDemandStatus.SUCCEEDED);
                Vertx vertx = VertXsKt.getVertx();
                Intrinsics.checkNotNullExpressionValue((Object)periodicId, (String)"periodicId");
                vertx.cancelTimer(periodicId.longValue());
                break;
            }
            case 2: {
                this$0.logger.info("Job " + $jobId + " failed");
                $callback.invoke((Object)WorkerOnDemandStatus.FAILED);
                Vertx vertx = VertXsKt.getVertx();
                Intrinsics.checkNotNullExpressionValue((Object)periodicId, (String)"periodicId");
                vertx.cancelTimer(periodicId.longValue());
                break;
            }
            case 3: {
                this$0.logger.info("Job " + $jobId + " is running");
                break;
            }
            case 4: {
                this$0.logger.info("Job " + $jobId + " is waiting");
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[WorkerOnDemandStatus.values().length];
            nArray[WorkerOnDemandStatus.SUCCEEDED.ordinal()] = 1;
            nArray[WorkerOnDemandStatus.FAILED.ordinal()] = 2;
            nArray[WorkerOnDemandStatus.RUNNING.ordinal()] = 3;
            nArray[WorkerOnDemandStatus.WAITING.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[JobStatus.values().length];
            nArray[JobStatus.SUBMITTED.ordinal()] = 1;
            nArray[JobStatus.PENDING.ordinal()] = 2;
            nArray[JobStatus.RUNNABLE.ordinal()] = 3;
            nArray[JobStatus.STARTING.ordinal()] = 4;
            nArray[JobStatus.RUNNING.ordinal()] = 5;
            nArray[JobStatus.SUCCEEDED.ordinal()] = 6;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

