/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.build.aws;

import ai.tock.nlp.build.aws.WorkerOnAwsBatch;
import ai.tock.nlp.build.aws.WorkerOnAwsBatchProperties;
import ai.tock.nlp.build.ondemand.WorkerOnDemand;
import ai.tock.nlp.build.ondemand.WorkerOnDemandStatus;
import ai.tock.nlp.build.ondemand.WorkerOnDemandSummary;
import ai.tock.shared.vertx.VertXsKt;
import com.amazonaws.services.batch.AWSBatch;
import com.amazonaws.services.batch.AWSBatchClientBuilder;
import com.amazonaws.services.batch.model.ContainerOverrides;
import com.amazonaws.services.batch.model.DescribeJobsRequest;
import com.amazonaws.services.batch.model.DescribeJobsResult;
import com.amazonaws.services.batch.model.JobDetail;
import com.amazonaws.services.batch.model.JobStatus;
import com.amazonaws.services.batch.model.JobSummary;
import com.amazonaws.services.batch.model.JobTimeout;
import com.amazonaws.services.batch.model.KeyValuePair;
import com.amazonaws.services.batch.model.ListJobsRequest;
import com.amazonaws.services.batch.model.ListJobsResult;
import com.amazonaws.services.batch.model.SubmitJobRequest;
import io.vertx.core.Vertx;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0014H\u0002J+\u0010\u0018\u001a\u00020\u00192!\u0010\u001a\u001a\u001d\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00190\u001bH\u0016J\b\u0010 \u001a\u00020\u0012H\u0016J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u0006H\u0002J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J*\u0010%\u001a\u0010\u0012\f\u0012\n (*\u0004\u0018\u00010'0'0&*\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007H\u0002J\f\u0010)\u001a\u00020\u0012*\u00020*H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lai/tock/nlp/build/aws/WorkerOnAwsBatch;", "Lai/tock/nlp/build/ondemand/WorkerOnDemand;", "workerOnAwsBatchProperties", "Lai/tock/nlp/build/aws/WorkerOnAwsBatchProperties;", "workerProperties", "", "", "Lai/tock/nlp/build/ondemand/WorkerProperties;", "batchClient", "Lcom/amazonaws/services/batch/AWSBatch;", "(Lai/tock/nlp/build/aws/WorkerOnAwsBatchProperties;Ljava/util/Map;Lcom/amazonaws/services/batch/AWSBatch;)V", "logger", "Lmu/KLogger;", "submitJobRequest", "Lcom/amazonaws/services/batch/model/SubmitJobRequest;", "getSubmitJobRequest", "()Lcom/amazonaws/services/batch/model/SubmitJobRequest;", "workerOnDemandSummary", "Lai/tock/nlp/build/ondemand/WorkerOnDemandSummary;", "jobSummaryByStatus", "Lcom/amazonaws/services/batch/model/JobSummary;", "jobStatus", "Lcom/amazonaws/services/batch/model/JobStatus;", "runningJob", "start", "", "callback", "Lkotlin/Function1;", "Lai/tock/nlp/build/ondemand/WorkerOnDemandStatus;", "Lkotlin/ParameterName;", "name", "status", "summary", "jobId", "jobName", "createdAt", "", "toKeyValuePairs", "", "Lcom/amazonaws/services/batch/model/KeyValuePair;", "kotlin.jvm.PlatformType", "toWorkerOnDemandSummary", "Lcom/amazonaws/services/batch/model/JobDetail;", "tock-nlp-build-model-worker-on-aws-batch"})
@SourceDebugExtension(value={"SMAP\nWorkerOnAwsBatch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkerOnAwsBatch.kt\nai/tock/nlp/build/aws/WorkerOnAwsBatch\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,159:1\n37#2:160\n36#2,3:161\n230#3,2:164\n295#3,2:166\n126#4:168\n153#4,3:169\n*S KotlinDebug\n*F\n+ 1 WorkerOnAwsBatch.kt\nai/tock/nlp/build/aws/WorkerOnAwsBatch\n*L\n63#1:160\n63#1:161,3\n75#1:164,2\n97#1:166,2\n134#1:168\n134#1:169,3\n*E\n"})
public final class WorkerOnAwsBatch
implements WorkerOnDemand {
    @NotNull
    private final WorkerOnAwsBatchProperties workerOnAwsBatchProperties;
    @NotNull
    private final Map<String, String> workerProperties;
    @NotNull
    private final AWSBatch batchClient;
    @NotNull
    private final KLogger logger;
    @NotNull
    private WorkerOnDemandSummary workerOnDemandSummary;

    public WorkerOnAwsBatch(@NotNull WorkerOnAwsBatchProperties workerOnAwsBatchProperties, @NotNull Map<String, String> workerProperties, @NotNull AWSBatch batchClient) {
        Intrinsics.checkNotNullParameter((Object)workerOnAwsBatchProperties, (String)"workerOnAwsBatchProperties");
        Intrinsics.checkNotNullParameter(workerProperties, (String)"workerProperties");
        Intrinsics.checkNotNullParameter((Object)batchClient, (String)"batchClient");
        this.workerOnAwsBatchProperties = workerOnAwsBatchProperties;
        this.workerProperties = workerProperties;
        this.batchClient = batchClient;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.workerOnDemandSummary = new WorkerOnDemandSummary(this.workerOnAwsBatchProperties.getJobName(), null, null, WorkerOnDemandStatus.WAITING, 6, null);
    }

    public /* synthetic */ WorkerOnAwsBatch(WorkerOnAwsBatchProperties workerOnAwsBatchProperties, Map map, AWSBatch aWSBatch, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            AWSBatch aWSBatch2 = AWSBatchClientBuilder.defaultClient();
            Intrinsics.checkNotNullExpressionValue((Object)aWSBatch2, (String)"defaultClient(...)");
            aWSBatch = aWSBatch2;
        }
        this(workerOnAwsBatchProperties, map, aWSBatch);
    }

    private final SubmitJobRequest getSubmitJobRequest() {
        Collection $this$toTypedArray$iv = this.toKeyValuePairs(this.workerProperties);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        KeyValuePair[] keyValuePairArray = thisCollection$iv.toArray(new KeyValuePair[0]);
        SubmitJobRequest submitJobRequest = new SubmitJobRequest().withJobName(this.workerOnAwsBatchProperties.getJobName()).withJobDefinition(this.workerOnAwsBatchProperties.getJobDefinitionName()).withJobQueue(this.workerOnAwsBatchProperties.getJobQueueName()).withTimeout(new JobTimeout().withAttemptDurationSeconds(Integer.valueOf(this.workerOnAwsBatchProperties.getAttemptDurationSeconds()))).withContainerOverrides(new ContainerOverrides().withEnvironment(Arrays.copyOf(keyValuePairArray, keyValuePairArray.length)).withVcpus(Integer.valueOf(this.workerOnAwsBatchProperties.getVcpus())).withMemory(Integer.valueOf(this.workerOnAwsBatchProperties.getMemory())));
        Intrinsics.checkNotNullExpressionValue((Object)submitJobRequest, (String)"withContainerOverrides(...)");
        return submitJobRequest;
    }

    /*
     * WARNING - void declaration
     */
    private final WorkerOnDemandSummary summary(String jobId) {
        void $this$summary_u24lambda_u242_u24lambda_u241;
        Object element$iv2;
        WorkerOnAwsBatch workerOnAwsBatch;
        Iterable iterable;
        block1: {
            void $this$first$iv;
            String[] stringArray = new String[]{jobId};
            DescribeJobsResult $this$summary_u24lambda_u242 = this.batchClient.describeJobs(new DescribeJobsRequest().withJobs(stringArray));
            boolean bl = false;
            List list = $this$summary_u24lambda_u242.getJobs();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getJobs(...)");
            iterable = list;
            workerOnAwsBatch = this;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                JobDetail it = (JobDetail)element$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getJobId(), (Object)jobId)) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        iterable = element$iv2;
        JobDetail $i$f$first = (JobDetail)iterable;
        boolean bl = false;
        this.logger.info((Function0)new Function0<Object>((JobDetail)$this$summary_u24lambda_u242_u24lambda_u241, jobId){
            final /* synthetic */ JobDetail $this_apply;
            final /* synthetic */ String $jobId;
            {
                this.$this_apply = $receiver;
                this.$jobId = $jobId;
                super(0);
            }

            public final Object invoke() {
                return "Job " + this.$this_apply.getJobName() + " with id " + this.$jobId + " is " + this.$this_apply.getStatus();
            }
        });
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"apply(...)");
        return workerOnAwsBatch.toWorkerOnDemandSummary((JobDetail)iterable2);
    }

    private final JobSummary runningJob() {
        JobSummary jobSummary = this.jobSummaryByStatus(JobStatus.RUNNING);
        if (jobSummary == null && (jobSummary = this.jobSummaryByStatus(JobStatus.PENDING)) == null && (jobSummary = this.jobSummaryByStatus(JobStatus.RUNNABLE)) == null && (jobSummary = this.jobSummaryByStatus(JobStatus.SUBMITTED)) == null) {
            jobSummary = this.jobSummaryByStatus(JobStatus.STARTING);
        }
        return jobSummary;
    }

    private final JobSummary jobSummaryByStatus(JobStatus jobStatus) {
        Object v1;
        block1: {
            ListJobsResult $this$jobSummaryByStatus_u24lambda_u244 = this.batchClient.listJobs(new ListJobsRequest().withJobQueue(this.workerOnAwsBatchProperties.getJobQueueName()).withJobStatus(jobStatus));
            boolean bl = false;
            List list = $this$jobSummaryByStatus_u24lambda_u244.getJobSummaryList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getJobSummaryList(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JobSummary it = (JobSummary)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getJobName(), (Object)this.workerOnAwsBatchProperties.getJobName())) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    public void start(@NotNull Function1<? super WorkerOnDemandStatus, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.logger.info("WorkerOnAwsBatch starting for " + this.workerProperties.get("TOCK_BUILD_TYPE") + " build type");
        Object object = this.runningJob();
        if (object == null || (object = object.getJobId()) == null) {
            object = this.batchClient.submitJob(this.getSubmitJobRequest()).getJobId();
        }
        Object jobId = object;
        VertXsKt.getVertx().setPeriodic(Duration.ofSeconds(10L).toMillis(), arg_0 -> WorkerOnAwsBatch.start$lambda$6(this, (String)jobId, callback, arg_0));
    }

    @NotNull
    public WorkerOnDemandSummary summary() {
        return this.workerOnDemandSummary;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KeyValuePair> toKeyValuePairs(Map<String, String> $this$toKeyValuePairs) {
        void $this$mapTo$iv$iv;
        Map<String, String> $this$map$iv = $this$toKeyValuePairs;
        boolean $i$f$map = false;
        Map<String, String> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new KeyValuePair().withName((String)it.getKey()).withValue((String)it.getValue()));
        }
        return (List)destination$iv$iv;
    }

    private final WorkerOnDemandSummary workerOnDemandSummary(String jobName, String jobId, long createdAt, String status) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(createdAt), TimeZone.getDefault().toZoneId());
        JobStatus jobStatus = JobStatus.fromValue((String)status);
        return new WorkerOnDemandSummary(jobName, jobId, localDateTime, switch (jobStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$1[jobStatus.ordinal()]) {
            case 1 -> WorkerOnDemandStatus.RUNNING;
            case 2 -> WorkerOnDemandStatus.RUNNING;
            case 3 -> WorkerOnDemandStatus.RUNNING;
            case 4 -> WorkerOnDemandStatus.RUNNING;
            case 5 -> WorkerOnDemandStatus.RUNNING;
            case 6 -> WorkerOnDemandStatus.SUCCEEDED;
            default -> WorkerOnDemandStatus.FAILED;
        });
    }

    private final WorkerOnDemandSummary toWorkerOnDemandSummary(JobDetail $this$toWorkerOnDemandSummary) {
        String string = $this$toWorkerOnDemandSummary.getJobName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getJobName(...)");
        String string2 = $this$toWorkerOnDemandSummary.getJobId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getJobId(...)");
        Long l = $this$toWorkerOnDemandSummary.getCreatedAt();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getCreatedAt(...)");
        long l2 = ((Number)l).longValue();
        String string3 = $this$toWorkerOnDemandSummary.getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getStatus(...)");
        return this.workerOnDemandSummary(string, string2, l2, string3);
    }

    private static final void start$lambda$6(WorkerOnAwsBatch this$0, String $jobId, Function1 $callback, Long periodicId) {
        Intrinsics.checkNotNull((Object)$jobId);
        WorkerOnDemandSummary $this$start_u24lambda_u246_u24lambda_u245 = this$0.summary($jobId);
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$start_u24lambda_u246_u24lambda_u245.getStatus().ordinal()]) {
            case 1: {
                this$0.logger.info("Job " + $jobId + " succeeded");
                $callback.invoke((Object)WorkerOnDemandStatus.SUCCEEDED);
                Vertx vertx = VertXsKt.getVertx();
                Intrinsics.checkNotNull((Object)periodicId);
                vertx.cancelTimer(periodicId.longValue());
                break;
            }
            case 2: {
                this$0.logger.info("Job " + $jobId + " failed");
                $callback.invoke((Object)WorkerOnDemandStatus.FAILED);
                Vertx vertx = VertXsKt.getVertx();
                Intrinsics.checkNotNull((Object)periodicId);
                vertx.cancelTimer(periodicId.longValue());
                break;
            }
            case 3: {
                this$0.logger.info("Job " + $jobId + " is running");
                break;
            }
            case 4: {
                this$0.logger.info("Job " + $jobId + " is waiting");
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[WorkerOnDemandStatus.values().length];
            try {
                nArray[WorkerOnDemandStatus.SUCCEEDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkerOnDemandStatus.FAILED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkerOnDemandStatus.RUNNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkerOnDemandStatus.WAITING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[JobStatus.values().length];
            try {
                nArray[JobStatus.SUBMITTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JobStatus.PENDING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JobStatus.RUNNABLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JobStatus.STARTING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JobStatus.RUNNING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JobStatus.SUCCEEDED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

