/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.build;

import ai.tock.nlp.build.BuildModelWorker;
import ai.tock.nlp.front.client.FrontClient;
import ai.tock.nlp.front.shared.ApplicationConfiguration;
import ai.tock.nlp.front.shared.build.ModelBuildTrigger;
import ai.tock.nlp.front.shared.config.ApplicationDefinition;
import ai.tock.nlp.front.shared.config.ClassifiedSentence;
import ai.tock.nlp.front.shared.config.ClassifiedSentenceStatus;
import ai.tock.nlp.front.shared.config.EntityTypeDefinition;
import ai.tock.nlp.front.shared.config.IntentDefinition;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.StringsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.Id;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00032\u00020\u0001:\u0002\u0003\u0004B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lai/tock/nlp/build/BuildModelWorker;", "", "()V", "Companion", "ModelRefreshKey", "tock-nlp-build-model-worker"})
public final class BuildModelWorker {
    private static final KLogger logger;
    private static final boolean testModelEnabled;
    private static final boolean cleanupModelEnabled;
    @NotNull
    private static final FrontClient front;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
        testModelEnabled = PropertiesKt.booleanProperty((String)"tock_test_model_enabled", (boolean)true);
        cleanupModelEnabled = PropertiesKt.booleanProperty((String)"tock_cleanup_model_enabled", (boolean)true);
        front = FrontClient.INSTANCE;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lai/tock/nlp/build/BuildModelWorker$ModelRefreshKey;", "", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "language", "Ljava/util/Locale;", "(Lorg/litote/kmongo/Id;Ljava/util/Locale;)V", "getApplicationId", "()Lorg/litote/kmongo/Id;", "getLanguage", "()Ljava/util/Locale;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "tock-nlp-build-model-worker"})
    public static final class ModelRefreshKey {
        @NotNull
        private final Id<ApplicationDefinition> applicationId;
        @NotNull
        private final Locale language;

        @NotNull
        public final Id<ApplicationDefinition> getApplicationId() {
            return this.applicationId;
        }

        @NotNull
        public final Locale getLanguage() {
            return this.language;
        }

        public ModelRefreshKey(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language) {
            Intrinsics.checkParameterIsNotNull(applicationId, (String)"applicationId");
            Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
            this.applicationId = applicationId;
            this.language = language;
        }

        @NotNull
        public final Id<ApplicationDefinition> component1() {
            return this.applicationId;
        }

        @NotNull
        public final Locale component2() {
            return this.language;
        }

        @NotNull
        public final ModelRefreshKey copy(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language) {
            Intrinsics.checkParameterIsNotNull(applicationId, (String)"applicationId");
            Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
            return new ModelRefreshKey(applicationId, language);
        }

        public static /* synthetic */ ModelRefreshKey copy$default(ModelRefreshKey modelRefreshKey, Id id, Locale locale, int n, Object object) {
            if ((n & 1) != 0) {
                id = modelRefreshKey.applicationId;
            }
            if ((n & 2) != 0) {
                locale = modelRefreshKey.language;
            }
            return modelRefreshKey.copy(id, locale);
        }

        @NotNull
        public String toString() {
            return "ModelRefreshKey(applicationId=" + this.applicationId + ", language=" + this.language + ")";
        }

        public int hashCode() {
            Id<ApplicationDefinition> id = this.applicationId;
            Locale locale = this.language;
            return (id != null ? id.hashCode() : 0) * 31 + (locale != null ? ((Object)locale).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ModelRefreshKey)) break block3;
                    ModelRefreshKey modelRefreshKey = (ModelRefreshKey)object;
                    if (!Intrinsics.areEqual(this.applicationId, modelRefreshKey.applicationId) || !Intrinsics.areEqual((Object)this.language, (Object)modelRefreshKey.language)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000e\u001a\u00020\u0004J\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010\u0010\u001a\u00020\u0004J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0006\u0010\u0014\u001a\u00020\u0004J\u0006\u0010\u0015\u001a\u00020\u0012J\u001a\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0004H\u0002J0\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\b\b\u0002\u0010\u0019\u001a\u00020\u0004H\u0002J(\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\b\b\u0002\u0010\u0019\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lai/tock/nlp/build/BuildModelWorker$Companion;", "", "()V", "cleanupModelEnabled", "", "getCleanupModelEnabled$tock_nlp_build_model_worker", "()Z", "front", "Lai/tock/nlp/front/client/FrontClient;", "getFront", "()Lai/tock/nlp/front/client/FrontClient;", "logger", "Lmu/KLogger;", "testModelEnabled", "buildModelForTriggeredApplication", "buildModelWithDeletedSentences", "buildModelWithValidatedSentences", "cleanupModel", "", "completeModel", "testModels", "updateAllModels", "updateApplicationModels", "app", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "onlyIfNotExists", "updateEntityModels", "locale", "Ljava/util/Locale;", "sentences", "", "Lai/tock/nlp/front/shared/config/ClassifiedSentence;", "updateModel", "key", "Lai/tock/nlp/build/BuildModelWorker$ModelRefreshKey;", "tock-nlp-build-model-worker"})
    public static final class Companion {
        public final boolean getCleanupModelEnabled$tock_nlp_build_model_worker() {
            return cleanupModelEnabled;
        }

        @NotNull
        public final FrontClient getFront() {
            return front;
        }

        public final void updateAllModels() {
            Iterable $this$forEach$iv = FrontClient.INSTANCE.getApplications();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ApplicationDefinition it = (ApplicationDefinition)element$iv;
                boolean bl = false;
                ai.tock.nlp.build.BuildModelWorker$Companion.updateApplicationModels$default(Companion, it, false, 2, null);
            }
        }

        private final void updateApplicationModels(ApplicationDefinition app, boolean onlyIfNotExists) {
            logger.info((Function0)new Function0<String>(app){
                final /* synthetic */ ApplicationDefinition $app;

                @NotNull
                public final String invoke() {
                    return "Rebuild all models for application " + this.$app.getName() + " and nlp engine " + this.$app.getNlpEngineType().getName();
                }
                {
                    this.$app = applicationDefinition;
                    super(0);
                }
            });
            Iterable $this$forEach$iv = app.getSupportedLocales();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Locale locale = (Locale)element$iv;
                boolean bl = false;
                Companion.getFront().updateIntentsModelForApplication(CollectionsKt.emptyList(), app, locale, app.getNlpEngineType(), onlyIfNotExists);
                Iterable $this$forEach$iv2 = app.getIntents();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Id intentId = (Id)element$iv2;
                    boolean bl2 = false;
                    logger.info((Function0)new Function0<String>(intentId, locale, app, onlyIfNotExists){
                        final /* synthetic */ Id $intentId;
                        final /* synthetic */ Locale $locale$inlined;
                        final /* synthetic */ ApplicationDefinition $app$inlined;
                        final /* synthetic */ boolean $onlyIfNotExists$inlined;
                        {
                            this.$intentId = id;
                            this.$locale$inlined = locale;
                            this.$app$inlined = applicationDefinition;
                            this.$onlyIfNotExists$inlined = bl;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "start model update for " + this.$app$inlined.getName() + ", intent " + this.$intentId + " and " + this.$locale$inlined;
                        }
                    });
                    Companion.getFront().updateEntityModelForIntent(CollectionsKt.emptyList(), app, intentId, locale, app.getNlpEngineType(), onlyIfNotExists);
                }
                Companion.updateEntityModels(app, locale, CollectionsKt.emptyList(), onlyIfNotExists);
            }
        }

        static /* synthetic */ void updateApplicationModels$default(Companion companion, ApplicationDefinition applicationDefinition, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            companion.updateApplicationModels(applicationDefinition, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void updateModel(ModelRefreshKey key, List<ClassifiedSentence> sentences, boolean onlyIfNotExists) {
            ApplicationDefinition app;
            block8: {
                app = this.getFront().getApplicationById(key.getApplicationId());
                if (app != null) break block8;
                logger.warn((Function0)new Function0<String>(key){
                    final /* synthetic */ ModelRefreshKey $key;

                    @NotNull
                    public final String invoke() {
                        return "Unknown application : " + this.$key;
                    }
                    {
                        this.$key = modelRefreshKey;
                        super(0);
                    }
                });
                logger.info((Function0)new Function0<String>(key){
                    final /* synthetic */ ModelRefreshKey $key;

                    @NotNull
                    public final String invoke() {
                        return "end model update for " + this.$key.getLanguage();
                    }
                    {
                        this.$key = modelRefreshKey;
                        super(0);
                    }
                });
                this.getFront().switchSentencesStatus(sentences, ClassifiedSentenceStatus.model);
                return;
            }
            try {
                void $this$groupByTo$iv$iv;
                logger.info((Function0)new Function0<String>(app, key){
                    final /* synthetic */ ApplicationDefinition $app;
                    final /* synthetic */ ModelRefreshKey $key;

                    @NotNull
                    public final String invoke() {
                        return "Start model update for " + this.$app.getName() + " and " + this.$key.getLanguage();
                    }
                    {
                        this.$app = applicationDefinition;
                        this.$key = modelRefreshKey;
                        super(0);
                    }
                });
                logger.trace((Function0)new Function0<String>(sentences){
                    final /* synthetic */ List $sentences;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final String invoke() {
                        Collection<String> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable iterable = this.$sentences;
                        StringBuilder stringBuilder = new StringBuilder().append("New sentences : ");
                        boolean $i$f$map = false;
                        void var3_4 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            ClassifiedSentence classifiedSentence = (ClassifiedSentence)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            String string = it.getText();
                            collection.add(string);
                        }
                        collection = (List)destination$iv$iv;
                        return stringBuilder.append(collection).toString();
                    }
                    {
                        this.$sentences = list;
                        super(0);
                    }
                });
                this.getFront().updateIntentsModelForApplication(sentences, app, key.getLanguage(), app.getNlpEngineType(), onlyIfNotExists);
                Iterable $this$groupBy$iv = sentences;
                boolean $i$f$groupBy = false;
                Iterable iterable = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object;
                    ClassifiedSentence it = (ClassifiedSentence)element$iv$iv;
                    boolean bl = false;
                    Id key$iv$iv = it.getClassification().getIntentId();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        ArrayList answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                destination$iv$iv.forEach((BiConsumer)new BiConsumer<Id<IntentDefinition>, List<? extends ClassifiedSentence>>(app, key, onlyIfNotExists){
                    final /* synthetic */ ApplicationDefinition $app;
                    final /* synthetic */ ModelRefreshKey $key;
                    final /* synthetic */ boolean $onlyIfNotExists;

                    public final void accept(@NotNull Id<IntentDefinition> intentId, @NotNull List<ClassifiedSentence> intentSentences) {
                        Intrinsics.checkParameterIsNotNull(intentId, (String)"intentId");
                        Intrinsics.checkParameterIsNotNull(intentSentences, (String)"intentSentences");
                        BuildModelWorker.access$getLogger$cp().info((Function0)new Function0<String>(this, intentId){
                            final /* synthetic */ updateModel.5 this$0;
                            final /* synthetic */ Id $intentId;

                            @NotNull
                            public final String invoke() {
                                return "start model update for " + this.this$0.$app.getName() + ", intent " + this.$intentId + " and " + this.this$0.$key.getLanguage();
                            }
                            {
                                this.this$0 = var1_1;
                                this.$intentId = id;
                                super(0);
                            }
                        });
                        BuildModelWorker.Companion.getFront().updateEntityModelForIntent(intentSentences, this.$app, intentId, this.$key.getLanguage(), this.$app.getNlpEngineType(), this.$onlyIfNotExists);
                    }
                    {
                        this.$app = applicationDefinition;
                        this.$key = modelRefreshKey;
                        this.$onlyIfNotExists = bl;
                    }
                });
                this.updateEntityModels(app, key.getLanguage(), sentences, onlyIfNotExists);
                logger.info((Function0)new Function0<String>(app, key){
                    final /* synthetic */ ApplicationDefinition $app;
                    final /* synthetic */ ModelRefreshKey $key;

                    @NotNull
                    public final String invoke() {
                        return "Model updated for " + this.$app.getName() + " and " + this.$key.getLanguage();
                    }
                    {
                        this.$app = applicationDefinition;
                        this.$key = modelRefreshKey;
                        super(0);
                    }
                });
            }
            catch (Throwable e) {
                try {
                    LoggersKt.error((KLogger)logger, (Throwable)e);
                }
                catch (Throwable throwable) {
                    logger.info((Function0)new /* invalid duplicate definition of identical inner class */);
                    this.getFront().switchSentencesStatus(sentences, ClassifiedSentenceStatus.model);
                    throw throwable;
                }
                logger.info((Function0)new /* invalid duplicate definition of identical inner class */);
                this.getFront().switchSentencesStatus(sentences, ClassifiedSentenceStatus.model);
            }
            logger.info((Function0)new /* invalid duplicate definition of identical inner class */);
            this.getFront().switchSentencesStatus(sentences, ClassifiedSentenceStatus.model);
        }

        static /* synthetic */ void updateModel$default(Companion companion, ModelRefreshKey modelRefreshKey, List list, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            companion.updateModel(modelRefreshKey, list, bl);
        }

        /*
         * WARNING - void declaration
         */
        private final void updateEntityModels(ApplicationDefinition app, Locale locale, List<ClassifiedSentence> sentences, boolean onlyIfNotExists) {
            EntityTypeDefinition it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.getFront().getEntityTypes();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (EntityTypeDefinition)element$iv$iv;
                boolean bl = false;
                Collection collection = it.getSubEntities();
                boolean bl2 = false;
                if (!(!collection.isEmpty())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (EntityTypeDefinition)element$iv$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)StringsKt.namespace((String)it.getName()), (Object)app.getNamespace())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$filterTo$iv$iv2;
                EntityTypeDefinition entityType = (EntityTypeDefinition)element$iv;
                boolean bl = false;
                Iterable $this$filter$iv2 = sentences;
                boolean $i$f$filter2 = false;
                Iterable bl3 = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    ClassifiedSentence s = (ClassifiedSentence)element$iv$iv;
                    boolean bl4 = false;
                    if (!s.getClassification().containsEntityOrSubEntity(entityType.getName())) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List sentencesWithEntity = (List)destination$iv$iv2;
                Collection collection = sentencesWithEntity;
                boolean bl5 = false;
                if (!(!collection.isEmpty())) continue;
                logger.info((Function0)new Function0<String>(entityType, sentences, app, locale, onlyIfNotExists){
                    final /* synthetic */ EntityTypeDefinition $entityType;
                    final /* synthetic */ List $sentences$inlined;
                    final /* synthetic */ ApplicationDefinition $app$inlined;
                    final /* synthetic */ Locale $locale$inlined;
                    final /* synthetic */ boolean $onlyIfNotExists$inlined;
                    {
                        this.$entityType = entityTypeDefinition;
                        this.$sentences$inlined = list;
                        this.$app$inlined = applicationDefinition;
                        this.$locale$inlined = locale;
                        this.$onlyIfNotExists$inlined = bl;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "start model update for " + this.$app$inlined.getName() + ", entity type " + this.$entityType + " and " + this.$locale$inlined;
                    }
                });
                Companion.getFront().updateEntityModelForEntityType(sentencesWithEntity, app, entityType, locale, app.getNlpEngineType(), onlyIfNotExists);
            }
        }

        static /* synthetic */ void updateEntityModels$default(Companion companion, ApplicationDefinition applicationDefinition, Locale locale, List list, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            companion.updateEntityModels(applicationDefinition, locale, list, bl);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean buildModelWithValidatedSentences() {
            List validatedSentences = ApplicationConfiguration.DefaultImpls.getSentences$default((ApplicationConfiguration)this.getFront(), null, null, (ClassifiedSentenceStatus)ClassifiedSentenceStatus.validated, (int)3, null);
            Collection collection = validatedSentences;
            boolean bl = false;
            if (!collection.isEmpty()) {
                void $this$groupByTo$iv$iv;
                logger.debug((Function0)new Function0<String>(validatedSentences){
                    final /* synthetic */ List $validatedSentences;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final String invoke() {
                        Collection<String> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable iterable = this.$validatedSentences;
                        StringBuilder stringBuilder = new StringBuilder().append("Sentences to update : ");
                        boolean $i$f$map = false;
                        void var3_4 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            ClassifiedSentence classifiedSentence = (ClassifiedSentence)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            String string = it.getText();
                            collection.add(string);
                        }
                        collection = (List)destination$iv$iv;
                        return stringBuilder.append(collection).toString();
                    }
                    {
                        this.$validatedSentences = list;
                        super(0);
                    }
                });
                Iterable $this$groupBy$iv = validatedSentences;
                boolean $i$f$groupBy = false;
                Object object = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object2;
                    ClassifiedSentence it = (ClassifiedSentence)element$iv$iv;
                    boolean bl2 = false;
                    ModelRefreshKey key$iv$iv = new ModelRefreshKey((Id<ApplicationDefinition>)it.getApplicationId(), it.getLanguage());
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl3 = false;
                        ArrayList answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object2 = answer$iv$iv$iv;
                    } else {
                        object2 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object2;
                    list$iv$iv.add(element$iv$iv);
                }
                Map refreshKeyMap = destination$iv$iv;
                logger.info((Function0)new Function0<String>(refreshKeyMap){
                    final /* synthetic */ Map $refreshKeyMap;

                    @NotNull
                    public final String invoke() {
                        return "Model refresh keys : " + this.$refreshKeyMap.keySet();
                    }
                    {
                        this.$refreshKeyMap = map;
                        super(0);
                    }
                });
                Map $this$forEach$iv = refreshKeyMap;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv;
                boolean bl4 = false;
                Iterator iterator = object.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator.next();
                    boolean bl5 = false;
                    ai.tock.nlp.build.BuildModelWorker$Companion.updateModel$default(Companion, (ModelRefreshKey)it.getKey(), (List)it.getValue(), false, 4, null);
                }
                logger.info((Function0)buildModelWithValidatedSentences.4.INSTANCE);
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean buildModelWithDeletedSentences() {
            List deletedSentences = ApplicationConfiguration.DefaultImpls.getSentences$default((ApplicationConfiguration)this.getFront(), null, null, (ClassifiedSentenceStatus)ClassifiedSentenceStatus.deleted, (int)3, null);
            Collection collection = deletedSentences;
            boolean bl = false;
            if (!collection.isEmpty()) {
                void $this$mapTo$iv$iv;
                logger.debug((Function0)new Function0<String>(deletedSentences){
                    final /* synthetic */ List $deletedSentences;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final String invoke() {
                        Collection<String> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable iterable = this.$deletedSentences;
                        StringBuilder stringBuilder = new StringBuilder().append("Sentences to remove from model : ");
                        boolean $i$f$map = false;
                        void var3_4 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            ClassifiedSentence classifiedSentence = (ClassifiedSentence)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            String string = it.getText();
                            collection.add(string);
                        }
                        collection = (List)destination$iv$iv;
                        return stringBuilder.append(collection).toString();
                    }
                    {
                        this.$deletedSentences = list;
                        super(0);
                    }
                });
                Iterable $this$map$iv = deletedSentences;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ClassifiedSentence classifiedSentence = (ClassifiedSentence)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    ModelRefreshKey modelRefreshKey = new ModelRefreshKey((Id<ApplicationDefinition>)it.getApplicationId(), it.getLanguage());
                    collection2.add(modelRefreshKey);
                }
                List refreshKeyMap = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                logger.info((Function0)new Function0<String>(refreshKeyMap){
                    final /* synthetic */ List $refreshKeyMap;

                    @NotNull
                    public final String invoke() {
                        return "Model refresh keys : " + this.$refreshKeyMap;
                    }
                    {
                        this.$refreshKeyMap = list;
                        super(0);
                    }
                });
                Iterable $this$forEach$iv = refreshKeyMap;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ModelRefreshKey it = (ModelRefreshKey)element$iv;
                    boolean bl3 = false;
                    ai.tock.nlp.build.BuildModelWorker$Companion.updateModel$default(Companion, it, CollectionsKt.emptyList(), false, 4, null);
                }
                this.getFront().deleteSentencesByStatus(ClassifiedSentenceStatus.deleted);
                logger.info((Function0)buildModelWithDeletedSentences.4.INSTANCE);
                return true;
            }
            return false;
        }

        public final boolean buildModelForTriggeredApplication() {
            List triggers = this.getFront().getTriggers();
            Collection collection = triggers;
            boolean bl = false;
            if (!collection.isEmpty()) {
                collection = triggers.get(0);
                bl = false;
                boolean bl2 = false;
                ModelBuildTrigger trigger = (ModelBuildTrigger)collection;
                boolean bl3 = false;
                logger.info((Function0)new Function0<String>(trigger){
                    final /* synthetic */ ModelBuildTrigger $trigger;

                    @NotNull
                    public final String invoke() {
                        return "use trigger " + this.$trigger;
                    }
                    {
                        this.$trigger = modelBuildTrigger;
                        super(0);
                    }
                });
                Companion.getFront().deleteTrigger(trigger);
                ApplicationDefinition applicationDefinition = Companion.getFront().getApplicationById(trigger.getApplicationId());
                if (applicationDefinition != null) {
                    ApplicationDefinition applicationDefinition2 = applicationDefinition;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    ApplicationDefinition it = applicationDefinition2;
                    boolean bl6 = false;
                    Companion.updateApplicationModels(it, trigger.getOnlyIfModelNotExists());
                } else {
                    logger.warn((Function0)new Function0<String>(trigger){
                        final /* synthetic */ ModelBuildTrigger $trigger;

                        @NotNull
                        public final String invoke() {
                            return "unknown application id trigger " + this.$trigger + " - skipped";
                        }
                        {
                            this.$trigger = modelBuildTrigger;
                            super(0);
                        }
                    });
                }
                return true;
            }
            return false;
        }

        public final boolean testModels() {
            if (testModelEnabled) {
                logger.info((Function0)testModels.1.INSTANCE);
                this.getFront().testModels();
                return true;
            }
            return false;
        }

        public final void completeModel() {
            logger.info((Function0)completeModel.1.INSTANCE);
            Iterable $this$forEach$iv = this.getFront().getApplications();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ApplicationDefinition it = (ApplicationDefinition)element$iv;
                boolean bl = false;
                Companion.getFront().triggerBuild(new ModelBuildTrigger(it.get_id(), true, true));
            }
        }

        public final void cleanupModel() {
            if (this.getCleanupModelEnabled$tock_nlp_build_model_worker()) {
                logger.debug((Function0)cleanupModel.1.INSTANCE);
                this.getFront().deleteOrphans();
                logger.debug((Function0)cleanupModel.2.INSTANCE);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

