/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.core.service;

import ai.tock.nlp.core.Application;
import ai.tock.nlp.core.BuildContext;
import ai.tock.nlp.core.CallContext;
import ai.tock.nlp.core.EntityRecognition;
import ai.tock.nlp.core.EntityType;
import ai.tock.nlp.core.IntOpenRange;
import ai.tock.nlp.core.Intent;
import ai.tock.nlp.core.ModelCore;
import ai.tock.nlp.core.NlpEngineType;
import ai.tock.nlp.core.ParsingResult;
import ai.tock.nlp.core.configuration.NlpApplicationConfiguration;
import ai.tock.nlp.core.quality.EntityMatchError;
import ai.tock.nlp.core.quality.IntentMatchError;
import ai.tock.nlp.core.quality.TestContext;
import ai.tock.nlp.core.quality.TestModelReport;
import ai.tock.nlp.core.sample.SampleEntity;
import ai.tock.nlp.core.sample.SampleExpression;
import ai.tock.nlp.core.service.ModelCoreService;
import ai.tock.nlp.core.service.NlpCoreService;
import ai.tock.nlp.model.EntityBuildContext;
import ai.tock.nlp.model.EntityBuildContextForIntent;
import ai.tock.nlp.model.EntityBuildContextForSubEntities;
import ai.tock.nlp.model.EntityCallContext;
import ai.tock.nlp.model.EntityCallContextForIntent;
import ai.tock.nlp.model.IntentContext;
import ai.tock.nlp.model.ModelHolder;
import ai.tock.nlp.model.NlpClassifier;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LoggersKt;
import com.github.salomonbrys.kodein.InjectedProperty;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u000b\u001a\u00020\f2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J$\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00132\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0013H\u0002J\u001e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0013H\u0016J&\u0010'\u001a\u00020\f2\u0006\u0010#\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0013H\u0002J&\u0010+\u001a\u00020\f2\u0006\u0010#\u001a\u00020(2\u0006\u0010,\u001a\u00020\u00142\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0013H\u0016J&\u0010-\u001a\u00020\f2\u0006\u0010#\u001a\u00020(2\u0006\u0010.\u001a\u00020\u00112\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0013H\u0016J\u001e\u0010/\u001a\u00020\f2\u0006\u0010#\u001a\u00020(2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0013H\u0016J \u00100\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u00020\u0016H\u0016J\u0010\u00103\u001a\u00020\f2\u0006\u0010#\u001a\u00020(H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u00064"}, d2={"Lai/tock/nlp/core/service/ModelCoreService;", "Lai/tock/nlp/core/ModelCore;", "()V", "logger", "Lmu/KLogger;", "nlpClassifier", "Lai/tock/nlp/model/NlpClassifier;", "getNlpClassifier", "()Lai/tock/nlp/model/NlpClassifier;", "nlpClassifier$delegate", "Lcom/github/salomonbrys/kodein/InjectedProperty;", "deleteOrphans", "", "applicationsAndIntents", "", "Lai/tock/nlp/core/Application;", "", "Lai/tock/nlp/core/Intent;", "entityTypes", "", "Lai/tock/nlp/core/EntityType;", "getCurrentModelConfiguration", "Lai/tock/nlp/core/configuration/NlpApplicationConfiguration;", "applicationName", "", "nlpEngineType", "Lai/tock/nlp/core/NlpEngineType;", "hasNotSameEntities", "", "expectedEntities", "Lai/tock/nlp/core/sample/SampleEntity;", "entities", "Lai/tock/nlp/core/EntityRecognition;", "testModel", "Lai/tock/nlp/core/quality/TestModelReport;", "context", "Lai/tock/nlp/core/quality/TestContext;", "expressions", "Lai/tock/nlp/core/sample/SampleExpression;", "updateEntityModel", "Lai/tock/nlp/core/BuildContext;", "nlpContext", "Lai/tock/nlp/model/EntityBuildContext;", "updateEntityModelForEntityType", "entityType", "updateEntityModelForIntent", "intent", "updateIntentModel", "updateModelConfiguration", "engineType", "configuration", "warmupModels", "tock-nlp-core-service"})
public final class ModelCoreService
implements ModelCore {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final KLogger logger;
    private static final InjectedProperty nlpClassifier$delegate;
    public static final ModelCoreService INSTANCE;

    static {
        ModelCoreService modelCoreService;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ModelCoreService.class), "nlpClassifier", "getNlpClassifier()Lai/tock/nlp/model/NlpClassifier;"))};
        INSTANCE = modelCoreService = new ModelCoreService();
        logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        KodeinInjectedBase $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        Object tag$iv = null;
        KodeinInjector kodeinInjector = $receiver$iv.getInjector();
        TypeToken typeToken = (TypeToken)new TypeReference<NlpClassifier>(){};
        nlpClassifier$delegate = kodeinInjector.Instance(typeToken, tag$iv);
    }

    private final NlpClassifier getNlpClassifier() {
        return (NlpClassifier)nlpClassifier$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void warmupModels(@NotNull BuildContext context) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.getNlpClassifier().warmupIntentModel(new IntentContext(context));
        Iterable $this$filter$iv = context.getApplication().getIntents();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Intent it = (Intent)element$iv$iv;
            boolean bl = false;
            Collection collection = it.getEntities();
            boolean bl2 = false;
            if (!(!collection.isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Intent it = (Intent)element$iv;
            boolean bl = false;
            INSTANCE.getNlpClassifier().warmupEntityModel((EntityCallContext)new EntityCallContextForIntent(new CallContext(context.getApplication(), context.getLanguage(), context.getEngineType(), null, 8, null), it));
        }
    }

    public void updateIntentModel(@NotNull BuildContext context, @NotNull List<SampleExpression> expressions) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(expressions, (String)"expressions");
        IntentContext nlpContext = new IntentContext(context);
        if (!context.getOnlyIfNotExists() || !this.getNlpClassifier().isIntentModelExist(nlpContext)) {
            this.getNlpClassifier().buildAndSaveIntentModel(nlpContext, expressions);
        }
    }

    public void updateEntityModelForIntent(@NotNull BuildContext context, @NotNull Intent intent, @NotNull List<SampleExpression> expressions) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        Intrinsics.checkParameterIsNotNull(expressions, (String)"expressions");
        EntityBuildContextForIntent nlpContext = new EntityBuildContextForIntent(context, intent);
        this.updateEntityModel(context, (EntityBuildContext)nlpContext, expressions);
    }

    public void updateEntityModelForEntityType(@NotNull BuildContext context, @NotNull EntityType entityType, @NotNull List<SampleExpression> expressions) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)entityType, (String)"entityType");
        Intrinsics.checkParameterIsNotNull(expressions, (String)"expressions");
        EntityBuildContextForSubEntities nlpContext = new EntityBuildContextForSubEntities(context, entityType);
        this.updateEntityModel(context, (EntityBuildContext)nlpContext, expressions);
    }

    private final void updateEntityModel(BuildContext context, EntityBuildContext nlpContext, List<SampleExpression> expressions) {
        if (!context.getOnlyIfNotExists() || !this.getNlpClassifier().isEntityModelExist(nlpContext)) {
            this.getNlpClassifier().buildAndSaveEntityModel(nlpContext, expressions);
        }
    }

    public void deleteOrphans(@NotNull Map<Application, ? extends Set<Intent>> applicationsAndIntents, @NotNull List<EntityType> entityTypes) {
        Intrinsics.checkParameterIsNotNull(applicationsAndIntents, (String)"applicationsAndIntents");
        Intrinsics.checkParameterIsNotNull(entityTypes, (String)"entityTypes");
        this.getNlpClassifier().deleteOrphans(applicationsAndIntents, entityTypes);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public TestModelReport testModel(@NotNull TestContext context, @NotNull List<SampleExpression> expressions) {
        void $this$mapNotNullTo$iv$iv22;
        List list$iv$iv;
        Object key$iv$iv;
        boolean bl;
        SampleExpression it;
        Map $this$groupByTo$iv$iv;
        List shuffle;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(expressions, (String)"expressions");
        if (expressions.size() < 100) {
            String string = "at least 100 expressions needed";
            boolean bl2 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        List list = shuffle = CollectionsKt.toMutableList((Collection)expressions);
        boolean bl3 = false;
        Collections.shuffle(list);
        int limit = (int)((float)expressions.size() * context.getThreshold());
        List modelExpressions = shuffle.subList(0, limit);
        List testedExpressions = shuffle.subList(limit, shuffle.size());
        Instant startDate = Instant.now();
        IntentContext intentContext = new IntentContext(context);
        ModelHolder intentModel = this.getNlpClassifier().buildIntentModel(intentContext, modelExpressions);
        Sequence $this$groupBy$iv = CollectionsKt.asSequence((Iterable)modelExpressions);
        boolean $i$f$groupBy = false;
        Sequence sequence = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv = iterator.next();
            it = (SampleExpression)element$iv$iv;
            bl = false;
            key$iv$iv = it.getIntent();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                ArrayList answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$mapNotNull$iv = destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$groupByTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv22;
        boolean $i$f$forEach = false;
        list$iv$iv = $this$forEach$iv$iv$iv;
        bl = false;
        key$iv$iv = list$iv$iv.entrySet().iterator();
        while (key$iv$iv.hasNext()) {
            Map.Entry entry;
            void intent;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = (Map.Entry)key$iv$iv.next();
            boolean bl5 = false;
            Map.Entry $dstr$intent$expressions = element$iv$iv;
            boolean bl6 = false;
            Map.Entry entry2 = $dstr$intent$expressions;
            boolean bl7 = false;
            Intent intent2 = (Intent)entry2.getKey();
            entry2 = $dstr$intent$expressions;
            bl7 = false;
            List expressions2 = (List)entry2.getValue();
            try {
                entry2 = TuplesKt.to((Object)intent, (Object)INSTANCE.getNlpClassifier().buildEntityModel((EntityBuildContext)new EntityBuildContextForIntent(context, (Intent)intent), expressions2));
            }
            catch (Exception e) {
                logger.error((Function0)new Function0<String>((Intent)intent){
                    final /* synthetic */ Intent $intent;

                    @NotNull
                    public final String invoke() {
                        return "entity model build fail for " + this.$intent + ' ';
                    }
                    {
                        this.$intent = intent;
                        super(0);
                    }
                });
                LoggersKt.error((KLogger)logger, (Throwable)e);
                entry2 = null;
            }
            if (entry2 == null) continue;
            boolean bl8 = false;
            boolean bl9 = false;
            Map.Entry it$iv$iv = entry;
            boolean bl10 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map entityModels2 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        Duration buildDuration = Duration.between(startDate, Instant.now());
        boolean $this$mapNotNullTo$iv$iv22 = false;
        List intentErrors = new ArrayList();
        boolean destination$iv$iv2 = false;
        List entityErrors = new ArrayList();
        Iterable $this$forEach$iv = testedExpressions;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (SampleExpression)element$iv;
            boolean bl11 = false;
            ParsingResult parseResult = NlpCoreService.INSTANCE.parse$tock_nlp_core_service(context, it.getText(), intentModel, entityModels2);
            if (Intrinsics.areEqual((Object)parseResult.getIntent(), (Object)it.getIntent().getName()) ^ true) {
                intentErrors.add(new IntentMatchError(it, parseResult.getIntent(), parseResult.getIntentProbability()));
                continue;
            }
            if (!INSTANCE.hasNotSameEntities(it.getEntities(), parseResult.getEntities())) continue;
            entityErrors.add(new EntityMatchError(it, parseResult.getEntities()));
        }
        Duration testDuration = Duration.between(startDate.plus(buildDuration), Instant.now());
        Duration duration = buildDuration;
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"buildDuration");
        Duration duration2 = testDuration;
        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"testDuration");
        Instant instant = startDate;
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"startDate");
        return new TestModelReport(expressions, testedExpressions, intentErrors, entityErrors, duration, duration2, instant);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasNotSameEntities(List<SampleEntity> expectedEntities, List<EntityRecognition> entities) {
        boolean bl;
        Object element$iv;
        Iterator iterator;
        boolean $i$f$none;
        Iterable $this$none$iv;
        boolean bl2;
        Iterable $this$any$iv = expectedEntities;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl2 = false;
        } else {
            for (Object element$iv2 : $this$any$iv) {
                EntityRecognition it;
                SampleEntity e = (SampleEntity)element$iv2;
                boolean bl3 = false;
                $this$none$iv = entities;
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    return true;
                }
                iterator = $this$none$iv.iterator();
                do {
                    if (!iterator.hasNext()) return true;
                    element$iv = iterator.next();
                    it = (EntityRecognition)element$iv;
                    boolean bl4 = false;
                } while (!(Intrinsics.areEqual((Object)it.getRole(), (Object)e.getDefinition().getRole()) && Intrinsics.areEqual((Object)it.getEntityType(), (Object)e.getDefinition().getEntityType()) && it.isSameRange((IntOpenRange)e)));
                boolean bl5 = false;
                if (!bl5) continue;
                return true;
            }
            bl2 = false;
        }
        if (bl2) return true;
        $this$any$iv = entities;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            SampleEntity e;
            Object element$iv2;
            if (!iterator2.hasNext()) return false;
            element$iv2 = iterator2.next();
            EntityRecognition it = (EntityRecognition)element$iv2;
            boolean bl6 = false;
            $this$none$iv = expectedEntities;
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                return true;
            }
            iterator = $this$none$iv.iterator();
            do {
                if (!iterator.hasNext()) return true;
                element$iv = iterator.next();
                e = (SampleEntity)element$iv;
                boolean bl7 = false;
            } while (!(Intrinsics.areEqual((Object)it.getRole(), (Object)e.getDefinition().getRole()) && Intrinsics.areEqual((Object)it.getEntityType(), (Object)e.getDefinition().getEntityType()) && it.isSameRange((IntOpenRange)e)));
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public NlpApplicationConfiguration getCurrentModelConfiguration(@NotNull String applicationName, @NotNull NlpEngineType nlpEngineType) {
        Intrinsics.checkParameterIsNotNull((Object)applicationName, (String)"applicationName");
        Intrinsics.checkParameterIsNotNull((Object)nlpEngineType, (String)"nlpEngineType");
        return this.getNlpClassifier().getCurrentModelConfiguration(applicationName, nlpEngineType);
    }

    public void updateModelConfiguration(@NotNull String applicationName, @NotNull NlpEngineType engineType, @NotNull NlpApplicationConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)applicationName, (String)"applicationName");
        Intrinsics.checkParameterIsNotNull((Object)engineType, (String)"engineType");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        this.getNlpClassifier().updateModelConfiguration(applicationName, engineType, configuration);
    }

    private ModelCoreService() {
    }
}

