/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.core.service.entity;

import ai.tock.nlp.core.DictionaryData;
import ai.tock.nlp.core.EntityType;
import ai.tock.nlp.core.PredefinedValue;
import ai.tock.nlp.core.service.entity.DictionaryEntityTypeClassifier;
import ai.tock.nlp.core.service.entity.DictionaryRepositoryService;
import ai.tock.nlp.core.service.entity.EntityTypeClassifier;
import ai.tock.nlp.core.service.entity.EntityTypeRecognition;
import ai.tock.nlp.core.service.entity.EntityTypeValue;
import ai.tock.nlp.model.EntityCallContext;
import ai.tock.nlp.model.EntityCallContextForEntity;
import ai.tock.nlp.model.EntityCallContextForIntent;
import ai.tock.nlp.model.EntityCallContextForSubEntities;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J6\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u001a\u0010\u0010\u001a\u0016\u0012\u0004\u0012\u00020\r\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00040\u00112\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0013"}, d2={"Lai/tock/nlp/core/service/entity/DictionaryEntityTypeClassifier;", "Lai/tock/nlp/core/service/entity/EntityTypeClassifier;", "()V", "classifyEntities", "", "Lai/tock/nlp/core/service/entity/EntityTypeRecognition;", "context", "Lai/tock/nlp/model/EntityCallContext;", "text", "", "classifyForIntent", "Lai/tock/nlp/model/EntityCallContextForIntent;", "predefinedValueOfSynonym", "Lai/tock/nlp/core/PredefinedValue;", "locale", "Ljava/util/Locale;", "predefinedValues", "", "stripAccents", "tock-nlp-core-service"})
public final class DictionaryEntityTypeClassifier
implements EntityTypeClassifier {
    @NotNull
    public static final DictionaryEntityTypeClassifier INSTANCE = new DictionaryEntityTypeClassifier();

    private DictionaryEntityTypeClassifier() {
    }

    @Override
    @NotNull
    public List<EntityTypeRecognition> classifyEntities(@NotNull EntityCallContext context, @NotNull String text) {
        List list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        EntityCallContext entityCallContext = context;
        if (entityCallContext instanceof EntityCallContextForIntent) {
            list = this.classifyForIntent((EntityCallContextForIntent)context, this.stripAccents(text));
        } else if (entityCallContext instanceof EntityCallContextForEntity) {
            list = CollectionsKt.emptyList();
        } else if (entityCallContext instanceof EntityCallContextForSubEntities) {
            list = CollectionsKt.emptyList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private final List<EntityTypeRecognition> classifyForIntent(EntityCallContextForIntent context, String text) {
        return SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)context.getIntent().getEntities()), (Function1)classifyForIntent.1.INSTANCE)), (Function1)((Function1)new Function1<EntityType, Sequence<? extends EntityTypeRecognition>>(context, text){
            final /* synthetic */ EntityCallContextForIntent $context;
            final /* synthetic */ String $text;
            {
                this.$context = $context;
                this.$text = $text;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Sequence<EntityTypeRecognition> invoke(@NotNull EntityType e) {
                Sequence sequence;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                DictionaryData data = DictionaryRepositoryService.INSTANCE.getDictionary(e);
                if (data != null) {
                    void $this$flatMapTo$iv$iv;
                    Map labelsMap = data.getLabelsMap(this.$context.getLanguage());
                    Iterable $this$flatMap$iv = labelsMap.values();
                    boolean $i$f$flatMap = false;
                    Iterable iterable = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$flatMapTo = false;
                    for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                        List it = (List)element$iv$iv;
                        boolean bl = false;
                        List list = it;
                        Iterable list$iv$iv = list == null ? CollectionsKt.emptyList() : list;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    List synonyms = (List)destination$iv$iv;
                    sequence = SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)SequencesKt.distinct((Sequence)CollectionsKt.asSequence((Iterable)synonyms)), (Function1)((Function1)new Function1<String, Boolean>(this.$text){
                        final /* synthetic */ String $text;
                        {
                            this.$text = $text;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull String synonym) {
                            Intrinsics.checkNotNullParameter((Object)synonym, (String)"synonym");
                            return StringsKt.contains((CharSequence)this.$text, (CharSequence)synonym, (boolean)true);
                        }
                    })), (Function1)((Function1)new Function1<String, Sequence<? extends EntityTypeRecognition>>(this.$text, this.$context, (Map<PredefinedValue, ? extends List<String>>)labelsMap, e){
                        final /* synthetic */ String $text;
                        final /* synthetic */ EntityCallContextForIntent $context;
                        final /* synthetic */ Map<PredefinedValue, List<String>> $labelsMap;
                        final /* synthetic */ EntityType $e;
                        {
                            this.$text = $text;
                            this.$context = $context;
                            this.$labelsMap = $labelsMap;
                            this.$e = $e;
                            super(1);
                        }

                        @NotNull
                        public final Sequence<EntityTypeRecognition> invoke(@NotNull String synonym) {
                            Intrinsics.checkNotNullParameter((Object)synonym, (String)"synonym");
                            String string = "\\s+(" + synonym + ")\\s+|^(" + synonym + ")$|^(" + synonym + ")\\s+|\\s+(" + synonym + ")$";
                            RegexOption regexOption = RegexOption.IGNORE_CASE;
                            boolean bl = false;
                            return SequencesKt.mapNotNull((Sequence)Regex.findAll$default((Regex)new Regex(string, regexOption), (CharSequence)this.$text, (int)0, (int)2, null), (Function1)((Function1)new Function1<MatchResult, EntityTypeRecognition>(synonym, this.$context, this.$labelsMap, this.$e){
                                final /* synthetic */ String $synonym;
                                final /* synthetic */ EntityCallContextForIntent $context;
                                final /* synthetic */ Map<PredefinedValue, List<String>> $labelsMap;
                                final /* synthetic */ EntityType $e;
                                {
                                    this.$synonym = $synonym;
                                    this.$context = $context;
                                    this.$labelsMap = $labelsMap;
                                    this.$e = $e;
                                    super(1);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                @Nullable
                                public final EntityTypeRecognition invoke(@NotNull MatchResult m) {
                                    EntityTypeRecognition entityTypeRecognition;
                                    Object v0;
                                    String string;
                                    Iterable iterable;
                                    block3: {
                                        void $this$firstOrNull$iv;
                                        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                                        iterable = CollectionsKt.filterNotNull((Iterable)((Iterable)m.getGroups()));
                                        string = this.$synonym;
                                        boolean $i$f$firstOrNull = false;
                                        for (T element$iv : $this$firstOrNull$iv) {
                                            MatchGroup it = (MatchGroup)element$iv;
                                            boolean bl = false;
                                            if (!StringsKt.equals((String)it.getValue(), (String)string, (boolean)true)) continue;
                                            v0 = element$iv;
                                            break block3;
                                        }
                                        v0 = null;
                                    }
                                    MatchGroup matchGroup = v0;
                                    if (matchGroup == null) {
                                        entityTypeRecognition = null;
                                    } else {
                                        iterable = matchGroup;
                                        string = this.$context;
                                        Map<PredefinedValue, List<String>> map = this.$labelsMap;
                                        String string2 = this.$synonym;
                                        EntityType entityType = this.$e;
                                        boolean bl = false;
                                        boolean bl2 = false;
                                        Iterable g = iterable;
                                        boolean bl3 = false;
                                        PredefinedValue predefinedValueOfSynonym = DictionaryEntityTypeClassifier.access$predefinedValueOfSynonym(DictionaryEntityTypeClassifier.INSTANCE, string.getLanguage(), map, string2);
                                        int n = g.getRange().getFirst();
                                        int n2 = g.getRange().getLast() + 1;
                                        PredefinedValue predefinedValue = predefinedValueOfSynonym;
                                        Intrinsics.checkNotNull((Object)predefinedValue);
                                        entityTypeRecognition = new EntityTypeRecognition(new EntityTypeValue(n, n2, entityType, predefinedValue.getValue(), true), 1.0);
                                    }
                                    return entityTypeRecognition;
                                }
                            }));
                        }
                    }));
                } else {
                    sequence = SequencesKt.emptySequence();
                }
                return sequence;
            }
        })), (Function1)classifyForIntent.3.INSTANCE)));
    }

    private final PredefinedValue predefinedValueOfSynonym(Locale locale, Map<PredefinedValue, ? extends List<String>> predefinedValues, String text) {
        for (PredefinedValue predefinedValue : predefinedValues.keySet()) {
            Object v5;
            block4: {
                if (predefinedValues.get(predefinedValue) == null) continue;
                List<String> list = predefinedValues.get(predefinedValue);
                Intrinsics.checkNotNull(list);
                List synonyms = CollectionsKt.plus((Collection)CollectionsKt.toMutableList((Collection)list), (Object)predefinedValue.getValue());
                Iterable iterable = synonyms;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    String s = (String)t;
                    boolean bl3 = false;
                    String string = s;
                    boolean bl4 = false;
                    String string2 = string;
                    boolean bl5 = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
                    string = text;
                    bl4 = false;
                    string2 = string;
                    bl5 = false;
                    String string5 = string2;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string6 = string5.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase(locale)");
                    if (!Intrinsics.areEqual((Object)string4, (Object)INSTANCE.stripAccents(string6))) continue;
                    v5 = t;
                    break block4;
                }
                v5 = null;
            }
            if (v5 == null) continue;
            return predefinedValue;
        }
        return null;
    }

    private final String stripAccents(String text) {
        String string = text;
        CharSequence charSequence = Normalizer.normalize(string, Normalizer.Form.NFD);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"normalize(string, Normalizer.Form.NFD)");
        string = charSequence;
        charSequence = string;
        String string2 = "[\\p{InCombiningDiacriticalMarks}]";
        boolean bl = false;
        string2 = new Regex(string2);
        String string3 = "";
        boolean bl2 = false;
        string = string2.replace(charSequence, string3);
        return string;
    }

    public static final /* synthetic */ PredefinedValue access$predefinedValueOfSynonym(DictionaryEntityTypeClassifier $this, Locale locale, Map predefinedValues, String text) {
        return $this.predefinedValueOfSynonym(locale, predefinedValues, text);
    }
}

