/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.core.service.entity;

import ai.tock.nlp.core.CallContext;
import ai.tock.nlp.core.Entity;
import ai.tock.nlp.core.EntityRecognition;
import ai.tock.nlp.core.EntityType;
import ai.tock.nlp.core.EntityValue;
import ai.tock.nlp.core.merge.ValueDescriptor;
import ai.tock.nlp.core.service.entity.EntityCore;
import ai.tock.nlp.core.service.entity.EntityCoreService;
import ai.tock.nlp.core.service.entity.EntityTypeClassifier;
import ai.tock.nlp.core.service.entity.EntityTypeEvaluator;
import ai.tock.nlp.core.service.entity.EntityTypeProvider;
import ai.tock.nlp.core.service.entity.EntityTypeRecognition;
import ai.tock.nlp.core.service.entity.EvaluationResult;
import ai.tock.nlp.model.EntityCallContext;
import ai.tock.nlp.model.EntityCallContextForEntity;
import ai.tock.nlp.model.EntityCallContextForIntent;
import ai.tock.nlp.model.EntityCallContextForSubEntities;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.StringsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u00042\u0006\u0010\u0015\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\fH\u0002J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J \u0010\u001b\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\fH\u0002J,\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00042\u0006\u0010\u0015\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0004H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010!2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020)H\u0016J \u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u0015\u001a\u00020\"2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020+0\u0004H\u0016J\u0010\u0010-\u001a\u00020)2\u0006\u0010&\u001a\u00020'H\u0016R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lai/tock/nlp/core/service/entity/EntityCoreService;", "Lai/tock/nlp/core/service/entity/EntityCore;", "()V", "entityTypeProviders", "", "Lai/tock/nlp/core/service/entity/EntityTypeProvider;", "getEntityTypeProviders", "()Ljava/util/List;", "entityTypeProviders$delegate", "Lkotlin/Lazy;", "knownEntityTypes", "", "", "getKnownEntityTypes", "()Ljava/util/Set;", "logger", "Lmu/KLogger;", "classifyEntities", "Lai/tock/nlp/core/service/entity/EntityTypeRecognition;", "classifier", "Lai/tock/nlp/core/service/entity/EntityTypeClassifier;", "context", "Lai/tock/nlp/model/EntityCallContext;", "text", "classifyEntityTypes", "classifyEntityTypesForIntent", "Lai/tock/nlp/model/EntityCallContextForIntent;", "evaluate", "Lai/tock/nlp/core/EntityRecognition;", "Lai/tock/nlp/core/CallContext;", "e", "Lai/tock/nlp/core/service/entity/EvaluationResult;", "evaluator", "Lai/tock/nlp/core/service/entity/EntityTypeEvaluator;", "Lai/tock/nlp/model/EntityCallContextForEntity;", "evaluateEntities", "entitiesRecognition", "getEntityEvaluator", "entityType", "Lai/tock/nlp/core/EntityType;", "healthcheck", "", "mergeValues", "Lai/tock/nlp/core/merge/ValueDescriptor;", "values", "supportValuesMerge", "tock-nlp-core-service"})
public final class EntityCoreService
implements EntityCore {
    @NotNull
    public static final EntityCoreService INSTANCE = new EntityCoreService();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    private static final Lazy entityTypeProviders$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)entityTypeProviders.2.INSTANCE);

    private EntityCoreService() {
    }

    private final List<EntityTypeProvider> getEntityTypeProviders() {
        Lazy lazy = entityTypeProviders$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> getKnownEntityTypes() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getEntityTypeProviders();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            EntityTypeProvider it = (EntityTypeProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.supportedEntityTypes();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final EntityTypeEvaluator getEntityEvaluator(EntityType entityType) {
        Object v0;
        block1: {
            Pair pair = StringsKt.namespaceAndName((String)entityType.getName());
            boolean bl = false;
            boolean bl2 = false;
            Pair $dstr$namespace$name = pair;
            boolean bl3 = false;
            String namespace = (String)$dstr$namespace$name.component1();
            String name = (String)$dstr$namespace$name.component2();
            Iterable $this$firstOrNull$iv = INSTANCE.getEntityTypeProviders();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EntityTypeProvider it = (EntityTypeProvider)element$iv;
                boolean bl4 = false;
                if (!it.supportEvaluation(namespace, name)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        EntityTypeProvider entityTypeProvider = v0;
        return entityTypeProvider == null ? null : entityTypeProvider.getEntityTypeEvaluator();
    }

    @Override
    public boolean supportValuesMerge(@NotNull EntityType entityType) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
            Pair pair = StringsKt.namespaceAndName((String)entityType.getName());
            boolean bl2 = false;
            boolean bl3 = false;
            Pair $dstr$namespace$name = pair;
            boolean bl4 = false;
            String namespace = (String)$dstr$namespace$name.component1();
            String name = (String)$dstr$namespace$name.component2();
            Iterable $this$any$iv = INSTANCE.getEntityTypeProviders();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    EntityTypeProvider it = (EntityTypeProvider)element$iv;
                    boolean bl5 = false;
                    if (!it.supportValuesMerge(namespace, name)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public List<EntityTypeRecognition> classifyEntityTypes(@NotNull EntityCallContext context, @NotNull String text) {
        List list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        EntityCallContext entityCallContext = context;
        if (entityCallContext instanceof EntityCallContextForIntent) {
            list = this.classifyEntityTypesForIntent((EntityCallContextForIntent)context, text);
        } else if (entityCallContext instanceof EntityCallContextForEntity) {
            list = CollectionsKt.emptyList();
        } else if (entityCallContext instanceof EntityCallContextForSubEntities) {
            list = CollectionsKt.emptyList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<EntityTypeRecognition> classifyEntityTypesForIntent(EntityCallContextForIntent context, String text) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = context.getIntent().getEntities();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            EntityTypeClassifier entityTypeClassifier;
            Object v0;
            block3: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Entity e = (Entity)element$iv$iv;
                boolean bl2 = false;
                Pair pair = StringsKt.namespaceAndName((String)e.getEntityType().getName());
                boolean bl3 = false;
                boolean bl4 = false;
                Pair $dstr$namespace$name = pair;
                boolean bl5 = false;
                String namespace = (String)$dstr$namespace$name.component1();
                String name = (String)$dstr$namespace$name.component2();
                Iterable $this$firstOrNull$iv = INSTANCE.getEntityTypeProviders();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    EntityTypeProvider it = (EntityTypeProvider)element$iv;
                    boolean bl6 = false;
                    if (!it.supportClassification(namespace, name)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            EntityTypeProvider entityTypeProvider = v0;
            if ((entityTypeProvider == null ? null : entityTypeProvider.getEntityTypeClassifier()) == null) continue;
            entityTypeClassifier = entityTypeClassifier;
            boolean bl = false;
            boolean bl7 = false;
            EntityTypeClassifier it$iv$iv = entityTypeClassifier;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$flatMap$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$flatMap = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            EntityTypeClassifier it = (EntityTypeClassifier)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = INSTANCE.classifyEntities(it, (EntityCallContext)context, text);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<EntityTypeRecognition> classifyEntities(EntityTypeClassifier classifier, EntityCallContext context, String text) {
        List list;
        try {
            list = classifier.classifyEntities(context, text);
        }
        catch (Throwable e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<EntityRecognition> evaluateEntities(@NotNull CallContext context, @NotNull String text, @NotNull List<EntityRecognition> entitiesRecognition) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(entitiesRecognition, (String)"entitiesRecognition");
        Iterable $this$map$iv = entitiesRecognition;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void e;
            EntityRecognition entityRecognition = (EntityRecognition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            EntityRecognition entityRecognition2 = INSTANCE.evaluate(context, text, (EntityRecognition)e);
            collection.add(entityRecognition2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final EntityRecognition evaluate(CallContext context, String text, EntityRecognition e) {
        EntityRecognition entityRecognition;
        boolean bl;
        EvaluationResult evaluationResult;
        if (e.getValue().getEvaluated()) {
            return e;
        }
        Object object = this.getEntityEvaluator(e.getEntityType());
        if (object == null) {
            evaluationResult = null;
        } else {
            EntityTypeEvaluator entityTypeEvaluator = object;
            boolean bl2 = false;
            bl = false;
            EntityTypeEvaluator evaluator = entityTypeEvaluator;
            boolean bl3 = false;
            evaluationResult = INSTANCE.evaluate(evaluator, new EntityCallContextForEntity(context, e.getValue().getEntity()), e.getValue().textValue(text));
        }
        EvaluationResult root = evaluationResult;
        object = e.getValue().getSubEntities();
        boolean bl4 = false;
        if (!object.isEmpty()) {
            void $this$mapTo$iv$iv;
            String t = e.textValue(text);
            double d = root == null ? 1.0 : e.getProbability();
            EntityValue entityValue = e.getValue();
            EvaluationResult evaluationResult2 = root;
            Object bl3 = evaluationResult2 == null ? null : evaluationResult2.getValue();
            Object object2 = root;
            boolean bl5 = object2 == null ? false : ((EvaluationResult)object2).getEvaluated();
            Iterable $this$map$iv = e.getValue().getSubEntities();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                EntityRecognition entityRecognition2 = (EntityRecognition)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl6 = false;
                EntityRecognition entityRecognition3 = INSTANCE.evaluate(context, t, (EntityRecognition)it);
                collection.add(entityRecognition3);
            }
            object2 = (List)destination$iv$iv;
            EntityValue entityValue2 = EntityValue.copy$default((EntityValue)entityValue, (int)0, (int)0, null, (Object)bl3, (List)object2, (boolean)bl5, (int)7, null);
            entityRecognition = e.copy(entityValue2, d);
        } else {
            object = root;
            if (object == null) {
                entityRecognition = e;
            } else {
                Object object3 = object;
                bl = false;
                boolean bl7 = false;
                Object it = object3;
                boolean bl8 = false;
                double d = ((EvaluationResult)it).getProbability();
                EntityValue entityValue = EntityValue.copy$default((EntityValue)e.getValue(), (int)0, (int)0, null, (Object)((EvaluationResult)it).getValue(), null, (boolean)((EvaluationResult)it).getEvaluated(), (int)23, null);
                EntityRecognition entityRecognition4 = e.copy(entityValue, d);
                entityRecognition = entityRecognition4 == null ? e : entityRecognition4;
            }
        }
        return entityRecognition;
    }

    private final EvaluationResult evaluate(EntityTypeEvaluator evaluator, EntityCallContextForEntity context, String text) {
        EvaluationResult evaluationResult;
        try {
            evaluationResult = evaluator.evaluate(context, text);
        }
        catch (Throwable e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
            evaluationResult = new EvaluationResult(false, null, 0.0, 6, null);
        }
        return evaluationResult;
    }

    @Override
    @Nullable
    public ValueDescriptor mergeValues(@NotNull EntityCallContextForEntity context, @NotNull List<ValueDescriptor> values) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        EntityTypeEvaluator entityTypeEvaluator = this.getEntityEvaluator(context.getEntityType());
        return entityTypeEvaluator == null ? null : entityTypeEvaluator.merge(context, values);
    }

    @Override
    public boolean healthcheck() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.getEntityTypeProviders();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    EntityTypeProvider it = (EntityTypeProvider)element$iv;
                    boolean bl2 = false;
                    if (it.healthcheck()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }
}

