/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.core.service.entity;

import ai.tock.nlp.core.Entity;
import ai.tock.nlp.core.EntityRecognition;
import ai.tock.nlp.core.EntityType;
import ai.tock.nlp.core.EntityValue;
import ai.tock.nlp.core.IntOpenRange;
import ai.tock.nlp.core.service.entity.EntityTypeValue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0001H\u0096\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00d6\u0001J\u0011\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0001H\u0096\u0001J\u0011\u0010 \u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0001H\u0096\u0001J\u0019\u0010 \u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0096\u0001J\t\u0010!\u001a\u00020\bH\u0096\u0001J\u0011\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0096\u0001J\t\u0010%\u001a\u00020&H\u0096\u0001J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020#J\t\u0010*\u001a\u00020#H\u00d6\u0001R\u0012\u0010\u0007\u001a\u00020\bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006+"}, d2={"Lai/tock/nlp/core/service/entity/EntityTypeRecognition;", "Lai/tock/nlp/core/IntOpenRange;", "value", "Lai/tock/nlp/core/service/entity/EntityTypeValue;", "probability", "", "(Lai/tock/nlp/core/service/entity/EntityTypeValue;D)V", "end", "", "getEnd", "()I", "entityType", "Lai/tock/nlp/core/EntityType;", "getEntityType", "()Lai/tock/nlp/core/EntityType;", "getProbability", "()D", "start", "getStart", "getValue", "()Lai/tock/nlp/core/service/entity/EntityTypeValue;", "compareTo", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "isSameRange", "range", "overlap", "size", "textValue", "", "originalText", "toClosedRange", "Lkotlin/ranges/IntRange;", "toEntityRecognition", "Lai/tock/nlp/core/EntityRecognition;", "role", "toString", "tock-nlp-core-service"})
public final class EntityTypeRecognition
implements IntOpenRange {
    @NotNull
    private final EntityTypeValue value;
    private final double probability;
    @NotNull
    private final transient EntityType entityType;

    public EntityTypeRecognition(@NotNull EntityTypeValue value, double probability) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
        this.probability = probability;
        this.entityType = this.value.getEntityType();
    }

    @NotNull
    public final EntityTypeValue getValue() {
        return this.value;
    }

    public final double getProbability() {
        return this.probability;
    }

    public int getEnd() {
        return this.value.getEnd();
    }

    public int getStart() {
        return this.value.getStart();
    }

    public int compareTo(@NotNull IntOpenRange other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.value.compareTo(other);
    }

    public boolean isSameRange(@NotNull IntOpenRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return this.value.isSameRange(range);
    }

    public boolean overlap(@NotNull IntOpenRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return this.value.overlap(range);
    }

    public boolean overlap(int start, int end) {
        return this.value.overlap(start, end);
    }

    public int size() {
        return this.value.size();
    }

    @NotNull
    public String textValue(@NotNull String originalText) {
        Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
        return this.value.textValue(originalText);
    }

    @NotNull
    public IntRange toClosedRange() {
        return this.value.toClosedRange();
    }

    @NotNull
    public final EntityType getEntityType() {
        return this.entityType;
    }

    @NotNull
    public final EntityRecognition toEntityRecognition(@NotNull String role) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        return new EntityRecognition(new EntityValue(this.value.getStart(), this.value.getEnd(), new Entity(this.value.getEntityType(), role), this.value.getValue(), CollectionsKt.emptyList(), this.value.getEvaluated()), this.probability);
    }

    @NotNull
    public final EntityTypeValue component1() {
        return this.value;
    }

    public final double component2() {
        return this.probability;
    }

    @NotNull
    public final EntityTypeRecognition copy(@NotNull EntityTypeValue value, double probability) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new EntityTypeRecognition(value, probability);
    }

    public static /* synthetic */ EntityTypeRecognition copy$default(EntityTypeRecognition entityTypeRecognition, EntityTypeValue entityTypeValue, double d, int n, Object object) {
        if ((n & 1) != 0) {
            entityTypeValue = entityTypeRecognition.value;
        }
        if ((n & 2) != 0) {
            d = entityTypeRecognition.probability;
        }
        return entityTypeRecognition.copy(entityTypeValue, d);
    }

    @NotNull
    public String toString() {
        return "EntityTypeRecognition(value=" + this.value + ", probability=" + this.probability + ")";
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = result * 31 + Double.hashCode(this.probability);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EntityTypeRecognition)) {
            return false;
        }
        EntityTypeRecognition entityTypeRecognition = (EntityTypeRecognition)other;
        if (!Intrinsics.areEqual((Object)this.value, (Object)entityTypeRecognition.value)) {
            return false;
        }
        return Double.compare(this.probability, entityTypeRecognition.probability) == 0;
    }
}

