/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.core.service;

import ai.tock.nlp.core.CallContext;
import ai.tock.nlp.core.Entity;
import ai.tock.nlp.core.EntityRecognition;
import ai.tock.nlp.core.EntityType;
import ai.tock.nlp.core.Intent;
import ai.tock.nlp.core.IntentClassification;
import ai.tock.nlp.core.IntentSelector;
import ai.tock.nlp.core.NlpCore;
import ai.tock.nlp.core.NlpEngineType;
import ai.tock.nlp.core.ParsingResult;
import ai.tock.nlp.core.merge.ValueDescriptor;
import ai.tock.nlp.core.quality.TestContext;
import ai.tock.nlp.core.service.NlpCoreService;
import ai.tock.nlp.core.service.entity.EntityCore;
import ai.tock.nlp.core.service.entity.EntityCoreService;
import ai.tock.nlp.core.service.entity.EntityMerge;
import ai.tock.nlp.core.service.entity.EntityTypeRecognition;
import ai.tock.nlp.model.EntityCallContext;
import ai.tock.nlp.model.EntityCallContextForEntity;
import ai.tock.nlp.model.EntityCallContextForIntent;
import ai.tock.nlp.model.IntentContext;
import ai.tock.nlp.model.ModelHolder;
import ai.tock.nlp.model.ModelNotInitializedException;
import ai.tock.nlp.model.NlpClassifier;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.StringsKt;
import com.github.salomonbrys.kodein.InjectedProperty;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JR\u0010\u0017\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190 2\u0006\u0010!\u001a\u00020\"H\u0002J,\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\"0&H\u0016J\b\u0010'\u001a\u00020(H\u0016J(\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020*0\u0019H\u0016JH\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\f\u00100\u001a\b\u0012\u0004\u0012\u000202012\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190 2\u0006\u00103\u001a\u000204H\u0002J \u0010.\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u00103\u001a\u000204H\u0016J;\u0010.\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u0002052\u0006\u0010!\u001a\u00020\"2\u0006\u00106\u001a\u0002072\u0014\u00108\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0006\u0012\u0004\u0018\u00010709H\u0000\u00a2\u0006\u0002\b:J\u0010\u0010;\u001a\u00020(2\u0006\u0010<\u001a\u00020=H\u0016J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020?0&H\u0016J\u0014\u0010@\u001a\u00020\"*\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0002J\u0014\u0010@\u001a\u00020\"*\u0002052\u0006\u0010!\u001a\u00020\"H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\b\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lai/tock/nlp/core/service/NlpCoreService;", "Lai/tock/nlp/core/NlpCore;", "()V", "entityCore", "Lai/tock/nlp/core/service/entity/EntityCore;", "getEntityCore", "()Lai/tock/nlp/core/service/entity/EntityCore;", "entityCore$delegate", "Lcom/github/salomonbrys/kodein/InjectedProperty;", "entityMerge", "Lai/tock/nlp/core/service/entity/EntityMerge;", "getEntityMerge", "()Lai/tock/nlp/core/service/entity/EntityMerge;", "entityMerge$delegate", "logger", "Lmu/KLogger;", "nlpClassifier", "Lai/tock/nlp/model/NlpClassifier;", "getNlpClassifier", "()Lai/tock/nlp/model/NlpClassifier;", "nlpClassifier$delegate", "unknownResult", "Lai/tock/nlp/core/ParsingResult;", "classifyAndEvaluate", "Lkotlin/Pair;", "", "Lai/tock/nlp/core/EntityRecognition;", "context", "Lai/tock/nlp/core/CallContext;", "intent", "Lai/tock/nlp/core/Intent;", "entityClassifier", "Lkotlin/Function1;", "text", "", "evaluateEntities", "entities", "getBuiltInEntityTypes", "", "healthcheck", "", "mergeValues", "Lai/tock/nlp/core/merge/ValueDescriptor;", "entity", "Lai/tock/nlp/core/Entity;", "values", "parse", "callContext", "intentClassifier", "Lkotlin/Function0;", "Lai/tock/nlp/core/IntentClassification;", "intentSelector", "Lai/tock/nlp/core/IntentSelector;", "Lai/tock/nlp/core/quality/TestContext;", "intentModelHolder", "Lai/tock/nlp/model/ModelHolder;", "entityModelHolders", "", "parse$tock_nlp_core_service", "supportValuesMerge", "entityType", "Lai/tock/nlp/core/EntityType;", "supportedNlpEngineTypes", "Lai/tock/nlp/core/NlpEngineType;", "prepareText", "tock-nlp-core-service"})
public final class NlpCoreService
implements NlpCore {
    @NotNull
    public static final NlpCoreService INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final KLogger logger;
    @NotNull
    private static final ParsingResult unknownResult;
    @NotNull
    private static final InjectedProperty entityCore$delegate;
    @NotNull
    private static final InjectedProperty entityMerge$delegate;
    @NotNull
    private static final InjectedProperty nlpClassifier$delegate;

    private NlpCoreService() {
    }

    private final EntityCore getEntityCore() {
        return (EntityCore)entityCore$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final EntityMerge getEntityMerge() {
        return (EntityMerge)entityMerge$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final NlpClassifier getNlpClassifier() {
        return (NlpClassifier)nlpClassifier$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @NotNull
    public ParsingResult parse(@NotNull CallContext context, @NotNull String text, @NotNull IntentSelector intentSelector) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)intentSelector, (String)"intentSelector");
        String t = this.prepareText(context, StringsKt.checkMaxLengthAllowed((String)text));
        return this.parse(context, t, (Function0<? extends IntentClassification>)((Function0)new Function0<IntentClassification>(context, t){
            final /* synthetic */ CallContext $context;
            final /* synthetic */ String $t;
            {
                this.$context = $context;
                this.$t = $t;
                super(0);
            }

            @NotNull
            public final IntentClassification invoke() {
                return NlpCoreService.access$getNlpClassifier(NlpCoreService.INSTANCE).classifyIntent(new IntentContext(this.$context), this.$t);
            }
        }), (Function1<? super Intent, ? extends List<EntityRecognition>>)((Function1)new Function1<Intent, List<? extends EntityRecognition>>(context, t){
            final /* synthetic */ CallContext $context;
            final /* synthetic */ String $t;
            {
                this.$context = $context;
                this.$t = $t;
                super(1);
            }

            @NotNull
            public final List<EntityRecognition> invoke(@NotNull Intent intent) {
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                return NlpCoreService.access$getNlpClassifier(NlpCoreService.INSTANCE).classifyEntities((EntityCallContext)new EntityCallContextForIntent(this.$context, intent), this.$t);
            }
        }), intentSelector);
    }

    @NotNull
    public final ParsingResult parse$tock_nlp_core_service(@NotNull TestContext context, @NotNull String text, @NotNull ModelHolder intentModelHolder, @NotNull Map<Intent, ? extends ModelHolder> entityModelHolders) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)intentModelHolder, (String)"intentModelHolder");
        Intrinsics.checkNotNullParameter(entityModelHolders, (String)"entityModelHolders");
        String t = this.prepareText(context, text);
        return this.parse(context.getCallContext(), t, (Function0<? extends IntentClassification>)((Function0)new Function0<IntentClassification>(context, intentModelHolder, t){
            final /* synthetic */ TestContext $context;
            final /* synthetic */ ModelHolder $intentModelHolder;
            final /* synthetic */ String $t;
            {
                this.$context = $context;
                this.$intentModelHolder = $intentModelHolder;
                this.$t = $t;
                super(0);
            }

            @NotNull
            public final IntentClassification invoke() {
                return NlpCoreService.access$getNlpClassifier(NlpCoreService.INSTANCE).classifyIntent(new IntentContext(this.$context), this.$intentModelHolder, this.$t);
            }
        }), (Function1<? super Intent, ? extends List<EntityRecognition>>)((Function1)new Function1<Intent, List<? extends EntityRecognition>>(entityModelHolders, context, t){
            final /* synthetic */ Map<Intent, ModelHolder> $entityModelHolders;
            final /* synthetic */ TestContext $context;
            final /* synthetic */ String $t;
            {
                this.$entityModelHolders = $entityModelHolders;
                this.$context = $context;
                this.$t = $t;
                super(1);
            }

            @NotNull
            public final List<EntityRecognition> invoke(@NotNull Intent intent) {
                Object object;
                block3: {
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                        object = this.$entityModelHolders.get(intent);
                        if (object == null) break block2;
                        ModelHolder modelHolder = object;
                        TestContext testContext = this.$context;
                        String string = this.$t;
                        ModelHolder entityModel = modelHolder;
                        boolean bl = false;
                        List list = NlpCoreService.access$getNlpClassifier(NlpCoreService.INSTANCE).classifyEntities((EntityCallContext)new EntityCallContextForIntent(testContext, intent), entityModel, string);
                        object = list;
                        if (list != null) break block3;
                    }
                    object = CollectionsKt.emptyList();
                }
                return object;
            }
        }), IntentSelector.Companion.getDefaultIntentSelector());
    }

    /*
     * WARNING - void declaration
     */
    private final ParsingResult parse(CallContext callContext, String text, Function0<? extends IntentClassification> intentClassifier, Function1<? super Intent, ? extends List<EntityRecognition>> entityClassifier, IntentSelector intentSelector) {
        try {
            double d;
            IntentClassification intents = (IntentClassification)intentClassifier.invoke();
            Pair pair = intentSelector.selectIntent(intents);
            if (pair == null) {
                pair = TuplesKt.to(null, null);
            }
            Pair pair2 = pair;
            Intent intent = (Intent)pair2.component1();
            Double probability = (Double)pair2.component2();
            if (intent == null || probability == null) {
                return unknownResult;
            }
            Pair<List<EntityRecognition>, List<EntityRecognition>> pair3 = this.classifyAndEvaluate(callContext, intent, entityClassifier, text);
            List evaluatedEntities = (List)pair3.component1();
            List notRetainedEntities = (List)pair3.component2();
            String string = intent.getName();
            List list = evaluatedEntities;
            List list2 = notRetainedEntities;
            double d2 = probability;
            if (evaluatedEntities.isEmpty()) {
                d = 1.0;
            } else {
                Collection<Double> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = evaluatedEntities;
                double d3 = d2;
                List list3 = list2;
                List list4 = list;
                String string2 = string;
                boolean $i$f$map = false;
                void var15_21 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    EntityRecognition entityRecognition = (EntityRecognition)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getProbability());
                }
                collection = (List)destination$iv$iv;
                string = string2;
                list = list4;
                list2 = list3;
                d2 = d3;
                d = CollectionsKt.averageOfDouble((Iterable)collection);
            }
            double d4 = d;
            double d5 = d2;
            List list5 = list2;
            List list6 = list;
            String string3 = string;
            return new ParsingResult(string3, list6, list5, d5, d4);
        }
        catch (ModelNotInitializedException e) {
            logger.warn((Function0)new Function0<Object>(e){
                final /* synthetic */ ModelNotInitializedException $e;
                {
                    this.$e = $e;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "model not initialized : " + this.$e.getMessage();
                }
            });
            return unknownResult;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
            return unknownResult;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<EntityRecognition>, List<EntityRecognition>> classifyAndEvaluate(CallContext context, Intent intent, Function1<? super Intent, ? extends List<EntityRecognition>> entityClassifier, String text) {
        Pair pair;
        try {
            Pair pair2;
            EntityCallContextForIntent intentContext = new EntityCallContextForIntent(context, intent);
            List entities = (List)entityClassifier.invoke((Object)intent);
            List<EntityRecognition> evaluatedEntities = this.evaluateEntities(context, text, entities);
            if (context.getEvaluationContext().getMergeEntityTypes() || context.getEvaluationContext().getClassifyEntityTypes()) {
                List<EntityTypeRecognition> classifiedEntityTypes = this.getEntityCore().classifyEntityTypes((EntityCallContext)intentContext, text);
                if (!((Collection)classifiedEntityTypes).isEmpty()) {
                    EntityTypeRecognition item$iv$iv;
                    List<EntityRecognition> list;
                    Collection collection;
                    List<EntityRecognition> result;
                    if (context.getEvaluationContext().getMergeEntityTypes()) {
                        Collection<EntityRecognition> collection2;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        result = this.getEntityMerge().mergeEntityTypes(context, text, intent, evaluatedEntities, classifiedEntityTypes);
                        Iterable iterable = classifiedEntityTypes;
                        collection = evaluatedEntities;
                        list = result;
                        boolean $i$f$map2 = false;
                        void var12_17 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator iterator = $this$mapTo$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            void it;
                            EntityTypeRecognition entityTypeRecognition = item$iv$iv = iterator.next();
                            collection2 = destination$iv$iv;
                            boolean bl = false;
                            collection2.add(it.toEntityRecognition(it.getEntityType().getName()));
                        }
                        collection2 = (List)destination$iv$iv;
                        pair2 = TuplesKt.to(list, (Object)CollectionsKt.toList((Iterable)CollectionsKt.subtract((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)collection2), (Iterable)result)));
                    } else {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        result = (List<EntityRecognition>)classifiedEntityTypes;
                        list = evaluatedEntities;
                        boolean $i$f$map = false;
                        void $i$f$map2 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                            void it;
                            item$iv$iv = (EntityTypeRecognition)item$iv$iv2;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(it.toEntityRecognition(it.getEntityType().getName()));
                        }
                        pair2 = TuplesKt.to(list, (Object)CollectionsKt.toList((Iterable)CollectionsKt.subtract((Iterable)((List)destination$iv$iv), (Iterable)evaluatedEntities)));
                    }
                } else {
                    pair2 = TuplesKt.to(evaluatedEntities, (Object)CollectionsKt.emptyList());
                }
            } else {
                pair2 = TuplesKt.to(evaluatedEntities, (Object)CollectionsKt.emptyList());
            }
            pair = pair2;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
            pair = new Pair((Object)CollectionsKt.emptyList(), (Object)CollectionsKt.emptyList());
        }
        return pair;
    }

    @NotNull
    public List<EntityRecognition> evaluateEntities(@NotNull CallContext context, @NotNull String text, @NotNull List<EntityRecognition> entities) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        return this.getEntityCore().evaluateEntities(context, text, entities);
    }

    @NotNull
    public Set<NlpEngineType> supportedNlpEngineTypes() {
        return this.getNlpClassifier().supportedNlpEngineTypes();
    }

    public boolean supportValuesMerge(@NotNull EntityType entityType) {
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        return this.getEntityCore().supportValuesMerge(entityType);
    }

    @Nullable
    public ValueDescriptor mergeValues(@NotNull CallContext context, @NotNull Entity entity, @NotNull List<ValueDescriptor> values) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return this.getEntityCore().mergeValues(new EntityCallContextForEntity(context, entity), values);
    }

    @NotNull
    public Set<String> getBuiltInEntityTypes() {
        return EntityCoreService.INSTANCE.getKnownEntityTypes();
    }

    public boolean healthcheck() {
        return this.getEntityCore().healthcheck();
    }

    private final String prepareText(CallContext $this$prepareText, String text) {
        return $this$prepareText.getApplication().getNormalizeText() ? StringsKt.normalize((String)text, (Locale)$this$prepareText.getLanguage()) : text;
    }

    private final String prepareText(TestContext $this$prepareText, String text) {
        return this.prepareText($this$prepareText.getCallContext(), text);
    }

    public static final /* synthetic */ NlpClassifier access$getNlpClassifier(NlpCoreService $this) {
        return $this.getNlpClassifier();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(NlpCoreService.class, "entityCore", "getEntityCore()Lai/tock/nlp/core/service/entity/EntityCore;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(NlpCoreService.class, "entityMerge", "getEntityMerge()Lai/tock/nlp/core/service/entity/EntityMerge;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(NlpCoreService.class, "nlpClassifier", "getNlpClassifier()Lai/tock/nlp/model/NlpClassifier;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new NlpCoreService();
        logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        unknownResult = new ParsingResult("tock:unknown", CollectionsKt.emptyList(), CollectionsKt.emptyList(), 1.0, 1.0);
        KodeinInjectedBase $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        Object tag$iv = null;
        KodeinInjector kodeinInjector = $receiver$iv.getInjector();
        entityCore$delegate = kodeinInjector.Instance((TypeToken)new TypeReference<EntityCore>(){}, tag$iv);
        $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        tag$iv = null;
        kodeinInjector = $receiver$iv.getInjector();
        entityMerge$delegate = kodeinInjector.Instance((TypeToken)new TypeReference<EntityMerge>(){}, tag$iv);
        $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        tag$iv = null;
        kodeinInjector = $receiver$iv.getInjector();
        nlpClassifier$delegate = kodeinInjector.Instance((TypeToken)new TypeReference<NlpClassifier>(){}, tag$iv);
    }
}

