/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.core.service;

import ai.tock.nlp.core.Application;
import ai.tock.nlp.core.BuildContext;
import ai.tock.nlp.core.CallContext;
import ai.tock.nlp.core.EntityRecognition;
import ai.tock.nlp.core.EntityType;
import ai.tock.nlp.core.IntOpenRange;
import ai.tock.nlp.core.Intent;
import ai.tock.nlp.core.ModelCore;
import ai.tock.nlp.core.NlpEngineType;
import ai.tock.nlp.core.ParsingResult;
import ai.tock.nlp.core.configuration.NlpApplicationConfiguration;
import ai.tock.nlp.core.quality.EntityMatchError;
import ai.tock.nlp.core.quality.IntentMatchError;
import ai.tock.nlp.core.quality.TestContext;
import ai.tock.nlp.core.quality.TestModelReport;
import ai.tock.nlp.core.sample.SampleEntity;
import ai.tock.nlp.core.sample.SampleExpression;
import ai.tock.nlp.core.service.ModelCoreService;
import ai.tock.nlp.core.service.NlpCoreService;
import ai.tock.nlp.model.EntityBuildContext;
import ai.tock.nlp.model.EntityBuildContextForIntent;
import ai.tock.nlp.model.EntityBuildContextForSubEntities;
import ai.tock.nlp.model.EntityCallContext;
import ai.tock.nlp.model.EntityCallContextForIntent;
import ai.tock.nlp.model.IntentContext;
import ai.tock.nlp.model.ModelHolder;
import ai.tock.nlp.model.NlpClassifier;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.StringsKt;
import com.github.salomonbrys.kodein.InjectedProperty;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u000b\u001a\u00020\f2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J$\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00132\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0013H\u0002J\u001e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0013H\u0016J&\u0010'\u001a\u00020\f2\u0006\u0010#\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0013H\u0002J&\u0010+\u001a\u00020\f2\u0006\u0010#\u001a\u00020(2\u0006\u0010,\u001a\u00020\u00142\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0013H\u0016J&\u0010-\u001a\u00020\f2\u0006\u0010#\u001a\u00020(2\u0006\u0010.\u001a\u00020\u00112\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0013H\u0016J\u001e\u0010/\u001a\u00020\f2\u0006\u0010#\u001a\u00020(2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0013H\u0016J \u00100\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u00020\u0016H\u0016J\u0010\u00103\u001a\u00020\f2\u0006\u0010#\u001a\u00020(H\u0016J \u00104\u001a\b\u0012\u0004\u0012\u00020&0\u0013*\u00020(2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0013H\u0002J \u00104\u001a\b\u0012\u0004\u0012\u00020&0\u0013*\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u00065"}, d2={"Lai/tock/nlp/core/service/ModelCoreService;", "Lai/tock/nlp/core/ModelCore;", "()V", "logger", "Lmu/KLogger;", "nlpClassifier", "Lai/tock/nlp/model/NlpClassifier;", "getNlpClassifier", "()Lai/tock/nlp/model/NlpClassifier;", "nlpClassifier$delegate", "Lcom/github/salomonbrys/kodein/InjectedProperty;", "deleteOrphans", "", "applicationsAndIntents", "", "Lai/tock/nlp/core/Application;", "", "Lai/tock/nlp/core/Intent;", "entityTypes", "", "Lai/tock/nlp/core/EntityType;", "getCurrentModelConfiguration", "Lai/tock/nlp/core/configuration/NlpApplicationConfiguration;", "applicationName", "", "nlpEngineType", "Lai/tock/nlp/core/NlpEngineType;", "hasNotSameEntities", "", "expectedEntities", "Lai/tock/nlp/core/sample/SampleEntity;", "entities", "Lai/tock/nlp/core/EntityRecognition;", "testModel", "Lai/tock/nlp/core/quality/TestModelReport;", "context", "Lai/tock/nlp/core/quality/TestContext;", "expressions", "Lai/tock/nlp/core/sample/SampleExpression;", "updateEntityModel", "Lai/tock/nlp/core/BuildContext;", "nlpContext", "Lai/tock/nlp/model/EntityBuildContext;", "updateEntityModelForEntityType", "entityType", "updateEntityModelForIntent", "intent", "updateIntentModel", "updateModelConfiguration", "engineType", "configuration", "warmupModels", "formatExpressions", "tock-nlp-core-service"})
@SourceDebugExtension(value={"SMAP\nModelCoreService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelCoreService.kt\nai/tock/nlp/core/service/ModelCoreService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 7 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n*L\n1#1,223:1\n766#2:224\n857#2,2:225\n1855#2,2:227\n1477#2:229\n1502#2,3:230\n1505#2,3:240\n1855#2,2:256\n1747#2,2:258\n2624#2,3:260\n1749#2:263\n1747#2,2:264\n2624#2,3:266\n1749#2:269\n1549#2:270\n1620#2,3:271\n1549#2:274\n1620#2,3:275\n361#3,7:233\n135#4,9:243\n215#4:252\n216#4:254\n144#4:255\n1#5:253\n80#6:278\n277#7:279\n*S KotlinDebug\n*F\n+ 1 ModelCoreService.kt\nai/tock/nlp/core/service/ModelCoreService\n*L\n62#1:224\n62#1:225,2\n63#1:227,2\n129#1:229\n129#1:230,3\n129#1:240,3\n150#1:256,2\n181#1:258,2\n182#1:260,3\n181#1:263\n188#1:264,2\n189#1:266,3\n188#1:269\n211#1:270\n211#1:271,3\n218#1:274\n218#1:275,3\n129#1:233,7\n130#1:243,9\n130#1:252\n130#1:254\n130#1:255\n130#1:253\n55#1:278\n55#1:279\n*E\n"})
public final class ModelCoreService
implements ModelCore {
    @NotNull
    public static final ModelCoreService INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final KLogger logger;
    @NotNull
    private static final InjectedProperty nlpClassifier$delegate;

    private ModelCoreService() {
    }

    private final NlpClassifier getNlpClassifier() {
        return (NlpClassifier)nlpClassifier$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void warmupModels(@NotNull BuildContext context) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.getNlpClassifier().warmupIntentModel(new IntentContext(context));
        Iterable $this$filter$iv = context.getApplication().getIntents();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Intent it = (Intent)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !((Collection)it.getEntities()).isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Intent it = (Intent)element$iv;
            boolean bl = false;
            INSTANCE.getNlpClassifier().warmupEntityModel((EntityCallContext)new EntityCallContextForIntent(new CallContext(context.getApplication(), context.getLanguage(), context.getEngineType(), null, 8, null), it));
        }
    }

    public void updateIntentModel(@NotNull BuildContext context, @NotNull List<SampleExpression> expressions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        IntentContext nlpContext = new IntentContext(context);
        if (!context.getOnlyIfNotExists() || !this.getNlpClassifier().isIntentModelExist(nlpContext)) {
            this.getNlpClassifier().buildAndSaveIntentModel(nlpContext, this.formatExpressions(context, expressions));
        }
    }

    public void updateEntityModelForIntent(@NotNull BuildContext context, @NotNull Intent intent, @NotNull List<SampleExpression> expressions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        EntityBuildContextForIntent nlpContext = new EntityBuildContextForIntent(context, intent);
        this.updateEntityModel(context, (EntityBuildContext)nlpContext, expressions);
    }

    public void updateEntityModelForEntityType(@NotNull BuildContext context, @NotNull EntityType entityType, @NotNull List<SampleExpression> expressions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        EntityBuildContextForSubEntities nlpContext = new EntityBuildContextForSubEntities(context, entityType);
        this.updateEntityModel(context, (EntityBuildContext)nlpContext, expressions);
    }

    private final void updateEntityModel(BuildContext context, EntityBuildContext nlpContext, List<SampleExpression> expressions) {
        if (!context.getOnlyIfNotExists() || !this.getNlpClassifier().isEntityModelExist(nlpContext)) {
            this.getNlpClassifier().buildAndSaveEntityModel(nlpContext, this.formatExpressions(context, expressions));
        }
    }

    public void deleteOrphans(@NotNull Map<Application, ? extends Set<Intent>> applicationsAndIntents, @NotNull List<EntityType> entityTypes) {
        Intrinsics.checkNotNullParameter(applicationsAndIntents, (String)"applicationsAndIntents");
        Intrinsics.checkNotNullParameter(entityTypes, (String)"entityTypes");
        this.getNlpClassifier().deleteOrphans(applicationsAndIntents, entityTypes);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public TestModelReport testModel(@NotNull TestContext context, @NotNull List<SampleExpression> expressions) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object list$iv$iv;
        SampleExpression it;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        if (expressions.size() < 100) {
            throw new IllegalStateException("at least 100 expressions needed".toString());
        }
        List shuffle = CollectionsKt.toMutableList((Collection)expressions);
        Collections.shuffle(shuffle);
        int limit = (int)((float)expressions.size() * context.getThreshold());
        List<SampleExpression> modelExpressions = shuffle.subList(0, limit);
        List testedExpressions = shuffle.subList(limit, shuffle.size());
        Instant startDate = Instant.now();
        IntentContext intentContext = new IntentContext(context);
        ModelHolder intentModel = this.getNlpClassifier().buildIntentModel(intentContext, this.formatExpressions(context, modelExpressions));
        Iterable iterable = modelExpressions;
        boolean $i$f$groupBy = false;
        void var13_13 = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (SampleExpression)element$iv$iv;
            boolean bl = false;
            Intent key$iv$iv = it.getIntent();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$groupByTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        list$iv$iv = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (list$iv$iv.hasNext()) {
            Pair it$iv$iv;
            Pair pair;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = (Map.Entry)list$iv$iv.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl3 = false;
            Intent intent = (Intent)entry.getKey();
            List expressions2 = (List)entry.getValue();
            try {
                pair = TuplesKt.to((Object)intent, (Object)INSTANCE.getNlpClassifier().buildEntityModel((EntityBuildContext)new EntityBuildContextForIntent(context, intent), INSTANCE.formatExpressions(context, (List<SampleExpression>)expressions2)));
            }
            catch (Exception e) {
                logger.error((Function0)new Function0<Object>(intent){
                    final /* synthetic */ Intent $intent;
                    {
                        this.$intent = $intent;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "entity model build fail for " + this.$intent + " ";
                    }
                });
                LoggersKt.error((KLogger)logger, (Throwable)e);
                pair = null;
            }
            if (pair == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map entityModels2 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        Duration buildDuration = Duration.between(startDate, Instant.now());
        List intentErrors = new ArrayList();
        List entityErrors = new ArrayList();
        Iterable $this$forEach$iv = testedExpressions;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (SampleExpression)element$iv;
            boolean bl = false;
            ParsingResult parseResult = NlpCoreService.INSTANCE.parse$tock_nlp_core_service(context, it.getText(), intentModel, entityModels2);
            if (!Intrinsics.areEqual((Object)parseResult.getIntent(), (Object)it.getIntent().getName())) {
                intentErrors.add(new IntentMatchError(it, parseResult.getIntent(), parseResult.getIntentProbability()));
                continue;
            }
            if (!INSTANCE.hasNotSameEntities(it.getEntities(), parseResult.getEntities())) continue;
            entityErrors.add(new EntityMatchError(it, parseResult.getEntities()));
        }
        Duration testDuration = Duration.between(startDate.plus(buildDuration), Instant.now());
        Intrinsics.checkNotNullExpressionValue((Object)buildDuration, (String)"buildDuration");
        Intrinsics.checkNotNullExpressionValue((Object)testDuration, (String)"testDuration");
        Intrinsics.checkNotNullExpressionValue((Object)startDate, (String)"startDate");
        return new TestModelReport(expressions, testedExpressions, intentErrors, entityErrors, buildDuration, testDuration, startDate);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasNotSameEntities(List<SampleEntity> expectedEntities, List<EntityRecognition> entities) {
        boolean bl;
        Object element$iv;
        Iterator iterator;
        boolean $i$f$none;
        Iterable $this$none$iv;
        boolean bl2;
        Iterable $this$any$iv = expectedEntities;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl2 = false;
        } else {
            for (Object element$iv2 : $this$any$iv) {
                EntityRecognition it;
                SampleEntity e = (SampleEntity)element$iv2;
                boolean bl3 = false;
                $this$none$iv = entities;
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    return true;
                }
                iterator = $this$none$iv.iterator();
                do {
                    if (!iterator.hasNext()) return true;
                    element$iv = iterator.next();
                    it = (EntityRecognition)element$iv;
                    boolean bl4 = false;
                } while (!(Intrinsics.areEqual((Object)it.getRole(), (Object)e.getDefinition().getRole()) && Intrinsics.areEqual((Object)it.getEntityType(), (Object)e.getDefinition().getEntityType()) && it.isSameRange((IntOpenRange)e)));
                boolean bl5 = false;
                if (!bl5) continue;
                return true;
            }
            bl2 = false;
        }
        if (bl2) return true;
        $this$any$iv = entities;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            SampleEntity e;
            Object element$iv2;
            if (!iterator2.hasNext()) return false;
            element$iv2 = iterator2.next();
            EntityRecognition it = (EntityRecognition)element$iv2;
            boolean bl6 = false;
            $this$none$iv = expectedEntities;
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                return true;
            }
            iterator = $this$none$iv.iterator();
            do {
                if (!iterator.hasNext()) return true;
                element$iv = iterator.next();
                e = (SampleEntity)element$iv;
                boolean bl7 = false;
            } while (!(Intrinsics.areEqual((Object)it.getRole(), (Object)e.getDefinition().getRole()) && Intrinsics.areEqual((Object)it.getEntityType(), (Object)e.getDefinition().getEntityType()) && it.isSameRange((IntOpenRange)e)));
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public NlpApplicationConfiguration getCurrentModelConfiguration(@NotNull String applicationName, @NotNull NlpEngineType nlpEngineType) {
        Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
        Intrinsics.checkNotNullParameter((Object)nlpEngineType, (String)"nlpEngineType");
        return this.getNlpClassifier().getCurrentModelConfiguration(applicationName, nlpEngineType);
    }

    public void updateModelConfiguration(@NotNull String applicationName, @NotNull NlpEngineType engineType, @NotNull NlpApplicationConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
        Intrinsics.checkNotNullParameter((Object)engineType, (String)"engineType");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.getNlpClassifier().updateModelConfiguration(applicationName, engineType, configuration);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SampleExpression> formatExpressions(BuildContext $this$formatExpressions, List<SampleExpression> expressions) {
        List list;
        if ($this$formatExpressions.getApplication().getNormalizeText()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = expressions;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void e;
                SampleExpression sampleExpression = (SampleExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(SampleExpression.copy$default((SampleExpression)e, (String)StringsKt.normalize((String)e.getText(), (Locale)$this$formatExpressions.getLanguage()), null, null, null, (int)14, null));
            }
            list = (List)destination$iv$iv;
        } else {
            list = expressions;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SampleExpression> formatExpressions(TestContext $this$formatExpressions, List<SampleExpression> expressions) {
        List list;
        if ($this$formatExpressions.getCallContext().getApplication().getNormalizeText()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = expressions;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void e;
                SampleExpression sampleExpression = (SampleExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(SampleExpression.copy$default((SampleExpression)e, (String)StringsKt.normalize((String)e.getText(), (Locale)$this$formatExpressions.getCallContext().getLanguage()), null, null, null, (int)14, null));
            }
            list = (List)destination$iv$iv;
        } else {
            list = expressions;
        }
        return list;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ModelCoreService.class, "nlpClassifier", "getNlpClassifier()Lai/tock/nlp/model/NlpClassifier;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new ModelCoreService();
        logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        KodeinInjectedBase $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        Object tag$iv = null;
        KodeinInjector kodeinInjector = $receiver$iv.getInjector();
        nlpClassifier$delegate = kodeinInjector.Instance((TypeToken)new TypeReference<NlpClassifier>(){}, tag$iv);
    }
}

