/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.core.service.entity;

import ai.tock.nlp.core.DictionaryData;
import ai.tock.nlp.core.Entity;
import ai.tock.nlp.core.EntityType;
import ai.tock.nlp.core.PredefinedValue;
import ai.tock.nlp.core.service.entity.DictionaryRepositoryService;
import ai.tock.nlp.core.service.entity.EntityTypeClassifier;
import ai.tock.nlp.core.service.entity.EntityTypeRecognition;
import ai.tock.nlp.core.service.entity.EntityTypeValue;
import ai.tock.nlp.model.EntityCallContext;
import ai.tock.nlp.model.EntityCallContextForEntity;
import ai.tock.nlp.model.EntityCallContextForIntent;
import ai.tock.nlp.model.EntityCallContextForSubEntities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J6\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u001a\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00050\u00122\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0013"}, d2={"Lai/tock/nlp/core/service/entity/DictionaryEntityTypeClassifier;", "Lai/tock/nlp/core/service/entity/EntityTypeClassifier;", "<init>", "()V", "classifyEntities", "", "Lai/tock/nlp/core/service/entity/EntityTypeRecognition;", "context", "Lai/tock/nlp/model/EntityCallContext;", "text", "", "classifyForIntent", "Lai/tock/nlp/model/EntityCallContextForIntent;", "predefinedValueOfSynonym", "Lai/tock/nlp/core/PredefinedValue;", "locale", "Ljava/util/Locale;", "predefinedValues", "", "tock-nlp-core-service"})
@SourceDebugExtension(value={"SMAP\nDictionaryEntityTypeClassifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DictionaryEntityTypeClassifier.kt\nai/tock/nlp/core/service/entity/DictionaryEntityTypeClassifier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1#2:116\n295#3,2:117\n1368#3:119\n1454#3,5:120\n*S KotlinDebug\n*F\n+ 1 DictionaryEntityTypeClassifier.kt\nai/tock/nlp/core/service/entity/DictionaryEntityTypeClassifier\n*L\n65#1:117,2\n52#1:119\n52#1:120,5\n*E\n"})
public final class DictionaryEntityTypeClassifier
implements EntityTypeClassifier {
    @NotNull
    public static final DictionaryEntityTypeClassifier INSTANCE = new DictionaryEntityTypeClassifier();

    private DictionaryEntityTypeClassifier() {
    }

    @Override
    @NotNull
    public List<EntityTypeRecognition> classifyEntities(@NotNull EntityCallContext context, @NotNull String text) {
        List<EntityTypeRecognition> list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        EntityCallContext entityCallContext = context;
        if (entityCallContext instanceof EntityCallContextForIntent) {
            list = this.classifyForIntent((EntityCallContextForIntent)context, ((Object)StringsKt.trim((CharSequence)ai.tock.shared.StringsKt.stripAccents((String)text))).toString());
        } else if (entityCallContext instanceof EntityCallContextForEntity) {
            list = CollectionsKt.emptyList();
        } else if (entityCallContext instanceof EntityCallContextForSubEntities) {
            list = CollectionsKt.emptyList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private final List<EntityTypeRecognition> classifyForIntent(EntityCallContextForIntent context, String text) {
        return SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.map((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)context.getIntent().getEntities()), DictionaryEntityTypeClassifier::classifyForIntent$lambda$0)), arg_0 -> DictionaryEntityTypeClassifier.classifyForIntent$lambda$7(context, text, arg_0)), DictionaryEntityTypeClassifier::classifyForIntent$lambda$8)));
    }

    private final PredefinedValue predefinedValueOfSynonym(Locale locale, Map<PredefinedValue, ? extends List<String>> predefinedValues, String text) {
        for (PredefinedValue predefinedValue : predefinedValues.keySet()) {
            Object v2;
            block2: {
                List<String> allValues = predefinedValues.get(predefinedValue);
                if (allValues == null) continue;
                List synonyms = CollectionsKt.plus((Collection)CollectionsKt.toMutableList((Collection)allValues), (Object)predefinedValue.getValue());
                Iterable iterable = synonyms;
                for (Object t : iterable) {
                    String s = (String)t;
                    boolean bl = false;
                    String string = s.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    String string2 = text.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    if (!Intrinsics.areEqual((Object)string, (Object)ai.tock.shared.StringsKt.stripAccents((String)string2))) continue;
                    v2 = t;
                    break block2;
                }
                v2 = null;
            }
            if (v2 == null) continue;
            return predefinedValue;
        }
        return null;
    }

    private static final EntityType classifyForIntent$lambda$0(Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getEntityType();
    }

    private static final boolean classifyForIntent$lambda$7$lambda$2(String $text, String synonym) {
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        Intrinsics.checkNotNullParameter((Object)synonym, (String)"synonym");
        return StringsKt.contains((CharSequence)$text, (CharSequence)synonym, (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    private static final EntityTypeRecognition classifyForIntent$lambda$7$lambda$6$lambda$5(String $synonym, EntityCallContextForIntent $context, Map $labelsMap, EntityType $e, MatchResult m) {
        EntityTypeRecognition entityTypeRecognition;
        Object v0;
        block3: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)$synonym, (String)"$synonym");
            Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
            Intrinsics.checkNotNullParameter((Object)$labelsMap, (String)"$labelsMap");
            Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            Iterable iterable = CollectionsKt.filterNotNull((Iterable)((Iterable)m.getGroups()));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MatchGroup it = (MatchGroup)element$iv;
                boolean bl = false;
                if (!StringsKt.equals((String)it.getValue(), (String)$synonym, (boolean)true)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        MatchGroup matchGroup = v0;
        if (matchGroup != null) {
            MatchGroup g = matchGroup;
            boolean bl = false;
            PredefinedValue predefinedValueOfSynonym = INSTANCE.predefinedValueOfSynonym($context.getLanguage(), $labelsMap, $synonym);
            entityTypeRecognition = predefinedValueOfSynonym != null ? new EntityTypeRecognition(new EntityTypeValue(g.getRange().getFirst(), g.getRange().getLast() + 1, $e, predefinedValueOfSynonym.getValue(), true), 1.0) : null;
        } else {
            entityTypeRecognition = null;
        }
        return entityTypeRecognition;
    }

    private static final Sequence classifyForIntent$lambda$7$lambda$6(String $text, EntityCallContextForIntent $context, Map $labelsMap, EntityType $e, String synonym) {
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$labelsMap, (String)"$labelsMap");
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        Intrinsics.checkNotNullParameter((Object)synonym, (String)"synonym");
        return SequencesKt.mapNotNull((Sequence)Regex.findAll$default((Regex)new Regex("\\s+(" + synonym + ")\\s+|^(" + synonym + ")$|^(" + synonym + ")\\s+|\\s+(" + synonym + ")$", RegexOption.IGNORE_CASE), (CharSequence)$text, (int)0, (int)2, null), arg_0 -> DictionaryEntityTypeClassifier.classifyForIntent$lambda$7$lambda$6$lambda$5(synonym, $context, $labelsMap, $e, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final Sequence classifyForIntent$lambda$7(EntityCallContextForIntent $context, String $text, EntityType e) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DictionaryData data = DictionaryRepositoryService.INSTANCE.getDictionary(e);
        if (data != null) {
            void $this$flatMapTo$iv$iv;
            Map labelsMap = data.getLabelsMap($context.getLanguage());
            Iterable $this$flatMap$iv = labelsMap.values();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List it = (List)element$iv$iv;
                boolean bl = false;
                List list = it;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List synonyms = (List)destination$iv$iv;
            sequence = SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)SequencesKt.distinct((Sequence)CollectionsKt.asSequence((Iterable)synonyms)), arg_0 -> DictionaryEntityTypeClassifier.classifyForIntent$lambda$7$lambda$2($text, arg_0)), arg_0 -> DictionaryEntityTypeClassifier.classifyForIntent$lambda$7$lambda$6($text, $context, labelsMap, e, arg_0));
        } else {
            sequence = SequencesKt.emptySequence();
        }
        return sequence;
    }

    private static final Sequence classifyForIntent$lambda$8(Sequence it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }
}

