/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.core;

import ai.tock.nlp.core.EntityType;
import ai.tock.nlp.core.EntityValue;
import ai.tock.nlp.core.IntOpenRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u0001H\u0096\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010\u001a\u001a\u0004\u0018\u00010 H\u00d6\u0003J\u0006\u0010!\u001a\u00020\u001fJ\t\u0010\"\u001a\u00020\bH\u00d6\u0001J\u0011\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u0001H\u0096\u0001J\u0011\u0010%\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u0001H\u0096\u0001J\u0019\u0010%\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0096\u0001J\t\u0010&\u001a\u00020\bH\u0096\u0001J\u0011\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u0012H\u0096\u0001J\t\u0010)\u001a\u00020*H\u0096\u0001J\t\u0010+\u001a\u00020\u0012H\u00d6\u0001R\u0012\u0010\u0007\u001a\u00020\bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006,"}, d2={"Lai/tock/nlp/core/EntityRecognition;", "Lai/tock/nlp/core/IntOpenRange;", "value", "Lai/tock/nlp/core/EntityValue;", "probability", "", "(Lai/tock/nlp/core/EntityValue;D)V", "end", "", "getEnd", "()I", "entityType", "Lai/tock/nlp/core/EntityType;", "getEntityType", "()Lai/tock/nlp/core/EntityType;", "getProbability", "()D", "role", "", "getRole", "()Ljava/lang/String;", "start", "getStart", "getValue", "()Lai/tock/nlp/core/EntityValue;", "compareTo", "other", "component1", "component2", "copy", "equals", "", "", "hasSubEntities", "hashCode", "isSameRange", "range", "overlap", "size", "textValue", "originalText", "toClosedRange", "Lkotlin/ranges/IntRange;", "toString", "tock-nlp-core-shared"})
public final class EntityRecognition
implements IntOpenRange {
    @NotNull
    private final EntityValue value;
    private final double probability;
    @NotNull
    private final transient EntityType entityType;
    @NotNull
    private final transient String role;

    public EntityRecognition(@NotNull EntityValue value, double probability) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
        this.probability = probability;
        this.entityType = this.value.getEntity().getEntityType();
        this.role = this.value.getEntity().getRole();
    }

    @NotNull
    public final EntityValue getValue() {
        return this.value;
    }

    public final double getProbability() {
        return this.probability;
    }

    @Override
    public int compareTo(@NotNull IntOpenRange other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.value.compareTo(other);
    }

    @Override
    public boolean isSameRange(@NotNull IntOpenRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return this.value.isSameRange(range);
    }

    @Override
    public boolean overlap(@NotNull IntOpenRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return this.value.overlap(range);
    }

    @Override
    public boolean overlap(int start, int end) {
        return this.value.overlap(start, end);
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    @NotNull
    public String textValue(@NotNull String originalText) {
        Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
        return this.value.textValue(originalText);
    }

    @Override
    @NotNull
    public IntRange toClosedRange() {
        return this.value.toClosedRange();
    }

    @Override
    public int getEnd() {
        return this.value.getEnd();
    }

    @Override
    public int getStart() {
        return this.value.getStart();
    }

    @NotNull
    public final EntityType getEntityType() {
        return this.entityType;
    }

    @NotNull
    public final String getRole() {
        return this.role;
    }

    public final boolean hasSubEntities() {
        return this.entityType.hasSubEntities();
    }

    @NotNull
    public final EntityValue component1() {
        return this.value;
    }

    public final double component2() {
        return this.probability;
    }

    @NotNull
    public final EntityRecognition copy(@NotNull EntityValue value, double probability) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new EntityRecognition(value, probability);
    }

    public static /* synthetic */ EntityRecognition copy$default(EntityRecognition entityRecognition, EntityValue entityValue, double d, int n, Object object) {
        if ((n & 1) != 0) {
            entityValue = entityRecognition.value;
        }
        if ((n & 2) != 0) {
            d = entityRecognition.probability;
        }
        return entityRecognition.copy(entityValue, d);
    }

    @NotNull
    public String toString() {
        return "EntityRecognition(value=" + this.value + ", probability=" + this.probability + ')';
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = result * 31 + Double.hashCode(this.probability);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EntityRecognition)) {
            return false;
        }
        EntityRecognition entityRecognition = (EntityRecognition)other;
        if (!Intrinsics.areEqual((Object)this.value, (Object)entityRecognition.value)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.probability, (Object)entityRecognition.probability);
    }
}

