/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.dialogflow;

import ai.tock.bot.admin.answer.AnswerConfigurationType;
import ai.tock.bot.admin.answer.SimpleAnswer;
import ai.tock.bot.admin.answer.SimpleAnswerConfiguration;
import ai.tock.bot.admin.story.StoryDefinitionConfiguration;
import ai.tock.bot.admin.story.StoryDefinitionConfigurationDAO;
import ai.tock.bot.definition.Intent;
import ai.tock.bot.mongo.IocKt;
import ai.tock.nlp.dialogflow.DialogflowIntentImporter;
import ai.tock.nlp.dialogflow.DialogflowService;
import ai.tock.nlp.front.client.FrontClient;
import ai.tock.nlp.front.ioc.FrontIoc;
import ai.tock.nlp.front.shared.codec.ImportReport;
import ai.tock.nlp.front.shared.codec.SentenceDump;
import ai.tock.nlp.front.shared.codec.SentencesDump;
import ai.tock.nlp.front.shared.config.ApplicationDefinition;
import ai.tock.nlp.front.shared.config.ClassifiedSentenceStatus;
import ai.tock.nlp.front.shared.config.IntentDefinition;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.translator.I18nKeyProvider;
import ai.tock.translator.I18nLabel;
import ai.tock.translator.I18nLabelValue;
import ai.tock.translator.Translator;
import com.github.salomonbrys.kodein.InjectedProperty;
import com.github.salomonbrys.kodein.Kodein;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import com.google.cloud.dialogflow.v2.Agent;
import com.google.cloud.dialogflow.v2.Intent;
import com.google.protobuf.ProtocolStringList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.Id;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lai/tock/nlp/dialogflow/DialogflowIntentImporter;", "", "()V", "logger", "Lmu/KLogger;", "projectId", "", "storyDefinitionDAO", "Lai/tock/bot/admin/story/StoryDefinitionConfigurationDAO;", "getStoryDefinitionDAO", "()Lai/tock/bot/admin/story/StoryDefinitionConfigurationDAO;", "storyDefinitionDAO$delegate", "Lcom/github/salomonbrys/kodein/InjectedProperty;", "createSimpleAnswers", "", "Lai/tock/bot/admin/answer/SimpleAnswerConfiguration;", "messagesList", "", "Lcom/google/cloud/dialogflow/v2/Intent$Message;", "locale", "Ljava/util/Locale;", "namespace", "importIntentsFromDialogflow", "", "appName", "appNamespace", "tock-nlp-dialogflow"})
public final class DialogflowIntentImporter {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final String projectId;
    private static final InjectedProperty storyDefinitionDAO$delegate;
    private static final KLogger logger;
    public static final DialogflowIntentImporter INSTANCE;

    static {
        DialogflowIntentImporter dialogflowIntentImporter;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DialogflowIntentImporter.class), "storyDefinitionDAO", "getStoryDefinitionDAO()Lai/tock/bot/admin/story/StoryDefinitionConfigurationDAO;"))};
        INSTANCE = dialogflowIntentImporter = new DialogflowIntentImporter();
        projectId = PropertiesKt.property((String)"dialogflow_project_id", (String)"please set a google project id");
        KodeinInjectedBase $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        Object tag$iv = null;
        KodeinInjector kodeinInjector = $receiver$iv.getInjector();
        TypeToken typeToken = (TypeToken)new TypeReference<StoryDefinitionConfigurationDAO>(){};
        storyDefinitionDAO$delegate = kodeinInjector.Instance(typeToken, tag$iv);
        logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        FrontIoc.INSTANCE.setup(new Kodein.Module[]{IOCsKt.getSharedModule(), IocKt.getBotMongoModule()});
    }

    private final StoryDefinitionConfigurationDAO getStoryDefinitionDAO() {
        return (StoryDefinitionConfigurationDAO)storyDefinitionDAO$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void importIntentsFromDialogflow(@NotNull String appName, @NotNull String appNamespace) {
        Intrinsics.checkParameterIsNotNull((Object)appName, (String)"appName");
        Intrinsics.checkParameterIsNotNull((Object)appNamespace, (String)"appNamespace");
        ApplicationDefinition application = FrontClient.INSTANCE.getApplicationByNamespaceAndName(appNamespace, appName);
        if (application == null) {
            logger.error((Function0)new Function0<String>(appNamespace, appName){
                final /* synthetic */ String $appNamespace;
                final /* synthetic */ String $appName;

                @NotNull
                public final String invoke() {
                    return "Can't find application " + this.$appNamespace + ':' + this.$appName;
                }
                {
                    this.$appNamespace = string;
                    this.$appName = string2;
                    super(0);
                }
            });
        } else {
            Agent agent = DialogflowService.INSTANCE.getAgent(projectId);
            if (agent == null) {
                logger.error((Function0)importIntentsFromDialogflow.2.INSTANCE);
            } else {
                Locale locale = Locale.forLanguageTag(agent.getDefaultLanguageCode());
                boolean bl = false;
                List sentences = new ArrayList();
                for (com.google.cloud.dialogflow.v2.Intent dialogflowIntent : DialogflowService.INSTANCE.getIntents(projectId)) {
                    String intentName;
                    String string = dialogflowIntent.getDisplayName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dialogflowIntent.displayName");
                    String string2 = StringsKt.replace$default((String)string, (String)" ", (String)"_", (boolean)false, (int)4, null);
                    boolean bl2 = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                    IntentDefinition intentDefinition = FrontClient.INSTANCE.getIntentByNamespaceAndName(application.getNamespace(), intentName);
                    if (intentDefinition == null) {
                        Set set = SetsKt.setOf((Object)application.get_id());
                        String string4 = application.getNamespace();
                        String string5 = intentName;
                        bl2 = false;
                        Set set2 = SetsKt.emptySet();
                        DefaultConstructorMarker defaultConstructorMarker = null;
                        int n = 1904;
                        Id id = null;
                        String string6 = null;
                        String string7 = null;
                        String string8 = dialogflowIntent.getDisplayName();
                        Set set3 = null;
                        Set set4 = null;
                        Map map = null;
                        Set set5 = set2;
                        Set set6 = set;
                        String string9 = string4;
                        String string10 = string5;
                        intentDefinition = new IntentDefinition(string10, string9, set6, set5, map, set4, set3, string8, string7, string6, id, n, defaultConstructorMarker);
                        FrontClient.INSTANCE.save(intentDefinition);
                    }
                    for (Intent.TrainingPhrase trainingPhrase : dialogflowIntent.getTrainingPhrasesList()) {
                        String text = "";
                        Intent.TrainingPhrase trainingPhrase2 = trainingPhrase;
                        Intrinsics.checkExpressionValueIsNotNull((Object)trainingPhrase2, (String)"trainingPhrase");
                        for (Intent.TrainingPhrase.Part part : trainingPhrase2.getPartsList()) {
                            StringBuilder stringBuilder = new StringBuilder().append(text);
                            Intent.TrainingPhrase.Part part2 = part;
                            Intrinsics.checkExpressionValueIsNotNull((Object)part2, (String)"part");
                            text = stringBuilder.append(part2.getText()).toString();
                        }
                        sentences.add(new SentenceDump(text, intentDefinition.getQualifiedName(), CollectionsKt.emptyList(), locale, ClassifiedSentenceStatus.model));
                    }
                    List list = dialogflowIntent.getMessagesList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"dialogflowIntent.messagesList");
                    Locale locale2 = locale;
                    Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"locale");
                    List<SimpleAnswerConfiguration> simpleAnswers = this.createSimpleAnswers(list, locale2, application.getNamespace());
                    Collection collection = simpleAnswers;
                    boolean text = false;
                    if (!(!collection.isEmpty())) continue;
                    StoryDefinitionConfiguration storyDefinitionConfiguration = new StoryDefinitionConfiguration(intentName, application.getName(), new Intent(intentName), AnswerConfigurationType.simple, simpleAnswers, 0, application.getNamespace(), null, null, null, null, null, null, null, null, null, 65440, null);
                    try {
                        this.getStoryDefinitionDAO().save(storyDefinitionConfiguration);
                    }
                    catch (Exception e) {
                        LoggersKt.trace((KLogger)logger, (Throwable)e);
                    }
                }
                SentencesDump sentenceDump = new SentencesDump(application.getName(), locale, sentences);
                ImportReport importReport = FrontClient.INSTANCE.importSentences(application.getNamespace(), sentenceDump);
                boolean bl3 = false;
                boolean bl4 = false;
                ImportReport it = importReport;
                boolean bl5 = false;
                if (it.getSuccess()) {
                    logger.info((Function0)new Function0<String>(it){
                        final /* synthetic */ ImportReport $it;

                        @NotNull
                        public final String invoke() {
                            return this.$it.getSentencesImported() + " imported sentences";
                        }
                        {
                            this.$it = importReport;
                            super(0);
                        }
                    });
                } else {
                    logger.error((Function0)importIntentsFromDialogflow.3.2.INSTANCE);
                }
            }
        }
    }

    private final List<SimpleAnswerConfiguration> createSimpleAnswers(List<Intent.Message> messagesList, Locale locale, String namespace) {
        boolean bl = false;
        List answerConfigurations = new ArrayList();
        for (Intent.Message message : messagesList) {
            Intent.Message.Text text = message.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)text, (String)"message.text");
            ProtocolStringList protocolStringList = text.getTextList();
            Intrinsics.checkExpressionValueIsNotNull((Object)protocolStringList, (String)"message.text.textList");
            Collection collection = (Collection)protocolStringList;
            boolean bl2 = false;
            if (!(!collection.isEmpty())) continue;
            Intent.Message.Text text2 = message.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)text2, (String)"message.text");
            ProtocolStringList protocolStringList2 = text2.getTextList();
            Intent.Message.Text text3 = message.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)text3, (String)"message.text");
            List alternatives = protocolStringList2.subList(1, text3.getTextList().size());
            I18nKeyProvider i18nKeyProvider = I18nKeyProvider.Companion.simpleKeyProvider(namespace, "answer");
            Intent.Message.Text text4 = message.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)text4, (String)"message.text");
            Object object = text4.getTextList().get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"message.text.textList[0]");
            I18nLabelValue labelKey = I18nKeyProvider.DefaultImpls.i18n$default((I18nKeyProvider)i18nKeyProvider, (CharSequence)((CharSequence)object), null, (int)2, null);
            I18nLabel label = Translator.INSTANCE.create(labelKey, locale, alternatives);
            answerConfigurations.add(new SimpleAnswerConfiguration(CollectionsKt.listOf((Object)new SimpleAnswer(new I18nLabelValue(label), -1L, null))));
        }
        return answerConfigurations;
    }

    private DialogflowIntentImporter() {
    }

    public static final /* synthetic */ String access$getProjectId$p(DialogflowIntentImporter $this) {
        DialogflowIntentImporter dialogflowIntentImporter = $this;
        return projectId;
    }
}

