/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.dialogflow;

import ai.tock.bot.definition.BotDefinition;
import ai.tock.bot.definition.Intent;
import ai.tock.bot.definition.IntentAware;
import ai.tock.bot.engine.BotRepository;
import ai.tock.bot.engine.ConnectorController;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.action.SendSentence;
import ai.tock.bot.engine.dialog.Dialog;
import ai.tock.bot.engine.dialog.EntityStateValue;
import ai.tock.bot.engine.dialog.EntityValue;
import ai.tock.bot.engine.dialog.Story;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.nlp.NlpCallStats;
import ai.tock.bot.engine.nlp.NlpController;
import ai.tock.bot.engine.nlp.NlpListener;
import ai.tock.bot.engine.user.UserTimeline;
import ai.tock.nlp.api.client.NlpClient;
import ai.tock.nlp.api.client.model.NlpEntityValue;
import ai.tock.nlp.api.client.model.NlpIntentQualifier;
import ai.tock.nlp.api.client.model.NlpQuery;
import ai.tock.nlp.api.client.model.NlpQueryContext;
import ai.tock.nlp.api.client.model.NlpQueryState;
import ai.tock.nlp.api.client.model.NlpResult;
import ai.tock.nlp.api.client.model.dump.ApplicationDump;
import ai.tock.nlp.api.client.model.dump.IntentDefinition;
import ai.tock.nlp.api.client.model.dump.SentencesDump;
import ai.tock.nlp.api.client.model.monitoring.MarkAsUnknownQuery;
import ai.tock.nlp.dialogflow.DialogflowNlp;
import ai.tock.shared.DatesKt;
import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.StringsKt;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import java.io.InputStream;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u0000 +2\u00020\u0001:\u0002+,B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J0\u0010#\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006-"}, d2={"Lai/tock/nlp/dialogflow/DialogflowNlp;", "Lai/tock/bot/engine/nlp/NlpController;", "()V", "executor", "Lai/tock/shared/Executor;", "getExecutor", "()Lai/tock/shared/Executor;", "nlpClient", "Lai/tock/nlp/api/client/NlpClient;", "getNlpClient", "()Lai/tock/nlp/api/client/NlpClient;", "getIntentsByNamespaceAndName", "", "Lai/tock/nlp/api/client/model/dump/IntentDefinition;", "namespace", "", "name", "importNlpDump", "", "stream", "Ljava/io/InputStream;", "importNlpPlainDump", "dump", "Lai/tock/nlp/api/client/model/dump/ApplicationDump;", "importNlpPlainSentencesDump", "Lai/tock/nlp/api/client/model/dump/SentencesDump;", "importNlpSentencesDump", "markAsUnknown", "", "sentence", "Lai/tock/bot/engine/action/SendSentence;", "userTimeline", "Lai/tock/bot/engine/user/UserTimeline;", "botDefinition", "Lai/tock/bot/definition/BotDefinition;", "parseSentence", "dialog", "Lai/tock/bot/engine/dialog/Dialog;", "connector", "Lai/tock/bot/engine/ConnectorController;", "waitAvailability", "timeToWaitInMs", "", "Companion", "SentenceParser", "tock-nlp-dialogflow"})
public final class DialogflowNlp
implements NlpController {
    private static final KLogger logger;
    @NotNull
    public static final Companion Companion;

    private final NlpClient getNlpClient() {
        KodeinInjector $this$provide$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        TypeToken typeToken = (TypeToken)new TypeReference<NlpClient>(){};
        return (NlpClient)((Function0)kodeinInjector.Provider(typeToken, tag$iv).getValue()).invoke();
    }

    private final Executor getExecutor() {
        KodeinInjector $this$provide$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        TypeToken typeToken = (TypeToken)new TypeReference<Executor>(){};
        return (Executor)((Function0)kodeinInjector.Provider(typeToken, tag$iv).getValue()).invoke();
    }

    public void parseSentence(@NotNull SendSentence sentence, @NotNull UserTimeline userTimeline, @NotNull Dialog dialog, @NotNull ConnectorController connector, @NotNull BotDefinition botDefinition) {
        Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
        Intrinsics.checkNotNullParameter((Object)userTimeline, (String)"userTimeline");
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
        new SentenceParser(this.getNlpClient(), sentence, userTimeline, dialog, connector, botDefinition).parse();
    }

    public void markAsUnknown(@NotNull SendSentence sentence, @NotNull UserTimeline userTimeline, @NotNull BotDefinition botDefinition) {
        Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
        Intrinsics.checkNotNullParameter((Object)userTimeline, (String)"userTimeline");
        Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
        if (sentence.getStringText() != null) {
            this.getExecutor().executeBlocking((Function0)new Function0<Unit>(this, botDefinition, userTimeline, sentence){
                final /* synthetic */ DialogflowNlp this$0;
                final /* synthetic */ BotDefinition $botDefinition;
                final /* synthetic */ UserTimeline $userTimeline;
                final /* synthetic */ SendSentence $sentence;

                public final void invoke() {
                    NlpClient nlpClient = DialogflowNlp.access$getNlpClient$p(this.this$0);
                    String string = this.$botDefinition.getNamespace();
                    String string2 = this.$botDefinition.getNlpModelName();
                    Locale locale = this.$userTimeline.getUserPreferences().getLocale();
                    String string3 = this.$sentence.getStringText();
                    Intrinsics.checkNotNull((Object)string3);
                    nlpClient.markAsUnknown(new MarkAsUnknownQuery(string, string2, locale, string3));
                }
                {
                    this.this$0 = dialogflowNlp;
                    this.$botDefinition = botDefinition;
                    this.$userTimeline = userTimeline;
                    this.$sentence = sendSentence;
                    super(0);
                }
            });
        }
    }

    @Nullable
    public List<IntentDefinition> getIntentsByNamespaceAndName(@NotNull String namespace, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List list = this.getNlpClient().getIntentsByNamespaceAndName(namespace, name);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public boolean importNlpDump(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        return this.getNlpClient().importNlpDump(stream);
    }

    public boolean importNlpPlainDump(@NotNull ApplicationDump dump) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        return this.getNlpClient().importNlpPlainDump(dump);
    }

    public boolean importNlpPlainSentencesDump(@NotNull SentencesDump dump) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        return this.getNlpClient().importNlpPlainSentencesDump(dump);
    }

    public boolean importNlpSentencesDump(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        return this.getNlpClient().importNlpSentencesDump(stream);
    }

    public void waitAvailability(long timeToWaitInMs) {
        long s = System.currentTimeMillis();
        while (!this.getNlpClient().healthcheck() && System.currentTimeMillis() - s < timeToWaitInMs) {
        }
    }

    static {
        Companion = new Companion(null);
        logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
    }

    public static final /* synthetic */ NlpClient access$getNlpClient$p(DialogflowNlp $this) {
        return $this.getNlpClient();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0004\u001a\u0004\u0018\u00010 H\u0002J\"\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\b\u001a\u00020\t2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0018\u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u00020\u001eH\u0002J\u0006\u0010)\u001a\u00020\"J\u0012\u0010)\u001a\u0004\u0018\u00010\u001e2\u0006\u0010*\u001a\u00020$H\u0002J\b\u0010+\u001a\u00020$H\u0002J\b\u0010,\u001a\u00020-H\u0002R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006."}, d2={"Lai/tock/nlp/dialogflow/DialogflowNlp$SentenceParser;", "", "nlpClient", "Lai/tock/nlp/api/client/NlpClient;", "sentence", "Lai/tock/bot/engine/action/SendSentence;", "userTimeline", "Lai/tock/bot/engine/user/UserTimeline;", "dialog", "Lai/tock/bot/engine/dialog/Dialog;", "connector", "Lai/tock/bot/engine/ConnectorController;", "botDefinition", "Lai/tock/bot/definition/BotDefinition;", "(Lai/tock/nlp/api/client/NlpClient;Lai/tock/bot/engine/action/SendSentence;Lai/tock/bot/engine/user/UserTimeline;Lai/tock/bot/engine/dialog/Dialog;Lai/tock/bot/engine/ConnectorController;Lai/tock/bot/definition/BotDefinition;)V", "getBotDefinition", "()Lai/tock/bot/definition/BotDefinition;", "getConnector", "()Lai/tock/bot/engine/ConnectorController;", "getDialog", "()Lai/tock/bot/engine/dialog/Dialog;", "getNlpClient", "()Lai/tock/nlp/api/client/NlpClient;", "getSentence", "()Lai/tock/bot/engine/action/SendSentence;", "getUserTimeline", "()Lai/tock/bot/engine/user/UserTimeline;", "findIntent", "Lai/tock/bot/definition/Intent;", "nlpResult", "Lai/tock/nlp/api/client/model/NlpResult;", "findKeyword", "", "listenNlpErrorCall", "", "query", "Lai/tock/nlp/api/client/model/NlpQuery;", "throwable", "", "listenNlpSuccessCall", "result", "parse", "request", "toNlpQuery", "toQueryContext", "Lai/tock/nlp/api/client/model/NlpQueryContext;", "tock-nlp-dialogflow"})
    private static final class SentenceParser {
        @NotNull
        private final NlpClient nlpClient;
        @NotNull
        private final SendSentence sentence;
        @NotNull
        private final UserTimeline userTimeline;
        @NotNull
        private final Dialog dialog;
        @NotNull
        private final ConnectorController connector;
        @NotNull
        private final BotDefinition botDefinition;

        /*
         * WARNING - void declaration
         */
        public final void parse() {
            logger.debug((Function0)new Function0<Object>(this){
                final /* synthetic */ SentenceParser this$0;

                @Nullable
                public final Object invoke() {
                    return "Parse sentence : " + this.this$0.getSentence();
                }
                {
                    this.this$0 = sentenceParser;
                    super(0);
                }
            });
            Intent intent = this.findKeyword(this.sentence.getStringText());
            if (intent != null) {
                Intent intent2 = intent;
                boolean bl = false;
                boolean bl2 = false;
                Intent $this$apply = intent2;
                boolean bl3 = false;
                this.dialog.getState().setCurrentIntent($this$apply);
                return;
            }
            NlpQuery nlpQuery = this.toNlpQuery();
            boolean bl = false;
            boolean bl4 = false;
            NlpQuery query = nlpQuery;
            boolean bl5 = false;
            try {
                NlpResult nlpResult;
                block10: {
                    block9: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Object object;
                        NlpResult result2;
                        NlpResult nlpResult2 = this.sentence.getPrecomputedNlp();
                        if (nlpResult2 == null) {
                            nlpResult2 = this.parse(query);
                        }
                        if ((nlpResult = (result2 = nlpResult2)) == null) break block9;
                        NlpResult nlpResult3 = nlpResult;
                        boolean bl6 = false;
                        boolean bl7 = false;
                        NlpResult nlpResult4 = nlpResult3;
                        boolean bl8 = false;
                        this.listenNlpSuccessCall(query, nlpResult4);
                        Intent intent3 = this.findIntent(this.userTimeline, this.dialog, this.sentence, nlpResult4);
                        boolean bl9 = false;
                        List customEntityEvaluations = new ArrayList();
                        BotRepository.INSTANCE.forEachNlpListener((Function1)new Function1<NlpListener, Unit>(customEntityEvaluations, nlpResult4, query, this){
                            final /* synthetic */ List $customEntityEvaluations;
                            final /* synthetic */ NlpResult $nlpResult;
                            final /* synthetic */ NlpQuery $query$inlined;
                            final /* synthetic */ SentenceParser this$0;
                            {
                                this.$customEntityEvaluations = list;
                                this.$nlpResult = nlpResult;
                                this.$query$inlined = nlpQuery;
                                this.this$0 = sentenceParser;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull NlpListener it) {
                                List list;
                                List list2;
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                List list3 = this.$customEntityEvaluations;
                                try {
                                    list2 = list3;
                                    list = it.evaluateEntities(this.this$0.getUserTimeline(), this.this$0.getDialog(), (Event)this.this$0.getSentence(), this.$nlpResult);
                                }
                                catch (Exception exception) {
                                    void e;
                                    list2 = list3;
                                    LoggersKt.error((KLogger)DialogflowNlp.access$getLogger$cp(), (Throwable)((Throwable)e));
                                    list = CollectionsKt.emptyList();
                                }
                                list2.addAll(list);
                            }
                        });
                        List entityEvaluations2 = CollectionsKt.plus((Collection)customEntityEvaluations, (Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)nlpResult4.getEntities()), (Function1)((Function1)new Function1<NlpEntityValue, Boolean>(customEntityEvaluations){
                            final /* synthetic */ List $customEntityEvaluations;

                            public final boolean invoke(@NotNull NlpEntityValue e) {
                                boolean bl;
                                block3: {
                                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                    Iterable $this$none$iv = this.$customEntityEvaluations;
                                    boolean $i$f$none = false;
                                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                        bl = true;
                                    } else {
                                        for (T element$iv : $this$none$iv) {
                                            EntityValue it = (EntityValue)element$iv;
                                            boolean bl2 = false;
                                            if (!Intrinsics.areEqual((Object)it.getEntity(), (Object)e.getEntity())) continue;
                                            bl = false;
                                            break block3;
                                        }
                                        bl = true;
                                    }
                                }
                                return bl;
                            }
                            {
                                this.$customEntityEvaluations = list;
                                super(1);
                            }
                        })), (Function1)((Function1)new Function1<NlpEntityValue, EntityValue>(nlpResult4){
                            final /* synthetic */ NlpResult $nlpResult;

                            @NotNull
                            public final EntityValue invoke(@NotNull NlpEntityValue it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return new EntityValue(this.$nlpResult, it);
                            }
                            {
                                this.$nlpResult = nlpResult;
                                super(1);
                            }
                        })));
                        this.sentence.getState().getEntityValues().addAll(entityEvaluations2);
                        Dialog dialog = this.dialog;
                        boolean bl10 = false;
                        boolean bl11 = false;
                        Dialog $this$apply = dialog;
                        boolean bl12 = false;
                        $this$apply.getState().setCurrentIntent(intent3);
                        String string = nlpResult4.getStaticResponse();
                        if (string != null) {
                            object = string;
                            boolean bl13 = false;
                            boolean bl14 = false;
                            Object it = object;
                            boolean bl15 = false;
                            $this$apply.getState().setContextValue("message", (Object)nlpResult4.getStaticResponse());
                        }
                        object = entityEvaluations2;
                        boolean $i$f$map = false;
                        void var22_31 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            EntityValue entityValue = (EntityValue)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl16 = false;
                            $this$apply.getState().getEntityValues().put(it.getEntity().getRole(), new EntityStateValue((Action)this.sentence, (EntityValue)it));
                            Unit unit = Unit.INSTANCE;
                            collection.add(unit);
                        }
                        List cfr_ignored_0 = (List)destination$iv$iv;
                        this.sentence.setNlpStats(new NlpCallStats(this.userTimeline.getUserPreferences().getLocale(), intent3, entityEvaluations2, entityEvaluations2, query, nlpResult4));
                        nlpResult = dialog;
                        if (nlpResult != null) break block10;
                    }
                    this.listenNlpErrorCall(query, this.dialog, null);
                    nlpResult = Unit.INSTANCE;
                }
                NlpResult nlpResult5 = nlpResult;
            }
            catch (Throwable t) {
                LoggersKt.error((KLogger)logger, (Throwable)t);
                this.listenNlpErrorCall(query, this.dialog, t);
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Intent findIntent(UserTimeline userTimeline, Dialog dialog, SendSentence sentence, NlpResult nlpResult) {
            void i;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            BotRepository.INSTANCE.forEachNlpListener((Function1)new Function1<NlpListener, Unit>((Ref.ObjectRef)i, userTimeline, dialog, sentence, nlpResult){
                final /* synthetic */ Ref.ObjectRef $i;
                final /* synthetic */ UserTimeline $userTimeline;
                final /* synthetic */ Dialog $dialog;
                final /* synthetic */ SendSentence $sentence;
                final /* synthetic */ NlpResult $nlpResult;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull NlpListener it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if ((Intent)this.$i.element == null) {
                        Intent intent;
                        Ref.ObjectRef objectRef;
                        Ref.ObjectRef objectRef2 = this.$i;
                        try {
                            objectRef = objectRef2;
                            IntentAware intentAware = it.findIntent(this.$userTimeline, this.$dialog, (Event)this.$sentence, this.$nlpResult);
                            intent = intentAware != null ? intentAware.wrappedIntent() : null;
                        }
                        catch (Exception exception) {
                            void e;
                            objectRef = objectRef2;
                            LoggersKt.error((KLogger)DialogflowNlp.access$getLogger$cp(), (Throwable)((Throwable)e));
                            intent = null;
                        }
                        objectRef.element = intent;
                    }
                }
                {
                    this.$i = objectRef;
                    this.$userTimeline = userTimeline;
                    this.$dialog = dialog;
                    this.$sentence = sendSentence;
                    this.$nlpResult = nlpResult;
                    super(1);
                }
            });
            Intent intent = (Intent)i.element;
            if (intent == null) {
                intent = this.botDefinition.findIntent(nlpResult.getIntent(), sentence.getApplicationId());
            }
            return intent;
        }

        /*
         * WARNING - void declaration
         */
        private final Intent findKeyword(String sentence) {
            Intent intent;
            if (sentence != null) {
                void i;
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                BotRepository.INSTANCE.forEachNlpListener((Function1)new Function1<NlpListener, Unit>((Ref.ObjectRef)i, sentence){
                    final /* synthetic */ Ref.ObjectRef $i;
                    final /* synthetic */ String $sentence;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull NlpListener it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if ((Intent)this.$i.element == null) {
                            Intent intent;
                            Ref.ObjectRef objectRef;
                            Ref.ObjectRef objectRef2 = this.$i;
                            try {
                                objectRef = objectRef2;
                                intent = it.handleKeyword(this.$sentence);
                            }
                            catch (Exception exception) {
                                void e;
                                objectRef = objectRef2;
                                LoggersKt.error((KLogger)DialogflowNlp.access$getLogger$cp(), (Throwable)((Throwable)e));
                                intent = null;
                            }
                            objectRef.element = intent;
                        }
                    }
                    {
                        this.$i = objectRef;
                        this.$sentence = string;
                        super(1);
                    }
                });
                intent = (Intent)i.element;
            } else {
                intent = null;
            }
            return intent;
        }

        private final void listenNlpSuccessCall(NlpQuery query, NlpResult result2) {
            BotRepository.INSTANCE.forEachNlpListener((Function1)new Function1<NlpListener, Unit>(query, result2){
                final /* synthetic */ NlpQuery $query;
                final /* synthetic */ NlpResult $result;

                public final void invoke(@NotNull NlpListener it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    try {
                        it.success(this.$query, this.$result);
                    }
                    catch (Exception e) {
                        LoggersKt.error((KLogger)DialogflowNlp.access$getLogger$cp(), (Throwable)e);
                    }
                }
                {
                    this.$query = nlpQuery;
                    this.$result = nlpResult;
                    super(1);
                }
            });
        }

        private final void listenNlpErrorCall(NlpQuery query, Dialog dialog, Throwable throwable) {
            BotRepository.INSTANCE.forEachNlpListener((Function1)new Function1<NlpListener, Unit>(query, dialog, throwable){
                final /* synthetic */ NlpQuery $query;
                final /* synthetic */ Dialog $dialog;
                final /* synthetic */ Throwable $throwable;

                public final void invoke(@NotNull NlpListener it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    try {
                        it.error(this.$query, this.$dialog, this.$throwable);
                    }
                    catch (Exception e) {
                        LoggersKt.error((KLogger)DialogflowNlp.access$getLogger$cp(), (Throwable)e);
                    }
                }
                {
                    this.$query = nlpQuery;
                    this.$dialog = dialog;
                    this.$throwable = throwable;
                    super(1);
                }
            });
        }

        private final NlpQueryContext toQueryContext() {
            boolean test = this.userTimeline.getUserPreferences().getTest();
            Locale locale = this.userTimeline.getUserPreferences().getLocale();
            String string = this.sentence.getPlayerId().getId();
            String string2 = this.dialog.getId().toString();
            String string3 = this.connector.getConnectorType().toString();
            Object object = this.dialog.getState().getNextActionState();
            if (object == null || (object = object.getReferenceDate()) == null) {
                object = ZonedDateTime.now(DatesKt.getDefaultZoneId());
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dialog.state.nextActionS\u2026teTime.now(defaultZoneId)");
            Object object2 = this.dialog.getState().getNextActionState();
            if (object2 == null || (object2 = object2.getReferenceTimezone()) == null) {
                object2 = DatesKt.getDefaultZoneId();
            }
            return new NlpQueryContext(locale, string, string2, string3, (ZonedDateTime)object, (ZoneId)object2, test, !test && !this.userTimeline.getUserState().getBotDisabled());
        }

        private final NlpQuery toNlpQuery() {
            String string = this.sentence.getStringText();
            if (string == null) {
                string = "";
            }
            List list = CollectionsKt.listOf((Object)string);
            String string2 = this.botDefinition.getNamespace();
            String string3 = this.botDefinition.getNlpModelName();
            NlpQueryContext nlpQueryContext = this.toQueryContext();
            Object object = this.dialog.getState().getNextActionState();
            if (object == null || (object = object.getStates()) == null) {
                Story story = this.dialog.getCurrentStory();
                object = CollectionsKt.toSet((Iterable)CollectionsKt.listOfNotNull(story != null && (story = story.getDefinition()) != null && (story = story.mainIntent()) != null ? story.getName() : null));
            }
            return new NlpQuery(list, string2, string3, nlpQueryContext, new NlpQueryState((Set)object), null, 32, null);
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private final NlpResult parse(NlpQuery request) {
            DialogflowNlp.access$getLogger$cp().debug((Function0)new Function0<Object>(this){
                final /* synthetic */ SentenceParser this$0;

                @Nullable
                public final Object invoke() {
                    return "Sending sentence '" + this.this$0.getSentence().getStringText() + "' to NLP";
                }
                {
                    this.this$0 = sentenceParser;
                    super(0);
                }
            });
            v0 = this.dialog.getState().getNextActionState();
            v1 = intentsQualifiers = v0 != null ? v0.getIntentsQualifiers() : null;
            if (intentsQualifiers == null) ** GOTO lbl-1000
            var4_3 = intentsQualifiers;
            var5_4 = false;
            if (var4_3.isEmpty() == false) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = useQualifiers = false;
            }
            if (!useQualifiers) {
                v3 = this.nlpClient.parse(request);
            } else {
                v4 = intentsQualifiers;
                Intrinsics.checkNotNull((Object)v4);
                v3 = result = this.nlpClient.parse(NlpQuery.copy$default((NlpQuery)request, null, null, null, null, null, (Set)SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)v4), (Function1)((Function1)new Function1<NlpIntentQualifier, NlpIntentQualifier>(request){
                    final /* synthetic */ NlpQuery $request;

                    @NotNull
                    public final NlpIntentQualifier invoke(@NotNull NlpIntentQualifier it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return NlpIntentQualifier.copy$default((NlpIntentQualifier)it, (String)StringsKt.withNamespace((String)it.getIntent(), (String)this.$request.getNamespace()), (double)0.0, (int)2, null);
                    }
                    {
                        this.$request = nlpQuery;
                        super(1);
                    }
                }))), (int)31, null));
            }
            if (result != null && useQualifiers) {
                block15: {
                    v5 = intentsQualifiers;
                    Intrinsics.checkNotNull((Object)v5);
                    $this$none$iv = v5;
                    $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        v6 = true;
                    } else {
                        for (T element$iv : $this$none$iv) {
                            it = (NlpIntentQualifier)element$iv;
                            $i$a$-none-DialogflowNlp$SentenceParser$parse$5 = false;
                            if (!Intrinsics.areEqual((Object)it.getIntent(), (Object)result.getIntent())) continue;
                            v6 = false;
                            break block15;
                        }
                        v6 = true;
                    }
                }
                if (v6) {
                    $this$none$iv = intentsQualifiers;
                    var15_16 = result;
                    $i$f$maxByOrNull = false;
                    iterator$iv = $this$maxByOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v7 = null;
                    } else {
                        maxElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            v7 = maxElem$iv;
                        } else {
                            it = (NlpIntentQualifier)maxElem$iv;
                            $i$a$-maxByOrNull-DialogflowNlp$SentenceParser$parse$6 = false;
                            maxValue$iv = it.getModifier();
                            do {
                                e$iv = iterator$iv.next();
                                it = (NlpIntentQualifier)e$iv;
                                $i$a$-maxByOrNull-DialogflowNlp$SentenceParser$parse$6 = false;
                                v$iv = it.getModifier();
                                if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                                maxElem$iv = e$iv;
                                maxValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            v7 = var16_20 = maxElem$iv;
                        }
                    }
                    if ((v8 /* !! */  = (NlpIntentQualifier)var16_20) == null || (v8 /* !! */  = v8 /* !! */ .getIntent()) == null) {
                        v8 /* !! */  = ((NlpIntentQualifier)CollectionsKt.first((List)intentsQualifiers)).getIntent();
                    }
                    var5_5 = NlpResult.copy$default((NlpResult)var15_16, (String)v8 /* !! */ , null, null, null, null, (double)0.0, (double)0.0, null, null, null, (int)1022, null);
                    var6_7 = false;
                    var7_9 = false;
                    it = var5_5;
                    $i$a$-also-DialogflowNlp$SentenceParser$parse$7 = false;
                    DialogflowNlp.access$getLogger$cp().warn((Function0)new Function0<Object>(it, result, (List)intentsQualifiers){
                        final /* synthetic */ NlpResult $it;
                        final /* synthetic */ NlpResult $result$inlined;
                        final /* synthetic */ List $intentsQualifiers$inlined;
                        {
                            this.$it = nlpResult;
                            this.$result$inlined = nlpResult2;
                            this.$intentsQualifiers$inlined = list;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return this.$result$inlined.getIntent() + " not in intents qualifier " + this.$intentsQualifiers$inlined + " - use " + this.$it;
                        }
                    });
                    return var5_5;
                }
            }
            return result;
        }

        @NotNull
        public final NlpClient getNlpClient() {
            return this.nlpClient;
        }

        @NotNull
        public final SendSentence getSentence() {
            return this.sentence;
        }

        @NotNull
        public final UserTimeline getUserTimeline() {
            return this.userTimeline;
        }

        @NotNull
        public final Dialog getDialog() {
            return this.dialog;
        }

        @NotNull
        public final ConnectorController getConnector() {
            return this.connector;
        }

        @NotNull
        public final BotDefinition getBotDefinition() {
            return this.botDefinition;
        }

        public SentenceParser(@NotNull NlpClient nlpClient, @NotNull SendSentence sentence, @NotNull UserTimeline userTimeline, @NotNull Dialog dialog, @NotNull ConnectorController connector, @NotNull BotDefinition botDefinition) {
            Intrinsics.checkNotNullParameter((Object)nlpClient, (String)"nlpClient");
            Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
            Intrinsics.checkNotNullParameter((Object)userTimeline, (String)"userTimeline");
            Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
            Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
            Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
            this.nlpClient = nlpClient;
            this.sentence = sentence;
            this.userTimeline = userTimeline;
            this.dialog = dialog;
            this.connector = connector;
            this.botDefinition = botDefinition;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/tock/nlp/dialogflow/DialogflowNlp$Companion;", "", "()V", "logger", "Lmu/KLogger;", "tock-nlp-dialogflow"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

