/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.dialogflow;

import ai.tock.nlp.dialogflow.DialogflowService;
import ai.tock.shared.IOCsKt;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import com.google.api.gax.core.CredentialsProvider;
import com.google.cloud.dialogflow.v2.Agent;
import com.google.cloud.dialogflow.v2.AgentsClient;
import com.google.cloud.dialogflow.v2.AgentsSettings;
import com.google.cloud.dialogflow.v2.DetectIntentResponse;
import com.google.cloud.dialogflow.v2.Intent;
import com.google.cloud.dialogflow.v2.IntentView;
import com.google.cloud.dialogflow.v2.IntentsClient;
import com.google.cloud.dialogflow.v2.IntentsSettings;
import com.google.cloud.dialogflow.v2.ListIntentsRequest;
import com.google.cloud.dialogflow.v2.ProjectAgentName;
import com.google.cloud.dialogflow.v2.ProjectName;
import com.google.cloud.dialogflow.v2.QueryInput;
import com.google.cloud.dialogflow.v2.QueryResult;
import com.google.cloud.dialogflow.v2.SessionName;
import com.google.cloud.dialogflow.v2.SessionsClient;
import com.google.cloud.dialogflow.v2.SessionsSettings;
import com.google.cloud.dialogflow.v2.TextInput;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u0007*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0007*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lai/tock/nlp/dialogflow/DialogflowService;", "", "()V", "DIALOGFLOW_MAX_TEXT_LENGTH", "", "agentsSettings", "Lcom/google/cloud/dialogflow/v2/AgentsSettings;", "kotlin.jvm.PlatformType", "credentialsProvider", "Lcom/google/api/gax/core/CredentialsProvider;", "getCredentialsProvider", "()Lcom/google/api/gax/core/CredentialsProvider;", "intentsSettings", "Lcom/google/cloud/dialogflow/v2/IntentsSettings;", "logger", "Lmu/KLogger;", "sessionsSettings", "Lcom/google/cloud/dialogflow/v2/SessionsSettings;", "detectIntentText", "Lcom/google/cloud/dialogflow/v2/QueryResult;", "projectId", "", "text", "sessionId", "languageCode", "getAgent", "Lcom/google/cloud/dialogflow/v2/Agent;", "getIntents", "", "Lcom/google/cloud/dialogflow/v2/Intent;", "tock-nlp-dialogflow"})
public final class DialogflowService {
    private static final int DIALOGFLOW_MAX_TEXT_LENGTH = 256;
    private static final KLogger logger;
    private static final SessionsSettings sessionsSettings;
    private static final AgentsSettings agentsSettings;
    private static final IntentsSettings intentsSettings;
    @NotNull
    public static final DialogflowService INSTANCE;

    private final CredentialsProvider getCredentialsProvider() {
        KodeinInjector $this$provide$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        TypeToken typeToken = (TypeToken)new TypeReference<CredentialsProvider>(){};
        return (CredentialsProvider)((Function0)kodeinInjector.Provider(typeToken, tag$iv).getValue()).invoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final QueryResult detectIntentText(@NotNull String projectId, @NotNull String text, @NotNull String sessionId, @NotNull String languageCode) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)languageCode, (String)"languageCode");
        AutoCloseable autoCloseable = (AutoCloseable)SessionsClient.create((SessionsSettings)sessionsSettings);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            String string;
            int n;
            int n2;
            String string2;
            SessionsClient it = (SessionsClient)autoCloseable;
            boolean bl3 = false;
            SessionName session = SessionName.of((String)projectId, (String)sessionId);
            logger.debug("Session Path: " + session);
            if (text.length() > 256) {
                string2 = text;
                n2 = 0;
                n = 256;
                boolean bl4 = false;
                String string3 = string2.substring(n2, n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string2 = string3;
                n2 = 0;
                n = 0;
                String it2 = string2;
                boolean bl5 = false;
                logger.warn((Function0)new Function0<Object>(projectId, sessionId, text, languageCode){
                    final /* synthetic */ String $projectId$inlined;
                    final /* synthetic */ String $sessionId$inlined;
                    final /* synthetic */ String $text$inlined;
                    final /* synthetic */ String $languageCode$inlined;
                    {
                        this.$projectId$inlined = string;
                        this.$sessionId$inlined = string2;
                        this.$text$inlined = string3;
                        this.$languageCode$inlined = string4;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Text sent to Dialogflow too long : More than " + this.$text$inlined.length() + " characters. Truncated to 256 characters.";
                    }
                });
                string = string2;
            } else {
                string = text;
            }
            String dialogflowText = string;
            string2 = TextInput.newBuilder().setText(dialogflowText).setLanguageCode(languageCode);
            n2 = 0;
            n = 0;
            String $this$apply = string2;
            boolean bl6 = false;
            QueryInput queryInput = QueryInput.newBuilder().setText((TextInput.Builder)$this$apply).build();
            boolean bl7 = false;
            boolean bl8 = false;
            QueryInput $this$apply2 = queryInput;
            boolean bl9 = false;
            DetectIntentResponse detectIntentResponse = it.detectIntent(session, $this$apply2);
            boolean bl10 = false;
            boolean bl11 = false;
            DetectIntentResponse $this$apply3 = detectIntentResponse;
            boolean bl12 = false;
            DetectIntentResponse detectIntentResponse2 = $this$apply3;
            Intrinsics.checkNotNullExpressionValue((Object)detectIntentResponse2, (String)"this");
            QueryResult queryResult = detectIntentResponse2.getQueryResult();
            boolean bl13 = false;
            boolean bl14 = false;
            QueryResult it3 = queryResult;
            boolean bl15 = false;
            logger.debug((Function0)new Function0<Object>(it3){
                final /* synthetic */ QueryResult $it;

                @Nullable
                public final Object invoke() {
                    StringBuilder stringBuilder = new StringBuilder().append("Query Text: '");
                    QueryResult queryResult = this.$it;
                    Intrinsics.checkNotNullExpressionValue((Object)queryResult, (String)"it");
                    return stringBuilder.append(queryResult.getQueryText()).append('\'').toString();
                }
                {
                    this.$it = queryResult;
                    super(0);
                }
            });
            logger.debug((Function0)new Function0<Object>(it3){
                final /* synthetic */ QueryResult $it;

                @Nullable
                public final Object invoke() {
                    StringBuilder stringBuilder = new StringBuilder().append("Detected Intent: ");
                    QueryResult queryResult = this.$it;
                    Intrinsics.checkNotNullExpressionValue((Object)queryResult, (String)"it");
                    Intent intent = queryResult.getIntent();
                    Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"it.intent");
                    StringBuilder stringBuilder2 = stringBuilder.append(intent.getDisplayName()).append(" (confidence: ");
                    QueryResult queryResult2 = this.$it;
                    Intrinsics.checkNotNullExpressionValue((Object)queryResult2, (String)"it");
                    return stringBuilder2.append(queryResult2.getIntentDetectionConfidence()).append(')').toString();
                }
                {
                    this.$it = queryResult;
                    super(0);
                }
            });
            QueryResult queryResult2 = queryResult;
            return queryResult2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Agent getAgent(@NotNull String projectId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        AutoCloseable autoCloseable = (AutoCloseable)AgentsClient.create((AgentsSettings)agentsSettings);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            AgentsClient it = (AgentsClient)autoCloseable;
            boolean bl3 = false;
            ProjectName projectName = ProjectName.of((String)projectId);
            Intrinsics.checkNotNullExpressionValue((Object)projectName, (String)"ProjectName.of(projectId)");
            ProjectName parent = projectName;
            Agent agent = it.getAgent(parent);
            return agent;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Intent> getIntents(@NotNull String projectId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        AutoCloseable autoCloseable = (AutoCloseable)IntentsClient.create((IntentsSettings)intentsSettings);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            IntentsClient it = (IntentsClient)autoCloseable;
            boolean bl3 = false;
            ProjectAgentName parent = ProjectAgentName.of((String)projectId);
            ListIntentsRequest request = ListIntentsRequest.newBuilder().setIntentView(IntentView.INTENT_VIEW_FULL).setParent(parent.toString()).build();
            Iterable iterable = it.listIntents(request).iterateAll();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"it.listIntents(request).iterateAll()");
            List list = SequencesKt.toList((Sequence)CollectionsKt.asSequence((Iterable)iterable));
            return list;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private DialogflowService() {
    }

    static {
        DialogflowService dialogflowService;
        INSTANCE = dialogflowService = new DialogflowService();
        logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        sessionsSettings = ((SessionsSettings.Builder)SessionsSettings.newBuilder().setCredentialsProvider(dialogflowService.getCredentialsProvider())).build();
        agentsSettings = ((AgentsSettings.Builder)AgentsSettings.newBuilder().setCredentialsProvider(dialogflowService.getCredentialsProvider())).build();
        intentsSettings = ((IntentsSettings.Builder)IntentsSettings.newBuilder().setCredentialsProvider(dialogflowService.getCredentialsProvider())).build();
    }
}

