/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.dialogflow;

import ai.tock.bot.definition.BotDefinition;
import ai.tock.bot.definition.Intent;
import ai.tock.bot.definition.StoryDefinition;
import ai.tock.bot.engine.BotRepository;
import ai.tock.bot.engine.ConnectorController;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.action.SendSentence;
import ai.tock.bot.engine.dialog.Dialog;
import ai.tock.bot.engine.dialog.EntityStateValue;
import ai.tock.bot.engine.dialog.EntityValue;
import ai.tock.bot.engine.dialog.NextUserActionState;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.nlp.NlpCallStats;
import ai.tock.bot.engine.nlp.NlpController;
import ai.tock.bot.engine.nlp.NlpListener;
import ai.tock.bot.engine.user.UserTimeline;
import ai.tock.nlp.api.client.NlpClient;
import ai.tock.nlp.api.client.model.NlpEntityValue;
import ai.tock.nlp.api.client.model.NlpIntentQualifier;
import ai.tock.nlp.api.client.model.NlpQuery;
import ai.tock.nlp.api.client.model.NlpQueryContext;
import ai.tock.nlp.api.client.model.NlpQueryState;
import ai.tock.nlp.api.client.model.NlpResult;
import ai.tock.nlp.api.client.model.dump.ApplicationDump;
import ai.tock.nlp.api.client.model.dump.IntentDefinition;
import ai.tock.nlp.api.client.model.dump.SentencesDump;
import ai.tock.nlp.api.client.model.monitoring.MarkAsUnknownQuery;
import ai.tock.nlp.dialogflow.DialogflowNlp;
import ai.tock.shared.DatesKt;
import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.StringsKt;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import java.io.InputStream;
import java.io.Serializable;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u0000 +2\u00020\u0001:\u0002+,B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J0\u0010#\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006-"}, d2={"Lai/tock/nlp/dialogflow/DialogflowNlp;", "Lai/tock/bot/engine/nlp/NlpController;", "()V", "executor", "Lai/tock/shared/Executor;", "getExecutor", "()Lai/tock/shared/Executor;", "nlpClient", "Lai/tock/nlp/api/client/NlpClient;", "getNlpClient", "()Lai/tock/nlp/api/client/NlpClient;", "getIntentsByNamespaceAndName", "", "Lai/tock/nlp/api/client/model/dump/IntentDefinition;", "namespace", "", "name", "importNlpDump", "", "stream", "Ljava/io/InputStream;", "importNlpPlainDump", "dump", "Lai/tock/nlp/api/client/model/dump/ApplicationDump;", "importNlpPlainSentencesDump", "Lai/tock/nlp/api/client/model/dump/SentencesDump;", "importNlpSentencesDump", "markAsUnknown", "", "sentence", "Lai/tock/bot/engine/action/SendSentence;", "userTimeline", "Lai/tock/bot/engine/user/UserTimeline;", "botDefinition", "Lai/tock/bot/definition/BotDefinition;", "parseSentence", "dialog", "Lai/tock/bot/engine/dialog/Dialog;", "connector", "Lai/tock/bot/engine/ConnectorController;", "waitAvailability", "timeToWaitInMs", "", "Companion", "SentenceParser", "tock-nlp-dialogflow"})
public final class DialogflowNlp
implements NlpController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);

    private final NlpClient getNlpClient() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        TypeToken typeToken = (TypeToken)new TypeReference<NlpClient>(){};
        return (NlpClient)((Function0)kodeinInjector.Provider(typeToken, tag$iv).getValue()).invoke();
    }

    private final Executor getExecutor() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        TypeToken typeToken = (TypeToken)new TypeReference<Executor>(){};
        return (Executor)((Function0)kodeinInjector.Provider(typeToken, tag$iv).getValue()).invoke();
    }

    public void parseSentence(@NotNull SendSentence sentence, @NotNull UserTimeline userTimeline, @NotNull Dialog dialog, @NotNull ConnectorController connector, @NotNull BotDefinition botDefinition) {
        Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
        Intrinsics.checkNotNullParameter((Object)userTimeline, (String)"userTimeline");
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
        new SentenceParser(this.getNlpClient(), sentence, userTimeline, dialog, connector, botDefinition).parse();
    }

    public void markAsUnknown(@NotNull SendSentence sentence, @NotNull UserTimeline userTimeline, @NotNull BotDefinition botDefinition) {
        Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
        Intrinsics.checkNotNullParameter((Object)userTimeline, (String)"userTimeline");
        Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
        if (sentence.getStringText() != null) {
            this.getExecutor().executeBlocking((Function0)new Function0<Unit>(this, botDefinition, userTimeline, sentence){
                final /* synthetic */ DialogflowNlp this$0;
                final /* synthetic */ BotDefinition $botDefinition;
                final /* synthetic */ UserTimeline $userTimeline;
                final /* synthetic */ SendSentence $sentence;
                {
                    this.this$0 = $receiver;
                    this.$botDefinition = $botDefinition;
                    this.$userTimeline = $userTimeline;
                    this.$sentence = $sentence;
                    super(0);
                }

                public final void invoke() {
                    NlpClient nlpClient = DialogflowNlp.access$getNlpClient(this.this$0);
                    String string = this.$botDefinition.getNamespace();
                    String string2 = this.$botDefinition.getNlpModelName();
                    Locale locale = this.$userTimeline.getUserPreferences().getLocale();
                    String string3 = this.$sentence.getStringText();
                    Intrinsics.checkNotNull((Object)string3);
                    nlpClient.markAsUnknown(new MarkAsUnknownQuery(string, string2, locale, string3));
                }
            });
        }
    }

    @Nullable
    public List<IntentDefinition> getIntentsByNamespaceAndName(@NotNull String namespace, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List list = this.getNlpClient().getIntentsByNamespaceAndName(namespace, name);
        return list == null ? CollectionsKt.emptyList() : list;
    }

    public boolean importNlpDump(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        return this.getNlpClient().importNlpDump(stream);
    }

    public boolean importNlpPlainDump(@NotNull ApplicationDump dump) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        return this.getNlpClient().importNlpPlainDump(dump);
    }

    public boolean importNlpPlainSentencesDump(@NotNull SentencesDump dump) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        return this.getNlpClient().importNlpPlainSentencesDump(dump);
    }

    public boolean importNlpSentencesDump(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        return this.getNlpClient().importNlpSentencesDump(stream);
    }

    public void waitAvailability(long timeToWaitInMs) {
        long s = System.currentTimeMillis();
        while (!this.getNlpClient().healthcheck() && System.currentTimeMillis() - s < timeToWaitInMs) {
        }
    }

    public static final /* synthetic */ NlpClient access$getNlpClient(DialogflowNlp $this) {
        return $this.getNlpClient();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/tock/nlp/dialogflow/DialogflowNlp$Companion;", "", "()V", "logger", "Lmu/KLogger;", "tock-nlp-dialogflow"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0004\u001a\u0004\u0018\u00010 H\u0002J\"\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\b\u001a\u00020\t2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0018\u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u00020\u001eH\u0002J\u0006\u0010)\u001a\u00020\"J\u0012\u0010)\u001a\u0004\u0018\u00010\u001e2\u0006\u0010*\u001a\u00020$H\u0002J\b\u0010+\u001a\u00020$H\u0002J\b\u0010,\u001a\u00020-H\u0002R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006."}, d2={"Lai/tock/nlp/dialogflow/DialogflowNlp$SentenceParser;", "", "nlpClient", "Lai/tock/nlp/api/client/NlpClient;", "sentence", "Lai/tock/bot/engine/action/SendSentence;", "userTimeline", "Lai/tock/bot/engine/user/UserTimeline;", "dialog", "Lai/tock/bot/engine/dialog/Dialog;", "connector", "Lai/tock/bot/engine/ConnectorController;", "botDefinition", "Lai/tock/bot/definition/BotDefinition;", "(Lai/tock/nlp/api/client/NlpClient;Lai/tock/bot/engine/action/SendSentence;Lai/tock/bot/engine/user/UserTimeline;Lai/tock/bot/engine/dialog/Dialog;Lai/tock/bot/engine/ConnectorController;Lai/tock/bot/definition/BotDefinition;)V", "getBotDefinition", "()Lai/tock/bot/definition/BotDefinition;", "getConnector", "()Lai/tock/bot/engine/ConnectorController;", "getDialog", "()Lai/tock/bot/engine/dialog/Dialog;", "getNlpClient", "()Lai/tock/nlp/api/client/NlpClient;", "getSentence", "()Lai/tock/bot/engine/action/SendSentence;", "getUserTimeline", "()Lai/tock/bot/engine/user/UserTimeline;", "findIntent", "Lai/tock/bot/definition/Intent;", "nlpResult", "Lai/tock/nlp/api/client/model/NlpResult;", "findKeyword", "", "listenNlpErrorCall", "", "query", "Lai/tock/nlp/api/client/model/NlpQuery;", "throwable", "", "listenNlpSuccessCall", "result", "parse", "request", "toNlpQuery", "toQueryContext", "Lai/tock/nlp/api/client/model/NlpQueryContext;", "tock-nlp-dialogflow"})
    private static final class SentenceParser {
        @NotNull
        private final NlpClient nlpClient;
        @NotNull
        private final SendSentence sentence;
        @NotNull
        private final UserTimeline userTimeline;
        @NotNull
        private final Dialog dialog;
        @NotNull
        private final ConnectorController connector;
        @NotNull
        private final BotDefinition botDefinition;

        public SentenceParser(@NotNull NlpClient nlpClient, @NotNull SendSentence sentence, @NotNull UserTimeline userTimeline, @NotNull Dialog dialog, @NotNull ConnectorController connector, @NotNull BotDefinition botDefinition) {
            Intrinsics.checkNotNullParameter((Object)nlpClient, (String)"nlpClient");
            Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
            Intrinsics.checkNotNullParameter((Object)userTimeline, (String)"userTimeline");
            Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
            Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
            Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
            this.nlpClient = nlpClient;
            this.sentence = sentence;
            this.userTimeline = userTimeline;
            this.dialog = dialog;
            this.connector = connector;
            this.botDefinition = botDefinition;
        }

        @NotNull
        public final NlpClient getNlpClient() {
            return this.nlpClient;
        }

        @NotNull
        public final SendSentence getSentence() {
            return this.sentence;
        }

        @NotNull
        public final UserTimeline getUserTimeline() {
            return this.userTimeline;
        }

        @NotNull
        public final Dialog getDialog() {
            return this.dialog;
        }

        @NotNull
        public final ConnectorController getConnector() {
            return this.connector;
        }

        @NotNull
        public final BotDefinition getBotDefinition() {
            return this.botDefinition;
        }

        /*
         * WARNING - void declaration
         */
        public final void parse() {
            logger.debug((Function0)new Function0<Object>(this){
                final /* synthetic */ SentenceParser this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return Intrinsics.stringPlus((String)"Parse sentence : ", (Object)this.this$0.getSentence());
                }
            });
            Intent intent = this.findKeyword(this.sentence.getStringText());
            if (intent != null) {
                Intent intent2 = intent;
                boolean bl = false;
                boolean bl2 = false;
                Intent $this$parse_u24lambda_u2d0 = intent2;
                boolean bl3 = false;
                this.getDialog().getState().setCurrentIntent($this$parse_u24lambda_u2d0);
                return;
            }
            intent = this.toNlpQuery();
            boolean bl = false;
            boolean bl4 = false;
            Intent query = intent;
            boolean bl5 = false;
            try {
                NlpResult nlpResult;
                Dialog dialog;
                NlpResult result2;
                NlpResult bl3 = this.getSentence().getPrecomputedNlp();
                NlpResult nlpResult2 = result2 = bl3 == null ? this.parse((NlpQuery)query) : bl3;
                if (nlpResult2 == null) {
                    dialog = null;
                } else {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    NlpResult nlpResult3 = nlpResult2;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    NlpResult nlpResult4 = nlpResult3;
                    boolean bl8 = false;
                    this.listenNlpSuccessCall((NlpQuery)query, nlpResult4);
                    Intent intent3 = this.findIntent(this.getUserTimeline(), this.getDialog(), this.getSentence(), nlpResult4);
                    boolean bl9 = false;
                    List customEntityEvaluations = new ArrayList();
                    BotRepository.INSTANCE.forEachNlpListener((Function1)new Function1<NlpListener, Unit>((List<EntityValue>)customEntityEvaluations, this, nlpResult4){
                        final /* synthetic */ List<EntityValue> $customEntityEvaluations;
                        final /* synthetic */ SentenceParser this$0;
                        final /* synthetic */ NlpResult $nlpResult;
                        {
                            this.$customEntityEvaluations = $customEntityEvaluations;
                            this.this$0 = $receiver;
                            this.$nlpResult = $nlpResult;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull NlpListener it) {
                            List list;
                            List<EntityValue> list2;
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            List<EntityValue> list3 = this.$customEntityEvaluations;
                            try {
                                list2 = list3;
                                list = it.evaluateEntities(this.this$0.getUserTimeline(), this.this$0.getDialog(), (Event)this.this$0.getSentence(), this.$nlpResult);
                            }
                            catch (Exception exception) {
                                void e;
                                list2 = list3;
                                LoggersKt.error((KLogger)DialogflowNlp.access$getLogger$cp(), (Throwable)((Throwable)e));
                                list = CollectionsKt.emptyList();
                            }
                            list2.addAll(list);
                        }
                    });
                    List entityEvaluations2 = CollectionsKt.plus((Collection)customEntityEvaluations, (Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)nlpResult4.getEntities()), (Function1)((Function1)new Function1<NlpEntityValue, Boolean>((List<EntityValue>)customEntityEvaluations){
                        final /* synthetic */ List<EntityValue> $customEntityEvaluations;
                        {
                            this.$customEntityEvaluations = $customEntityEvaluations;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull NlpEntityValue e) {
                            boolean bl;
                            block3: {
                                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                Iterable $this$none$iv = this.$customEntityEvaluations;
                                boolean $i$f$none = false;
                                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                    bl = true;
                                } else {
                                    for (T element$iv : $this$none$iv) {
                                        EntityValue it = (EntityValue)element$iv;
                                        boolean bl2 = false;
                                        if (!Intrinsics.areEqual((Object)it.getEntity(), (Object)e.getEntity())) continue;
                                        bl = false;
                                        break block3;
                                    }
                                    bl = true;
                                }
                            }
                            return bl;
                        }
                    })), (Function1)((Function1)new Function1<NlpEntityValue, EntityValue>(nlpResult4){
                        final /* synthetic */ NlpResult $nlpResult;
                        {
                            this.$nlpResult = $nlpResult;
                            super(1);
                        }

                        @NotNull
                        public final EntityValue invoke(@NotNull NlpEntityValue it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return new EntityValue(this.$nlpResult, it);
                        }
                    })));
                    this.getSentence().getState().getEntityValues().addAll(entityEvaluations2);
                    Dialog dialog2 = this.getDialog();
                    boolean bl10 = false;
                    boolean bl11 = false;
                    Dialog $this$parse_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d3 = dialog2;
                    boolean bl12 = false;
                    $this$parse_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d3.getState().setCurrentIntent(intent3);
                    Object object = nlpResult4.getStaticResponse();
                    if (object != null) {
                        String string = object;
                        boolean bl13 = false;
                        boolean bl14 = false;
                        String it = string;
                        boolean bl15 = false;
                        $this$parse_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d3.getState().setContextValue("message", (Object)nlpResult4.getStaticResponse());
                    }
                    object = entityEvaluations2;
                    boolean $i$f$map = false;
                    void var24_34 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        EntityValue entityValue = (EntityValue)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl16 = false;
                        Map map = $this$parse_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d3.getState().getEntityValues();
                        String string = it.getEntity().getRole();
                        EntityStateValue entityStateValue = new EntityStateValue((Action)this.getSentence(), (EntityValue)it);
                        boolean bl17 = false;
                        map.put(string, entityStateValue);
                        Unit unit = Unit.INSTANCE;
                        collection.add(unit);
                    }
                    List cfr_ignored_0 = (List)destination$iv$iv;
                    this.getSentence().setNlpStats(new NlpCallStats(this.getUserTimeline().getUserPreferences().getLocale(), intent3, entityEvaluations2, entityEvaluations2, (NlpQuery)query, nlpResult4));
                    dialog = dialog2;
                }
                bl3 = dialog;
                if (bl3 == null) {
                    this.listenNlpErrorCall((NlpQuery)query, this.getDialog(), null);
                    nlpResult = Unit.INSTANCE;
                } else {
                    nlpResult = bl3;
                }
                NlpResult nlpResult5 = nlpResult;
            }
            catch (Throwable t) {
                LoggersKt.error((KLogger)logger, (Throwable)t);
                this.listenNlpErrorCall((NlpQuery)query, this.getDialog(), t);
                Unit unit = Unit.INSTANCE;
            }
        }

        private final Intent findIntent(UserTimeline userTimeline, Dialog dialog, SendSentence sentence, NlpResult nlpResult) {
            Ref.ObjectRef i = new Ref.ObjectRef();
            BotRepository.INSTANCE.forEachNlpListener((Function1)new Function1<NlpListener, Unit>((Ref.ObjectRef<Intent>)i, userTimeline, dialog, sentence, nlpResult){
                final /* synthetic */ Ref.ObjectRef<Intent> $i;
                final /* synthetic */ UserTimeline $userTimeline;
                final /* synthetic */ Dialog $dialog;
                final /* synthetic */ SendSentence $sentence;
                final /* synthetic */ NlpResult $nlpResult;
                {
                    this.$i = $i;
                    this.$userTimeline = $userTimeline;
                    this.$dialog = $dialog;
                    this.$sentence = $sentence;
                    this.$nlpResult = $nlpResult;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull NlpListener it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (this.$i.element == null) {
                        Intent intent;
                        Ref.ObjectRef<Intent> objectRef;
                        Ref.ObjectRef<Intent> objectRef2 = this.$i;
                        try {
                            objectRef = objectRef2;
                            intent = it.findIntent(this.$userTimeline, this.$dialog, (Event)this.$sentence, this.$nlpResult);
                            intent = intent == null ? null : intent.wrappedIntent();
                        }
                        catch (Exception exception) {
                            void e;
                            objectRef = objectRef2;
                            LoggersKt.error((KLogger)DialogflowNlp.access$getLogger$cp(), (Throwable)((Throwable)e));
                            intent = null;
                        }
                        objectRef.element = intent;
                    }
                }
            });
            Intent intent = (Intent)i.element;
            return intent == null ? this.botDefinition.findIntent(nlpResult.getIntent(), sentence.getApplicationId()) : intent;
        }

        private final Intent findKeyword(String sentence) {
            Intent intent;
            if (sentence != null) {
                Ref.ObjectRef i = new Ref.ObjectRef();
                BotRepository.INSTANCE.forEachNlpListener((Function1)new Function1<NlpListener, Unit>((Ref.ObjectRef<Intent>)i, sentence){
                    final /* synthetic */ Ref.ObjectRef<Intent> $i;
                    final /* synthetic */ String $sentence;
                    {
                        this.$i = $i;
                        this.$sentence = $sentence;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull NlpListener it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if (this.$i.element == null) {
                            Intent intent;
                            Ref.ObjectRef<Intent> objectRef;
                            Ref.ObjectRef<Intent> objectRef2 = this.$i;
                            try {
                                objectRef = objectRef2;
                                intent = it.handleKeyword(this.$sentence);
                            }
                            catch (Exception exception) {
                                void e;
                                objectRef = objectRef2;
                                LoggersKt.error((KLogger)DialogflowNlp.access$getLogger$cp(), (Throwable)((Throwable)e));
                                intent = null;
                            }
                            objectRef.element = intent;
                        }
                    }
                });
                intent = (Intent)i.element;
            } else {
                intent = null;
            }
            return intent;
        }

        private final void listenNlpSuccessCall(NlpQuery query, NlpResult result2) {
            BotRepository.INSTANCE.forEachNlpListener((Function1)new Function1<NlpListener, Unit>(query, result2){
                final /* synthetic */ NlpQuery $query;
                final /* synthetic */ NlpResult $result;
                {
                    this.$query = $query;
                    this.$result = $result;
                    super(1);
                }

                public final void invoke(@NotNull NlpListener it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    try {
                        it.success(this.$query, this.$result);
                    }
                    catch (Exception e) {
                        LoggersKt.error((KLogger)DialogflowNlp.access$getLogger$cp(), (Throwable)e);
                    }
                }
            });
        }

        private final void listenNlpErrorCall(NlpQuery query, Dialog dialog, Throwable throwable) {
            BotRepository.INSTANCE.forEachNlpListener((Function1)new Function1<NlpListener, Unit>(query, dialog, throwable){
                final /* synthetic */ NlpQuery $query;
                final /* synthetic */ Dialog $dialog;
                final /* synthetic */ Throwable $throwable;
                {
                    this.$query = $query;
                    this.$dialog = $dialog;
                    this.$throwable = $throwable;
                    super(1);
                }

                public final void invoke(@NotNull NlpListener it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    try {
                        it.error(this.$query, this.$dialog, this.$throwable);
                    }
                    catch (Exception e) {
                        LoggersKt.error((KLogger)DialogflowNlp.access$getLogger$cp(), (Throwable)e);
                    }
                }
            });
        }

        private final NlpQueryContext toQueryContext() {
            boolean test = this.userTimeline.getUserPreferences().getTest();
            Locale locale = this.userTimeline.getUserPreferences().getLocale();
            String string = this.sentence.getPlayerId().getId();
            String string2 = this.dialog.getId().toString();
            String string3 = this.connector.getConnectorType().toString();
            NextUserActionState nextUserActionState = this.dialog.getState().getNextActionState();
            ZonedDateTime zonedDateTime = nextUserActionState == null ? null : nextUserActionState.getReferenceDate();
            Serializable serializable = zonedDateTime == null ? ZonedDateTime.now(DatesKt.getDefaultZoneId()) : zonedDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)serializable, (String)"dialog.state.nextActionS\u2026teTime.now(defaultZoneId)");
            ZonedDateTime zonedDateTime2 = serializable;
            zonedDateTime = this.dialog.getState().getNextActionState();
            serializable = zonedDateTime == null ? null : zonedDateTime.getReferenceTimezone();
            return new NlpQueryContext(locale, string, string2, string3, zonedDateTime2, (ZoneId)(serializable == null ? DatesKt.getDefaultZoneId() : serializable), test, !test && !this.userTimeline.getUserState().getBotDisabled());
        }

        private final NlpQuery toNlpQuery() {
            Intent intent;
            StoryDefinition storyDefinition;
            Object object = this.sentence.getStringText();
            List list = CollectionsKt.listOf((Object)(object == null ? "" : object));
            NextUserActionState nextUserActionState = this.dialog.getState().getNextActionState();
            Object object2 = object = nextUserActionState == null ? null : nextUserActionState.getStates();
            return new NlpQuery(list, this.botDefinition.getNamespace(), this.botDefinition.getNlpModelName(), this.toQueryContext(), new NlpQueryState((Set)(object == null ? CollectionsKt.toSet((Iterable)CollectionsKt.listOfNotNull((nextUserActionState = this.dialog.getCurrentStory()) == null ? null : ((storyDefinition = nextUserActionState.getDefinition()) == null ? null : ((intent = storyDefinition.mainIntent()) == null ? null : intent.getName())))) : object)), null, 32, null);
        }

        /*
         * Unable to fully structure code
         */
        private final NlpResult parse(NlpQuery request) {
            DialogflowNlp.access$getLogger$cp().debug((Function0)new Function0<Object>(this){
                final /* synthetic */ SentenceParser this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Sending sentence '" + this.this$0.getSentence().getStringText() + "' to NLP";
                }
            });
            var3_2 = this.dialog.getState().getNextActionState();
            v0 = intentsQualifiers = var3_2 == null ? null : var3_2.getIntentsQualifiers();
            if (intentsQualifiers == null) ** GOTO lbl-1000
            var4_5 = intentsQualifiers;
            var5_6 = false;
            if (var4_5.isEmpty() == false) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = useQualifiers = false;
            }
            if (!useQualifiers) {
                v2 = this.nlpClient.parse(request);
            } else {
                v3 = intentsQualifiers;
                Intrinsics.checkNotNull((Object)v3);
                v2 = result = this.nlpClient.parse(NlpQuery.copy$default((NlpQuery)request, null, null, null, null, null, (Set)SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)v3), (Function1)((Function1)new Function1<NlpIntentQualifier, NlpIntentQualifier>(request){
                    final /* synthetic */ NlpQuery $request;
                    {
                        this.$request = $request;
                        super(1);
                    }

                    @NotNull
                    public final NlpIntentQualifier invoke(@NotNull NlpIntentQualifier it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return NlpIntentQualifier.copy$default((NlpIntentQualifier)it, (String)StringsKt.withNamespace((String)it.getIntent(), (String)this.$request.getNamespace()), (double)0.0, (int)2, null);
                    }
                }))), (int)31, null));
            }
            if (result != null && useQualifiers) {
                block14: {
                    v4 = intentsQualifiers;
                    Intrinsics.checkNotNull((Object)v4);
                    $this$none$iv = v4;
                    $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        v5 = true;
                    } else {
                        for (T element$iv : $this$none$iv) {
                            it = (NlpIntentQualifier)element$iv;
                            $i$a$-none-DialogflowNlp$SentenceParser$parse$5 = false;
                            if (!Intrinsics.areEqual((Object)it.getIntent(), (Object)result.getIntent())) continue;
                            v5 = false;
                            break block14;
                        }
                        v5 = true;
                    }
                }
                if (v5) {
                    var7_11 = intentsQualifiers;
                    var17_20 = result;
                    $i$f$maxByOrNull = false;
                    iterator$iv = $this$maxByOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v6 = null;
                    } else {
                        maxElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            v6 = maxElem$iv;
                        } else {
                            it = (NlpIntentQualifier)maxElem$iv;
                            $i$a$-maxByOrNull-DialogflowNlp$SentenceParser$parse$6 = false;
                            maxValue$iv = it.getModifier();
                            do {
                                e$iv = iterator$iv.next();
                                it = (NlpIntentQualifier)e$iv;
                                $i$a$-maxByOrNull-DialogflowNlp$SentenceParser$parse$6 = false;
                                v$iv = it.getModifier();
                                if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                                maxElem$iv = e$iv;
                                maxValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            v6 = maxElem$iv;
                        }
                    }
                    var18_28 = v6;
                    var6_9 = var18_28;
                    var5_7 = var6_9 == null ? null : var6_9.getIntent();
                    var5_7 = NlpResult.copy$default((NlpResult)var17_20, (String)(var5_7 == null ? ((NlpIntentQualifier)CollectionsKt.first((List)intentsQualifiers)).getIntent() : var5_7), null, null, null, null, (double)0.0, (double)0.0, null, null, null, (int)1022, null);
                    var6_10 = false;
                    var7_12 = false;
                    it = var5_7;
                    $i$a$-also-DialogflowNlp$SentenceParser$parse$7 = false;
                    DialogflowNlp.access$getLogger$cp().warn((Function0)new Function0<Object>(result, (List<NlpIntentQualifier>)intentsQualifiers, (NlpResult)it){
                        final /* synthetic */ NlpResult $result;
                        final /* synthetic */ List<NlpIntentQualifier> $intentsQualifiers;
                        final /* synthetic */ NlpResult $it;
                        {
                            this.$result = $result;
                            this.$intentsQualifiers = $intentsQualifiers;
                            this.$it = $it;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return this.$result.getIntent() + " not in intents qualifier " + this.$intentsQualifiers + " - use " + this.$it;
                        }
                    });
                    return var5_7;
                }
            }
            return result;
        }
    }
}

