/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.dialogflow;

import ai.tock.nlp.dialogflow.DialogflowService;
import ai.tock.shared.IOCsKt;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import com.google.api.gax.core.CredentialsProvider;
import com.google.cloud.dialogflow.v2.Agent;
import com.google.cloud.dialogflow.v2.AgentsClient;
import com.google.cloud.dialogflow.v2.AgentsSettings;
import com.google.cloud.dialogflow.v2.DetectIntentResponse;
import com.google.cloud.dialogflow.v2.Intent;
import com.google.cloud.dialogflow.v2.IntentView;
import com.google.cloud.dialogflow.v2.IntentsClient;
import com.google.cloud.dialogflow.v2.IntentsSettings;
import com.google.cloud.dialogflow.v2.ListIntentsRequest;
import com.google.cloud.dialogflow.v2.ProjectAgentName;
import com.google.cloud.dialogflow.v2.ProjectName;
import com.google.cloud.dialogflow.v2.QueryInput;
import com.google.cloud.dialogflow.v2.QueryResult;
import com.google.cloud.dialogflow.v2.SessionName;
import com.google.cloud.dialogflow.v2.SessionsClient;
import com.google.cloud.dialogflow.v2.SessionsSettings;
import com.google.cloud.dialogflow.v2.TextInput;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u0007*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0007*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lai/tock/nlp/dialogflow/DialogflowService;", "", "()V", "DIALOGFLOW_MAX_TEXT_LENGTH", "", "agentsSettings", "Lcom/google/cloud/dialogflow/v2/AgentsSettings;", "kotlin.jvm.PlatformType", "credentialsProvider", "Lcom/google/api/gax/core/CredentialsProvider;", "getCredentialsProvider", "()Lcom/google/api/gax/core/CredentialsProvider;", "intentsSettings", "Lcom/google/cloud/dialogflow/v2/IntentsSettings;", "logger", "Lmu/KLogger;", "sessionsSettings", "Lcom/google/cloud/dialogflow/v2/SessionsSettings;", "detectIntentText", "Lcom/google/cloud/dialogflow/v2/QueryResult;", "projectId", "", "text", "sessionId", "languageCode", "getAgent", "Lcom/google/cloud/dialogflow/v2/Agent;", "getIntents", "", "Lcom/google/cloud/dialogflow/v2/Intent;", "tock-nlp-dialogflow"})
@SourceDebugExtension(value={"SMAP\nDialogflowService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DialogflowService.kt\nai/tock/nlp/dialogflow/DialogflowService\n+ 2 IOCs.kt\nai/tock/shared/IOCsKt\n+ 3 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 4 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n*L\n1#1,121:1\n53#2,2:122\n51#3:124\n277#4:125\n*S KotlinDebug\n*F\n+ 1 DialogflowService.kt\nai/tock/nlp/dialogflow/DialogflowService\n*L\n46#1:122,2\n46#1:124\n46#1:125\n*E\n"})
public final class DialogflowService {
    @NotNull
    public static final DialogflowService INSTANCE = new DialogflowService();
    private static final int DIALOGFLOW_MAX_TEXT_LENGTH = 256;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    private static final SessionsSettings sessionsSettings = ((SessionsSettings.Builder)SessionsSettings.newBuilder().setCredentialsProvider(INSTANCE.getCredentialsProvider())).build();
    private static final AgentsSettings agentsSettings = ((AgentsSettings.Builder)AgentsSettings.newBuilder().setCredentialsProvider(INSTANCE.getCredentialsProvider())).build();
    private static final IntentsSettings intentsSettings = ((IntentsSettings.Builder)IntentsSettings.newBuilder().setCredentialsProvider(INSTANCE.getCredentialsProvider())).build();

    private DialogflowService() {
    }

    private final CredentialsProvider getCredentialsProvider() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (CredentialsProvider)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<CredentialsProvider>(){}, tag$iv).getValue()).invoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final QueryResult detectIntentText(@NotNull String projectId, @NotNull String text, @NotNull String sessionId, @NotNull String languageCode) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)languageCode, (String)"languageCode");
        AutoCloseable autoCloseable = (AutoCloseable)SessionsClient.create((SessionsSettings)sessionsSettings);
        Throwable throwable = null;
        try {
            QueryResult queryResult;
            String string;
            SessionsClient it = (SessionsClient)autoCloseable;
            boolean bl = false;
            SessionName session = SessionName.of((String)projectId, (String)sessionId);
            logger.debug("Session Path: " + session);
            if (text.length() > 256) {
                String string2;
                String string3 = text.substring(0, 256);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String it2 = string2 = string3;
                boolean bl2 = false;
                logger.warn((Function0)new Function0<Object>(text){
                    final /* synthetic */ String $text;
                    {
                        this.$text = $text;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Text sent to Dialogflow too long : More than " + this.$text.length() + " characters. Truncated to 256 characters.";
                    }
                });
                string = string2;
            } else {
                string = text;
            }
            String dialogflowText2 = string;
            TextInput.Builder $this$detectIntentText_u24lambda_u245_u24lambda_u244 = TextInput.newBuilder().setText(dialogflowText2).setLanguageCode(languageCode);
            boolean bl3 = false;
            QueryInput $this$detectIntentText_u24lambda_u245_u24lambda_u244_u24lambda_u243 = QueryInput.newBuilder().setText($this$detectIntentText_u24lambda_u245_u24lambda_u244).build();
            boolean bl4 = false;
            DetectIntentResponse $this$detectIntentText_u24lambda_u245_u24lambda_u244_u24lambda_u243_u24lambda_u242 = it.detectIntent(session, $this$detectIntentText_u24lambda_u245_u24lambda_u244_u24lambda_u243);
            boolean bl5 = false;
            QueryResult it3 = queryResult = $this$detectIntentText_u24lambda_u245_u24lambda_u244_u24lambda_u243_u24lambda_u242.getQueryResult();
            boolean bl6 = false;
            logger.debug((Function0)new Function0<Object>(it3){
                final /* synthetic */ QueryResult $it;
                {
                    this.$it = $it;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Query Text: '" + this.$it.getQueryText() + "'";
                }
            });
            logger.debug((Function0)new Function0<Object>(it3){
                final /* synthetic */ QueryResult $it;
                {
                    this.$it = $it;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Detected Intent: " + this.$it.getIntent().getDisplayName() + " (confidence: " + this.$it.getIntentDetectionConfidence() + ")";
                }
            });
            QueryResult queryResult2 = queryResult;
            return queryResult2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Agent getAgent(@NotNull String projectId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        AutoCloseable autoCloseable = (AutoCloseable)AgentsClient.create((AgentsSettings)agentsSettings);
        Throwable throwable = null;
        try {
            AgentsClient it = (AgentsClient)autoCloseable;
            boolean bl = false;
            ProjectName projectName = ProjectName.of((String)projectId);
            Intrinsics.checkNotNullExpressionValue((Object)projectName, (String)"of(...)");
            ProjectName parent = projectName;
            Agent agent = it.getAgent(parent);
            return agent;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Intent> getIntents(@NotNull String projectId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        AutoCloseable autoCloseable = (AutoCloseable)IntentsClient.create((IntentsSettings)intentsSettings);
        Throwable throwable = null;
        try {
            IntentsClient it = (IntentsClient)autoCloseable;
            boolean bl = false;
            ProjectAgentName parent = ProjectAgentName.of((String)projectId);
            ListIntentsRequest request = ListIntentsRequest.newBuilder().setIntentView(IntentView.INTENT_VIEW_FULL).setParent(parent.toString()).build();
            Iterable iterable = it.listIntents(request).iterateAll();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"iterateAll(...)");
            List list = SequencesKt.toList((Sequence)CollectionsKt.asSequence((Iterable)iterable));
            return list;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }
}

