/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.dialogflow;

import ai.tock.bot.definition.BotDefinition;
import ai.tock.bot.definition.Intent;
import ai.tock.bot.definition.IntentAware;
import ai.tock.bot.engine.BotRepository;
import ai.tock.bot.engine.ConnectorController;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.action.SendSentence;
import ai.tock.bot.engine.dialog.Dialog;
import ai.tock.bot.engine.dialog.EntityStateValue;
import ai.tock.bot.engine.dialog.EntityValue;
import ai.tock.bot.engine.dialog.NextUserActionState;
import ai.tock.bot.engine.dialog.Story;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.nlp.NlpCallStats;
import ai.tock.bot.engine.nlp.NlpController;
import ai.tock.bot.engine.nlp.NlpListener;
import ai.tock.bot.engine.user.UserTimeline;
import ai.tock.nlp.api.client.NlpClient;
import ai.tock.nlp.api.client.model.NlpEntityValue;
import ai.tock.nlp.api.client.model.NlpIntentQualifier;
import ai.tock.nlp.api.client.model.NlpQuery;
import ai.tock.nlp.api.client.model.NlpQueryContext;
import ai.tock.nlp.api.client.model.NlpQueryState;
import ai.tock.nlp.api.client.model.NlpResult;
import ai.tock.nlp.api.client.model.dump.ApplicationDump;
import ai.tock.nlp.api.client.model.dump.IntentDefinition;
import ai.tock.nlp.api.client.model.dump.SentencesDump;
import ai.tock.nlp.api.client.model.monitoring.MarkAsUnknownQuery;
import ai.tock.shared.DatesKt;
import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.StringsKt;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import java.io.InputStream;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0002,-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020 2\u0006\u0010$\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020+H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006."}, d2={"Lai/tock/nlp/dialogflow/DialogflowNlp;", "Lai/tock/bot/engine/nlp/NlpController;", "<init>", "()V", "nlpClient", "Lai/tock/nlp/api/client/NlpClient;", "getNlpClient", "()Lai/tock/nlp/api/client/NlpClient;", "executor", "Lai/tock/shared/Executor;", "getExecutor", "()Lai/tock/shared/Executor;", "parseSentence", "", "sentence", "Lai/tock/bot/engine/action/SendSentence;", "userTimeline", "Lai/tock/bot/engine/user/UserTimeline;", "dialog", "Lai/tock/bot/engine/dialog/Dialog;", "connector", "Lai/tock/bot/engine/ConnectorController;", "botDefinition", "Lai/tock/bot/definition/BotDefinition;", "markAsUnknown", "getIntentsByNamespaceAndName", "", "Lai/tock/nlp/api/client/model/dump/IntentDefinition;", "namespace", "", "name", "importNlpDump", "", "stream", "Ljava/io/InputStream;", "importNlpPlainDump", "dump", "Lai/tock/nlp/api/client/model/dump/ApplicationDump;", "importNlpPlainSentencesDump", "Lai/tock/nlp/api/client/model/dump/SentencesDump;", "importNlpSentencesDump", "waitAvailability", "timeToWaitInMs", "", "Companion", "SentenceParser", "tock-nlp-dialogflow"})
@SourceDebugExtension(value={"SMAP\nDialogflowNlp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DialogflowNlp.kt\nai/tock/nlp/dialogflow/DialogflowNlp\n+ 2 IOCs.kt\nai/tock/shared/IOCsKt\n+ 3 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 4 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n*L\n1#1,314:1\n53#2,2:315\n53#2,2:319\n51#3:317\n51#3:321\n277#4:318\n277#4:322\n*S KotlinDebug\n*F\n+ 1 DialogflowNlp.kt\nai/tock/nlp/dialogflow/DialogflowNlp\n*L\n58#1:315,2\n59#1:319,2\n58#1:317\n59#1:321\n58#1:318\n59#1:322\n*E\n"})
public final class DialogflowNlp
implements NlpController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(DialogflowNlp::logger$lambda$1);

    private final NlpClient getNlpClient() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (NlpClient)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<NlpClient>(){}, tag$iv).getValue()).invoke();
    }

    private final Executor getExecutor() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (Executor)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<Executor>(){}, tag$iv).getValue()).invoke();
    }

    public void parseSentence(@NotNull SendSentence sentence, @NotNull UserTimeline userTimeline, @NotNull Dialog dialog, @NotNull ConnectorController connector, @NotNull BotDefinition botDefinition) {
        Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
        Intrinsics.checkNotNullParameter((Object)userTimeline, (String)"userTimeline");
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
        new SentenceParser(this.getNlpClient(), sentence, userTimeline, dialog, connector, botDefinition).parse();
    }

    public void markAsUnknown(@NotNull SendSentence sentence, @NotNull UserTimeline userTimeline, @NotNull BotDefinition botDefinition) {
        Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
        Intrinsics.checkNotNullParameter((Object)userTimeline, (String)"userTimeline");
        Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
        if (sentence.getStringText() != null) {
            this.getExecutor().executeBlocking(() -> DialogflowNlp.markAsUnknown$lambda$0(this, botDefinition, userTimeline, sentence));
        }
    }

    @Nullable
    public List<IntentDefinition> getIntentsByNamespaceAndName(@NotNull String namespace, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List list = this.getNlpClient().getIntentsByNamespaceAndName(namespace, name);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public boolean importNlpDump(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        return this.getNlpClient().importNlpDump(stream);
    }

    public boolean importNlpPlainDump(@NotNull ApplicationDump dump) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        return this.getNlpClient().importNlpPlainDump(dump);
    }

    public boolean importNlpPlainSentencesDump(@NotNull SentencesDump dump) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        return this.getNlpClient().importNlpPlainSentencesDump(dump);
    }

    public boolean importNlpSentencesDump(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        return this.getNlpClient().importNlpSentencesDump(stream);
    }

    public void waitAvailability(long timeToWaitInMs) {
        long s = System.currentTimeMillis();
        while (!this.getNlpClient().healthcheck() && System.currentTimeMillis() - s < timeToWaitInMs) {
        }
    }

    private static final Unit markAsUnknown$lambda$0(DialogflowNlp this$0, BotDefinition $botDefinition, UserTimeline $userTimeline, SendSentence $sentence) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$botDefinition, (String)"$botDefinition");
        Intrinsics.checkNotNullParameter((Object)$userTimeline, (String)"$userTimeline");
        Intrinsics.checkNotNullParameter((Object)$sentence, (String)"$sentence");
        NlpClient nlpClient = this$0.getNlpClient();
        String string = $botDefinition.getNamespace();
        String string2 = $botDefinition.getNlpModelName();
        Locale locale = $userTimeline.getUserPreferences().getLocale();
        String string3 = $sentence.getStringText();
        Intrinsics.checkNotNull((Object)string3);
        nlpClient.markAsUnknown(new MarkAsUnknownQuery(string, string2, locale, string3));
        return Unit.INSTANCE;
    }

    private static final Unit logger$lambda$1() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/tock/nlp/dialogflow/DialogflowNlp$Companion;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "tock-nlp-dialogflow"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010\u001c\u001a\u00020\u001dJ(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!H\u0002J\u0014\u0010\"\u001a\u0004\u0018\u00010\u001f2\b\u0010\u0004\u001a\u0004\u0018\u00010#H\u0002J\u0018\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020!H\u0002J\"\u0010(\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\u0006\u0010\b\u001a\u00020\t2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\b\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020&H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010!2\u0006\u0010.\u001a\u00020&H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006/"}, d2={"Lai/tock/nlp/dialogflow/DialogflowNlp$SentenceParser;", "", "nlpClient", "Lai/tock/nlp/api/client/NlpClient;", "sentence", "Lai/tock/bot/engine/action/SendSentence;", "userTimeline", "Lai/tock/bot/engine/user/UserTimeline;", "dialog", "Lai/tock/bot/engine/dialog/Dialog;", "connector", "Lai/tock/bot/engine/ConnectorController;", "botDefinition", "Lai/tock/bot/definition/BotDefinition;", "<init>", "(Lai/tock/nlp/api/client/NlpClient;Lai/tock/bot/engine/action/SendSentence;Lai/tock/bot/engine/user/UserTimeline;Lai/tock/bot/engine/dialog/Dialog;Lai/tock/bot/engine/ConnectorController;Lai/tock/bot/definition/BotDefinition;)V", "getNlpClient", "()Lai/tock/nlp/api/client/NlpClient;", "getSentence", "()Lai/tock/bot/engine/action/SendSentence;", "getUserTimeline", "()Lai/tock/bot/engine/user/UserTimeline;", "getDialog", "()Lai/tock/bot/engine/dialog/Dialog;", "getConnector", "()Lai/tock/bot/engine/ConnectorController;", "getBotDefinition", "()Lai/tock/bot/definition/BotDefinition;", "parse", "", "findIntent", "Lai/tock/bot/definition/Intent;", "nlpResult", "Lai/tock/nlp/api/client/model/NlpResult;", "findKeyword", "", "listenNlpSuccessCall", "query", "Lai/tock/nlp/api/client/model/NlpQuery;", "result", "listenNlpErrorCall", "throwable", "", "toQueryContext", "Lai/tock/nlp/api/client/model/NlpQueryContext;", "toNlpQuery", "request", "tock-nlp-dialogflow"})
    @SourceDebugExtension(value={"SMAP\nDialogflowNlp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DialogflowNlp.kt\nai/tock/nlp/dialogflow/DialogflowNlp$SentenceParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,314:1\n1557#2:315\n1628#2,3:316\n2632#2,3:319\n1971#2,14:322\n2632#2,3:336\n*S KotlinDebug\n*F\n+ 1 DialogflowNlp.kt\nai/tock/nlp/dialogflow/DialogflowNlp$SentenceParser\n*L\n115#1:315\n115#1:316,3\n244#1:319,3\n246#1:322,14\n102#1:336,3\n*E\n"})
    private static final class SentenceParser {
        @NotNull
        private final NlpClient nlpClient;
        @NotNull
        private final SendSentence sentence;
        @NotNull
        private final UserTimeline userTimeline;
        @NotNull
        private final Dialog dialog;
        @NotNull
        private final ConnectorController connector;
        @NotNull
        private final BotDefinition botDefinition;

        public SentenceParser(@NotNull NlpClient nlpClient, @NotNull SendSentence sentence, @NotNull UserTimeline userTimeline, @NotNull Dialog dialog, @NotNull ConnectorController connector, @NotNull BotDefinition botDefinition) {
            Intrinsics.checkNotNullParameter((Object)nlpClient, (String)"nlpClient");
            Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
            Intrinsics.checkNotNullParameter((Object)userTimeline, (String)"userTimeline");
            Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
            Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
            Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
            this.nlpClient = nlpClient;
            this.sentence = sentence;
            this.userTimeline = userTimeline;
            this.dialog = dialog;
            this.connector = connector;
            this.botDefinition = botDefinition;
        }

        @NotNull
        public final NlpClient getNlpClient() {
            return this.nlpClient;
        }

        @NotNull
        public final SendSentence getSentence() {
            return this.sentence;
        }

        @NotNull
        public final UserTimeline getUserTimeline() {
            return this.userTimeline;
        }

        @NotNull
        public final Dialog getDialog() {
            return this.dialog;
        }

        @NotNull
        public final ConnectorController getConnector() {
            return this.connector;
        }

        @NotNull
        public final BotDefinition getBotDefinition() {
            return this.botDefinition;
        }

        /*
         * WARNING - void declaration
         */
        public final void parse() {
            logger.debug(() -> SentenceParser.parse$lambda$0(this));
            Intent intent = this.findKeyword(this.sentence.getStringText());
            if (intent != null) {
                Intent $this$parse_u24lambda_u241 = intent;
                boolean bl = false;
                this.dialog.getState().setCurrentIntent($this$parse_u24lambda_u241);
                return;
            }
            NlpQuery query = this.toNlpQuery();
            boolean bl = false;
            try {
                NlpResult nlpResult;
                block11: {
                    block10: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        String it;
                        Dialog dialog;
                        NlpResult result;
                        NlpResult nlpResult2 = this.sentence.getPrecomputedNlp();
                        if (nlpResult2 == null) {
                            nlpResult2 = this.parse(query);
                        }
                        if ((nlpResult = (result = nlpResult2)) == null) break block10;
                        NlpResult nlpResult3 = nlpResult;
                        boolean bl2 = false;
                        this.listenNlpSuccessCall(query, nlpResult3);
                        Intent intent2 = this.findIntent(this.userTimeline, this.dialog, this.sentence, nlpResult3);
                        List customEntityEvaluations = new ArrayList();
                        BotRepository.INSTANCE.forEachNlpListener(arg_0 -> SentenceParser.parse$lambda$10$lambda$9$lambda$2(customEntityEvaluations, this, nlpResult3, arg_0));
                        List entityEvaluations = CollectionsKt.plus((Collection)customEntityEvaluations, (Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)nlpResult3.getEntities()), arg_0 -> SentenceParser.parse$lambda$10$lambda$9$lambda$4(customEntityEvaluations, arg_0)), arg_0 -> SentenceParser.parse$lambda$10$lambda$9$lambda$5(nlpResult3, arg_0)));
                        this.sentence.getState().getEntityValues().addAll(entityEvaluations);
                        Dialog $this$parse_u24lambda_u2410_u24lambda_u249_u24lambda_u248 = dialog = this.dialog;
                        boolean bl3 = false;
                        $this$parse_u24lambda_u2410_u24lambda_u249_u24lambda_u248.getState().setCurrentIntent(intent2);
                        String string = nlpResult3.getStaticResponse();
                        if (string != null) {
                            it = string;
                            boolean bl4 = false;
                            $this$parse_u24lambda_u2410_u24lambda_u249_u24lambda_u248.getState().setContextValue("message", (Object)nlpResult3.getStaticResponse());
                        }
                        Iterable iterable = entityEvaluations;
                        boolean $i$f$map = false;
                        it = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it2;
                            EntityValue entityValue = (EntityValue)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl5 = false;
                            $this$parse_u24lambda_u2410_u24lambda_u249_u24lambda_u248.getState().getEntityValues().put(it2.getEntity().getRole(), new EntityStateValue((Action)this.sentence, (EntityValue)it2));
                            collection.add(Unit.INSTANCE);
                        }
                        List cfr_ignored_0 = (List)destination$iv$iv;
                        this.sentence.setNlpStats(new NlpCallStats(this.userTimeline.getUserPreferences().getLocale(), intent2, entityEvaluations, entityEvaluations, query, nlpResult3));
                        Dialog dialog2 = dialog;
                        nlpResult = dialog2;
                        if (dialog2 != null) break block11;
                    }
                    this.listenNlpErrorCall(query, this.dialog, null);
                    nlpResult = Unit.INSTANCE;
                }
                NlpResult nlpResult4 = nlpResult;
            }
            catch (Throwable t) {
                LoggersKt.error((KLogger)logger, (Throwable)t);
                this.listenNlpErrorCall(query, this.dialog, t);
                Unit unit = Unit.INSTANCE;
            }
        }

        private final Intent findIntent(UserTimeline userTimeline, Dialog dialog, SendSentence sentence, NlpResult nlpResult) {
            Ref.ObjectRef i = new Ref.ObjectRef();
            BotRepository.INSTANCE.forEachNlpListener(arg_0 -> SentenceParser.findIntent$lambda$11(i, userTimeline, dialog, sentence, nlpResult, arg_0));
            Intent intent = (Intent)i.element;
            if (intent == null) {
                intent = this.botDefinition.findIntent(nlpResult.getIntent(), sentence.getApplicationId());
            }
            return intent;
        }

        private final Intent findKeyword(String sentence) {
            Intent intent;
            if (sentence != null) {
                Ref.ObjectRef i = new Ref.ObjectRef();
                BotRepository.INSTANCE.forEachNlpListener(arg_0 -> SentenceParser.findKeyword$lambda$12(i, sentence, arg_0));
                intent = (Intent)i.element;
            } else {
                intent = null;
            }
            return intent;
        }

        private final void listenNlpSuccessCall(NlpQuery query, NlpResult result) {
            BotRepository.INSTANCE.forEachNlpListener(arg_0 -> SentenceParser.listenNlpSuccessCall$lambda$13(query, result, arg_0));
        }

        private final void listenNlpErrorCall(NlpQuery query, Dialog dialog, Throwable throwable) {
            BotRepository.INSTANCE.forEachNlpListener(arg_0 -> SentenceParser.listenNlpErrorCall$lambda$14(query, dialog, throwable, arg_0));
        }

        private final NlpQueryContext toQueryContext() {
            boolean test = this.userTimeline.getUserPreferences().getTest();
            Locale locale = this.userTimeline.getUserPreferences().getLocale();
            String string = this.sentence.getPlayerId().getId();
            String string2 = this.dialog.getId().toString();
            String string3 = this.connector.getConnectorType().toString();
            Object object = this.dialog.getState().getNextActionState();
            if (object == null || (object = object.getReferenceDate()) == null) {
                object = ZonedDateTime.now(DatesKt.getDefaultZoneId());
            }
            Object object2 = object;
            Intrinsics.checkNotNull((Object)object2);
            Object object3 = this.dialog.getState().getNextActionState();
            if (object3 == null || (object3 = object3.getReferenceTimezone()) == null) {
                object3 = DatesKt.getDefaultZoneId();
            }
            return new NlpQueryContext(locale, string, string2, string3, (ZonedDateTime)object2, (ZoneId)object3, test, !test && !this.userTimeline.getUserState().getBotDisabled());
        }

        private final NlpQuery toNlpQuery() {
            String string = this.sentence.getStringText();
            if (string == null) {
                string = "";
            }
            List list = CollectionsKt.listOf((Object)string);
            String string2 = this.botDefinition.getNamespace();
            String string3 = this.botDefinition.getNlpModelName();
            NlpQueryContext nlpQueryContext = this.toQueryContext();
            Object object = this.dialog.getState().getNextActionState();
            if (object == null || (object = object.getStates()) == null) {
                Story story = this.dialog.getCurrentStory();
                object = CollectionsKt.toSet((Iterable)CollectionsKt.listOfNotNull(story != null && (story = story.getDefinition()) != null && (story = story.mainIntent()) != null ? story.getName() : null));
            }
            return new NlpQuery(list, string2, string3, nlpQueryContext, new NlpQueryState((Set)object), null, null, 96, null);
        }

        /*
         * WARNING - void declaration
         */
        private final NlpResult parse(NlpQuery request) {
            NlpResult result;
            NlpResult nlpResult;
            boolean useQualifiers;
            List intentsQualifiers;
            logger.debug(() -> SentenceParser.parse$lambda$15(this));
            NextUserActionState nextUserActionState = this.dialog.getState().getNextActionState();
            List list = intentsQualifiers = nextUserActionState != null ? nextUserActionState.getIntentsQualifiers() : null;
            boolean bl = intentsQualifiers != null && !((Collection)intentsQualifiers).isEmpty() ? true : (useQualifiers = false);
            if (!useQualifiers) {
                nlpResult = this.nlpClient.parse(request);
            } else {
                List list2 = intentsQualifiers;
                Intrinsics.checkNotNull((Object)list2);
                nlpResult = result = this.nlpClient.parse(NlpQuery.copy$default((NlpQuery)request, null, null, null, null, null, (Set)SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list2), arg_0 -> SentenceParser.parse$lambda$16(request, arg_0))), null, (int)95, null));
            }
            if (result != null && useQualifiers) {
                boolean bl2;
                block13: {
                    List list3 = intentsQualifiers;
                    Intrinsics.checkNotNull((Object)list3);
                    Iterable $this$none$iv = list3;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            NlpIntentQualifier it = (NlpIntentQualifier)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.getIntent(), (Object)result.getIntent())) continue;
                            bl2 = false;
                            break block13;
                        }
                        bl2 = true;
                    }
                }
                if (bl2) {
                    NlpResult nlpResult2;
                    Object object;
                    Object v7;
                    void $this$maxByOrNull$iv;
                    Iterable $i$f$none = intentsQualifiers;
                    NlpResult nlpResult3 = result;
                    boolean $i$f$maxByOrNull = false;
                    Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v7 = null;
                    } else {
                        Object maxElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            v7 = maxElem$iv;
                        } else {
                            NlpIntentQualifier it = (NlpIntentQualifier)maxElem$iv;
                            boolean bl4 = false;
                            double maxValue$iv = it.getModifier();
                            do {
                                Object e$iv = iterator$iv.next();
                                NlpIntentQualifier it2 = (NlpIntentQualifier)e$iv;
                                $i$a$-maxByOrNull-DialogflowNlp$SentenceParser$parse$6 = false;
                                double v$iv = it2.getModifier();
                                if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                                maxElem$iv = e$iv;
                                maxValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            v7 = maxElem$iv;
                        }
                    }
                    if ((object = (NlpIntentQualifier)v7) == null || (object = object.getIntent()) == null) {
                        object = ((NlpIntentQualifier)CollectionsKt.first((List)intentsQualifiers)).getIntent();
                    }
                    NlpResult it = nlpResult2 = NlpResult.copy$default((NlpResult)nlpResult3, (String)object, null, null, null, null, (double)0.0, (double)0.0, null, null, null, (int)1022, null);
                    boolean bl5 = false;
                    logger.warn(() -> SentenceParser.parse$lambda$20$lambda$19(result, intentsQualifiers, it));
                    return nlpResult2;
                }
            }
            return result;
        }

        private static final Object parse$lambda$0(SentenceParser this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return "Parse sentence : " + this$0.sentence;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit parse$lambda$10$lambda$9$lambda$2(List $customEntityEvaluations, SentenceParser this$0, NlpResult $nlpResult, NlpListener it) {
            List list;
            List list2;
            Intrinsics.checkNotNullParameter((Object)$customEntityEvaluations, (String)"$customEntityEvaluations");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$nlpResult, (String)"$nlpResult");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            List list3 = $customEntityEvaluations;
            try {
                list2 = list3;
                list = it.evaluateEntities(this$0.userTimeline, this$0.dialog, (Event)this$0.sentence, $nlpResult);
            }
            catch (Exception exception) {
                void e;
                list2 = list3;
                LoggersKt.error((KLogger)logger, (Throwable)((Throwable)e));
                list = CollectionsKt.emptyList();
            }
            list2.addAll(list);
            return Unit.INSTANCE;
        }

        private static final boolean parse$lambda$10$lambda$9$lambda$4(List $customEntityEvaluations, NlpEntityValue e) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)$customEntityEvaluations, (String)"$customEntityEvaluations");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Iterable $this$none$iv = $customEntityEvaluations;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        EntityValue it = (EntityValue)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getEntity(), (Object)e.getEntity())) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        private static final EntityValue parse$lambda$10$lambda$9$lambda$5(NlpResult $nlpResult, NlpEntityValue it) {
            Intrinsics.checkNotNullParameter((Object)$nlpResult, (String)"$nlpResult");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new EntityValue($nlpResult, it);
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit findIntent$lambda$11(Ref.ObjectRef $i, UserTimeline $userTimeline, Dialog $dialog, SendSentence $sentence, NlpResult $nlpResult, NlpListener it) {
            Intrinsics.checkNotNullParameter((Object)$i, (String)"$i");
            Intrinsics.checkNotNullParameter((Object)$userTimeline, (String)"$userTimeline");
            Intrinsics.checkNotNullParameter((Object)$dialog, (String)"$dialog");
            Intrinsics.checkNotNullParameter((Object)$sentence, (String)"$sentence");
            Intrinsics.checkNotNullParameter((Object)$nlpResult, (String)"$nlpResult");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if ($i.element == null) {
                Intent intent;
                Ref.ObjectRef objectRef;
                Ref.ObjectRef objectRef2 = $i;
                try {
                    objectRef = objectRef2;
                    IntentAware intentAware = it.findIntent($userTimeline, $dialog, (Event)$sentence, $nlpResult);
                    intent = intentAware != null ? intentAware.wrappedIntent() : null;
                }
                catch (Exception exception) {
                    void e;
                    objectRef = objectRef2;
                    LoggersKt.error((KLogger)logger, (Throwable)((Throwable)e));
                    intent = null;
                }
                objectRef.element = intent;
            }
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit findKeyword$lambda$12(Ref.ObjectRef $i, String $sentence, NlpListener it) {
            Intrinsics.checkNotNullParameter((Object)$i, (String)"$i");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if ($i.element == null) {
                Intent intent;
                Ref.ObjectRef objectRef;
                Ref.ObjectRef objectRef2 = $i;
                try {
                    objectRef = objectRef2;
                    intent = it.handleKeyword($sentence);
                }
                catch (Exception exception) {
                    void e;
                    objectRef = objectRef2;
                    LoggersKt.error((KLogger)logger, (Throwable)((Throwable)e));
                    intent = null;
                }
                objectRef.element = intent;
            }
            return Unit.INSTANCE;
        }

        private static final Unit listenNlpSuccessCall$lambda$13(NlpQuery $query, NlpResult $result, NlpListener it) {
            Intrinsics.checkNotNullParameter((Object)$query, (String)"$query");
            Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            try {
                it.success($query, $result);
            }
            catch (Exception e) {
                LoggersKt.error((KLogger)logger, (Throwable)e);
            }
            return Unit.INSTANCE;
        }

        private static final Unit listenNlpErrorCall$lambda$14(NlpQuery $query, Dialog $dialog, Throwable $throwable, NlpListener it) {
            Intrinsics.checkNotNullParameter((Object)$query, (String)"$query");
            Intrinsics.checkNotNullParameter((Object)$dialog, (String)"$dialog");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            try {
                it.error($query, $dialog, $throwable);
            }
            catch (Exception e) {
                LoggersKt.error((KLogger)logger, (Throwable)e);
            }
            return Unit.INSTANCE;
        }

        private static final Object parse$lambda$15(SentenceParser this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return "Sending sentence '" + this$0.sentence.getStringText() + "' to NLP";
        }

        private static final NlpIntentQualifier parse$lambda$16(NlpQuery $request, NlpIntentQualifier it) {
            Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return NlpIntentQualifier.copy$default((NlpIntentQualifier)it, (String)StringsKt.withNamespace((String)it.getIntent(), (String)$request.getNamespace()), (double)0.0, (int)2, null);
        }

        private static final Object parse$lambda$20$lambda$19(NlpResult $result, List $intentsQualifiers, NlpResult $it) {
            Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
            return $result.getIntent() + " not in intents qualifier " + $intentsQualifiers + " - use " + $it;
        }
    }
}

