/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.dialogflow;

import ai.tock.bot.admin.answer.AnswerConfigurationType;
import ai.tock.bot.admin.answer.SimpleAnswer;
import ai.tock.bot.admin.answer.SimpleAnswerConfiguration;
import ai.tock.bot.admin.story.StoryDefinitionConfiguration;
import ai.tock.bot.admin.story.StoryDefinitionConfigurationDAO;
import ai.tock.bot.definition.IntentWithoutNamespace;
import ai.tock.bot.mongo.IocKt;
import ai.tock.nlp.dialogflow.DialogflowService;
import ai.tock.nlp.front.client.FrontClient;
import ai.tock.nlp.front.ioc.FrontIoc;
import ai.tock.nlp.front.shared.codec.ImportReport;
import ai.tock.nlp.front.shared.codec.SentenceDump;
import ai.tock.nlp.front.shared.codec.SentencesDump;
import ai.tock.nlp.front.shared.config.ApplicationDefinition;
import ai.tock.nlp.front.shared.config.ClassifiedSentenceStatus;
import ai.tock.nlp.front.shared.config.IntentDefinition;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LocalesKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.translator.I18nKeyProvider;
import ai.tock.translator.I18nLabel;
import ai.tock.translator.I18nLabelValue;
import ai.tock.translator.Translator;
import com.github.salomonbrys.kodein.InjectedProperty;
import com.github.salomonbrys.kodein.Kodein;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import com.google.cloud.dialogflow.v2.Agent;
import com.google.cloud.dialogflow.v2.Intent;
import com.google.protobuf.ProtocolStringList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005J,\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lai/tock/nlp/dialogflow/DialogflowIntentImporter;", "", "<init>", "()V", "projectId", "", "storyDefinitionDAO", "Lai/tock/bot/admin/story/StoryDefinitionConfigurationDAO;", "getStoryDefinitionDAO", "()Lai/tock/bot/admin/story/StoryDefinitionConfigurationDAO;", "storyDefinitionDAO$delegate", "Lcom/github/salomonbrys/kodein/InjectedProperty;", "logger", "Lmu/KLogger;", "importIntentsFromDialogflow", "", "appName", "appNamespace", "createSimpleAnswers", "", "Lai/tock/bot/admin/answer/SimpleAnswerConfiguration;", "messagesList", "", "Lcom/google/cloud/dialogflow/v2/Intent$Message;", "locale", "Ljava/util/Locale;", "namespace", "tock-nlp-dialogflow"})
@SourceDebugExtension(value={"SMAP\nDialogflowIntentImporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DialogflowIntentImporter.kt\nai/tock/nlp/dialogflow/DialogflowIntentImporter\n+ 2 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 3 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n*L\n1#1,174:1\n80#2:175\n277#3:176\n*S KotlinDebug\n*F\n+ 1 DialogflowIntentImporter.kt\nai/tock/nlp/dialogflow/DialogflowIntentImporter\n*L\n51#1:175\n51#1:176\n*E\n"})
public final class DialogflowIntentImporter {
    @NotNull
    public static final DialogflowIntentImporter INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final String projectId;
    @NotNull
    private static final InjectedProperty storyDefinitionDAO$delegate;
    @NotNull
    private static final KLogger logger;

    private DialogflowIntentImporter() {
    }

    private final StoryDefinitionConfigurationDAO getStoryDefinitionDAO() {
        return (StoryDefinitionConfigurationDAO)storyDefinitionDAO$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void importIntentsFromDialogflow(@NotNull String appName, @NotNull String appNamespace) {
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        Intrinsics.checkNotNullParameter((Object)appNamespace, (String)"appNamespace");
        ApplicationDefinition application = FrontClient.INSTANCE.getApplicationByNamespaceAndName(appNamespace, appName);
        if (application == null) {
            logger.error(() -> DialogflowIntentImporter.importIntentsFromDialogflow$lambda$1(appNamespace, appName));
        } else {
            Agent agent = DialogflowService.INSTANCE.getAgent(projectId);
            if (agent == null) {
                logger.error(DialogflowIntentImporter::importIntentsFromDialogflow$lambda$2);
            } else {
                Locale locale = Locale.forLanguageTag(agent.getDefaultLanguageCode());
                List sentences = new ArrayList();
                for (Intent dialogflowIntent : DialogflowService.INSTANCE.getIntents(projectId)) {
                    String intentName;
                    String string = dialogflowIntent.getDisplayName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
                    String string2 = StringsKt.replace$default((String)string, (String)" ", (String)"_", (boolean)false, (int)4, null);
                    Intrinsics.checkNotNullExpressionValue((Object)string2.toLowerCase(LocalesKt.getDefaultLocale()), (String)"toLowerCase(...)");
                    IntentDefinition intentDefinition = FrontClient.INSTANCE.getIntentByNamespaceAndName(application.getNamespace(), intentName);
                    if (intentDefinition == null) {
                        intentDefinition = new IntentDefinition(intentName, application.getNamespace(), SetsKt.setOf((Object)application.get_id()), SetsKt.emptySet(), null, null, null, dialogflowIntent.getDisplayName(), null, null, null, 1904, null);
                        FrontClient.INSTANCE.save(intentDefinition);
                    }
                    for (Intent.TrainingPhrase trainingPhrase : dialogflowIntent.getTrainingPhrasesList()) {
                        Object text = "";
                        for (Intent.TrainingPhrase.Part part : trainingPhrase.getPartsList()) {
                            text = (String)text + part.getText();
                        }
                        sentences.add(new SentenceDump((String)text, intentDefinition.getQualifiedName(), null, null, locale, ClassifiedSentenceStatus.model, false, null, 204, null));
                    }
                    List list = dialogflowIntent.getMessagesList();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMessagesList(...)");
                    Intrinsics.checkNotNull((Object)locale);
                    List<SimpleAnswerConfiguration> simpleAnswers = this.createSimpleAnswers(list, locale, application.getNamespace());
                    if (!(!((Collection)simpleAnswers).isEmpty())) continue;
                    StoryDefinitionConfiguration storyDefinitionConfiguration = new StoryDefinitionConfiguration(intentName, application.getName(), new IntentWithoutNamespace(intentName), AnswerConfigurationType.simple, simpleAnswers, 0, application.getNamespace(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, 4194208, null);
                    try {
                        this.getStoryDefinitionDAO().save(storyDefinitionConfiguration);
                    }
                    catch (Exception e) {
                        LoggersKt.trace((KLogger)logger, (Throwable)e);
                    }
                }
                SentencesDump sentenceDump = new SentencesDump(application.getName(), locale, sentences);
                ImportReport it = FrontClient.INSTANCE.importSentences(application.getNamespace(), sentenceDump);
                boolean bl = false;
                if (it.getSuccess()) {
                    logger.info(() -> DialogflowIntentImporter.importIntentsFromDialogflow$lambda$5$lambda$3(it));
                } else {
                    logger.error(DialogflowIntentImporter::importIntentsFromDialogflow$lambda$5$lambda$4);
                }
            }
        }
    }

    private final List<SimpleAnswerConfiguration> createSimpleAnswers(List<Intent.Message> messagesList, Locale locale, String namespace) {
        List answerConfigurations = new ArrayList();
        for (Intent.Message message : messagesList) {
            ProtocolStringList protocolStringList = message.getText().getTextList();
            Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getTextList(...)");
            if (!(!((Collection)protocolStringList).isEmpty())) continue;
            List alternatives = message.getText().getTextList().subList(1, message.getText().getTextList().size());
            I18nKeyProvider i18nKeyProvider = I18nKeyProvider.Companion.simpleKeyProvider(namespace, "answer");
            Object object = message.getText().getTextList().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            I18nLabelValue labelKey = I18nKeyProvider.DefaultImpls.i18n$default((I18nKeyProvider)i18nKeyProvider, (CharSequence)((CharSequence)object), null, (int)2, null);
            I18nLabel label = Translator.INSTANCE.create(labelKey, locale, alternatives);
            answerConfigurations.add(new SimpleAnswerConfiguration(CollectionsKt.listOf((Object)new SimpleAnswer(new I18nLabelValue(label), -1L, null))));
        }
        return answerConfigurations;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object importIntentsFromDialogflow$lambda$1(String $appNamespace, String $appName) {
        Intrinsics.checkNotNullParameter((Object)$appNamespace, (String)"$appNamespace");
        Intrinsics.checkNotNullParameter((Object)$appName, (String)"$appName");
        return "Can't find application " + $appNamespace + ":" + $appName;
    }

    private static final Object importIntentsFromDialogflow$lambda$2() {
        return "Can't find Dialogflow agent " + projectId;
    }

    private static final Object importIntentsFromDialogflow$lambda$5$lambda$3(ImportReport $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return $it.getSentencesImported() + " imported sentences";
    }

    private static final Object importIntentsFromDialogflow$lambda$5$lambda$4() {
        return "Intents import failed";
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(DialogflowIntentImporter.class, "storyDefinitionDAO", "getStoryDefinitionDAO()Lai/tock/bot/admin/story/StoryDefinitionConfigurationDAO;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new DialogflowIntentImporter();
        projectId = PropertiesKt.property((String)"dialogflow_project_id", (String)"please set a google project id");
        KodeinInjectedBase $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        Object tag$iv = null;
        KodeinInjector kodeinInjector = $receiver$iv.getInjector();
        storyDefinitionDAO$delegate = kodeinInjector.Instance((TypeToken)new TypeReference<StoryDefinitionConfigurationDAO>(){}, tag$iv);
        logger = KotlinLogging.INSTANCE.logger(DialogflowIntentImporter::logger$lambda$0);
        kPropertyArray = new Kodein.Module[]{IOCsKt.getSharedModule(), IocKt.getBotMongoModule()};
        FrontIoc.INSTANCE.setup((Kodein.Module[])kPropertyArray);
    }
}

