/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.dialogflow;

import ai.tock.nlp.api.client.NlpClient;
import ai.tock.nlp.api.client.model.NlpLogCount;
import ai.tock.nlp.api.client.model.NlpLogCountQuery;
import ai.tock.nlp.api.client.model.NlpQuery;
import ai.tock.nlp.api.client.model.NlpResult;
import ai.tock.nlp.api.client.model.dump.ApplicationDefinition;
import ai.tock.nlp.api.client.model.dump.ApplicationDump;
import ai.tock.nlp.api.client.model.dump.IntentDefinition;
import ai.tock.nlp.api.client.model.dump.SentencesDump;
import ai.tock.nlp.api.client.model.evaluation.EntityEvaluationQuery;
import ai.tock.nlp.api.client.model.evaluation.EntityEvaluationResult;
import ai.tock.nlp.api.client.model.merge.ValuesMergeQuery;
import ai.tock.nlp.api.client.model.merge.ValuesMergeResult;
import ai.tock.nlp.api.client.model.monitoring.MarkAsUnknownQuery;
import ai.tock.nlp.dialogflow.DialogflowService;
import ai.tock.nlp.dialogflow.DialogflowTockMapper;
import ai.tock.shared.PropertiesKt;
import com.google.cloud.dialogflow.v2.QueryResult;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\"\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010&\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020'H\u0016J\u0018\u0010(\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010\u00162\u0006\u0010\b\u001a\u00020*H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lai/tock/nlp/dialogflow/TockDialogflowNlpClient;", "Lai/tock/nlp/api/client/NlpClient;", "<init>", "()V", "projectId", "", "parse", "Lai/tock/nlp/api/client/model/NlpResult;", "query", "Lai/tock/nlp/api/client/model/NlpQuery;", "healthcheck", "", "evaluateEntities", "Lai/tock/nlp/api/client/model/evaluation/EntityEvaluationResult;", "Lai/tock/nlp/api/client/model/evaluation/EntityEvaluationQuery;", "mergeValues", "Lai/tock/nlp/api/client/model/merge/ValuesMergeResult;", "Lai/tock/nlp/api/client/model/merge/ValuesMergeQuery;", "markAsUnknown", "", "Lai/tock/nlp/api/client/model/monitoring/MarkAsUnknownQuery;", "getIntentsByNamespaceAndName", "", "Lai/tock/nlp/api/client/model/dump/IntentDefinition;", "namespace", "name", "getApplicationByNamespaceAndName", "Lai/tock/nlp/api/client/model/dump/ApplicationDefinition;", "createApplication", "locale", "Ljava/util/Locale;", "importNlpDump", "stream", "Ljava/io/InputStream;", "importNlpPlainDump", "dump", "Lai/tock/nlp/api/client/model/dump/ApplicationDump;", "importNlpSentencesDump", "importNlpPlainSentencesDump", "Lai/tock/nlp/api/client/model/dump/SentencesDump;", "logsCount", "Lai/tock/nlp/api/client/model/NlpLogCount;", "Lai/tock/nlp/api/client/model/NlpLogCountQuery;", "tock-nlp-dialogflow"})
public final class TockDialogflowNlpClient
implements NlpClient {
    @NotNull
    private final String projectId = PropertiesKt.property((String)"dialogflow_project_id", (String)"please set a google project id");

    @Nullable
    public NlpResult parse(@NotNull NlpQuery query) {
        NlpResult nlpResult;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        String string = (String)CollectionsKt.firstOrNull((List)query.getQueries());
        if (string == null) {
            string = "";
        }
        String string2 = query.getContext().getDialogId();
        String string3 = query.getContext().getLanguage().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        QueryResult queryResult = DialogflowService.INSTANCE.detectIntentText(this.projectId, string, string2, string3);
        if (queryResult != null) {
            QueryResult it = queryResult;
            boolean bl = false;
            nlpResult = new DialogflowTockMapper().toNlpResult(it, query.getNamespace());
        } else {
            nlpResult = null;
        }
        return nlpResult;
    }

    public boolean healthcheck() {
        return true;
    }

    @Nullable
    public EntityEvaluationResult evaluateEntities(@NotNull EntityEvaluationQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return null;
    }

    @Nullable
    public ValuesMergeResult mergeValues(@NotNull ValuesMergeQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return null;
    }

    public void markAsUnknown(@NotNull MarkAsUnknownQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
    }

    @Nullable
    public List<IntentDefinition> getIntentsByNamespaceAndName(@NotNull String namespace, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return null;
    }

    @Nullable
    public ApplicationDefinition getApplicationByNamespaceAndName(@NotNull String namespace, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return null;
    }

    @Nullable
    public ApplicationDefinition createApplication(@NotNull String namespace, @NotNull String name, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return null;
    }

    public boolean importNlpDump(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        return false;
    }

    public boolean importNlpPlainDump(@NotNull ApplicationDump dump) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        return false;
    }

    public boolean importNlpSentencesDump(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        return false;
    }

    public boolean importNlpPlainSentencesDump(@NotNull SentencesDump dump) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        return false;
    }

    @Nullable
    public List<NlpLogCount> logsCount(@NotNull NlpLogCountQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return null;
    }
}

