/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.duckling.service;

import ai.tock.duckling.service.DucklingBridge;
import ai.tock.duckling.service.DucklingVerticle;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.jackson.JacksonKt;
import ai.tock.shared.vertx.DetailedHealthcheckKt;
import ai.tock.shared.vertx.RequestLogger;
import ai.tock.shared.vertx.UnauthorizedException;
import ai.tock.shared.vertx.VertXsKt;
import ai.tock.shared.vertx.WebVerticle;
import clojure.lang.Keyword;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.vertx.core.AsyncResult;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.RoutingContext;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\nH\u0016J\u0014\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\nH\u0016J\u0016\u0010\r\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lai/tock/duckling/service/DucklingVerticle;", "Lai/tock/shared/vertx/WebVerticle;", "()V", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "configure", "", "defaultHealthcheck", "Lkotlin/Function1;", "Lio/vertx/ext/web/RoutingContext;", "detailedHealthcheck", "startServer", "promise", "Lio/vertx/core/Promise;", "Ljava/lang/Void;", "KeywordSerializer", "ParseRequest", "tock-nlp-duckling-service"})
@SourceDebugExtension(value={"SMAP\nDucklingVerticle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DucklingVerticle.kt\nai/tock/duckling/service/DucklingVerticle\n+ 2 WebVerticle.kt\nai/tock/shared/vertx/WebVerticle\n*L\n1#1,102:1\n567#2,7:103\n396#2:110\n411#2:111\n574#2:112\n*S KotlinDebug\n*F\n+ 1 DucklingVerticle.kt\nai/tock/duckling/service/DucklingVerticle\n*L\n62#1:103,7\n62#1:110\n62#1:111\n62#1:112\n*E\n"})
public final class DucklingVerticle
extends WebVerticle {
    @NotNull
    private final KLogger logger;

    public DucklingVerticle() {
        JacksonKt.getMapper().registerModule((Module)new SimpleModule().addSerializer(Keyword.class, (JsonSerializer)new KeywordSerializer()));
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    }

    @NotNull
    public KLogger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    public void configure() {
        void this_$iv$iv;
        String path$iv = "/parse";
        Set roles$iv = ((WebVerticle)this).defaultRoles();
        RequestLogger logger$iv = WebVerticle.Companion.getDefaultRequestLogger();
        boolean $i$f$blockingJsonPost = false;
        WebVerticle webVerticle = this;
        HttpMethod httpMethod = HttpMethod.POST;
        Intrinsics.checkNotNullExpressionValue((Object)httpMethod, (String)"POST");
        HttpMethod method$iv$iv = httpMethod;
        boolean $i$f$blockingWithBodyJson = false;
        WebVerticle.blocking$default((WebVerticle)this_$iv$iv, (HttpMethod)method$iv$iv, (String)path$iv, (Set)roles$iv, null, (Function1)((Function1)new Function1<RoutingContext, Unit>((WebVerticle)this_$iv$iv, logger$iv){
            final /* synthetic */ WebVerticle this$0;
            final /* synthetic */ RequestLogger $logger;
            {
                this.this$0 = $receiver;
                this.$logger = $logger;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull RoutingContext context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Object input = null;
                try {
                    void $this$readValue$iv$iv;
                    WebVerticle webVerticle = this.this$0;
                    RoutingContext $this$readJson$iv = context;
                    boolean $i$f$readJson = false;
                    ObjectMapper objectMapper = JacksonKt.getMapper();
                    String string = $this$readJson$iv.body().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.body().asString()");
                    String content$iv$iv = string;
                    boolean $i$f$readValue = false;
                    boolean $i$f$jacksonTypeRef = false;
                    input = $this$readValue$iv$iv.readValue(content$iv$iv, (TypeReference)new TypeReference<ParseRequest>(){});
                    ParseRequest request = (ParseRequest)input;
                    boolean bl = false;
                    ParseRequest $this$configure_u24lambda_u241_u24lambda_u240 = request;
                    boolean bl2 = false;
                    Object result = DucklingBridge.INSTANCE.parse($this$configure_u24lambda_u241_u24lambda_u240.getLanguage(), $this$configure_u24lambda_u241_u24lambda_u240.getTextToParse(), $this$configure_u24lambda_u241_u24lambda_u240.getDimensions(), $this$configure_u24lambda_u241_u24lambda_u240.getReferenceDate(), $this$configure_u24lambda_u241_u24lambda_u240.getReferenceTimezone());
                    this.this$0.endJson(context, result);
                    RequestLogger.DefaultImpls.log$default((RequestLogger)this.$logger, (RoutingContext)context, (Object)input, (boolean)false, (int)4, null);
                }
                catch (Throwable t) {
                    if (!(t instanceof UnauthorizedException)) {
                        this.$logger.log(context, input, true);
                    }
                    throw t;
                }
            }
        }), (int)8, null);
    }

    @NotNull
    public Function1<RoutingContext, Unit> defaultHealthcheck() {
        return defaultHealthcheck.1.INSTANCE;
    }

    @NotNull
    public Function1<RoutingContext, Unit> detailedHealthcheck() {
        return DetailedHealthcheckKt.detailedHealthcheck$default((List)CollectionsKt.listOf((Object)new Pair((Object)"duckling_bridge", (Object)detailedHealthcheck.1.INSTANCE)), null, (int)2, null);
    }

    protected void startServer(@NotNull Promise<Void> promise) {
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        Vertx vertx = this.vertx;
        Intrinsics.checkNotNullExpressionValue((Object)vertx, (String)"vertx");
        VertXsKt.blocking((Vertx)vertx, (Function1)((Function1)new Function1<Promise<Boolean>, Unit>(this){
            final /* synthetic */ DucklingVerticle this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Promise<Boolean> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                try {
                    this.this$0.getLogger().info((Function0)startServer.1.INSTANCE);
                    DucklingBridge.INSTANCE.initDuckling();
                    this.this$0.getLogger().info((Function0)startServer.2.INSTANCE);
                    it.complete();
                }
                catch (Exception e) {
                    LoggersKt.error((KLogger)this.this$0.getLogger(), (Throwable)e);
                    it.fail((Throwable)e);
                }
            }
        }), (Function1)((Function1)new Function1<AsyncResult<Boolean>, Unit>(this, promise){
            final /* synthetic */ DucklingVerticle this$0;
            final /* synthetic */ Promise<Void> $promise;
            {
                this.this$0 = $receiver;
                this.$promise = $promise;
                super(1);
            }

            public final void invoke(@NotNull AsyncResult<Boolean> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (it.succeeded()) {
                    DucklingVerticle.access$startServer$s1249618968(this.this$0, this.$promise);
                } else {
                    this.$promise.fail(it.cause());
                }
            }
        }));
    }

    public static final /* synthetic */ void access$startServer$s1249618968(DucklingVerticle $this, Promise promise) {
        super.startServer(promise);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lai/tock/duckling/service/DucklingVerticle$KeywordSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lclojure/lang/Keyword;", "()V", "serialize", "", "keyword", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "tock-nlp-duckling-service"})
    public static final class KeywordSerializer
    extends JsonSerializer<Keyword> {
        public void serialize(@NotNull Keyword keyword, @NotNull JsonGenerator gen, @NotNull SerializerProvider provider) {
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            gen.writeString(keyword.getName());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003JA\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006!"}, d2={"Lai/tock/duckling/service/DucklingVerticle$ParseRequest;", "", "language", "", "dimensions", "", "referenceDate", "Ljava/time/ZonedDateTime;", "referenceTimezone", "Ljava/time/ZoneId;", "textToParse", "(Ljava/lang/String;Ljava/util/List;Ljava/time/ZonedDateTime;Ljava/time/ZoneId;Ljava/lang/String;)V", "getDimensions", "()Ljava/util/List;", "getLanguage", "()Ljava/lang/String;", "getReferenceDate", "()Ljava/time/ZonedDateTime;", "getReferenceTimezone", "()Ljava/time/ZoneId;", "getTextToParse", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "tock-nlp-duckling-service"})
    public static final class ParseRequest {
        @NotNull
        private final String language;
        @NotNull
        private final List<String> dimensions;
        @NotNull
        private final ZonedDateTime referenceDate;
        @NotNull
        private final ZoneId referenceTimezone;
        @NotNull
        private final String textToParse;

        public ParseRequest(@NotNull String language, @NotNull List<String> dimensions, @NotNull ZonedDateTime referenceDate, @NotNull ZoneId referenceTimezone, @NotNull String textToParse) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter(dimensions, (String)"dimensions");
            Intrinsics.checkNotNullParameter((Object)referenceDate, (String)"referenceDate");
            Intrinsics.checkNotNullParameter((Object)referenceTimezone, (String)"referenceTimezone");
            Intrinsics.checkNotNullParameter((Object)textToParse, (String)"textToParse");
            this.language = language;
            this.dimensions = dimensions;
            this.referenceDate = referenceDate;
            this.referenceTimezone = referenceTimezone;
            this.textToParse = textToParse;
        }

        @NotNull
        public final String getLanguage() {
            return this.language;
        }

        @NotNull
        public final List<String> getDimensions() {
            return this.dimensions;
        }

        @NotNull
        public final ZonedDateTime getReferenceDate() {
            return this.referenceDate;
        }

        @NotNull
        public final ZoneId getReferenceTimezone() {
            return this.referenceTimezone;
        }

        @NotNull
        public final String getTextToParse() {
            return this.textToParse;
        }

        @NotNull
        public final String component1() {
            return this.language;
        }

        @NotNull
        public final List<String> component2() {
            return this.dimensions;
        }

        @NotNull
        public final ZonedDateTime component3() {
            return this.referenceDate;
        }

        @NotNull
        public final ZoneId component4() {
            return this.referenceTimezone;
        }

        @NotNull
        public final String component5() {
            return this.textToParse;
        }

        @NotNull
        public final ParseRequest copy(@NotNull String language, @NotNull List<String> dimensions, @NotNull ZonedDateTime referenceDate, @NotNull ZoneId referenceTimezone, @NotNull String textToParse) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter(dimensions, (String)"dimensions");
            Intrinsics.checkNotNullParameter((Object)referenceDate, (String)"referenceDate");
            Intrinsics.checkNotNullParameter((Object)referenceTimezone, (String)"referenceTimezone");
            Intrinsics.checkNotNullParameter((Object)textToParse, (String)"textToParse");
            return new ParseRequest(language, dimensions, referenceDate, referenceTimezone, textToParse);
        }

        public static /* synthetic */ ParseRequest copy$default(ParseRequest parseRequest, String string, List list, ZonedDateTime zonedDateTime, ZoneId zoneId, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = parseRequest.language;
            }
            if ((n & 2) != 0) {
                list = parseRequest.dimensions;
            }
            if ((n & 4) != 0) {
                zonedDateTime = parseRequest.referenceDate;
            }
            if ((n & 8) != 0) {
                zoneId = parseRequest.referenceTimezone;
            }
            if ((n & 0x10) != 0) {
                string2 = parseRequest.textToParse;
            }
            return parseRequest.copy(string, list, zonedDateTime, zoneId, string2);
        }

        @NotNull
        public String toString() {
            return "ParseRequest(language=" + this.language + ", dimensions=" + this.dimensions + ", referenceDate=" + this.referenceDate + ", referenceTimezone=" + this.referenceTimezone + ", textToParse=" + this.textToParse + ")";
        }

        public int hashCode() {
            int result = this.language.hashCode();
            result = result * 31 + ((Object)this.dimensions).hashCode();
            result = result * 31 + this.referenceDate.hashCode();
            result = result * 31 + this.referenceTimezone.hashCode();
            result = result * 31 + this.textToParse.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParseRequest)) {
                return false;
            }
            ParseRequest parseRequest = (ParseRequest)other;
            if (!Intrinsics.areEqual((Object)this.language, (Object)parseRequest.language)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.dimensions, parseRequest.dimensions)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.referenceDate, (Object)parseRequest.referenceDate)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.referenceTimezone, (Object)parseRequest.referenceTimezone)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.textToParse, (Object)parseRequest.textToParse);
        }
    }
}

