/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.entity.rest;

import ai.tock.nlp.core.EntityType;
import ai.tock.nlp.core.service.entity.EntityTypeRecognition;
import ai.tock.nlp.core.service.entity.EntityTypeValue;
import ai.tock.nlp.entity.rest.RestEntityTypeClient;
import ai.tock.shared.LocalesKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\b\u0018\u0000 \u00112\u00020\u0001:\u0007\u0011\u0012\u0013\u0014\u0015\u0016\u0017B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lai/tock/nlp/entity/rest/RestEntityTypeClient;", "", "targetUrl", "", "(Ljava/lang/String;)V", "api", "Lai/tock/nlp/entity/rest/RestEntityTypeClient$EntityTypeApi;", "healthcheck", "", "parse", "", "Lai/tock/nlp/core/service/entity/EntityTypeRecognition;", "text", "language", "Ljava/util/Locale;", "retrieveSupportedEntityTypes", "", "Companion", "EntityDescription", "EntityResponse", "EntityTypeApi", "EntityTypeDescription", "EntityTypeRequest", "EntityTypeResponse", "tock-nlp-entity-rest"})
public final class RestEntityTypeClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EntityTypeApi api;
    private static final long timeoutInSeconds = PropertiesKt.longProperty((String)"tock_bot_rest_timeout_in_ms", (long)10000L);
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);

    public RestEntityTypeClient(@NotNull String targetUrl) {
        Intrinsics.checkNotNullParameter((Object)targetUrl, (String)"targetUrl");
        Retrofit retrofit = RetrofitsKt.addJacksonConverter$default((Retrofit.Builder)RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)timeoutInSeconds, null, null, null, (boolean)false, (boolean)false, null, (int)126, null), null, (int)1, null).baseUrl(targetUrl).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"retrofitBuilderWithTimeo\u2026Url)\n            .build()");
        Retrofit $this$create$iv = retrofit;
        boolean $i$f$create = false;
        this.api = (EntityTypeApi)$this$create$iv.create(EntityTypeApi.class);
    }

    public /* synthetic */ RestEntityTypeClient(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = PropertiesKt.property((String)"tock_nlp_entity_type_url", (String)"http://localhost:5000/app/v1/");
        }
        this(string);
    }

    @NotNull
    public final Set<String> retrieveSupportedEntityTypes() {
        Set set;
        try {
            Set set2 = (Set)this.api.supportedEntityTypes().execute().body();
            if (set2 == null) {
                set2 = SetsKt.emptySet();
            }
            set = set2;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
            set = SetsKt.emptySet();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EntityTypeRecognition> parse(@NotNull String text, @NotNull Locale language) {
        List list;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        try {
            List list2;
            EntityTypeResponse entityTypeResponse = (EntityTypeResponse)this.api.parse(new EntityTypeRequest(text, language)).execute().body();
            if (entityTypeResponse == null) {
                list2 = null;
            } else {
                List<EntityResponse> list3 = entityTypeResponse.getEntities();
                if (list3 == null) {
                    list2 = null;
                } else {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = list3;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        EntityResponse entityResponse = (EntityResponse)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(new EntityTypeRecognition(new EntityTypeValue(it.getEntity().getStart(), it.getEntity().getEnd(), new EntityType(it.getEntity().getType().getName(), null, false, false, 14, null), null, false, 24, null), it.getProbability()));
                    }
                    list2 = (List)destination$iv$iv;
                }
            }
            list = list2;
            list = list == null ? CollectionsKt.emptyList() : list;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final boolean healthcheck() {
        boolean bl;
        try {
            bl = this.api.healthcheck().execute().isSuccessful();
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    public RestEntityTypeClient() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lai/tock/nlp/entity/rest/RestEntityTypeClient$EntityTypeRequest;", "", "text", "", "language", "Ljava/util/Locale;", "(Ljava/lang/String;Ljava/util/Locale;)V", "getLanguage", "()Ljava/util/Locale;", "getText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "tock-nlp-entity-rest"})
    public static final class EntityTypeRequest {
        @NotNull
        private final String text;
        @NotNull
        private final Locale language;

        public EntityTypeRequest(@NotNull String text, @NotNull Locale language) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            this.text = text;
            this.language = language;
        }

        public /* synthetic */ EntityTypeRequest(String string, Locale locale, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                locale = LocalesKt.getDefaultLocale();
            }
            this(string, locale);
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final Locale getLanguage() {
            return this.language;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final Locale component2() {
            return this.language;
        }

        @NotNull
        public final EntityTypeRequest copy(@NotNull String text, @NotNull Locale language) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            return new EntityTypeRequest(text, language);
        }

        public static /* synthetic */ EntityTypeRequest copy$default(EntityTypeRequest entityTypeRequest, String string, Locale locale, int n, Object object) {
            if ((n & 1) != 0) {
                string = entityTypeRequest.text;
            }
            if ((n & 2) != 0) {
                locale = entityTypeRequest.language;
            }
            return entityTypeRequest.copy(string, locale);
        }

        @NotNull
        public String toString() {
            return "EntityTypeRequest(text=" + this.text + ", language=" + this.language + ')';
        }

        public int hashCode() {
            int result = this.text.hashCode();
            result = result * 31 + this.language.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EntityTypeRequest)) {
                return false;
            }
            EntityTypeRequest entityTypeRequest = (EntityTypeRequest)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)entityTypeRequest.text)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.language, (Object)entityTypeRequest.language);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lai/tock/nlp/entity/rest/RestEntityTypeClient$EntityTypeResponse;", "", "entities", "", "Lai/tock/nlp/entity/rest/RestEntityTypeClient$EntityResponse;", "(Ljava/util/List;)V", "getEntities", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "tock-nlp-entity-rest"})
    public static final class EntityTypeResponse {
        @NotNull
        private final List<EntityResponse> entities;

        public EntityTypeResponse(@NotNull List<EntityResponse> entities) {
            Intrinsics.checkNotNullParameter(entities, (String)"entities");
            this.entities = entities;
        }

        @NotNull
        public final List<EntityResponse> getEntities() {
            return this.entities;
        }

        @NotNull
        public final List<EntityResponse> component1() {
            return this.entities;
        }

        @NotNull
        public final EntityTypeResponse copy(@NotNull List<EntityResponse> entities) {
            Intrinsics.checkNotNullParameter(entities, (String)"entities");
            return new EntityTypeResponse(entities);
        }

        public static /* synthetic */ EntityTypeResponse copy$default(EntityTypeResponse entityTypeResponse, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = entityTypeResponse.entities;
            }
            return entityTypeResponse.copy(list);
        }

        @NotNull
        public String toString() {
            return "EntityTypeResponse(entities=" + this.entities + ')';
        }

        public int hashCode() {
            return ((Object)this.entities).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EntityTypeResponse)) {
                return false;
            }
            EntityTypeResponse entityTypeResponse = (EntityTypeResponse)other;
            return Intrinsics.areEqual(this.entities, entityTypeResponse.entities);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lai/tock/nlp/entity/rest/RestEntityTypeClient$EntityResponse;", "", "entity", "Lai/tock/nlp/entity/rest/RestEntityTypeClient$EntityDescription;", "probability", "", "(Lai/tock/nlp/entity/rest/RestEntityTypeClient$EntityDescription;D)V", "getEntity", "()Lai/tock/nlp/entity/rest/RestEntityTypeClient$EntityDescription;", "getProbability", "()D", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "tock-nlp-entity-rest"})
    public static final class EntityResponse {
        @NotNull
        private final EntityDescription entity;
        private final double probability;

        public EntityResponse(@NotNull EntityDescription entity, double probability) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            this.entity = entity;
            this.probability = probability;
        }

        public /* synthetic */ EntityResponse(EntityDescription entityDescription, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                d = 1.0;
            }
            this(entityDescription, d);
        }

        @NotNull
        public final EntityDescription getEntity() {
            return this.entity;
        }

        public final double getProbability() {
            return this.probability;
        }

        @NotNull
        public final EntityDescription component1() {
            return this.entity;
        }

        public final double component2() {
            return this.probability;
        }

        @NotNull
        public final EntityResponse copy(@NotNull EntityDescription entity, double probability) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            return new EntityResponse(entity, probability);
        }

        public static /* synthetic */ EntityResponse copy$default(EntityResponse entityResponse, EntityDescription entityDescription, double d, int n, Object object) {
            if ((n & 1) != 0) {
                entityDescription = entityResponse.entity;
            }
            if ((n & 2) != 0) {
                d = entityResponse.probability;
            }
            return entityResponse.copy(entityDescription, d);
        }

        @NotNull
        public String toString() {
            return "EntityResponse(entity=" + this.entity + ", probability=" + this.probability + ')';
        }

        public int hashCode() {
            int result = this.entity.hashCode();
            result = result * 31 + Double.hashCode(this.probability);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EntityResponse)) {
                return false;
            }
            EntityResponse entityResponse = (EntityResponse)other;
            if (!Intrinsics.areEqual((Object)this.entity, (Object)entityResponse.entity)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.probability, (Object)entityResponse.probability);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lai/tock/nlp/entity/rest/RestEntityTypeClient$EntityDescription;", "", "start", "", "end", "type", "Lai/tock/nlp/entity/rest/RestEntityTypeClient$EntityTypeDescription;", "(IILai/tock/nlp/entity/rest/RestEntityTypeClient$EntityTypeDescription;)V", "getEnd", "()I", "getStart", "getType", "()Lai/tock/nlp/entity/rest/RestEntityTypeClient$EntityTypeDescription;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "tock-nlp-entity-rest"})
    public static final class EntityDescription {
        private final int start;
        private final int end;
        @NotNull
        private final EntityTypeDescription type;

        public EntityDescription(int start, int end, @NotNull EntityTypeDescription type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.start = start;
            this.end = end;
            this.type = type;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        @NotNull
        public final EntityTypeDescription getType() {
            return this.type;
        }

        public final int component1() {
            return this.start;
        }

        public final int component2() {
            return this.end;
        }

        @NotNull
        public final EntityTypeDescription component3() {
            return this.type;
        }

        @NotNull
        public final EntityDescription copy(int start, int end, @NotNull EntityTypeDescription type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new EntityDescription(start, end, type);
        }

        public static /* synthetic */ EntityDescription copy$default(EntityDescription entityDescription, int n, int n2, EntityTypeDescription entityTypeDescription, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = entityDescription.start;
            }
            if ((n3 & 2) != 0) {
                n2 = entityDescription.end;
            }
            if ((n3 & 4) != 0) {
                entityTypeDescription = entityDescription.type;
            }
            return entityDescription.copy(n, n2, entityTypeDescription);
        }

        @NotNull
        public String toString() {
            return "EntityDescription(start=" + this.start + ", end=" + this.end + ", type=" + this.type + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.start);
            result = result * 31 + Integer.hashCode(this.end);
            result = result * 31 + this.type.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EntityDescription)) {
                return false;
            }
            EntityDescription entityDescription = (EntityDescription)other;
            if (this.start != entityDescription.start) {
                return false;
            }
            if (this.end != entityDescription.end) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.type, (Object)entityDescription.type);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lai/tock/nlp/entity/rest/RestEntityTypeClient$EntityTypeDescription;", "", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "tock-nlp-entity-rest"})
    public static final class EntityTypeDescription {
        @NotNull
        private final String name;

        public EntityTypeDescription(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final EntityTypeDescription copy(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new EntityTypeDescription(name);
        }

        public static /* synthetic */ EntityTypeDescription copy$default(EntityTypeDescription entityTypeDescription, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = entityTypeDescription.name;
            }
            return entityTypeDescription.copy(string);
        }

        @NotNull
        public String toString() {
            return "EntityTypeDescription(name=" + this.name + ')';
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EntityTypeDescription)) {
                return false;
            }
            EntityTypeDescription entityTypeDescription = (EntityTypeDescription)other;
            return Intrinsics.areEqual((Object)this.name, (Object)entityTypeDescription.name);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\bb\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H'J\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\b\b\u0001\u0010\u0007\u001a\u00020\bH'J\u0014\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0003H'\u00a8\u0006\f"}, d2={"Lai/tock/nlp/entity/rest/RestEntityTypeClient$EntityTypeApi;", "", "healthcheck", "Lretrofit2/Call;", "Lokhttp3/ResponseBody;", "parse", "Lai/tock/nlp/entity/rest/RestEntityTypeClient$EntityTypeResponse;", "testPlan", "Lai/tock/nlp/entity/rest/RestEntityTypeClient$EntityTypeRequest;", "supportedEntityTypes", "", "", "tock-nlp-entity-rest"})
    private static interface EntityTypeApi {
        @Headers(value={"Content-Type:application/json"})
        @GET(value="entities")
        @NotNull
        public Call<Set<String>> supportedEntityTypes();

        @Headers(value={"Content-Type:application/json"})
        @POST(value="parse")
        @NotNull
        public Call<EntityTypeResponse> parse(@Body @NotNull EntityTypeRequest var1);

        @GET(value="healthcheck")
        @NotNull
        public Call<ResponseBody> healthcheck();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lai/tock/nlp/entity/rest/RestEntityTypeClient$Companion;", "", "()V", "logger", "Lmu/KLogger;", "timeoutInSeconds", "", "tock-nlp-entity-rest"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

