/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.entity.date;

import ai.tock.nlp.entity.date.DateEntityGrain$WhenMappings;
import java.time.DayOfWeek;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0001\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001aB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lai/tock/nlp/entity/date/DateEntityGrain;", "", "time", "", "(Ljava/lang/String;IZ)V", "getTime", "()Z", "calculateEnd", "Ljava/time/ZonedDateTime;", "start", "zoneId", "Ljava/time/ZoneId;", "calculateInclusiveEnd", "truncate", "date", "timezone", "unknown", "second", "minute", "hour", "day_of_week", "day", "week", "month", "quarter", "year", "Companion", "tock-nlp-entity-value"})
public final class DateEntityGrain
extends Enum<DateEntityGrain> {
    public static final /* enum */ DateEntityGrain timezone;
    public static final /* enum */ DateEntityGrain unknown;
    public static final /* enum */ DateEntityGrain second;
    public static final /* enum */ DateEntityGrain minute;
    public static final /* enum */ DateEntityGrain hour;
    public static final /* enum */ DateEntityGrain day_of_week;
    public static final /* enum */ DateEntityGrain day;
    public static final /* enum */ DateEntityGrain week;
    public static final /* enum */ DateEntityGrain month;
    public static final /* enum */ DateEntityGrain quarter;
    public static final /* enum */ DateEntityGrain year;
    private static final /* synthetic */ DateEntityGrain[] $VALUES;
    private final boolean time;
    @NotNull
    public static final Companion Companion;

    static {
        DateEntityGrain[] dateEntityGrainArray = new DateEntityGrain[11];
        DateEntityGrain[] dateEntityGrainArray2 = dateEntityGrainArray;
        dateEntityGrainArray[0] = timezone = new DateEntityGrain(false);
        dateEntityGrainArray[1] = unknown = new DateEntityGrain(false);
        dateEntityGrainArray[2] = second = new DateEntityGrain(true);
        dateEntityGrainArray[3] = minute = new DateEntityGrain(true);
        dateEntityGrainArray[4] = hour = new DateEntityGrain(true);
        dateEntityGrainArray[5] = day_of_week = new DateEntityGrain(false);
        dateEntityGrainArray[6] = day = new DateEntityGrain(false);
        dateEntityGrainArray[7] = week = new DateEntityGrain(false);
        dateEntityGrainArray[8] = month = new DateEntityGrain(false);
        dateEntityGrainArray[9] = quarter = new DateEntityGrain(false);
        dateEntityGrainArray[10] = year = new DateEntityGrain(false);
        $VALUES = dateEntityGrainArray;
        Companion = new Companion(null);
    }

    @NotNull
    public final ZonedDateTime truncate(@NotNull ZonedDateTime date) {
        ZonedDateTime zonedDateTime;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        try {
            ZonedDateTime zonedDateTime2;
            switch (DateEntityGrain$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    zonedDateTime2 = date.truncatedTo(ChronoUnit.SECONDS);
                    break;
                }
                case 2: {
                    zonedDateTime2 = date.truncatedTo(ChronoUnit.MINUTES);
                    break;
                }
                case 3: {
                    zonedDateTime2 = date.truncatedTo(ChronoUnit.HOURS);
                    break;
                }
                case 4: 
                case 5: {
                    zonedDateTime2 = date.truncatedTo(ChronoUnit.DAYS);
                    break;
                }
                case 6: {
                    zonedDateTime2 = date.with(TemporalAdjusters.previous(DayOfWeek.MONDAY)).truncatedTo(ChronoUnit.DAYS);
                    break;
                }
                case 7: {
                    zonedDateTime2 = date.with(TemporalAdjusters.firstDayOfMonth()).truncatedTo(ChronoUnit.DAYS);
                    break;
                }
                case 8: {
                    zonedDateTime2 = date.with(TemporalAdjusters.firstDayOfMonth()).truncatedTo(ChronoUnit.DAYS);
                    break;
                }
                case 9: {
                    zonedDateTime2 = date.with(TemporalAdjusters.firstDayOfYear()).truncatedTo(ChronoUnit.DAYS);
                    break;
                }
                default: {
                    zonedDateTime2 = date;
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"when (this) {\n          \u2026lse -> date\n            }");
            zonedDateTime = zonedDateTime2;
        }
        catch (Exception e) {
            zonedDateTime = date;
        }
        return zonedDateTime;
    }

    @NotNull
    public final ZonedDateTime calculateInclusiveEnd(@NotNull ZonedDateTime start, @NotNull ZoneId zoneId) {
        ZonedDateTime zonedDateTime;
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        ZonedDateTime s = this.calculateEnd(start, zoneId);
        switch (DateEntityGrain$WhenMappings.$EnumSwitchMapping$1[this.ordinal()]) {
            case 1: {
                ZonedDateTime zonedDateTime2 = s.minusSeconds(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"s.minusSeconds(1)");
                zonedDateTime = this.truncate(zonedDateTime2);
                break;
            }
            case 2: {
                ZonedDateTime zonedDateTime3 = s.minusMinutes(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime3, (String)"s.minusMinutes(1)");
                zonedDateTime = this.truncate(zonedDateTime3);
                break;
            }
            case 3: {
                ZonedDateTime zonedDateTime4 = s.minusHours(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime4, (String)"s.minusHours(1)");
                zonedDateTime = this.truncate(zonedDateTime4);
                break;
            }
            case 4: 
            case 5: {
                ZonedDateTime zonedDateTime5 = s.minusDays(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime5, (String)"s.minusDays(1)");
                zonedDateTime = this.truncate(zonedDateTime5);
                break;
            }
            case 6: {
                ZonedDateTime zonedDateTime6 = s.minusWeeks(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime6, (String)"s.minusWeeks(1)");
                zonedDateTime = this.truncate(zonedDateTime6);
                break;
            }
            case 7: {
                ZonedDateTime zonedDateTime7 = s.minusMonths(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime7, (String)"s.minusMonths(1)");
                zonedDateTime = this.truncate(zonedDateTime7);
                break;
            }
            case 8: {
                ZonedDateTime zonedDateTime8 = s.minusMonths(3L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime8, (String)"s.minusMonths(3)");
                zonedDateTime = this.truncate(zonedDateTime8);
                break;
            }
            case 9: {
                ZonedDateTime zonedDateTime9 = s.minusYears(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime9, (String)"s.minusYears(1)");
                zonedDateTime = this.truncate(zonedDateTime9);
                break;
            }
            default: {
                zonedDateTime = s;
            }
        }
        return zonedDateTime;
    }

    @NotNull
    public final ZonedDateTime calculateEnd(@NotNull ZonedDateTime start, @NotNull ZoneId zoneId) {
        ZonedDateTime zonedDateTime;
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        ZonedDateTime s = start.withZoneSameInstant(zoneId);
        switch (DateEntityGrain$WhenMappings.$EnumSwitchMapping$2[this.ordinal()]) {
            case 1: {
                ZonedDateTime zonedDateTime2 = s.plusSeconds(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"s.plusSeconds(1)");
                zonedDateTime = this.truncate(zonedDateTime2);
                break;
            }
            case 2: {
                ZonedDateTime zonedDateTime3 = s.plusMinutes(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime3, (String)"s.plusMinutes(1)");
                zonedDateTime = this.truncate(zonedDateTime3);
                break;
            }
            case 3: {
                ZonedDateTime zonedDateTime4 = s.plusHours(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime4, (String)"s.plusHours(1)");
                zonedDateTime = this.truncate(zonedDateTime4);
                break;
            }
            case 4: 
            case 5: {
                ZonedDateTime zonedDateTime5 = s.plusDays(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime5, (String)"s.plusDays(1)");
                zonedDateTime = this.truncate(zonedDateTime5);
                break;
            }
            case 6: {
                ZonedDateTime zonedDateTime6 = s.plusWeeks(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime6, (String)"s.plusWeeks(1)");
                zonedDateTime = this.truncate(zonedDateTime6);
                break;
            }
            case 7: {
                ZonedDateTime zonedDateTime7 = s.plusMonths(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime7, (String)"s.plusMonths(1)");
                zonedDateTime = this.truncate(zonedDateTime7);
                break;
            }
            case 8: {
                ZonedDateTime zonedDateTime8 = s.plusMonths(3L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime8, (String)"s.plusMonths(3)");
                zonedDateTime = this.truncate(zonedDateTime8);
                break;
            }
            case 9: {
                ZonedDateTime zonedDateTime9 = s.plusYears(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime9, (String)"s.plusYears(1)");
                zonedDateTime = this.truncate(zonedDateTime9);
                break;
            }
            default: {
                ZonedDateTime zonedDateTime10 = s;
                zonedDateTime = zonedDateTime10;
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime10, (String)"s");
            }
        }
        return zonedDateTime;
    }

    public final boolean getTime() {
        return this.time;
    }

    private DateEntityGrain(boolean time) {
        this.time = time;
    }

    public static DateEntityGrain[] values() {
        return (DateEntityGrain[])$VALUES.clone();
    }

    public static DateEntityGrain valueOf(String string) {
        return Enum.valueOf(DateEntityGrain.class, string);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lai/tock/nlp/entity/date/DateEntityGrain$Companion;", "", "()V", "from", "Lai/tock/nlp/entity/date/DateEntityGrain;", "s", "", "maxGrain", "start", "Ljava/time/ZonedDateTime;", "end", "tock-nlp-entity-value"})
    public static final class Companion {
        @NotNull
        public final DateEntityGrain from(@Nullable String s) {
            try {
                return s == null ? unknown : DateEntityGrain.valueOf(s);
            }
            catch (Exception e) {
                return unknown;
            }
        }

        @NotNull
        public final DateEntityGrain maxGrain(@NotNull ZonedDateTime start, @NotNull ZonedDateTime end) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            return start.plusSeconds(1L).compareTo(end) >= 0 ? second : (start.truncatedTo(ChronoUnit.MINUTES).plusMinutes(1L).compareTo(end.truncatedTo(ChronoUnit.MINUTES)) >= 0 ? minute : (start.truncatedTo(ChronoUnit.HOURS).plusHours(1L).compareTo(end.truncatedTo(ChronoUnit.HOURS)) >= 0 ? hour : (start.truncatedTo(ChronoUnit.DAYS).plusDays(1L).compareTo(end.truncatedTo(ChronoUnit.DAYS)) >= 0 ? day : (start.truncatedTo(ChronoUnit.DAYS).plusWeeks(1L).compareTo(end.truncatedTo(ChronoUnit.DAYS)) >= 0 ? week : (start.truncatedTo(ChronoUnit.MONTHS).plusMonths(1L).compareTo(end.truncatedTo(ChronoUnit.MONTHS)) >= 0 ? month : year)))));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

