/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.entity.date;

import ai.tock.nlp.entity.date.DateEntityGrain;
import ai.tock.nlp.entity.date.DateEntityRange;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lai/tock/nlp/entity/date/DateEntityValue;", "Lai/tock/nlp/entity/date/DateEntityRange;", "date", "Ljava/time/ZonedDateTime;", "grain", "Lai/tock/nlp/entity/date/DateEntityGrain;", "(Ljava/time/ZonedDateTime;Lai/tock/nlp/entity/date/DateEntityGrain;)V", "getDate", "()Ljava/time/ZonedDateTime;", "getGrain", "()Lai/tock/nlp/entity/date/DateEntityGrain;", "component1", "component2", "copy", "duration", "Ljava/time/Duration;", "end", "zoneId", "Ljava/time/ZoneId;", "equals", "", "other", "", "hashCode", "", "start", "toString", "", "tock-nlp-entity-value"})
public final class DateEntityValue
implements DateEntityRange {
    @NotNull
    private final ZonedDateTime date;
    @NotNull
    private final DateEntityGrain grain;

    @Override
    @NotNull
    public ZonedDateTime start() {
        return this.date;
    }

    @Override
    @NotNull
    public ZonedDateTime end(@NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        return this.grain.calculateEnd(this.date, zoneId);
    }

    @Override
    @NotNull
    public Duration duration() {
        Temporal temporal = this.grain.truncate(this.date);
        ZoneId zoneId = this.date.getZone();
        Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"date.zone");
        Duration duration = Duration.between(temporal, this.grain.truncate(this.end(zoneId)));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.between(grain.t\u2026truncate(end(date.zone)))");
        return duration;
    }

    @NotNull
    public final ZonedDateTime getDate() {
        return this.date;
    }

    @NotNull
    public final DateEntityGrain getGrain() {
        return this.grain;
    }

    public DateEntityValue(@NotNull ZonedDateTime date, @NotNull DateEntityGrain grain) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)((Object)grain), (String)"grain");
        this.date = date;
        this.grain = grain;
    }

    @Override
    @NotNull
    public ZonedDateTime end() {
        return DateEntityRange.DefaultImpls.end(this);
    }

    @Override
    @NotNull
    public ZonedDateTime inclusiveEnd() {
        return DateEntityRange.DefaultImpls.inclusiveEnd(this);
    }

    @Override
    @NotNull
    public ZonedDateTime inclusiveEnd(@NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        return DateEntityRange.DefaultImpls.inclusiveEnd(this, zoneId);
    }

    @NotNull
    public final ZonedDateTime component1() {
        return this.date;
    }

    @NotNull
    public final DateEntityGrain component2() {
        return this.grain;
    }

    @NotNull
    public final DateEntityValue copy(@NotNull ZonedDateTime date, @NotNull DateEntityGrain grain) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)((Object)grain), (String)"grain");
        return new DateEntityValue(date, grain);
    }

    public static /* synthetic */ DateEntityValue copy$default(DateEntityValue dateEntityValue, ZonedDateTime zonedDateTime, DateEntityGrain dateEntityGrain, int n, Object object) {
        if ((n & 1) != 0) {
            zonedDateTime = dateEntityValue.date;
        }
        if ((n & 2) != 0) {
            dateEntityGrain = dateEntityValue.grain;
        }
        return dateEntityValue.copy(zonedDateTime, dateEntityGrain);
    }

    @NotNull
    public String toString() {
        return "DateEntityValue(date=" + this.date + ", grain=" + (Object)((Object)this.grain) + ")";
    }

    public int hashCode() {
        ZonedDateTime zonedDateTime = this.date;
        DateEntityGrain dateEntityGrain = this.grain;
        return (zonedDateTime != null ? ((Object)zonedDateTime).hashCode() : 0) * 31 + (dateEntityGrain != null ? ((Object)((Object)dateEntityGrain)).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DateEntityValue)) break block3;
                DateEntityValue dateEntityValue = (DateEntityValue)object;
                if (!Intrinsics.areEqual((Object)this.date, (Object)dateEntityValue.date) || !Intrinsics.areEqual((Object)((Object)this.grain), (Object)((Object)dateEntityValue.grain))) break block3;
            }
            return true;
        }
        return false;
    }
}

