/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.entity.date;

import java.time.DayOfWeek;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001bB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u0016\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u001c"}, d2={"Lai/tock/nlp/entity/date/DateEntityGrain;", "", "time", "", "<init>", "(Ljava/lang/String;IZ)V", "getTime", "()Z", "timezone", "unknown", "second", "minute", "hour", "day_of_week", "day", "week", "month", "quarter", "year", "truncate", "Ljava/time/ZonedDateTime;", "date", "calculateInclusiveEnd", "start", "zoneId", "Ljava/time/ZoneId;", "calculateEnd", "Companion", "tock-nlp-entity-value"})
public final class DateEntityGrain
extends Enum<DateEntityGrain> {
    @NotNull
    public static final Companion Companion;
    private final boolean time;
    public static final /* enum */ DateEntityGrain timezone;
    public static final /* enum */ DateEntityGrain unknown;
    public static final /* enum */ DateEntityGrain second;
    public static final /* enum */ DateEntityGrain minute;
    public static final /* enum */ DateEntityGrain hour;
    public static final /* enum */ DateEntityGrain day_of_week;
    public static final /* enum */ DateEntityGrain day;
    public static final /* enum */ DateEntityGrain week;
    public static final /* enum */ DateEntityGrain month;
    public static final /* enum */ DateEntityGrain quarter;
    public static final /* enum */ DateEntityGrain year;
    private static final /* synthetic */ DateEntityGrain[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private DateEntityGrain(boolean time) {
        this.time = time;
    }

    public final boolean getTime() {
        return this.time;
    }

    @NotNull
    public final ZonedDateTime truncate(@NotNull ZonedDateTime date) {
        ZonedDateTime zonedDateTime;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        try {
            ZonedDateTime zonedDateTime2;
            switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    zonedDateTime2 = date.truncatedTo(ChronoUnit.SECONDS);
                    break;
                }
                case 2: {
                    zonedDateTime2 = date.truncatedTo(ChronoUnit.MINUTES);
                    break;
                }
                case 3: {
                    zonedDateTime2 = date.truncatedTo(ChronoUnit.HOURS);
                    break;
                }
                case 4: 
                case 5: {
                    zonedDateTime2 = date.truncatedTo(ChronoUnit.DAYS);
                    break;
                }
                case 6: {
                    zonedDateTime2 = date.with(TemporalAdjusters.previous(DayOfWeek.MONDAY)).truncatedTo(ChronoUnit.DAYS);
                    break;
                }
                case 7: {
                    zonedDateTime2 = date.with(TemporalAdjusters.firstDayOfMonth()).truncatedTo(ChronoUnit.DAYS);
                    break;
                }
                case 8: {
                    zonedDateTime2 = date.with(TemporalAdjusters.firstDayOfMonth()).truncatedTo(ChronoUnit.DAYS);
                    break;
                }
                case 9: {
                    zonedDateTime2 = date.with(TemporalAdjusters.firstDayOfYear()).truncatedTo(ChronoUnit.DAYS);
                    break;
                }
                default: {
                    zonedDateTime2 = date;
                }
            }
            zonedDateTime = zonedDateTime2;
        }
        catch (Exception e) {
            zonedDateTime = date;
        }
        return zonedDateTime;
    }

    @NotNull
    public final ZonedDateTime calculateInclusiveEnd(@NotNull ZonedDateTime start, @NotNull ZoneId zoneId) {
        ZonedDateTime zonedDateTime;
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        ZonedDateTime s = this.calculateEnd(start, zoneId);
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                ZonedDateTime zonedDateTime2 = s.minusSeconds(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"minusSeconds(...)");
                zonedDateTime = this.truncate(zonedDateTime2);
                break;
            }
            case 2: {
                ZonedDateTime zonedDateTime3 = s.minusMinutes(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime3, (String)"minusMinutes(...)");
                zonedDateTime = this.truncate(zonedDateTime3);
                break;
            }
            case 3: {
                ZonedDateTime zonedDateTime4 = s.minusHours(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime4, (String)"minusHours(...)");
                zonedDateTime = this.truncate(zonedDateTime4);
                break;
            }
            case 4: 
            case 5: {
                ZonedDateTime zonedDateTime5 = s.minusDays(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime5, (String)"minusDays(...)");
                zonedDateTime = this.truncate(zonedDateTime5);
                break;
            }
            case 6: {
                ZonedDateTime zonedDateTime6 = s.minusWeeks(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime6, (String)"minusWeeks(...)");
                zonedDateTime = this.truncate(zonedDateTime6);
                break;
            }
            case 7: {
                ZonedDateTime zonedDateTime7 = s.minusMonths(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime7, (String)"minusMonths(...)");
                zonedDateTime = this.truncate(zonedDateTime7);
                break;
            }
            case 8: {
                ZonedDateTime zonedDateTime8 = s.minusMonths(3L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime8, (String)"minusMonths(...)");
                zonedDateTime = this.truncate(zonedDateTime8);
                break;
            }
            case 9: {
                ZonedDateTime zonedDateTime9 = s.minusYears(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime9, (String)"minusYears(...)");
                zonedDateTime = this.truncate(zonedDateTime9);
                break;
            }
            default: {
                zonedDateTime = s;
            }
        }
        return zonedDateTime;
    }

    @NotNull
    public final ZonedDateTime calculateEnd(@NotNull ZonedDateTime start, @NotNull ZoneId zoneId) {
        ZonedDateTime zonedDateTime;
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        ZonedDateTime s = start.withZoneSameInstant(zoneId);
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                ZonedDateTime zonedDateTime2 = s.plusSeconds(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"plusSeconds(...)");
                zonedDateTime = this.truncate(zonedDateTime2);
                break;
            }
            case 2: {
                ZonedDateTime zonedDateTime3 = s.plusMinutes(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime3, (String)"plusMinutes(...)");
                zonedDateTime = this.truncate(zonedDateTime3);
                break;
            }
            case 3: {
                ZonedDateTime zonedDateTime4 = s.plusHours(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime4, (String)"plusHours(...)");
                zonedDateTime = this.truncate(zonedDateTime4);
                break;
            }
            case 4: 
            case 5: {
                ZonedDateTime zonedDateTime5 = s.plusDays(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime5, (String)"plusDays(...)");
                zonedDateTime = this.truncate(zonedDateTime5);
                break;
            }
            case 6: {
                ZonedDateTime zonedDateTime6 = s.plusWeeks(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime6, (String)"plusWeeks(...)");
                zonedDateTime = this.truncate(zonedDateTime6);
                break;
            }
            case 7: {
                ZonedDateTime zonedDateTime7 = s.plusMonths(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime7, (String)"plusMonths(...)");
                zonedDateTime = this.truncate(zonedDateTime7);
                break;
            }
            case 8: {
                ZonedDateTime zonedDateTime8 = s.plusMonths(3L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime8, (String)"plusMonths(...)");
                zonedDateTime = this.truncate(zonedDateTime8);
                break;
            }
            case 9: {
                ZonedDateTime zonedDateTime9 = s.plusYears(1L);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime9, (String)"plusYears(...)");
                zonedDateTime = this.truncate(zonedDateTime9);
                break;
            }
            default: {
                Intrinsics.checkNotNull((Object)s);
                zonedDateTime = s;
            }
        }
        return zonedDateTime;
    }

    public static DateEntityGrain[] values() {
        return (DateEntityGrain[])$VALUES.clone();
    }

    public static DateEntityGrain valueOf(String value) {
        return Enum.valueOf(DateEntityGrain.class, value);
    }

    @NotNull
    public static EnumEntries<DateEntityGrain> getEntries() {
        return $ENTRIES;
    }

    static {
        timezone = new DateEntityGrain(false);
        unknown = new DateEntityGrain(false);
        second = new DateEntityGrain(true);
        minute = new DateEntityGrain(true);
        hour = new DateEntityGrain(true);
        day_of_week = new DateEntityGrain(false);
        day = new DateEntityGrain(false);
        week = new DateEntityGrain(false);
        month = new DateEntityGrain(false);
        quarter = new DateEntityGrain(false);
        year = new DateEntityGrain(false);
        $VALUES = dateEntityGrainArray = new DateEntityGrain[]{DateEntityGrain.timezone, DateEntityGrain.unknown, DateEntityGrain.second, DateEntityGrain.minute, DateEntityGrain.hour, DateEntityGrain.day_of_week, DateEntityGrain.day, DateEntityGrain.week, DateEntityGrain.month, DateEntityGrain.quarter, DateEntityGrain.year};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u00a8\u0006\f"}, d2={"Lai/tock/nlp/entity/date/DateEntityGrain$Companion;", "", "<init>", "()V", "from", "Lai/tock/nlp/entity/date/DateEntityGrain;", "s", "", "maxGrain", "start", "Ljava/time/ZonedDateTime;", "end", "tock-nlp-entity-value"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DateEntityGrain from(@Nullable String s) {
            try {
                String string = s;
                return string == null ? unknown : DateEntityGrain.valueOf(string);
            }
            catch (Exception e) {
                return unknown;
            }
        }

        @NotNull
        public final DateEntityGrain maxGrain(@NotNull ZonedDateTime start, @NotNull ZonedDateTime end) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            return start.plusSeconds(1L).compareTo(end) >= 0 ? second : (start.truncatedTo(ChronoUnit.MINUTES).plusMinutes(1L).compareTo(end.truncatedTo(ChronoUnit.MINUTES)) >= 0 ? minute : (start.truncatedTo(ChronoUnit.HOURS).plusHours(1L).compareTo(end.truncatedTo(ChronoUnit.HOURS)) >= 0 ? hour : (start.truncatedTo(ChronoUnit.DAYS).plusDays(1L).compareTo(end.truncatedTo(ChronoUnit.DAYS)) >= 0 ? day : (start.truncatedTo(ChronoUnit.DAYS).plusWeeks(1L).compareTo(end.truncatedTo(ChronoUnit.DAYS)) >= 0 ? week : (start.truncatedTo(ChronoUnit.MONTHS).plusMonths(1L).compareTo(end.truncatedTo(ChronoUnit.MONTHS)) >= 0 ? month : year)))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DateEntityGrain.values().length];
            try {
                nArray[DateEntityGrain.second.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateEntityGrain.minute.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateEntityGrain.hour.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateEntityGrain.day_of_week.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateEntityGrain.day.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateEntityGrain.week.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateEntityGrain.month.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateEntityGrain.quarter.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateEntityGrain.year.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

