/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.entity.date;

import java.time.DayOfWeek;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0081\u0002\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001aB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lai/tock/nlp/entity/date/DateEntityGrain;", "", "time", "", "(Ljava/lang/String;IZ)V", "getTime", "()Z", "calculateEnd", "Ljava/time/ZonedDateTime;", "start", "zoneId", "Ljava/time/ZoneId;", "calculateInclusiveEnd", "truncate", "date", "timezone", "unknown", "second", "minute", "hour", "day_of_week", "day", "week", "month", "quarter", "year", "Companion", "tock-nlp-entity-value"})
public final class DateEntityGrain
extends Enum<DateEntityGrain> {
    @NotNull
    public static final Companion Companion;
    private final boolean time;
    public static final /* enum */ DateEntityGrain timezone;
    public static final /* enum */ DateEntityGrain unknown;
    public static final /* enum */ DateEntityGrain second;
    public static final /* enum */ DateEntityGrain minute;
    public static final /* enum */ DateEntityGrain hour;
    public static final /* enum */ DateEntityGrain day_of_week;
    public static final /* enum */ DateEntityGrain day;
    public static final /* enum */ DateEntityGrain week;
    public static final /* enum */ DateEntityGrain month;
    public static final /* enum */ DateEntityGrain quarter;
    public static final /* enum */ DateEntityGrain year;
    private static final /* synthetic */ DateEntityGrain[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private DateEntityGrain(boolean time) {
        this.time = time;
    }

    public final boolean getTime() {
        return this.time;
    }

    @NotNull
    public final ZonedDateTime truncate(@NotNull ZonedDateTime date) {
        ZonedDateTime zonedDateTime;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        try {
            zonedDateTime = switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1 -> date.truncatedTo(ChronoUnit.SECONDS);
                case 2 -> date.truncatedTo(ChronoUnit.MINUTES);
                case 3 -> date.truncatedTo(ChronoUnit.HOURS);
                case 4, 5 -> date.truncatedTo(ChronoUnit.DAYS);
                case 6 -> date.with(TemporalAdjusters.previous(DayOfWeek.MONDAY)).truncatedTo(ChronoUnit.DAYS);
                case 7 -> date.with(TemporalAdjusters.firstDayOfMonth()).truncatedTo(ChronoUnit.DAYS);
                case 8 -> date.with(TemporalAdjusters.firstDayOfMonth()).truncatedTo(ChronoUnit.DAYS);
                case 9 -> date.with(TemporalAdjusters.firstDayOfYear()).truncatedTo(ChronoUnit.DAYS);
                default -> date;
            };
            Intrinsics.checkNotNull((Object)zonedDateTime);
        }
        catch (Exception e) {
            zonedDateTime = date;
        }
        return zonedDateTime;
    }

    @NotNull
    public final ZonedDateTime calculateInclusiveEnd(@NotNull ZonedDateTime start, @NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        ZonedDateTime s = this.calculateEnd(start, zoneId);
        return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1 -> {
                ZonedDateTime v0 = s.minusSeconds(1L);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"minusSeconds(...)");
                yield this.truncate(v0);
            }
            case 2 -> {
                ZonedDateTime v2 = s.minusMinutes(1L);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"minusMinutes(...)");
                yield this.truncate(v2);
            }
            case 3 -> {
                ZonedDateTime v3 = s.minusHours(1L);
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"minusHours(...)");
                yield this.truncate(v3);
            }
            case 4, 5 -> {
                ZonedDateTime v4 = s.minusDays(1L);
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"minusDays(...)");
                yield this.truncate(v4);
            }
            case 6 -> {
                ZonedDateTime v5 = s.minusWeeks(1L);
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"minusWeeks(...)");
                yield this.truncate(v5);
            }
            case 7 -> {
                ZonedDateTime v6 = s.minusMonths(1L);
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"minusMonths(...)");
                yield this.truncate(v6);
            }
            case 8 -> {
                ZonedDateTime v7 = s.minusMonths(3L);
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"minusMonths(...)");
                yield this.truncate(v7);
            }
            case 9 -> {
                ZonedDateTime v8 = s.minusYears(1L);
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"minusYears(...)");
                yield this.truncate(v8);
            }
            default -> s;
        };
    }

    @NotNull
    public final ZonedDateTime calculateEnd(@NotNull ZonedDateTime start, @NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        ZonedDateTime s = start.withZoneSameInstant(zoneId);
        return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1 -> {
                ZonedDateTime v0 = s.plusSeconds(1L);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"plusSeconds(...)");
                yield this.truncate(v0);
            }
            case 2 -> {
                ZonedDateTime v2 = s.plusMinutes(1L);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"plusMinutes(...)");
                yield this.truncate(v2);
            }
            case 3 -> {
                ZonedDateTime v3 = s.plusHours(1L);
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"plusHours(...)");
                yield this.truncate(v3);
            }
            case 4, 5 -> {
                ZonedDateTime v4 = s.plusDays(1L);
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"plusDays(...)");
                yield this.truncate(v4);
            }
            case 6 -> {
                ZonedDateTime v5 = s.plusWeeks(1L);
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"plusWeeks(...)");
                yield this.truncate(v5);
            }
            case 7 -> {
                ZonedDateTime v6 = s.plusMonths(1L);
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"plusMonths(...)");
                yield this.truncate(v6);
            }
            case 8 -> {
                ZonedDateTime v7 = s.plusMonths(3L);
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"plusMonths(...)");
                yield this.truncate(v7);
            }
            case 9 -> {
                ZonedDateTime v8 = s.plusYears(1L);
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"plusYears(...)");
                yield this.truncate(v8);
            }
            default -> {
                Intrinsics.checkNotNull((Object)s);
                yield s;
            }
        };
    }

    public static DateEntityGrain[] values() {
        return (DateEntityGrain[])$VALUES.clone();
    }

    public static DateEntityGrain valueOf(String value) {
        return Enum.valueOf(DateEntityGrain.class, value);
    }

    @NotNull
    public static EnumEntries<DateEntityGrain> getEntries() {
        return $ENTRIES;
    }

    static {
        timezone = new DateEntityGrain(false);
        unknown = new DateEntityGrain(false);
        second = new DateEntityGrain(true);
        minute = new DateEntityGrain(true);
        hour = new DateEntityGrain(true);
        day_of_week = new DateEntityGrain(false);
        day = new DateEntityGrain(false);
        week = new DateEntityGrain(false);
        month = new DateEntityGrain(false);
        quarter = new DateEntityGrain(false);
        year = new DateEntityGrain(false);
        $VALUES = dateEntityGrainArray = new DateEntityGrain[]{DateEntityGrain.timezone, DateEntityGrain.unknown, DateEntityGrain.second, DateEntityGrain.minute, DateEntityGrain.hour, DateEntityGrain.day_of_week, DateEntityGrain.day, DateEntityGrain.week, DateEntityGrain.month, DateEntityGrain.quarter, DateEntityGrain.year};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lai/tock/nlp/entity/date/DateEntityGrain$Companion;", "", "()V", "from", "Lai/tock/nlp/entity/date/DateEntityGrain;", "s", "", "maxGrain", "start", "Ljava/time/ZonedDateTime;", "end", "tock-nlp-entity-value"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DateEntityGrain from(@Nullable String s) {
            try {
                String string = s;
                return string == null ? unknown : DateEntityGrain.valueOf(string);
            }
            catch (Exception e) {
                return unknown;
            }
        }

        @NotNull
        public final DateEntityGrain maxGrain(@NotNull ZonedDateTime start, @NotNull ZonedDateTime end) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            return start.plusSeconds(1L).compareTo(end) >= 0 ? second : (start.truncatedTo(ChronoUnit.MINUTES).plusMinutes(1L).compareTo(end.truncatedTo(ChronoUnit.MINUTES)) >= 0 ? minute : (start.truncatedTo(ChronoUnit.HOURS).plusHours(1L).compareTo(end.truncatedTo(ChronoUnit.HOURS)) >= 0 ? hour : (start.truncatedTo(ChronoUnit.DAYS).plusDays(1L).compareTo(end.truncatedTo(ChronoUnit.DAYS)) >= 0 ? day : (start.truncatedTo(ChronoUnit.DAYS).plusWeeks(1L).compareTo(end.truncatedTo(ChronoUnit.DAYS)) >= 0 ? week : (start.truncatedTo(ChronoUnit.MONTHS).plusMonths(1L).compareTo(end.truncatedTo(ChronoUnit.MONTHS)) >= 0 ? month : year)))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DateEntityGrain.values().length];
            try {
                nArray[DateEntityGrain.second.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateEntityGrain.minute.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateEntityGrain.hour.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateEntityGrain.day_of_week.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateEntityGrain.day.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateEntityGrain.week.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateEntityGrain.month.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateEntityGrain.quarter.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateEntityGrain.year.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

