/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.entity.date;

import ai.tock.nlp.entity.date.DateEntityGrain;
import ai.tock.nlp.entity.date.DateEntityRange;
import ai.tock.nlp.entity.date.DateEntityValue;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lai/tock/nlp/entity/date/DateIntervalEntityValue;", "Lai/tock/nlp/entity/date/DateEntityRange;", "date", "Lai/tock/nlp/entity/date/DateEntityValue;", "toDate", "(Lai/tock/nlp/entity/date/DateEntityValue;Lai/tock/nlp/entity/date/DateEntityValue;)V", "getDate", "()Lai/tock/nlp/entity/date/DateEntityValue;", "getToDate", "component1", "component2", "copy", "duration", "Ljava/time/Duration;", "end", "Ljava/time/ZonedDateTime;", "zoneId", "Ljava/time/ZoneId;", "equals", "", "other", "", "hashCode", "", "inclusiveEnd", "start", "toString", "", "tock-nlp-entity-value"})
public final class DateIntervalEntityValue
implements DateEntityRange {
    @NotNull
    private final DateEntityValue date;
    @NotNull
    private final DateEntityValue toDate;

    public DateIntervalEntityValue(@NotNull DateEntityValue date, @NotNull DateEntityValue toDate) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)toDate, (String)"toDate");
        this.date = date;
        this.toDate = toDate;
    }

    @NotNull
    public final DateEntityValue getDate() {
        return this.date;
    }

    @NotNull
    public final DateEntityValue getToDate() {
        return this.toDate;
    }

    @Override
    @NotNull
    public ZonedDateTime start() {
        return this.date.getDate();
    }

    @Override
    @NotNull
    public ZonedDateTime inclusiveEnd(@NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        return this.toDate.getGrain().calculateInclusiveEnd(this.toDate.getDate(), zoneId);
    }

    @Override
    @NotNull
    public ZonedDateTime end(@NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        return this.toDate.getGrain().calculateEnd(this.toDate.getDate(), zoneId);
    }

    @Override
    @NotNull
    public Duration duration() {
        Temporal temporal = this.date.getGrain().truncate(this.start());
        DateEntityGrain dateEntityGrain = this.toDate.getGrain();
        ZoneId zoneId = this.start().getZone();
        Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"getZone(...)");
        Duration duration = Duration.between(temporal, dateEntityGrain.truncate(this.end(zoneId)));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
        return duration;
    }

    @Override
    @NotNull
    public ZonedDateTime inclusiveEnd() {
        return DateEntityRange.DefaultImpls.inclusiveEnd(this);
    }

    @Override
    @NotNull
    public ZonedDateTime end() {
        return DateEntityRange.DefaultImpls.end(this);
    }

    @NotNull
    public final DateEntityValue component1() {
        return this.date;
    }

    @NotNull
    public final DateEntityValue component2() {
        return this.toDate;
    }

    @NotNull
    public final DateIntervalEntityValue copy(@NotNull DateEntityValue date, @NotNull DateEntityValue toDate) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)toDate, (String)"toDate");
        return new DateIntervalEntityValue(date, toDate);
    }

    public static /* synthetic */ DateIntervalEntityValue copy$default(DateIntervalEntityValue dateIntervalEntityValue, DateEntityValue dateEntityValue, DateEntityValue dateEntityValue2, int n, Object object) {
        if ((n & 1) != 0) {
            dateEntityValue = dateIntervalEntityValue.date;
        }
        if ((n & 2) != 0) {
            dateEntityValue2 = dateIntervalEntityValue.toDate;
        }
        return dateIntervalEntityValue.copy(dateEntityValue, dateEntityValue2);
    }

    @NotNull
    public String toString() {
        return "DateIntervalEntityValue(date=" + this.date + ", toDate=" + this.toDate + ")";
    }

    public int hashCode() {
        int result = this.date.hashCode();
        result = result * 31 + this.toDate.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DateIntervalEntityValue)) {
            return false;
        }
        DateIntervalEntityValue dateIntervalEntityValue = (DateIntervalEntityValue)other;
        if (!Intrinsics.areEqual((Object)this.date, (Object)dateIntervalEntityValue.date)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.toDate, (Object)dateIntervalEntityValue.toDate);
    }
}

