/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.front.storage.mongo;

import ai.tock.nlp.front.service.storage.ParseRequestLogDAO;
import ai.tock.nlp.front.shared.config.ApplicationDefinition;
import ai.tock.nlp.front.shared.config.SearchMark;
import ai.tock.nlp.front.shared.monitoring.ParseRequestExportLog;
import ai.tock.nlp.front.shared.monitoring.ParseRequestLog;
import ai.tock.nlp.front.shared.monitoring.ParseRequestLogIntentStat;
import ai.tock.nlp.front.shared.monitoring.ParseRequestLogQuery;
import ai.tock.nlp.front.shared.monitoring.ParseRequestLogQueryResult;
import ai.tock.nlp.front.shared.monitoring.ParseRequestLogStat;
import ai.tock.nlp.front.shared.monitoring.ParseRequestLogStatQuery;
import ai.tock.nlp.front.shared.parser.ParseQuery;
import ai.tock.nlp.front.shared.parser.ParseResult;
import ai.tock.nlp.front.storage.mongo.ClassifiedSentenceMongoDAO;
import ai.tock.nlp.front.storage.mongo.DayAndYear_;
import ai.tock.nlp.front.storage.mongo.MongoHelpersKt;
import ai.tock.nlp.front.storage.mongo.ParseRequestLogCol_;
import ai.tock.nlp.front.storage.mongo.ParseRequestLogIntentStatCol_;
import ai.tock.nlp.front.storage.mongo.ParseRequestLogMongoDAO;
import ai.tock.nlp.front.storage.mongo.ParseRequestLogStatCol_;
import ai.tock.nlp.front.storage.mongo.ParseRequestLogStatResult_;
import ai.tock.shared.security.TockObfuscatorService;
import com.mongodb.Function;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.KMongoIterableKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.AccumulatorsKt;
import org.litote.kmongo.AggregatesKt;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.FindIterablesKt;
import org.litote.kmongo.Id;
import org.litote.kmongo.IdsKt;
import org.litote.kmongo.MongoCollectionsKt;
import org.litote.kmongo.ProjectionsKt;
import org.litote.kmongo.SortsKt;
import org.litote.kmongo.UpdatesKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0005)*+,-B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020&H\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\t\u001a\u0004\b\f\u0010\u0007R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\t\u001a\u0004\b\u0012\u0010\u0007\u00a8\u0006."}, d2={"Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO;", "Lai/tock/nlp/front/service/storage/ParseRequestLogDAO;", "()V", "col", "Lcom/mongodb/client/MongoCollection;", "Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$ParseRequestLogCol;", "getCol$tock_nlp_front_storage_mongo", "()Lcom/mongodb/client/MongoCollection;", "col$delegate", "Lkotlin/Lazy;", "intentStatsCol", "Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$ParseRequestLogIntentStatCol;", "getIntentStatsCol$tock_nlp_front_storage_mongo", "intentStatsCol$delegate", "logger", "Lmu/KLogger;", "statsCol", "Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$ParseRequestLogStatCol;", "getStatsCol$tock_nlp_front_storage_mongo", "statsCol$delegate", "export", "", "Lai/tock/nlp/front/shared/monitoring/ParseRequestExportLog;", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "language", "Ljava/util/Locale;", "intentStats", "Lai/tock/nlp/front/shared/monitoring/ParseRequestLogIntentStat;", "query", "Lai/tock/nlp/front/shared/monitoring/ParseRequestLogStatQuery;", "save", "", "log", "Lai/tock/nlp/front/shared/monitoring/ParseRequestLog;", "search", "Lai/tock/nlp/front/shared/monitoring/ParseRequestLogQueryResult;", "Lai/tock/nlp/front/shared/monitoring/ParseRequestLogQuery;", "stats", "Lai/tock/nlp/front/shared/monitoring/ParseRequestLogStat;", "DayAndYear", "ParseRequestLogCol", "ParseRequestLogIntentStatCol", "ParseRequestLogStatCol", "ParseRequestLogStatResult", "tock-nlp-front-storage-mongo"})
public final class ParseRequestLogMongoDAO
implements ParseRequestLogDAO {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final KLogger logger;
    @NotNull
    private static final Lazy col$delegate;
    @NotNull
    private static final Lazy statsCol$delegate;
    @NotNull
    private static final Lazy intentStatsCol$delegate;
    public static final ParseRequestLogMongoDAO INSTANCE;

    static {
        ParseRequestLogMongoDAO parseRequestLogMongoDAO;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ParseRequestLogMongoDAO.class), "col", "getCol$tock_nlp_front_storage_mongo()Lcom/mongodb/client/MongoCollection;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ParseRequestLogMongoDAO.class), "statsCol", "getStatsCol$tock_nlp_front_storage_mongo()Lcom/mongodb/client/MongoCollection;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ParseRequestLogMongoDAO.class), "intentStatsCol", "getIntentStatsCol$tock_nlp_front_storage_mongo()Lcom/mongodb/client/MongoCollection;"))};
        INSTANCE = parseRequestLogMongoDAO = new ParseRequestLogMongoDAO();
        logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        col$delegate = LazyKt.lazy((Function0)col.2.INSTANCE);
        statsCol$delegate = LazyKt.lazy((Function0)statsCol.2.INSTANCE);
        intentStatsCol$delegate = LazyKt.lazy((Function0)intentStatsCol.2.INSTANCE);
    }

    @NotNull
    public final MongoCollection<ParseRequestLogCol> getCol$tock_nlp_front_storage_mongo() {
        Lazy lazy = col$delegate;
        ParseRequestLogMongoDAO parseRequestLogMongoDAO = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (MongoCollection)lazy.getValue();
    }

    @NotNull
    public final MongoCollection<ParseRequestLogStatCol> getStatsCol$tock_nlp_front_storage_mongo() {
        Lazy lazy = statsCol$delegate;
        ParseRequestLogMongoDAO parseRequestLogMongoDAO = this;
        KProperty kProperty = $$delegatedProperties[1];
        boolean bl = false;
        return (MongoCollection)lazy.getValue();
    }

    @NotNull
    public final MongoCollection<ParseRequestLogIntentStatCol> getIntentStatsCol$tock_nlp_front_storage_mongo() {
        Lazy lazy = intentStatsCol$delegate;
        ParseRequestLogMongoDAO parseRequestLogMongoDAO = this;
        KProperty kProperty = $$delegatedProperties[2];
        boolean bl = false;
        return (MongoCollection)lazy.getValue();
    }

    public void save(@NotNull ParseRequestLog log) {
        block14: {
            ParseRequestLogIntentStatCol parseRequestLogIntentStatCol;
            block16: {
                double diff;
                String intent2;
                String intent1;
                block15: {
                    Bson bson;
                    Bson bson2;
                    Bson bson3;
                    double it;
                    boolean bl;
                    boolean bl2;
                    MongoCollection<ParseRequestLogStatCol> mongoCollection;
                    Bson bson4;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n;
                    Double d;
                    ParseResult parseResult;
                    Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
                    ParseQuery parseQuery = ParseQuery.copy$default((ParseQuery)log.getQuery(), (List)TockObfuscatorService.INSTANCE.obfuscate(log.getQuery().getQueries()), null, null, null, null, null, (int)62, null);
                    ParseResult parseResult2 = log.getResult();
                    if (parseResult2 != null) {
                        ParseResult parseResult3 = log.getResult();
                        String string = TockObfuscatorService.obfuscate$default((TockObfuscatorService)TockObfuscatorService.INSTANCE, (String)(parseResult3 != null ? parseResult3.getRetainedQuery() : null), null, (int)2, null);
                        if (string == null) {
                            string = "";
                        }
                        parseResult = ParseResult.copy$default((ParseResult)parseResult2, null, null, null, null, null, (double)0.0, (double)0.0, (String)string, null, (int)383, null);
                    } else {
                        parseResult = null;
                    }
                    ParseRequestLog savedLog = ParseRequestLog.copy$default((ParseRequestLog)log, null, (ParseQuery)parseQuery, parseResult, (long)0L, (boolean)false, null, (int)57, null);
                    this.getCol$tock_nlp_front_storage_mongo().insertOne((Object)new ParseRequestLogCol(savedLog));
                    if (!log.getQuery().getContext().getIncreaseQueryCounter()) break block14;
                    ParseRequestLogStatCol stat = new ParseRequestLogStatCol(log);
                    MongoCollection<ParseRequestLogStatCol> mongoCollection2 = this.getStatsCol$tock_nlp_front_storage_mongo();
                    Bson bson5 = FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)ParseRequestLogStatCol_.Companion.getLanguage()), (Object)stat.getLanguage()), FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getApplicationId()), stat.getApplicationId()), FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getText()), (Object)stat.getText())});
                    Object[] objectArray3 = new Bson[4];
                    Object[] objectArray4 = objectArray3;
                    Object[] objectArray5 = objectArray3;
                    int n2 = 0;
                    Double d2 = stat.getIntentProbability();
                    if (d2 != null) {
                        d = d2;
                        n = n2;
                        objectArray2 = objectArray4;
                        objectArray = objectArray5;
                        bson4 = bson5;
                        mongoCollection = mongoCollection2;
                        bl2 = false;
                        bl = false;
                        it = ((Number)d).doubleValue();
                        boolean bl3 = false;
                        bson3 = UpdatesKt.set((KProperty)((KProperty)ParseRequestLogStatResult_.Companion.getIntentProbability()), (Object)it);
                        mongoCollection2 = mongoCollection;
                        bson5 = bson4;
                        objectArray5 = objectArray;
                        objectArray4 = objectArray2;
                        n2 = n;
                        bson2 = bson3;
                    } else {
                        bson2 = null;
                    }
                    objectArray4[n2] = bson2;
                    Object[] objectArray6 = objectArray5;
                    Object[] objectArray7 = objectArray5;
                    int n3 = 1;
                    Double d3 = stat.getEntitiesProbability();
                    if (d3 != null) {
                        d = d3;
                        n = n3;
                        objectArray2 = objectArray6;
                        objectArray = objectArray7;
                        bson4 = bson5;
                        mongoCollection = mongoCollection2;
                        bl2 = false;
                        bl = false;
                        it = ((Number)d).doubleValue();
                        boolean bl4 = false;
                        bson3 = UpdatesKt.set((KProperty)((KProperty)ParseRequestLogStatResult_.Companion.getEntitiesProbability()), (Object)it);
                        mongoCollection2 = mongoCollection;
                        bson5 = bson4;
                        objectArray7 = objectArray;
                        objectArray6 = objectArray2;
                        n3 = n;
                        bson = bson3;
                    } else {
                        bson = null;
                    }
                    objectArray6[n3] = bson;
                    objectArray7[2] = UpdatesKt.set((KProperty)((KProperty)ParseRequestLogStatCol_.Companion.getLastUsage()), (Object)stat.getLastUsage());
                    objectArray7[3] = UpdatesKt.inc((KProperty)((KProperty)ParseRequestLogStatResult_.Companion.getCount()), (Number)1);
                    ParseRequestLogStatCol updatedStat = (ParseRequestLogStatCol)mongoCollection2.findOneAndUpdate(bson5, UpdatesKt.combine((List)CollectionsKt.listOfNotNull((Object[])objectArray7)), new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.AFTER));
                    if (updatedStat != null) {
                        ClassifiedSentenceMongoDAO.INSTANCE.updateSentenceState$tock_nlp_front_storage_mongo(updatedStat);
                    }
                    ParseResult parseResult4 = log.getResult();
                    intent1 = parseResult4 != null ? parseResult4.getIntent() : null;
                    Object object = log.getResult();
                    Map.Entry nextIntent = object != null && (object = object.getOtherIntentsProbabilities()) != null && (object = MapsKt.asSequence((Map)object)) != null ? (Map.Entry)SequencesKt.firstOrNull((Sequence)object) : null;
                    Object object2 = nextIntent;
                    String string = object2 != null && (object2 = (String)object2.getKey()) != null ? ai.tock.shared.StringsKt.name((String)object2) : (intent2 = null);
                    if (intent1 == null || intent2 == null || !(Intrinsics.areEqual((Object)intent2, (Object)intent1) ^ true)) break block14;
                    if (intent1.compareTo(intent2) > 0) {
                        String tmp = intent1;
                        intent1 = intent2;
                        intent2 = tmp;
                    }
                    ParseResult parseResult5 = log.getResult();
                    if (parseResult5 == null) {
                        Intrinsics.throwNpe();
                    }
                    double d4 = parseResult5.getIntentProbability();
                    Map.Entry entry = nextIntent;
                    if (entry == null) {
                        Intrinsics.throwNpe();
                    }
                    diff = d4 - ((Number)entry.getValue()).doubleValue();
                    parseRequestLogIntentStatCol = (ParseRequestLogIntentStatCol)MongoCollectionsKt.findOne(this.getIntentStatsCol$tock_nlp_front_storage_mongo(), (Bson)FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)ParseRequestLogStatCol_.Companion.getLanguage()), (Object)stat.getLanguage()), FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getApplicationId()), stat.getApplicationId()), FiltersKt.eq((KProperty)((KProperty)ParseRequestLogIntentStatCol_.Companion.getIntent1()), (Object)intent1), FiltersKt.eq((KProperty)((KProperty)ParseRequestLogIntentStatCol_.Companion.getIntent2()), (Object)intent2)}));
                    if (parseRequestLogIntentStatCol == null) break block15;
                    ParseRequestLogIntentStatCol parseRequestLogIntentStatCol2 = parseRequestLogIntentStatCol;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    ParseRequestLogIntentStatCol $this$run = parseRequestLogIntentStatCol2;
                    boolean bl7 = false;
                    Id id = null;
                    double d5 = ($this$run.getAverageDiff() * (double)$this$run.getCount() + diff) / (double)($this$run.getCount() + 1L);
                    long l = $this$run.getCount() + 1L;
                    ParseRequestLogIntentStatCol parseRequestLogIntentStatCol3 = ParseRequestLogIntentStatCol.copy$default($this$run, null, null, null, null, d5, l, id, 79, null);
                    parseRequestLogIntentStatCol = parseRequestLogIntentStatCol3;
                    if (parseRequestLogIntentStatCol3 != null) break block16;
                }
                parseRequestLogIntentStatCol = new ParseRequestLogIntentStatCol(log.getApplicationId(), log.getQuery().getContext().getLanguage(), intent1, intent2, diff, 1L, null, 64, null);
            }
            ParseRequestLogIntentStatCol s = parseRequestLogIntentStatCol;
            MongoCollectionsKt.save(this.getIntentStatsCol$tock_nlp_front_storage_mongo(), (Object)s);
        }
    }

    @NotNull
    public ParseRequestLogQueryResult search(@NotNull ParseRequestLogQuery query2) {
        ParseRequestLogQueryResult parseRequestLogQueryResult;
        Bson bson;
        Bson bson2;
        Intrinsics.checkParameterIsNotNull((Object)query2, (String)"query");
        boolean bl = false;
        boolean bl2 = false;
        ParseRequestLogQuery $this$with = query2;
        boolean bl3 = false;
        Bson[] bsonArray = new Bson[8];
        bsonArray[0] = FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getApplicationId()), (Object)$this$with.getApplicationId());
        bsonArray[1] = $this$with.getLanguage() == null ? null : FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getQuery().getContext().getLanguage()), (Object)$this$with.getLanguage());
        bsonArray[2] = query2.getDisplayTests() ? null : FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getQuery().getContext().getTest()), (Object)false);
        CharSequence charSequence = $this$with.getSearch();
        int n = 3;
        Bson[] bsonArray2 = bsonArray;
        Bson[] bsonArray3 = bsonArray;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
        Bson[] bsonArray4 = bsonArray3;
        Bson[] bsonArray5 = bsonArray2;
        int n2 = n;
        if (bl6) {
            bson2 = null;
        } else if (query2.getOnlyExactMatch()) {
            bson2 = FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getText()), (Object)$this$with.getSearch());
        } else {
            KProperty kProperty = (KProperty)ParseRequestLogCol_.Companion.getText();
            String string = $this$with.getSearch();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            charSequence = string;
            KProperty kProperty2 = kProperty;
            n = n2;
            bsonArray2 = bsonArray5;
            bsonArray3 = bsonArray4;
            bl4 = false;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string2 = ((Object)StringsKt.trim((CharSequence)charSequence2)).toString();
            bsonArray4 = bsonArray3;
            bsonArray5 = bsonArray2;
            n2 = n;
            bson2 = bsonArray5[n2] = FiltersKt.regex((KProperty)kProperty2, (String)string2, (String)"i");
        }
        if ($this$with.getSearchMark() == null) {
            bson = null;
        } else {
            KProperty kProperty = (KProperty)ParseRequestLogCol_.Companion.getDate();
            SearchMark searchMark = $this$with.getSearchMark();
            if (searchMark == null) {
                Intrinsics.throwNpe();
            }
            bson = FiltersKt.lte((KProperty)kProperty, (Object)searchMark.getDate());
        }
        bsonArray4[4] = bson;
        bsonArray4[5] = $this$with.getSinceDate() == null ? null : FiltersKt.gte((KProperty)((KProperty)ParseRequestLogCol_.Companion.getDate()), (Object)$this$with.getSinceDate());
        charSequence = $this$with.getClientDevice();
        n = 6;
        bsonArray2 = bsonArray4;
        bsonArray3 = bsonArray4;
        bl4 = false;
        bl5 = false;
        bl6 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
        bsonArray2[n] = bl6 ? null : FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getQuery().getContext().getClientDevice()), (Object)$this$with.getClientDevice());
        charSequence = $this$with.getClientId();
        n = 7;
        bsonArray2 = bsonArray3;
        bl4 = false;
        bl5 = false;
        bl6 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
        bsonArray2[n] = bl6 ? null : FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getQuery().getContext().getClientId()), (Object)$this$with.getClientId());
        Bson baseFilter2 = FiltersKt.and((Bson[])bsonArray3);
        long count = INSTANCE.getCol$tock_nlp_front_storage_mongo().countDocuments(baseFilter2);
        if (count > $this$with.getStart()) {
            FindIterable findIterable = INSTANCE.getCol$tock_nlp_front_storage_mongo().find(baseFilter2);
            Intrinsics.checkExpressionValueIsNotNull((Object)findIterable, (String)"col.find(baseFilter)");
            FindIterable list = FindIterablesKt.descendingSort((FindIterable)findIterable, (KProperty[])new KProperty[]{(KProperty)ParseRequestLogCol_.Companion.getDate()}).skip((int)$this$with.getStart()).limit($this$with.getSize());
            MongoIterable mongoIterable = list.map((Function)search.1.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)mongoIterable, (String)"list.map { it.toRequest() }");
            parseRequestLogQueryResult = new ParseRequestLogQueryResult(count, KMongoIterableKt.toList((MongoIterable)mongoIterable));
        } else {
            parseRequestLogQueryResult = new ParseRequestLogQueryResult(0L, CollectionsKt.emptyList());
        }
        return parseRequestLogQueryResult;
    }

    @NotNull
    public List<ParseRequestExportLog> export(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language) {
        Intrinsics.checkParameterIsNotNull(applicationId, (String)"applicationId");
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        MongoCollection<ParseRequestLogCol> $this$withDocumentClass$iv = this.getCol$tock_nlp_front_storage_mongo();
        boolean $i$f$withDocumentClass = false;
        MongoCollection mongoCollection = $this$withDocumentClass$iv.withDocumentClass(Document.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoCollection, (String)"withDocumentClass(NewTDocument::class.java)");
        FindIterable findIterable = mongoCollection.find(FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getApplicationId()), applicationId), FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getQuery().getContext().getLanguage()), (Object)language), FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getQuery().getContext().getTest()), (Object)false)}));
        Intrinsics.checkExpressionValueIsNotNull((Object)findIterable, (String)"col.withDocumentClass<Do\u2026y.context.test eq false))");
        MongoIterable mongoIterable = FindIterablesKt.descendingSort((FindIterable)findIterable, (KProperty[])new KProperty[]{(KProperty)ParseRequestLogCol_.Companion.getDate()}).projection(ProjectionsKt.fields((Bson[])new Bson[]{ProjectionsKt.include((KProperty[])new KProperty[]{(KProperty)ParseRequestLogCol_.Companion.getQuery().getQueries(), (KProperty)ParseRequestLogCol_.Companion.getResult().getIntent(), (KProperty)ParseRequestLogCol_.Companion.getResult().getIntentNamespace(), (KProperty)ParseRequestLogCol_.Companion.getDate()}), ProjectionsKt.excludeId()})).map((Function)export.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoIterable, (String)"col.withDocumentClass<Do\u2026          )\n            }");
        return KMongoIterableKt.toList((MongoIterable)mongoIterable);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ParseRequestLogStat> stats(@NotNull ParseRequestLogStatQuery query2) {
        void $this$mapTo$iv$iv;
        void $this$aggregate$iv;
        Intrinsics.checkParameterIsNotNull((Object)query2, (String)"query");
        boolean bl = false;
        boolean bl2 = false;
        ParseRequestLogStatQuery $this$with = query2;
        boolean bl3 = false;
        MongoCollection<ParseRequestLogCol> mongoCollection = INSTANCE.getCol$tock_nlp_front_storage_mongo();
        Object[] pipeline$iv = new Bson[]{AggregatesKt.match((Bson)FiltersKt.and((Iterable)CollectionsKt.listOfNotNull((Object[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getApplicationId()), (Object)$this$with.getApplicationId()), $this$with.getLanguage() == null ? null : FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getQuery().getContext().getLanguage()), (Object)$this$with.getLanguage()), FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getQuery().getContext().getTest()), (Object)false), $this$with.getIntent() == null ? null : FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getResult().getIntent()), (Object)$this$with.getIntent())}))), AggregatesKt.project((Bson[])new Bson[]{ProjectionsKt.from((KProperty)((KProperty)ParseRequestLogCol_.Companion.getError()), (Object)AggregatesKt.cond(ParseRequestLogCol_.Companion.getError(), (Object)1, (Object)0)), ProjectionsKt.from((KProperty)((KProperty)DayAndYear_.Companion.getDayOfYear()), (Object)AggregatesKt.dayOfYear((KProperty)((KProperty)ParseRequestLogCol_.Companion.getDate()))), ProjectionsKt.from((KProperty)((KProperty)DayAndYear_.Companion.getYear()), (Object)AggregatesKt.year((KProperty)((KProperty)ParseRequestLogCol_.Companion.getDate()))), ProjectionsKt.from((KProperty)((KProperty)ParseRequestLogStatResult_.Companion.getDuration()), ParseRequestLogCol_.Companion.getDurationInMS()), ProjectionsKt.from((KProperty)((KProperty)ParseRequestLogStatResult_.Companion.getIntentProbability()), ParseRequestLogCol_.Companion.getResult().getIntentProbability()), ProjectionsKt.from((KProperty)((KProperty)ParseRequestLogStatResult_.Companion.getEntitiesProbability()), ParseRequestLogCol_.Companion.getResult().getEntitiesProbability())}), AggregatesKt.group((Object)AggregatesKt.document((Bson[])new Bson[]{ProjectionsKt.from((KProperty)((KProperty)DayAndYear_.Companion.getDayOfYear()), DayAndYear_.Companion.getDayOfYear()), ProjectionsKt.from((KProperty)((KProperty)DayAndYear_.Companion.getYear()), DayAndYear_.Companion.getYear())}), (BsonField[])new BsonField[]{AccumulatorsKt.sum((KProperty)((KProperty)ParseRequestLogCol_.Companion.getError()), ParseRequestLogCol_.Companion.getError()), AccumulatorsKt.sum((KProperty)((KProperty)ParseRequestLogStatResult_.Companion.getCount()), (Object)1), AccumulatorsKt.avg((KProperty)((KProperty)ParseRequestLogStatResult_.Companion.getDuration()), ParseRequestLogStatResult_.Companion.getDuration()), AccumulatorsKt.avg((KProperty)((KProperty)ParseRequestLogStatResult_.Companion.getIntentProbability()), ParseRequestLogStatResult_.Companion.getIntentProbability()), AccumulatorsKt.avg((KProperty)((KProperty)ParseRequestLogStatResult_.Companion.getEntitiesProbability()), ParseRequestLogStatResult_.Companion.getEntitiesProbability())}), AggregatesKt.sort((Bson)SortsKt.ascending((KProperty[])new KProperty[]{(KProperty)ParseRequestLogStatResult_.Companion.get_id().getYear(), (KProperty)ParseRequestLogStatResult_.Companion.get_id().getDayOfYear()}))};
        boolean $i$f$aggregate22 = false;
        AggregateIterable aggregateIterable = $this$aggregate$iv.aggregate(ArraysKt.toList((Object[])pipeline$iv), ParseRequestLogStatResult.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)aggregateIterable, (String)"aggregate(pipeline.toList(), TResult::class.java)");
        Iterable $this$map$iv = KMongoIterableKt.toList((MongoIterable)((MongoIterable)aggregateIterable));
        boolean $i$f$map = false;
        Iterable $i$f$aggregate22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ParseRequestLogStatResult parseRequestLogStatResult = (ParseRequestLogStatResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            ParseRequestLogStat parseRequestLogStat = it.toStat();
            collection.add(parseRequestLogStat);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<ParseRequestLogIntentStat> intentStats(@NotNull ParseRequestLogStatQuery query2) {
        Intrinsics.checkParameterIsNotNull((Object)query2, (String)"query");
        FindIterable findIterable = this.getIntentStatsCol$tock_nlp_front_storage_mongo().find(FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getApplicationId()), (Object)query2.getApplicationId()), FiltersKt.gte((KProperty)((KProperty)ParseRequestLogStatResult_.Companion.getCount()), (Object)query2.getMinOccurrences())}));
        Intrinsics.checkExpressionValueIsNotNull((Object)findIterable, (String)"intentStatsCol\n         \u2026          )\n            )");
        MongoIterable mongoIterable = FindIterablesKt.descendingSort((FindIterable)findIterable, (KProperty[])new KProperty[]{(KProperty)ParseRequestLogStatResult_.Companion.getCount()}).map((Function)intentStats.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoIterable, (String)"intentStatsCol\n         \u2026          )\n            }");
        return KMongoIterableKt.toList((MongoIterable)mongoIterable);
    }

    private ParseRequestLogMongoDAO() {
    }

    public static final /* synthetic */ KLogger access$getLogger$p(ParseRequestLogMongoDAO $this) {
        ParseRequestLogMongoDAO parseRequestLogMongoDAO = $this;
        return logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004BM\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\t\u0010#\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\t\u0010%\u001a\u00020\u000bH\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\t\u0010'\u001a\u00020\u000fH\u00c6\u0003J\t\u0010(\u001a\u00020\u0011H\u00c6\u0003J\t\u0010)\u001a\u00020\u0013H\u00c6\u0003JW\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u00c6\u0001J\u0013\u0010+\u001a\u00020\u00112\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020.H\u00d6\u0001J\u0006\u0010/\u001a\u00020\u0003J\t\u00100\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u00061"}, d2={"Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$ParseRequestLogCol;", "", "request", "Lai/tock/nlp/front/shared/monitoring/ParseRequestLog;", "(Lai/tock/nlp/front/shared/monitoring/ParseRequestLog;)V", "text", "", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "query", "Lai/tock/nlp/front/shared/parser/ParseQuery;", "result", "Lai/tock/nlp/front/shared/parser/ParseResult;", "durationInMS", "", "error", "", "date", "Ljava/time/Instant;", "(Ljava/lang/String;Lorg/litote/kmongo/Id;Lai/tock/nlp/front/shared/parser/ParseQuery;Lai/tock/nlp/front/shared/parser/ParseResult;JZLjava/time/Instant;)V", "getApplicationId", "()Lorg/litote/kmongo/Id;", "getDate", "()Ljava/time/Instant;", "getDurationInMS", "()J", "getError", "()Z", "getQuery", "()Lai/tock/nlp/front/shared/parser/ParseQuery;", "getResult", "()Lai/tock/nlp/front/shared/parser/ParseResult;", "getText", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "", "toRequest", "toString", "tock-nlp-front-storage-mongo"})
    public static final class ParseRequestLogCol {
        @NotNull
        private final String text;
        @NotNull
        private final Id<ApplicationDefinition> applicationId;
        @NotNull
        private final ParseQuery query;
        @Nullable
        private final ParseResult result;
        private final long durationInMS;
        private final boolean error;
        @NotNull
        private final Instant date;

        @NotNull
        public final ParseRequestLog toRequest() {
            return new ParseRequestLog(this.applicationId, this.query, this.result, this.durationInMS, this.error, this.date);
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final Id<ApplicationDefinition> getApplicationId() {
            return this.applicationId;
        }

        @NotNull
        public final ParseQuery getQuery() {
            return this.query;
        }

        @Nullable
        public final ParseResult getResult() {
            return this.result;
        }

        public final long getDurationInMS() {
            return this.durationInMS;
        }

        public final boolean getError() {
            return this.error;
        }

        @NotNull
        public final Instant getDate() {
            return this.date;
        }

        public ParseRequestLogCol(@NotNull String text, @NotNull Id<ApplicationDefinition> applicationId, @NotNull ParseQuery query2, @Nullable ParseResult result2, long durationInMS, boolean error, @NotNull Instant date) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull(applicationId, (String)"applicationId");
            Intrinsics.checkParameterIsNotNull((Object)query2, (String)"query");
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            this.text = text;
            this.applicationId = applicationId;
            this.query = query2;
            this.result = result2;
            this.durationInMS = durationInMS;
            this.error = error;
            this.date = date;
        }

        public /* synthetic */ ParseRequestLogCol(String string, Id id, ParseQuery parseQuery, ParseResult parseResult, long l, boolean bl, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                parseResult = null;
            }
            if ((n & 0x10) != 0) {
                l = 0L;
            }
            if ((n & 0x20) != 0) {
                bl = false;
            }
            if ((n & 0x40) != 0) {
                Instant instant2 = Instant.now();
                Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"Instant.now()");
                instant = instant2;
            }
            this(string, (Id<ApplicationDefinition>)id, parseQuery, parseResult, l, bl, instant);
        }

        public ParseRequestLogCol(@NotNull ParseRequestLog request) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Object object2 = request.getResult();
            if (object2 == null || (object2 = object2.getRetainedQuery()) == null) {
                object2 = object = (String)CollectionsKt.firstOrNull((List)request.getQuery().getQueries());
            }
            if (object2 == null) {
                object = "";
            }
            this(MongoHelpersKt.textKey((String)object), (Id<ApplicationDefinition>)request.getApplicationId(), request.getQuery(), request.getResult(), request.getDurationInMS(), request.getError(), request.getDate());
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final Id<ApplicationDefinition> component2() {
            return this.applicationId;
        }

        @NotNull
        public final ParseQuery component3() {
            return this.query;
        }

        @Nullable
        public final ParseResult component4() {
            return this.result;
        }

        public final long component5() {
            return this.durationInMS;
        }

        public final boolean component6() {
            return this.error;
        }

        @NotNull
        public final Instant component7() {
            return this.date;
        }

        @NotNull
        public final ParseRequestLogCol copy(@NotNull String text, @NotNull Id<ApplicationDefinition> applicationId, @NotNull ParseQuery query2, @Nullable ParseResult result2, long durationInMS, boolean error, @NotNull Instant date) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull(applicationId, (String)"applicationId");
            Intrinsics.checkParameterIsNotNull((Object)query2, (String)"query");
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            return new ParseRequestLogCol(text, applicationId, query2, result2, durationInMS, error, date);
        }

        public static /* synthetic */ ParseRequestLogCol copy$default(ParseRequestLogCol parseRequestLogCol, String string, Id id, ParseQuery parseQuery, ParseResult parseResult, long l, boolean bl, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                string = parseRequestLogCol.text;
            }
            if ((n & 2) != 0) {
                id = parseRequestLogCol.applicationId;
            }
            if ((n & 4) != 0) {
                parseQuery = parseRequestLogCol.query;
            }
            if ((n & 8) != 0) {
                parseResult = parseRequestLogCol.result;
            }
            if ((n & 0x10) != 0) {
                l = parseRequestLogCol.durationInMS;
            }
            if ((n & 0x20) != 0) {
                bl = parseRequestLogCol.error;
            }
            if ((n & 0x40) != 0) {
                instant = parseRequestLogCol.date;
            }
            return parseRequestLogCol.copy(string, id, parseQuery, parseResult, l, bl, instant);
        }

        @NotNull
        public String toString() {
            return "ParseRequestLogCol(text=" + this.text + ", applicationId=" + this.applicationId + ", query=" + this.query + ", result=" + this.result + ", durationInMS=" + this.durationInMS + ", error=" + this.error + ", date=" + this.date + ")";
        }

        public int hashCode() {
            String string = this.text;
            Id<ApplicationDefinition> id = this.applicationId;
            ParseQuery parseQuery = this.query;
            ParseResult parseResult = this.result;
            int n = (((((string != null ? string.hashCode() : 0) * 31 + (id != null ? id.hashCode() : 0)) * 31 + (parseQuery != null ? parseQuery.hashCode() : 0)) * 31 + (parseResult != null ? parseResult.hashCode() : 0)) * 31 + Long.hashCode(this.durationInMS)) * 31;
            int n2 = this.error ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            Instant instant = this.date;
            return (n + n2) * 31 + (instant != null ? ((Object)instant).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ParseRequestLogCol)) break block3;
                    ParseRequestLogCol parseRequestLogCol = (ParseRequestLogCol)object;
                    if (!Intrinsics.areEqual((Object)this.text, (Object)parseRequestLogCol.text) || !Intrinsics.areEqual(this.applicationId, parseRequestLogCol.applicationId) || !Intrinsics.areEqual((Object)this.query, (Object)parseRequestLogCol.query) || !Intrinsics.areEqual((Object)this.result, (Object)parseRequestLogCol.result) || this.durationInMS != parseRequestLogCol.durationInMS || this.error != parseRequestLogCol.error || !Intrinsics.areEqual((Object)this.date, (Object)parseRequestLogCol.date)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004BO\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\t\u0010\"\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\t\u0010$\u001a\u00020\u000bH\u00c6\u0003J\u0010\u0010%\u001a\u0004\u0018\u00010\rH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010&\u001a\u0004\u0018\u00010\rH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0019J\t\u0010'\u001a\u00020\u0010H\u00c6\u0003J\t\u0010(\u001a\u00020\u0012H\u00c6\u0003J^\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u00c6\u0001\u00a2\u0006\u0002\u0010*J\u0013\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010.\u001a\u00020/H\u00d6\u0001J\t\u00100\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0015\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019R\u0015\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00061"}, d2={"Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$ParseRequestLogStatCol;", "", "request", "Lai/tock/nlp/front/shared/monitoring/ParseRequestLog;", "(Lai/tock/nlp/front/shared/monitoring/ParseRequestLog;)V", "text", "", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "language", "Ljava/util/Locale;", "intentProbability", "", "entitiesProbability", "lastUsage", "Ljava/time/Instant;", "count", "", "(Ljava/lang/String;Lorg/litote/kmongo/Id;Ljava/util/Locale;Ljava/lang/Double;Ljava/lang/Double;Ljava/time/Instant;J)V", "getApplicationId", "()Lorg/litote/kmongo/Id;", "getCount", "()J", "getEntitiesProbability", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getIntentProbability", "getLanguage", "()Ljava/util/Locale;", "getLastUsage", "()Ljava/time/Instant;", "getText", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(Ljava/lang/String;Lorg/litote/kmongo/Id;Ljava/util/Locale;Ljava/lang/Double;Ljava/lang/Double;Ljava/time/Instant;J)Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$ParseRequestLogStatCol;", "equals", "", "other", "hashCode", "", "toString", "tock-nlp-front-storage-mongo"})
    public static final class ParseRequestLogStatCol {
        @NotNull
        private final String text;
        @NotNull
        private final Id<ApplicationDefinition> applicationId;
        @NotNull
        private final Locale language;
        @Nullable
        private final Double intentProbability;
        @Nullable
        private final Double entitiesProbability;
        @NotNull
        private final Instant lastUsage;
        private final long count;

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final Id<ApplicationDefinition> getApplicationId() {
            return this.applicationId;
        }

        @NotNull
        public final Locale getLanguage() {
            return this.language;
        }

        @Nullable
        public final Double getIntentProbability() {
            return this.intentProbability;
        }

        @Nullable
        public final Double getEntitiesProbability() {
            return this.entitiesProbability;
        }

        @NotNull
        public final Instant getLastUsage() {
            return this.lastUsage;
        }

        public final long getCount() {
            return this.count;
        }

        public ParseRequestLogStatCol(@NotNull String text, @NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language, @Nullable Double intentProbability, @Nullable Double entitiesProbability, @NotNull Instant lastUsage, long count) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull(applicationId, (String)"applicationId");
            Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
            Intrinsics.checkParameterIsNotNull((Object)lastUsage, (String)"lastUsage");
            this.text = text;
            this.applicationId = applicationId;
            this.language = language;
            this.intentProbability = intentProbability;
            this.entitiesProbability = entitiesProbability;
            this.lastUsage = lastUsage;
            this.count = count;
        }

        public /* synthetic */ ParseRequestLogStatCol(String string, Id id, Locale locale, Double d, Double d2, Instant instant, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                d = null;
            }
            if ((n & 0x10) != 0) {
                d2 = null;
            }
            if ((n & 0x20) != 0) {
                Instant instant2 = Instant.now();
                Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"Instant.now()");
                instant = instant2;
            }
            if ((n & 0x40) != 0) {
                l = 1L;
            }
            this(string, (Id<ApplicationDefinition>)id, locale, d, d2, instant, l);
        }

        public ParseRequestLogStatCol(@NotNull ParseRequestLog request) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Object object2 = request.getResult();
            if (object2 == null || (object2 = object2.getRetainedQuery()) == null) {
                object2 = object = (String)CollectionsKt.firstOrNull((List)request.getQuery().getQueries());
            }
            if (object2 == null) {
                object = "";
            }
            ParseResult parseResult = request.getResult();
            ParseResult parseResult2 = request.getResult();
            this(MongoHelpersKt.textKey((String)object), request.getApplicationId(), request.getQuery().getContext().getLanguage(), parseResult != null ? Double.valueOf(parseResult.getIntentProbability()) : null, parseResult2 != null ? Double.valueOf(parseResult2.getEntitiesProbability()) : null, request.getDate(), 0L, 64, null);
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final Id<ApplicationDefinition> component2() {
            return this.applicationId;
        }

        @NotNull
        public final Locale component3() {
            return this.language;
        }

        @Nullable
        public final Double component4() {
            return this.intentProbability;
        }

        @Nullable
        public final Double component5() {
            return this.entitiesProbability;
        }

        @NotNull
        public final Instant component6() {
            return this.lastUsage;
        }

        public final long component7() {
            return this.count;
        }

        @NotNull
        public final ParseRequestLogStatCol copy(@NotNull String text, @NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language, @Nullable Double intentProbability, @Nullable Double entitiesProbability, @NotNull Instant lastUsage, long count) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull(applicationId, (String)"applicationId");
            Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
            Intrinsics.checkParameterIsNotNull((Object)lastUsage, (String)"lastUsage");
            return new ParseRequestLogStatCol(text, applicationId, language, intentProbability, entitiesProbability, lastUsage, count);
        }

        public static /* synthetic */ ParseRequestLogStatCol copy$default(ParseRequestLogStatCol parseRequestLogStatCol, String string, Id id, Locale locale, Double d, Double d2, Instant instant, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = parseRequestLogStatCol.text;
            }
            if ((n & 2) != 0) {
                id = parseRequestLogStatCol.applicationId;
            }
            if ((n & 4) != 0) {
                locale = parseRequestLogStatCol.language;
            }
            if ((n & 8) != 0) {
                d = parseRequestLogStatCol.intentProbability;
            }
            if ((n & 0x10) != 0) {
                d2 = parseRequestLogStatCol.entitiesProbability;
            }
            if ((n & 0x20) != 0) {
                instant = parseRequestLogStatCol.lastUsage;
            }
            if ((n & 0x40) != 0) {
                l = parseRequestLogStatCol.count;
            }
            return parseRequestLogStatCol.copy(string, id, locale, d, d2, instant, l);
        }

        @NotNull
        public String toString() {
            return "ParseRequestLogStatCol(text=" + this.text + ", applicationId=" + this.applicationId + ", language=" + this.language + ", intentProbability=" + this.intentProbability + ", entitiesProbability=" + this.entitiesProbability + ", lastUsage=" + this.lastUsage + ", count=" + this.count + ")";
        }

        public int hashCode() {
            String string = this.text;
            Id<ApplicationDefinition> id = this.applicationId;
            Locale locale = this.language;
            Double d = this.intentProbability;
            Double d2 = this.entitiesProbability;
            Instant instant = this.lastUsage;
            return ((((((string != null ? string.hashCode() : 0) * 31 + (id != null ? id.hashCode() : 0)) * 31 + (locale != null ? ((Object)locale).hashCode() : 0)) * 31 + (d != null ? ((Object)d).hashCode() : 0)) * 31 + (d2 != null ? ((Object)d2).hashCode() : 0)) * 31 + (instant != null ? ((Object)instant).hashCode() : 0)) * 31 + Long.hashCode(this.count);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ParseRequestLogStatCol)) break block3;
                    ParseRequestLogStatCol parseRequestLogStatCol = (ParseRequestLogStatCol)object;
                    if (!Intrinsics.areEqual((Object)this.text, (Object)parseRequestLogStatCol.text) || !Intrinsics.areEqual(this.applicationId, parseRequestLogStatCol.applicationId) || !Intrinsics.areEqual((Object)this.language, (Object)parseRequestLogStatCol.language) || !Intrinsics.areEqual((Object)this.intentProbability, (Object)parseRequestLogStatCol.intentProbability) || !Intrinsics.areEqual((Object)this.entitiesProbability, (Object)parseRequestLogStatCol.entitiesProbability) || !Intrinsics.areEqual((Object)this.lastUsage, (Object)parseRequestLogStatCol.lastUsage) || this.count != parseRequestLogStatCol.count) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BM\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u00a2\u0006\u0002\u0010\u000fJ\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J\t\u0010 \u001a\u00020\u000bH\u00c6\u0003J\t\u0010!\u001a\u00020\rH\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003H\u00c6\u0003J[\u0010#\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003H\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\bH\u00d6\u0001R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006*"}, d2={"Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$ParseRequestLogIntentStatCol;", "", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "language", "Ljava/util/Locale;", "intent1", "", "intent2", "averageDiff", "", "count", "", "_id", "(Lorg/litote/kmongo/Id;Ljava/util/Locale;Ljava/lang/String;Ljava/lang/String;DJLorg/litote/kmongo/Id;)V", "get_id", "()Lorg/litote/kmongo/Id;", "getApplicationId", "getAverageDiff", "()D", "getCount", "()J", "getIntent1", "()Ljava/lang/String;", "getIntent2", "getLanguage", "()Ljava/util/Locale;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toString", "tock-nlp-front-storage-mongo"})
    public static final class ParseRequestLogIntentStatCol {
        @NotNull
        private final Id<ApplicationDefinition> applicationId;
        @NotNull
        private final Locale language;
        @NotNull
        private final String intent1;
        @NotNull
        private final String intent2;
        private final double averageDiff;
        private final long count;
        @NotNull
        private final Id<ParseRequestLogIntentStatCol> _id;

        @NotNull
        public final Id<ApplicationDefinition> getApplicationId() {
            return this.applicationId;
        }

        @NotNull
        public final Locale getLanguage() {
            return this.language;
        }

        @NotNull
        public final String getIntent1() {
            return this.intent1;
        }

        @NotNull
        public final String getIntent2() {
            return this.intent2;
        }

        public final double getAverageDiff() {
            return this.averageDiff;
        }

        public final long getCount() {
            return this.count;
        }

        @NotNull
        public final Id<ParseRequestLogIntentStatCol> get_id() {
            return this._id;
        }

        public ParseRequestLogIntentStatCol(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language, @NotNull String intent1, @NotNull String intent2, double averageDiff, long count, @NotNull Id<ParseRequestLogIntentStatCol> _id2) {
            Intrinsics.checkParameterIsNotNull(applicationId, (String)"applicationId");
            Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
            Intrinsics.checkParameterIsNotNull((Object)intent1, (String)"intent1");
            Intrinsics.checkParameterIsNotNull((Object)intent2, (String)"intent2");
            Intrinsics.checkParameterIsNotNull(_id2, (String)"_id");
            this.applicationId = applicationId;
            this.language = language;
            this.intent1 = intent1;
            this.intent2 = intent2;
            this.averageDiff = averageDiff;
            this.count = count;
            this._id = _id2;
        }

        public /* synthetic */ ParseRequestLogIntentStatCol(Id id, Locale locale, String string, String string2, double d, long l, Id id2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                l = 1L;
            }
            if ((n & 0x40) != 0) {
                id2 = IdsKt.newId();
            }
            this((Id<ApplicationDefinition>)id, locale, string, string2, d, l, (Id<ParseRequestLogIntentStatCol>)id2);
        }

        @NotNull
        public final Id<ApplicationDefinition> component1() {
            return this.applicationId;
        }

        @NotNull
        public final Locale component2() {
            return this.language;
        }

        @NotNull
        public final String component3() {
            return this.intent1;
        }

        @NotNull
        public final String component4() {
            return this.intent2;
        }

        public final double component5() {
            return this.averageDiff;
        }

        public final long component6() {
            return this.count;
        }

        @NotNull
        public final Id<ParseRequestLogIntentStatCol> component7() {
            return this._id;
        }

        @NotNull
        public final ParseRequestLogIntentStatCol copy(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language, @NotNull String intent1, @NotNull String intent2, double averageDiff, long count, @NotNull Id<ParseRequestLogIntentStatCol> _id2) {
            Intrinsics.checkParameterIsNotNull(applicationId, (String)"applicationId");
            Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
            Intrinsics.checkParameterIsNotNull((Object)intent1, (String)"intent1");
            Intrinsics.checkParameterIsNotNull((Object)intent2, (String)"intent2");
            Intrinsics.checkParameterIsNotNull(_id2, (String)"_id");
            return new ParseRequestLogIntentStatCol(applicationId, language, intent1, intent2, averageDiff, count, _id2);
        }

        public static /* synthetic */ ParseRequestLogIntentStatCol copy$default(ParseRequestLogIntentStatCol parseRequestLogIntentStatCol, Id id, Locale locale, String string, String string2, double d, long l, Id id2, int n, Object object) {
            if ((n & 1) != 0) {
                id = parseRequestLogIntentStatCol.applicationId;
            }
            if ((n & 2) != 0) {
                locale = parseRequestLogIntentStatCol.language;
            }
            if ((n & 4) != 0) {
                string = parseRequestLogIntentStatCol.intent1;
            }
            if ((n & 8) != 0) {
                string2 = parseRequestLogIntentStatCol.intent2;
            }
            if ((n & 0x10) != 0) {
                d = parseRequestLogIntentStatCol.averageDiff;
            }
            if ((n & 0x20) != 0) {
                l = parseRequestLogIntentStatCol.count;
            }
            if ((n & 0x40) != 0) {
                id2 = parseRequestLogIntentStatCol._id;
            }
            return parseRequestLogIntentStatCol.copy(id, locale, string, string2, d, l, id2);
        }

        @NotNull
        public String toString() {
            return "ParseRequestLogIntentStatCol(applicationId=" + this.applicationId + ", language=" + this.language + ", intent1=" + this.intent1 + ", intent2=" + this.intent2 + ", averageDiff=" + this.averageDiff + ", count=" + this.count + ", _id=" + this._id + ")";
        }

        public int hashCode() {
            Id<ApplicationDefinition> id = this.applicationId;
            Locale locale = this.language;
            String string = this.intent1;
            String string2 = this.intent2;
            Id<ParseRequestLogIntentStatCol> id2 = this._id;
            return ((((((id != null ? id.hashCode() : 0) * 31 + (locale != null ? ((Object)locale).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + Double.hashCode(this.averageDiff)) * 31 + Long.hashCode(this.count)) * 31 + (id2 != null ? id2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ParseRequestLogIntentStatCol)) break block3;
                    ParseRequestLogIntentStatCol parseRequestLogIntentStatCol = (ParseRequestLogIntentStatCol)object;
                    if (!Intrinsics.areEqual(this.applicationId, parseRequestLogIntentStatCol.applicationId) || !Intrinsics.areEqual((Object)this.language, (Object)parseRequestLogIntentStatCol.language) || !Intrinsics.areEqual((Object)this.intent1, (Object)parseRequestLogIntentStatCol.intent1) || !Intrinsics.areEqual((Object)this.intent2, (Object)parseRequestLogIntentStatCol.intent2) || Double.compare(this.averageDiff, parseRequestLogIntentStatCol.averageDiff) != 0 || this.count != parseRequestLogIntentStatCol.count || !Intrinsics.areEqual(this._id, parseRequestLogIntentStatCol._id)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$DayAndYear;", "", "dayOfYear", "", "year", "(II)V", "getDayOfYear", "()I", "getYear", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "tock-nlp-front-storage-mongo"})
    public static final class DayAndYear {
        private final int dayOfYear;
        private final int year;

        public final int getDayOfYear() {
            return this.dayOfYear;
        }

        public final int getYear() {
            return this.year;
        }

        public DayAndYear(int dayOfYear, int year) {
            this.dayOfYear = dayOfYear;
            this.year = year;
        }

        public final int component1() {
            return this.dayOfYear;
        }

        public final int component2() {
            return this.year;
        }

        @NotNull
        public final DayAndYear copy(int dayOfYear, int year) {
            return new DayAndYear(dayOfYear, year);
        }

        public static /* synthetic */ DayAndYear copy$default(DayAndYear dayAndYear, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = dayAndYear.dayOfYear;
            }
            if ((n3 & 2) != 0) {
                n2 = dayAndYear.year;
            }
            return dayAndYear.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "DayAndYear(dayOfYear=" + this.dayOfYear + ", year=" + this.year + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.dayOfYear) * 31 + Integer.hashCode(this.year);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DayAndYear)) break block3;
                    DayAndYear dayAndYear = (DayAndYear)object;
                    if (this.dayOfYear != dayAndYear.dayOfYear || this.year != dayAndYear.year) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003JE\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00d6\u0001J\u0006\u0010 \u001a\u00020!J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006$"}, d2={"Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$ParseRequestLogStatResult;", "", "_id", "Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$DayAndYear;", "error", "", "count", "duration", "", "intentProbability", "entitiesProbability", "(Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$DayAndYear;IIDDD)V", "get_id", "()Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$DayAndYear;", "getCount", "()I", "getDuration", "()D", "getEntitiesProbability", "getError", "getIntentProbability", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toStat", "Lai/tock/nlp/front/shared/monitoring/ParseRequestLogStat;", "toString", "", "tock-nlp-front-storage-mongo"})
    public static final class ParseRequestLogStatResult {
        @NotNull
        private final DayAndYear _id;
        private final int error;
        private final int count;
        private final double duration;
        private final double intentProbability;
        private final double entitiesProbability;

        @NotNull
        public final ParseRequestLogStat toStat() {
            LocalDate localDate = LocalDate.ofYearDay(this._id.getYear(), this._id.getDayOfYear());
            Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"LocalDate.ofYearDay(_id.year, _id.dayOfYear)");
            return new ParseRequestLogStat(localDate, this.error, this.count, this.duration, this.intentProbability, this.entitiesProbability);
        }

        @NotNull
        public final DayAndYear get_id() {
            return this._id;
        }

        public final int getError() {
            return this.error;
        }

        public final int getCount() {
            return this.count;
        }

        public final double getDuration() {
            return this.duration;
        }

        public final double getIntentProbability() {
            return this.intentProbability;
        }

        public final double getEntitiesProbability() {
            return this.entitiesProbability;
        }

        public ParseRequestLogStatResult(@NotNull DayAndYear _id2, int error, int count, double duration, double intentProbability, double entitiesProbability) {
            Intrinsics.checkParameterIsNotNull((Object)_id2, (String)"_id");
            this._id = _id2;
            this.error = error;
            this.count = count;
            this.duration = duration;
            this.intentProbability = intentProbability;
            this.entitiesProbability = entitiesProbability;
        }

        @NotNull
        public final DayAndYear component1() {
            return this._id;
        }

        public final int component2() {
            return this.error;
        }

        public final int component3() {
            return this.count;
        }

        public final double component4() {
            return this.duration;
        }

        public final double component5() {
            return this.intentProbability;
        }

        public final double component6() {
            return this.entitiesProbability;
        }

        @NotNull
        public final ParseRequestLogStatResult copy(@NotNull DayAndYear _id2, int error, int count, double duration, double intentProbability, double entitiesProbability) {
            Intrinsics.checkParameterIsNotNull((Object)_id2, (String)"_id");
            return new ParseRequestLogStatResult(_id2, error, count, duration, intentProbability, entitiesProbability);
        }

        public static /* synthetic */ ParseRequestLogStatResult copy$default(ParseRequestLogStatResult parseRequestLogStatResult, DayAndYear dayAndYear, int n, int n2, double d, double d2, double d3, int n3, Object object) {
            if ((n3 & 1) != 0) {
                dayAndYear = parseRequestLogStatResult._id;
            }
            if ((n3 & 2) != 0) {
                n = parseRequestLogStatResult.error;
            }
            if ((n3 & 4) != 0) {
                n2 = parseRequestLogStatResult.count;
            }
            if ((n3 & 8) != 0) {
                d = parseRequestLogStatResult.duration;
            }
            if ((n3 & 0x10) != 0) {
                d2 = parseRequestLogStatResult.intentProbability;
            }
            if ((n3 & 0x20) != 0) {
                d3 = parseRequestLogStatResult.entitiesProbability;
            }
            return parseRequestLogStatResult.copy(dayAndYear, n, n2, d, d2, d3);
        }

        @NotNull
        public String toString() {
            return "ParseRequestLogStatResult(_id=" + this._id + ", error=" + this.error + ", count=" + this.count + ", duration=" + this.duration + ", intentProbability=" + this.intentProbability + ", entitiesProbability=" + this.entitiesProbability + ")";
        }

        public int hashCode() {
            DayAndYear dayAndYear = this._id;
            return (((((dayAndYear != null ? ((Object)dayAndYear).hashCode() : 0) * 31 + Integer.hashCode(this.error)) * 31 + Integer.hashCode(this.count)) * 31 + Double.hashCode(this.duration)) * 31 + Double.hashCode(this.intentProbability)) * 31 + Double.hashCode(this.entitiesProbability);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ParseRequestLogStatResult)) break block3;
                    ParseRequestLogStatResult parseRequestLogStatResult = (ParseRequestLogStatResult)object;
                    if (!Intrinsics.areEqual((Object)this._id, (Object)parseRequestLogStatResult._id) || this.error != parseRequestLogStatResult.error || this.count != parseRequestLogStatResult.count || Double.compare(this.duration, parseRequestLogStatResult.duration) != 0 || Double.compare(this.intentProbability, parseRequestLogStatResult.intentProbability) != 0 || Double.compare(this.entitiesProbability, parseRequestLogStatResult.entitiesProbability) != 0) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

