/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.front.storage.mongo;

import ai.tock.nlp.front.service.storage.TestModelDAO;
import ai.tock.nlp.front.shared.config.ApplicationDefinition;
import ai.tock.nlp.front.shared.config.IntentDefinition;
import ai.tock.nlp.front.shared.test.EntityTestError;
import ai.tock.nlp.front.shared.test.EntityTestErrorQueryResult;
import ai.tock.nlp.front.shared.test.EntityTestError_;
import ai.tock.nlp.front.shared.test.IntentTestError;
import ai.tock.nlp.front.shared.test.IntentTestErrorQueryResult;
import ai.tock.nlp.front.shared.test.IntentTestError_;
import ai.tock.nlp.front.shared.test.TestBuild;
import ai.tock.nlp.front.shared.test.TestBuild_;
import ai.tock.nlp.front.shared.test.TestErrorQuery;
import ai.tock.nlp.front.storage.mongo.IntentDefinitionMongoDAO;
import ai.tock.nlp.front.storage.mongo.MongoHelpersKt;
import ai.tock.nlp.front.storage.mongo.TestModelMongoDAO;
import ai.tock.shared.StringsKt;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoIterable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.KMongoIterableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.FindIterablesKt;
import org.litote.kmongo.Id;
import org.litote.kmongo.MongoCollectionsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J&\u0010\u0017\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J&\u0010\u001f\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0005H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010\"\u001a\u00020#H\u0016R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\t\u001a\u0004\b\f\u0010\u0007R!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\t\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006*"}, d2={"Lai/tock/nlp/front/storage/mongo/TestModelMongoDAO;", "Lai/tock/nlp/front/service/storage/TestModelDAO;", "()V", "buildCol", "Lcom/mongodb/client/MongoCollection;", "Lai/tock/nlp/front/shared/test/TestBuild;", "getBuildCol", "()Lcom/mongodb/client/MongoCollection;", "buildCol$delegate", "Lkotlin/Lazy;", "entityErrorCol", "Lai/tock/nlp/front/shared/test/EntityTestError;", "getEntityErrorCol", "entityErrorCol$delegate", "intentErrorCol", "Lai/tock/nlp/front/shared/test/IntentTestError;", "getIntentErrorCol", "intentErrorCol$delegate", "addTestEntityError", "", "entityError", "addTestIntentError", "intentError", "deleteTestEntityError", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "language", "Ljava/util/Locale;", "text", "", "deleteTestIntentError", "getTestBuilds", "", "query", "Lai/tock/nlp/front/shared/test/TestErrorQuery;", "saveTestBuild", "build", "searchTestEntityErrors", "Lai/tock/nlp/front/shared/test/EntityTestErrorQueryResult;", "searchTestIntentErrors", "Lai/tock/nlp/front/shared/test/IntentTestErrorQueryResult;", "tock-nlp-front-storage-mongo"})
public final class TestModelMongoDAO
implements TestModelDAO {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final Lazy buildCol$delegate;
    private static final Lazy intentErrorCol$delegate;
    private static final Lazy entityErrorCol$delegate;
    public static final TestModelMongoDAO INSTANCE;

    static {
        TestModelMongoDAO testModelMongoDAO;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(TestModelMongoDAO.class), "buildCol", "getBuildCol()Lcom/mongodb/client/MongoCollection;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(TestModelMongoDAO.class), "intentErrorCol", "getIntentErrorCol()Lcom/mongodb/client/MongoCollection;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(TestModelMongoDAO.class), "entityErrorCol", "getEntityErrorCol()Lcom/mongodb/client/MongoCollection;"))};
        INSTANCE = testModelMongoDAO = new TestModelMongoDAO();
        buildCol$delegate = LazyKt.lazy((Function0)buildCol.2.INSTANCE);
        intentErrorCol$delegate = LazyKt.lazy((Function0)intentErrorCol.2.INSTANCE);
        entityErrorCol$delegate = LazyKt.lazy((Function0)entityErrorCol.2.INSTANCE);
    }

    private final MongoCollection<TestBuild> getBuildCol() {
        Lazy lazy = buildCol$delegate;
        TestModelMongoDAO testModelMongoDAO = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (MongoCollection)lazy.getValue();
    }

    private final MongoCollection<IntentTestError> getIntentErrorCol() {
        Lazy lazy = intentErrorCol$delegate;
        TestModelMongoDAO testModelMongoDAO = this;
        KProperty kProperty = $$delegatedProperties[1];
        boolean bl = false;
        return (MongoCollection)lazy.getValue();
    }

    private final MongoCollection<EntityTestError> getEntityErrorCol() {
        Lazy lazy = entityErrorCol$delegate;
        TestModelMongoDAO testModelMongoDAO = this;
        KProperty kProperty = $$delegatedProperties[2];
        boolean bl = false;
        return (MongoCollection)lazy.getValue();
    }

    @NotNull
    public List<TestBuild> getTestBuilds(@NotNull TestErrorQuery query2) {
        Intrinsics.checkParameterIsNotNull((Object)query2, (String)"query");
        boolean bl = false;
        boolean bl2 = false;
        TestErrorQuery $this$with = query2;
        boolean bl3 = false;
        FindIterable findIterable = INSTANCE.getBuildCol().find(FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getLanguage()), (Object)$this$with.getLanguage()), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getApplicationId()), (Object)$this$with.getApplicationId()), $this$with.getAfter() != null ? FiltersKt.gte((KProperty)((KProperty)TestBuild_.Companion.getStartDate()), (Object)$this$with.getAfter()) : null}));
        Intrinsics.checkExpressionValueIsNotNull((Object)findIterable, (String)"buildCol.find(\n         \u2026          )\n            )");
        MongoIterable $this$mapNotNull$iv = (MongoIterable)FindIterablesKt.descendingSort((FindIterable)findIterable, (KProperty[])new KProperty[]{(KProperty)TestBuild_.Companion.getStartDate()});
        boolean $i$f$mapNotNull = false;
        return CollectionsKt.toList((Iterable)((List)KMongoIterableKt.useCursor((MongoIterable)$this$mapNotNull$iv, (Function1)((Function1)new Function1<Iterable<? extends TestBuild>, List<? extends TestBuild>>($this$with){
            final /* synthetic */ TestErrorQuery $this_with$inlined;
            {
                this.$this_with$inlined = testErrorQuery;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<TestBuild> invoke(@NotNull Iterable<? extends TestBuild> it) {
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                Iterable<? extends TestBuild> $this$mapNotNull$iv = it;
                boolean $i$f$mapNotNull = false;
                Iterable<? extends TestBuild> iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    TestBuild testBuild;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    TestBuild it2 = (TestBuild)element$iv$iv;
                    boolean bl2 = false;
                    String intent = this.$this_with$inlined.getIntentName();
                    if (intent == null) {
                        testBuild = it2;
                    } else {
                        Integer n = (Integer)it2.getIntentErrorsByIntent().get(intent);
                        int intentErrors = n != null ? n : 0;
                        Integer n2 = (Integer)it2.getEntityErrorsByIntent().get(intent);
                        int entityErrors = n2 != null ? n2 : 0;
                        Integer n3 = (Integer)it2.getNbSentencesTestedByIntent().get(intent);
                        testBuild = TestBuild.copy$default((TestBuild)it2, null, null, null, null, null, (int)0, (int)(n3 != null ? n3 : 0), (int)(intentErrors + entityErrors), (int)intentErrors, (int)entityErrors, null, null, null, (int)7231, null);
                    }
                    if (testBuild == null) continue;
                    TestBuild testBuild2 = testBuild;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    TestBuild it$iv$iv = testBuild2;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }))));
    }

    public void saveTestBuild(@NotNull TestBuild build) {
        Intrinsics.checkParameterIsNotNull((Object)build, (String)"build");
        this.getBuildCol().insertOne((Object)build);
    }

    @NotNull
    public IntentTestErrorQueryResult searchTestIntentErrors(@NotNull TestErrorQuery query2) {
        IntentTestErrorQueryResult intentTestErrorQueryResult;
        Intrinsics.checkParameterIsNotNull((Object)query2, (String)"query");
        Bson filter = FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getLanguage()), (Object)query2.getLanguage()), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getApplicationId()), (Object)query2.getApplicationId()), query2.getIntentName() == null ? null : FiltersKt.eq((KProperty)((KProperty)IntentTestError_.Companion.getCurrentIntent()), (Object)query2.getIntentName())});
        int count = (int)this.getIntentErrorCol().countDocuments(filter);
        if (count == 0) {
            intentTestErrorQueryResult = new IntentTestErrorQueryResult(0, CollectionsKt.emptyList());
        } else {
            FindIterable findIterable = this.getIntentErrorCol().find(filter);
            Intrinsics.checkExpressionValueIsNotNull((Object)findIterable, (String)"intentErrorCol\n                    .find(filter)");
            FindIterable findIterable2 = FindIterablesKt.descendingSort((FindIterable)findIterable, (KProperty[])new KProperty[]{(KProperty)IntentTestError_.Companion.getCount()}).skip((int)query2.getStart()).limit(query2.getSize());
            Intrinsics.checkExpressionValueIsNotNull((Object)findIterable2, (String)"intentErrorCol\n         \u2026       .limit(query.size)");
            intentTestErrorQueryResult = new IntentTestErrorQueryResult(count, KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable2)));
        }
        return intentTestErrorQueryResult;
    }

    public void addTestIntentError(@NotNull IntentTestError intentError) {
        block6: {
            IntentTestError intentTestError;
            boolean newError;
            block5: {
                Intrinsics.checkParameterIsNotNull((Object)intentError, (String)"intentError");
                Bson filter = FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)IntentTestError_.Companion.getText()), (Object)MongoHelpersKt.textKey(intentError.getText())), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getLanguage()), (Object)intentError.getLanguage()), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getApplicationId()), (Object)intentError.getApplicationId())});
                newError = intentError.getCount() != 0;
                intentTestError = (IntentTestError)MongoCollectionsKt.findOne(this.getIntentErrorCol(), (Bson)filter);
                if (intentTestError == null) break block5;
                IntentTestError intentTestError2 = intentTestError;
                boolean bl = false;
                boolean bl2 = false;
                IntentTestError $this$apply = intentTestError2;
                boolean bl3 = false;
                Instant instant = null;
                int n = $this$apply.getTotal() + 1;
                double d = newError ? ($this$apply.getAverageErrorProbability() * (double)$this$apply.getTotal() + intentError.getAverageErrorProbability()) / (double)($this$apply.getTotal() + 1) : $this$apply.getAverageErrorProbability();
                String string = newError ? intentError.getWrongIntent() : $this$apply.getWrongIntent();
                String string2 = newError ? intentError.getCurrentIntent() : $this$apply.getCurrentIntent();
                int n2 = $this$apply.getCount() + intentError.getCount();
                INSTANCE.getIntentErrorCol().replaceOne(filter, (Object)IntentTestError.copy$default((IntentTestError)$this$apply, null, null, null, (String)string2, (String)string, (double)d, (int)n2, (int)n, instant, (int)263, null));
                intentTestError = intentTestError2;
                if (intentTestError != null) break block6;
            }
            if (newError) {
                MongoCollectionsKt.save(this.getIntentErrorCol(), (Object)IntentTestError.copy$default((IntentTestError)intentError, null, null, (String)MongoHelpersKt.textKey(intentError.getText()), null, null, (double)0.0, (int)0, (int)0, null, (int)507, null));
                intentTestError = Unit.INSTANCE;
            } else {
                intentTestError = Unit.INSTANCE;
            }
        }
    }

    public void deleteTestIntentError(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull(applicationId, (String)"applicationId");
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.getIntentErrorCol().deleteOne(FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)IntentTestError_.Companion.getText()), (Object)MongoHelpersKt.textKey(text)), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getLanguage()), (Object)language), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getApplicationId()), applicationId)}));
    }

    @NotNull
    public EntityTestErrorQueryResult searchTestEntityErrors(@NotNull TestErrorQuery query2) {
        EntityTestErrorQueryResult entityTestErrorQueryResult;
        Bson bson;
        Intrinsics.checkParameterIsNotNull((Object)query2, (String)"query");
        Bson[] bsonArray = new Bson[3];
        bsonArray[0] = FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getLanguage()), (Object)query2.getLanguage());
        bsonArray[1] = FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getApplicationId()), (Object)query2.getApplicationId());
        Bson[] bsonArray2 = bsonArray;
        Bson[] bsonArray3 = bsonArray;
        int n = 2;
        String string = query2.getIntentName();
        if (string != null) {
            Bson bson2;
            String string2 = string;
            int n2 = n;
            Bson[] bsonArray4 = bsonArray2;
            Bson[] bsonArray5 = bsonArray3;
            boolean bl = false;
            boolean bl2 = false;
            String intentName = string2;
            boolean bl3 = false;
            IntentDefinition intentDefinition = IntentDefinitionMongoDAO.INSTANCE.getIntentByNamespaceAndName(StringsKt.namespace((String)intentName), StringsKt.name((String)intentName));
            if (intentDefinition != null) {
                IntentDefinition intentDefinition2 = intentDefinition;
                boolean bl4 = false;
                boolean bl5 = false;
                IntentDefinition it = intentDefinition2;
                boolean bl6 = false;
                bson2 = FiltersKt.eq((KProperty)((KProperty)EntityTestError_.Companion.getIntentId()), (Object)it.get_id());
            } else {
                bson2 = null;
            }
            Bson bson3 = bson2;
            bsonArray3 = bsonArray5;
            bsonArray2 = bsonArray4;
            n = n2;
            bson = bson3;
        } else {
            bson = null;
        }
        bsonArray2[n] = bson;
        Bson filter = FiltersKt.and((Bson[])bsonArray3);
        int count = (int)this.getEntityErrorCol().countDocuments(filter);
        if (count == 0) {
            entityTestErrorQueryResult = new EntityTestErrorQueryResult(0, CollectionsKt.emptyList());
        } else {
            FindIterable findIterable = this.getEntityErrorCol().find(filter);
            Intrinsics.checkExpressionValueIsNotNull((Object)findIterable, (String)"entityErrorCol\n                    .find(filter)");
            FindIterable findIterable2 = FindIterablesKt.descendingSort((FindIterable)findIterable, (KProperty[])new KProperty[]{(KProperty)IntentTestError_.Companion.getCount()}).skip((int)query2.getStart()).limit(query2.getSize());
            Intrinsics.checkExpressionValueIsNotNull((Object)findIterable2, (String)"entityErrorCol\n         \u2026       .limit(query.size)");
            entityTestErrorQueryResult = new EntityTestErrorQueryResult(count, KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable2)));
        }
        return entityTestErrorQueryResult;
    }

    public void addTestEntityError(@NotNull EntityTestError entityError) {
        block6: {
            EntityTestError entityTestError;
            boolean newError;
            block5: {
                Intrinsics.checkParameterIsNotNull((Object)entityError, (String)"entityError");
                Bson filter = FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)IntentTestError_.Companion.getText()), (Object)MongoHelpersKt.textKey(entityError.getText())), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getLanguage()), (Object)entityError.getLanguage()), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getApplicationId()), (Object)entityError.getApplicationId())});
                newError = entityError.getCount() != 0;
                entityTestError = (EntityTestError)MongoCollectionsKt.findOne(this.getEntityErrorCol(), (Bson)filter);
                if (entityTestError == null) break block5;
                EntityTestError entityTestError2 = entityTestError;
                boolean bl = false;
                boolean bl2 = false;
                EntityTestError $this$apply = entityTestError2;
                boolean bl3 = false;
                Instant instant = null;
                int n = $this$apply.getTotal() + 1;
                double d = newError ? ($this$apply.getAverageErrorProbability() * (double)$this$apply.getTotal() + entityError.getAverageErrorProbability()) / (double)($this$apply.getTotal() + 1) : $this$apply.getAverageErrorProbability();
                List list = newError ? entityError.getLastAnalyse() : $this$apply.getLastAnalyse();
                Id id = entityError.getIntentId();
                int n2 = $this$apply.getCount() + entityError.getCount();
                INSTANCE.getEntityErrorCol().replaceOne(filter, (Object)EntityTestError.copy$default((EntityTestError)$this$apply, null, null, null, (Id)id, (List)list, (double)d, (int)n2, (int)n, instant, (int)263, null));
                entityTestError = entityTestError2;
                if (entityTestError != null) break block6;
            }
            if (newError) {
                MongoCollectionsKt.save(this.getEntityErrorCol(), (Object)EntityTestError.copy$default((EntityTestError)entityError, null, null, (String)MongoHelpersKt.textKey(entityError.getText()), null, null, (double)0.0, (int)0, (int)0, null, (int)507, null));
                entityTestError = Unit.INSTANCE;
            } else {
                entityTestError = Unit.INSTANCE;
            }
        }
    }

    public void deleteTestEntityError(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull(applicationId, (String)"applicationId");
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.getEntityErrorCol().deleteOne(FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)IntentTestError_.Companion.getText()), (Object)MongoHelpersKt.textKey(text)), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getLanguage()), (Object)language), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getApplicationId()), applicationId)}));
    }

    private TestModelMongoDAO() {
    }
}

