/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.front.storage.mongo;

import ai.tock.nlp.front.service.storage.ClassifiedSentenceDAO;
import ai.tock.nlp.front.shared.config.ApplicationDefinition;
import ai.tock.nlp.front.shared.config.Classification;
import ai.tock.nlp.front.shared.config.Classification_;
import ai.tock.nlp.front.shared.config.ClassifiedEntity;
import ai.tock.nlp.front.shared.config.ClassifiedEntity_;
import ai.tock.nlp.front.shared.config.ClassifiedSentence;
import ai.tock.nlp.front.shared.config.ClassifiedSentenceStatus;
import ai.tock.nlp.front.shared.config.EntityDefinition;
import ai.tock.nlp.front.shared.config.IntentDefinition;
import ai.tock.nlp.front.shared.config.SearchMark;
import ai.tock.nlp.front.shared.config.SentencesQuery;
import ai.tock.nlp.front.shared.config.SentencesQueryResult;
import ai.tock.nlp.front.storage.mongo.ApplicationDefinitionMongoDAO;
import ai.tock.nlp.front.storage.mongo.ClassifiedSentenceCol_;
import ai.tock.nlp.front.storage.mongo.ClassifiedSentenceMongoDAO;
import ai.tock.nlp.front.storage.mongo.MongoHelpersKt;
import ai.tock.nlp.front.storage.mongo.ParseRequestLogMongoDAO;
import ai.tock.shared.LocalesKt;
import com.mongodb.Function;
import com.mongodb.ReadPreference;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.ReplaceOptions;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.KMongoIterableKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.FindIterablesKt;
import org.litote.kmongo.Id;
import org.litote.kmongo.MongoCollectionsKt;
import org.litote.kmongo.MongoOperator;
import org.litote.kmongo.PropertiesKt;
import org.litote.kmongo.SetTo;
import org.litote.kmongo.SharedExtensionsKt;
import org.litote.kmongo.SortsKt;
import org.litote.kmongo.UpdatesKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001SB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J8\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0014\u0010\u0019\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u0011\u0018\u00010\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J&\u0010\u001e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J4\u0010!\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00112\u0006\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020 H\u0016J.\u0010%\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020 2\u0006\u0010&\u001a\u00020'H\u0002J&\u0010(\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020 H\u0016J\u0010\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u0018H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0016\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020 0\u0017H\u0002J\u0016\u00102\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020 0\u0017H\u0002J\u0010\u00103\u001a\u0002002\u0006\u0010#\u001a\u00020 H\u0002J&\u00104\u001a\u00020\u000f2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000207H\u0016J$\u00109\u001a\u00020\u000f2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0011H\u0016J2\u00109\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00112\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0011H\u0016J\u001e\u0010<\u001a\u00020\u000f2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010=\u001a\u00020\u0015H\u0016J\u0015\u0010>\u001a\u00020\u000f2\u0006\u0010?\u001a\u00020@H\u0000\u00a2\u0006\u0002\bAJ\u001c\u0010B\u001a\b\u0012\u0004\u0012\u00020 0\u00172\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\f\u0010C\u001a\u000200*\u00020.H\u0002J\u000e\u0010D\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010E\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010F\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010G\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010H\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010I\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010J\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010K\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010L\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010M\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010N\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010O\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010P\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010Q\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010R\u001a\u0004\u0018\u000100*\u00020.H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lai/tock/nlp/front/storage/mongo/ClassifiedSentenceMongoDAO;", "Lai/tock/nlp/front/service/storage/ClassifiedSentenceDAO;", "()V", "Classification_", "Lai/tock/nlp/front/shared/config/Classification_;", "Lai/tock/nlp/front/storage/mongo/ClassifiedSentenceMongoDAO$ClassifiedSentenceCol;", "col", "Lcom/mongodb/client/MongoCollection;", "getCol", "()Lcom/mongodb/client/MongoCollection;", "col$delegate", "Lkotlin/Lazy;", "logger", "Lmu/KLogger;", "deleteSentencesByApplicationId", "", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "deleteSentencesByStatus", "status", "Lai/tock/nlp/front/shared/config/ClassifiedSentenceStatus;", "getSentences", "", "Lai/tock/nlp/front/shared/config/ClassifiedSentence;", "intents", "", "Lai/tock/nlp/front/shared/config/IntentDefinition;", "language", "Ljava/util/Locale;", "incrementUnknownStat", "text", "", "removeEntityFromSentences", "intentId", "entityType", "role", "removeSubEntitiesFromSentence", "level", "", "removeSubEntityFromSentences", "save", "sentence", "search", "Lai/tock/nlp/front/shared/config/SentencesQueryResult;", "query", "Lai/tock/nlp/front/shared/config/SentencesQuery;", "subEntityRoleQueryToExclude", "Lorg/bson/conversions/Bson;", "roles", "subEntityRoleQueryToInclude", "subEntityTypeQuery", "switchSentencesEntity", "sentences", "oldEntity", "Lai/tock/nlp/front/shared/config/EntityDefinition;", "newEntity", "switchSentencesIntent", "newIntentId", "oldIntentId", "switchSentencesStatus", "newStatus", "updateSentenceState", "stat", "Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$ParseRequestLogStatCol;", "updateSentenceState$tock_nlp_front_storage_mongo", "users", "filterApplication", "filterByAllButUser", "filterByUser", "filterEntityRoleToExclude", "filterEntityRolesToInclude", "filterEntityType", "filterIntent", "filterLanguage", "filterMaxIntentProbability", "filterMinIntentProbability", "filterModifiedAfter", "filterModifiedBefore", "filterReviewOnly", "filterSearchMark", "filterStatus", "filterText", "ClassifiedSentenceCol", "tock-nlp-front-storage-mongo"})
public final class ClassifiedSentenceMongoDAO
implements ClassifiedSentenceDAO {
    private static final KLogger logger;
    private static final Classification_<ClassifiedSentenceCol> Classification_;
    private static final Lazy col$delegate;
    public static final ClassifiedSentenceMongoDAO INSTANCE;

    private final MongoCollection<ClassifiedSentenceCol> getCol() {
        Lazy lazy = col$delegate;
        ClassifiedSentenceMongoDAO classifiedSentenceMongoDAO = this;
        Object var3_3 = null;
        boolean bl = false;
        return (MongoCollection)lazy.getValue();
    }

    @NotNull
    public List<ClassifiedSentence> getSentences(@Nullable Set<? extends Id<IntentDefinition>> intents2, @Nullable Locale language, @Nullable ClassifiedSentenceStatus status) {
        if (intents2 == null && language == null && status == null) {
            String string = "at least one parameter should be not null";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        MongoIterable mongoIterable = MongoCollectionsKt.find(this.getCol(), (Bson[])new Bson[]{intents2 != null ? FiltersKt.in((KProperty)((KProperty)Classification_.getIntentId()), (Iterable)intents2) : null, language != null ? FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLanguage()), (Object)language) : null, status != null ? FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getStatus()), (Object)status) : null}).map((Function)getSentences.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoIterable, (String)"col\n            .find(\n \u2026 .map { it.toSentence() }");
        return KMongoIterableKt.toList((MongoIterable)mongoIterable);
    }

    public void switchSentencesStatus(@NotNull List<ClassifiedSentence> sentences, @NotNull ClassifiedSentenceStatus newStatus) {
        Intrinsics.checkParameterIsNotNull(sentences, (String)"sentences");
        Intrinsics.checkParameterIsNotNull((Object)newStatus, (String)"newStatus");
        Iterable $this$forEach$iv = sentences;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassifiedSentence it = (ClassifiedSentence)element$iv;
            boolean bl = false;
            INSTANCE.save(ClassifiedSentence.copy$default((ClassifiedSentence)it, null, null, null, null, null, (ClassifiedSentenceStatus)newStatus, null, null, null, null, (long)0L, (long)0L, (boolean)false, null, null, null, (int)65503, null));
        }
    }

    public void deleteSentencesByStatus(@NotNull ClassifiedSentenceStatus status) {
        Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
        this.getCol().deleteMany(FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getStatus()), (Object)status));
    }

    public void deleteSentencesByApplicationId(@NotNull Id<ApplicationDefinition> applicationId) {
        Intrinsics.checkParameterIsNotNull(applicationId, (String)"applicationId");
        this.getCol().deleteMany(FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), applicationId));
    }

    public void save(@NotNull ClassifiedSentence sentence) {
        Intrinsics.checkParameterIsNotNull((Object)sentence, (String)"sentence");
        MongoCollection<ClassifiedSentenceCol> mongoCollection = this.getCol();
        Bson bson = FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getText()), (Object)MongoHelpersKt.textKey(sentence.getText())), FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLanguage()), (Object)sentence.getLanguage()), FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), (Object)sentence.getApplicationId())});
        ClassifiedSentenceCol classifiedSentenceCol = new ClassifiedSentenceCol(sentence);
        ReplaceOptions replaceOptions = new ReplaceOptions().upsert(true);
        Intrinsics.checkExpressionValueIsNotNull((Object)replaceOptions, (String)"ReplaceOptions().upsert(true)");
        MongoCollectionsKt.replaceOneWithFilter(mongoCollection, (Bson)bson, (Object)classifiedSentenceCol, (ReplaceOptions)replaceOptions);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> users(@NotNull Id<ApplicationDefinition> applicationId) {
        void field$iv;
        void $this$distinct$iv;
        Intrinsics.checkParameterIsNotNull(applicationId, (String)"applicationId");
        MongoCollection<ClassifiedSentenceCol> mongoCollection = this.getCol();
        KProperty1<ClassifiedSentenceCol, String> kProperty1 = ClassifiedSentenceCol_.Companion.getClassifier();
        Bson filter$iv = FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), applicationId), FiltersKt.in((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getStatus()), (Iterable)CollectionsKt.listOf((Object[])new ClassifiedSentenceStatus[]{ClassifiedSentenceStatus.validated, ClassifiedSentenceStatus.model}))});
        boolean $i$f$distinct = false;
        DistinctIterable distinctIterable = $this$distinct$iv.distinct(PropertiesKt.path((KProperty)((KProperty)field$iv)), filter$iv, String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)distinctIterable, (String)"distinct(field.path(), f\u2026ter, TResult::class.java)");
        return KMongoIterableKt.filterNotNull((MongoIterable)((MongoIterable)distinctIterable));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public SentencesQueryResult search(@NotNull SentencesQuery query2) {
        Intrinsics.checkParameterIsNotNull((Object)query2, (String)"query");
        boolean bl = false;
        boolean bl2 = false;
        SentencesQuery $this$with = query2;
        boolean bl3 = false;
        Bson filterBase = FiltersKt.and((Bson[])new Bson[]{INSTANCE.filterApplication($this$with), INSTANCE.filterLanguage($this$with), INSTANCE.filterText($this$with), INSTANCE.filterIntent($this$with), INSTANCE.filterStatus($this$with), INSTANCE.filterEntityType($this$with), INSTANCE.filterEntityRolesToInclude($this$with), INSTANCE.filterEntityRoleToExclude($this$with), INSTANCE.filterSearchMark($this$with), INSTANCE.filterModifiedAfter($this$with), INSTANCE.filterModifiedBefore($this$with), INSTANCE.filterReviewOnly($this$with), INSTANCE.filterByUser($this$with), INSTANCE.filterByAllButUser($this$with), INSTANCE.filterMaxIntentProbability($this$with), INSTANCE.filterMinIntentProbability($this$with)});
        logger.debug((Function0)new Function0<String>(filterBase){
            final /* synthetic */ Bson $filterBase;

            @NotNull
            public final String invoke() {
                return SharedExtensionsKt.getJson((Object)this.$filterBase);
            }
            {
                this.$filterBase = bson;
                super(0);
            }
        });
        MongoCollection c = $this$with.getOnlyExactMatch() ? INSTANCE.getCol() : INSTANCE.getCol().withReadPreference(ReadPreference.secondaryPreferred());
        long count = c.countDocuments(filterBase);
        logger.debug((Function0)new Function0<String>(count){
            final /* synthetic */ long $count;

            @NotNull
            public final String invoke() {
                return "count : " + this.$count;
            }
            {
                this.$count = l;
                super(0);
            }
        });
        if (count > $this$with.getStart()) {
            FindIterable findIterable;
            Iterable iterable;
            FindIterable findIterable2;
            FindIterable findIterable3 = c.find(filterBase);
            boolean bl4 = false;
            boolean bl5 = false;
            FindIterable $this$run = findIterable3;
            boolean bl6 = false;
            if (query2.getSort().isEmpty()) {
                findIterable2 = FindIterablesKt.descendingSort((FindIterable)$this$run, (KProperty[])new KProperty[]{(KProperty)ClassifiedSentenceCol_.Companion.getUpdateDate()});
            } else {
                Collection<Pair> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                iterable = query2.getSort();
                FindIterable findIterable4 = $this$run;
                boolean $i$f$map = false;
                void var18_18 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Object object;
                    void it;
                    Pair pair = (Pair)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl7 = false;
                    switch ((String)it.getFirst()) {
                        case "text": {
                            object = ClassifiedSentenceCol_.Companion.getText();
                            break;
                        }
                        case "currentIntent": {
                            object = (KProperty1)Classification_.getIntentId();
                            break;
                        }
                        case "intentProbability": {
                            object = ClassifiedSentenceCol_.Companion.getLastIntentProbability();
                            break;
                        }
                        case "entitiesProbability": {
                            object = ClassifiedSentenceCol_.Companion.getLastEntityProbability();
                            break;
                        }
                        case "lastUpdate": {
                            object = ClassifiedSentenceCol_.Companion.getUpdateDate();
                            break;
                        }
                        case "lastUsage": {
                            object = ClassifiedSentenceCol_.Companion.getLastUsage();
                            break;
                        }
                        case "usageCount": {
                            object = ClassifiedSentenceCol_.Companion.getUsageCount();
                            break;
                        }
                        case "unknownCount": {
                            object = ClassifiedSentenceCol_.Companion.getUnknownCount();
                            break;
                        }
                        default: {
                            object = ClassifiedSentenceCol_.Companion.getUpdateDate();
                        }
                    }
                    Pair pair2 = TuplesKt.to(object, (Object)it.getSecond());
                    collection.add(pair2);
                }
                collection = (List)destination$iv$iv;
                findIterable2 = findIterable4.sort(SortsKt.orderBy((Map)MapsKt.toMap((Iterable)collection)));
            }
            findIterable3 = findIterable2;
            bl4 = false;
            bl5 = false;
            $this$run = findIterable3;
            boolean bl8 = false;
            iterable = query2.getSort();
            boolean bl9 = false;
            if (!iterable.isEmpty()) {
                Collation.Builder builder = Collation.builder().caseLevel(Boolean.valueOf(false));
                Locale locale = query2.getLanguage();
                if (locale == null) {
                    locale = LocalesKt.getDefaultLocale();
                }
                findIterable = $this$run.collation(builder.locale(locale.toLanguageTag()).build());
            } else {
                findIterable = $this$run;
            }
            FindIterable list = findIterable.skip((int)$this$with.getStart()).limit($this$with.getSize());
            MongoIterable mongoIterable = list.map((Function)search.1.3.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)mongoIterable, (String)"list.map { it.toSentence() }");
            return new SentencesQueryResult(count, KMongoIterableKt.toList((MongoIterable)mongoIterable));
        }
        return new SentencesQueryResult(count, CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    private final Bson filterApplication(@NotNull SentencesQuery $this$filterApplication) {
        Bson bson;
        if ($this$filterApplication.getWholeNamespace()) {
            Iterable iterable;
            KProperty kProperty = (KProperty)ClassifiedSentenceCol_.Companion.getApplicationId();
            Object object = ApplicationDefinitionMongoDAO.INSTANCE.getApplicationById((Id<ApplicationDefinition>)$this$filterApplication.getApplicationId());
            if (object != null && (object = object.getNamespace()) != null) {
                void $this$mapTo$iv$iv;
                Object object2 = object;
                KProperty kProperty2 = kProperty;
                boolean bl = false;
                boolean bl2 = false;
                Object n = object2;
                boolean bl3 = false;
                Iterable $this$map$iv = ApplicationDefinitionMongoDAO.INSTANCE.getApplicationsByNamespace((String)n);
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ApplicationDefinition applicationDefinition = (ApplicationDefinition)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    Id id = it.get_id();
                    collection.add(id);
                }
                List list = (List)destination$iv$iv;
                kProperty = kProperty2;
                iterable = list;
            } else {
                iterable = CollectionsKt.emptyList();
            }
            bson = FiltersKt.in((KProperty)kProperty, (Iterable)iterable);
        } else {
            bson = FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), (Object)$this$filterApplication.getApplicationId());
        }
        return bson;
    }

    private final Bson filterReviewOnly(@NotNull SentencesQuery $this$filterReviewOnly) {
        return $this$filterReviewOnly.getOnlyToReview() ? FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getForReview()), (Object)true) : null;
    }

    private final Bson filterByUser(@NotNull SentencesQuery $this$filterByUser) {
        return $this$filterByUser.getUser() != null ? FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getClassifier()), (Object)$this$filterByUser.getUser()) : null;
    }

    private final Bson filterByAllButUser(@NotNull SentencesQuery $this$filterByAllButUser) {
        return $this$filterByAllButUser.getAllButUser() != null ? FiltersKt.ne((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getClassifier()), (Object)$this$filterByAllButUser.getAllButUser()) : null;
    }

    private final Bson filterSearchMark(@NotNull SentencesQuery $this$filterSearchMark) {
        Bson bson;
        if ($this$filterSearchMark.getSearchMark() == null) {
            bson = null;
        } else {
            SearchMark searchMark = $this$filterSearchMark.getSearchMark();
            bson = FiltersKt.lte((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getUpdateDate()), (Object)(searchMark != null ? searchMark.getDate() : null));
        }
        return bson;
    }

    private final Bson filterModifiedAfter(@NotNull SentencesQuery $this$filterModifiedAfter) {
        Bson bson;
        if ($this$filterModifiedAfter.getModifiedAfter() == null) {
            bson = null;
        } else {
            ZonedDateTime zonedDateTime = $this$filterModifiedAfter.getModifiedAfter();
            bson = FiltersKt.gt((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getUpdateDate()), (Object)(zonedDateTime != null ? zonedDateTime.toInstant() : null));
        }
        return bson;
    }

    private final Bson filterModifiedBefore(@NotNull SentencesQuery $this$filterModifiedBefore) {
        Bson bson;
        if ($this$filterModifiedBefore.getModifiedBefore() == null) {
            bson = null;
        } else {
            ZonedDateTime zonedDateTime = $this$filterModifiedBefore.getModifiedBefore();
            bson = FiltersKt.lt((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getUpdateDate()), (Object)(zonedDateTime != null ? zonedDateTime.toInstant() : null));
        }
        return bson;
    }

    private final Bson filterEntityRoleToExclude(@NotNull SentencesQuery $this$filterEntityRoleToExclude) {
        return $this$filterEntityRoleToExclude.getEntityRolesToExclude().isEmpty() ? null : ($this$filterEntityRoleToExclude.getSearchSubEntities() ? this.subEntityRoleQueryToExclude($this$filterEntityRoleToExclude.getEntityRolesToExclude()) : FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getRole()), (Iterable)$this$filterEntityRoleToExclude.getEntityRolesToExclude()));
    }

    private final Bson filterEntityRolesToInclude(@NotNull SentencesQuery $this$filterEntityRolesToInclude) {
        return $this$filterEntityRolesToInclude.getEntityRolesToInclude().isEmpty() ? null : ($this$filterEntityRolesToInclude.getSearchSubEntities() ? this.subEntityRoleQueryToInclude($this$filterEntityRolesToInclude.getEntityRolesToInclude()) : FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getRole()), (Iterable)$this$filterEntityRolesToInclude.getEntityRolesToInclude()));
    }

    private final Bson filterEntityType(@NotNull SentencesQuery $this$filterEntityType) {
        Bson bson;
        if ($this$filterEntityType.getEntityType() == null) {
            bson = null;
        } else if ($this$filterEntityType.getSearchSubEntities()) {
            String string = $this$filterEntityType.getEntityType();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            bson = this.subEntityTypeQuery(string);
        } else {
            bson = FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getType()), (Object)$this$filterEntityType.getEntityType());
        }
        return bson;
    }

    private final Bson filterStatus(@NotNull SentencesQuery $this$filterStatus) {
        Collection collection = $this$filterStatus.getStatus();
        boolean bl = false;
        return !collection.isEmpty() ? FiltersKt.in((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getStatus()), (Iterable)$this$filterStatus.getStatus()) : ($this$filterStatus.getNotStatus() != null ? FiltersKt.ne((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getStatus()), (Object)$this$filterStatus.getNotStatus()) : null);
    }

    private final Bson filterIntent(@NotNull SentencesQuery $this$filterIntent) {
        return $this$filterIntent.getIntentId() == null ? null : FiltersKt.eq((KProperty)((KProperty)Classification_.getIntentId()), (Object)$this$filterIntent.getIntentId());
    }

    private final Bson filterText(@NotNull SentencesQuery $this$filterText) {
        Bson bson;
        CharSequence charSequence = $this$filterText.getSearch();
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            bson = null;
        } else if ($this$filterText.getOnlyExactMatch()) {
            bson = FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getText()), (Object)$this$filterText.getSearch());
        } else {
            KProperty kProperty = (KProperty)ClassifiedSentenceCol_.Companion.getFullText();
            String string = $this$filterText.getSearch();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            charSequence = string;
            KProperty kProperty2 = kProperty;
            bl = false;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string2 = ((Object)StringsKt.trim((CharSequence)charSequence2)).toString();
            bson = FiltersKt.regex((KProperty)kProperty2, (String)string2, (String)"i");
        }
        return bson;
    }

    private final Bson filterLanguage(@NotNull SentencesQuery $this$filterLanguage) {
        return $this$filterLanguage.getLanguage() == null ? null : FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLanguage()), (Object)$this$filterLanguage.getLanguage());
    }

    private final Bson filterMaxIntentProbability(@NotNull SentencesQuery $this$filterMaxIntentProbability) {
        return $this$filterMaxIntentProbability.getMaxIntentProbability() < 1.0f ? FiltersKt.lt((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLastIntentProbability()), (Object)$this$filterMaxIntentProbability.getMaxIntentProbability()) : null;
    }

    private final Bson filterMinIntentProbability(@NotNull SentencesQuery $this$filterMinIntentProbability) {
        return $this$filterMinIntentProbability.getMinIntentProbability() > 0.0f ? FiltersKt.gt((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLastIntentProbability()), (Object)$this$filterMinIntentProbability.getMinIntentProbability()) : null;
    }

    private final Bson subEntityTypeQuery(String entityType) {
        return FiltersKt.or((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getType()), (Object)entityType)});
    }

    private final Bson subEntityRoleQueryToInclude(List<String> roles) {
        return FiltersKt.or((Bson[])new Bson[]{FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles)});
    }

    private final Bson subEntityRoleQueryToExclude(List<String> roles) {
        return FiltersKt.and((Bson[])new Bson[]{FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles)});
    }

    public void switchSentencesIntent(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Id<IntentDefinition> oldIntentId, @NotNull Id<IntentDefinition> newIntentId) {
        Intrinsics.checkParameterIsNotNull(applicationId, (String)"applicationId");
        Intrinsics.checkParameterIsNotNull(oldIntentId, (String)"oldIntentId");
        Intrinsics.checkParameterIsNotNull(newIntentId, (String)"newIntentId");
        MongoCollectionsKt.updateMany$default(this.getCol(), (Bson)FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), applicationId), FiltersKt.eq((KProperty)((KProperty)Classification_.getIntentId()), oldIntentId)}), (SetTo[])new SetTo[]{UpdatesKt.setTo((KProperty)((KProperty)Classification_.getIntentId()), newIntentId), UpdatesKt.setTo((KProperty)((KProperty)Classification_.getEntities()), (Object)CollectionsKt.emptyList()), UpdatesKt.setTo((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getStatus()), (Object)ClassifiedSentenceStatus.inbox)}, null, (int)4, null);
    }

    public void switchSentencesIntent(@NotNull List<ClassifiedSentence> sentences, @NotNull Id<IntentDefinition> newIntentId) {
        Intrinsics.checkParameterIsNotNull(sentences, (String)"sentences");
        Intrinsics.checkParameterIsNotNull(newIntentId, (String)"newIntentId");
        Iterable $this$forEach$iv = sentences;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassifiedSentence it = (ClassifiedSentence)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)newIntentId.toString(), (Object)"tock:unknown")) {
                INSTANCE.save(ClassifiedSentence.copy$default((ClassifiedSentence)it, null, null, null, null, null, null, (Classification)it.getClassification().copy(newIntentId, CollectionsKt.emptyList()), null, null, null, (long)0L, (long)0L, (boolean)false, null, null, null, (int)65471, null));
                continue;
            }
            INSTANCE.save(ClassifiedSentence.copy$default((ClassifiedSentence)it, null, null, null, null, null, null, (Classification)Classification.copy$default((Classification)it.getClassification(), newIntentId, null, (int)2, null), null, null, null, (long)0L, (long)0L, (boolean)false, null, null, null, (int)65471, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void switchSentencesEntity(@NotNull List<ClassifiedSentence> sentences, @NotNull EntityDefinition oldEntity, @NotNull EntityDefinition newEntity) {
        Intrinsics.checkParameterIsNotNull(sentences, (String)"sentences");
        Intrinsics.checkParameterIsNotNull((Object)oldEntity, (String)"oldEntity");
        Intrinsics.checkParameterIsNotNull((Object)newEntity, (String)"newEntity");
        Iterable $this$forEach$iv = sentences;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection<ClassifiedEntity> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            ClassifiedEntity it;
            void $this$filterTo$iv$iv;
            ClassifiedSentence it2 = (ClassifiedSentence)element$iv;
            boolean bl = false;
            Iterable $this$filter$iv = it2.getClassification().getEntities();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ClassifiedEntity)element$iv$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)it.getRole(), (Object)oldEntity.getRole()) && Intrinsics.areEqual((Object)it.getType(), (Object)oldEntity.getEntityTypeName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List selectedEntities = (List)destination$iv$iv;
            $this$filter$iv = it2.getClassification().getEntities();
            Id id = null;
            Classification classification2 = it2.getClassification();
            ClassifiedSentenceStatus classifiedSentenceStatus = null;
            Instant instant = null;
            Instant instant2 = null;
            Id id2 = null;
            Locale locale = null;
            String string = null;
            ClassifiedSentence classifiedSentence = it2;
            ClassifiedSentenceMongoDAO classifiedSentenceMongoDAO = INSTANCE;
            boolean $i$f$filterNot = false;
            $this$filterTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (ClassifiedEntity)element$iv$iv;
                boolean bl3 = false;
                if (Intrinsics.areEqual((Object)it.getRole(), (Object)oldEntity.getRole()) && Intrinsics.areEqual((Object)it.getType(), (Object)oldEntity.getEntityTypeName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection collection2 = (List)destination$iv$iv;
            $this$filterNot$iv = selectedEntities;
            collection2 = collection2;
            boolean $i$f$map = false;
            $this$filterNotTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ClassifiedEntity)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                ClassifiedEntity classifiedEntity = ClassifiedEntity.copy$default((ClassifiedEntity)it, (String)newEntity.getEntityTypeName(), (String)newEntity.getRole(), (int)0, (int)0, null, (int)28, null);
                collection.add(classifiedEntity);
            }
            collection = (List)destination$iv$iv;
            classifiedSentenceMongoDAO.save(ClassifiedSentence.copy$default((ClassifiedSentence)classifiedSentence, string, locale, id2, instant2, instant, classifiedSentenceStatus, (Classification)Classification.copy$default((Classification)classification2, id, (List)CollectionsKt.plus((Collection)collection2, (Iterable)collection), (int)1, null), null, null, null, (long)0L, (long)0L, (boolean)false, null, null, null, (int)65471, null));
        }
    }

    public void removeEntityFromSentences(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Id<IntentDefinition> intentId, @NotNull String entityType, @NotNull String role) {
        Intrinsics.checkParameterIsNotNull(applicationId, (String)"applicationId");
        Intrinsics.checkParameterIsNotNull(intentId, (String)"intentId");
        Intrinsics.checkParameterIsNotNull((Object)entityType, (String)"entityType");
        Intrinsics.checkParameterIsNotNull((Object)role, (String)"role");
        this.getCol().updateMany(FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), applicationId), FiltersKt.eq((KProperty)((KProperty)Classification_.getIntentId()), intentId)}), UpdatesKt.pullByFilter((KProperty)((KProperty)Classification_.getEntities()), (Bson)FiltersKt.eq((KProperty)((KProperty)ClassifiedEntity_.Companion.getRole()), (Object)role)));
    }

    public void removeSubEntityFromSentences(@NotNull Id<ApplicationDefinition> applicationId, @NotNull String entityType, @NotNull String role) {
        Intrinsics.checkParameterIsNotNull(applicationId, (String)"applicationId");
        Intrinsics.checkParameterIsNotNull((Object)entityType, (String)"entityType");
        Intrinsics.checkParameterIsNotNull((Object)role, (String)"role");
        int n = 1;
        Iterable $this$forEach$iv = (Iterable)new IntRange(n, 10);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            INSTANCE.removeSubEntitiesFromSentence(applicationId, entityType, role, it);
        }
    }

    private final void removeSubEntitiesFromSentence(Id<ApplicationDefinition> applicationId, String entityType, String role, int level) {
        int n = 2;
        String baseFilter2 = "classification.entities" + CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(n, level)), (CharSequence)"", null, null, (int)0, null, (Function1)removeSubEntitiesFromSentence.baseFilter.1.INSTANCE, (int)30, null);
        String filter = "{\n            'applicationId':" + SharedExtensionsKt.getJson(applicationId) + ",\n            '" + baseFilter2 + "':{\n                " + MongoOperator.elemMatch + " :{\n                    type:" + SharedExtensionsKt.getJson((Object)entityType) + ",\n                    subEntities:{\n                        " + MongoOperator.elemMatch + ":{\n                            'role':" + SharedExtensionsKt.getJson((Object)role) + "\n                        }\n                    }\n                }\n            }\n        }";
        String update = "{\n                    " + MongoOperator.pull + ":{\n                        '" + StringsKt.replace$default((String)baseFilter2, (String)".subEntities", (String)".$[].subEntities", (boolean)false, (int)4, null) + ".$.subEntities':{\n                            'role':" + SharedExtensionsKt.getJson((Object)role) + "\n                            }\n                        }\n                    }";
        logger.debug((Function0)new Function0<String>(filter, update){
            final /* synthetic */ String $filter;
            final /* synthetic */ String $update;

            @NotNull
            public final String invoke() {
                return this.$filter + ' ' + this.$update;
            }
            {
                this.$filter = string;
                this.$update = string2;
                super(0);
            }
        });
        MongoCollectionsKt.updateMany$default(this.getCol(), (String)filter, (String)update, null, (int)4, null);
    }

    public final void updateSentenceState$tock_nlp_front_storage_mongo(@NotNull ParseRequestLogMongoDAO.ParseRequestLogStatCol stat) {
        Bson bson;
        Bson bson2;
        Bson bson3;
        double it;
        boolean bl;
        boolean bl2;
        MongoCollection<ClassifiedSentenceCol> mongoCollection;
        Bson bson4;
        Object[] objectArray;
        Object[] objectArray2;
        int n;
        Double d;
        Intrinsics.checkParameterIsNotNull((Object)stat, (String)"stat");
        MongoCollection<ClassifiedSentenceCol> mongoCollection2 = this.getCol();
        Bson bson5 = FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLanguage()), (Object)stat.getLanguage()), FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), stat.getApplicationId()), FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getText()), (Object)stat.getText())});
        Object[] objectArray3 = new Bson[4];
        Object[] objectArray4 = objectArray3;
        Object[] objectArray5 = objectArray3;
        int n2 = 0;
        Double d2 = stat.getIntentProbability();
        if (d2 != null) {
            d = d2;
            n = n2;
            objectArray2 = objectArray4;
            objectArray = objectArray5;
            bson4 = bson5;
            mongoCollection = mongoCollection2;
            bl2 = false;
            bl = false;
            it = ((Number)d).doubleValue();
            boolean bl3 = false;
            bson3 = UpdatesKt.setValue((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLastIntentProbability()), (Object)it);
            mongoCollection2 = mongoCollection;
            bson5 = bson4;
            objectArray5 = objectArray;
            objectArray4 = objectArray2;
            n2 = n;
            bson2 = bson3;
        } else {
            bson2 = null;
        }
        objectArray4[n2] = bson2;
        Object[] objectArray6 = objectArray5;
        Object[] objectArray7 = objectArray5;
        int n3 = 1;
        Double d3 = stat.getEntitiesProbability();
        if (d3 != null) {
            d = d3;
            n = n3;
            objectArray2 = objectArray6;
            objectArray = objectArray7;
            bson4 = bson5;
            mongoCollection = mongoCollection2;
            bl2 = false;
            bl = false;
            it = ((Number)d).doubleValue();
            boolean bl4 = false;
            bson3 = UpdatesKt.setValue((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLastEntityProbability()), (Object)it);
            mongoCollection2 = mongoCollection;
            bson5 = bson4;
            objectArray7 = objectArray;
            objectArray6 = objectArray2;
            n3 = n;
            bson = bson3;
        } else {
            bson = null;
        }
        objectArray6[n3] = bson;
        objectArray7[2] = UpdatesKt.setValue((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLastUsage()), (Object)stat.getLastUsage());
        objectArray7[3] = UpdatesKt.setValue((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getUsageCount()), (Object)stat.getCount());
        mongoCollection2.updateOne(bson5, UpdatesKt.combine((List)CollectionsKt.listOfNotNull((Object[])objectArray7)));
    }

    public void incrementUnknownStat(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull(applicationId, (String)"applicationId");
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.getCol().updateOne(FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLanguage()), (Object)language), FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), applicationId), FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getText()), (Object)text)}), UpdatesKt.inc((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getUnknownCount()), (Number)1));
    }

    private ClassifiedSentenceMongoDAO() {
    }

    static {
        ClassifiedSentenceMongoDAO classifiedSentenceMongoDAO;
        INSTANCE = classifiedSentenceMongoDAO = new ClassifiedSentenceMongoDAO();
        logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        Classification_ = ClassifiedSentenceCol_.Companion.getClassification();
        col$delegate = LazyKt.lazy((Function0)col.2.INSTANCE);
    }

    public static final /* synthetic */ Classification_ access$getClassification_$p(ClassifiedSentenceMongoDAO $this) {
        ClassifiedSentenceMongoDAO classifiedSentenceMongoDAO = $this;
        return Classification_;
    }

    public static final /* synthetic */ KLogger access$getLogger$p(ClassifiedSentenceMongoDAO $this) {
        ClassifiedSentenceMongoDAO classifiedSentenceMongoDAO = $this;
        return logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b4\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u00c7\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u0012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0015\u0012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u0012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0019\u0012\b\b\u0002\u0010\u001b\u001a\u00020\u001c\u0012\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0006\u0012\u0010\b\u0002\u0010\u001e\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u001f\u0012\u0014\b\u0002\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150!\u00a2\u0006\u0002\u0010\"J\t\u0010@\u001a\u00020\u0006H\u00c6\u0003J\u0010\u0010A\u001a\u0004\u0018\u00010\u0015H\u00c6\u0003\u00a2\u0006\u0002\u00101J\u000b\u0010B\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\u0010\u0010C\u001a\u0004\u0018\u00010\u0019H\u00c6\u0003\u00a2\u0006\u0002\u0010<J\u0010\u0010D\u001a\u0004\u0018\u00010\u0019H\u00c6\u0003\u00a2\u0006\u0002\u0010<J\t\u0010E\u001a\u00020\u001cH\u00c6\u0003J\u000b\u0010F\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u0011\u0010G\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u001fH\u00c6\u0003J\u0015\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150!H\u00c6\u0003J\t\u0010I\u001a\u00020\u0006H\u00c6\u0003J\t\u0010J\u001a\u00020\tH\u00c6\u0003J\u000f\u0010K\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003J\t\u0010L\u001a\u00020\u000eH\u00c6\u0003J\t\u0010M\u001a\u00020\u000eH\u00c6\u0003J\t\u0010N\u001a\u00020\u0011H\u00c6\u0003J\t\u0010O\u001a\u00020\u0013H\u00c6\u0003J\u0010\u0010P\u001a\u0004\u0018\u00010\u0015H\u00c6\u0003\u00a2\u0006\u0002\u00101J\u00de\u0001\u0010Q\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u00062\u0010\b\u0002\u0010\u001e\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u001f2\u0014\b\u0002\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150!H\u00c6\u0001\u00a2\u0006\u0002\u0010RJ\u0013\u0010S\u001a\u00020\u001c2\b\u0010T\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010U\u001a\u00020VH\u00d6\u0001J\u0006\u0010W\u001a\u00020\u0003J\t\u0010X\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0019\u0010\u001e\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010(R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0015\u0010\u0016\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\n\n\u0002\u00102\u001a\u0004\b0\u00101R\u0015\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\n\n\u0002\u00102\u001a\u0004\b3\u00101R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010*R\u001d\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150!\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010(R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010(R\u0015\u0010\u001a\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\n\n\u0002\u0010=\u001a\u0004\b;\u0010<R\u0011\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010*R\u0015\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\n\n\u0002\u0010=\u001a\u0004\b?\u0010<\u00a8\u0006Y"}, d2={"Lai/tock/nlp/front/storage/mongo/ClassifiedSentenceMongoDAO$ClassifiedSentenceCol;", "", "sentence", "Lai/tock/nlp/front/shared/config/ClassifiedSentence;", "(Lai/tock/nlp/front/shared/config/ClassifiedSentence;)V", "text", "", "fullText", "language", "Ljava/util/Locale;", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "creationDate", "Ljava/time/Instant;", "updateDate", "status", "Lai/tock/nlp/front/shared/config/ClassifiedSentenceStatus;", "classification", "Lai/tock/nlp/front/shared/config/Classification;", "lastIntentProbability", "", "lastEntityProbability", "lastUsage", "usageCount", "", "unknownCount", "forReview", "", "reviewComment", "classifier", "Lai/tock/shared/security/UserLogin;", "otherIntentsProbabilities", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Locale;Lorg/litote/kmongo/Id;Ljava/time/Instant;Ljava/time/Instant;Lai/tock/nlp/front/shared/config/ClassifiedSentenceStatus;Lai/tock/nlp/front/shared/config/Classification;Ljava/lang/Double;Ljava/lang/Double;Ljava/time/Instant;Ljava/lang/Long;Ljava/lang/Long;ZLjava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "getApplicationId", "()Lorg/litote/kmongo/Id;", "getClassification", "()Lai/tock/nlp/front/shared/config/Classification;", "getClassifier", "()Ljava/lang/String;", "getCreationDate", "()Ljava/time/Instant;", "getForReview", "()Z", "getFullText", "getLanguage", "()Ljava/util/Locale;", "getLastEntityProbability", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getLastIntentProbability", "getLastUsage", "getOtherIntentsProbabilities", "()Ljava/util/Map;", "getReviewComment", "getStatus", "()Lai/tock/nlp/front/shared/config/ClassifiedSentenceStatus;", "getText", "getUnknownCount", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getUpdateDate", "getUsageCount", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Locale;Lorg/litote/kmongo/Id;Ljava/time/Instant;Ljava/time/Instant;Lai/tock/nlp/front/shared/config/ClassifiedSentenceStatus;Lai/tock/nlp/front/shared/config/Classification;Ljava/lang/Double;Ljava/lang/Double;Ljava/time/Instant;Ljava/lang/Long;Ljava/lang/Long;ZLjava/lang/String;Ljava/lang/String;Ljava/util/Map;)Lai/tock/nlp/front/storage/mongo/ClassifiedSentenceMongoDAO$ClassifiedSentenceCol;", "equals", "other", "hashCode", "", "toSentence", "toString", "tock-nlp-front-storage-mongo"})
    public static final class ClassifiedSentenceCol {
        @NotNull
        private final String text;
        @NotNull
        private final String fullText;
        @NotNull
        private final Locale language;
        @NotNull
        private final Id<ApplicationDefinition> applicationId;
        @NotNull
        private final Instant creationDate;
        @NotNull
        private final Instant updateDate;
        @NotNull
        private final ClassifiedSentenceStatus status;
        @NotNull
        private final Classification classification;
        @Nullable
        private final Double lastIntentProbability;
        @Nullable
        private final Double lastEntityProbability;
        @Nullable
        private final Instant lastUsage;
        @Nullable
        private final Long usageCount;
        @Nullable
        private final Long unknownCount;
        private final boolean forReview;
        @Nullable
        private final String reviewComment;
        @Nullable
        private final String classifier;
        @NotNull
        private final Map<String, Double> otherIntentsProbabilities;

        @NotNull
        public final ClassifiedSentence toSentence() {
            Long l = this.usageCount;
            Long l2 = this.unknownCount;
            return new ClassifiedSentence(this.fullText, this.language, this.applicationId, this.creationDate, this.updateDate, this.status, this.classification, this.lastIntentProbability, this.lastEntityProbability, this.lastUsage, l != null ? l : 0L, l2 != null ? l2 : 0L, this.forReview, this.reviewComment, this.classifier, this.otherIntentsProbabilities);
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String getFullText() {
            return this.fullText;
        }

        @NotNull
        public final Locale getLanguage() {
            return this.language;
        }

        @NotNull
        public final Id<ApplicationDefinition> getApplicationId() {
            return this.applicationId;
        }

        @NotNull
        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @NotNull
        public final Instant getUpdateDate() {
            return this.updateDate;
        }

        @NotNull
        public final ClassifiedSentenceStatus getStatus() {
            return this.status;
        }

        @NotNull
        public final Classification getClassification() {
            return this.classification;
        }

        @Nullable
        public final Double getLastIntentProbability() {
            return this.lastIntentProbability;
        }

        @Nullable
        public final Double getLastEntityProbability() {
            return this.lastEntityProbability;
        }

        @Nullable
        public final Instant getLastUsage() {
            return this.lastUsage;
        }

        @Nullable
        public final Long getUsageCount() {
            return this.usageCount;
        }

        @Nullable
        public final Long getUnknownCount() {
            return this.unknownCount;
        }

        public final boolean getForReview() {
            return this.forReview;
        }

        @Nullable
        public final String getReviewComment() {
            return this.reviewComment;
        }

        @Nullable
        public final String getClassifier() {
            return this.classifier;
        }

        @NotNull
        public final Map<String, Double> getOtherIntentsProbabilities() {
            return this.otherIntentsProbabilities;
        }

        public ClassifiedSentenceCol(@NotNull String text, @NotNull String fullText, @NotNull Locale language, @NotNull Id<ApplicationDefinition> applicationId, @NotNull Instant creationDate, @NotNull Instant updateDate, @NotNull ClassifiedSentenceStatus status, @NotNull Classification classification2, @Nullable Double lastIntentProbability, @Nullable Double lastEntityProbability, @Nullable Instant lastUsage, @Nullable Long usageCount, @Nullable Long unknownCount, boolean forReview, @Nullable String reviewComment, @Nullable String classifier, @NotNull Map<String, Double> otherIntentsProbabilities2) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)fullText, (String)"fullText");
            Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
            Intrinsics.checkParameterIsNotNull(applicationId, (String)"applicationId");
            Intrinsics.checkParameterIsNotNull((Object)creationDate, (String)"creationDate");
            Intrinsics.checkParameterIsNotNull((Object)updateDate, (String)"updateDate");
            Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
            Intrinsics.checkParameterIsNotNull((Object)classification2, (String)"classification");
            Intrinsics.checkParameterIsNotNull(otherIntentsProbabilities2, (String)"otherIntentsProbabilities");
            this.text = text;
            this.fullText = fullText;
            this.language = language;
            this.applicationId = applicationId;
            this.creationDate = creationDate;
            this.updateDate = updateDate;
            this.status = status;
            this.classification = classification2;
            this.lastIntentProbability = lastIntentProbability;
            this.lastEntityProbability = lastEntityProbability;
            this.lastUsage = lastUsage;
            this.usageCount = usageCount;
            this.unknownCount = unknownCount;
            this.forReview = forReview;
            this.reviewComment = reviewComment;
            this.classifier = classifier;
            this.otherIntentsProbabilities = otherIntentsProbabilities2;
        }

        public /* synthetic */ ClassifiedSentenceCol(String string, String string2, Locale locale, Id id, Instant instant, Instant instant2, ClassifiedSentenceStatus classifiedSentenceStatus, Classification classification2, Double d, Double d2, Instant instant3, Long l, Long l2, boolean bl, String string3, String string4, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = string;
            }
            if ((n & 0x100) != 0) {
                d = null;
            }
            if ((n & 0x200) != 0) {
                d2 = null;
            }
            if ((n & 0x400) != 0) {
                instant3 = null;
            }
            if ((n & 0x800) != 0) {
                l = 0L;
            }
            if ((n & 0x1000) != 0) {
                l2 = 0L;
            }
            if ((n & 0x2000) != 0) {
                bl = false;
            }
            if ((n & 0x4000) != 0) {
                string3 = null;
            }
            if ((n & 0x8000) != 0) {
                string4 = null;
            }
            if ((n & 0x10000) != 0) {
                map = MapsKt.emptyMap();
            }
            this(string, string2, locale, (Id<ApplicationDefinition>)id, instant, instant2, classifiedSentenceStatus, classification2, d, d2, instant3, l, l2, bl, string3, string4, map);
        }

        public ClassifiedSentenceCol(@NotNull ClassifiedSentence sentence) {
            Intrinsics.checkParameterIsNotNull((Object)sentence, (String)"sentence");
            String string = MongoHelpersKt.textKey(sentence.getText());
            String string2 = sentence.getText();
            Locale locale = sentence.getLanguage();
            Id id = sentence.getApplicationId();
            Instant instant = sentence.getCreationDate();
            Instant instant2 = Instant.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"now()");
            this(string, string2, locale, (Id<ApplicationDefinition>)id, instant, instant2, sentence.getStatus(), sentence.getClassification(), sentence.getLastIntentProbability(), sentence.getLastEntityProbability(), sentence.getLastUsage(), sentence.getUsageCount(), sentence.getUnknownCount(), sentence.getForReview(), sentence.getReviewComment(), sentence.getQualifier(), sentence.getOtherIntentsProbabilities());
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final String component2() {
            return this.fullText;
        }

        @NotNull
        public final Locale component3() {
            return this.language;
        }

        @NotNull
        public final Id<ApplicationDefinition> component4() {
            return this.applicationId;
        }

        @NotNull
        public final Instant component5() {
            return this.creationDate;
        }

        @NotNull
        public final Instant component6() {
            return this.updateDate;
        }

        @NotNull
        public final ClassifiedSentenceStatus component7() {
            return this.status;
        }

        @NotNull
        public final Classification component8() {
            return this.classification;
        }

        @Nullable
        public final Double component9() {
            return this.lastIntentProbability;
        }

        @Nullable
        public final Double component10() {
            return this.lastEntityProbability;
        }

        @Nullable
        public final Instant component11() {
            return this.lastUsage;
        }

        @Nullable
        public final Long component12() {
            return this.usageCount;
        }

        @Nullable
        public final Long component13() {
            return this.unknownCount;
        }

        public final boolean component14() {
            return this.forReview;
        }

        @Nullable
        public final String component15() {
            return this.reviewComment;
        }

        @Nullable
        public final String component16() {
            return this.classifier;
        }

        @NotNull
        public final Map<String, Double> component17() {
            return this.otherIntentsProbabilities;
        }

        @NotNull
        public final ClassifiedSentenceCol copy(@NotNull String text, @NotNull String fullText, @NotNull Locale language, @NotNull Id<ApplicationDefinition> applicationId, @NotNull Instant creationDate, @NotNull Instant updateDate, @NotNull ClassifiedSentenceStatus status, @NotNull Classification classification2, @Nullable Double lastIntentProbability, @Nullable Double lastEntityProbability, @Nullable Instant lastUsage, @Nullable Long usageCount, @Nullable Long unknownCount, boolean forReview, @Nullable String reviewComment, @Nullable String classifier, @NotNull Map<String, Double> otherIntentsProbabilities2) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)fullText, (String)"fullText");
            Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
            Intrinsics.checkParameterIsNotNull(applicationId, (String)"applicationId");
            Intrinsics.checkParameterIsNotNull((Object)creationDate, (String)"creationDate");
            Intrinsics.checkParameterIsNotNull((Object)updateDate, (String)"updateDate");
            Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
            Intrinsics.checkParameterIsNotNull((Object)classification2, (String)"classification");
            Intrinsics.checkParameterIsNotNull(otherIntentsProbabilities2, (String)"otherIntentsProbabilities");
            return new ClassifiedSentenceCol(text, fullText, language, applicationId, creationDate, updateDate, status, classification2, lastIntentProbability, lastEntityProbability, lastUsage, usageCount, unknownCount, forReview, reviewComment, classifier, otherIntentsProbabilities2);
        }

        public static /* synthetic */ ClassifiedSentenceCol copy$default(ClassifiedSentenceCol classifiedSentenceCol, String string, String string2, Locale locale, Id id, Instant instant, Instant instant2, ClassifiedSentenceStatus classifiedSentenceStatus, Classification classification2, Double d, Double d2, Instant instant3, Long l, Long l2, boolean bl, String string3, String string4, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                string = classifiedSentenceCol.text;
            }
            if ((n & 2) != 0) {
                string2 = classifiedSentenceCol.fullText;
            }
            if ((n & 4) != 0) {
                locale = classifiedSentenceCol.language;
            }
            if ((n & 8) != 0) {
                id = classifiedSentenceCol.applicationId;
            }
            if ((n & 0x10) != 0) {
                instant = classifiedSentenceCol.creationDate;
            }
            if ((n & 0x20) != 0) {
                instant2 = classifiedSentenceCol.updateDate;
            }
            if ((n & 0x40) != 0) {
                classifiedSentenceStatus = classifiedSentenceCol.status;
            }
            if ((n & 0x80) != 0) {
                classification2 = classifiedSentenceCol.classification;
            }
            if ((n & 0x100) != 0) {
                d = classifiedSentenceCol.lastIntentProbability;
            }
            if ((n & 0x200) != 0) {
                d2 = classifiedSentenceCol.lastEntityProbability;
            }
            if ((n & 0x400) != 0) {
                instant3 = classifiedSentenceCol.lastUsage;
            }
            if ((n & 0x800) != 0) {
                l = classifiedSentenceCol.usageCount;
            }
            if ((n & 0x1000) != 0) {
                l2 = classifiedSentenceCol.unknownCount;
            }
            if ((n & 0x2000) != 0) {
                bl = classifiedSentenceCol.forReview;
            }
            if ((n & 0x4000) != 0) {
                string3 = classifiedSentenceCol.reviewComment;
            }
            if ((n & 0x8000) != 0) {
                string4 = classifiedSentenceCol.classifier;
            }
            if ((n & 0x10000) != 0) {
                map = classifiedSentenceCol.otherIntentsProbabilities;
            }
            return classifiedSentenceCol.copy(string, string2, locale, id, instant, instant2, classifiedSentenceStatus, classification2, d, d2, instant3, l, l2, bl, string3, string4, map);
        }

        @NotNull
        public String toString() {
            return "ClassifiedSentenceCol(text=" + this.text + ", fullText=" + this.fullText + ", language=" + this.language + ", applicationId=" + this.applicationId + ", creationDate=" + this.creationDate + ", updateDate=" + this.updateDate + ", status=" + this.status + ", classification=" + this.classification + ", lastIntentProbability=" + this.lastIntentProbability + ", lastEntityProbability=" + this.lastEntityProbability + ", lastUsage=" + this.lastUsage + ", usageCount=" + this.usageCount + ", unknownCount=" + this.unknownCount + ", forReview=" + this.forReview + ", reviewComment=" + this.reviewComment + ", classifier=" + this.classifier + ", otherIntentsProbabilities=" + this.otherIntentsProbabilities + ")";
        }

        public int hashCode() {
            String string = this.text;
            String string2 = this.fullText;
            Locale locale = this.language;
            Id<ApplicationDefinition> id = this.applicationId;
            Instant instant = this.creationDate;
            Instant instant2 = this.updateDate;
            ClassifiedSentenceStatus classifiedSentenceStatus = this.status;
            Classification classification2 = this.classification;
            Double d = this.lastIntentProbability;
            Double d2 = this.lastEntityProbability;
            Instant instant3 = this.lastUsage;
            Long l = this.usageCount;
            Long l2 = this.unknownCount;
            int n = (((((((((((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (locale != null ? ((Object)locale).hashCode() : 0)) * 31 + (id != null ? id.hashCode() : 0)) * 31 + (instant != null ? ((Object)instant).hashCode() : 0)) * 31 + (instant2 != null ? ((Object)instant2).hashCode() : 0)) * 31 + (classifiedSentenceStatus != null ? classifiedSentenceStatus.hashCode() : 0)) * 31 + (classification2 != null ? classification2.hashCode() : 0)) * 31 + (d != null ? ((Object)d).hashCode() : 0)) * 31 + (d2 != null ? ((Object)d2).hashCode() : 0)) * 31 + (instant3 != null ? ((Object)instant3).hashCode() : 0)) * 31 + (l != null ? ((Object)l).hashCode() : 0)) * 31 + (l2 != null ? ((Object)l2).hashCode() : 0)) * 31;
            int n2 = this.forReview ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            String string3 = this.reviewComment;
            String string4 = this.classifier;
            Map<String, Double> map = this.otherIntentsProbabilities;
            return (((n + n2) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ClassifiedSentenceCol)) break block3;
                    ClassifiedSentenceCol classifiedSentenceCol = (ClassifiedSentenceCol)object;
                    if (!Intrinsics.areEqual((Object)this.text, (Object)classifiedSentenceCol.text) || !Intrinsics.areEqual((Object)this.fullText, (Object)classifiedSentenceCol.fullText) || !Intrinsics.areEqual((Object)this.language, (Object)classifiedSentenceCol.language) || !Intrinsics.areEqual(this.applicationId, classifiedSentenceCol.applicationId) || !Intrinsics.areEqual((Object)this.creationDate, (Object)classifiedSentenceCol.creationDate) || !Intrinsics.areEqual((Object)this.updateDate, (Object)classifiedSentenceCol.updateDate) || !Intrinsics.areEqual((Object)this.status, (Object)classifiedSentenceCol.status) || !Intrinsics.areEqual((Object)this.classification, (Object)classifiedSentenceCol.classification) || !Intrinsics.areEqual((Object)this.lastIntentProbability, (Object)classifiedSentenceCol.lastIntentProbability) || !Intrinsics.areEqual((Object)this.lastEntityProbability, (Object)classifiedSentenceCol.lastEntityProbability) || !Intrinsics.areEqual((Object)this.lastUsage, (Object)classifiedSentenceCol.lastUsage) || !Intrinsics.areEqual((Object)this.usageCount, (Object)classifiedSentenceCol.usageCount) || !Intrinsics.areEqual((Object)this.unknownCount, (Object)classifiedSentenceCol.unknownCount) || this.forReview != classifiedSentenceCol.forReview || !Intrinsics.areEqual((Object)this.reviewComment, (Object)classifiedSentenceCol.reviewComment) || !Intrinsics.areEqual((Object)this.classifier, (Object)classifiedSentenceCol.classifier) || !Intrinsics.areEqual(this.otherIntentsProbabilities, classifiedSentenceCol.otherIntentsProbabilities)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

