/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.front.storage.mongo;

import ai.tock.nlp.front.service.storage.ModelBuildTriggerDAO;
import ai.tock.nlp.front.shared.build.ModelBuild;
import ai.tock.nlp.front.shared.build.ModelBuildQueryResult;
import ai.tock.nlp.front.shared.build.ModelBuildTrigger;
import ai.tock.nlp.front.shared.build.ModelBuildTrigger_;
import ai.tock.nlp.front.shared.build.ModelBuild_;
import ai.tock.nlp.front.shared.config.ApplicationDefinition;
import ai.tock.nlp.front.storage.mongo.ModelBuildTriggerMongoDAO;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoIterable;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.KMongoIterableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.FindIterablesKt;
import org.litote.kmongo.Id;
import org.litote.kmongo.MongoCollectionsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0016R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\t\u001a\u0004\b\f\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lai/tock/nlp/front/storage/mongo/ModelBuildTriggerMongoDAO;", "Lai/tock/nlp/front/service/storage/ModelBuildTriggerDAO;", "()V", "col", "Lcom/mongodb/client/MongoCollection;", "Lai/tock/nlp/front/shared/build/ModelBuildTrigger;", "getCol", "()Lcom/mongodb/client/MongoCollection;", "col$delegate", "Lkotlin/Lazy;", "modelCol", "Lai/tock/nlp/front/shared/build/ModelBuild;", "getModelCol", "modelCol$delegate", "builds", "Lai/tock/nlp/front/shared/build/ModelBuildQueryResult;", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "language", "Ljava/util/Locale;", "start", "", "size", "deleteTrigger", "", "trigger", "getTriggers", "", "save", "build", "tock-nlp-front-storage-mongo"})
public final class ModelBuildTriggerMongoDAO
implements ModelBuildTriggerDAO {
    private static final Lazy col$delegate;
    private static final Lazy modelCol$delegate;
    public static final ModelBuildTriggerMongoDAO INSTANCE;

    private final MongoCollection<ModelBuildTrigger> getCol() {
        Lazy lazy = col$delegate;
        ModelBuildTriggerMongoDAO modelBuildTriggerMongoDAO = this;
        Object var3_3 = null;
        boolean bl = false;
        return (MongoCollection)lazy.getValue();
    }

    private final MongoCollection<ModelBuild> getModelCol() {
        Lazy lazy = modelCol$delegate;
        ModelBuildTriggerMongoDAO modelBuildTriggerMongoDAO = this;
        Object var3_3 = null;
        boolean bl = false;
        return (MongoCollection)lazy.getValue();
    }

    public void save(@NotNull ModelBuildTrigger trigger) {
        Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
        MongoCollectionsKt.save(this.getCol(), (Object)trigger);
    }

    public void deleteTrigger(@NotNull ModelBuildTrigger trigger) {
        Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
        MongoCollectionsKt.deleteMany$default(this.getCol(), (Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)ModelBuildTrigger_.Companion.getApplicationId()), (Object)trigger.getApplicationId()), FiltersKt.eq((KProperty)((KProperty)ModelBuildTrigger_.Companion.getOnlyIfModelNotExists()), (Object)trigger.getOnlyIfModelNotExists())}, null, (int)2, null);
    }

    @NotNull
    public List<ModelBuildTrigger> getTriggers() {
        FindIterable findIterable = this.getCol().find();
        Intrinsics.checkExpressionValueIsNotNull((Object)findIterable, (String)"col.find()");
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable));
    }

    public void save(@NotNull ModelBuild build) {
        Intrinsics.checkParameterIsNotNull((Object)build, (String)"build");
        MongoCollectionsKt.save(this.getModelCol(), (Object)build);
    }

    @NotNull
    public ModelBuildQueryResult builds(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language, int start, int size) {
        Intrinsics.checkParameterIsNotNull(applicationId, (String)"applicationId");
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        Bson filter = FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)ModelBuild_.Companion.getApplicationId()), applicationId), FiltersKt.eq((KProperty)((KProperty)ModelBuild_.Companion.getLanguage()), (Object)language)});
        long l = this.getModelCol().countDocuments(filter);
        FindIterable findIterable = this.getModelCol().find(filter);
        Intrinsics.checkExpressionValueIsNotNull((Object)findIterable, (String)"modelCol\n                .find(filter)");
        FindIterable findIterable2 = FindIterablesKt.descendingSort((FindIterable)findIterable, (KProperty[])new KProperty[]{(KProperty)ModelBuild_.Companion.getDate()}).skip(start).limit(size);
        Intrinsics.checkExpressionValueIsNotNull((Object)findIterable2, (String)"modelCol\n               \u2026             .limit(size)");
        return new ModelBuildQueryResult(l, KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable2)));
    }

    private ModelBuildTriggerMongoDAO() {
    }

    static {
        ModelBuildTriggerMongoDAO modelBuildTriggerMongoDAO;
        INSTANCE = modelBuildTriggerMongoDAO = new ModelBuildTriggerMongoDAO();
        col$delegate = LazyKt.lazy((Function0)col.2.INSTANCE);
        modelCol$delegate = LazyKt.lazy((Function0)modelCol.2.INSTANCE);
    }
}

