/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.front.storage.mongo;

import ai.tock.nlp.front.service.storage.UserNamespaceDAO;
import ai.tock.nlp.front.shared.user.UserNamespace;
import ai.tock.nlp.front.shared.user.UserNamespace_;
import ai.tock.nlp.front.storage.mongo.UserNamespaceMongoDAO;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.ReplaceOptions;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.KMongoIterableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.UpdatesKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lai/tock/nlp/front/storage/mongo/UserNamespaceMongoDAO;", "Lai/tock/nlp/front/service/storage/UserNamespaceDAO;", "()V", "col", "Lcom/mongodb/client/MongoCollection;", "Lai/tock/nlp/front/shared/user/UserNamespace;", "getCol", "()Lcom/mongodb/client/MongoCollection;", "col$delegate", "Lkotlin/Lazy;", "deleteNamespace", "", "user", "", "namespace", "getNamespaces", "", "getUsers", "hasNamespace", "", "isExistingNamespace", "isNamespaceOwner", "saveNamespace", "setCurrentNamespace", "tock-nlp-front-storage-mongo"})
public final class UserNamespaceMongoDAO
implements UserNamespaceDAO {
    private static final Lazy col$delegate;
    @NotNull
    public static final UserNamespaceMongoDAO INSTANCE;

    private final MongoCollection<UserNamespace> getCol() {
        Lazy lazy = col$delegate;
        UserNamespaceMongoDAO userNamespaceMongoDAO = this;
        Object var3_3 = null;
        boolean bl = false;
        return (MongoCollection)lazy.getValue();
    }

    @NotNull
    public List<UserNamespace> getNamespaces(@NotNull String user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        FindIterable findIterable = this.getCol().find(FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getLogin()), (Object)user));
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"col.find(Login eq user)");
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable));
    }

    @NotNull
    public List<UserNamespace> getUsers(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        FindIterable findIterable = this.getCol().find(FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getNamespace()), (Object)namespace));
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"col.find(Namespace eq namespace)");
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable));
    }

    public void saveNamespace(@NotNull UserNamespace namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        this.getCol().replaceOne(FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getLogin()), (Object)namespace.getLogin()), FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getNamespace()), (Object)namespace.getNamespace())}), (Object)namespace, new ReplaceOptions().upsert(true));
    }

    public void deleteNamespace(@NotNull String user, @NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        this.getCol().deleteOne(FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getLogin()), (Object)user), FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getNamespace()), (Object)namespace)}));
    }

    public boolean hasNamespace(@NotNull String user, @NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        return this.getCol().countDocuments(FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getLogin()), (Object)user), FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getNamespace()), (Object)namespace)})) == 1L;
    }

    public void setCurrentNamespace(@NotNull String user, @NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        this.getCol().updateMany(FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getLogin()), (Object)user), UpdatesKt.setValue((KProperty)((KProperty)UserNamespace_.Companion.getCurrent()), (Object)false));
        this.getCol().updateOne(FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getLogin()), (Object)user), FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getNamespace()), (Object)namespace)}), UpdatesKt.setValue((KProperty)((KProperty)UserNamespace_.Companion.getCurrent()), (Object)true));
    }

    public boolean isNamespaceOwner(@NotNull String user, @NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        return this.getCol().countDocuments(FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getLogin()), (Object)user), FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getNamespace()), (Object)namespace), FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getOwner()), (Object)true)})) == 1L;
    }

    public boolean isExistingNamespace(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        return this.getCol().countDocuments(FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getNamespace()), (Object)namespace)) != 0L;
    }

    private UserNamespaceMongoDAO() {
    }

    static {
        UserNamespaceMongoDAO userNamespaceMongoDAO;
        INSTANCE = userNamespaceMongoDAO = new UserNamespaceMongoDAO();
        col$delegate = LazyKt.lazy((Function0)col.2.INSTANCE);
    }
}

