/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.front.storage.mongo;

import ai.tock.nlp.front.service.storage.ClassifiedSentenceDAO;
import ai.tock.nlp.front.shared.config.ApplicationDefinition;
import ai.tock.nlp.front.shared.config.Classification;
import ai.tock.nlp.front.shared.config.Classification_;
import ai.tock.nlp.front.shared.config.ClassifiedEntity;
import ai.tock.nlp.front.shared.config.ClassifiedEntity_;
import ai.tock.nlp.front.shared.config.ClassifiedSentence;
import ai.tock.nlp.front.shared.config.ClassifiedSentenceStatus;
import ai.tock.nlp.front.shared.config.EntityDefinition;
import ai.tock.nlp.front.shared.config.EntityTypeDefinition;
import ai.tock.nlp.front.shared.config.IntentDefinition;
import ai.tock.nlp.front.shared.config.SearchMark;
import ai.tock.nlp.front.shared.config.SentencesQuery;
import ai.tock.nlp.front.shared.config.SentencesQueryResult;
import ai.tock.nlp.front.storage.mongo.ApplicationDefinitionMongoDAO;
import ai.tock.nlp.front.storage.mongo.ClassifiedSentenceCol_;
import ai.tock.nlp.front.storage.mongo.ClassifiedSentenceMongoDAO;
import ai.tock.nlp.front.storage.mongo.EntityTypeDefinitionMongoDAO;
import ai.tock.nlp.front.storage.mongo.MongoHelpersKt;
import ai.tock.nlp.front.storage.mongo.ParseRequestLogMongoDAO;
import ai.tock.shared.LocalesKt;
import ai.tock.shared.MongosKt;
import com.mongodb.ReadPreference;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.ReplaceOptions;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.KMongoIterableKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.FindIterablesKt;
import org.litote.kmongo.Id;
import org.litote.kmongo.MongoCollectionsKt;
import org.litote.kmongo.MongoOperator;
import org.litote.kmongo.PropertiesKt;
import org.litote.kmongo.SetTo;
import org.litote.kmongo.SharedExtensionsKt;
import org.litote.kmongo.SortsKt;
import org.litote.kmongo.UpdatesKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001TB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J8\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0014\u0010\u0019\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u0011\u0018\u00010\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J&\u0010\u001e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J4\u0010!\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00112\u0006\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020 H\u0016J.\u0010%\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020 2\u0006\u0010&\u001a\u00020'H\u0002J&\u0010(\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020 H\u0016J\u0010\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u0018H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0016\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020 0\u0017H\u0002J\u0016\u00102\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020 0\u0017H\u0002J\u0010\u00103\u001a\u0002002\u0006\u0010#\u001a\u00020 H\u0002J.\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u00020 2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u000208H\u0016J$\u0010:\u001a\u00020\u000f2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0011H\u0016J2\u0010:\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00112\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0011H\u0016J\u001e\u0010=\u001a\u00020\u000f2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010>\u001a\u00020\u0015H\u0016J\u0015\u0010?\u001a\u00020\u000f2\u0006\u0010@\u001a\u00020AH\u0000\u00a2\u0006\u0002\bBJ\u001c\u0010C\u001a\b\u0012\u0004\u0012\u00020 0\u00172\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\f\u0010D\u001a\u000200*\u00020.H\u0002J\u000e\u0010E\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010F\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010G\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010H\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010I\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010J\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010K\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010L\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010M\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010N\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010O\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010P\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010Q\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010R\u001a\u0004\u0018\u000100*\u00020.H\u0002J\u000e\u0010S\u001a\u0004\u0018\u000100*\u00020.H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lai/tock/nlp/front/storage/mongo/ClassifiedSentenceMongoDAO;", "Lai/tock/nlp/front/service/storage/ClassifiedSentenceDAO;", "()V", "Classification_", "Lai/tock/nlp/front/shared/config/Classification_;", "Lai/tock/nlp/front/storage/mongo/ClassifiedSentenceMongoDAO$ClassifiedSentenceCol;", "col", "Lcom/mongodb/client/MongoCollection;", "getCol", "()Lcom/mongodb/client/MongoCollection;", "col$delegate", "Lkotlin/Lazy;", "logger", "Lmu/KLogger;", "deleteSentencesByApplicationId", "", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "deleteSentencesByStatus", "status", "Lai/tock/nlp/front/shared/config/ClassifiedSentenceStatus;", "getSentences", "", "Lai/tock/nlp/front/shared/config/ClassifiedSentence;", "intents", "", "Lai/tock/nlp/front/shared/config/IntentDefinition;", "language", "Ljava/util/Locale;", "incrementUnknownStat", "text", "", "removeEntityFromSentences", "intentId", "entityType", "role", "removeSubEntitiesFromSentence", "level", "", "removeSubEntityFromSentences", "save", "sentence", "search", "Lai/tock/nlp/front/shared/config/SentencesQueryResult;", "query", "Lai/tock/nlp/front/shared/config/SentencesQuery;", "subEntityRoleQueryToExclude", "Lorg/bson/conversions/Bson;", "roles", "subEntityRoleQueryToInclude", "subEntityTypeQuery", "switchSentencesEntity", "allowedNamespace", "sentences", "oldEntity", "Lai/tock/nlp/front/shared/config/EntityDefinition;", "newEntity", "switchSentencesIntent", "newIntentId", "oldIntentId", "switchSentencesStatus", "newStatus", "updateSentenceState", "stat", "Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$ParseRequestLogStatCol;", "updateSentenceState$tock_nlp_front_storage_mongo", "users", "filterApplication", "filterByAllButUser", "filterByUser", "filterEntityRoleToExclude", "filterEntityRolesToInclude", "filterEntityType", "filterIntent", "filterLanguage", "filterMaxIntentProbability", "filterMinIntentProbability", "filterModifiedAfter", "filterModifiedBefore", "filterReviewOnly", "filterSearchMark", "filterStatus", "filterText", "ClassifiedSentenceCol", "tock-nlp-front-storage-mongo"})
public final class ClassifiedSentenceMongoDAO
implements ClassifiedSentenceDAO {
    @NotNull
    public static final ClassifiedSentenceMongoDAO INSTANCE = new ClassifiedSentenceMongoDAO();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    private static final Classification_<ClassifiedSentenceCol> Classification_ = ClassifiedSentenceCol_.Companion.getClassification();
    @NotNull
    private static final Lazy col$delegate = LazyKt.lazy((Function0)col.2.INSTANCE);

    private ClassifiedSentenceMongoDAO() {
    }

    private final MongoCollection<ClassifiedSentenceCol> getCol() {
        Lazy lazy = col$delegate;
        boolean bl = false;
        return (MongoCollection)lazy.getValue();
    }

    @NotNull
    public List<ClassifiedSentence> getSentences(@Nullable Set<? extends Id<IntentDefinition>> intents2, @Nullable Locale language, @Nullable ClassifiedSentenceStatus status) {
        if (intents2 == null && language == null && status == null) {
            String string = "at least one parameter should be not null";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Bson[] bsonArray = new Bson[]{intents2 != null ? FiltersKt.in((KProperty)((KProperty)Classification_.getIntentId()), (Iterable)intents2) : null, language != null ? FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLanguage()), (Object)language) : null, status != null ? FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getStatus()), (Object)status) : null};
        MongoIterable mongoIterable = MongoCollectionsKt.find(this.getCol(), (Bson[])bsonArray).map(ClassifiedSentenceMongoDAO::getSentences$lambda-0);
        Intrinsics.checkNotNullExpressionValue((Object)mongoIterable, (String)"col\n            .find(\n                if (intents != null) Classification_.intentId `in` intents else null,\n                if (language != null) Language eq language else null,\n                if (status != null) Status eq status else null\n            )\n            .map { it.toSentence() }");
        return KMongoIterableKt.toList((MongoIterable)mongoIterable);
    }

    public void switchSentencesStatus(@NotNull List<ClassifiedSentence> sentences, @NotNull ClassifiedSentenceStatus newStatus) {
        Intrinsics.checkNotNullParameter(sentences, (String)"sentences");
        Intrinsics.checkNotNullParameter((Object)newStatus, (String)"newStatus");
        Iterable $this$forEach$iv = sentences;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassifiedSentence it = (ClassifiedSentence)element$iv;
            boolean bl = false;
            INSTANCE.save(ClassifiedSentence.copy$default((ClassifiedSentence)it, null, null, null, null, null, (ClassifiedSentenceStatus)newStatus, null, null, null, null, (long)0L, (long)0L, (boolean)false, null, null, null, (int)65503, null));
        }
    }

    public void deleteSentencesByStatus(@NotNull ClassifiedSentenceStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        this.getCol().deleteMany(FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getStatus()), (Object)status));
    }

    public void deleteSentencesByApplicationId(@NotNull Id<ApplicationDefinition> applicationId) {
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        this.getCol().deleteMany(FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), applicationId));
    }

    public void save(@NotNull ClassifiedSentence sentence) {
        Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
        MongoCollection<ClassifiedSentenceCol> mongoCollection = this.getCol();
        ReplaceOptions replaceOptions = new ReplaceOptions[]{FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getText()), (Object)MongoHelpersKt.textKey(sentence.getText())), FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLanguage()), (Object)sentence.getLanguage()), FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), (Object)sentence.getApplicationId())};
        Bson bson = FiltersKt.and((Bson[])replaceOptions);
        ClassifiedSentenceCol classifiedSentenceCol = new ClassifiedSentenceCol(sentence);
        replaceOptions = new ReplaceOptions().upsert(true);
        Intrinsics.checkNotNullExpressionValue((Object)replaceOptions, (String)"ReplaceOptions().upsert(true)");
        MongoCollectionsKt.replaceOneWithFilter(mongoCollection, (Bson)bson, (Object)classifiedSentenceCol, (ReplaceOptions)replaceOptions);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> users(@NotNull Id<ApplicationDefinition> applicationId) {
        void filter$iv;
        void field$iv;
        void $this$distinct$iv;
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        MongoCollection<ClassifiedSentenceCol> mongoCollection = this.getCol();
        KProperty1<ClassifiedSentenceCol, String> kProperty1 = ClassifiedSentenceCol_.Companion.getClassifier();
        Bson bson = new Bson[2];
        bson[0] = FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), applicationId);
        Object[] objectArray = new ClassifiedSentenceStatus[]{ClassifiedSentenceStatus.validated, ClassifiedSentenceStatus.model};
        bson[1] = FiltersKt.in((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getStatus()), (Iterable)CollectionsKt.listOf((Object[])objectArray));
        bson = FiltersKt.and((Bson[])bson);
        boolean $i$f$distinct = false;
        DistinctIterable distinctIterable = $this$distinct$iv.distinct(PropertiesKt.path((KProperty)((KProperty)field$iv)), (Bson)filter$iv, String.class);
        Intrinsics.checkNotNullExpressionValue((Object)distinctIterable, (String)"distinct(field.path(), filter, TResult::class.java)");
        return KMongoIterableKt.filterNotNull((MongoIterable)((MongoIterable)distinctIterable));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public SentencesQueryResult search(@NotNull SentencesQuery query2) {
        long count;
        block31: {
            FindIterable findIterable;
            FindIterable findIterable2;
            Object object;
            boolean bl;
            boolean bl2;
            FindIterable findIterable3;
            SentencesQuery $this$search_u24lambda_u2d6;
            block33: {
                Collection<Pair> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                FindIterable $this$search_u24lambda_u2d6_u24lambda_u2d3;
                block32: {
                    Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
                    boolean bl3 = false;
                    boolean bl4 = false;
                    $this$search_u24lambda_u2d6 = query2;
                    boolean bl5 = false;
                    Bson[] bsonArray = new Bson[]{INSTANCE.filterApplication($this$search_u24lambda_u2d6), INSTANCE.filterLanguage($this$search_u24lambda_u2d6), INSTANCE.filterText($this$search_u24lambda_u2d6), INSTANCE.filterIntent($this$search_u24lambda_u2d6), INSTANCE.filterStatus($this$search_u24lambda_u2d6), INSTANCE.filterEntityType($this$search_u24lambda_u2d6), INSTANCE.filterEntityRolesToInclude($this$search_u24lambda_u2d6), INSTANCE.filterEntityRoleToExclude($this$search_u24lambda_u2d6), INSTANCE.filterSearchMark($this$search_u24lambda_u2d6), INSTANCE.filterModifiedAfter($this$search_u24lambda_u2d6), INSTANCE.filterModifiedBefore($this$search_u24lambda_u2d6), INSTANCE.filterReviewOnly($this$search_u24lambda_u2d6), INSTANCE.filterByUser($this$search_u24lambda_u2d6), INSTANCE.filterByAllButUser($this$search_u24lambda_u2d6), INSTANCE.filterMaxIntentProbability($this$search_u24lambda_u2d6), INSTANCE.filterMinIntentProbability($this$search_u24lambda_u2d6)};
                    Bson filterBase = FiltersKt.and((Bson[])bsonArray);
                    logger.debug((Function0)new Function0<Object>(filterBase){
                        final /* synthetic */ Bson $filterBase;
                        {
                            this.$filterBase = $filterBase;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return SharedExtensionsKt.getJson((Object)this.$filterBase);
                        }
                    });
                    MongoCollection c = $this$search_u24lambda_u2d6.getOnlyExactMatch() ? INSTANCE.getCol() : INSTANCE.getCol().withReadPreference(ReadPreference.secondaryPreferred());
                    count = c.countDocuments(filterBase);
                    logger.debug((Function0)new Function0<Object>(count){
                        final /* synthetic */ long $count;
                        {
                            this.$count = $count;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return Intrinsics.stringPlus((String)"count : ", (Object)this.$count);
                        }
                    });
                    if (count <= $this$search_u24lambda_u2d6.getStart()) break block31;
                    findIterable3 = c.find(filterBase);
                    bl2 = false;
                    bl = false;
                    $this$search_u24lambda_u2d6_u24lambda_u2d3 = findIterable3;
                    boolean bl6 = false;
                    if (!query2.getSort().isEmpty()) break block32;
                    Intrinsics.checkNotNullExpressionValue((Object)$this$search_u24lambda_u2d6_u24lambda_u2d3, (String)"");
                    object = new KProperty[]{(KProperty)ClassifiedSentenceCol_.Companion.getUpdateDate()};
                    findIterable2 = FindIterablesKt.descendingSort((FindIterable)$this$search_u24lambda_u2d6_u24lambda_u2d3, (KProperty[])object);
                    break block33;
                }
                object = (KProperty[])query2.getSort();
                FindIterable findIterable4 = $this$search_u24lambda_u2d6_u24lambda_u2d3;
                boolean $i$f$map = false;
                void var18_19 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Object object2;
                    void it;
                    Pair pair = (Pair)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl7 = false;
                    switch ((String)it.getFirst()) {
                        case "text": {
                            object2 = ClassifiedSentenceCol_.Companion.getText();
                            break;
                        }
                        case "currentIntent": {
                            object2 = (KProperty1)Classification_.getIntentId();
                            break;
                        }
                        case "intentProbability": {
                            object2 = ClassifiedSentenceCol_.Companion.getLastIntentProbability();
                            break;
                        }
                        case "entitiesProbability": {
                            object2 = ClassifiedSentenceCol_.Companion.getLastEntityProbability();
                            break;
                        }
                        case "lastUpdate": {
                            object2 = ClassifiedSentenceCol_.Companion.getUpdateDate();
                            break;
                        }
                        case "lastUsage": {
                            object2 = ClassifiedSentenceCol_.Companion.getLastUsage();
                            break;
                        }
                        case "usageCount": {
                            object2 = ClassifiedSentenceCol_.Companion.getUsageCount();
                            break;
                        }
                        case "unknownCount": {
                            object2 = ClassifiedSentenceCol_.Companion.getUnknownCount();
                            break;
                        }
                        default: {
                            object2 = ClassifiedSentenceCol_.Companion.getUpdateDate();
                        }
                    }
                    Pair pair2 = TuplesKt.to(object2, (Object)it.getSecond());
                    collection.add(pair2);
                }
                collection = (List)destination$iv$iv;
                findIterable2 = findIterable4.sort(SortsKt.orderBy((Map)MapsKt.toMap((Iterable)collection)));
            }
            findIterable3 = findIterable2;
            bl2 = false;
            bl = false;
            FindIterable $this$search_u24lambda_u2d6_u24lambda_u2d4 = findIterable3;
            boolean bl8 = false;
            object = query2.getSort();
            boolean bl9 = false;
            if (!object.isEmpty()) {
                Intrinsics.checkNotNullExpressionValue((Object)$this$search_u24lambda_u2d6_u24lambda_u2d4, (String)"");
                Locale locale = query2.getLanguage();
                object = Collation.builder().caseLevel(Boolean.valueOf(false)).locale((locale == null ? LocalesKt.getDefaultLocale() : locale).toLanguageTag()).build();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builder()\n                                    .caseLevel(false)\n                                    .locale((query.language ?: defaultLocale).toLanguageTag())\n                                    .build()");
                findIterable = MongosKt.safeCollation((FindIterable)$this$search_u24lambda_u2d6_u24lambda_u2d4, (Collation)object);
            } else {
                findIterable = $this$search_u24lambda_u2d6_u24lambda_u2d4;
            }
            FindIterable list = findIterable.skip((int)$this$search_u24lambda_u2d6.getStart()).limit($this$search_u24lambda_u2d6.getSize());
            findIterable3 = list.map(ClassifiedSentenceMongoDAO::search$lambda-6$lambda-5);
            Intrinsics.checkNotNullExpressionValue((Object)findIterable3, (String)"list.map { it.toSentence() }");
            return new SentencesQueryResult(count, KMongoIterableKt.toList((MongoIterable)findIterable3));
        }
        return new SentencesQueryResult(count, CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    private final Bson filterApplication(SentencesQuery $this$filterApplication) {
        Bson bson;
        if ($this$filterApplication.getWholeNamespace()) {
            List list;
            KProperty kProperty = (KProperty)ClassifiedSentenceCol_.Companion.getApplicationId();
            ApplicationDefinition applicationDefinition = ApplicationDefinitionMongoDAO.INSTANCE.getApplicationById((Id<ApplicationDefinition>)$this$filterApplication.getApplicationId());
            if (applicationDefinition == null) {
                list = null;
            } else {
                String string = applicationDefinition.getNamespace();
                if (string == null) {
                    list = null;
                } else {
                    void $this$mapTo$iv$iv;
                    void n;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String string3 = string2;
                    KProperty kProperty2 = kProperty;
                    boolean bl3 = false;
                    Iterable $this$map$iv = ApplicationDefinitionMongoDAO.INSTANCE.getApplicationsByNamespace((String)n);
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ApplicationDefinition applicationDefinition2 = (ApplicationDefinition)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl4 = false;
                        Id id = it.get_id();
                        collection.add(id);
                    }
                    List list2 = (List)destination$iv$iv;
                    kProperty = kProperty2;
                    list = list2;
                }
            }
            List list3 = list;
            bson = FiltersKt.in((KProperty)kProperty, (Iterable)(list3 == null ? (Iterable)CollectionsKt.emptyList() : (Iterable)list3));
        } else {
            bson = FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), (Object)$this$filterApplication.getApplicationId());
        }
        return bson;
    }

    private final Bson filterReviewOnly(SentencesQuery $this$filterReviewOnly) {
        return $this$filterReviewOnly.getOnlyToReview() ? FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getForReview()), (Object)true) : null;
    }

    private final Bson filterByUser(SentencesQuery $this$filterByUser) {
        return $this$filterByUser.getUser() != null ? FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getClassifier()), (Object)$this$filterByUser.getUser()) : null;
    }

    private final Bson filterByAllButUser(SentencesQuery $this$filterByAllButUser) {
        return $this$filterByAllButUser.getAllButUser() != null ? FiltersKt.ne((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getClassifier()), (Object)$this$filterByAllButUser.getAllButUser()) : null;
    }

    private final Bson filterSearchMark(SentencesQuery $this$filterSearchMark) {
        SearchMark searchMark;
        return $this$filterSearchMark.getSearchMark() == null ? null : FiltersKt.lte((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getUpdateDate()), (Object)((searchMark = $this$filterSearchMark.getSearchMark()) == null ? null : searchMark.getDate()));
    }

    private final Bson filterModifiedAfter(SentencesQuery $this$filterModifiedAfter) {
        ZonedDateTime zonedDateTime;
        return $this$filterModifiedAfter.getModifiedAfter() == null ? null : FiltersKt.gt((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getUpdateDate()), (Object)((zonedDateTime = $this$filterModifiedAfter.getModifiedAfter()) == null ? null : zonedDateTime.toInstant()));
    }

    private final Bson filterModifiedBefore(SentencesQuery $this$filterModifiedBefore) {
        ZonedDateTime zonedDateTime;
        return $this$filterModifiedBefore.getModifiedBefore() == null ? null : FiltersKt.lt((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getUpdateDate()), (Object)((zonedDateTime = $this$filterModifiedBefore.getModifiedBefore()) == null ? null : zonedDateTime.toInstant()));
    }

    private final Bson filterEntityRoleToExclude(SentencesQuery $this$filterEntityRoleToExclude) {
        return $this$filterEntityRoleToExclude.getEntityRolesToExclude().isEmpty() ? null : ($this$filterEntityRoleToExclude.getSearchSubEntities() ? this.subEntityRoleQueryToExclude($this$filterEntityRoleToExclude.getEntityRolesToExclude()) : FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getRole()), (Iterable)$this$filterEntityRoleToExclude.getEntityRolesToExclude()));
    }

    private final Bson filterEntityRolesToInclude(SentencesQuery $this$filterEntityRolesToInclude) {
        return $this$filterEntityRolesToInclude.getEntityRolesToInclude().isEmpty() ? null : ($this$filterEntityRolesToInclude.getSearchSubEntities() ? this.subEntityRoleQueryToInclude($this$filterEntityRolesToInclude.getEntityRolesToInclude()) : FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getRole()), (Iterable)$this$filterEntityRolesToInclude.getEntityRolesToInclude()));
    }

    private final Bson filterEntityType(SentencesQuery $this$filterEntityType) {
        Bson bson;
        if ($this$filterEntityType.getEntityType() == null) {
            bson = null;
        } else if ($this$filterEntityType.getSearchSubEntities()) {
            String string = $this$filterEntityType.getEntityType();
            Intrinsics.checkNotNull((Object)string);
            bson = this.subEntityTypeQuery(string);
        } else {
            bson = FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getType()), (Object)$this$filterEntityType.getEntityType());
        }
        return bson;
    }

    private final Bson filterStatus(SentencesQuery $this$filterStatus) {
        Collection collection = $this$filterStatus.getStatus();
        boolean bl = false;
        return !collection.isEmpty() ? FiltersKt.in((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getStatus()), (Iterable)$this$filterStatus.getStatus()) : ($this$filterStatus.getNotStatus() != null ? FiltersKt.ne((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getStatus()), (Object)$this$filterStatus.getNotStatus()) : null);
    }

    private final Bson filterIntent(SentencesQuery $this$filterIntent) {
        return $this$filterIntent.getIntentId() == null ? null : FiltersKt.eq((KProperty)((KProperty)Classification_.getIntentId()), (Object)$this$filterIntent.getIntentId());
    }

    private final Bson filterText(SentencesQuery $this$filterText) {
        Bson bson;
        CharSequence charSequence = $this$filterText.getSearch();
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            bson = null;
        } else if ($this$filterText.getOnlyExactMatch()) {
            bson = FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getText()), (Object)$this$filterText.getSearch());
        } else {
            KProperty kProperty = (KProperty)ClassifiedSentenceCol_.Companion.getFullText();
            String string = $this$filterText.getSearch();
            Intrinsics.checkNotNull((Object)string);
            charSequence = string;
            bl = false;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            bson = FiltersKt.regex((KProperty)kProperty, (String)((Object)StringsKt.trim((CharSequence)charSequence2)).toString(), (String)"i");
        }
        return bson;
    }

    private final Bson filterLanguage(SentencesQuery $this$filterLanguage) {
        return $this$filterLanguage.getLanguage() == null ? null : FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLanguage()), (Object)$this$filterLanguage.getLanguage());
    }

    private final Bson filterMaxIntentProbability(SentencesQuery $this$filterMaxIntentProbability) {
        return $this$filterMaxIntentProbability.getMaxIntentProbability() < 1.0f ? FiltersKt.lt((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLastIntentProbability()), (Object)$this$filterMaxIntentProbability.getMaxIntentProbability()) : null;
    }

    private final Bson filterMinIntentProbability(SentencesQuery $this$filterMinIntentProbability) {
        return $this$filterMinIntentProbability.getMinIntentProbability() > 0.0f ? FiltersKt.gt((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLastIntentProbability()), (Object)$this$filterMinIntentProbability.getMinIntentProbability()) : null;
    }

    private final Bson subEntityTypeQuery(String entityType) {
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getType()), (Object)entityType)};
        return FiltersKt.or((Bson[])bsonArray);
    }

    private final Bson subEntityRoleQueryToInclude(List<String> roles) {
        Bson[] bsonArray = new Bson[]{FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles)};
        return FiltersKt.or((Bson[])bsonArray);
    }

    private final Bson subEntityRoleQueryToExclude(List<String> roles) {
        Bson[] bsonArray = new Bson[]{FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles)};
        return FiltersKt.and((Bson[])bsonArray);
    }

    public void switchSentencesIntent(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Id<IntentDefinition> oldIntentId, @NotNull Id<IntentDefinition> newIntentId) {
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter(oldIntentId, (String)"oldIntentId");
        Intrinsics.checkNotNullParameter(newIntentId, (String)"newIntentId");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), applicationId), FiltersKt.eq((KProperty)((KProperty)Classification_.getIntentId()), oldIntentId)};
        Bson bson = FiltersKt.and((Bson[])bsonArray);
        bsonArray = new SetTo[]{UpdatesKt.setTo((KProperty)((KProperty)Classification_.getIntentId()), newIntentId), UpdatesKt.setTo((KProperty)((KProperty)Classification_.getEntities()), (Object)CollectionsKt.emptyList()), UpdatesKt.setTo((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getStatus()), (Object)ClassifiedSentenceStatus.inbox)};
        MongoCollectionsKt.updateMany$default(this.getCol(), (Bson)bson, (SetTo[])bsonArray, null, (int)4, null);
    }

    public void switchSentencesIntent(@NotNull List<ClassifiedSentence> sentences, @NotNull Id<IntentDefinition> newIntentId) {
        Intrinsics.checkNotNullParameter(sentences, (String)"sentences");
        Intrinsics.checkNotNullParameter(newIntentId, (String)"newIntentId");
        Iterable $this$forEach$iv = sentences;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassifiedSentence it = (ClassifiedSentence)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)newIntentId.toString(), (Object)"tock:unknown")) {
                INSTANCE.save(ClassifiedSentence.copy$default((ClassifiedSentence)it, null, null, null, null, null, null, (Classification)it.getClassification().copy(newIntentId, CollectionsKt.emptyList()), null, null, null, (long)0L, (long)0L, (boolean)false, null, null, null, (int)65471, null));
                continue;
            }
            INSTANCE.save(ClassifiedSentence.copy$default((ClassifiedSentence)it, null, null, null, null, null, null, (Classification)Classification.copy$default((Classification)it.getClassification(), newIntentId, null, (int)2, null), null, null, null, (long)0L, (long)0L, (boolean)false, null, null, null, (int)65471, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void switchSentencesEntity(@NotNull String allowedNamespace, @NotNull List<ClassifiedSentence> sentences, @NotNull EntityDefinition oldEntity, @NotNull EntityDefinition newEntity) {
        Intrinsics.checkNotNullParameter((Object)allowedNamespace, (String)"allowedNamespace");
        Intrinsics.checkNotNullParameter(sentences, (String)"sentences");
        Intrinsics.checkNotNullParameter((Object)oldEntity, (String)"oldEntity");
        Intrinsics.checkNotNullParameter((Object)newEntity, (String)"newEntity");
        EntityTypeDefinition entityTypeDefinition = EntityTypeDefinitionMongoDAO.INSTANCE.getEntityTypeByName(oldEntity.getEntityTypeName());
        if (entityTypeDefinition == null) {
            String string = Intrinsics.stringPlus((String)"no entity type found: ", (Object)oldEntity);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        EntityTypeDefinition oldEntityType = entityTypeDefinition;
        EntityTypeDefinition entityTypeDefinition2 = EntityTypeDefinitionMongoDAO.INSTANCE.getEntityTypeByName(newEntity.getEntityTypeName());
        if (entityTypeDefinition2 == null) {
            String string = Intrinsics.stringPlus((String)"no entity type found: ", (Object)newEntity);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        EntityTypeDefinition newEntityType = entityTypeDefinition2;
        boolean bl = false;
        Set newSubEntityDefinitions = new LinkedHashSet();
        Iterable $this$forEach$iv = sentences;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection<ClassifiedEntity> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterNotTo$iv$iv;
            void $this$filterTo$iv$iv;
            ClassifiedSentence s = (ClassifiedSentence)element$iv;
            boolean bl2 = false;
            Iterable $this$filter$iv = s.getClassification().getEntities();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ClassifiedEntity e = (ClassifiedEntity)element$iv$iv;
                boolean bl3 = false;
                if (!(Intrinsics.areEqual((Object)e.getRole(), (Object)oldEntity.getRole()) && Intrinsics.areEqual((Object)e.getType(), (Object)oldEntity.getEntityTypeName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List selectedEntities = (List)destination$iv$iv;
            Iterable $this$filterNot$iv = s.getClassification().getEntities();
            boolean $i$f$filterNot = false;
            destination$iv$iv = $this$filterNot$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                ClassifiedEntity e = (ClassifiedEntity)element$iv$iv;
                boolean bl4 = false;
                if (Intrinsics.areEqual((Object)e.getRole(), (Object)oldEntity.getRole()) && Intrinsics.areEqual((Object)e.getType(), (Object)oldEntity.getEntityTypeName())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filterNot$iv = selectedEntities;
            Collection collection2 = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterNotTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                List list;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Iterable $this$any$iv;
                ClassifiedEntity subEntity;
                void $this$filterTo$iv$iv2;
                Iterable $this$filter$iv2;
                ClassifiedEntity e = (ClassifiedEntity)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl5 = false;
                Iterable iterable2 = e.getSubEntities();
                boolean $i$f$filter2 = false;
                void var29_42 = $this$filter$iv2;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    boolean bl6;
                    block22: {
                        subEntity = (ClassifiedEntity)element$iv$iv;
                        boolean bl7 = false;
                        $this$any$iv = newEntityType.getSubEntities();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl6 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                EntityDefinition it = (EntityDefinition)element$iv2;
                                boolean bl8 = false;
                                if (!Intrinsics.areEqual((Object)it.getRole(), (Object)subEntity.getRole())) continue;
                                bl6 = true;
                                break block22;
                            }
                            bl6 = false;
                        }
                    }
                    if (!bl6) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                $this$filter$iv2 = (List)destination$iv$iv3;
                boolean $i$f$map22 = false;
                $this$filterTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    Object element$iv32;
                    void $i$f$any;
                    Collection collection3;
                    block23: {
                        void $this$first$iv;
                        void sub;
                        subEntity = (ClassifiedEntity)item$iv$iv2;
                        collection3 = destination$iv$iv3;
                        boolean bl9 = false;
                        $this$any$iv = newEntityType.getSubEntities();
                        $i$f$any = sub;
                        boolean $i$f$first = false;
                        for (Object element$iv32 : $this$first$iv) {
                            EntityDefinition it = (EntityDefinition)element$iv32;
                            boolean bl10 = false;
                            if (!Intrinsics.areEqual((Object)it.getRole(), (Object)sub.getRole())) continue;
                            break block23;
                        }
                        throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    Object t = element$iv32;
                    ClassifiedEntity classifiedEntity = ClassifiedEntity.copy$default((ClassifiedEntity)$i$f$any, (String)((EntityDefinition)t).getEntityTypeName(), null, (int)0, (int)0, null, (int)30, null);
                    collection3.add(classifiedEntity);
                }
                List subEntitiesWithExistingRole = (List)destination$iv$iv3;
                if (Intrinsics.areEqual((Object)ai.tock.shared.StringsKt.namespace((String)newEntityType.getName()), (Object)allowedNamespace)) {
                    void $this$filterNotTo$iv$iv2;
                    List $this$filterNot$iv2;
                    Object item$iv$iv2;
                    Iterable $i$f$map22 = e.getSubEntities();
                    boolean $i$f$filterNot2 = false;
                    destination$iv$iv3 = $this$filterNot$iv2;
                    Collection destination$iv$iv4 = new ArrayList();
                    boolean $i$f$filterNotTo2 = false;
                    item$iv$iv2 = $this$filterNotTo$iv$iv2.iterator();
                    while (item$iv$iv2.hasNext()) {
                        boolean bl11;
                        Object element$iv$iv;
                        block24: {
                            element$iv$iv = item$iv$iv2.next();
                            ClassifiedEntity subEntity2 = (ClassifiedEntity)element$iv$iv;
                            boolean bl12 = false;
                            Iterable $this$any$iv2 = newEntityType.getSubEntities();
                            boolean $i$f$any = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl11 = false;
                            } else {
                                for (Object element$iv32 : $this$any$iv2) {
                                    EntityDefinition it = (EntityDefinition)element$iv32;
                                    boolean bl13 = false;
                                    if (!Intrinsics.areEqual((Object)it.getRole(), (Object)subEntity2.getRole())) continue;
                                    bl11 = true;
                                    break block24;
                                }
                                bl11 = false;
                            }
                        }
                        if (bl11) continue;
                        destination$iv$iv4.add(element$iv$iv);
                    }
                    $this$filterNot$iv2 = (List)destination$iv$iv4;
                    boolean bl14 = false;
                    boolean bl15 = false;
                    List $this$switchSentencesEntity_u24lambda_u2d23_u24lambda_u2d22_u24lambda_u2d21 = $this$filterNot$iv2;
                    boolean bl16 = false;
                    Iterable $this$forEach$iv2 = $this$switchSentencesEntity_u24lambda_u2d23_u24lambda_u2d22_u24lambda_u2d21;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv4 : $this$forEach$iv2) {
                        Unit unit;
                        Object v2;
                        boolean bl17;
                        Object object;
                        block25: {
                            ClassifiedEntity sub = (ClassifiedEntity)element$iv4;
                            boolean bl18 = false;
                            object = oldEntityType.getSubEntities();
                            bl17 = false;
                            Object object2 = object;
                            boolean bl13 = false;
                            Iterator iterator = object2.iterator();
                            while (iterator.hasNext()) {
                                Object t = iterator.next();
                                EntityDefinition it = (EntityDefinition)t;
                                boolean bl19 = false;
                                if (!Intrinsics.areEqual((Object)sub.getRole(), (Object)it.getRole())) continue;
                                v2 = t;
                                break block25;
                            }
                            v2 = null;
                        }
                        EntityDefinition entityDefinition = v2;
                        if (entityDefinition == null) {
                            unit = null;
                            continue;
                        }
                        object = entityDefinition;
                        bl17 = false;
                        boolean bl20 = false;
                        Object newSubEntity = object;
                        boolean bl21 = false;
                        newSubEntityDefinitions.add(newSubEntity);
                        unit = Unit.INSTANCE;
                    }
                    list = $this$filterNot$iv2;
                } else {
                    list = CollectionsKt.emptyList();
                }
                List subEntitiesWithNotExistingRole = list;
                List newSubEntities = CollectionsKt.plus((Collection)subEntitiesWithExistingRole, (Iterable)subEntitiesWithNotExistingRole);
                ClassifiedEntity classifiedEntity = ClassifiedEntity.copy$default((ClassifiedEntity)e, (String)newEntity.getEntityTypeName(), (String)newEntity.getRole(), (int)0, (int)0, (List)CollectionsKt.sorted((Iterable)newSubEntities), (int)12, null);
                collection.add(classifiedEntity);
            }
            collection = (List)destination$iv$iv2;
            List newEntities = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
            INSTANCE.save(ClassifiedSentence.copy$default((ClassifiedSentence)s, null, null, null, null, null, null, (Classification)Classification.copy$default((Classification)s.getClassification(), null, (List)CollectionsKt.sorted((Iterable)newEntities), (int)1, null), null, null, null, (long)0L, (long)0L, (boolean)false, null, null, null, (int)65471, null));
        }
        Collection collection = newSubEntityDefinitions;
        boolean bl22 = false;
        if (!collection.isEmpty()) {
            EntityTypeDefinitionMongoDAO.INSTANCE.save(EntityTypeDefinition.copy$default((EntityTypeDefinition)newEntityType, null, null, (List)CollectionsKt.plus((Collection)newEntityType.getSubEntities(), (Iterable)newSubEntityDefinitions), (boolean)false, (boolean)false, null, (int)59, null));
        }
    }

    public void removeEntityFromSentences(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Id<IntentDefinition> intentId, @NotNull String entityType, @NotNull String role) {
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter(intentId, (String)"intentId");
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), applicationId), FiltersKt.eq((KProperty)((KProperty)Classification_.getIntentId()), intentId)};
        this.getCol().updateMany(FiltersKt.and((Bson[])bsonArray), UpdatesKt.pullByFilter((KProperty)((KProperty)Classification_.getEntities()), (Bson)FiltersKt.eq((KProperty)((KProperty)ClassifiedEntity_.Companion.getRole()), (Object)role)));
    }

    public void removeSubEntityFromSentences(@NotNull Id<ApplicationDefinition> applicationId, @NotNull String entityType, @NotNull String role) {
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Iterable $this$forEach$iv = (Iterable)new IntRange(1, 10);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            INSTANCE.removeSubEntitiesFromSentence(applicationId, entityType, role, it);
        }
    }

    private final void removeSubEntitiesFromSentence(Id<ApplicationDefinition> applicationId, String entityType, String role, int level) {
        String baseFilter2 = Intrinsics.stringPlus((String)"classification.entities", (Object)CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(2, level)), (CharSequence)"", null, null, (int)0, null, (Function1)removeSubEntitiesFromSentence.baseFilter.1.INSTANCE, (int)30, null));
        String filter = "{\n            'applicationId':" + SharedExtensionsKt.getJson(applicationId) + ",\n            '" + baseFilter2 + "':{\n                " + MongoOperator.elemMatch + " :{\n                    type:" + SharedExtensionsKt.getJson((Object)entityType) + ",\n                    subEntities:{\n                        " + MongoOperator.elemMatch + ":{\n                            'role':" + SharedExtensionsKt.getJson((Object)role) + "\n                        }\n                    }\n                }\n            }\n        }";
        String update = "{\n                    " + MongoOperator.pull + ":{\n                        '" + StringsKt.replace$default((String)baseFilter2, (String)".subEntities", (String)".$[].subEntities", (boolean)false, (int)4, null) + ".$.subEntities':{\n                            'role':" + SharedExtensionsKt.getJson((Object)role) + "\n                            }\n                        }\n                    }";
        logger.debug((Function0)new Function0<Object>(filter, update){
            final /* synthetic */ String $filter;
            final /* synthetic */ String $update;
            {
                this.$filter = $filter;
                this.$update = $update;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return this.$filter + ' ' + this.$update;
            }
        });
        MongoCollectionsKt.updateMany$default(this.getCol(), (String)filter, (String)update, null, (int)4, null);
    }

    public final void updateSentenceState$tock_nlp_front_storage_mongo(@NotNull ParseRequestLogMongoDAO.ParseRequestLogStatCol stat) {
        Bson bson;
        Bson bson2;
        double it;
        MongoCollection<ClassifiedSentenceCol> mongoCollection;
        Bson bson3;
        Object[] objectArray;
        int n;
        boolean bl;
        boolean bl2;
        Double d;
        Bson bson4;
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        MongoCollection<ClassifiedSentenceCol> mongoCollection2 = this.getCol();
        Object[] objectArray2 = new Bson[]{FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLanguage()), (Object)stat.getLanguage()), FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), stat.getApplicationId()), FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getText()), (Object)stat.getText())};
        Bson bson5 = FiltersKt.and((Bson[])objectArray2);
        Object[] objectArray3 = objectArray2 = new Bson[4];
        int n2 = 0;
        Double d2 = stat.getIntentProbability();
        if (d2 == null) {
            bson4 = null;
        } else {
            d = d2;
            bl2 = false;
            bl = false;
            double d3 = ((Number)d).doubleValue();
            n = n2;
            objectArray = objectArray3;
            bson3 = bson5;
            mongoCollection = mongoCollection2;
            boolean bl3 = false;
            bson2 = UpdatesKt.setValue((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLastIntentProbability()), (Object)it);
            mongoCollection2 = mongoCollection;
            bson5 = bson3;
            objectArray3 = objectArray;
            n2 = n;
            bson4 = bson2;
        }
        objectArray3[n2] = bson4;
        Object[] objectArray4 = objectArray2;
        int n3 = 1;
        d2 = stat.getEntitiesProbability();
        if (d2 == null) {
            bson = null;
        } else {
            d = d2;
            bl2 = false;
            bl = false;
            it = ((Number)d).doubleValue();
            n = n3;
            objectArray = objectArray4;
            bson3 = bson5;
            mongoCollection = mongoCollection2;
            boolean bl4 = false;
            bson2 = UpdatesKt.setValue((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLastEntityProbability()), (Object)it);
            mongoCollection2 = mongoCollection;
            bson5 = bson3;
            objectArray4 = objectArray;
            n3 = n;
            bson = bson2;
        }
        objectArray4[n3] = bson;
        objectArray2[2] = UpdatesKt.setValue((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLastUsage()), (Object)stat.getLastUsage());
        objectArray2[3] = UpdatesKt.setValue((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getUsageCount()), (Object)stat.getCount());
        mongoCollection2.updateOne(bson5, UpdatesKt.combine((List)CollectionsKt.listOfNotNull((Object[])objectArray2)));
    }

    public void incrementUnknownStat(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language, @NotNull String text) {
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLanguage()), (Object)language), FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), applicationId), FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getText()), (Object)text)};
        this.getCol().updateOne(FiltersKt.and((Bson[])bsonArray), UpdatesKt.inc((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getUnknownCount()), (Number)1));
    }

    private static final ClassifiedSentence getSentences$lambda-0(ClassifiedSentenceCol it) {
        return it.toSentence();
    }

    private static final ClassifiedSentence search$lambda-6$lambda-5(ClassifiedSentenceCol it) {
        return it.toSentence();
    }

    public static final /* synthetic */ Classification_ access$getClassification_$p() {
        return Classification_;
    }

    public static final /* synthetic */ KLogger access$getLogger$p() {
        return logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b4\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u00c7\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u0012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0015\u0012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u0012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0019\u0012\b\b\u0002\u0010\u001b\u001a\u00020\u001c\u0012\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0006\u0012\u0010\b\u0002\u0010\u001e\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u001f\u0012\u0014\b\u0002\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150!\u00a2\u0006\u0002\u0010\"J\t\u0010@\u001a\u00020\u0006H\u00c6\u0003J\u0010\u0010A\u001a\u0004\u0018\u00010\u0015H\u00c6\u0003\u00a2\u0006\u0002\u00101J\u000b\u0010B\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\u0010\u0010C\u001a\u0004\u0018\u00010\u0019H\u00c6\u0003\u00a2\u0006\u0002\u0010<J\u0010\u0010D\u001a\u0004\u0018\u00010\u0019H\u00c6\u0003\u00a2\u0006\u0002\u0010<J\t\u0010E\u001a\u00020\u001cH\u00c6\u0003J\u000b\u0010F\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u0011\u0010G\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u001fH\u00c6\u0003J\u0015\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150!H\u00c6\u0003J\t\u0010I\u001a\u00020\u0006H\u00c6\u0003J\t\u0010J\u001a\u00020\tH\u00c6\u0003J\u000f\u0010K\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003J\t\u0010L\u001a\u00020\u000eH\u00c6\u0003J\t\u0010M\u001a\u00020\u000eH\u00c6\u0003J\t\u0010N\u001a\u00020\u0011H\u00c6\u0003J\t\u0010O\u001a\u00020\u0013H\u00c6\u0003J\u0010\u0010P\u001a\u0004\u0018\u00010\u0015H\u00c6\u0003\u00a2\u0006\u0002\u00101J\u00de\u0001\u0010Q\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u00062\u0010\b\u0002\u0010\u001e\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u001f2\u0014\b\u0002\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150!H\u00c6\u0001\u00a2\u0006\u0002\u0010RJ\u0013\u0010S\u001a\u00020\u001c2\b\u0010T\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010U\u001a\u00020VH\u00d6\u0001J\u0006\u0010W\u001a\u00020\u0003J\t\u0010X\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0019\u0010\u001e\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010(R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0015\u0010\u0016\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\n\n\u0002\u00102\u001a\u0004\b0\u00101R\u0015\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\n\n\u0002\u00102\u001a\u0004\b3\u00101R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010*R\u001d\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150!\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010(R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010(R\u0015\u0010\u001a\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\n\n\u0002\u0010=\u001a\u0004\b;\u0010<R\u0011\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010*R\u0015\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\n\n\u0002\u0010=\u001a\u0004\b?\u0010<\u00a8\u0006Y"}, d2={"Lai/tock/nlp/front/storage/mongo/ClassifiedSentenceMongoDAO$ClassifiedSentenceCol;", "", "sentence", "Lai/tock/nlp/front/shared/config/ClassifiedSentence;", "(Lai/tock/nlp/front/shared/config/ClassifiedSentence;)V", "text", "", "fullText", "language", "Ljava/util/Locale;", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "creationDate", "Ljava/time/Instant;", "updateDate", "status", "Lai/tock/nlp/front/shared/config/ClassifiedSentenceStatus;", "classification", "Lai/tock/nlp/front/shared/config/Classification;", "lastIntentProbability", "", "lastEntityProbability", "lastUsage", "usageCount", "", "unknownCount", "forReview", "", "reviewComment", "classifier", "Lai/tock/shared/security/UserLogin;", "otherIntentsProbabilities", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Locale;Lorg/litote/kmongo/Id;Ljava/time/Instant;Ljava/time/Instant;Lai/tock/nlp/front/shared/config/ClassifiedSentenceStatus;Lai/tock/nlp/front/shared/config/Classification;Ljava/lang/Double;Ljava/lang/Double;Ljava/time/Instant;Ljava/lang/Long;Ljava/lang/Long;ZLjava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "getApplicationId", "()Lorg/litote/kmongo/Id;", "getClassification", "()Lai/tock/nlp/front/shared/config/Classification;", "getClassifier", "()Ljava/lang/String;", "getCreationDate", "()Ljava/time/Instant;", "getForReview", "()Z", "getFullText", "getLanguage", "()Ljava/util/Locale;", "getLastEntityProbability", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getLastIntentProbability", "getLastUsage", "getOtherIntentsProbabilities", "()Ljava/util/Map;", "getReviewComment", "getStatus", "()Lai/tock/nlp/front/shared/config/ClassifiedSentenceStatus;", "getText", "getUnknownCount", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getUpdateDate", "getUsageCount", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Locale;Lorg/litote/kmongo/Id;Ljava/time/Instant;Ljava/time/Instant;Lai/tock/nlp/front/shared/config/ClassifiedSentenceStatus;Lai/tock/nlp/front/shared/config/Classification;Ljava/lang/Double;Ljava/lang/Double;Ljava/time/Instant;Ljava/lang/Long;Ljava/lang/Long;ZLjava/lang/String;Ljava/lang/String;Ljava/util/Map;)Lai/tock/nlp/front/storage/mongo/ClassifiedSentenceMongoDAO$ClassifiedSentenceCol;", "equals", "other", "hashCode", "", "toSentence", "toString", "tock-nlp-front-storage-mongo"})
    public static final class ClassifiedSentenceCol {
        @NotNull
        private final String text;
        @NotNull
        private final String fullText;
        @NotNull
        private final Locale language;
        @NotNull
        private final Id<ApplicationDefinition> applicationId;
        @NotNull
        private final Instant creationDate;
        @NotNull
        private final Instant updateDate;
        @NotNull
        private final ClassifiedSentenceStatus status;
        @NotNull
        private final Classification classification;
        @Nullable
        private final Double lastIntentProbability;
        @Nullable
        private final Double lastEntityProbability;
        @Nullable
        private final Instant lastUsage;
        @Nullable
        private final Long usageCount;
        @Nullable
        private final Long unknownCount;
        private final boolean forReview;
        @Nullable
        private final String reviewComment;
        @Nullable
        private final String classifier;
        @NotNull
        private final Map<String, Double> otherIntentsProbabilities;

        public ClassifiedSentenceCol(@NotNull String text, @NotNull String fullText, @NotNull Locale language, @NotNull Id<ApplicationDefinition> applicationId, @NotNull Instant creationDate, @NotNull Instant updateDate, @NotNull ClassifiedSentenceStatus status, @NotNull Classification classification2, @Nullable Double lastIntentProbability, @Nullable Double lastEntityProbability, @Nullable Instant lastUsage, @Nullable Long usageCount, @Nullable Long unknownCount, boolean forReview, @Nullable String reviewComment, @Nullable String classifier, @NotNull Map<String, Double> otherIntentsProbabilities2) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)fullText, (String)"fullText");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)creationDate, (String)"creationDate");
            Intrinsics.checkNotNullParameter((Object)updateDate, (String)"updateDate");
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Intrinsics.checkNotNullParameter((Object)classification2, (String)"classification");
            Intrinsics.checkNotNullParameter(otherIntentsProbabilities2, (String)"otherIntentsProbabilities");
            this.text = text;
            this.fullText = fullText;
            this.language = language;
            this.applicationId = applicationId;
            this.creationDate = creationDate;
            this.updateDate = updateDate;
            this.status = status;
            this.classification = classification2;
            this.lastIntentProbability = lastIntentProbability;
            this.lastEntityProbability = lastEntityProbability;
            this.lastUsage = lastUsage;
            this.usageCount = usageCount;
            this.unknownCount = unknownCount;
            this.forReview = forReview;
            this.reviewComment = reviewComment;
            this.classifier = classifier;
            this.otherIntentsProbabilities = otherIntentsProbabilities2;
        }

        public /* synthetic */ ClassifiedSentenceCol(String string, String string2, Locale locale, Id id, Instant instant, Instant instant2, ClassifiedSentenceStatus classifiedSentenceStatus, Classification classification2, Double d, Double d2, Instant instant3, Long l, Long l2, boolean bl, String string3, String string4, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = string;
            }
            if ((n & 0x100) != 0) {
                d = null;
            }
            if ((n & 0x200) != 0) {
                d2 = null;
            }
            if ((n & 0x400) != 0) {
                instant3 = null;
            }
            if ((n & 0x800) != 0) {
                l = 0L;
            }
            if ((n & 0x1000) != 0) {
                l2 = 0L;
            }
            if ((n & 0x2000) != 0) {
                bl = false;
            }
            if ((n & 0x4000) != 0) {
                string3 = null;
            }
            if ((n & 0x8000) != 0) {
                string4 = null;
            }
            if ((n & 0x10000) != 0) {
                map = MapsKt.emptyMap();
            }
            this(string, string2, locale, (Id<ApplicationDefinition>)id, instant, instant2, classifiedSentenceStatus, classification2, d, d2, instant3, l, l2, bl, string3, string4, map);
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String getFullText() {
            return this.fullText;
        }

        @NotNull
        public final Locale getLanguage() {
            return this.language;
        }

        @NotNull
        public final Id<ApplicationDefinition> getApplicationId() {
            return this.applicationId;
        }

        @NotNull
        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @NotNull
        public final Instant getUpdateDate() {
            return this.updateDate;
        }

        @NotNull
        public final ClassifiedSentenceStatus getStatus() {
            return this.status;
        }

        @NotNull
        public final Classification getClassification() {
            return this.classification;
        }

        @Nullable
        public final Double getLastIntentProbability() {
            return this.lastIntentProbability;
        }

        @Nullable
        public final Double getLastEntityProbability() {
            return this.lastEntityProbability;
        }

        @Nullable
        public final Instant getLastUsage() {
            return this.lastUsage;
        }

        @Nullable
        public final Long getUsageCount() {
            return this.usageCount;
        }

        @Nullable
        public final Long getUnknownCount() {
            return this.unknownCount;
        }

        public final boolean getForReview() {
            return this.forReview;
        }

        @Nullable
        public final String getReviewComment() {
            return this.reviewComment;
        }

        @Nullable
        public final String getClassifier() {
            return this.classifier;
        }

        @NotNull
        public final Map<String, Double> getOtherIntentsProbabilities() {
            return this.otherIntentsProbabilities;
        }

        public ClassifiedSentenceCol(@NotNull ClassifiedSentence sentence) {
            Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
            String string = MongoHelpersKt.textKey(sentence.getText());
            String string2 = sentence.getText();
            Locale locale = sentence.getLanguage();
            Id id = sentence.getApplicationId();
            Instant instant = sentence.getCreationDate();
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now()");
            this(string, string2, locale, (Id<ApplicationDefinition>)id, instant, instant2, sentence.getStatus(), sentence.getClassification(), sentence.getLastIntentProbability(), sentence.getLastEntityProbability(), sentence.getLastUsage(), sentence.getUsageCount(), sentence.getUnknownCount(), sentence.getForReview(), sentence.getReviewComment(), sentence.getQualifier(), sentence.getOtherIntentsProbabilities());
        }

        @NotNull
        public final ClassifiedSentence toSentence() {
            Long l = this.usageCount;
            long l2 = l == null ? 0L : l;
            l = this.unknownCount;
            return new ClassifiedSentence(this.fullText, this.language, this.applicationId, this.creationDate, this.updateDate, this.status, this.classification, this.lastIntentProbability, this.lastEntityProbability, this.lastUsage, l2, l == null ? 0L : l, this.forReview, this.reviewComment, this.classifier, this.otherIntentsProbabilities);
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final String component2() {
            return this.fullText;
        }

        @NotNull
        public final Locale component3() {
            return this.language;
        }

        @NotNull
        public final Id<ApplicationDefinition> component4() {
            return this.applicationId;
        }

        @NotNull
        public final Instant component5() {
            return this.creationDate;
        }

        @NotNull
        public final Instant component6() {
            return this.updateDate;
        }

        @NotNull
        public final ClassifiedSentenceStatus component7() {
            return this.status;
        }

        @NotNull
        public final Classification component8() {
            return this.classification;
        }

        @Nullable
        public final Double component9() {
            return this.lastIntentProbability;
        }

        @Nullable
        public final Double component10() {
            return this.lastEntityProbability;
        }

        @Nullable
        public final Instant component11() {
            return this.lastUsage;
        }

        @Nullable
        public final Long component12() {
            return this.usageCount;
        }

        @Nullable
        public final Long component13() {
            return this.unknownCount;
        }

        public final boolean component14() {
            return this.forReview;
        }

        @Nullable
        public final String component15() {
            return this.reviewComment;
        }

        @Nullable
        public final String component16() {
            return this.classifier;
        }

        @NotNull
        public final Map<String, Double> component17() {
            return this.otherIntentsProbabilities;
        }

        @NotNull
        public final ClassifiedSentenceCol copy(@NotNull String text, @NotNull String fullText, @NotNull Locale language, @NotNull Id<ApplicationDefinition> applicationId, @NotNull Instant creationDate, @NotNull Instant updateDate, @NotNull ClassifiedSentenceStatus status, @NotNull Classification classification2, @Nullable Double lastIntentProbability, @Nullable Double lastEntityProbability, @Nullable Instant lastUsage, @Nullable Long usageCount, @Nullable Long unknownCount, boolean forReview, @Nullable String reviewComment, @Nullable String classifier, @NotNull Map<String, Double> otherIntentsProbabilities2) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)fullText, (String)"fullText");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)creationDate, (String)"creationDate");
            Intrinsics.checkNotNullParameter((Object)updateDate, (String)"updateDate");
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Intrinsics.checkNotNullParameter((Object)classification2, (String)"classification");
            Intrinsics.checkNotNullParameter(otherIntentsProbabilities2, (String)"otherIntentsProbabilities");
            return new ClassifiedSentenceCol(text, fullText, language, applicationId, creationDate, updateDate, status, classification2, lastIntentProbability, lastEntityProbability, lastUsage, usageCount, unknownCount, forReview, reviewComment, classifier, otherIntentsProbabilities2);
        }

        public static /* synthetic */ ClassifiedSentenceCol copy$default(ClassifiedSentenceCol classifiedSentenceCol, String string, String string2, Locale locale, Id id, Instant instant, Instant instant2, ClassifiedSentenceStatus classifiedSentenceStatus, Classification classification2, Double d, Double d2, Instant instant3, Long l, Long l2, boolean bl, String string3, String string4, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                string = classifiedSentenceCol.text;
            }
            if ((n & 2) != 0) {
                string2 = classifiedSentenceCol.fullText;
            }
            if ((n & 4) != 0) {
                locale = classifiedSentenceCol.language;
            }
            if ((n & 8) != 0) {
                id = classifiedSentenceCol.applicationId;
            }
            if ((n & 0x10) != 0) {
                instant = classifiedSentenceCol.creationDate;
            }
            if ((n & 0x20) != 0) {
                instant2 = classifiedSentenceCol.updateDate;
            }
            if ((n & 0x40) != 0) {
                classifiedSentenceStatus = classifiedSentenceCol.status;
            }
            if ((n & 0x80) != 0) {
                classification2 = classifiedSentenceCol.classification;
            }
            if ((n & 0x100) != 0) {
                d = classifiedSentenceCol.lastIntentProbability;
            }
            if ((n & 0x200) != 0) {
                d2 = classifiedSentenceCol.lastEntityProbability;
            }
            if ((n & 0x400) != 0) {
                instant3 = classifiedSentenceCol.lastUsage;
            }
            if ((n & 0x800) != 0) {
                l = classifiedSentenceCol.usageCount;
            }
            if ((n & 0x1000) != 0) {
                l2 = classifiedSentenceCol.unknownCount;
            }
            if ((n & 0x2000) != 0) {
                bl = classifiedSentenceCol.forReview;
            }
            if ((n & 0x4000) != 0) {
                string3 = classifiedSentenceCol.reviewComment;
            }
            if ((n & 0x8000) != 0) {
                string4 = classifiedSentenceCol.classifier;
            }
            if ((n & 0x10000) != 0) {
                map = classifiedSentenceCol.otherIntentsProbabilities;
            }
            return classifiedSentenceCol.copy(string, string2, locale, id, instant, instant2, classifiedSentenceStatus, classification2, d, d2, instant3, l, l2, bl, string3, string4, map);
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ClassifiedSentenceCol(text=").append(this.text).append(", fullText=").append(this.fullText).append(", language=").append(this.language).append(", applicationId=").append(this.applicationId).append(", creationDate=").append(this.creationDate).append(", updateDate=").append(this.updateDate).append(", status=").append(this.status).append(", classification=").append(this.classification).append(", lastIntentProbability=").append(this.lastIntentProbability).append(", lastEntityProbability=").append(this.lastEntityProbability).append(", lastUsage=").append(this.lastUsage).append(", usageCount=");
            stringBuilder.append(this.usageCount).append(", unknownCount=").append(this.unknownCount).append(", forReview=").append(this.forReview).append(", reviewComment=").append((Object)this.reviewComment).append(", classifier=").append((Object)this.classifier).append(", otherIntentsProbabilities=").append(this.otherIntentsProbabilities).append(')');
            return stringBuilder.toString();
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + this.fullText.hashCode();
            result2 = result2 * 31 + this.language.hashCode();
            result2 = result2 * 31 + this.applicationId.hashCode();
            result2 = result2 * 31 + this.creationDate.hashCode();
            result2 = result2 * 31 + this.updateDate.hashCode();
            result2 = result2 * 31 + this.status.hashCode();
            result2 = result2 * 31 + this.classification.hashCode();
            result2 = result2 * 31 + (this.lastIntentProbability == null ? 0 : ((Object)this.lastIntentProbability).hashCode());
            result2 = result2 * 31 + (this.lastEntityProbability == null ? 0 : ((Object)this.lastEntityProbability).hashCode());
            result2 = result2 * 31 + (this.lastUsage == null ? 0 : this.lastUsage.hashCode());
            result2 = result2 * 31 + (this.usageCount == null ? 0 : ((Object)this.usageCount).hashCode());
            result2 = result2 * 31 + (this.unknownCount == null ? 0 : ((Object)this.unknownCount).hashCode());
            int n = this.forReview ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            result2 = result2 * 31 + (this.reviewComment == null ? 0 : this.reviewComment.hashCode());
            result2 = result2 * 31 + (this.classifier == null ? 0 : this.classifier.hashCode());
            result2 = result2 * 31 + ((Object)this.otherIntentsProbabilities).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClassifiedSentenceCol)) {
                return false;
            }
            ClassifiedSentenceCol classifiedSentenceCol = (ClassifiedSentenceCol)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)classifiedSentenceCol.text)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fullText, (Object)classifiedSentenceCol.fullText)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.language, (Object)classifiedSentenceCol.language)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.applicationId, classifiedSentenceCol.applicationId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.creationDate, (Object)classifiedSentenceCol.creationDate)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.updateDate, (Object)classifiedSentenceCol.updateDate)) {
                return false;
            }
            if (this.status != classifiedSentenceCol.status) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.classification, (Object)classifiedSentenceCol.classification)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastIntentProbability, (Object)classifiedSentenceCol.lastIntentProbability)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastEntityProbability, (Object)classifiedSentenceCol.lastEntityProbability)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastUsage, (Object)classifiedSentenceCol.lastUsage)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.usageCount, (Object)classifiedSentenceCol.usageCount)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.unknownCount, (Object)classifiedSentenceCol.unknownCount)) {
                return false;
            }
            if (this.forReview != classifiedSentenceCol.forReview) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.reviewComment, (Object)classifiedSentenceCol.reviewComment)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.classifier, (Object)classifiedSentenceCol.classifier)) {
                return false;
            }
            return Intrinsics.areEqual(this.otherIntentsProbabilities, classifiedSentenceCol.otherIntentsProbabilities);
        }
    }
}

