/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.front.storage.mongo;

import ai.tock.nlp.front.service.storage.TestModelDAO;
import ai.tock.nlp.front.shared.config.ApplicationDefinition;
import ai.tock.nlp.front.shared.config.IntentDefinition;
import ai.tock.nlp.front.shared.test.EntityTestError;
import ai.tock.nlp.front.shared.test.EntityTestErrorQueryResult;
import ai.tock.nlp.front.shared.test.EntityTestError_;
import ai.tock.nlp.front.shared.test.IntentTestError;
import ai.tock.nlp.front.shared.test.IntentTestErrorQueryResult;
import ai.tock.nlp.front.shared.test.IntentTestError_;
import ai.tock.nlp.front.shared.test.TestBuild;
import ai.tock.nlp.front.shared.test.TestBuild_;
import ai.tock.nlp.front.shared.test.TestErrorQuery;
import ai.tock.nlp.front.storage.mongo.IntentDefinitionMongoDAO;
import ai.tock.nlp.front.storage.mongo.MongoHelpersKt;
import ai.tock.nlp.front.storage.mongo.TestModelMongoDAO;
import ai.tock.shared.StringsKt;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.KMongoIterableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.FindIterablesKt;
import org.litote.kmongo.Id;
import org.litote.kmongo.MongoCollectionsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J&\u0010\u0017\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J&\u0010\u001f\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0005H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010\"\u001a\u00020#H\u0016R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\t\u001a\u0004\b\f\u0010\u0007R!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\t\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006*"}, d2={"Lai/tock/nlp/front/storage/mongo/TestModelMongoDAO;", "Lai/tock/nlp/front/service/storage/TestModelDAO;", "()V", "buildCol", "Lcom/mongodb/client/MongoCollection;", "Lai/tock/nlp/front/shared/test/TestBuild;", "getBuildCol", "()Lcom/mongodb/client/MongoCollection;", "buildCol$delegate", "Lkotlin/Lazy;", "entityErrorCol", "Lai/tock/nlp/front/shared/test/EntityTestError;", "getEntityErrorCol", "entityErrorCol$delegate", "intentErrorCol", "Lai/tock/nlp/front/shared/test/IntentTestError;", "getIntentErrorCol", "intentErrorCol$delegate", "addTestEntityError", "", "entityError", "addTestIntentError", "intentError", "deleteTestEntityError", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "language", "Ljava/util/Locale;", "text", "", "deleteTestIntentError", "getTestBuilds", "", "query", "Lai/tock/nlp/front/shared/test/TestErrorQuery;", "saveTestBuild", "build", "searchTestEntityErrors", "Lai/tock/nlp/front/shared/test/EntityTestErrorQueryResult;", "searchTestIntentErrors", "Lai/tock/nlp/front/shared/test/IntentTestErrorQueryResult;", "tock-nlp-front-storage-mongo"})
public final class TestModelMongoDAO
implements TestModelDAO {
    @NotNull
    public static final TestModelMongoDAO INSTANCE = new TestModelMongoDAO();
    @NotNull
    private static final Lazy buildCol$delegate = LazyKt.lazy((Function0)buildCol.2.INSTANCE);
    @NotNull
    private static final Lazy intentErrorCol$delegate = LazyKt.lazy((Function0)intentErrorCol.2.INSTANCE);
    @NotNull
    private static final Lazy entityErrorCol$delegate = LazyKt.lazy((Function0)entityErrorCol.2.INSTANCE);

    private TestModelMongoDAO() {
    }

    private final MongoCollection<TestBuild> getBuildCol() {
        Lazy lazy = buildCol$delegate;
        boolean bl = false;
        return (MongoCollection)lazy.getValue();
    }

    private final MongoCollection<IntentTestError> getIntentErrorCol() {
        Lazy lazy = intentErrorCol$delegate;
        boolean bl = false;
        return (MongoCollection)lazy.getValue();
    }

    private final MongoCollection<EntityTestError> getEntityErrorCol() {
        Lazy lazy = entityErrorCol$delegate;
        boolean bl = false;
        return (MongoCollection)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<TestBuild> getTestBuilds(@NotNull TestErrorQuery query2) {
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        boolean bl = false;
        boolean bl2 = false;
        TestErrorQuery $this$getTestBuilds_u24lambda_u2d1 = query2;
        boolean bl3 = false;
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getLanguage()), (Object)$this$getTestBuilds_u24lambda_u2d1.getLanguage()), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getApplicationId()), (Object)$this$getTestBuilds_u24lambda_u2d1.getApplicationId()), $this$getTestBuilds_u24lambda_u2d1.getAfter() != null ? FiltersKt.gte((KProperty)((KProperty)TestBuild_.Companion.getStartDate()), (Object)$this$getTestBuilds_u24lambda_u2d1.getAfter()) : null};
        MongoIterable mongoIterable = INSTANCE.getBuildCol().find(FiltersKt.and((Bson[])bsonArray));
        Intrinsics.checkNotNullExpressionValue((Object)mongoIterable, (String)"buildCol.find(\n                and(\n                    Language eq language,\n                    ApplicationId eq applicationId,\n                    if (after != null) StartDate gte after else null\n                )\n            )");
        MongoIterable mongoIterable2 = mongoIterable;
        mongoIterable = new MongoIterable[]{(KProperty)TestBuild_.Companion.getStartDate()};
        mongoIterable = (MongoIterable)FindIterablesKt.descendingSort((FindIterable)mongoIterable2, (KProperty[])mongoIterable);
        boolean $i$f$mapNotNull = false;
        return CollectionsKt.toList((Iterable)((List)KMongoIterableKt.useCursor((MongoIterable)$this$mapNotNull$iv, (Function1)((Function1)new Function1<Iterable<? extends TestBuild>, List<? extends TestBuild>>($this$getTestBuilds_u24lambda_u2d1){
            final /* synthetic */ TestErrorQuery $this_with$inlined;
            {
                this.$this_with$inlined = testErrorQuery;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<TestBuild> invoke(@NotNull Iterable<? extends TestBuild> it) {
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Iterable<? extends TestBuild> $this$mapNotNull$iv = it;
                boolean $i$f$mapNotNull = false;
                Iterable<? extends TestBuild> iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    TestBuild testBuild;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    TestBuild it2 = (TestBuild)element$iv$iv;
                    boolean bl2 = false;
                    String intent = this.$this_with$inlined.getIntentName();
                    if (intent == null) {
                        testBuild = it2;
                    } else {
                        Integer n = (Integer)it2.getIntentErrorsByIntent().get(intent);
                        int intentErrors = n == null ? 0 : n;
                        Integer n2 = (Integer)it2.getEntityErrorsByIntent().get(intent);
                        int entityErrors = n2 == null ? 0 : n2;
                        Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                        n2 = (Integer)it2.getNbSentencesTestedByIntent().get(intent);
                        testBuild = TestBuild.copy$default((TestBuild)it2, null, null, null, null, null, (int)0, (int)(n2 == null ? 0 : n2), (int)(intentErrors + entityErrors), (int)intentErrors, (int)entityErrors, null, null, null, (int)7231, null);
                    }
                    if (testBuild == null) continue;
                    TestBuild testBuild2 = testBuild;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    TestBuild it$iv$iv = testBuild2;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }))));
    }

    public void saveTestBuild(@NotNull TestBuild build) {
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        this.getBuildCol().insertOne((Object)build);
    }

    @NotNull
    public IntentTestErrorQueryResult searchTestIntentErrors(@NotNull TestErrorQuery query2) {
        IntentTestErrorQueryResult intentTestErrorQueryResult;
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getLanguage()), (Object)query2.getLanguage()), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getApplicationId()), (Object)query2.getApplicationId()), query2.getIntentName() == null ? null : FiltersKt.eq((KProperty)((KProperty)IntentTestError_.Companion.getCurrentIntent()), (Object)query2.getIntentName())};
        Bson filter = FiltersKt.and((Bson[])bsonArray);
        int count = (int)this.getIntentErrorCol().countDocuments(filter);
        if (count == 0) {
            intentTestErrorQueryResult = new IntentTestErrorQueryResult(0, CollectionsKt.emptyList());
        } else {
            KProperty[] kPropertyArray = this.getIntentErrorCol().find(filter);
            Intrinsics.checkNotNullExpressionValue((Object)kPropertyArray, (String)"intentErrorCol\n                    .find(filter)");
            KProperty[] kPropertyArray2 = kPropertyArray;
            kPropertyArray = new KProperty[]{(KProperty)IntentTestError_.Companion.getCount()};
            FindIterable findIterable = FindIterablesKt.descendingSort((FindIterable)kPropertyArray2, (KProperty[])kPropertyArray).skip((int)query2.getStart()).limit(query2.getSize());
            Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"intentErrorCol\n                    .find(filter)\n                    .descendingSort(Count)\n                    .skip(query.start.toInt())\n                    .limit(query.size)");
            IntentTestErrorQueryResult intentTestErrorQueryResult2 = new IntentTestErrorQueryResult(count, KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable)));
            intentTestErrorQueryResult = intentTestErrorQueryResult2;
        }
        return intentTestErrorQueryResult;
    }

    public void addTestIntentError(@NotNull IntentTestError intentError) {
        block2: {
            IntentTestError intentTestError;
            IntentTestError intentTestError2;
            Intrinsics.checkNotNullParameter((Object)intentError, (String)"intentError");
            Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)IntentTestError_.Companion.getText()), (Object)MongoHelpersKt.textKey(intentError.getText())), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getLanguage()), (Object)intentError.getLanguage()), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getApplicationId()), (Object)intentError.getApplicationId())};
            Bson filter = FiltersKt.and((Bson[])bsonArray);
            boolean newError = intentError.getCount() != 0;
            IntentTestError intentTestError3 = (IntentTestError)MongoCollectionsKt.findOne(this.getIntentErrorCol(), (Bson)filter);
            if (intentTestError3 == null) {
                intentTestError2 = null;
            } else {
                IntentTestError intentTestError4 = intentTestError3;
                boolean bl = false;
                boolean bl2 = false;
                IntentTestError $this$addTestIntentError_u24lambda_u2d2 = intentTestError4;
                boolean bl3 = false;
                int n = $this$addTestIntentError_u24lambda_u2d2.getCount() + intentError.getCount();
                String string = newError ? intentError.getCurrentIntent() : $this$addTestIntentError_u24lambda_u2d2.getCurrentIntent();
                String string2 = newError ? intentError.getWrongIntent() : $this$addTestIntentError_u24lambda_u2d2.getWrongIntent();
                double d = newError ? ($this$addTestIntentError_u24lambda_u2d2.getAverageErrorProbability() * (double)$this$addTestIntentError_u24lambda_u2d2.getTotal() + intentError.getAverageErrorProbability()) / (double)($this$addTestIntentError_u24lambda_u2d2.getTotal() + 1) : $this$addTestIntentError_u24lambda_u2d2.getAverageErrorProbability();
                int n2 = $this$addTestIntentError_u24lambda_u2d2.getTotal() + 1;
                INSTANCE.getIntentErrorCol().replaceOne(filter, (Object)IntentTestError.copy$default((IntentTestError)$this$addTestIntentError_u24lambda_u2d2, null, null, null, (String)string, (String)string2, (double)d, (int)n, (int)n2, null, (int)263, null));
                intentTestError2 = intentTestError = intentTestError4;
            }
            if (intentTestError != null || !newError) break block2;
            MongoCollectionsKt.save(this.getIntentErrorCol(), (Object)IntentTestError.copy$default((IntentTestError)intentError, null, null, (String)MongoHelpersKt.textKey(intentError.getText()), null, null, (double)0.0, (int)0, (int)0, null, (int)507, null));
        }
    }

    public void deleteTestIntentError(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language, @NotNull String text) {
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)IntentTestError_.Companion.getText()), (Object)MongoHelpersKt.textKey(text)), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getLanguage()), (Object)language), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getApplicationId()), applicationId)};
        this.getIntentErrorCol().deleteOne(FiltersKt.and((Bson[])bsonArray));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public EntityTestErrorQueryResult searchTestEntityErrors(@NotNull TestErrorQuery query2) {
        EntityTestErrorQueryResult entityTestErrorQueryResult;
        FindIterable findIterable;
        Bson bson;
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        Bson[] bsonArray = new Bson[3];
        bsonArray[0] = FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getLanguage()), (Object)query2.getLanguage());
        bsonArray[1] = FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getApplicationId()), (Object)query2.getApplicationId());
        Bson[] bsonArray2 = bsonArray;
        int n = 2;
        FindIterable findIterable2 = query2.getIntentName();
        if (findIterable2 == null) {
            bson = null;
        } else {
            Bson bson2;
            void intentName;
            findIterable = findIterable2;
            boolean bl = false;
            boolean bl2 = false;
            FindIterable findIterable3 = findIterable;
            int n2 = n;
            Bson[] bsonArray3 = bsonArray2;
            boolean bl3 = false;
            IntentDefinition intentDefinition = IntentDefinitionMongoDAO.INSTANCE.getIntentByNamespaceAndName(StringsKt.namespace((String)intentName), StringsKt.name((String)intentName));
            if (intentDefinition == null) {
                bson2 = null;
            } else {
                IntentDefinition intentDefinition2 = intentDefinition;
                boolean bl4 = false;
                boolean bl5 = false;
                IntentDefinition it = intentDefinition2;
                boolean bl6 = false;
                bson2 = FiltersKt.eq((KProperty)((KProperty)EntityTestError_.Companion.getIntentId()), (Object)it.get_id());
            }
            Bson bson3 = bson2;
            bsonArray2 = bsonArray3;
            n = n2;
            bson = bson3;
        }
        bsonArray2[n] = bson;
        Bson filter = FiltersKt.and((Bson[])bsonArray);
        int count = (int)this.getEntityErrorCol().countDocuments(filter);
        if (count == 0) {
            entityTestErrorQueryResult = new EntityTestErrorQueryResult(0, CollectionsKt.emptyList());
        } else {
            findIterable = this.getEntityErrorCol().find(filter);
            Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"entityErrorCol\n                    .find(filter)");
            FindIterable findIterable4 = findIterable;
            findIterable = new FindIterable[]{(KProperty)IntentTestError_.Companion.getCount()};
            findIterable2 = FindIterablesKt.descendingSort((FindIterable)findIterable4, (KProperty[])findIterable).skip((int)query2.getStart()).limit(query2.getSize());
            Intrinsics.checkNotNullExpressionValue((Object)findIterable2, (String)"entityErrorCol\n                    .find(filter)\n                    .descendingSort(Count)\n                    .skip(query.start.toInt())\n                    .limit(query.size)");
            EntityTestErrorQueryResult entityTestErrorQueryResult2 = new EntityTestErrorQueryResult(count, KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable2)));
            entityTestErrorQueryResult = entityTestErrorQueryResult2;
        }
        return entityTestErrorQueryResult;
    }

    public void addTestEntityError(@NotNull EntityTestError entityError) {
        block2: {
            EntityTestError entityTestError;
            EntityTestError entityTestError2;
            Intrinsics.checkNotNullParameter((Object)entityError, (String)"entityError");
            Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)IntentTestError_.Companion.getText()), (Object)MongoHelpersKt.textKey(entityError.getText())), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getLanguage()), (Object)entityError.getLanguage()), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getApplicationId()), (Object)entityError.getApplicationId())};
            Bson filter = FiltersKt.and((Bson[])bsonArray);
            boolean newError = entityError.getCount() != 0;
            EntityTestError entityTestError3 = (EntityTestError)MongoCollectionsKt.findOne(this.getEntityErrorCol(), (Bson)filter);
            if (entityTestError3 == null) {
                entityTestError2 = null;
            } else {
                EntityTestError entityTestError4 = entityTestError3;
                boolean bl = false;
                boolean bl2 = false;
                EntityTestError $this$addTestEntityError_u24lambda_u2d5 = entityTestError4;
                boolean bl3 = false;
                int n = $this$addTestEntityError_u24lambda_u2d5.getCount() + entityError.getCount();
                Id id = entityError.getIntentId();
                List list = newError ? entityError.getLastAnalyse() : $this$addTestEntityError_u24lambda_u2d5.getLastAnalyse();
                double d = newError ? ($this$addTestEntityError_u24lambda_u2d5.getAverageErrorProbability() * (double)$this$addTestEntityError_u24lambda_u2d5.getTotal() + entityError.getAverageErrorProbability()) / (double)($this$addTestEntityError_u24lambda_u2d5.getTotal() + 1) : $this$addTestEntityError_u24lambda_u2d5.getAverageErrorProbability();
                int n2 = $this$addTestEntityError_u24lambda_u2d5.getTotal() + 1;
                INSTANCE.getEntityErrorCol().replaceOne(filter, (Object)EntityTestError.copy$default((EntityTestError)$this$addTestEntityError_u24lambda_u2d5, null, null, null, (Id)id, (List)list, (double)d, (int)n, (int)n2, null, (int)263, null));
                entityTestError2 = entityTestError = entityTestError4;
            }
            if (entityTestError != null || !newError) break block2;
            MongoCollectionsKt.save(this.getEntityErrorCol(), (Object)EntityTestError.copy$default((EntityTestError)entityError, null, null, (String)MongoHelpersKt.textKey(entityError.getText()), null, null, (double)0.0, (int)0, (int)0, null, (int)507, null));
        }
    }

    public void deleteTestEntityError(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language, @NotNull String text) {
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)IntentTestError_.Companion.getText()), (Object)MongoHelpersKt.textKey(text)), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getLanguage()), (Object)language), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getApplicationId()), applicationId)};
        this.getEntityErrorCol().deleteOne(FiltersKt.and((Bson[])bsonArray));
    }
}

