/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.front.storage.mongo;

import ai.tock.nlp.front.service.storage.ClassifiedSentenceDAO;
import ai.tock.nlp.front.shared.config.ApplicationDefinition;
import ai.tock.nlp.front.shared.config.Classification;
import ai.tock.nlp.front.shared.config.Classification_;
import ai.tock.nlp.front.shared.config.ClassifiedEntity;
import ai.tock.nlp.front.shared.config.ClassifiedEntity_;
import ai.tock.nlp.front.shared.config.ClassifiedSentence;
import ai.tock.nlp.front.shared.config.ClassifiedSentenceStatus;
import ai.tock.nlp.front.shared.config.EntityDefinition;
import ai.tock.nlp.front.shared.config.EntityTypeDefinition;
import ai.tock.nlp.front.shared.config.IntentDefinition;
import ai.tock.nlp.front.shared.config.SearchMark;
import ai.tock.nlp.front.shared.config.SentencesQuery;
import ai.tock.nlp.front.shared.config.SentencesQueryResult;
import ai.tock.nlp.front.storage.mongo.ApplicationDefinitionMongoDAO;
import ai.tock.nlp.front.storage.mongo.ClassifiedSentenceCol_;
import ai.tock.nlp.front.storage.mongo.EntityTypeDefinitionMongoDAO;
import ai.tock.nlp.front.storage.mongo.IntentDefinitionMongoDAO;
import ai.tock.nlp.front.storage.mongo.MongoFrontConfiguration;
import ai.tock.nlp.front.storage.mongo.MongoHelpersKt;
import ai.tock.nlp.front.storage.mongo.ParseRequestLogMongoDAO;
import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LocalesKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.MongosKt;
import ai.tock.shared.PropertiesKt;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import com.mongodb.ReadPreference;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.result.DeleteResult;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.KMongoIterableKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.FindIterablesKt;
import org.litote.kmongo.Id;
import org.litote.kmongo.MongoCollectionsKt;
import org.litote.kmongo.MongoOperator;
import org.litote.kmongo.SetTo;
import org.litote.kmongo.SharedExtensionsKt;
import org.litote.kmongo.SortsKt;
import org.litote.kmongo.UpdatesKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001ZB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J8\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0014\u0010\u0017\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0012\u0018\u00010\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u001e\u0010\u001e\u001a\u00020\u00102\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010 \u001a\u00020\u001dH\u0016J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\"\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0016H\u0016J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\bH\u0002J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00152\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020'0\u00152\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\f\u0010-\u001a\u00020.*\u00020,H\u0002J\u000e\u0010/\u001a\u0004\u0018\u00010.*\u00020,H\u0002J\u000e\u00100\u001a\u0004\u0018\u00010.*\u00020,H\u0002J\u000e\u00101\u001a\u0004\u0018\u00010.*\u00020,H\u0002J\u000e\u00102\u001a\u0004\u0018\u00010.*\u00020,H\u0002J\u000e\u00103\u001a\u0004\u0018\u00010.*\u00020,H\u0002J\u000e\u00104\u001a\u0004\u0018\u00010.*\u00020,H\u0002J\u000e\u00105\u001a\u0004\u0018\u00010.*\u00020,H\u0002J\u000e\u00106\u001a\u0004\u0018\u00010.*\u00020,H\u0002J\u000e\u00107\u001a\u0004\u0018\u00010.*\u00020,H\u0002J\u000e\u00108\u001a\u0004\u0018\u00010.*\u00020,H\u0002J\u000e\u00109\u001a\u0004\u0018\u00010.*\u00020,H\u0002J\u000e\u0010:\u001a\u0004\u0018\u00010.*\u00020,H\u0002J\u000e\u0010;\u001a\u0004\u0018\u00010.*\u00020,H\u0002J\f\u0010<\u001a\u00020.*\u00020,H\u0002J\u000e\u0010=\u001a\u0004\u0018\u00010.*\u00020,H\u0002J\u000e\u0010>\u001a\u0004\u0018\u00010.*\u00020,H\u0002J\u000e\u0010?\u001a\u0004\u0018\u00010.*\u00020,H\u0002J\u0010\u0010@\u001a\u00020.2\u0006\u0010A\u001a\u00020'H\u0002J\u0016\u0010B\u001a\u00020.2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020'0\u0015H\u0002J\u0016\u0010D\u001a\u00020.2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020'0\u0015H\u0002J2\u0010E\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00190\u00122\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00190\u0012H\u0016J$\u0010E\u001a\u00020\u00102\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00190\u0012H\u0016J.\u0010H\u001a\u00020\u00102\u0006\u0010I\u001a\u00020'2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020KH\u0016J4\u0010M\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00190\u00122\u0006\u0010A\u001a\u00020'2\u0006\u0010O\u001a\u00020'H\u0016J&\u0010P\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010A\u001a\u00020'2\u0006\u0010O\u001a\u00020'H\u0016J.\u0010Q\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010A\u001a\u00020'2\u0006\u0010O\u001a\u00020'2\u0006\u0010R\u001a\u00020SH\u0002J\u0015\u0010T\u001a\u00020\u00102\u0006\u0010U\u001a\u00020VH\u0000\u00a2\u0006\u0002\bWJ&\u0010X\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010Y\u001a\u00020'H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006["}, d2={"Lai/tock/nlp/front/storage/mongo/ClassifiedSentenceMongoDAO;", "Lai/tock/nlp/front/service/storage/ClassifiedSentenceDAO;", "<init>", "()V", "logger", "Lmu/KLogger;", "Classification_", "Lai/tock/nlp/front/shared/config/Classification_;", "Lai/tock/nlp/front/storage/mongo/ClassifiedSentenceMongoDAO$ClassifiedSentenceCol;", "col", "Lcom/mongodb/client/MongoCollection;", "getCol", "()Lcom/mongodb/client/MongoCollection;", "col$delegate", "Lkotlin/Lazy;", "updateFormattedSentences", "", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "getSentences", "", "Lai/tock/nlp/front/shared/config/ClassifiedSentence;", "intents", "", "Lai/tock/nlp/front/shared/config/IntentDefinition;", "language", "Ljava/util/Locale;", "status", "Lai/tock/nlp/front/shared/config/ClassifiedSentenceStatus;", "switchSentencesStatus", "sentences", "newStatus", "deleteSentencesByStatus", "deleteSentencesByApplicationId", "save", "sentence", "s", "users", "", "configurations", "search", "Lai/tock/nlp/front/shared/config/SentencesQueryResult;", "query", "Lai/tock/nlp/front/shared/config/SentencesQuery;", "filterApplication", "Lorg/bson/conversions/Bson;", "filterReviewOnly", "filterByUser", "filterByAllButUser", "filterSearchMark", "filterModifiedAfter", "filterModifiedBefore", "filterEntityRoleToExclude", "filterEntityRolesToInclude", "filterEntityType", "filterStatus", "filterConfiguration", "filterIntent", "filterText", "filterOnlyExactMatchText", "filterLanguage", "filterMaxIntentProbability", "filterMinIntentProbability", "subEntityTypeQuery", "entityType", "subEntityRoleQueryToInclude", "roles", "subEntityRoleQueryToExclude", "switchSentencesIntent", "oldIntentId", "newIntentId", "switchSentencesEntity", "allowedNamespace", "oldEntity", "Lai/tock/nlp/front/shared/config/EntityDefinition;", "newEntity", "removeEntityFromSentences", "intentId", "role", "removeSubEntityFromSentences", "removeSubEntitiesFromSentence", "level", "", "updateSentenceState", "stat", "Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$ParseRequestLogStatCol;", "updateSentenceState$tock_nlp_front_storage_mongo", "incrementUnknownStat", "text", "ClassifiedSentenceCol", "tock-nlp-front-storage-mongo"})
@SourceDebugExtension(value={"SMAP\nClassifiedSentenceMongoDAO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassifiedSentenceMongoDAO.kt\nai/tock/nlp/front/storage/mongo/ClassifiedSentenceMongoDAO\n+ 2 KMongoIterable.kt\nkotlin/collections/KMongoIterableKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 MongoCollections.kt\norg/litote/kmongo/MongoCollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 MongoDatabases.kt\norg/litote/kmongo/MongoDatabasesKt\n+ 7 IOCs.kt\nai/tock/shared/IOCsKt\n+ 8 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 9 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n*L\n1#1,685:1\n61#2:686\n1863#3,2:687\n1557#3:691\n1628#3,3:692\n1557#3:696\n1628#3,3:697\n1863#3,2:700\n1863#3:702\n774#3:703\n865#3,2:704\n827#3:706\n855#3,2:707\n1557#3:709\n1628#3,2:710\n774#3:712\n865#3:713\n1755#3,3:714\n866#3:717\n1557#3:718\n1628#3,2:719\n230#3,2:721\n1630#3:723\n827#3:724\n855#3:725\n1755#3,3:726\n856#3:729\n1863#3,2:730\n1630#3:732\n1864#3:733\n1863#3,2:734\n1557#3:736\n1628#3,3:737\n107#4:689\n107#4:690\n1#5:695\n40#6,11:740\n48#7,2:751\n51#8:753\n277#9:754\n*S KotlinDebug\n*F\n+ 1 ClassifiedSentenceMongoDAO.kt\nai/tock/nlp/front/storage/mongo/ClassifiedSentenceMongoDAO\n*L\n238#1:686\n264#1:687,2\n345#1:691\n345#1:692,3\n391#1:696\n391#1:697,3\n519#1:700,2\n543#1:702\n545#1:703\n545#1:704,2\n547#1:706\n547#1:707,2\n548#1:709\n548#1:710,2\n551#1:712\n551#1:713\n551#1:714,3\n551#1:717\n552#1:718\n552#1:719,2\n553#1:721,2\n552#1:723\n560#1:724\n560#1:725\n560#1:726,3\n560#1:729\n562#1:730,2\n548#1:732\n543#1:733\n618#1:734,2\n219#1:736\n219#1:737,3\n294#1:689\n302#1:690\n187#1:740,11\n218#1:751,2\n218#1:753\n218#1:754\n*E\n"})
public final class ClassifiedSentenceMongoDAO
implements ClassifiedSentenceDAO {
    @NotNull
    public static final ClassifiedSentenceMongoDAO INSTANCE = new ClassifiedSentenceMongoDAO();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(ClassifiedSentenceMongoDAO::logger$lambda$0);
    @NotNull
    private static final Classification_<ClassifiedSentenceCol> Classification_ = ClassifiedSentenceCol_.Companion.getClassification();
    @NotNull
    private static final Lazy col$delegate = LazyKt.lazy(ClassifiedSentenceMongoDAO::col_delegate$lambda$6);

    private ClassifiedSentenceMongoDAO() {
    }

    private final MongoCollection<ClassifiedSentenceCol> getCol() {
        Lazy lazy = col$delegate;
        return (MongoCollection)lazy.getValue();
    }

    public void updateFormattedSentences(@NotNull Id<ApplicationDefinition> applicationId) {
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        logger.debug(ClassifiedSentenceMongoDAO::updateFormattedSentences$lambda$7);
        FindIterable findIterable = this.getCol().find(FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), applicationId));
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"find(...)");
        MongoIterable $this$forEach$iv = (MongoIterable)findIterable;
        boolean $i$f$forEach = false;
        $this$forEach$iv.forEach(new Consumer(){

            public final void accept(T it) {
                ClassifiedSentenceCol it2 = (ClassifiedSentenceCol)it;
                boolean bl = false;
                ClassifiedSentenceMongoDAO.access$save(ClassifiedSentenceMongoDAO.INSTANCE, ClassifiedSentenceCol.copy$default(it2, null, ai.tock.shared.StringsKt.normalize((String)it2.getText(), (Locale)it2.getLanguage()), null, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, 524285, null));
            }
        });
        logger.debug(ClassifiedSentenceMongoDAO::updateFormattedSentences$lambda$9);
    }

    @NotNull
    public List<ClassifiedSentence> getSentences(@Nullable Set<? extends Id<IntentDefinition>> intents2, @Nullable Locale language, @Nullable ClassifiedSentenceStatus status) {
        if (intents2 == null && language == null && status == null) {
            throw new IllegalStateException("at least one parameter should be not null".toString());
        }
        Bson[] bsonArray = new Bson[]{intents2 != null ? FiltersKt.in((KProperty)((KProperty)Classification_.getIntentId()), (Iterable)intents2) : null, language != null ? FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLanguage()), (Object)language) : null, status != null ? FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getStatus()), (Object)status) : null};
        MongoIterable mongoIterable = MongoCollectionsKt.find(this.getCol(), (Bson[])bsonArray).map(ClassifiedSentenceMongoDAO::getSentences$lambda$10);
        Intrinsics.checkNotNullExpressionValue((Object)mongoIterable, (String)"map(...)");
        return KMongoIterableKt.toList((MongoIterable)mongoIterable);
    }

    public void switchSentencesStatus(@NotNull List<ClassifiedSentence> sentences, @NotNull ClassifiedSentenceStatus newStatus) {
        Intrinsics.checkNotNullParameter(sentences, (String)"sentences");
        Intrinsics.checkNotNullParameter((Object)newStatus, (String)"newStatus");
        Iterable $this$forEach$iv = sentences;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassifiedSentence it = (ClassifiedSentence)element$iv;
            boolean bl = false;
            INSTANCE.save(ClassifiedSentence.copy$default((ClassifiedSentence)it, null, null, null, null, null, (ClassifiedSentenceStatus)newStatus, null, null, null, null, (long)0L, (long)0L, (boolean)false, null, null, null, null, (int)131039, null));
        }
    }

    public void deleteSentencesByStatus(@NotNull ClassifiedSentenceStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        this.getCol().deleteMany(FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getStatus()), (Object)status));
    }

    public void deleteSentencesByApplicationId(@NotNull Id<ApplicationDefinition> applicationId) {
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        this.getCol().deleteMany(FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), applicationId));
    }

    public void save(@NotNull ClassifiedSentence sentence) {
        Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
        this.save(new ClassifiedSentenceCol(sentence));
    }

    private final void save(ClassifiedSentenceCol s) {
        MongoCollection<ClassifiedSentenceCol> mongoCollection = this.getCol();
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getText()), (Object)MongoHelpersKt.textKey(s.getText())), FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLanguage()), (Object)s.getLanguage()), FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), s.getApplicationId())};
        Bson bson = FiltersKt.and((Bson[])bsonArray);
        ReplaceOptions replaceOptions = new ReplaceOptions().upsert(true);
        Intrinsics.checkNotNullExpressionValue((Object)replaceOptions, (String)"upsert(...)");
        MongoCollectionsKt.replaceOneWithFilter(mongoCollection, (Bson)bson, (Object)s, (ReplaceOptions)replaceOptions);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> users(@NotNull Id<ApplicationDefinition> applicationId) {
        void filter$iv;
        void field$iv;
        void $this$distinct$iv;
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        MongoCollection<ClassifiedSentenceCol> mongoCollection = this.getCol();
        KProperty1<ClassifiedSentenceCol, String> kProperty1 = ClassifiedSentenceCol_.Companion.getClassifier();
        Bson bson = new Bson[2];
        bson[0] = FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), applicationId);
        Object[] objectArray = new ClassifiedSentenceStatus[]{ClassifiedSentenceStatus.validated, ClassifiedSentenceStatus.model};
        bson[1] = FiltersKt.in((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getStatus()), (Iterable)CollectionsKt.listOf((Object[])objectArray));
        bson = FiltersKt.and((Bson[])bson);
        boolean $i$f$distinct = false;
        DistinctIterable distinctIterable = $this$distinct$iv.distinct(org.litote.kmongo.PropertiesKt.path((KProperty)((KProperty)field$iv)), (Bson)filter$iv, String.class);
        Intrinsics.checkNotNullExpressionValue((Object)distinctIterable, (String)"distinct(...)");
        return KMongoIterableKt.filterNotNull((MongoIterable)((MongoIterable)distinctIterable));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> configurations(@NotNull Id<ApplicationDefinition> applicationId) {
        void filter$iv;
        void field$iv;
        void $this$distinct$iv;
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        MongoCollection<ClassifiedSentenceCol> mongoCollection = this.getCol();
        KProperty1<ClassifiedSentenceCol, String> kProperty1 = ClassifiedSentenceCol_.Companion.getConfiguration();
        Bson bson = new Bson[]{FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), applicationId)};
        bson = FiltersKt.and((Bson[])bson);
        boolean $i$f$distinct = false;
        DistinctIterable distinctIterable = $this$distinct$iv.distinct(org.litote.kmongo.PropertiesKt.path((KProperty)((KProperty)field$iv)), (Bson)filter$iv, String.class);
        Intrinsics.checkNotNullExpressionValue((Object)distinctIterable, (String)"distinct(...)");
        return KMongoIterableKt.filterNotNull((MongoIterable)((MongoIterable)distinctIterable));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public SentencesQueryResult search(@NotNull SentencesQuery query2) {
        long count;
        block36: {
            Integer n;
            block41: {
                FindIterable $this$search_u24lambda_u2420_u24lambda_u2418;
                block40: {
                    FindIterable findIterable;
                    FindIterable findIterable2;
                    SentencesQuery $this$search_u24lambda_u2420;
                    block38: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        KProperty[] kPropertyArray;
                        FindIterable $this$search_u24lambda_u2420_u24lambda_u2415;
                        block37: {
                            Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
                            $this$search_u24lambda_u2420 = query2;
                            boolean bl = false;
                            Bson[] bsonArray = new Bson[]{INSTANCE.filterApplication($this$search_u24lambda_u2420), INSTANCE.filterLanguage($this$search_u24lambda_u2420), INSTANCE.filterText($this$search_u24lambda_u2420), INSTANCE.filterIntent($this$search_u24lambda_u2420), INSTANCE.filterStatus($this$search_u24lambda_u2420), INSTANCE.filterEntityType($this$search_u24lambda_u2420), INSTANCE.filterEntityRolesToInclude($this$search_u24lambda_u2420), INSTANCE.filterEntityRoleToExclude($this$search_u24lambda_u2420), INSTANCE.filterSearchMark($this$search_u24lambda_u2420), INSTANCE.filterModifiedAfter($this$search_u24lambda_u2420), INSTANCE.filterModifiedBefore($this$search_u24lambda_u2420), INSTANCE.filterReviewOnly($this$search_u24lambda_u2420), INSTANCE.filterByUser($this$search_u24lambda_u2420), INSTANCE.filterByAllButUser($this$search_u24lambda_u2420), INSTANCE.filterMaxIntentProbability($this$search_u24lambda_u2420), INSTANCE.filterMinIntentProbability($this$search_u24lambda_u2420), INSTANCE.filterConfiguration($this$search_u24lambda_u2420)};
                            Bson filterBase = FiltersKt.and((Bson[])bsonArray);
                            logger.debug(() -> ClassifiedSentenceMongoDAO.search$lambda$20$lambda$12(filterBase));
                            MongoCollection c2 = $this$search_u24lambda_u2420.getOnlyExactMatch() ? INSTANCE.getCol() : INSTANCE.getCol().withReadPreference(ReadPreference.secondaryPreferred());
                            count = c2.countDocuments(filterBase);
                            logger.debug(() -> ClassifiedSentenceMongoDAO.search$lambda$20$lambda$13(count));
                            if (count <= $this$search_u24lambda_u2420.getStart()) break block36;
                            $this$search_u24lambda_u2420_u24lambda_u2415 = c2.find(filterBase);
                            boolean bl2 = false;
                            if (!query2.getSort().isEmpty()) break block37;
                            Intrinsics.checkNotNull((Object)$this$search_u24lambda_u2420_u24lambda_u2415);
                            kPropertyArray = new KProperty[]{ClassifiedSentenceCol_.Companion.getUpdateDate()};
                            findIterable2 = FindIterablesKt.descendingSort((FindIterable)$this$search_u24lambda_u2420_u24lambda_u2415, (KProperty[])kPropertyArray);
                            break block38;
                        }
                        kPropertyArray = (KProperty[])query2.getSort();
                        FindIterable findIterable3 = $this$search_u24lambda_u2420_u24lambda_u2415;
                        boolean $i$f$map = false;
                        void var13_14 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            Object object;
                            void it;
                            Pair pair = (Pair)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            switch ((String)it.getFirst()) {
                                case "text": {
                                    object = ClassifiedSentenceCol_.Companion.getText();
                                    break;
                                }
                                case "currentIntent": {
                                    object = (KProperty1)Classification_.getIntentId();
                                    break;
                                }
                                case "intentProbability": {
                                    object = ClassifiedSentenceCol_.Companion.getLastIntentProbability();
                                    break;
                                }
                                case "entitiesProbability": {
                                    object = ClassifiedSentenceCol_.Companion.getLastEntityProbability();
                                    break;
                                }
                                case "lastUpdate": {
                                    object = ClassifiedSentenceCol_.Companion.getUpdateDate();
                                    break;
                                }
                                case "lastUsage": {
                                    object = ClassifiedSentenceCol_.Companion.getLastUsage();
                                    break;
                                }
                                case "usageCount": {
                                    object = ClassifiedSentenceCol_.Companion.getUsageCount();
                                    break;
                                }
                                case "unknownCount": {
                                    object = ClassifiedSentenceCol_.Companion.getUnknownCount();
                                    break;
                                }
                                default: {
                                    object = ClassifiedSentenceCol_.Companion.getUpdateDate();
                                }
                            }
                            collection.add(TuplesKt.to(object, (Object)it.getSecond()));
                        }
                        findIterable2 = findIterable3.sort(SortsKt.orderBy((Map)MapsKt.toMap((Iterable)((List)destination$iv$iv))));
                    }
                    FindIterable $this$search_u24lambda_u2420_u24lambda_u2416 = findIterable2;
                    boolean bl = false;
                    if (!((Collection)query2.getSort()).isEmpty()) {
                        Intrinsics.checkNotNull((Object)$this$search_u24lambda_u2420_u24lambda_u2416);
                        Collation.Builder builder = Collation.builder().caseLevel(Boolean.valueOf(false));
                        Locale locale = query2.getLanguage();
                        if (locale == null) {
                            locale = LocalesKt.getDefaultLocale();
                        }
                        Collation collation = builder.locale(locale.toLanguageTag()).build();
                        Intrinsics.checkNotNullExpressionValue((Object)collation, (String)"build(...)");
                        findIterable = MongosKt.safeCollation((FindIterable)$this$search_u24lambda_u2420_u24lambda_u2416, (Collation)collation);
                    } else {
                        findIterable = $this$search_u24lambda_u2420_u24lambda_u2416;
                    }
                    $this$search_u24lambda_u2420_u24lambda_u2418 = findIterable.skip((int)$this$search_u24lambda_u2420.getStart());
                    boolean bl3 = false;
                    n = $this$search_u24lambda_u2420.getSize();
                    if (n == null) break block40;
                    int it = ((Number)n).intValue();
                    boolean bl4 = false;
                    FindIterable findIterable4 = $this$search_u24lambda_u2420_u24lambda_u2418.limit(it);
                    n = findIterable4;
                    if (findIterable4 != null) break block41;
                }
                n = $this$search_u24lambda_u2420_u24lambda_u2418;
            }
            Integer list = n;
            MongoIterable mongoIterable = list.map(ClassifiedSentenceMongoDAO::search$lambda$20$lambda$19);
            Intrinsics.checkNotNullExpressionValue((Object)mongoIterable, (String)"map(...)");
            return new SentencesQueryResult(count, KMongoIterableKt.toList((MongoIterable)mongoIterable));
        }
        return new SentencesQueryResult(count, CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    private final Bson filterApplication(SentencesQuery $this$filterApplication) {
        Bson bson;
        if ($this$filterApplication.getWholeNamespace()) {
            Iterable iterable;
            KProperty kProperty = (KProperty)ClassifiedSentenceCol_.Companion.getApplicationId();
            Object object = ApplicationDefinitionMongoDAO.INSTANCE.getApplicationById((Id<ApplicationDefinition>)$this$filterApplication.getApplicationId());
            if (object != null && (object = object.getNamespace()) != null) {
                void $this$mapTo$iv$iv;
                void n;
                Object object2 = object;
                KProperty kProperty2 = kProperty;
                boolean bl = false;
                Iterable $this$map$iv = ApplicationDefinitionMongoDAO.INSTANCE.getApplicationsByNamespace((String)n);
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ApplicationDefinition applicationDefinition = (ApplicationDefinition)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.get_id());
                }
                kProperty = kProperty2;
                iterable = (List)destination$iv$iv;
            } else {
                iterable = CollectionsKt.emptyList();
            }
            bson = FiltersKt.in((KProperty)kProperty, (Iterable)iterable);
        } else {
            bson = FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), (Object)$this$filterApplication.getApplicationId());
        }
        return bson;
    }

    private final Bson filterReviewOnly(SentencesQuery $this$filterReviewOnly) {
        return $this$filterReviewOnly.getOnlyToReview() ? FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getForReview()), (Object)true) : null;
    }

    private final Bson filterByUser(SentencesQuery $this$filterByUser) {
        return $this$filterByUser.getUser() != null ? FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getClassifier()), (Object)$this$filterByUser.getUser()) : null;
    }

    private final Bson filterByAllButUser(SentencesQuery $this$filterByAllButUser) {
        return $this$filterByAllButUser.getAllButUser() != null ? FiltersKt.ne((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getClassifier()), (Object)$this$filterByAllButUser.getAllButUser()) : null;
    }

    private final Bson filterSearchMark(SentencesQuery $this$filterSearchMark) {
        Bson bson;
        if ($this$filterSearchMark.getSearchMark() == null) {
            bson = null;
        } else {
            SearchMark searchMark = $this$filterSearchMark.getSearchMark();
            bson = FiltersKt.lte((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getUpdateDate()), (Object)(searchMark != null ? searchMark.getDate() : null));
        }
        return bson;
    }

    private final Bson filterModifiedAfter(SentencesQuery $this$filterModifiedAfter) {
        Bson bson;
        if ($this$filterModifiedAfter.getModifiedAfter() == null) {
            bson = null;
        } else {
            ZonedDateTime zonedDateTime = $this$filterModifiedAfter.getModifiedAfter();
            bson = FiltersKt.gt((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getUpdateDate()), (Object)(zonedDateTime != null ? zonedDateTime.toInstant() : null));
        }
        return bson;
    }

    private final Bson filterModifiedBefore(SentencesQuery $this$filterModifiedBefore) {
        Bson bson;
        if ($this$filterModifiedBefore.getModifiedBefore() == null) {
            bson = null;
        } else {
            ZonedDateTime zonedDateTime = $this$filterModifiedBefore.getModifiedBefore();
            bson = FiltersKt.lt((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getUpdateDate()), (Object)(zonedDateTime != null ? zonedDateTime.toInstant() : null));
        }
        return bson;
    }

    private final Bson filterEntityRoleToExclude(SentencesQuery $this$filterEntityRoleToExclude) {
        return $this$filterEntityRoleToExclude.getEntityRolesToExclude().isEmpty() ? null : ($this$filterEntityRoleToExclude.getSearchSubEntities() ? this.subEntityRoleQueryToExclude($this$filterEntityRoleToExclude.getEntityRolesToExclude()) : FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getRole()), (Iterable)$this$filterEntityRoleToExclude.getEntityRolesToExclude()));
    }

    private final Bson filterEntityRolesToInclude(SentencesQuery $this$filterEntityRolesToInclude) {
        return $this$filterEntityRolesToInclude.getEntityRolesToInclude().isEmpty() ? null : ($this$filterEntityRolesToInclude.getSearchSubEntities() ? this.subEntityRoleQueryToInclude($this$filterEntityRolesToInclude.getEntityRolesToInclude()) : FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getRole()), (Iterable)$this$filterEntityRolesToInclude.getEntityRolesToInclude()));
    }

    private final Bson filterEntityType(SentencesQuery $this$filterEntityType) {
        Bson bson;
        if ($this$filterEntityType.getEntityType() == null) {
            bson = null;
        } else if ($this$filterEntityType.getSearchSubEntities()) {
            String string = $this$filterEntityType.getEntityType();
            Intrinsics.checkNotNull((Object)string);
            bson = this.subEntityTypeQuery(string);
        } else {
            bson = FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getType()), (Object)$this$filterEntityType.getEntityType());
        }
        return bson;
    }

    private final Bson filterStatus(SentencesQuery $this$filterStatus) {
        return !((Collection)$this$filterStatus.getStatus()).isEmpty() ? FiltersKt.in((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getStatus()), (Iterable)$this$filterStatus.getStatus()) : ($this$filterStatus.getNotStatus() != null ? FiltersKt.ne((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getStatus()), (Object)$this$filterStatus.getNotStatus()) : null);
    }

    private final Bson filterConfiguration(SentencesQuery $this$filterConfiguration) {
        return $this$filterConfiguration.getConfiguration() == null ? null : FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getConfiguration()), (Object)$this$filterConfiguration.getConfiguration());
    }

    private final Bson filterIntent(SentencesQuery $this$filterIntent) {
        return $this$filterIntent.getIntentId() == null ? null : FiltersKt.eq((KProperty)((KProperty)Classification_.getIntentId()), (Object)$this$filterIntent.getIntentId());
    }

    private final Bson filterText(SentencesQuery $this$filterText) {
        Bson bson;
        CharSequence charSequence = $this$filterText.getSearch();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            bson = null;
        } else if ($this$filterText.getOnlyExactMatch()) {
            bson = this.filterOnlyExactMatchText($this$filterText);
        } else {
            KProperty kProperty = (KProperty)ClassifiedSentenceCol_.Companion.getFullText();
            String string = $this$filterText.getSearch();
            Intrinsics.checkNotNull((Object)string);
            bson = FiltersKt.regex((KProperty)kProperty, (String)((Object)StringsKt.trim((CharSequence)string)).toString(), (String)"i");
        }
        return bson;
    }

    private final Bson filterOnlyExactMatchText(SentencesQuery $this$filterOnlyExactMatchText) {
        Bson bson;
        if ($this$filterOnlyExactMatchText.getNormalizeText()) {
            String string;
            KProperty kProperty = (KProperty)ClassifiedSentenceCol_.Companion.getNormalizedText();
            String string2 = $this$filterOnlyExactMatchText.getSearch();
            if (string2 != null) {
                Locale locale = $this$filterOnlyExactMatchText.getLanguage();
                if (locale == null) {
                    locale = LocalesKt.getDefaultLocale();
                }
                string = ai.tock.shared.StringsKt.normalize((String)string2, (Locale)locale);
            } else {
                string = null;
            }
            bson = FiltersKt.eq((KProperty)kProperty, string);
        } else {
            bson = FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getText()), (Object)$this$filterOnlyExactMatchText.getSearch());
        }
        return bson;
    }

    private final Bson filterLanguage(SentencesQuery $this$filterLanguage) {
        return $this$filterLanguage.getLanguage() == null ? null : FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLanguage()), (Object)$this$filterLanguage.getLanguage());
    }

    private final Bson filterMaxIntentProbability(SentencesQuery $this$filterMaxIntentProbability) {
        return $this$filterMaxIntentProbability.getMaxIntentProbability() < 1.0f ? FiltersKt.lt((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLastIntentProbability()), (Object)$this$filterMaxIntentProbability.getMaxIntentProbability()) : null;
    }

    private final Bson filterMinIntentProbability(SentencesQuery $this$filterMinIntentProbability) {
        return $this$filterMinIntentProbability.getMinIntentProbability() > 0.0f ? FiltersKt.gt((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLastIntentProbability()), (Object)$this$filterMinIntentProbability.getMinIntentProbability()) : null;
    }

    private final Bson subEntityTypeQuery(String entityType) {
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getType()), (Object)entityType), FiltersKt.eq((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getType()), (Object)entityType)};
        return FiltersKt.or((Bson[])bsonArray);
    }

    private final Bson subEntityRoleQueryToInclude(List<String> roles) {
        Bson[] bsonArray = new Bson[]{FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.in((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles)};
        return FiltersKt.or((Bson[])bsonArray);
    }

    private final Bson subEntityRoleQueryToExclude(List<String> roles) {
        Bson[] bsonArray = new Bson[]{FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles), FiltersKt.nin((KProperty)((KProperty)Classification_.getEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getSubEntities().getRole()), (Iterable)roles)};
        return FiltersKt.and((Bson[])bsonArray);
    }

    public void switchSentencesIntent(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Id<IntentDefinition> oldIntentId, @NotNull Id<IntentDefinition> newIntentId) {
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter(oldIntentId, (String)"oldIntentId");
        Intrinsics.checkNotNullParameter(newIntentId, (String)"newIntentId");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), applicationId), FiltersKt.eq((KProperty)((KProperty)Classification_.getIntentId()), oldIntentId)};
        Bson bson = FiltersKt.and((Bson[])bsonArray);
        bsonArray = new SetTo[]{UpdatesKt.setTo((KProperty)((KProperty)Classification_.getIntentId()), newIntentId), UpdatesKt.setTo((KProperty)((KProperty)Classification_.getEntities()), (Object)CollectionsKt.emptyList()), UpdatesKt.setTo((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getStatus()), (Object)ClassifiedSentenceStatus.inbox)};
        MongoCollectionsKt.updateMany$default(this.getCol(), (Bson)bson, (SetTo[])bsonArray, null, (int)4, null);
    }

    public void switchSentencesIntent(@NotNull List<ClassifiedSentence> sentences, @NotNull Id<IntentDefinition> newIntentId) {
        Intrinsics.checkNotNullParameter(sentences, (String)"sentences");
        Intrinsics.checkNotNullParameter(newIntentId, (String)"newIntentId");
        Iterable $this$forEach$iv = sentences;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassifiedSentence it = (ClassifiedSentence)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)newIntentId.toString(), (Object)"tock:unknown") || Intrinsics.areEqual((Object)newIntentId.toString(), (Object)"tock:ragexcluded")) {
                INSTANCE.save(ClassifiedSentence.copy$default((ClassifiedSentence)it, null, null, null, null, null, null, (Classification)it.getClassification().copy(newIntentId, CollectionsKt.emptyList()), null, null, null, (long)0L, (long)0L, (boolean)false, null, null, null, null, (int)131007, null));
                continue;
            }
            INSTANCE.save(ClassifiedSentence.copy$default((ClassifiedSentence)it, null, null, null, null, null, null, (Classification)Classification.copy$default((Classification)it.getClassification(), newIntentId, null, (int)2, null), null, null, null, (long)0L, (long)0L, (boolean)false, null, null, null, null, (int)131007, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void switchSentencesEntity(@NotNull String allowedNamespace, @NotNull List<ClassifiedSentence> sentences, @NotNull EntityDefinition oldEntity, @NotNull EntityDefinition newEntity) {
        Intrinsics.checkNotNullParameter((Object)allowedNamespace, (String)"allowedNamespace");
        Intrinsics.checkNotNullParameter(sentences, (String)"sentences");
        Intrinsics.checkNotNullParameter((Object)oldEntity, (String)"oldEntity");
        Intrinsics.checkNotNullParameter((Object)newEntity, (String)"newEntity");
        EntityTypeDefinition entityTypeDefinition = EntityTypeDefinitionMongoDAO.INSTANCE.getEntityTypeByName(oldEntity.getEntityTypeName());
        if (entityTypeDefinition == null) {
            throw new IllegalStateException(("no entity type found: " + oldEntity).toString());
        }
        EntityTypeDefinition oldEntityType = entityTypeDefinition;
        EntityTypeDefinition entityTypeDefinition2 = EntityTypeDefinitionMongoDAO.INSTANCE.getEntityTypeByName(newEntity.getEntityTypeName());
        if (entityTypeDefinition2 == null) {
            throw new IllegalStateException(("no entity type found: " + newEntity).toString());
        }
        EntityTypeDefinition newEntityType = entityTypeDefinition2;
        Set newSubEntityDefinitions = new LinkedHashSet();
        Iterable $this$forEach$iv = sentences;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterNotTo$iv$iv;
            void $this$filterTo$iv$iv;
            ClassifiedSentence s = (ClassifiedSentence)element$iv;
            boolean bl = false;
            Iterable $this$filter$iv = s.getClassification().getEntities();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ClassifiedEntity e = (ClassifiedEntity)element$iv$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)e.getRole(), (Object)oldEntity.getRole()) && Intrinsics.areEqual((Object)e.getType(), (Object)oldEntity.getEntityTypeName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List selectedEntities = (List)destination$iv$iv;
            Iterable $this$filterNot$iv = s.getClassification().getEntities();
            boolean $i$f$filterNot = false;
            destination$iv$iv = $this$filterNot$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                ClassifiedEntity e = (ClassifiedEntity)element$iv$iv;
                boolean bl3 = false;
                if (Intrinsics.areEqual((Object)e.getRole(), (Object)oldEntity.getRole()) && Intrinsics.areEqual((Object)e.getType(), (Object)oldEntity.getEntityTypeName())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filterNot$iv = selectedEntities;
            Collection collection = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterNotTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                List list;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                EntityDefinition it;
                Iterable $this$any$iv;
                ClassifiedEntity subEntity;
                void $this$filterTo$iv$iv2;
                Iterable $this$filter$iv2;
                ClassifiedEntity e = (ClassifiedEntity)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl4 = false;
                Iterable iterable2 = e.getSubEntities();
                boolean $i$f$filter2 = false;
                void var29_37 = $this$filter$iv2;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    boolean bl5;
                    block21: {
                        subEntity = (ClassifiedEntity)element$iv$iv;
                        boolean bl6 = false;
                        $this$any$iv = newEntityType.getSubEntities();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl5 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                it = (EntityDefinition)element$iv2;
                                boolean bl7 = false;
                                if (!Intrinsics.areEqual((Object)it.getRole(), (Object)subEntity.getRole())) continue;
                                bl5 = true;
                                break block21;
                            }
                            bl5 = false;
                        }
                    }
                    if (!bl5) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                $this$filter$iv2 = (List)destination$iv$iv3;
                boolean $i$f$map22 = false;
                $this$filterTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    Object element$iv32;
                    void $i$f$any;
                    Collection collection3;
                    block22: {
                        void $this$first$iv;
                        void sub;
                        subEntity = (ClassifiedEntity)item$iv$iv2;
                        collection3 = destination$iv$iv3;
                        boolean bl8 = false;
                        $this$any$iv = newEntityType.getSubEntities();
                        $i$f$any = sub;
                        boolean $i$f$first = false;
                        for (Object element$iv32 : $this$first$iv) {
                            EntityDefinition it2 = (EntityDefinition)element$iv32;
                            boolean bl9 = false;
                            if (!Intrinsics.areEqual((Object)it2.getRole(), (Object)sub.getRole())) continue;
                            break block22;
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    collection3.add(ClassifiedEntity.copy$default((ClassifiedEntity)$i$f$any, (String)((EntityDefinition)element$iv32).getEntityTypeName(), null, (int)0, (int)0, null, (int)30, null));
                }
                List subEntitiesWithExistingRole = (List)destination$iv$iv3;
                if (Intrinsics.areEqual((Object)ai.tock.shared.StringsKt.namespace((String)newEntityType.getName()), (Object)allowedNamespace)) {
                    void $this$filterNotTo$iv$iv2;
                    List $this$filterNot$iv2;
                    Iterable $i$f$map22 = e.getSubEntities();
                    boolean $i$f$filterNot2 = false;
                    destination$iv$iv3 = $this$filterNot$iv2;
                    Collection destination$iv$iv4 = new ArrayList();
                    boolean $i$f$filterNotTo2 = false;
                    for (Object element$iv$iv : $this$filterNotTo$iv$iv2) {
                        boolean bl10;
                        block23: {
                            ClassifiedEntity subEntity2 = (ClassifiedEntity)element$iv$iv;
                            boolean bl11 = false;
                            Iterable $this$any$iv2 = newEntityType.getSubEntities();
                            boolean $i$f$any = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl10 = false;
                            } else {
                                for (Object element$iv32 : $this$any$iv2) {
                                    EntityDefinition it3 = (EntityDefinition)element$iv32;
                                    boolean bl12 = false;
                                    if (!Intrinsics.areEqual((Object)it3.getRole(), (Object)subEntity2.getRole())) continue;
                                    bl10 = true;
                                    break block23;
                                }
                                bl10 = false;
                            }
                        }
                        if (bl10) continue;
                        destination$iv$iv4.add(element$iv$iv);
                    }
                    List $this$switchSentencesEntity_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435 = $this$filterNot$iv2 = (List)destination$iv$iv4;
                    boolean bl13 = false;
                    Iterable $this$forEach$iv2 = $this$switchSentencesEntity_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv4 : $this$forEach$iv2) {
                        EntityDefinition entityDefinition;
                        Iterator iterator;
                        block24: {
                            ClassifiedEntity sub = (ClassifiedEntity)element$iv4;
                            boolean bl14 = false;
                            Iterable $this$any$iv2 = oldEntityType.getSubEntities();
                            for (Iterator iterator2 : $this$any$iv2) {
                                it = (EntityDefinition)iterator2;
                                boolean bl15 = false;
                                if (!Intrinsics.areEqual((Object)sub.getRole(), (Object)it.getRole())) continue;
                                iterator = iterator2;
                                break block24;
                            }
                            iterator = null;
                        }
                        if ((entityDefinition = (EntityDefinition)iterator) == null) continue;
                        EntityDefinition newSubEntity = entityDefinition;
                        boolean bl16 = false;
                        newSubEntityDefinitions.add(newSubEntity);
                    }
                    list = $this$filterNot$iv2;
                } else {
                    list = CollectionsKt.emptyList();
                }
                List subEntitiesWithNotExistingRole = list;
                List newSubEntities = CollectionsKt.plus((Collection)subEntitiesWithExistingRole, (Iterable)subEntitiesWithNotExistingRole);
                collection2.add(ClassifiedEntity.copy$default((ClassifiedEntity)e, (String)newEntity.getEntityTypeName(), (String)newEntity.getRole(), (int)0, (int)0, (List)CollectionsKt.sorted((Iterable)newSubEntities), (int)12, null));
            }
            List newEntities = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv2));
            INSTANCE.save(ClassifiedSentence.copy$default((ClassifiedSentence)s, null, null, null, null, null, null, (Classification)Classification.copy$default((Classification)s.getClassification(), null, (List)CollectionsKt.sorted((Iterable)newEntities), (int)1, null), null, null, null, (long)0L, (long)0L, (boolean)false, null, null, null, null, (int)131007, null));
        }
        if (!((Collection)newSubEntityDefinitions).isEmpty()) {
            EntityTypeDefinitionMongoDAO.INSTANCE.save(EntityTypeDefinition.copy$default((EntityTypeDefinition)newEntityType, null, null, (List)CollectionsKt.plus((Collection)newEntityType.getSubEntities(), (Iterable)newSubEntityDefinitions), (boolean)false, (boolean)false, null, (int)59, null));
        }
    }

    public void removeEntityFromSentences(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Id<IntentDefinition> intentId, @NotNull String entityType, @NotNull String role) {
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter(intentId, (String)"intentId");
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), applicationId), FiltersKt.eq((KProperty)((KProperty)Classification_.getIntentId()), intentId)};
        this.getCol().updateMany(FiltersKt.and((Bson[])bsonArray), UpdatesKt.pullByFilter((KProperty)((KProperty)Classification_.getEntities()), (Bson)FiltersKt.eq((KProperty)((KProperty)ClassifiedEntity_.Companion.getRole()), (Object)role)));
    }

    public void removeSubEntityFromSentences(@NotNull Id<ApplicationDefinition> applicationId, @NotNull String entityType, @NotNull String role) {
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Iterable $this$forEach$iv = (Iterable)new IntRange(1, 10);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            INSTANCE.removeSubEntitiesFromSentence(applicationId, entityType, role, it);
        }
    }

    private final void removeSubEntitiesFromSentence(Id<ApplicationDefinition> applicationId, String entityType, String role, int level) {
        String baseFilter = "classification.entities" + CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(2, level)), (CharSequence)"", null, null, (int)0, null, ClassifiedSentenceMongoDAO::removeSubEntitiesFromSentence$lambda$39, (int)30, null);
        String filter = "{\n            'applicationId':" + SharedExtensionsKt.getJson(applicationId) + ",\n            '" + baseFilter + "':{\n                " + MongoOperator.elemMatch + " :{\n                    type:" + SharedExtensionsKt.getJson((Object)entityType) + ",\n                    subEntities:{\n                        " + MongoOperator.elemMatch + ":{\n                            'role':" + SharedExtensionsKt.getJson((Object)role) + "\n                        }\n                    }\n                }\n            }\n        }";
        String update = "{\n                    " + MongoOperator.pull + ":{\n                        '" + StringsKt.replace$default((String)baseFilter, (String)".subEntities", (String)".$[].subEntities", (boolean)false, (int)4, null) + ".$.subEntities':{\n                            'role':" + SharedExtensionsKt.getJson((Object)role) + "\n                            }\n                        }\n                    }";
        logger.debug(() -> ClassifiedSentenceMongoDAO.removeSubEntitiesFromSentence$lambda$40(filter, update));
        MongoCollectionsKt.updateMany$default(this.getCol(), (String)filter, (String)update, null, (int)4, null);
    }

    public final void updateSentenceState$tock_nlp_front_storage_mongo(@NotNull ParseRequestLogMongoDAO.ParseRequestLogStatCol stat) {
        Bson bson;
        Bson bson2;
        Bson bson3;
        double it;
        MongoCollection<ClassifiedSentenceCol> mongoCollection;
        Bson bson4;
        Object[] objectArray;
        int n;
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        MongoCollection<ClassifiedSentenceCol> mongoCollection2 = this.getCol();
        Object[] objectArray2 = new Bson[]{FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLanguage()), (Object)stat.getLanguage()), FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), stat.getApplicationId()), FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getText()), (Object)stat.getText())};
        Bson bson5 = FiltersKt.and((Bson[])objectArray2);
        Object[] objectArray3 = objectArray2 = new Bson[4];
        int n2 = 0;
        Double d = stat.getIntentProbability();
        if (d != null) {
            double d2 = ((Number)d).doubleValue();
            n = n2;
            objectArray = objectArray3;
            bson4 = bson5;
            mongoCollection = mongoCollection2;
            boolean bl = false;
            bson3 = UpdatesKt.setValue((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLastIntentProbability()), (Object)it);
            mongoCollection2 = mongoCollection;
            bson5 = bson4;
            objectArray3 = objectArray;
            n2 = n;
            bson2 = bson3;
        } else {
            bson2 = null;
        }
        objectArray3[n2] = bson2;
        Object[] objectArray4 = objectArray2;
        int n3 = 1;
        Double d3 = stat.getEntitiesProbability();
        if (d3 != null) {
            it = ((Number)d3).doubleValue();
            n = n3;
            objectArray = objectArray4;
            bson4 = bson5;
            mongoCollection = mongoCollection2;
            boolean bl = false;
            bson3 = UpdatesKt.setValue((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLastEntityProbability()), (Object)it);
            mongoCollection2 = mongoCollection;
            bson5 = bson4;
            objectArray4 = objectArray;
            n3 = n;
            bson = bson3;
        } else {
            bson = null;
        }
        objectArray4[n3] = bson;
        objectArray2[2] = UpdatesKt.setValue((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLastUsage()), (Object)stat.getLastUsage());
        objectArray2[3] = UpdatesKt.setValue((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getUsageCount()), (Object)stat.getCount());
        mongoCollection2.updateOne(bson5, UpdatesKt.combine((List)CollectionsKt.listOfNotNull((Object[])objectArray2)));
    }

    public void incrementUnknownStat(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language, @NotNull String text) {
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getLanguage()), (Object)language), FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getApplicationId()), applicationId), FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getText()), (Object)text)};
        this.getCol().updateOne(FiltersKt.and((Bson[])bsonArray), UpdatesKt.inc((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getUnknownCount()), (Number)1));
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object col_delegate$lambda$6$lambda$1(long $ttlDays) {
        return "add classified sentence ttl index for " + $ttlDays + " days";
    }

    private static final Object col_delegate$lambda$6$lambda$2(long $ttlDays, List $ttlIntents) {
        return "add classified sentence periodic crawler for " + $ttlDays + " days and intents " + $ttlIntents;
    }

    private static final Object col_delegate$lambda$6$lambda$5$lambda$4(DeleteResult $deleted, List $ttlIntents, List $intentIds) {
        return "delete " + $deleted.getDeletedCount() + " old classified sentences for intents " + $ttlIntents + " of ids " + $intentIds;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit col_delegate$lambda$6$lambda$5(List $ttlIntents, MongoCollection $c, long $ttlDays) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = IntentDefinitionMongoDAO.INSTANCE.getIntentsByNames($ttlIntents);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IntentDefinition intentDefinition = (IntentDefinition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.get_id());
        }
        List intentIds = (List)destination$iv$iv;
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getStatus()), (Object)ClassifiedSentenceStatus.inbox), FiltersKt.in((KProperty)((KProperty)Classification_.getIntentId()), (Iterable)intentIds), FiltersKt.lt((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getUpdateDate()), (Object)Instant.now().minus($ttlDays, ChronoUnit.DAYS))};
        DeleteResult deleted = $c.deleteMany(FiltersKt.and((Bson[])bsonArray));
        logger.debug(() -> ClassifiedSentenceMongoDAO.col_delegate$lambda$6$lambda$5$lambda$4(deleted, $ttlIntents, intentIds));
        return Unit.INSTANCE;
    }

    private static final MongoCollection col_delegate$lambda$6() {
        KProperty[] $this$getCollection$iv;
        MongoDatabase mongoDatabase = MongoFrontConfiguration.INSTANCE.getDatabase();
        String collectionName$iv = "classified_sentence";
        boolean $i$f$getCollection = false;
        KProperty[] $this$getCollectionOfName$iv$iv = $this$getCollection$iv;
        boolean $i$f$getCollectionOfName = false;
        MongoCollection mongoCollection = $this$getCollectionOfName$iv$iv.getCollection(collectionName$iv, ClassifiedSentenceCol.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        MongoCollection c2 = mongoCollection;
        try {
            String string;
            $this$getCollection$iv = new KProperty[]{ClassifiedSentenceCol_.Companion.getText(), ClassifiedSentenceCol_.Companion.getLanguage(), ClassifiedSentenceCol_.Companion.getApplicationId()};
            MongosKt.ensureUniqueIndex$default((MongoCollection)c2, (KProperty[])$this$getCollection$iv, null, (int)2, null);
            $this$getCollection$iv = new KProperty[]{ClassifiedSentenceCol_.Companion.getNormalizedText(), ClassifiedSentenceCol_.Companion.getLanguage(), ClassifiedSentenceCol_.Companion.getApplicationId()};
            MongosKt.ensureIndex$default((MongoCollection)c2, (KProperty[])$this$getCollection$iv, null, (int)2, null);
            $this$getCollection$iv = new KProperty[]{ClassifiedSentenceCol_.Companion.getLanguage(), ClassifiedSentenceCol_.Companion.getApplicationId(), ClassifiedSentenceCol_.Companion.getStatus()};
            MongosKt.ensureIndex$default((MongoCollection)c2, (KProperty[])$this$getCollection$iv, null, (int)2, null);
            $this$getCollection$iv = new KProperty[]{ClassifiedSentenceCol_.Companion.getStatus()};
            MongosKt.ensureIndex$default((MongoCollection)c2, (KProperty[])$this$getCollection$iv, null, (int)2, null);
            $this$getCollection$iv = new Pair[]{TuplesKt.to(ClassifiedSentenceCol_.Companion.getApplicationId(), (Object)true), TuplesKt.to(ClassifiedSentenceCol_.Companion.getLanguage(), (Object)true), TuplesKt.to(ClassifiedSentenceCol_.Companion.getUpdateDate(), (Object)false)};
            MongosKt.ensureIndex$default((MongoCollection)c2, (Bson)SortsKt.orderBy((Map)MapsKt.mapOf((Pair[])$this$getCollection$iv)), null, (int)2, null);
            $this$getCollection$iv = new KProperty[]{ClassifiedSentenceCol_.Companion.getLanguage(), ClassifiedSentenceCol_.Companion.getApplicationId(), ClassifiedSentenceCol_.Companion.getUsageCount()};
            MongosKt.ensureIndex$default((MongoCollection)c2, (KProperty[])$this$getCollection$iv, null, (int)2, null);
            $this$getCollection$iv = new KProperty[]{ClassifiedSentenceCol_.Companion.getLanguage(), ClassifiedSentenceCol_.Companion.getApplicationId(), ClassifiedSentenceCol_.Companion.getUnknownCount()};
            MongosKt.ensureIndex$default((MongoCollection)c2, (KProperty[])$this$getCollection$iv, null, (int)2, null);
            $this$getCollection$iv = new KProperty[]{ClassifiedSentenceCol_.Companion.getLanguage(), ClassifiedSentenceCol_.Companion.getStatus(), Classification_.getIntentId()};
            MongosKt.ensureIndex$default((MongoCollection)c2, (KProperty[])$this$getCollection$iv, null, (int)2, null);
            $this$getCollection$iv = new KProperty[]{ClassifiedSentenceCol_.Companion.getApplicationId(), Classification_.getIntentId(), ClassifiedSentenceCol_.Companion.getLanguage(), ClassifiedSentenceCol_.Companion.getUpdateDate()};
            MongosKt.ensureIndex$default((MongoCollection)c2, (KProperty[])$this$getCollection$iv, null, (int)2, null);
            $this$getCollection$iv = new KProperty[]{ClassifiedSentenceCol_.Companion.getForReview()};
            MongosKt.ensureIndex$default((MongoCollection)c2, (KProperty[])$this$getCollection$iv, null, (int)2, null);
            List ttlIntents = PropertiesKt.listProperty$default((String)"tock_nlp_classified_sentences_index_ttl_intent_names", (List)CollectionsKt.emptyList(), null, (int)4, null);
            long ttlDays = PropertiesKt.longProperty((String)"tock_nlp_classified_sentences_index_ttl_days", (long)-1L);
            if (ttlIntents.isEmpty() && ttlDays != -1L) {
                logger.info(() -> ClassifiedSentenceMongoDAO.col_delegate$lambda$6$lambda$1(ttlDays));
                $this$getCollectionOfName$iv$iv = new KProperty[]{ClassifiedSentenceCol_.Companion.getUpdateDate()};
                IndexOptions indexOptions = new IndexOptions().expireAfter(Long.valueOf(ttlDays), TimeUnit.DAYS).partialFilterExpression(FiltersKt.eq((KProperty)((KProperty)ClassifiedSentenceCol_.Companion.getStatus()), (Object)ClassifiedSentenceStatus.inbox));
                Intrinsics.checkNotNullExpressionValue((Object)indexOptions, (String)"partialFilterExpression(...)");
                string = MongosKt.ensureIndex((MongoCollection)c2, (KProperty[])$this$getCollectionOfName$iv$iv, (IndexOptions)indexOptions);
            } else {
                $this$getCollectionOfName$iv$iv = new KProperty[]{ClassifiedSentenceCol_.Companion.getUpdateDate()};
                string = MongosKt.ensureIndex$default((MongoCollection)c2, (KProperty[])$this$getCollectionOfName$iv$iv, null, (int)2, null);
            }
            if (!((Collection)ttlIntents).isEmpty() && ttlDays != -1L) {
                logger.info(() -> ClassifiedSentenceMongoDAO.col_delegate$lambda$6$lambda$2(ttlDays, ttlIntents));
                KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
                Object tag$iv = null;
                boolean $i$f$provide = false;
                KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
                KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
                Executor executor = (Executor)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<Executor>(){}, tag$iv).getValue()).invoke();
                Duration duration = Duration.ofMinutes(1L);
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
                Duration duration2 = Duration.ofDays(1L);
                Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofDays(...)");
                executor.setPeriodic(duration, duration2, () -> ClassifiedSentenceMongoDAO.col_delegate$lambda$6$lambda$5(ttlIntents, c2, ttlDays));
            }
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
        }
        return c2;
    }

    private static final Object updateFormattedSentences$lambda$7() {
        return "start updating formatted sentences";
    }

    private static final Object updateFormattedSentences$lambda$9() {
        return "end updating formatted sentences";
    }

    private static final ClassifiedSentence getSentences$lambda$10(ClassifiedSentenceCol it) {
        return it.toSentence();
    }

    private static final Object search$lambda$20$lambda$12(Bson $filterBase) {
        return SharedExtensionsKt.getJson((Object)$filterBase);
    }

    private static final Object search$lambda$20$lambda$13(long $count) {
        return "count : " + $count;
    }

    private static final ClassifiedSentence search$lambda$20$lambda$19(ClassifiedSentenceCol it) {
        return it.toSentence();
    }

    private static final CharSequence removeSubEntitiesFromSentence$lambda$39(int it) {
        return ".subEntities";
    }

    private static final Object removeSubEntitiesFromSentence$lambda$40(String $filter, String $update) {
        return $filter + " " + $update;
    }

    public static final /* synthetic */ void access$save(ClassifiedSentenceMongoDAO $this, ClassifiedSentenceCol s) {
        $this.save(s);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b9\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u00df\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0013\u0012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0017\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u0012\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u001c\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u001d\u0012\u0014\b\u0002\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u001f\u0012\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b!\u0010\"B\u0011\b\u0016\u0012\u0006\u0010#\u001a\u00020$\u00a2\u0006\u0004\b!\u0010%J\u0006\u0010E\u001a\u00020$J\t\u0010F\u001a\u00020\u0003H\u00c6\u0003J\t\u0010G\u001a\u00020\u0003H\u00c6\u0003J\t\u0010H\u001a\u00020\u0003H\u00c6\u0003J\t\u0010I\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010J\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\t\u0010K\u001a\u00020\fH\u00c6\u0003J\t\u0010L\u001a\u00020\fH\u00c6\u0003J\t\u0010M\u001a\u00020\u000fH\u00c6\u0003J\t\u0010N\u001a\u00020\u0011H\u00c6\u0003J\u0010\u0010O\u001a\u0004\u0018\u00010\u0013H\u00c6\u0003\u00a2\u0006\u0002\u00106J\u0010\u0010P\u001a\u0004\u0018\u00010\u0013H\u00c6\u0003\u00a2\u0006\u0002\u00106J\u000b\u0010Q\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\u0010\u0010R\u001a\u0004\u0018\u00010\u0017H\u00c6\u0003\u00a2\u0006\u0002\u0010;J\u0010\u0010S\u001a\u0004\u0018\u00010\u0017H\u00c6\u0003\u00a2\u0006\u0002\u0010;J\t\u0010T\u001a\u00020\u001aH\u00c6\u0003J\u000b\u0010U\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010V\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u001dH\u00c6\u0003J\u0015\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u001fH\u00c6\u0003J\u000b\u0010X\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u00f4\u0001\u0010Y\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u001c\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u001d2\u0014\b\u0002\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010ZJ\u0013\u0010[\u001a\u00020\u001a2\b\u0010\\\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010]\u001a\u00020^H\u00d6\u0001J\t\u0010_\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010'R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010'R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010/R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0015\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\n\n\u0002\u00107\u001a\u0004\b5\u00106R\u0015\u0010\u0014\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\n\n\u0002\u00107\u001a\u0004\b8\u00106R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010/R\u0015\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\n\n\u0002\u0010<\u001a\u0004\b:\u0010;R\u0015\u0010\u0018\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\n\n\u0002\u0010<\u001a\u0004\b=\u0010;R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010'R\u0019\u0010\u001c\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010'R\u001d\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0013\u0010 \u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010'\u00a8\u0006`"}, d2={"Lai/tock/nlp/front/storage/mongo/ClassifiedSentenceMongoDAO$ClassifiedSentenceCol;", "", "text", "", "normalizedText", "fullText", "language", "Ljava/util/Locale;", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "creationDate", "Ljava/time/Instant;", "updateDate", "status", "Lai/tock/nlp/front/shared/config/ClassifiedSentenceStatus;", "classification", "Lai/tock/nlp/front/shared/config/Classification;", "lastIntentProbability", "", "lastEntityProbability", "lastUsage", "usageCount", "", "unknownCount", "forReview", "", "reviewComment", "classifier", "Lai/tock/shared/security/UserLogin;", "otherIntentsProbabilities", "", "configuration", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Locale;Lorg/litote/kmongo/Id;Ljava/time/Instant;Ljava/time/Instant;Lai/tock/nlp/front/shared/config/ClassifiedSentenceStatus;Lai/tock/nlp/front/shared/config/Classification;Ljava/lang/Double;Ljava/lang/Double;Ljava/time/Instant;Ljava/lang/Long;Ljava/lang/Long;ZLjava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;)V", "sentence", "Lai/tock/nlp/front/shared/config/ClassifiedSentence;", "(Lai/tock/nlp/front/shared/config/ClassifiedSentence;)V", "getText", "()Ljava/lang/String;", "getNormalizedText", "getFullText", "getLanguage", "()Ljava/util/Locale;", "getApplicationId", "()Lorg/litote/kmongo/Id;", "getCreationDate", "()Ljava/time/Instant;", "getUpdateDate", "getStatus", "()Lai/tock/nlp/front/shared/config/ClassifiedSentenceStatus;", "getClassification", "()Lai/tock/nlp/front/shared/config/Classification;", "getLastIntentProbability", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getLastEntityProbability", "getLastUsage", "getUsageCount", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getUnknownCount", "getForReview", "()Z", "getReviewComment", "getClassifier", "getOtherIntentsProbabilities", "()Ljava/util/Map;", "getConfiguration", "toSentence", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Locale;Lorg/litote/kmongo/Id;Ljava/time/Instant;Ljava/time/Instant;Lai/tock/nlp/front/shared/config/ClassifiedSentenceStatus;Lai/tock/nlp/front/shared/config/Classification;Ljava/lang/Double;Ljava/lang/Double;Ljava/time/Instant;Ljava/lang/Long;Ljava/lang/Long;ZLjava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;)Lai/tock/nlp/front/storage/mongo/ClassifiedSentenceMongoDAO$ClassifiedSentenceCol;", "equals", "other", "hashCode", "", "toString", "tock-nlp-front-storage-mongo"})
    public static final class ClassifiedSentenceCol {
        @NotNull
        private final String text;
        @NotNull
        private final String normalizedText;
        @NotNull
        private final String fullText;
        @NotNull
        private final Locale language;
        @NotNull
        private final Id<ApplicationDefinition> applicationId;
        @NotNull
        private final Instant creationDate;
        @NotNull
        private final Instant updateDate;
        @NotNull
        private final ClassifiedSentenceStatus status;
        @NotNull
        private final Classification classification;
        @Nullable
        private final Double lastIntentProbability;
        @Nullable
        private final Double lastEntityProbability;
        @Nullable
        private final Instant lastUsage;
        @Nullable
        private final Long usageCount;
        @Nullable
        private final Long unknownCount;
        private final boolean forReview;
        @Nullable
        private final String reviewComment;
        @Nullable
        private final String classifier;
        @NotNull
        private final Map<String, Double> otherIntentsProbabilities;
        @Nullable
        private final String configuration;

        public ClassifiedSentenceCol(@NotNull String text, @NotNull String normalizedText, @NotNull String fullText, @NotNull Locale language, @NotNull Id<ApplicationDefinition> applicationId, @NotNull Instant creationDate, @NotNull Instant updateDate, @NotNull ClassifiedSentenceStatus status, @NotNull Classification classification2, @Nullable Double lastIntentProbability, @Nullable Double lastEntityProbability, @Nullable Instant lastUsage, @Nullable Long usageCount, @Nullable Long unknownCount, boolean forReview, @Nullable String reviewComment, @Nullable String classifier, @NotNull Map<String, Double> otherIntentsProbabilities2, @Nullable String configuration) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)normalizedText, (String)"normalizedText");
            Intrinsics.checkNotNullParameter((Object)fullText, (String)"fullText");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)creationDate, (String)"creationDate");
            Intrinsics.checkNotNullParameter((Object)updateDate, (String)"updateDate");
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Intrinsics.checkNotNullParameter((Object)classification2, (String)"classification");
            Intrinsics.checkNotNullParameter(otherIntentsProbabilities2, (String)"otherIntentsProbabilities");
            this.text = text;
            this.normalizedText = normalizedText;
            this.fullText = fullText;
            this.language = language;
            this.applicationId = applicationId;
            this.creationDate = creationDate;
            this.updateDate = updateDate;
            this.status = status;
            this.classification = classification2;
            this.lastIntentProbability = lastIntentProbability;
            this.lastEntityProbability = lastEntityProbability;
            this.lastUsage = lastUsage;
            this.usageCount = usageCount;
            this.unknownCount = unknownCount;
            this.forReview = forReview;
            this.reviewComment = reviewComment;
            this.classifier = classifier;
            this.otherIntentsProbabilities = otherIntentsProbabilities2;
            this.configuration = configuration;
        }

        public /* synthetic */ ClassifiedSentenceCol(String string, String string2, String string3, Locale locale, Id id, Instant instant, Instant instant2, ClassifiedSentenceStatus classifiedSentenceStatus, Classification classification2, Double d, Double d2, Instant instant3, Long l, Long l2, boolean bl, String string4, String string5, Map map, String string6, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = string;
            }
            if ((n & 4) != 0) {
                string3 = string;
            }
            if ((n & 0x200) != 0) {
                d = null;
            }
            if ((n & 0x400) != 0) {
                d2 = null;
            }
            if ((n & 0x800) != 0) {
                instant3 = null;
            }
            if ((n & 0x1000) != 0) {
                l = 0L;
            }
            if ((n & 0x2000) != 0) {
                l2 = 0L;
            }
            if ((n & 0x4000) != 0) {
                bl = false;
            }
            if ((n & 0x8000) != 0) {
                string4 = null;
            }
            if ((n & 0x10000) != 0) {
                string5 = null;
            }
            if ((n & 0x20000) != 0) {
                map = MapsKt.emptyMap();
            }
            if ((n & 0x40000) != 0) {
                string6 = null;
            }
            this(string, string2, string3, locale, (Id<ApplicationDefinition>)id, instant, instant2, classifiedSentenceStatus, classification2, d, d2, instant3, l, l2, bl, string4, string5, map, string6);
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String getNormalizedText() {
            return this.normalizedText;
        }

        @NotNull
        public final String getFullText() {
            return this.fullText;
        }

        @NotNull
        public final Locale getLanguage() {
            return this.language;
        }

        @NotNull
        public final Id<ApplicationDefinition> getApplicationId() {
            return this.applicationId;
        }

        @NotNull
        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @NotNull
        public final Instant getUpdateDate() {
            return this.updateDate;
        }

        @NotNull
        public final ClassifiedSentenceStatus getStatus() {
            return this.status;
        }

        @NotNull
        public final Classification getClassification() {
            return this.classification;
        }

        @Nullable
        public final Double getLastIntentProbability() {
            return this.lastIntentProbability;
        }

        @Nullable
        public final Double getLastEntityProbability() {
            return this.lastEntityProbability;
        }

        @Nullable
        public final Instant getLastUsage() {
            return this.lastUsage;
        }

        @Nullable
        public final Long getUsageCount() {
            return this.usageCount;
        }

        @Nullable
        public final Long getUnknownCount() {
            return this.unknownCount;
        }

        public final boolean getForReview() {
            return this.forReview;
        }

        @Nullable
        public final String getReviewComment() {
            return this.reviewComment;
        }

        @Nullable
        public final String getClassifier() {
            return this.classifier;
        }

        @NotNull
        public final Map<String, Double> getOtherIntentsProbabilities() {
            return this.otherIntentsProbabilities;
        }

        @Nullable
        public final String getConfiguration() {
            return this.configuration;
        }

        public ClassifiedSentenceCol(@NotNull ClassifiedSentence sentence) {
            Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
            String string = MongoHelpersKt.textKey(sentence.getText());
            String string2 = ai.tock.shared.StringsKt.normalize((String)sentence.getText(), (Locale)sentence.getLanguage());
            String string3 = sentence.getText();
            Locale locale = sentence.getLanguage();
            Id id = sentence.getApplicationId();
            Instant instant = sentence.getCreationDate();
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            this(string, string2, string3, locale, (Id<ApplicationDefinition>)id, instant, instant2, sentence.getStatus(), sentence.getClassification(), sentence.getLastIntentProbability(), sentence.getLastEntityProbability(), sentence.getLastUsage(), sentence.getUsageCount(), sentence.getUnknownCount(), sentence.getForReview(), sentence.getReviewComment(), sentence.getQualifier(), sentence.getOtherIntentsProbabilities(), sentence.getConfiguration());
        }

        @NotNull
        public final ClassifiedSentence toSentence() {
            Long l = this.usageCount;
            Long l2 = this.unknownCount;
            return new ClassifiedSentence(this.fullText, this.language, this.applicationId, this.creationDate, this.updateDate, this.status, this.classification, this.lastIntentProbability, this.lastEntityProbability, this.lastUsage, l != null ? l : 0L, l2 != null ? l2 : 0L, this.forReview, this.reviewComment, this.classifier, this.otherIntentsProbabilities, this.configuration);
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final String component2() {
            return this.normalizedText;
        }

        @NotNull
        public final String component3() {
            return this.fullText;
        }

        @NotNull
        public final Locale component4() {
            return this.language;
        }

        @NotNull
        public final Id<ApplicationDefinition> component5() {
            return this.applicationId;
        }

        @NotNull
        public final Instant component6() {
            return this.creationDate;
        }

        @NotNull
        public final Instant component7() {
            return this.updateDate;
        }

        @NotNull
        public final ClassifiedSentenceStatus component8() {
            return this.status;
        }

        @NotNull
        public final Classification component9() {
            return this.classification;
        }

        @Nullable
        public final Double component10() {
            return this.lastIntentProbability;
        }

        @Nullable
        public final Double component11() {
            return this.lastEntityProbability;
        }

        @Nullable
        public final Instant component12() {
            return this.lastUsage;
        }

        @Nullable
        public final Long component13() {
            return this.usageCount;
        }

        @Nullable
        public final Long component14() {
            return this.unknownCount;
        }

        public final boolean component15() {
            return this.forReview;
        }

        @Nullable
        public final String component16() {
            return this.reviewComment;
        }

        @Nullable
        public final String component17() {
            return this.classifier;
        }

        @NotNull
        public final Map<String, Double> component18() {
            return this.otherIntentsProbabilities;
        }

        @Nullable
        public final String component19() {
            return this.configuration;
        }

        @NotNull
        public final ClassifiedSentenceCol copy(@NotNull String text, @NotNull String normalizedText, @NotNull String fullText, @NotNull Locale language, @NotNull Id<ApplicationDefinition> applicationId, @NotNull Instant creationDate, @NotNull Instant updateDate, @NotNull ClassifiedSentenceStatus status, @NotNull Classification classification2, @Nullable Double lastIntentProbability, @Nullable Double lastEntityProbability, @Nullable Instant lastUsage, @Nullable Long usageCount, @Nullable Long unknownCount, boolean forReview, @Nullable String reviewComment, @Nullable String classifier, @NotNull Map<String, Double> otherIntentsProbabilities2, @Nullable String configuration) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)normalizedText, (String)"normalizedText");
            Intrinsics.checkNotNullParameter((Object)fullText, (String)"fullText");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)creationDate, (String)"creationDate");
            Intrinsics.checkNotNullParameter((Object)updateDate, (String)"updateDate");
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Intrinsics.checkNotNullParameter((Object)classification2, (String)"classification");
            Intrinsics.checkNotNullParameter(otherIntentsProbabilities2, (String)"otherIntentsProbabilities");
            return new ClassifiedSentenceCol(text, normalizedText, fullText, language, applicationId, creationDate, updateDate, status, classification2, lastIntentProbability, lastEntityProbability, lastUsage, usageCount, unknownCount, forReview, reviewComment, classifier, otherIntentsProbabilities2, configuration);
        }

        public static /* synthetic */ ClassifiedSentenceCol copy$default(ClassifiedSentenceCol classifiedSentenceCol, String string, String string2, String string3, Locale locale, Id id, Instant instant, Instant instant2, ClassifiedSentenceStatus classifiedSentenceStatus, Classification classification2, Double d, Double d2, Instant instant3, Long l, Long l2, boolean bl, String string4, String string5, Map map, String string6, int n, Object object) {
            if ((n & 1) != 0) {
                string = classifiedSentenceCol.text;
            }
            if ((n & 2) != 0) {
                string2 = classifiedSentenceCol.normalizedText;
            }
            if ((n & 4) != 0) {
                string3 = classifiedSentenceCol.fullText;
            }
            if ((n & 8) != 0) {
                locale = classifiedSentenceCol.language;
            }
            if ((n & 0x10) != 0) {
                id = classifiedSentenceCol.applicationId;
            }
            if ((n & 0x20) != 0) {
                instant = classifiedSentenceCol.creationDate;
            }
            if ((n & 0x40) != 0) {
                instant2 = classifiedSentenceCol.updateDate;
            }
            if ((n & 0x80) != 0) {
                classifiedSentenceStatus = classifiedSentenceCol.status;
            }
            if ((n & 0x100) != 0) {
                classification2 = classifiedSentenceCol.classification;
            }
            if ((n & 0x200) != 0) {
                d = classifiedSentenceCol.lastIntentProbability;
            }
            if ((n & 0x400) != 0) {
                d2 = classifiedSentenceCol.lastEntityProbability;
            }
            if ((n & 0x800) != 0) {
                instant3 = classifiedSentenceCol.lastUsage;
            }
            if ((n & 0x1000) != 0) {
                l = classifiedSentenceCol.usageCount;
            }
            if ((n & 0x2000) != 0) {
                l2 = classifiedSentenceCol.unknownCount;
            }
            if ((n & 0x4000) != 0) {
                bl = classifiedSentenceCol.forReview;
            }
            if ((n & 0x8000) != 0) {
                string4 = classifiedSentenceCol.reviewComment;
            }
            if ((n & 0x10000) != 0) {
                string5 = classifiedSentenceCol.classifier;
            }
            if ((n & 0x20000) != 0) {
                map = classifiedSentenceCol.otherIntentsProbabilities;
            }
            if ((n & 0x40000) != 0) {
                string6 = classifiedSentenceCol.configuration;
            }
            return classifiedSentenceCol.copy(string, string2, string3, locale, id, instant, instant2, classifiedSentenceStatus, classification2, d, d2, instant3, l, l2, bl, string4, string5, map, string6);
        }

        @NotNull
        public String toString() {
            return "ClassifiedSentenceCol(text=" + this.text + ", normalizedText=" + this.normalizedText + ", fullText=" + this.fullText + ", language=" + this.language + ", applicationId=" + this.applicationId + ", creationDate=" + this.creationDate + ", updateDate=" + this.updateDate + ", status=" + this.status + ", classification=" + this.classification + ", lastIntentProbability=" + this.lastIntentProbability + ", lastEntityProbability=" + this.lastEntityProbability + ", lastUsage=" + this.lastUsage + ", usageCount=" + this.usageCount + ", unknownCount=" + this.unknownCount + ", forReview=" + this.forReview + ", reviewComment=" + this.reviewComment + ", classifier=" + this.classifier + ", otherIntentsProbabilities=" + this.otherIntentsProbabilities + ", configuration=" + this.configuration + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + this.normalizedText.hashCode();
            result2 = result2 * 31 + this.fullText.hashCode();
            result2 = result2 * 31 + this.language.hashCode();
            result2 = result2 * 31 + this.applicationId.hashCode();
            result2 = result2 * 31 + this.creationDate.hashCode();
            result2 = result2 * 31 + this.updateDate.hashCode();
            result2 = result2 * 31 + this.status.hashCode();
            result2 = result2 * 31 + this.classification.hashCode();
            result2 = result2 * 31 + (this.lastIntentProbability == null ? 0 : ((Object)this.lastIntentProbability).hashCode());
            result2 = result2 * 31 + (this.lastEntityProbability == null ? 0 : ((Object)this.lastEntityProbability).hashCode());
            result2 = result2 * 31 + (this.lastUsage == null ? 0 : this.lastUsage.hashCode());
            result2 = result2 * 31 + (this.usageCount == null ? 0 : ((Object)this.usageCount).hashCode());
            result2 = result2 * 31 + (this.unknownCount == null ? 0 : ((Object)this.unknownCount).hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.forReview);
            result2 = result2 * 31 + (this.reviewComment == null ? 0 : this.reviewComment.hashCode());
            result2 = result2 * 31 + (this.classifier == null ? 0 : this.classifier.hashCode());
            result2 = result2 * 31 + ((Object)this.otherIntentsProbabilities).hashCode();
            result2 = result2 * 31 + (this.configuration == null ? 0 : this.configuration.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClassifiedSentenceCol)) {
                return false;
            }
            ClassifiedSentenceCol classifiedSentenceCol = (ClassifiedSentenceCol)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)classifiedSentenceCol.text)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.normalizedText, (Object)classifiedSentenceCol.normalizedText)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fullText, (Object)classifiedSentenceCol.fullText)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.language, (Object)classifiedSentenceCol.language)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.applicationId, classifiedSentenceCol.applicationId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.creationDate, (Object)classifiedSentenceCol.creationDate)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.updateDate, (Object)classifiedSentenceCol.updateDate)) {
                return false;
            }
            if (this.status != classifiedSentenceCol.status) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.classification, (Object)classifiedSentenceCol.classification)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastIntentProbability, (Object)classifiedSentenceCol.lastIntentProbability)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastEntityProbability, (Object)classifiedSentenceCol.lastEntityProbability)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastUsage, (Object)classifiedSentenceCol.lastUsage)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.usageCount, (Object)classifiedSentenceCol.usageCount)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.unknownCount, (Object)classifiedSentenceCol.unknownCount)) {
                return false;
            }
            if (this.forReview != classifiedSentenceCol.forReview) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.reviewComment, (Object)classifiedSentenceCol.reviewComment)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.classifier, (Object)classifiedSentenceCol.classifier)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.otherIntentsProbabilities, classifiedSentenceCol.otherIntentsProbabilities)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.configuration, (Object)classifiedSentenceCol.configuration);
        }
    }
}

