/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.front.storage.mongo;

import ai.tock.nlp.front.service.storage.FaqDefinitionDAO;
import ai.tock.nlp.front.shared.config.ApplicationDefinition;
import ai.tock.nlp.front.shared.config.ClassifiedSentenceStatus;
import ai.tock.nlp.front.shared.config.FaqDefinition;
import ai.tock.nlp.front.shared.config.FaqDefinitionTag;
import ai.tock.nlp.front.shared.config.FaqQuery;
import ai.tock.nlp.front.shared.config.FaqQueryResult;
import ai.tock.nlp.front.shared.config.IntentDefinition;
import ai.tock.nlp.front.storage.mongo.FaqDefinitionMongoDAO;
import ai.tock.nlp.front.storage.mongo.FaqDefinitionMongoDAO$listenFaqDefinitionChanges$;
import ai.tock.nlp.front.storage.mongo.MongoFrontConfiguration;
import ai.tock.shared.MongosKt;
import ai.tock.translator.I18nLabel;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.Variable;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.KMongoIterableKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.AccumulatorsKt;
import org.litote.kmongo.AggregatesKt;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.Id;
import org.litote.kmongo.IdsKt;
import org.litote.kmongo.MongoCollectionsKt;
import org.litote.kmongo.MongoOperator;
import org.litote.kmongo.ProjectionsKt;
import org.litote.kmongo.PropertiesKt;
import org.litote.kmongo.SharedExtensionsKt;
import org.litote.kmongo.SortsKt;
import org.litote.kmongo.reactivestreams.MongoSharedCollectionsKt;
import org.litote.kmongo.util.KMongoUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0018H\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u001e2\u0006\u0010\u0017\u001a\u00020\u001aH\u0016J\u0018\u0010\u001f\u001a\u0004\u0018\u00010\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020 0\u0018H\u0016J\"\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u001e2\u0012\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u00180#H\u0016J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u001e2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001a0#H\u0016J\u0018\u0010&\u001a\u0004\u0018\u00010\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020'0\u0018H\u0016J$\u0010(\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u001e2\u0012\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0\u00180#H\u0016J \u0010*\u001a\u0004\u0018\u00010\b2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020 0\u00182\u0006\u0010,\u001a\u00020\u001aH\u0016J\u0010\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\bH\u0016J@\u0010/\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002010\u001e\u0012\u0004\u0012\u000202002\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0014\u00107\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0\u0018\u0018\u00010\u001eH\u0016J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001e2\u0006\u0010,\u001a\u00020\u001aH\u0016J$\u00109\u001a\u00020\u00132\u001a\u0010:\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u001a0;H\u0016J>\u0010?\u001a\u0012\u0012\u0004\u0012\u00020A0@j\b\u0012\u0004\u0012\u00020A`B2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0014\u00107\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0\u0018\u0018\u00010\u001eH\u0002J>\u0010C\u001a\u0012\u0012\u0004\u0012\u00020A0@j\b\u0012\u0004\u0012\u00020A`B2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0014\u00107\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0\u0018\u0018\u00010\u001eH\u0002J\u000e\u0010D\u001a\u0004\u0018\u00010A*\u000204H\u0002J\u000e\u0010E\u001a\u0004\u0018\u00010A*\u000204H\u0002J\u000e\u0010F\u001a\u0004\u0018\u00010A*\u000204H\u0002J\u001a\u0010G\u001a\u00020A*\u0002042\f\u0010H\u001a\b\u0012\u0004\u0012\u0002060\u0018H\u0002J\f\u0010I\u001a\u00020A*\u000204H\u0002J$\u0010J\u001a\u0004\u0018\u00010A*\u0002042\u0014\u00107\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0\u0018\u0018\u00010\u001eH\u0002J\u000e\u0010K\u001a\u0004\u0018\u00010A*\u000204H\u0002J\u000e\u0010L\u001a\u0004\u0018\u00010A*\u000204H\u0002J\u0010\u0010M\u001a\u00020A2\u0006\u0010,\u001a\u00020\u001aH\u0002J\f\u0010N\u001a\u00020A*\u000204H\u0002J\b\u0010O\u001a\u00020AH\u0002J\f\u0010P\u001a\u00020A*\u000204H\u0002J\u001a\u0010Q\u001a\u00020A*\u0002042\f\u0010R\u001a\b\u0012\u0004\u0012\u0002060\u0018H\u0002J\b\u0010S\u001a\u00020AH\u0002J\b\u0010T\u001a\u00020AH\u0002J%\u0010U\u001a\u00020A2\u0016\u0010V\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010A0W\"\u0004\u0018\u00010AH\u0002\u00a2\u0006\u0002\u0010XJ%\u0010Y\u001a\u00020A2\u0016\u0010V\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010A0W\"\u0004\u0018\u00010AH\u0002\u00a2\u0006\u0002\u0010XJ)\u0010Z\u001a\u00020A2\u001a\u0010[\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\\0W\"\u0006\u0012\u0002\b\u00030\\H\u0002\u00a2\u0006\u0002\u0010]J)\u0010^\u001a\u00020A2\u001a\u0010[\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\\0W\"\u0006\u0012\u0002\b\u00030\\H\u0002\u00a2\u0006\u0002\u0010]R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010<\u001a\u00020\u001aX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u001aX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u001aX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Lai/tock/nlp/front/storage/mongo/FaqDefinitionMongoDAO;", "Lai/tock/nlp/front/service/storage/FaqDefinitionDAO;", "<init>", "()V", "logger", "Lmu/KLogger;", "col", "Lcom/mongodb/client/MongoCollection;", "Lai/tock/nlp/front/shared/config/FaqDefinition;", "getCol$tock_nlp_front_storage_mongo", "()Lcom/mongodb/client/MongoCollection;", "col$delegate", "Lkotlin/Lazy;", "asyncCol", "Lcom/mongodb/reactivestreams/client/MongoCollection;", "getAsyncCol", "()Lcom/mongodb/reactivestreams/client/MongoCollection;", "asyncCol$delegate", "listenFaqDefinitionChanges", "", "listener", "Lkotlin/Function0;", "deleteFaqDefinitionById", "id", "Lorg/litote/kmongo/Id;", "deleteFaqDefinitionByBotIdAndNamespace", "", "namespace", "getFaqDefinitionById", "getFaqDefinitionByBotId", "", "getFaqDefinitionByIntentId", "Lai/tock/nlp/front/shared/config/IntentDefinition;", "getFaqDefinitionByIntentIds", "intentIds", "", "getFaqDefinitionByTags", "tags", "getFaqDefinitionByI18nId", "Lai/tock/translator/I18nLabel;", "getFaqDefinitionByI18nIds", "ids", "getFaqDefinitionByIntentIdAndBotId", "intentId", "botId", "save", "faqDefinition", "getFaqDetailsWithCount", "Lkotlin/Pair;", "Lai/tock/nlp/front/shared/config/FaqQueryResult;", "", "query", "Lai/tock/nlp/front/shared/config/FaqQuery;", "applicationDefinition", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "i18nIds", "getTags", "makeMigration", "intentIdSupplier", "Lkotlin/Function1;", "CLASSIFIED_SENTENCE_COLLECTION", "INTENT_DEFINITION_COLLECTION", "FAQ_INTENTID", "prepareFaqDetailBaseAggregation", "Ljava/util/ArrayList;", "Lorg/bson/conversions/Bson;", "Lkotlin/collections/ArrayList;", "prepareFaqDetailBaseAggregationDocumentDb", "filterTextSearchOnFaqTitle", "filterTextSearchOnFaqDescription", "filterTextSearchOnClassifiedSentence", "filterCurrentApplicationClassifiedSentence", "currentApplicationId", "filterNotDeletedClassifiedSentencesStatus", "filterI18nIds", "filterTags", "filterEnabled", "filterOnBotId", "groupFaqDefinitionDetailedData", "joinOnIntentDefinition", "joinOnClassifiedSentence", "joinOnClassifiedSentenceStatusNotDeleted", "applicationId", "groupByTag", "projectByTag", "orNotNull", "predicates", "", "([Lorg/bson/conversions/Bson;)Lorg/bson/conversions/Bson;", "andNotNull", "sortAscending", "properties", "Lkotlin/reflect/KProperty;", "([Lkotlin/reflect/KProperty;)Lorg/bson/conversions/Bson;", "sortDescending", "tock-nlp-front-storage-mongo"})
@SourceDebugExtension(value={"SMAP\nFaqDefinitionMongoDAO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FaqDefinitionMongoDAO.kt\nai/tock/nlp/front/storage/mongo/FaqDefinitionMongoDAO\n+ 2 Mongos.kt\nai/tock/shared/MongosKt\n+ 3 MongoSharedCollections.kt\norg/litote/kmongo/reactivestreams/MongoSharedCollectionsKt\n+ 4 KMongoIterable.kt\nkotlin/collections/KMongoIterableKt\n+ 5 MongoCollections.kt\norg/litote/kmongo/MongoCollectionsKt\n+ 6 MongoDatabases.kt\norg/litote/kmongo/MongoDatabasesKt\n+ 7 MongoSharedDatabases.kt\norg/litote/kmongo/reactivestreams/MongoSharedDatabasesKt\n+ 8 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,540:1\n232#2,5:541\n243#2:565\n60#3,19:546\n725#4:566\n61#4:569\n187#5:567\n187#5:568\n61#6:570\n52#7:571\n1557#8:572\n1628#8,3:573\n*S KotlinDebug\n*F\n+ 1 FaqDefinitionMongoDAO.kt\nai/tock/nlp/front/storage/mongo/FaqDefinitionMongoDAO\n*L\n104#1:541,5\n104#1:565\n104#1:546,19\n185#1:566\n239#1:569\n200#1:567\n233#1:568\n86#1:570\n100#1:571\n172#1:572\n172#1:573,3\n*E\n"})
public final class FaqDefinitionMongoDAO
implements FaqDefinitionDAO {
    @NotNull
    public static final FaqDefinitionMongoDAO INSTANCE = new FaqDefinitionMongoDAO();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(FaqDefinitionMongoDAO::logger$lambda$0);
    @NotNull
    private static final Lazy col$delegate = LazyKt.lazy(FaqDefinitionMongoDAO::col_delegate$lambda$2);
    @NotNull
    private static final Lazy asyncCol$delegate = LazyKt.lazy(FaqDefinitionMongoDAO::asyncCol_delegate$lambda$3);
    @NotNull
    private static final String CLASSIFIED_SENTENCE_COLLECTION = "classified_sentence";
    @NotNull
    private static final String INTENT_DEFINITION_COLLECTION = "intent_definition";
    @NotNull
    private static final String FAQ_INTENTID = "faq_intentId";

    private FaqDefinitionMongoDAO() {
    }

    @NotNull
    public final com.mongodb.client.MongoCollection<FaqDefinition> getCol$tock_nlp_front_storage_mongo() {
        Lazy lazy = col$delegate;
        return (com.mongodb.client.MongoCollection)lazy.getValue();
    }

    private final MongoCollection<FaqDefinition> getAsyncCol() {
        Lazy lazy = asyncCol$delegate;
        return (MongoCollection)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void listenFaqDefinitionChanges(@NotNull Function0<Unit> listener) {
        void errorListener$iv$iv;
        void subscribeListener$iv$iv;
        void $this$watchIndefinitely_u24default$iv$iv;
        void $this$watch_u24default$iv;
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        MongoCollection<FaqDefinition> mongoCollection = this.getAsyncCol();
        Function1 listener$iv = arg_0 -> FaqDefinitionMongoDAO.listenFaqDefinitionChanges$lambda$4(listener, arg_0);
        FullDocument fullDocument$iv = FullDocument.DEFAULT;
        boolean $i$f$watch = false;
        void var6_6 = $this$watch_u24default$iv;
        Function0 function0 = listenFaqDefinitionChanges$$inlined$watch$default$1.INSTANCE;
        Function1 function1 = listenFaqDefinitionChanges$$inlined$watch$default$2.INSTANCE;
        Function0 reopenListener$iv$iv = listenFaqDefinitionChanges$$inlined$watch$default$3.INSTANCE;
        long reopenDelayInMS$iv$iv = 5000L;
        boolean $i$f$watchIndefinitely = false;
        MongoSharedCollectionsKt.watchIndefinitely((MongoCollection)$this$watchIndefinitely_u24default$iv$iv, (Function1)((Function1)new Function1<MongoCollection<FaqDefinition>, ChangeStreamPublisher<FaqDefinition>>((MongoCollection)$this$watchIndefinitely_u24default$iv$iv, fullDocument$iv){
            final /* synthetic */ MongoCollection $this_watchIndefinitely;
            final /* synthetic */ FullDocument $fullDocument;
            {
                this.$this_watchIndefinitely = $receiver;
                this.$fullDocument = $fullDocument;
            }

            public final ChangeStreamPublisher<FaqDefinition> invoke(MongoCollection<FaqDefinition> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                ChangeStreamPublisher changeStreamPublisher = this.$this_watchIndefinitely.watch(FaqDefinition.class).fullDocument(this.$fullDocument);
                Intrinsics.checkNotNullExpressionValue((Object)changeStreamPublisher, (String)"fullDocument(...)");
                return changeStreamPublisher;
            }
        }), (Function0)subscribeListener$iv$iv, (Function1)errorListener$iv$iv, (Function0)reopenListener$iv$iv, (long)reopenDelayInMS$iv$iv, (Function1)listener$iv);
    }

    public void deleteFaqDefinitionById(@NotNull Id<FaqDefinition> id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        MongoCollectionsKt.deleteOneById(this.getCol$tock_nlp_front_storage_mongo(), id);
    }

    public void deleteFaqDefinitionByBotIdAndNamespace(@NotNull String id, @NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)deleteFaqDefinitionByBotIdAndNamespace.1.INSTANCE), (Object)id), FiltersKt.eq((KProperty)((KProperty)deleteFaqDefinitionByBotIdAndNamespace.2.INSTANCE), (Object)namespace)};
        this.getCol$tock_nlp_front_storage_mongo().deleteMany(FiltersKt.and((Bson[])bsonArray));
    }

    @Nullable
    public FaqDefinition getFaqDefinitionById(@NotNull Id<FaqDefinition> id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        return (FaqDefinition)MongoCollectionsKt.findOneById(this.getCol$tock_nlp_front_storage_mongo(), id);
    }

    @NotNull
    public List<FaqDefinition> getFaqDefinitionByBotId(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Collection collection = this.getCol$tock_nlp_front_storage_mongo().find(FiltersKt.eq((KProperty)((KProperty)getFaqDefinitionByBotId.1.INSTANCE), (Object)id)).into((Collection)new ArrayList());
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"into(...)");
        return (List)collection;
    }

    @Nullable
    public FaqDefinition getFaqDefinitionByIntentId(@NotNull Id<IntentDefinition> id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        return (FaqDefinition)MongoCollectionsKt.findOne(this.getCol$tock_nlp_front_storage_mongo(), (Bson)FiltersKt.eq((KProperty)((KProperty)getFaqDefinitionByIntentId.1.INSTANCE), id));
    }

    @NotNull
    public List<FaqDefinition> getFaqDefinitionByIntentIds(@NotNull Set<? extends Id<IntentDefinition>> intentIds) {
        Intrinsics.checkNotNullParameter(intentIds, (String)"intentIds");
        Collection collection = this.getCol$tock_nlp_front_storage_mongo().find(FiltersKt.in((KProperty)((KProperty)getFaqDefinitionByIntentIds.1.INSTANCE), (Iterable)intentIds)).into((Collection)new ArrayList());
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"into(...)");
        return (List)collection;
    }

    @NotNull
    public List<FaqDefinition> getFaqDefinitionByTags(@NotNull Set<String> tags) {
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Collection collection = this.getCol$tock_nlp_front_storage_mongo().find(FiltersKt.inArray((KProperty)((KProperty)getFaqDefinitionByTags.1.INSTANCE), (Iterable)tags)).into((Collection)new ArrayList());
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"into(...)");
        return (List)collection;
    }

    @Nullable
    public FaqDefinition getFaqDefinitionByI18nId(@NotNull Id<I18nLabel> id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        return (FaqDefinition)MongoCollectionsKt.findOne(this.getCol$tock_nlp_front_storage_mongo(), (Bson)FiltersKt.eq((KProperty)((KProperty)getFaqDefinitionByI18nId.1.INSTANCE), id));
    }

    @Nullable
    public List<FaqDefinition> getFaqDefinitionByI18nIds(@NotNull Set<? extends Id<I18nLabel>> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        return (List)this.getCol$tock_nlp_front_storage_mongo().find(FiltersKt.in((KProperty)((KProperty)getFaqDefinitionByI18nIds.1.INSTANCE), (Iterable)ids)).into((Collection)new ArrayList());
    }

    @Nullable
    public FaqDefinition getFaqDefinitionByIntentIdAndBotId(@NotNull Id<IntentDefinition> intentId, @NotNull String botId) {
        Intrinsics.checkNotNullParameter(intentId, (String)"intentId");
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)getFaqDefinitionByIntentIdAndBotId.1.INSTANCE), intentId), FiltersKt.eq((KProperty)((KProperty)getFaqDefinitionByIntentIdAndBotId.2.INSTANCE), (Object)botId)};
        return (FaqDefinition)MongoCollectionsKt.findOne(this.getCol$tock_nlp_front_storage_mongo(), (Bson[])bsonArray);
    }

    public void save(@NotNull FaqDefinition faqDefinition) {
        Intrinsics.checkNotNullParameter((Object)faqDefinition, (String)"faqDefinition");
        com.mongodb.client.MongoCollection<FaqDefinition> mongoCollection = this.getCol$tock_nlp_front_storage_mongo();
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)save.1.INSTANCE), (Object)faqDefinition.get_id()), FiltersKt.eq((KProperty)((KProperty)save.2.INSTANCE), (Object)faqDefinition.getIntentId()), FiltersKt.eq((KProperty)((KProperty)save.3.INSTANCE), (Object)faqDefinition.getI18nId())};
        Bson bson = FiltersKt.and((Bson[])bsonArray);
        ReplaceOptions replaceOptions = new ReplaceOptions().upsert(true);
        Intrinsics.checkNotNullExpressionValue((Object)replaceOptions, (String)"upsert(...)");
        MongoCollectionsKt.replaceOneWithFilter(mongoCollection, (Bson)bson, (Object)faqDefinition, (ReplaceOptions)replaceOptions);
    }

    @NotNull
    public Pair<List<FaqQueryResult>, Long> getFaqDetailsWithCount(@NotNull FaqQuery query2, @NotNull ApplicationDefinition applicationDefinition, @Nullable List<? extends Id<I18nLabel>> i18nIds) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        Intrinsics.checkNotNullParameter((Object)applicationDefinition, (String)"applicationDefinition");
        FaqQuery $this$getFaqDetailsWithCount_u24lambda_u249 = query2;
        boolean bl = false;
        ArrayList<Bson> baseAggregation = MongosKt.isDocumentDB() ? INSTANCE.prepareFaqDetailBaseAggregationDocumentDb(query2, applicationDefinition, i18nIds) : INSTANCE.prepareFaqDetailBaseAggregation(query2, applicationDefinition, i18nIds);
        logger.debug(() -> FaqDefinitionMongoDAO.getFaqDetailsWithCount$lambda$9$lambda$6(baseAggregation));
        AggregateIterable aggregateIterable = INSTANCE.getCol$tock_nlp_front_storage_mongo().aggregate((List)baseAggregation, FaqQueryResult.class);
        Intrinsics.checkNotNullExpressionValue((Object)aggregateIterable, (String)"aggregate(...)");
        int count = KMongoIterableKt.count((MongoIterable)((MongoIterable)aggregateIterable));
        logger.debug(() -> FaqDefinitionMongoDAO.getFaqDetailsWithCount$lambda$9$lambda$7(count));
        List aggregationWithSkipAndLimit = (int)$this$getFaqDetailsWithCount_u24lambda_u249.getStart() > 0 ? CollectionsKt.plus((Collection)baseAggregation, (Object)AggregatesKt.skip((int)((int)$this$getFaqDetailsWithCount_u24lambda_u249.getStart()))) : (List)baseAggregation;
        aggregationWithSkipAndLimit = CollectionsKt.plus((Collection)aggregationWithSkipAndLimit, (Object)AggregatesKt.limit((int)$this$getFaqDetailsWithCount_u24lambda_u249.getSize()));
        if ((long)count > $this$getFaqDetailsWithCount_u24lambda_u249.getStart()) {
            AggregateIterable res = INSTANCE.getCol$tock_nlp_front_storage_mongo().aggregate(aggregationWithSkipAndLimit, FaqQueryResult.class);
            Intrinsics.checkNotNull((Object)res);
            MongoIterable $this$mapNotNull$iv = (MongoIterable)res;
            boolean $i$f$mapNotNull = false;
            Pair pair2 = new Pair((Object)((List)KMongoIterableKt.useCursor((MongoIterable)$this$mapNotNull$iv, (Function1)((Function1)new Function1<Iterable<? extends FaqQueryResult>, List<? extends FaqQueryResult>>(){

                /*
                 * WARNING - void declaration
                 */
                public final List<FaqQueryResult> invoke(Iterable<? extends FaqQueryResult> it) {
                    void $this$mapNotNullTo$iv$iv;
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    Iterable<? extends FaqQueryResult> $this$mapNotNull$iv = it;
                    boolean $i$f$mapNotNull = false;
                    Iterable<? extends FaqQueryResult> iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        FaqQueryResult it$iv$iv;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        FaqQueryResult it2 = (FaqQueryResult)element$iv$iv;
                        boolean bl2 = false;
                        if (it2 == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
            }))), (Object)count);
            pair = pair2;
        } else {
            pair = new Pair((Object)CollectionsKt.emptyList(), (Object)0L);
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getTags(@NotNull String botId) {
        void $this$aggregate$iv;
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        com.mongodb.client.MongoCollection<FaqDefinition> mongoCollection = this.getCol$tock_nlp_front_storage_mongo();
        Object[] objectArray = new Bson[6];
        objectArray[0] = this.joinOnIntentDefinition();
        Bson[] bsonArray = new Bson[]{this.filterOnBotId(botId)};
        objectArray[1] = AggregatesKt.match((Bson)this.andNotNull(bsonArray));
        objectArray[2] = AggregatesKt.unwind$default((KProperty)((KProperty)getTags.1.INSTANCE), null, (int)1, null);
        objectArray[3] = this.groupByTag();
        objectArray[4] = this.projectByTag();
        bsonArray = new KProperty[]{getTags.2.INSTANCE};
        objectArray[5] = this.sortAscending((KProperty<?>[])bsonArray);
        Object[] pipeline$iv = objectArray;
        boolean $i$f$aggregate = false;
        AggregateIterable aggregateIterable = $this$aggregate$iv.aggregate(ArraysKt.toList((Object[])pipeline$iv), FaqDefinitionTag.class);
        Intrinsics.checkNotNullExpressionValue((Object)aggregateIterable, (String)"aggregate(...)");
        MongoIterable mongoIterable = aggregateIterable.map(FaqDefinitionMongoDAO::getTags$lambda$10);
        Intrinsics.checkNotNullExpressionValue((Object)mongoIterable, (String)"map(...)");
        return KMongoIterableKt.toList((MongoIterable)mongoIterable);
    }

    /*
     * WARNING - void declaration
     */
    public void makeMigration(@NotNull Function1<? super Id<IntentDefinition>, String> intentIdSupplier) {
        void $this$aggregate$iv;
        Intrinsics.checkNotNullParameter(intentIdSupplier, (String)"intentIdSupplier");
        com.mongodb.client.MongoCollection<FaqDefinition> mongoCollection = this.getCol$tock_nlp_front_storage_mongo();
        Object[] objectArray = new Bson[1];
        Bson[] bsonArray = new Bson[]{FiltersKt.exists((KProperty)((KProperty)makeMigration.1.INSTANCE), (boolean)false), FiltersKt.exists((KProperty)((KProperty)makeMigration.2.INSTANCE), (boolean)true)};
        objectArray[0] = AggregatesKt.match((Bson[])bsonArray);
        Object[] pipeline$iv = objectArray;
        boolean $i$f$aggregate = false;
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000C\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001Ba\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u00c6\u0003J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u00c6\u0003J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060\fH\u00c6\u0003J\t\u0010&\u001a\u00020\u000eH\u00c6\u0003J\t\u0010'\u001a\u00020\u0010H\u00c6\u0003J\t\u0010(\u001a\u00020\u0010H\u00c6\u0003Jv\u0010)\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010H\u00c6\u0001\u00a2\u0006\u0002\u0010*J\u0013\u0010+\u001a\u00020\u000e2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020.H\u00d6\u0001J\t\u0010/\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001f\u00a8\u00060"}, d2={"ai/tock/nlp/front/storage/mongo/FaqDefinitionMongoDAO$makeMigration$FaqProjection", "", "_id", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/FaqDefinition;", "botId", "", "intentId", "Lai/tock/nlp/front/shared/config/IntentDefinition;", "i18nId", "Lai/tock/translator/I18nLabel;", "tags", "", "enabled", "", "creationDate", "Ljava/time/Instant;", "updateDate", "<init>", "(Lorg/litote/kmongo/Id;Ljava/lang/String;Lorg/litote/kmongo/Id;Lorg/litote/kmongo/Id;Ljava/util/List;ZLjava/time/Instant;Ljava/time/Instant;)V", "get_id", "()Lorg/litote/kmongo/Id;", "getBotId", "()Ljava/lang/String;", "getIntentId", "getI18nId", "getTags", "()Ljava/util/List;", "getEnabled", "()Z", "getCreationDate", "()Ljava/time/Instant;", "getUpdateDate", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "(Lorg/litote/kmongo/Id;Ljava/lang/String;Lorg/litote/kmongo/Id;Lorg/litote/kmongo/Id;Ljava/util/List;ZLjava/time/Instant;Ljava/time/Instant;)Lai/tock/nlp/front/storage/mongo/FaqDefinitionMongoDAO$makeMigration$FaqProjection;", "equals", "other", "hashCode", "", "toString", "tock-nlp-front-storage-mongo"})
        public final class FaqProjection {
            private final Id<FaqDefinition> _id;
            private final String botId;
            private final Id<IntentDefinition> intentId;
            private final Id<I18nLabel> i18nId;
            private final List<String> tags;
            private final boolean enabled;
            private final Instant creationDate;
            private final Instant updateDate;

            public FaqProjection(Id<FaqDefinition> _id2, String botId, Id<IntentDefinition> intentId, Id<I18nLabel> i18nId, List<String> tags, boolean enabled, Instant creationDate, Instant updateDate) {
                Intrinsics.checkNotNullParameter(_id2, (String)"_id");
                Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
                Intrinsics.checkNotNullParameter(intentId, (String)"intentId");
                Intrinsics.checkNotNullParameter(i18nId, (String)"i18nId");
                Intrinsics.checkNotNullParameter(tags, (String)"tags");
                Intrinsics.checkNotNullParameter((Object)creationDate, (String)"creationDate");
                Intrinsics.checkNotNullParameter((Object)updateDate, (String)"updateDate");
                this._id = _id2;
                this.botId = botId;
                this.intentId = intentId;
                this.i18nId = i18nId;
                this.tags = tags;
                this.enabled = enabled;
                this.creationDate = creationDate;
                this.updateDate = updateDate;
            }

            public /* synthetic */ FaqProjection(Id id, String string, Id id2, Id id3, List list, boolean bl, Instant instant, Instant instant2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    id = IdsKt.newId();
                }
                this((Id<FaqDefinition>)id, string, (Id<IntentDefinition>)id2, (Id<I18nLabel>)id3, list, bl, instant, instant2);
            }

            public final Id<FaqDefinition> get_id() {
                return this._id;
            }

            public final String getBotId() {
                return this.botId;
            }

            public final Id<IntentDefinition> getIntentId() {
                return this.intentId;
            }

            public final Id<I18nLabel> getI18nId() {
                return this.i18nId;
            }

            public final List<String> getTags() {
                return this.tags;
            }

            public final boolean getEnabled() {
                return this.enabled;
            }

            public final Instant getCreationDate() {
                return this.creationDate;
            }

            public final Instant getUpdateDate() {
                return this.updateDate;
            }

            public final Id<FaqDefinition> component1() {
                return this._id;
            }

            public final String component2() {
                return this.botId;
            }

            public final Id<IntentDefinition> component3() {
                return this.intentId;
            }

            public final Id<I18nLabel> component4() {
                return this.i18nId;
            }

            public final List<String> component5() {
                return this.tags;
            }

            public final boolean component6() {
                return this.enabled;
            }

            public final Instant component7() {
                return this.creationDate;
            }

            public final Instant component8() {
                return this.updateDate;
            }

            public final FaqProjection copy(Id<FaqDefinition> _id2, String botId, Id<IntentDefinition> intentId, Id<I18nLabel> i18nId, List<String> tags, boolean enabled, Instant creationDate, Instant updateDate) {
                Intrinsics.checkNotNullParameter(_id2, (String)"_id");
                Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
                Intrinsics.checkNotNullParameter(intentId, (String)"intentId");
                Intrinsics.checkNotNullParameter(i18nId, (String)"i18nId");
                Intrinsics.checkNotNullParameter(tags, (String)"tags");
                Intrinsics.checkNotNullParameter((Object)creationDate, (String)"creationDate");
                Intrinsics.checkNotNullParameter((Object)updateDate, (String)"updateDate");
                return new FaqProjection(_id2, botId, intentId, i18nId, tags, enabled, creationDate, updateDate);
            }

            public static /* synthetic */ FaqProjection copy$default(FaqProjection faqProjection, Id id, String string, Id id2, Id id3, List list, boolean bl, Instant instant, Instant instant2, int n, Object object) {
                if ((n & 1) != 0) {
                    id = faqProjection._id;
                }
                if ((n & 2) != 0) {
                    string = faqProjection.botId;
                }
                if ((n & 4) != 0) {
                    id2 = faqProjection.intentId;
                }
                if ((n & 8) != 0) {
                    id3 = faqProjection.i18nId;
                }
                if ((n & 0x10) != 0) {
                    list = faqProjection.tags;
                }
                if ((n & 0x20) != 0) {
                    bl = faqProjection.enabled;
                }
                if ((n & 0x40) != 0) {
                    instant = faqProjection.creationDate;
                }
                if ((n & 0x80) != 0) {
                    instant2 = faqProjection.updateDate;
                }
                return faqProjection.copy(id, string, id2, id3, list, bl, instant, instant2);
            }

            public String toString() {
                return "FaqProjection(_id=" + this._id + ", botId=" + this.botId + ", intentId=" + this.intentId + ", i18nId=" + this.i18nId + ", tags=" + this.tags + ", enabled=" + this.enabled + ", creationDate=" + this.creationDate + ", updateDate=" + this.updateDate + ")";
            }

            public int hashCode() {
                int result2 = this._id.hashCode();
                result2 = result2 * 31 + this.botId.hashCode();
                result2 = result2 * 31 + this.intentId.hashCode();
                result2 = result2 * 31 + this.i18nId.hashCode();
                result2 = result2 * 31 + ((Object)this.tags).hashCode();
                result2 = result2 * 31 + Boolean.hashCode(this.enabled);
                result2 = result2 * 31 + this.creationDate.hashCode();
                result2 = result2 * 31 + this.updateDate.hashCode();
                return result2;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FaqProjection)) {
                    return false;
                }
                FaqProjection faqProjection = (FaqProjection)other;
                if (!Intrinsics.areEqual(this._id, faqProjection._id)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.botId, (Object)faqProjection.botId)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.intentId, faqProjection.intentId)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.i18nId, faqProjection.i18nId)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.tags, faqProjection.tags)) {
                    return false;
                }
                if (this.enabled != faqProjection.enabled) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.creationDate, (Object)faqProjection.creationDate)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.updateDate, (Object)faqProjection.updateDate);
            }
        }
        AggregateIterable aggregateIterable = $this$aggregate$iv.aggregate(ArraysKt.toList((Object[])pipeline$iv), FaqProjection.class);
        Intrinsics.checkNotNullExpressionValue((Object)aggregateIterable, (String)"aggregate(...)");
        MongoIterable $this$forEach$iv = (MongoIterable)aggregateIterable;
        boolean $i$f$forEach = false;
        $this$forEach$iv.forEach(new Consumer(intentIdSupplier){
            final /* synthetic */ Function1 $intentIdSupplier$inlined;
            {
                this.$intentIdSupplier$inlined = function1;
            }

            public final void accept(T it) {
                FaqProjection projection = (FaqProjection)it;
                boolean bl = false;
                ThreadsKt.thread$default((boolean)true, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(projection, (Function1<? super Id<IntentDefinition>, String>)this.$intentIdSupplier$inlined){
                    final /* synthetic */ FaqProjection $projection;
                    final /* synthetic */ Function1<Id<IntentDefinition>, String> $intentIdSupplier;
                    {
                        this.$projection = $projection;
                        this.$intentIdSupplier = $intentIdSupplier;
                    }

                    public final void invoke() {
                        FaqProjection faqProjection = this.$projection;
                        Function1<Id<IntentDefinition>, String> function1 = this.$intentIdSupplier;
                        FaqProjection faqProjection2 = this.$projection;
                        FaqProjection $this$invoke_u24lambda_u240 = faqProjection;
                        boolean bl = false;
                        String string = (String)function1.invoke($this$invoke_u24lambda_u240.getIntentId());
                        if (string == null) {
                            throw new Exception("Fail to migrate Faq with intent " + $this$invoke_u24lambda_u240.getIntentId() + "  due to namespace not found with id " + $this$invoke_u24lambda_u240.getIntentId());
                        }
                        String namespace = string;
                        FaqDefinitionMongoDAO.access$getLogger$p().info((Function0)new Function0<Object>(faqProjection2, namespace){
                            final /* synthetic */ FaqProjection $projection;
                            final /* synthetic */ String $namespace;
                            {
                                this.$projection = $projection;
                                this.$namespace = $namespace;
                            }

                            public final Object invoke() {
                                return "Migrate FaqDefinition " + this.$projection.get_id() + " with namespace " + this.$namespace;
                            }
                        });
                        FaqDefinition faq = new FaqDefinition($this$invoke_u24lambda_u240.get_id(), $this$invoke_u24lambda_u240.getBotId(), namespace, $this$invoke_u24lambda_u240.getIntentId(), $this$invoke_u24lambda_u240.getI18nId(), $this$invoke_u24lambda_u240.getTags(), $this$invoke_u24lambda_u240.getEnabled(), $this$invoke_u24lambda_u240.getCreationDate(), $this$invoke_u24lambda_u240.getUpdateDate());
                        boolean bl2 = false;
                        MongoCollectionsKt.save(FaqDefinitionMongoDAO.INSTANCE.getCol$tock_nlp_front_storage_mongo(), (Object)faq);
                    }
                }), (int)30, null);
            }
        });
    }

    private final ArrayList<Bson> prepareFaqDetailBaseAggregation(FaqQuery query2, ApplicationDefinition applicationDefinition, List<? extends Id<I18nLabel>> i18nIds) {
        FaqQuery $this$prepareFaqDetailBaseAggregation_u24lambda_u2412 = query2;
        boolean bl = false;
        Object[] objectArray = new Bson[6];
        KProperty[] kPropertyArray = new KProperty[]{prepareFaqDetailBaseAggregation.1.1.INSTANCE};
        objectArray[0] = INSTANCE.sortAscending(kPropertyArray);
        objectArray[1] = INSTANCE.joinOnIntentDefinition();
        objectArray[2] = INSTANCE.joinOnClassifiedSentenceStatusNotDeleted($this$prepareFaqDetailBaseAggregation_u24lambda_u2412, (Id<ApplicationDefinition>)applicationDefinition.get_id());
        objectArray[3] = AggregatesKt.unwind$default((KProperty)((KProperty)prepareFaqDetailBaseAggregation.1.2.INSTANCE), null, (int)1, null);
        kPropertyArray = new Bson[2];
        Bson[] bsonArray = new Bson[]{INSTANCE.filterTextSearchOnFaqTitle($this$prepareFaqDetailBaseAggregation_u24lambda_u2412), INSTANCE.filterTextSearchOnFaqDescription($this$prepareFaqDetailBaseAggregation_u24lambda_u2412), INSTANCE.filterTextSearchOnClassifiedSentence($this$prepareFaqDetailBaseAggregation_u24lambda_u2412), INSTANCE.filterI18nIds($this$prepareFaqDetailBaseAggregation_u24lambda_u2412, i18nIds)};
        kPropertyArray[0] = INSTANCE.orNotNull(bsonArray);
        bsonArray = new Bson[]{INSTANCE.filterOnBotId(applicationDefinition.getName()), INSTANCE.filterTags($this$prepareFaqDetailBaseAggregation_u24lambda_u2412), INSTANCE.filterEnabled($this$prepareFaqDetailBaseAggregation_u24lambda_u2412)};
        kPropertyArray[1] = INSTANCE.andNotNull(bsonArray);
        objectArray[4] = AggregatesKt.match((Bson)INSTANCE.andNotNull((Bson[])kPropertyArray));
        kPropertyArray = new KProperty[]{prepareFaqDetailBaseAggregation.1.3.INSTANCE};
        objectArray[5] = INSTANCE.sortDescending(kPropertyArray);
        return CollectionsKt.arrayListOf((Object[])objectArray);
    }

    private final ArrayList<Bson> prepareFaqDetailBaseAggregationDocumentDb(FaqQuery query2, ApplicationDefinition applicationDefinition, List<? extends Id<I18nLabel>> i18nIds) {
        FaqQuery $this$prepareFaqDetailBaseAggregationDocumentDb_u24lambda_u2413 = query2;
        boolean bl = false;
        Object[] objectArray = new Bson[7];
        KProperty[] kPropertyArray = new KProperty[]{prepareFaqDetailBaseAggregationDocumentDb.1.1.INSTANCE};
        objectArray[0] = INSTANCE.sortAscending(kPropertyArray);
        objectArray[1] = INSTANCE.joinOnIntentDefinition();
        objectArray[2] = INSTANCE.joinOnClassifiedSentence($this$prepareFaqDetailBaseAggregationDocumentDb_u24lambda_u2413);
        objectArray[3] = AggregatesKt.unwind$default((KProperty)((KProperty)prepareFaqDetailBaseAggregationDocumentDb.1.2.INSTANCE), null, (int)1, null);
        kPropertyArray = new Bson[2];
        Bson[] bsonArray = new Bson[]{INSTANCE.filterOnBotId(applicationDefinition.getName()), INSTANCE.filterTags($this$prepareFaqDetailBaseAggregationDocumentDb_u24lambda_u2413), INSTANCE.filterEnabled($this$prepareFaqDetailBaseAggregationDocumentDb_u24lambda_u2413), INSTANCE.filterCurrentApplicationClassifiedSentence($this$prepareFaqDetailBaseAggregationDocumentDb_u24lambda_u2413, (Id<ApplicationDefinition>)applicationDefinition.get_id()), INSTANCE.filterNotDeletedClassifiedSentencesStatus($this$prepareFaqDetailBaseAggregationDocumentDb_u24lambda_u2413)};
        kPropertyArray[0] = INSTANCE.andNotNull(bsonArray);
        bsonArray = new Bson[]{INSTANCE.filterTextSearchOnFaqTitle($this$prepareFaqDetailBaseAggregationDocumentDb_u24lambda_u2413), INSTANCE.filterTextSearchOnFaqDescription($this$prepareFaqDetailBaseAggregationDocumentDb_u24lambda_u2413), INSTANCE.filterTextSearchOnClassifiedSentence($this$prepareFaqDetailBaseAggregationDocumentDb_u24lambda_u2413), INSTANCE.filterI18nIds($this$prepareFaqDetailBaseAggregationDocumentDb_u24lambda_u2413, i18nIds)};
        kPropertyArray[1] = INSTANCE.orNotNull(bsonArray);
        objectArray[4] = AggregatesKt.match((Bson)INSTANCE.andNotNull((Bson[])kPropertyArray));
        objectArray[5] = INSTANCE.groupFaqDefinitionDetailedData($this$prepareFaqDetailBaseAggregationDocumentDb_u24lambda_u2413);
        kPropertyArray = new KProperty[]{prepareFaqDetailBaseAggregationDocumentDb.1.3.INSTANCE};
        objectArray[6] = INSTANCE.sortDescending(kPropertyArray);
        return CollectionsKt.arrayListOf((Object[])objectArray);
    }

    private final Bson filterTextSearchOnFaqTitle(FaqQuery $this$filterTextSearchOnFaqTitle) {
        Bson bson;
        if ($this$filterTextSearchOnFaqTitle.getSearch() == null) {
            bson = null;
        } else {
            KProperty kProperty = (KProperty)PropertiesKt.div((KProperty1)((KProperty1)filterTextSearchOnFaqTitle.1.INSTANCE), (KProperty1)((KProperty1)filterTextSearchOnFaqTitle.2.INSTANCE));
            String string = $this$filterTextSearchOnFaqTitle.getSearch();
            Intrinsics.checkNotNull((Object)string);
            bson = FiltersKt.regex((KProperty)kProperty, (String)string, (String)"i");
        }
        return bson;
    }

    private final Bson filterTextSearchOnFaqDescription(FaqQuery $this$filterTextSearchOnFaqDescription) {
        Bson bson;
        if ($this$filterTextSearchOnFaqDescription.getSearch() == null) {
            bson = null;
        } else {
            KProperty kProperty = (KProperty)PropertiesKt.div((KProperty1)((KProperty1)filterTextSearchOnFaqDescription.1.INSTANCE), (KProperty1)((KProperty1)filterTextSearchOnFaqDescription.2.INSTANCE));
            String string = $this$filterTextSearchOnFaqDescription.getSearch();
            Intrinsics.checkNotNull((Object)string);
            bson = FiltersKt.regex((KProperty)kProperty, (String)string, (String)"i");
        }
        return bson;
    }

    private final Bson filterTextSearchOnClassifiedSentence(FaqQuery $this$filterTextSearchOnClassifiedSentence) {
        Bson bson;
        if ($this$filterTextSearchOnClassifiedSentence.getSearch() == null) {
            bson = null;
        } else {
            KProperty kProperty = (KProperty)PropertiesKt.divCol((KProperty1)((KProperty1)filterTextSearchOnClassifiedSentence.1.INSTANCE), (KProperty1)((KProperty1)filterTextSearchOnClassifiedSentence.2.INSTANCE));
            String string = $this$filterTextSearchOnClassifiedSentence.getSearch();
            Intrinsics.checkNotNull((Object)string);
            bson = FiltersKt.regex((KProperty)kProperty, (String)string, (String)"i");
        }
        return bson;
    }

    private final Bson filterCurrentApplicationClassifiedSentence(FaqQuery $this$filterCurrentApplicationClassifiedSentence, Id<ApplicationDefinition> currentApplicationId) {
        return FiltersKt.eq((KProperty)((KProperty)PropertiesKt.divCol((KProperty1)((KProperty1)filterCurrentApplicationClassifiedSentence.1.INSTANCE), (KProperty1)((KProperty1)filterCurrentApplicationClassifiedSentence.2.INSTANCE))), currentApplicationId);
    }

    private final Bson filterNotDeletedClassifiedSentencesStatus(FaqQuery $this$filterNotDeletedClassifiedSentencesStatus) {
        return FiltersKt.ne((KProperty)((KProperty)PropertiesKt.divCol((KProperty1)((KProperty1)filterNotDeletedClassifiedSentencesStatus.1.INSTANCE), (KProperty1)((KProperty1)filterNotDeletedClassifiedSentencesStatus.2.INSTANCE))), (Object)ClassifiedSentenceStatus.deleted);
    }

    private final Bson filterI18nIds(FaqQuery $this$filterI18nIds, List<? extends Id<I18nLabel>> i18nIds) {
        return i18nIds == null ? null : FiltersKt.in((KProperty)((KProperty)filterI18nIds.1.INSTANCE), (Iterable)i18nIds);
    }

    private final Bson filterTags(FaqQuery $this$filterTags) {
        return $this$filterTags.getTags().isEmpty() ? null : FiltersKt.inArray((KProperty)((KProperty)filterTags.1.INSTANCE), (Iterable)$this$filterTags.getTags());
    }

    private final Bson filterEnabled(FaqQuery $this$filterEnabled) {
        return $this$filterEnabled.getEnabled() == null ? null : FiltersKt.eq((KProperty)((KProperty)filterEnabled.1.INSTANCE), (Object)$this$filterEnabled.getEnabled());
    }

    private final Bson filterOnBotId(String botId) {
        return FiltersKt.eq((KProperty)((KProperty)filterOnBotId.1.INSTANCE), (Object)botId);
    }

    private final Bson groupFaqDefinitionDetailedData(FaqQuery $this$groupFaqDefinitionDetailedData) {
        Object[] objectArray = new BsonField[]{AccumulatorsKt.first((KProperty)((KProperty)groupFaqDefinitionDetailedData.2.INSTANCE), (Object)((Object)groupFaqDefinitionDetailedData.3.INSTANCE)), AccumulatorsKt.first((KProperty)((KProperty)groupFaqDefinitionDetailedData.4.INSTANCE), (Object)((Object)groupFaqDefinitionDetailedData.5.INSTANCE)), AccumulatorsKt.first((KProperty)((KProperty)groupFaqDefinitionDetailedData.6.INSTANCE), (Object)((Object)groupFaqDefinitionDetailedData.7.INSTANCE)), AccumulatorsKt.first((KProperty)((KProperty)groupFaqDefinitionDetailedData.8.INSTANCE), (Object)((Object)groupFaqDefinitionDetailedData.9.INSTANCE)), AccumulatorsKt.first((KProperty)((KProperty)groupFaqDefinitionDetailedData.10.INSTANCE), (Object)((Object)groupFaqDefinitionDetailedData.11.INSTANCE)), AccumulatorsKt.first((KProperty)((KProperty)groupFaqDefinitionDetailedData.12.INSTANCE), (Object)((Object)groupFaqDefinitionDetailedData.13.INSTANCE)), AccumulatorsKt.first((KProperty)((KProperty)groupFaqDefinitionDetailedData.14.INSTANCE), (Object)((Object)groupFaqDefinitionDetailedData.15.INSTANCE)), AccumulatorsKt.first((KProperty)((KProperty)groupFaqDefinitionDetailedData.16.INSTANCE), (Object)((Object)groupFaqDefinitionDetailedData.17.INSTANCE)), AccumulatorsKt.first((KProperty)((KProperty)groupFaqDefinitionDetailedData.18.INSTANCE), (Object)((Object)groupFaqDefinitionDetailedData.19.INSTANCE)), AccumulatorsKt.first((KProperty)((KProperty)groupFaqDefinitionDetailedData.20.INSTANCE), (Object)((Object)groupFaqDefinitionDetailedData.21.INSTANCE))};
        return AggregatesKt.group((Object)((Object)groupFaqDefinitionDetailedData.1.INSTANCE), (List)CollectionsKt.listOf((Object[])objectArray));
    }

    private final Bson joinOnIntentDefinition() {
        return AggregatesKt.lookup((String)INTENT_DEFINITION_COLLECTION, (String)"intentId", (String)"_id", (String)"faq");
    }

    private final Bson joinOnClassifiedSentence(FaqQuery $this$joinOnClassifiedSentence) {
        return AggregatesKt.lookup((String)CLASSIFIED_SENTENCE_COLLECTION, (String)"intentId", (String)PropertiesKt.div((KProperty1)((KProperty1)joinOnClassifiedSentence.1.INSTANCE), (KProperty1)((KProperty1)joinOnClassifiedSentence.2.INSTANCE)).getName(), (String)"utterances");
    }

    private final Bson joinOnClassifiedSentenceStatusNotDeleted(FaqQuery $this$joinOnClassifiedSentenceStatusNotDeleted, Id<ApplicationDefinition> applicationId) {
        Bson[] bsonArray = new Bson[1];
        Object[] objectArray = new Bson[3];
        Object[] objectArray2 = new Object[]{PropertiesKt.div((KProperty1)((KProperty1)joinOnClassifiedSentenceStatusNotDeleted.3.INSTANCE), (KProperty1)((KProperty1)joinOnClassifiedSentenceStatusNotDeleted.4.INSTANCE)), "$$faq_intentId"};
        objectArray[0] = ProjectionsKt.from((MongoOperator)MongoOperator.eq, (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new Object[]{joinOnClassifiedSentenceStatusNotDeleted.5.INSTANCE, applicationId};
        objectArray[1] = ProjectionsKt.from((MongoOperator)MongoOperator.eq, (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new Object[]{joinOnClassifiedSentenceStatusNotDeleted.6.INSTANCE, ClassifiedSentenceStatus.deleted};
        objectArray[2] = ProjectionsKt.from((MongoOperator)MongoOperator.ne, (Object)CollectionsKt.listOf((Object[])objectArray2));
        bsonArray[0] = AggregatesKt.match((Bson)FiltersKt.expr((Object)ProjectionsKt.from((MongoOperator)MongoOperator.and, (Object)CollectionsKt.listOf((Object[])objectArray))));
        return AggregatesKt.lookup((String)CLASSIFIED_SENTENCE_COLLECTION, (List)CollectionsKt.listOf((Object)new Variable(FAQ_INTENTID, (Object)joinOnClassifiedSentenceStatusNotDeleted.1.INSTANCE)), (KProperty)((KProperty)joinOnClassifiedSentenceStatusNotDeleted.2.INSTANCE), (Bson[])bsonArray);
    }

    private final Bson groupByTag() {
        BsonField[] bsonFieldArray = new BsonField[]{AccumulatorsKt.first((KProperty)((KProperty)groupByTag.2.INSTANCE), (Object)((Object)groupByTag.3.INSTANCE))};
        return AggregatesKt.group((Object)((Object)groupByTag.1.INSTANCE), (BsonField[])bsonFieldArray);
    }

    private final Bson projectByTag() {
        Bson[] bsonArray = new Bson[2];
        bsonArray[0] = ProjectionsKt.excludeId();
        Bson[] bsonArray2 = new Bson[]{ProjectionsKt.from((KProperty)((KProperty)projectByTag.1.INSTANCE), (Object)((Object)projectByTag.2.INSTANCE))};
        bsonArray[1] = AggregatesKt.document((Bson[])bsonArray2);
        return AggregatesKt.project((Bson[])bsonArray);
    }

    private final Bson orNotNull(Bson ... predicates) {
        return FiltersKt.or((Iterable)ArraysKt.filterNotNull((Object[])predicates));
    }

    private final Bson andNotNull(Bson ... predicates) {
        return FiltersKt.and((Iterable)ArraysKt.filterNotNull((Object[])predicates));
    }

    private final Bson sortAscending(KProperty<?> ... properties) {
        return AggregatesKt.sort((Bson)SortsKt.ascending((List)ArraysKt.asList((Object[])properties)));
    }

    private final Bson sortDescending(KProperty<?> ... properties) {
        return AggregatesKt.sort((Bson)SortsKt.descending((List)ArraysKt.asList((Object[])properties)));
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final com.mongodb.client.MongoCollection col_delegate$lambda$2() {
        com.mongodb.client.MongoCollection mongoCollection;
        MongoDatabase $this$getCollection$iv = MongoFrontConfiguration.INSTANCE.getDatabase();
        boolean $i$f$getCollection = false;
        com.mongodb.client.MongoCollection mongoCollection2 = $this$getCollection$iv.getCollection(KMongoUtil.INSTANCE.defaultCollectionName(Reflection.getOrCreateKotlinClass(FaqDefinition.class)), FaqDefinition.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection2, (String)"getCollection(...)");
        com.mongodb.client.MongoCollection $this$col_delegate_u24lambda_u242_u24lambda_u241 = mongoCollection = mongoCollection2;
        boolean bl = false;
        KProperty[] kPropertyArray = new KProperty[]{col.2.c.1.1.INSTANCE, col.2.c.1.2.INSTANCE, col.2.c.1.3.INSTANCE, col.2.c.1.4.INSTANCE};
        MongoCollectionsKt.ensureUniqueIndex$default((com.mongodb.client.MongoCollection)$this$col_delegate_u24lambda_u242_u24lambda_u241, (KProperty[])kPropertyArray, null, (int)2, null);
        kPropertyArray = new KProperty[]{col.2.c.1.5.INSTANCE, col.2.c.1.6.INSTANCE, col.2.c.1.7.INSTANCE};
        MongosKt.ensureIndex$default((com.mongodb.client.MongoCollection)$this$col_delegate_u24lambda_u242_u24lambda_u241, (KProperty[])kPropertyArray, null, (int)2, null);
        kPropertyArray = new KProperty[]{col.2.c.1.8.INSTANCE, col.2.c.1.9.INSTANCE, col.2.c.1.10.INSTANCE};
        MongosKt.ensureIndex$default((com.mongodb.client.MongoCollection)$this$col_delegate_u24lambda_u242_u24lambda_u241, (KProperty[])kPropertyArray, null, (int)2, null);
        com.mongodb.client.MongoCollection c2 = mongoCollection;
        return c2;
    }

    private static final MongoCollection asyncCol_delegate$lambda$3() {
        com.mongodb.reactivestreams.client.MongoDatabase $this$getCollection$iv = MongoFrontConfiguration.INSTANCE.getAsyncDatabase();
        boolean $i$f$getCollection = false;
        MongoCollection mongoCollection = $this$getCollection$iv.getCollection(KMongoUtil.INSTANCE.defaultCollectionName(Reflection.getOrCreateKotlinClass(FaqDefinition.class)), FaqDefinition.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        return mongoCollection;
    }

    private static final Unit listenFaqDefinitionChanges$lambda$4(Function0 $listener, ChangeStreamDocument it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $listener.invoke();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object getFaqDetailsWithCount$lambda$9$lambda$6(ArrayList $baseAggregation) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $baseAggregation;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Bson bson = (Bson)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SharedExtensionsKt.getJson((Object)it));
        }
        return (List)destination$iv$iv;
    }

    private static final Object getFaqDetailsWithCount$lambda$9$lambda$7(int $count) {
        return "count : " + $count;
    }

    private static final String getTags$lambda$10(FaqDefinitionTag it) {
        return it.getTag();
    }

    public static final /* synthetic */ KLogger access$getLogger$p() {
        return logger;
    }
}

