/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.front.storage.mongo;

import ai.tock.nlp.front.service.storage.IntentDefinitionDAO;
import ai.tock.nlp.front.shared.config.ApplicationDefinition;
import ai.tock.nlp.front.shared.config.IntentDefinition;
import ai.tock.nlp.front.shared.config.IntentDefinition_;
import ai.tock.nlp.front.storage.mongo.IntentDefinitionMongoDAO$listenIntentDefinitionChanges$;
import ai.tock.nlp.front.storage.mongo.MongoFrontConfiguration;
import ai.tock.shared.MongosKt;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.KMongoIterableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.Id;
import org.litote.kmongo.MongoCollectionsKt;
import org.litote.kmongo.reactivestreams.MongoSharedCollectionsKt;
import org.litote.kmongo.util.KMongoUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0016J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u001d\u001a\u00020\u001bH\u0016J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001bH\u0016J\u0018\u0010 \u001a\u0004\u0018\u00010\u00062\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017H\u0016J$\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00152\u0012\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00170$H\u0016J\u0010\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u0006H\u0016J\u0016\u0010'\u001a\u00020\u00112\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017H\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010)\u001a\u00020\u001bH\u0016J\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0015R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000e\u00a8\u0006,"}, d2={"Lai/tock/nlp/front/storage/mongo/IntentDefinitionMongoDAO;", "Lai/tock/nlp/front/service/storage/IntentDefinitionDAO;", "<init>", "()V", "col", "Lcom/mongodb/client/MongoCollection;", "Lai/tock/nlp/front/shared/config/IntentDefinition;", "getCol", "()Lcom/mongodb/client/MongoCollection;", "col$delegate", "Lkotlin/Lazy;", "asyncCol", "Lcom/mongodb/reactivestreams/client/MongoCollection;", "getAsyncCol", "()Lcom/mongodb/reactivestreams/client/MongoCollection;", "asyncCol$delegate", "listenIntentDefinitionChanges", "", "listener", "Lkotlin/Function0;", "getIntentsByApplicationId", "", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "getIntentsByNamespace", "namespace", "", "getIntentsByApplicationIdAndCategory", "category", "getIntentByNamespaceAndName", "name", "getIntentById", "id", "getIntentByIds", "ids", "", "save", "intent", "deleteIntentById", "getIntentsUsingEntity", "entityType", "getIntentsByNames", "names", "tock-nlp-front-storage-mongo"})
@SourceDebugExtension(value={"SMAP\nIntentDefinitionMongoDAO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntentDefinitionMongoDAO.kt\nai/tock/nlp/front/storage/mongo/IntentDefinitionMongoDAO\n+ 2 Mongos.kt\nai/tock/shared/MongosKt\n+ 3 MongoSharedCollections.kt\norg/litote/kmongo/reactivestreams/MongoSharedCollectionsKt\n+ 4 MongoDatabases.kt\norg/litote/kmongo/MongoDatabasesKt\n+ 5 MongoSharedDatabases.kt\norg/litote/kmongo/reactivestreams/MongoSharedDatabasesKt\n*L\n1#1,105:1\n232#2,5:106\n243#2:130\n60#3,19:111\n61#4:131\n52#5:132\n*S KotlinDebug\n*F\n+ 1 IntentDefinitionMongoDAO.kt\nai/tock/nlp/front/storage/mongo/IntentDefinitionMongoDAO\n*L\n64#1:106,5\n64#1:130\n64#1:111,19\n53#1:131\n60#1:132\n*E\n"})
public final class IntentDefinitionMongoDAO
implements IntentDefinitionDAO {
    @NotNull
    public static final IntentDefinitionMongoDAO INSTANCE = new IntentDefinitionMongoDAO();
    @NotNull
    private static final Lazy col$delegate = LazyKt.lazy(IntentDefinitionMongoDAO::col_delegate$lambda$0);
    @NotNull
    private static final Lazy asyncCol$delegate = LazyKt.lazy(IntentDefinitionMongoDAO::asyncCol_delegate$lambda$1);

    private IntentDefinitionMongoDAO() {
    }

    private final MongoCollection<IntentDefinition> getCol() {
        Lazy lazy = col$delegate;
        return (MongoCollection)lazy.getValue();
    }

    private final com.mongodb.reactivestreams.client.MongoCollection<IntentDefinition> getAsyncCol() {
        Lazy lazy = asyncCol$delegate;
        return (com.mongodb.reactivestreams.client.MongoCollection)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void listenIntentDefinitionChanges(@NotNull Function0<Unit> listener) {
        void errorListener$iv$iv;
        void subscribeListener$iv$iv;
        void $this$watchIndefinitely_u24default$iv$iv;
        void $this$watch_u24default$iv;
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        com.mongodb.reactivestreams.client.MongoCollection<IntentDefinition> mongoCollection = this.getAsyncCol();
        Function1 listener$iv = arg_0 -> IntentDefinitionMongoDAO.listenIntentDefinitionChanges$lambda$2(listener, arg_0);
        FullDocument fullDocument$iv = FullDocument.DEFAULT;
        boolean $i$f$watch = false;
        void var6_6 = $this$watch_u24default$iv;
        Function0 function0 = listenIntentDefinitionChanges$$inlined$watch$default$1.INSTANCE;
        Function1 function1 = listenIntentDefinitionChanges$$inlined$watch$default$2.INSTANCE;
        Function0 reopenListener$iv$iv = listenIntentDefinitionChanges$$inlined$watch$default$3.INSTANCE;
        long reopenDelayInMS$iv$iv = 5000L;
        boolean $i$f$watchIndefinitely = false;
        MongoSharedCollectionsKt.watchIndefinitely((com.mongodb.reactivestreams.client.MongoCollection)$this$watchIndefinitely_u24default$iv$iv, (Function1)((Function1)new Function1<com.mongodb.reactivestreams.client.MongoCollection<IntentDefinition>, ChangeStreamPublisher<IntentDefinition>>((com.mongodb.reactivestreams.client.MongoCollection)$this$watchIndefinitely_u24default$iv$iv, fullDocument$iv){
            final /* synthetic */ com.mongodb.reactivestreams.client.MongoCollection $this_watchIndefinitely;
            final /* synthetic */ FullDocument $fullDocument;
            {
                this.$this_watchIndefinitely = $receiver;
                this.$fullDocument = $fullDocument;
            }

            public final ChangeStreamPublisher<IntentDefinition> invoke(com.mongodb.reactivestreams.client.MongoCollection<IntentDefinition> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                ChangeStreamPublisher changeStreamPublisher = this.$this_watchIndefinitely.watch(IntentDefinition.class).fullDocument(this.$fullDocument);
                Intrinsics.checkNotNullExpressionValue((Object)changeStreamPublisher, (String)"fullDocument(...)");
                return changeStreamPublisher;
            }
        }), (Function0)subscribeListener$iv$iv, (Function1)errorListener$iv$iv, (Function0)reopenListener$iv$iv, (long)reopenDelayInMS$iv$iv, (Function1)listener$iv);
    }

    @NotNull
    public List<IntentDefinition> getIntentsByApplicationId(@NotNull Id<ApplicationDefinition> applicationId) {
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        FindIterable findIterable = this.getCol().find(FiltersKt.contains((KProperty)((KProperty)IntentDefinition_.Companion.getApplications()), applicationId));
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"find(...)");
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable));
    }

    @NotNull
    public List<IntentDefinition> getIntentsByNamespace(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        FindIterable findIterable = this.getCol().find(FiltersKt.eq((KProperty)((KProperty)IntentDefinition_.Companion.getNamespace()), (Object)namespace));
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"find(...)");
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable));
    }

    @NotNull
    public List<IntentDefinition> getIntentsByApplicationIdAndCategory(@NotNull Id<ApplicationDefinition> applicationId, @NotNull String category) {
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        FindIterable findIterable = this.getCol().find(FiltersKt.contains((KProperty)((KProperty)IntentDefinition_.Companion.getApplications()), applicationId)).filter(FiltersKt.eq((KProperty)((KProperty)IntentDefinition_.Companion.getCategory()), (Object)category));
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"filter(...)");
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable));
    }

    @Nullable
    public IntentDefinition getIntentByNamespaceAndName(@NotNull String namespace, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)IntentDefinition_.Companion.getName()), (Object)name), FiltersKt.eq((KProperty)((KProperty)IntentDefinition_.Companion.getNamespace()), (Object)namespace)};
        return (IntentDefinition)MongoCollectionsKt.findOne(this.getCol(), (Bson[])bsonArray);
    }

    @Nullable
    public IntentDefinition getIntentById(@NotNull Id<IntentDefinition> id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        return (IntentDefinition)MongoCollectionsKt.findOneById(this.getCol(), id);
    }

    @Nullable
    public List<IntentDefinition> getIntentByIds(@NotNull Set<? extends Id<IntentDefinition>> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        return (List)this.getCol().find(FiltersKt.in((KProperty)((KProperty)IntentDefinition_.Companion.get_id()), (Iterable)ids)).into((Collection)new ArrayList());
    }

    public void save(@NotNull IntentDefinition intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        MongoCollectionsKt.save(this.getCol(), (Object)intent);
    }

    public void deleteIntentById(@NotNull Id<IntentDefinition> id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        MongoCollectionsKt.deleteOneById(this.getCol(), id);
    }

    @NotNull
    public List<IntentDefinition> getIntentsUsingEntity(@NotNull String entityType) {
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        FindIterable findIterable = this.getCol().find(FiltersKt.eq((KProperty)((KProperty)IntentDefinition_.Companion.getEntities().getEntityTypeName()), (Object)entityType));
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"find(...)");
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable));
    }

    @NotNull
    public final List<IntentDefinition> getIntentsByNames(@NotNull List<String> names) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        FindIterable findIterable = this.getCol().find(FiltersKt.in((KProperty)((KProperty)IntentDefinition_.Companion.getName()), (Iterable)names));
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"find(...)");
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable));
    }

    private static final MongoCollection col_delegate$lambda$0() {
        MongoDatabase $this$getCollection$iv = MongoFrontConfiguration.INSTANCE.getDatabase();
        boolean $i$f$getCollection = false;
        MongoCollection mongoCollection = $this$getCollection$iv.getCollection(KMongoUtil.INSTANCE.defaultCollectionName(Reflection.getOrCreateKotlinClass(IntentDefinition.class)), IntentDefinition.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        MongoCollection c2 = mongoCollection;
        KProperty[] kPropertyArray = new KProperty[]{IntentDefinition_.Companion.getApplications()};
        MongosKt.ensureIndex$default((MongoCollection)c2, (KProperty[])kPropertyArray, null, (int)2, null);
        kPropertyArray = new KProperty[]{IntentDefinition_.Companion.getNamespace(), IntentDefinition_.Companion.getName()};
        MongosKt.ensureUniqueIndex$default((MongoCollection)c2, (KProperty[])kPropertyArray, null, (int)2, null);
        return c2;
    }

    private static final com.mongodb.reactivestreams.client.MongoCollection asyncCol_delegate$lambda$1() {
        com.mongodb.reactivestreams.client.MongoDatabase $this$getCollection$iv = MongoFrontConfiguration.INSTANCE.getAsyncDatabase();
        boolean $i$f$getCollection = false;
        com.mongodb.reactivestreams.client.MongoCollection mongoCollection = $this$getCollection$iv.getCollection(KMongoUtil.INSTANCE.defaultCollectionName(Reflection.getOrCreateKotlinClass(IntentDefinition.class)), IntentDefinition.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        return mongoCollection;
    }

    private static final Unit listenIntentDefinitionChanges$lambda$2(Function0 $listener, ChangeStreamDocument it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $listener.invoke();
        return Unit.INSTANCE;
    }
}

