/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.front.storage.mongo;

import ai.tock.nlp.front.service.storage.ModelBuildTriggerDAO;
import ai.tock.nlp.front.shared.build.ModelBuild;
import ai.tock.nlp.front.shared.build.ModelBuildQueryResult;
import ai.tock.nlp.front.shared.build.ModelBuildTrigger;
import ai.tock.nlp.front.shared.build.ModelBuildTrigger_;
import ai.tock.nlp.front.shared.build.ModelBuild_;
import ai.tock.nlp.front.shared.config.ApplicationDefinition;
import ai.tock.nlp.front.storage.mongo.MongoFrontConfiguration;
import ai.tock.shared.MongosKt;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.KMongoIterableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.FindIterablesKt;
import org.litote.kmongo.Id;
import org.litote.kmongo.MongoCollectionsKt;
import org.litote.kmongo.util.KMongoUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\fH\u0016J.\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\n\u001a\u0004\b\r\u0010\b\u00a8\u0006 "}, d2={"Lai/tock/nlp/front/storage/mongo/ModelBuildTriggerMongoDAO;", "Lai/tock/nlp/front/service/storage/ModelBuildTriggerDAO;", "<init>", "()V", "col", "Lcom/mongodb/client/MongoCollection;", "Lai/tock/nlp/front/shared/build/ModelBuildTrigger;", "getCol", "()Lcom/mongodb/client/MongoCollection;", "col$delegate", "Lkotlin/Lazy;", "modelCol", "Lai/tock/nlp/front/shared/build/ModelBuild;", "getModelCol", "modelCol$delegate", "save", "", "trigger", "deleteTrigger", "getTriggers", "", "build", "builds", "Lai/tock/nlp/front/shared/build/ModelBuildQueryResult;", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "language", "Ljava/util/Locale;", "start", "", "size", "tock-nlp-front-storage-mongo"})
@SourceDebugExtension(value={"SMAP\nModelBuildTriggerMongoDAO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelBuildTriggerMongoDAO.kt\nai/tock/nlp/front/storage/mongo/ModelBuildTriggerMongoDAO\n+ 2 MongoDatabases.kt\norg/litote/kmongo/MongoDatabasesKt\n*L\n1#1,97:1\n61#2:98\n61#2:99\n*S KotlinDebug\n*F\n+ 1 ModelBuildTriggerMongoDAO.kt\nai/tock/nlp/front/storage/mongo/ModelBuildTriggerMongoDAO\n*L\n44#1:98\n50#1:99\n*E\n"})
public final class ModelBuildTriggerMongoDAO
implements ModelBuildTriggerDAO {
    @NotNull
    public static final ModelBuildTriggerMongoDAO INSTANCE = new ModelBuildTriggerMongoDAO();
    @NotNull
    private static final Lazy col$delegate = LazyKt.lazy(ModelBuildTriggerMongoDAO::col_delegate$lambda$0);
    @NotNull
    private static final Lazy modelCol$delegate = LazyKt.lazy(ModelBuildTriggerMongoDAO::modelCol_delegate$lambda$1);

    private ModelBuildTriggerMongoDAO() {
    }

    private final MongoCollection<ModelBuildTrigger> getCol() {
        Lazy lazy = col$delegate;
        return (MongoCollection)lazy.getValue();
    }

    private final MongoCollection<ModelBuild> getModelCol() {
        Lazy lazy = modelCol$delegate;
        return (MongoCollection)lazy.getValue();
    }

    public void save(@NotNull ModelBuildTrigger trigger) {
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        MongoCollectionsKt.save(this.getCol(), (Object)trigger);
    }

    public void deleteTrigger(@NotNull ModelBuildTrigger trigger) {
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)ModelBuildTrigger_.Companion.getApplicationId()), (Object)trigger.getApplicationId()), FiltersKt.eq((KProperty)((KProperty)ModelBuildTrigger_.Companion.getOnlyIfModelNotExists()), (Object)trigger.getOnlyIfModelNotExists())};
        MongoCollectionsKt.deleteMany$default(this.getCol(), (Bson[])bsonArray, null, (int)2, null);
    }

    @NotNull
    public List<ModelBuildTrigger> getTriggers() {
        FindIterable findIterable = this.getCol().find();
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"find(...)");
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable));
    }

    public void save(@NotNull ModelBuild build) {
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        MongoCollectionsKt.save(this.getModelCol(), (Object)build);
    }

    @NotNull
    public ModelBuildQueryResult builds(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language, int start, int size) {
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        FindIterable findIterable = new FindIterable[]{FiltersKt.eq((KProperty)((KProperty)ModelBuild_.Companion.getApplicationId()), applicationId), FiltersKt.eq((KProperty)((KProperty)ModelBuild_.Companion.getLanguage()), (Object)language)};
        Bson filter = FiltersKt.and((Bson[])findIterable);
        long l = this.getModelCol().countDocuments(filter);
        FindIterable findIterable2 = this.getModelCol().find(filter);
        Intrinsics.checkNotNullExpressionValue((Object)findIterable2, (String)"find(...)");
        KProperty[] kPropertyArray = new KProperty[]{ModelBuild_.Companion.getDate()};
        findIterable = FindIterablesKt.descendingSort((FindIterable)findIterable2, (KProperty[])kPropertyArray).skip(start).limit(size);
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"limit(...)");
        return new ModelBuildQueryResult(l, KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable)));
    }

    private static final MongoCollection col_delegate$lambda$0() {
        MongoDatabase $this$getCollection$iv = MongoFrontConfiguration.INSTANCE.getDatabase();
        boolean $i$f$getCollection = false;
        MongoCollection mongoCollection = $this$getCollection$iv.getCollection(KMongoUtil.INSTANCE.defaultCollectionName(Reflection.getOrCreateKotlinClass(ModelBuildTrigger.class)), ModelBuildTrigger.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        MongoCollection c2 = mongoCollection;
        KProperty[] kPropertyArray = new KProperty[]{ModelBuildTrigger_.Companion.getApplicationId()};
        MongosKt.ensureIndex$default((MongoCollection)c2, (KProperty[])kPropertyArray, null, (int)2, null);
        return c2;
    }

    private static final MongoCollection modelCol_delegate$lambda$1() {
        MongoDatabase $this$getCollection$iv = MongoFrontConfiguration.INSTANCE.getDatabase();
        boolean $i$f$getCollection = false;
        MongoCollection mongoCollection = $this$getCollection$iv.getCollection(KMongoUtil.INSTANCE.defaultCollectionName(Reflection.getOrCreateKotlinClass(ModelBuild.class)), ModelBuild.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        MongoCollection c2 = mongoCollection;
        KProperty[] kPropertyArray = new KProperty[]{ModelBuild_.Companion.getApplicationId(), ModelBuild_.Companion.getLanguage()};
        MongosKt.ensureIndex$default((MongoCollection)c2, (KProperty[])kPropertyArray, null, (int)2, null);
        kPropertyArray = new KProperty[]{ModelBuild_.Companion.getApplicationId(), ModelBuild_.Companion.getLanguage(), ModelBuild_.Companion.getDate()};
        MongosKt.ensureIndex$default((MongoCollection)c2, (KProperty[])kPropertyArray, null, (int)2, null);
        return c2;
    }
}

