/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.front.storage.mongo;

import ai.tock.nlp.front.service.storage.ParseRequestLogDAO;
import ai.tock.nlp.front.shared.config.ApplicationDefinition;
import ai.tock.nlp.front.shared.config.SearchMark;
import ai.tock.nlp.front.shared.monitoring.ParseRequestExportLog;
import ai.tock.nlp.front.shared.monitoring.ParseRequestLog;
import ai.tock.nlp.front.shared.monitoring.ParseRequestLogCount;
import ai.tock.nlp.front.shared.monitoring.ParseRequestLogCountQuery;
import ai.tock.nlp.front.shared.monitoring.ParseRequestLogCountQueryResult;
import ai.tock.nlp.front.shared.monitoring.ParseRequestLogIntentStat;
import ai.tock.nlp.front.shared.monitoring.ParseRequestLogQuery;
import ai.tock.nlp.front.shared.monitoring.ParseRequestLogQueryResult;
import ai.tock.nlp.front.shared.monitoring.ParseRequestLogStat;
import ai.tock.nlp.front.shared.monitoring.ParseRequestLogStatQuery;
import ai.tock.nlp.front.shared.parser.ParseQuery;
import ai.tock.nlp.front.shared.parser.ParseResult;
import ai.tock.nlp.front.storage.mongo.ClassifiedSentenceMongoDAO;
import ai.tock.nlp.front.storage.mongo.DayAndYear_;
import ai.tock.nlp.front.storage.mongo.LogObfuscationService;
import ai.tock.nlp.front.storage.mongo.MongoFrontConfiguration;
import ai.tock.nlp.front.storage.mongo.MongoHelpersKt;
import ai.tock.nlp.front.storage.mongo.ParseRequestLogCol_;
import ai.tock.nlp.front.storage.mongo.ParseRequestLogIntentStatCol_;
import ai.tock.nlp.front.storage.mongo.ParseRequestLogStatCol_;
import ai.tock.nlp.front.storage.mongo.ParseRequestLogStatResult_;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.MongosKt;
import ai.tock.shared.PropertiesKt;
import com.mongodb.ReadPreference;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.ReturnDocument;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.KMongoIterableKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.AccumulatorsKt;
import org.litote.kmongo.AggregatesKt;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.FindIterablesKt;
import org.litote.kmongo.Id;
import org.litote.kmongo.IdsKt;
import org.litote.kmongo.MongoCollectionsKt;
import org.litote.kmongo.ProjectionsKt;
import org.litote.kmongo.SortsKt;
import org.litote.kmongo.UpdatesKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0005./012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001b\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020 H\u0016J$\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(H\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\"2\u0006\u0010\u001d\u001a\u00020+H\u0016J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\"2\u0006\u0010\u001d\u001a\u00020+H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000e\u001a\u0004\b\u0011\u0010\fR!\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\t8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000e\u001a\u0004\b\u0015\u0010\f\u00a8\u00063"}, d2={"Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO;", "Lai/tock/nlp/front/service/storage/ParseRequestLogDAO;", "<init>", "()V", "logger", "Lmu/KLogger;", "logObfuscationService", "Lai/tock/nlp/front/storage/mongo/LogObfuscationService;", "col", "Lcom/mongodb/client/MongoCollection;", "Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$ParseRequestLogCol;", "getCol$tock_nlp_front_storage_mongo", "()Lcom/mongodb/client/MongoCollection;", "col$delegate", "Lkotlin/Lazy;", "statsCol", "Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$ParseRequestLogStatCol;", "getStatsCol$tock_nlp_front_storage_mongo", "statsCol$delegate", "intentStatsCol", "Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$ParseRequestLogIntentStatCol;", "getIntentStatsCol$tock_nlp_front_storage_mongo", "intentStatsCol$delegate", "save", "", "log", "Lai/tock/nlp/front/shared/monitoring/ParseRequestLog;", "search", "Lai/tock/nlp/front/shared/monitoring/ParseRequestLogQueryResult;", "query", "Lai/tock/nlp/front/shared/monitoring/ParseRequestLogQuery;", "Lai/tock/nlp/front/shared/monitoring/ParseRequestLogCountQueryResult;", "Lai/tock/nlp/front/shared/monitoring/ParseRequestLogCountQuery;", "export", "", "Lai/tock/nlp/front/shared/monitoring/ParseRequestExportLog;", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "language", "Ljava/util/Locale;", "stats", "Lai/tock/nlp/front/shared/monitoring/ParseRequestLogStat;", "Lai/tock/nlp/front/shared/monitoring/ParseRequestLogStatQuery;", "intentStats", "Lai/tock/nlp/front/shared/monitoring/ParseRequestLogIntentStat;", "ParseRequestLogCol", "ParseRequestLogStatCol", "ParseRequestLogIntentStatCol", "DayAndYear", "ParseRequestLogStatResult", "tock-nlp-front-storage-mongo"})
@SourceDebugExtension(value={"SMAP\nParseRequestLogMongoDAO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParseRequestLogMongoDAO.kt\nai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MongoCollections.kt\norg/litote/kmongo/MongoCollectionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 MongoDatabases.kt\norg/litote/kmongo/MongoDatabasesKt\n*L\n1#1,456:1\n1#2:457\n67#3:458\n187#3:459\n1557#4:460\n1628#4,3:461\n40#5,11:464\n40#5,11:475\n40#5,11:486\n*S KotlinDebug\n*F\n+ 1 ParseRequestLogMongoDAO.kt\nai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO\n*L\n379#1:458\n396#1:459\n433#1:460\n433#1:461,3\n225#1:464,11\n240#1:475,11\n256#1:486,11\n*E\n"})
public final class ParseRequestLogMongoDAO
implements ParseRequestLogDAO {
    @NotNull
    public static final ParseRequestLogMongoDAO INSTANCE = new ParseRequestLogMongoDAO();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(ParseRequestLogMongoDAO::logger$lambda$0);
    @NotNull
    private static final LogObfuscationService logObfuscationService = new LogObfuscationService();
    @NotNull
    private static final Lazy col$delegate = LazyKt.lazy(ParseRequestLogMongoDAO::col_delegate$lambda$1);
    @NotNull
    private static final Lazy statsCol$delegate = LazyKt.lazy(ParseRequestLogMongoDAO::statsCol_delegate$lambda$2);
    @NotNull
    private static final Lazy intentStatsCol$delegate = LazyKt.lazy(ParseRequestLogMongoDAO::intentStatsCol_delegate$lambda$3);

    private ParseRequestLogMongoDAO() {
    }

    @NotNull
    public final MongoCollection<ParseRequestLogCol> getCol$tock_nlp_front_storage_mongo() {
        Lazy lazy = col$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (MongoCollection)object;
    }

    @NotNull
    public final MongoCollection<ParseRequestLogStatCol> getStatsCol$tock_nlp_front_storage_mongo() {
        Lazy lazy = statsCol$delegate;
        return (MongoCollection)lazy.getValue();
    }

    @NotNull
    public final MongoCollection<ParseRequestLogIntentStatCol> getIntentStatsCol$tock_nlp_front_storage_mongo() {
        Lazy lazy = intentStatsCol$delegate;
        return (MongoCollection)lazy.getValue();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void save(@NotNull ParseRequestLog log) {
        block10: {
            Intrinsics.checkNotNullParameter((Object)log, (String)"log");
            savedLog = ParseRequestLogMongoDAO.logObfuscationService.obfuscate(log);
            this.getCol$tock_nlp_front_storage_mongo().insertOne((Object)new ParseRequestLogCol(savedLog));
            if (!log.getQuery().getContext().getIncreaseQueryCounter()) break block10;
            stat = new ParseRequestLogStatCol(log);
            v0 = this.getStatsCol$tock_nlp_front_storage_mongo();
            var5_4 = new Bson[]{FiltersKt.eq((KProperty)((KProperty)ParseRequestLogStatCol_.Companion.getLanguage()), (Object)stat.getLanguage()), FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getApplicationId()), stat.getApplicationId()), FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getText()), (Object)stat.getText())};
            v1 = FiltersKt.and((Bson[])var5_4);
            v2 = var5_4 = new Bson[5];
            v3 = 0;
            v4 = stat.getIntentProbability();
            if (v4 != null) {
                var8_5 = ((Number)v4).doubleValue();
                var22_9 = v3;
                var21_10 = v2;
                var20_11 = v1;
                var19_12 = v0;
                $i$a$-let-ParseRequestLogMongoDAO$save$updatedStat$1 = false;
                var23_15 = UpdatesKt.setValue((KProperty)((KProperty)ParseRequestLogStatResult_.Companion.getIntentProbability()), (Object)it);
                v0 = var19_12;
                v1 = var20_11;
                v2 = var21_10;
                v3 = var22_9;
                v5 = var23_15;
            } else {
                v5 = null;
            }
            v2[v3] = v5;
            v6 = var5_4;
            v7 = 1;
            v8 = stat.getEntitiesProbability();
            if (v8 != null) {
                it = ((Number)v8).doubleValue();
                var22_9 = v7;
                var21_10 = v6;
                var20_11 = v1;
                var19_12 = v0;
                $i$a$-let-ParseRequestLogMongoDAO$save$updatedStat$2 = false;
                var23_15 = UpdatesKt.setValue((KProperty)((KProperty)ParseRequestLogStatResult_.Companion.getEntitiesProbability()), (Object)it);
                v0 = var19_12;
                v1 = var20_11;
                v6 = var21_10;
                v7 = var22_9;
                v9 = var23_15;
            } else {
                v9 = null;
            }
            v6[v7] = v9;
            var5_4[2] = UpdatesKt.setValue((KProperty)((KProperty)ParseRequestLogStatCol_.Companion.getLastUsage()), (Object)stat.getLastUsage());
            v10 = var5_4;
            v11 = 3;
            v12 = stat.getIntent();
            if (v12 != null) {
                it = v12;
                var22_9 = v11;
                var21_10 = v10;
                var20_11 = v1;
                var19_12 = v0;
                $i$a$-let-ParseRequestLogMongoDAO$save$updatedStat$3 = false;
                var23_15 = UpdatesKt.setValue((KProperty)((KProperty)ParseRequestLogStatCol_.Companion.getIntent()), (Object)it);
                v0 = var19_12;
                v1 = var20_11;
                v10 = var21_10;
                v11 = var22_9;
                v13 = var23_15;
            } else {
                v13 = null;
            }
            v10[v11] = v13;
            var5_4[4] = UpdatesKt.inc((KProperty)((KProperty)ParseRequestLogStatResult_.Companion.getCount()), (Number)1);
            updatedStat = (ParseRequestLogStatCol)v0.findOneAndUpdate(v1, UpdatesKt.combine((List)CollectionsKt.listOfNotNull((Object[])var5_4)), new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.AFTER));
            if (updatedStat != null) {
                ClassifiedSentenceMongoDAO.INSTANCE.updateSentenceState$tock_nlp_front_storage_mongo(updatedStat);
            }
            v14 = log.getResult();
            intent1 = v14 != null ? v14.getIntent() : null;
            v15 /* !! */  = log.getResult();
            nextIntent = v15 /* !! */  != null && (v15 /* !! */  = v15 /* !! */ .getOtherIntentsProbabilities()) != null && (v15 /* !! */  = MapsKt.asSequence((Map)v15 /* !! */ )) != null ? (Map.Entry)SequencesKt.firstOrNull((Sequence)v15 /* !! */ ) : null;
            v16 = nextIntent;
            v17 = v16 != null && (v16 = (String)v16.getKey()) != null ? ai.tock.shared.StringsKt.name((String)v16) : (intent2 = null);
            if (intent1 == null || intent2 == null || Intrinsics.areEqual((Object)intent2, (Object)intent1)) break block10;
            if (intent1.compareTo(intent2) > 0) {
                tmp = intent1;
                intent1 = intent2;
                intent2 = tmp;
            }
            v18 = log.getResult();
            Intrinsics.checkNotNull((Object)v18);
            v19 = v18.getIntentProbability();
            v20 = nextIntent;
            Intrinsics.checkNotNull((Object)v20);
            diff = v19 - ((Number)v20.getValue()).doubleValue();
            var12_20 /* !! */  = new Bson[]{FiltersKt.eq((KProperty)((KProperty)ParseRequestLogStatCol_.Companion.getLanguage()), (Object)stat.getLanguage()), FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getApplicationId()), stat.getApplicationId()), FiltersKt.eq((KProperty)((KProperty)ParseRequestLogIntentStatCol_.Companion.getIntent1()), (Object)intent1), FiltersKt.eq((KProperty)((KProperty)ParseRequestLogIntentStatCol_.Companion.getIntent2()), (Object)intent2)};
            var11_21 = (ParseRequestLogIntentStatCol)MongoCollectionsKt.findOne(this.getIntentStatsCol$tock_nlp_front_storage_mongo(), (Bson)FiltersKt.and((Bson[])var12_20 /* !! */ ));
            if (var11_21 == null) ** GOTO lbl-1000
            $this$save_u24lambda_u247 = var11_21;
            $i$a$-run-ParseRequestLogMongoDAO$save$s$1 = false;
            var15_24 = $this$save_u24lambda_u247.getCount() + 1L;
            var17_25 = ($this$save_u24lambda_u247.getAverageDiff() * (double)$this$save_u24lambda_u247.getCount() + diff) / (double)($this$save_u24lambda_u247.getCount() + 1L);
            var12_20 /* !! */  = ParseRequestLogIntentStatCol.copy$default($this$save_u24lambda_u247, null, null, null, null, var17_25, var15_24, null, 79, null);
            if (var12_20 /* !! */  != null) {
                v21 /* !! */  = var12_20 /* !! */ ;
            } else lbl-1000:
            // 2 sources

            {
                v21 /* !! */  = new ParseRequestLogIntentStatCol(log.getApplicationId(), log.getQuery().getContext().getLanguage(), intent1, intent2, diff, 1L, null, 64, null);
            }
            s = v21 /* !! */ ;
            MongoCollectionsKt.save(this.getIntentStatsCol$tock_nlp_front_storage_mongo(), (Object)s);
        }
    }

    @NotNull
    public ParseRequestLogQueryResult search(@NotNull ParseRequestLogQuery query2) {
        ParseRequestLogQueryResult parseRequestLogQueryResult;
        Bson bson;
        Bson bson2;
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        ParseRequestLogQuery $this$search_u24lambda_u249 = query2;
        boolean bl = false;
        Bson[] bsonArray = new Bson[8];
        bsonArray[0] = FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getApplicationId()), (Object)$this$search_u24lambda_u249.getApplicationId());
        bsonArray[1] = $this$search_u24lambda_u249.getLanguage() == null ? null : FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getQuery().getContext().getLanguage()), (Object)$this$search_u24lambda_u249.getLanguage());
        bsonArray[2] = query2.getDisplayTests() ? null : FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getQuery().getContext().getTest()), (Object)false);
        CharSequence charSequence = $this$search_u24lambda_u249.getSearch();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            bson2 = null;
        } else if (query2.getOnlyExactMatch()) {
            bson2 = FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getText()), (Object)$this$search_u24lambda_u249.getSearch());
        } else {
            KProperty kProperty = (KProperty)ParseRequestLogCol_.Companion.getText();
            String string = $this$search_u24lambda_u249.getSearch();
            Intrinsics.checkNotNull((Object)string);
            bson2 = bsonArray[3] = FiltersKt.regex((KProperty)kProperty, (String)((Object)StringsKt.trim((CharSequence)string)).toString(), (String)"i");
        }
        if ($this$search_u24lambda_u249.getSearchMark() == null) {
            bson = null;
        } else {
            KProperty kProperty = (KProperty)ParseRequestLogCol_.Companion.getDate();
            SearchMark searchMark = $this$search_u24lambda_u249.getSearchMark();
            Intrinsics.checkNotNull((Object)searchMark);
            bson = FiltersKt.lte((KProperty)kProperty, (Object)searchMark.getDate());
        }
        bsonArray[4] = bson;
        bsonArray[5] = $this$search_u24lambda_u249.getSinceDate() == null ? null : FiltersKt.gte((KProperty)((KProperty)ParseRequestLogCol_.Companion.getDate()), (Object)$this$search_u24lambda_u249.getSinceDate());
        charSequence = $this$search_u24lambda_u249.getClientDevice();
        bsonArray[6] = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getQuery().getContext().getClientDevice()), (Object)$this$search_u24lambda_u249.getClientDevice());
        charSequence = $this$search_u24lambda_u249.getClientId();
        bsonArray[7] = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getQuery().getContext().getClientId()), (Object)$this$search_u24lambda_u249.getClientId());
        Bson baseFilter = FiltersKt.and((Bson[])bsonArray);
        long count = INSTANCE.getCol$tock_nlp_front_storage_mongo().countDocuments(baseFilter, MongosKt.getDefaultCountOptions());
        if (count > $this$search_u24lambda_u249.getStart()) {
            FindIterable findIterable = INSTANCE.getCol$tock_nlp_front_storage_mongo().find(baseFilter);
            Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"find(...)");
            KProperty[] kPropertyArray = new KProperty[]{ParseRequestLogCol_.Companion.getDate()};
            FindIterable list = FindIterablesKt.descendingSort((FindIterable)findIterable, (KProperty[])kPropertyArray).skip((int)$this$search_u24lambda_u249.getStart()).limit($this$search_u24lambda_u249.getSize());
            MongoIterable mongoIterable = list.map(ParseRequestLogMongoDAO::search$lambda$9$lambda$8);
            Intrinsics.checkNotNullExpressionValue((Object)mongoIterable, (String)"map(...)");
            parseRequestLogQueryResult = new ParseRequestLogQueryResult(count, KMongoIterableKt.toList((MongoIterable)mongoIterable));
        } else {
            parseRequestLogQueryResult = new ParseRequestLogQueryResult(0L, CollectionsKt.emptyList());
        }
        return parseRequestLogQueryResult;
    }

    @NotNull
    public ParseRequestLogCountQueryResult search(@NotNull ParseRequestLogCountQuery query2) {
        ParseRequestLogCountQueryResult parseRequestLogCountQueryResult;
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        ParseRequestLogCountQuery $this$search_u24lambda_u2411 = query2;
        boolean bl = false;
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getApplicationId()), (Object)$this$search_u24lambda_u2411.getApplicationId()), FiltersKt.eq((KProperty)((KProperty)ParseRequestLogStatCol_.Companion.getLanguage()), (Object)$this$search_u24lambda_u2411.getLanguage()), FiltersKt.gte((KProperty)((KProperty)ParseRequestLogStatResult_.Companion.getCount()), (Object)query2.getMinCount()), $this$search_u24lambda_u2411.getIntent() == null ? null : FiltersKt.eq((KProperty)((KProperty)ParseRequestLogStatCol_.Companion.getIntent()), (Object)$this$search_u24lambda_u2411.getIntent())};
        Bson baseFilter = FiltersKt.and((Bson[])bsonArray);
        long count = INSTANCE.getStatsCol$tock_nlp_front_storage_mongo().countDocuments(baseFilter, MongosKt.getDefaultCountOptions());
        if (count > $this$search_u24lambda_u2411.getStart()) {
            FindIterable findIterable = INSTANCE.getStatsCol$tock_nlp_front_storage_mongo().find(baseFilter);
            Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"find(...)");
            KProperty[] kPropertyArray = new KProperty[]{ParseRequestLogStatResult_.Companion.getCount()};
            FindIterable list = FindIterablesKt.descendingSort((FindIterable)findIterable, (KProperty[])kPropertyArray).skip((int)$this$search_u24lambda_u2411.getStart()).limit($this$search_u24lambda_u2411.getSize());
            MongoIterable mongoIterable = list.map(ParseRequestLogMongoDAO::search$lambda$11$lambda$10);
            Intrinsics.checkNotNullExpressionValue((Object)mongoIterable, (String)"map(...)");
            parseRequestLogCountQueryResult = new ParseRequestLogCountQueryResult(count, KMongoIterableKt.toList((MongoIterable)mongoIterable));
        } else {
            parseRequestLogCountQueryResult = new ParseRequestLogCountQueryResult(0L, CollectionsKt.emptyList());
        }
        return parseRequestLogCountQueryResult;
    }

    @NotNull
    public List<ParseRequestExportLog> export(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language) {
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        MongoCollection<ParseRequestLogCol> $this$withDocumentClass$iv = this.getCol$tock_nlp_front_storage_mongo();
        boolean $i$f$withDocumentClass = false;
        MongoCollection mongoCollection = $this$withDocumentClass$iv.withDocumentClass(Document.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"withDocumentClass(...)");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getApplicationId()), applicationId), FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getQuery().getContext().getLanguage()), (Object)language), FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getQuery().getContext().getTest()), (Object)false)};
        FindIterable findIterable = mongoCollection.find(FiltersKt.and((Bson[])bsonArray));
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"find(...)");
        KProperty[] kPropertyArray = new KProperty[]{ParseRequestLogCol_.Companion.getDate()};
        FindIterable findIterable2 = FindIterablesKt.descendingSort((FindIterable)findIterable, (KProperty[])kPropertyArray);
        kPropertyArray = new Bson[2];
        bsonArray = new KProperty[]{ParseRequestLogCol_.Companion.getQuery().getQueries(), ParseRequestLogCol_.Companion.getResult().getIntent(), ParseRequestLogCol_.Companion.getResult().getIntentNamespace(), ParseRequestLogCol_.Companion.getDate()};
        kPropertyArray[0] = ProjectionsKt.include((KProperty[])bsonArray);
        kPropertyArray[1] = ProjectionsKt.excludeId();
        MongoIterable mongoIterable = findIterable2.projection(ProjectionsKt.fields((Bson[])kPropertyArray)).map(ParseRequestLogMongoDAO::export$lambda$13);
        Intrinsics.checkNotNullExpressionValue((Object)mongoIterable, (String)"map(...)");
        return KMongoIterableKt.toList((MongoIterable)mongoIterable);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ParseRequestLogStat> stats(@NotNull ParseRequestLogStatQuery query2) {
        void $this$mapTo$iv$iv;
        void pipeline$iv;
        void $this$aggregate$iv;
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        ParseRequestLogStatQuery $this$stats_u24lambda_u2415 = query2;
        boolean bl = false;
        MongoCollection<ParseRequestLogCol> mongoCollection = INSTANCE.getCol$tock_nlp_front_storage_mongo();
        Bson[] bsonArray = new Bson[4];
        Object[] objectArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getApplicationId()), (Object)$this$stats_u24lambda_u2415.getApplicationId()), $this$stats_u24lambda_u2415.getLanguage() == null ? null : FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getQuery().getContext().getLanguage()), (Object)$this$stats_u24lambda_u2415.getLanguage()), FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getQuery().getContext().getTest()), (Object)false), $this$stats_u24lambda_u2415.getIntent() == null ? null : FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getResult().getIntent()), (Object)$this$stats_u24lambda_u2415.getIntent())};
        bsonArray[0] = AggregatesKt.match((Bson)FiltersKt.and((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)));
        objectArray = new Bson[]{ProjectionsKt.from((KProperty)((KProperty)ParseRequestLogCol_.Companion.getError()), (Object)AggregatesKt.cond(ParseRequestLogCol_.Companion.getError(), (Object)1, (Object)0)), ProjectionsKt.from((KProperty)((KProperty)DayAndYear_.Companion.getDayOfYear()), (Object)AggregatesKt.dayOfYear((KProperty)((KProperty)ParseRequestLogCol_.Companion.getDate()))), ProjectionsKt.from((KProperty)((KProperty)DayAndYear_.Companion.getYear()), (Object)AggregatesKt.year((KProperty)((KProperty)ParseRequestLogCol_.Companion.getDate()))), ProjectionsKt.from((KProperty)((KProperty)ParseRequestLogStatResult_.Companion.getDuration()), ParseRequestLogCol_.Companion.getDurationInMS()), ProjectionsKt.from((KProperty)((KProperty)ParseRequestLogStatResult_.Companion.getIntentProbability()), ParseRequestLogCol_.Companion.getResult().getIntentProbability()), ProjectionsKt.from((KProperty)((KProperty)ParseRequestLogStatResult_.Companion.getEntitiesProbability()), ParseRequestLogCol_.Companion.getResult().getEntitiesProbability())};
        bsonArray[1] = AggregatesKt.project((Bson[])objectArray);
        objectArray = new Bson[]{ProjectionsKt.from((KProperty)((KProperty)DayAndYear_.Companion.getDayOfYear()), DayAndYear_.Companion.getDayOfYear()), ProjectionsKt.from((KProperty)((KProperty)DayAndYear_.Companion.getYear()), DayAndYear_.Companion.getYear())};
        Bson bson = AggregatesKt.document((Bson[])objectArray);
        objectArray = new BsonField[]{AccumulatorsKt.sum((KProperty)((KProperty)ParseRequestLogCol_.Companion.getError()), ParseRequestLogCol_.Companion.getError()), AccumulatorsKt.sum((KProperty)((KProperty)ParseRequestLogStatResult_.Companion.getCount()), (Object)1), AccumulatorsKt.avg((KProperty)((KProperty)ParseRequestLogStatResult_.Companion.getDuration()), ParseRequestLogStatResult_.Companion.getDuration()), AccumulatorsKt.avg((KProperty)((KProperty)ParseRequestLogStatResult_.Companion.getIntentProbability()), ParseRequestLogStatResult_.Companion.getIntentProbability()), AccumulatorsKt.avg((KProperty)((KProperty)ParseRequestLogStatResult_.Companion.getEntitiesProbability()), ParseRequestLogStatResult_.Companion.getEntitiesProbability())};
        bsonArray[2] = AggregatesKt.group((Object)bson, (BsonField[])objectArray);
        objectArray = new KProperty[]{ParseRequestLogStatResult_.Companion.get_id().getYear(), ParseRequestLogStatResult_.Companion.get_id().getDayOfYear()};
        bsonArray[3] = AggregatesKt.sort((Bson)SortsKt.ascending((KProperty[])objectArray));
        boolean $i$f$aggregate22 = false;
        AggregateIterable aggregateIterable = $this$aggregate$iv.aggregate(ArraysKt.toList((Object[])pipeline$iv), ParseRequestLogStatResult.class);
        Intrinsics.checkNotNullExpressionValue((Object)aggregateIterable, (String)"aggregate(...)");
        Iterable $this$map$iv = KMongoIterableKt.toList((MongoIterable)((MongoIterable)aggregateIterable));
        boolean $i$f$map = false;
        Iterable $i$f$aggregate22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ParseRequestLogStatResult parseRequestLogStatResult = (ParseRequestLogStatResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.toStat());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<ParseRequestLogIntentStat> intentStats(@NotNull ParseRequestLogStatQuery query2) {
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)ParseRequestLogCol_.Companion.getApplicationId()), (Object)query2.getApplicationId()), FiltersKt.gte((KProperty)((KProperty)ParseRequestLogStatResult_.Companion.getCount()), (Object)query2.getMinOccurrences())};
        FindIterable findIterable = this.getIntentStatsCol$tock_nlp_front_storage_mongo().find(FiltersKt.and((Bson[])bsonArray));
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"find(...)");
        KProperty[] kPropertyArray = new KProperty[]{ParseRequestLogStatResult_.Companion.getCount()};
        MongoIterable mongoIterable = FindIterablesKt.descendingSort((FindIterable)findIterable, (KProperty[])kPropertyArray).map(ParseRequestLogMongoDAO::intentStats$lambda$16);
        Intrinsics.checkNotNullExpressionValue((Object)mongoIterable, (String)"map(...)");
        return KMongoIterableKt.toList((MongoIterable)mongoIterable);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final MongoCollection col_delegate$lambda$1() {
        void $this$getCollection$iv;
        KProperty[] kPropertyArray = MongoFrontConfiguration.INSTANCE.getDatabase();
        String collectionName$iv = "parse_request_log";
        boolean $i$f$getCollection = false;
        void $this$getCollectionOfName$iv$iv = $this$getCollection$iv;
        boolean $i$f$getCollectionOfName = false;
        MongoCollection mongoCollection = $this$getCollectionOfName$iv$iv.getCollection(collectionName$iv, ParseRequestLogCol.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        MongoCollection c2 = mongoCollection;
        try {
            kPropertyArray = new KProperty[]{ParseRequestLogCol_.Companion.getQuery().getContext().getLanguage(), ParseRequestLogCol_.Companion.getApplicationId(), ParseRequestLogCol_.Companion.getQuery().getContext().getTest()};
            MongosKt.ensureIndex$default((MongoCollection)c2, (KProperty[])kPropertyArray, null, (int)2, null);
            kPropertyArray = new KProperty[]{ParseRequestLogCol_.Companion.getQuery().getContext().getLanguage(), ParseRequestLogCol_.Companion.getApplicationId(), ParseRequestLogCol_.Companion.getText()};
            MongosKt.ensureIndex$default((MongoCollection)c2, (KProperty[])kPropertyArray, null, (int)2, null);
            kPropertyArray = new KProperty[]{ParseRequestLogCol_.Companion.getDate()};
            IndexOptions indexOptions = new IndexOptions().expireAfter(Long.valueOf(PropertiesKt.longProperty((String)"tock_nlp_log_index_ttl_days", (long)7L)), TimeUnit.DAYS);
            Intrinsics.checkNotNullExpressionValue((Object)indexOptions, (String)"expireAfter(...)");
            MongosKt.ensureIndex((MongoCollection)c2, (KProperty[])kPropertyArray, (IndexOptions)indexOptions);
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
        }
        return c2.withReadPreference(ReadPreference.secondaryPreferred());
    }

    /*
     * WARNING - void declaration
     */
    private static final MongoCollection statsCol_delegate$lambda$2() {
        void $this$getCollection$iv;
        KProperty[] kPropertyArray = MongoFrontConfiguration.INSTANCE.getDatabase();
        String collectionName$iv = "parse_request_log_stats";
        boolean $i$f$getCollection = false;
        void $this$getCollectionOfName$iv$iv = $this$getCollection$iv;
        boolean $i$f$getCollectionOfName = false;
        MongoCollection mongoCollection = $this$getCollectionOfName$iv$iv.getCollection(collectionName$iv, ParseRequestLogStatCol.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        MongoCollection c2 = mongoCollection;
        try {
            kPropertyArray = new KProperty[]{ParseRequestLogStatCol_.Companion.getLanguage(), ParseRequestLogCol_.Companion.getApplicationId(), ParseRequestLogCol_.Companion.getText()};
            MongosKt.ensureIndex$default((MongoCollection)c2, (KProperty[])kPropertyArray, null, (int)2, null);
            kPropertyArray = new KProperty[]{ParseRequestLogStatResult_.Companion.getCount(), ParseRequestLogStatCol_.Companion.getLanguage(), ParseRequestLogCol_.Companion.getApplicationId(), ParseRequestLogCol_.Companion.getText(), ParseRequestLogStatCol_.Companion.getIntent()};
            MongosKt.ensureIndex$default((MongoCollection)c2, (KProperty[])kPropertyArray, null, (int)2, null);
            kPropertyArray = new KProperty[]{ParseRequestLogStatCol_.Companion.getLastUsage()};
            IndexOptions indexOptions = new IndexOptions().expireAfter(Long.valueOf(PropertiesKt.longProperty((String)"tock_nlp_log_stats_index_ttl_days", (long)365L)), TimeUnit.DAYS);
            Intrinsics.checkNotNullExpressionValue((Object)indexOptions, (String)"expireAfter(...)");
            MongosKt.ensureIndex((MongoCollection)c2, (KProperty[])kPropertyArray, (IndexOptions)indexOptions);
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
        }
        return c2;
    }

    /*
     * WARNING - void declaration
     */
    private static final MongoCollection intentStatsCol_delegate$lambda$3() {
        void $this$getCollection$iv;
        KProperty[] kPropertyArray = MongoFrontConfiguration.INSTANCE.getDatabase();
        String collectionName$iv = "parse_request_log_intent_stats";
        boolean $i$f$getCollection = false;
        void $this$getCollectionOfName$iv$iv = $this$getCollection$iv;
        boolean $i$f$getCollectionOfName = false;
        MongoCollection mongoCollection = $this$getCollectionOfName$iv$iv.getCollection(collectionName$iv, ParseRequestLogIntentStatCol.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        MongoCollection c2 = mongoCollection;
        kPropertyArray = new KProperty[]{ParseRequestLogStatCol_.Companion.getLanguage(), ParseRequestLogCol_.Companion.getApplicationId(), ParseRequestLogIntentStatCol_.Companion.getIntent1(), ParseRequestLogIntentStatCol_.Companion.getIntent2()};
        MongosKt.ensureUniqueIndex$default((MongoCollection)c2, (KProperty[])kPropertyArray, null, (int)2, null);
        return c2;
    }

    private static final ParseRequestLog search$lambda$9$lambda$8(ParseRequestLogCol it) {
        return it.toRequest();
    }

    private static final ParseRequestLogCount search$lambda$11$lambda$10(ParseRequestLogStatCol it) {
        return it.toRequestLogStat();
    }

    /*
     * WARNING - void declaration
     */
    private static final ParseRequestExportLog export$lambda$13(Document it) {
        String string;
        Document document;
        Object object = it.get((Object)"query");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bson.Document");
        Object object2 = ((Document)object).get((Object)"queries");
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
        String string2 = (String)CollectionsKt.first((List)((List)object2));
        Object object3 = it.get((Object)"result");
        Document document2 = document = object3 instanceof Document ? (Document)object3 : null;
        if (document != null && (object3 = document.getString((Object)"intent")) != null) {
            void intent;
            Object object4 = object3;
            String string3 = string2;
            boolean bl = false;
            Object object5 = it.get((Object)"result");
            Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type org.bson.Document");
            string = ((Document)object5).getString((Object)"intentNamespace") + ":" + (String)intent;
            string2 = string3;
        } else {
            string = null;
        }
        Object object6 = it.get((Object)"date");
        Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type java.util.Date");
        Instant instant = ((Date)object6).toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        Instant instant2 = instant;
        String string4 = string;
        String string5 = string2;
        return new ParseRequestExportLog(string5, string4, instant2);
    }

    private static final ParseRequestLogIntentStat intentStats$lambda$16(ParseRequestLogIntentStatCol it) {
        return new ParseRequestLogIntentStat(it.getIntent1(), it.getIntent2(), it.getCount(), it.getAverageDiff());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$DayAndYear;", "", "dayOfYear", "", "year", "<init>", "(II)V", "getDayOfYear", "()I", "getYear", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "tock-nlp-front-storage-mongo"})
    public static final class DayAndYear {
        private final int dayOfYear;
        private final int year;

        public DayAndYear(int dayOfYear, int year) {
            this.dayOfYear = dayOfYear;
            this.year = year;
        }

        public final int getDayOfYear() {
            return this.dayOfYear;
        }

        public final int getYear() {
            return this.year;
        }

        public final int component1() {
            return this.dayOfYear;
        }

        public final int component2() {
            return this.year;
        }

        @NotNull
        public final DayAndYear copy(int dayOfYear, int year) {
            return new DayAndYear(dayOfYear, year);
        }

        public static /* synthetic */ DayAndYear copy$default(DayAndYear dayAndYear, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = dayAndYear.dayOfYear;
            }
            if ((n3 & 2) != 0) {
                n2 = dayAndYear.year;
            }
            return dayAndYear.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "DayAndYear(dayOfYear=" + this.dayOfYear + ", year=" + this.year + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.dayOfYear);
            result2 = result2 * 31 + Integer.hashCode(this.year);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DayAndYear)) {
                return false;
            }
            DayAndYear dayAndYear = (DayAndYear)other;
            if (this.dayOfYear != dayAndYear.dayOfYear) {
                return false;
            }
            return this.year == dayAndYear.year;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012B\u0011\b\u0016\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0015J\u0006\u0010$\u001a\u00020\u0014J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\bH\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u0010)\u001a\u00020\fH\u00c6\u0003J\t\u0010*\u001a\u00020\u000eH\u00c6\u0003J\t\u0010+\u001a\u00020\u0010H\u00c6\u0003JW\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u00c6\u0001J\u0013\u0010-\u001a\u00020\u000e2\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00062"}, d2={"Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$ParseRequestLogCol;", "", "text", "", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "query", "Lai/tock/nlp/front/shared/parser/ParseQuery;", "result", "Lai/tock/nlp/front/shared/parser/ParseResult;", "durationInMS", "", "error", "", "date", "Ljava/time/Instant;", "<init>", "(Ljava/lang/String;Lorg/litote/kmongo/Id;Lai/tock/nlp/front/shared/parser/ParseQuery;Lai/tock/nlp/front/shared/parser/ParseResult;JZLjava/time/Instant;)V", "request", "Lai/tock/nlp/front/shared/monitoring/ParseRequestLog;", "(Lai/tock/nlp/front/shared/monitoring/ParseRequestLog;)V", "getText", "()Ljava/lang/String;", "getApplicationId", "()Lorg/litote/kmongo/Id;", "getQuery", "()Lai/tock/nlp/front/shared/parser/ParseQuery;", "getResult", "()Lai/tock/nlp/front/shared/parser/ParseResult;", "getDurationInMS", "()J", "getError", "()Z", "getDate", "()Ljava/time/Instant;", "toRequest", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "", "toString", "tock-nlp-front-storage-mongo"})
    public static final class ParseRequestLogCol {
        @NotNull
        private final String text;
        @NotNull
        private final Id<ApplicationDefinition> applicationId;
        @NotNull
        private final ParseQuery query;
        @Nullable
        private final ParseResult result;
        private final long durationInMS;
        private final boolean error;
        @NotNull
        private final Instant date;

        public ParseRequestLogCol(@NotNull String text, @NotNull Id<ApplicationDefinition> applicationId, @NotNull ParseQuery query2, @Nullable ParseResult result2, long durationInMS, boolean error, @NotNull Instant date) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            this.text = text;
            this.applicationId = applicationId;
            this.query = query2;
            this.result = result2;
            this.durationInMS = durationInMS;
            this.error = error;
            this.date = date;
        }

        public /* synthetic */ ParseRequestLogCol(String string, Id id, ParseQuery parseQuery, ParseResult parseResult, long l, boolean bl, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                parseResult = null;
            }
            if ((n & 0x10) != 0) {
                l = 0L;
            }
            if ((n & 0x20) != 0) {
                bl = false;
            }
            if ((n & 0x40) != 0) {
                instant = Instant.now();
            }
            this(string, (Id<ApplicationDefinition>)id, parseQuery, parseResult, l, bl, instant);
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final Id<ApplicationDefinition> getApplicationId() {
            return this.applicationId;
        }

        @NotNull
        public final ParseQuery getQuery() {
            return this.query;
        }

        @Nullable
        public final ParseResult getResult() {
            return this.result;
        }

        public final long getDurationInMS() {
            return this.durationInMS;
        }

        public final boolean getError() {
            return this.error;
        }

        @NotNull
        public final Instant getDate() {
            return this.date;
        }

        public ParseRequestLogCol(@NotNull ParseRequestLog request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Object object = request.getResult();
            if ((object == null || (object = object.getRetainedQuery()) == null) && (object = (String)CollectionsKt.firstOrNull((List)request.getQuery().getQueries())) == null) {
                object = "";
            }
            this(MongoHelpersKt.textKey((String)object), (Id<ApplicationDefinition>)request.getApplicationId(), request.getQuery(), request.getResult(), request.getDurationInMS(), request.getError(), request.getDate());
        }

        @NotNull
        public final ParseRequestLog toRequest() {
            return new ParseRequestLog(this.applicationId, this.query, this.result, this.durationInMS, this.error, this.date);
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final Id<ApplicationDefinition> component2() {
            return this.applicationId;
        }

        @NotNull
        public final ParseQuery component3() {
            return this.query;
        }

        @Nullable
        public final ParseResult component4() {
            return this.result;
        }

        public final long component5() {
            return this.durationInMS;
        }

        public final boolean component6() {
            return this.error;
        }

        @NotNull
        public final Instant component7() {
            return this.date;
        }

        @NotNull
        public final ParseRequestLogCol copy(@NotNull String text, @NotNull Id<ApplicationDefinition> applicationId, @NotNull ParseQuery query2, @Nullable ParseResult result2, long durationInMS, boolean error, @NotNull Instant date) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            return new ParseRequestLogCol(text, applicationId, query2, result2, durationInMS, error, date);
        }

        public static /* synthetic */ ParseRequestLogCol copy$default(ParseRequestLogCol parseRequestLogCol, String string, Id id, ParseQuery parseQuery, ParseResult parseResult, long l, boolean bl, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                string = parseRequestLogCol.text;
            }
            if ((n & 2) != 0) {
                id = parseRequestLogCol.applicationId;
            }
            if ((n & 4) != 0) {
                parseQuery = parseRequestLogCol.query;
            }
            if ((n & 8) != 0) {
                parseResult = parseRequestLogCol.result;
            }
            if ((n & 0x10) != 0) {
                l = parseRequestLogCol.durationInMS;
            }
            if ((n & 0x20) != 0) {
                bl = parseRequestLogCol.error;
            }
            if ((n & 0x40) != 0) {
                instant = parseRequestLogCol.date;
            }
            return parseRequestLogCol.copy(string, id, parseQuery, parseResult, l, bl, instant);
        }

        @NotNull
        public String toString() {
            return "ParseRequestLogCol(text=" + this.text + ", applicationId=" + this.applicationId + ", query=" + this.query + ", result=" + this.result + ", durationInMS=" + this.durationInMS + ", error=" + this.error + ", date=" + this.date + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + this.applicationId.hashCode();
            result2 = result2 * 31 + this.query.hashCode();
            result2 = result2 * 31 + (this.result == null ? 0 : this.result.hashCode());
            result2 = result2 * 31 + Long.hashCode(this.durationInMS);
            result2 = result2 * 31 + Boolean.hashCode(this.error);
            result2 = result2 * 31 + this.date.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParseRequestLogCol)) {
                return false;
            }
            ParseRequestLogCol parseRequestLogCol = (ParseRequestLogCol)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)parseRequestLogCol.text)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.applicationId, parseRequestLogCol.applicationId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.query, (Object)parseRequestLogCol.query)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.result, (Object)parseRequestLogCol.result)) {
                return false;
            }
            if (this.durationInMS != parseRequestLogCol.durationInMS) {
                return false;
            }
            if (this.error != parseRequestLogCol.error) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.date, (Object)parseRequestLogCol.date);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BO\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J\t\u0010!\u001a\u00020\u000bH\u00c6\u0003J\t\u0010\"\u001a\u00020\rH\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003H\u00c6\u0003J[\u0010$\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003H\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020\bH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012\u00a8\u0006+"}, d2={"Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$ParseRequestLogIntentStatCol;", "", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "language", "Ljava/util/Locale;", "intent1", "", "intent2", "averageDiff", "", "count", "", "_id", "<init>", "(Lorg/litote/kmongo/Id;Ljava/util/Locale;Ljava/lang/String;Ljava/lang/String;DJLorg/litote/kmongo/Id;)V", "getApplicationId", "()Lorg/litote/kmongo/Id;", "getLanguage", "()Ljava/util/Locale;", "getIntent1", "()Ljava/lang/String;", "getIntent2", "getAverageDiff", "()D", "getCount", "()J", "get_id", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toString", "tock-nlp-front-storage-mongo"})
    public static final class ParseRequestLogIntentStatCol {
        @NotNull
        private final Id<ApplicationDefinition> applicationId;
        @NotNull
        private final Locale language;
        @NotNull
        private final String intent1;
        @NotNull
        private final String intent2;
        private final double averageDiff;
        private final long count;
        @NotNull
        private final Id<ParseRequestLogIntentStatCol> _id;

        public ParseRequestLogIntentStatCol(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language, @NotNull String intent1, @NotNull String intent2, double averageDiff, long count, @NotNull Id<ParseRequestLogIntentStatCol> _id2) {
            Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)intent1, (String)"intent1");
            Intrinsics.checkNotNullParameter((Object)intent2, (String)"intent2");
            Intrinsics.checkNotNullParameter(_id2, (String)"_id");
            this.applicationId = applicationId;
            this.language = language;
            this.intent1 = intent1;
            this.intent2 = intent2;
            this.averageDiff = averageDiff;
            this.count = count;
            this._id = _id2;
        }

        public /* synthetic */ ParseRequestLogIntentStatCol(Id id, Locale locale, String string, String string2, double d, long l, Id id2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                l = 1L;
            }
            if ((n & 0x40) != 0) {
                id2 = IdsKt.newId();
            }
            this((Id<ApplicationDefinition>)id, locale, string, string2, d, l, (Id<ParseRequestLogIntentStatCol>)id2);
        }

        @NotNull
        public final Id<ApplicationDefinition> getApplicationId() {
            return this.applicationId;
        }

        @NotNull
        public final Locale getLanguage() {
            return this.language;
        }

        @NotNull
        public final String getIntent1() {
            return this.intent1;
        }

        @NotNull
        public final String getIntent2() {
            return this.intent2;
        }

        public final double getAverageDiff() {
            return this.averageDiff;
        }

        public final long getCount() {
            return this.count;
        }

        @NotNull
        public final Id<ParseRequestLogIntentStatCol> get_id() {
            return this._id;
        }

        @NotNull
        public final Id<ApplicationDefinition> component1() {
            return this.applicationId;
        }

        @NotNull
        public final Locale component2() {
            return this.language;
        }

        @NotNull
        public final String component3() {
            return this.intent1;
        }

        @NotNull
        public final String component4() {
            return this.intent2;
        }

        public final double component5() {
            return this.averageDiff;
        }

        public final long component6() {
            return this.count;
        }

        @NotNull
        public final Id<ParseRequestLogIntentStatCol> component7() {
            return this._id;
        }

        @NotNull
        public final ParseRequestLogIntentStatCol copy(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language, @NotNull String intent1, @NotNull String intent2, double averageDiff, long count, @NotNull Id<ParseRequestLogIntentStatCol> _id2) {
            Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)intent1, (String)"intent1");
            Intrinsics.checkNotNullParameter((Object)intent2, (String)"intent2");
            Intrinsics.checkNotNullParameter(_id2, (String)"_id");
            return new ParseRequestLogIntentStatCol(applicationId, language, intent1, intent2, averageDiff, count, _id2);
        }

        public static /* synthetic */ ParseRequestLogIntentStatCol copy$default(ParseRequestLogIntentStatCol parseRequestLogIntentStatCol, Id id, Locale locale, String string, String string2, double d, long l, Id id2, int n, Object object) {
            if ((n & 1) != 0) {
                id = parseRequestLogIntentStatCol.applicationId;
            }
            if ((n & 2) != 0) {
                locale = parseRequestLogIntentStatCol.language;
            }
            if ((n & 4) != 0) {
                string = parseRequestLogIntentStatCol.intent1;
            }
            if ((n & 8) != 0) {
                string2 = parseRequestLogIntentStatCol.intent2;
            }
            if ((n & 0x10) != 0) {
                d = parseRequestLogIntentStatCol.averageDiff;
            }
            if ((n & 0x20) != 0) {
                l = parseRequestLogIntentStatCol.count;
            }
            if ((n & 0x40) != 0) {
                id2 = parseRequestLogIntentStatCol._id;
            }
            return parseRequestLogIntentStatCol.copy(id, locale, string, string2, d, l, id2);
        }

        @NotNull
        public String toString() {
            return "ParseRequestLogIntentStatCol(applicationId=" + this.applicationId + ", language=" + this.language + ", intent1=" + this.intent1 + ", intent2=" + this.intent2 + ", averageDiff=" + this.averageDiff + ", count=" + this.count + ", _id=" + this._id + ")";
        }

        public int hashCode() {
            int result2 = this.applicationId.hashCode();
            result2 = result2 * 31 + this.language.hashCode();
            result2 = result2 * 31 + this.intent1.hashCode();
            result2 = result2 * 31 + this.intent2.hashCode();
            result2 = result2 * 31 + Double.hashCode(this.averageDiff);
            result2 = result2 * 31 + Long.hashCode(this.count);
            result2 = result2 * 31 + this._id.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParseRequestLogIntentStatCol)) {
                return false;
            }
            ParseRequestLogIntentStatCol parseRequestLogIntentStatCol = (ParseRequestLogIntentStatCol)other;
            if (!Intrinsics.areEqual(this.applicationId, parseRequestLogIntentStatCol.applicationId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.language, (Object)parseRequestLogIntentStatCol.language)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.intent1, (Object)parseRequestLogIntentStatCol.intent1)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.intent2, (Object)parseRequestLogIntentStatCol.intent2)) {
                return false;
            }
            if (Double.compare(this.averageDiff, parseRequestLogIntentStatCol.averageDiff) != 0) {
                return false;
            }
            if (this.count != parseRequestLogIntentStatCol.count) {
                return false;
            }
            return Intrinsics.areEqual(this._id, parseRequestLogIntentStatCol._id);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001Bg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014B\u0011\b\u0016\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0017J\u0006\u0010)\u001a\u00020*J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010-\u001a\u00020\bH\u00c6\u0003J\u000b\u0010.\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010/\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010 J\u0010\u00100\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010 J\t\u00101\u001a\u00020\u000eH\u00c6\u0003J\t\u00102\u001a\u00020\u0010H\u00c6\u0003J\t\u00103\u001a\u00020\u0012H\u00c6\u0003Jt\u00104\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u00c6\u0001\u00a2\u0006\u0002\u00105J\u0013\u00106\u001a\u00020\u00122\b\u00107\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00108\u001a\u000209H\u00d6\u0001J\t\u0010:\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019R\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b\u001f\u0010 R\u0015\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b\"\u0010 R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006;"}, d2={"Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$ParseRequestLogStatCol;", "", "text", "", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "language", "Ljava/util/Locale;", "intent", "intentProbability", "", "entitiesProbability", "lastUsage", "Ljava/time/Instant;", "count", "", "validated", "", "<init>", "(Ljava/lang/String;Lorg/litote/kmongo/Id;Ljava/util/Locale;Ljava/lang/String;Ljava/lang/Double;Ljava/lang/Double;Ljava/time/Instant;JZ)V", "request", "Lai/tock/nlp/front/shared/monitoring/ParseRequestLog;", "(Lai/tock/nlp/front/shared/monitoring/ParseRequestLog;)V", "getText", "()Ljava/lang/String;", "getApplicationId", "()Lorg/litote/kmongo/Id;", "getLanguage", "()Ljava/util/Locale;", "getIntent", "getIntentProbability", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getEntitiesProbability", "getLastUsage", "()Ljava/time/Instant;", "getCount", "()J", "getValidated", "()Z", "toRequestLogStat", "Lai/tock/nlp/front/shared/monitoring/ParseRequestLogCount;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;Lorg/litote/kmongo/Id;Ljava/util/Locale;Ljava/lang/String;Ljava/lang/Double;Ljava/lang/Double;Ljava/time/Instant;JZ)Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$ParseRequestLogStatCol;", "equals", "other", "hashCode", "", "toString", "tock-nlp-front-storage-mongo"})
    public static final class ParseRequestLogStatCol {
        @NotNull
        private final String text;
        @NotNull
        private final Id<ApplicationDefinition> applicationId;
        @NotNull
        private final Locale language;
        @Nullable
        private final String intent;
        @Nullable
        private final Double intentProbability;
        @Nullable
        private final Double entitiesProbability;
        @NotNull
        private final Instant lastUsage;
        private final long count;
        private final boolean validated;

        public ParseRequestLogStatCol(@NotNull String text, @NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language, @Nullable String intent, @Nullable Double intentProbability, @Nullable Double entitiesProbability, @NotNull Instant lastUsage, long count, boolean validated) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)lastUsage, (String)"lastUsage");
            this.text = text;
            this.applicationId = applicationId;
            this.language = language;
            this.intent = intent;
            this.intentProbability = intentProbability;
            this.entitiesProbability = entitiesProbability;
            this.lastUsage = lastUsage;
            this.count = count;
            this.validated = validated;
        }

        public /* synthetic */ ParseRequestLogStatCol(String string, Id id, Locale locale, String string2, Double d, Double d2, Instant instant, long l, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string2 = null;
            }
            if ((n & 0x10) != 0) {
                d = null;
            }
            if ((n & 0x20) != 0) {
                d2 = null;
            }
            if ((n & 0x40) != 0) {
                instant = Instant.now();
            }
            if ((n & 0x80) != 0) {
                l = 1L;
            }
            if ((n & 0x100) != 0) {
                bl = false;
            }
            this(string, (Id<ApplicationDefinition>)id, locale, string2, d, d2, instant, l, bl);
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final Id<ApplicationDefinition> getApplicationId() {
            return this.applicationId;
        }

        @NotNull
        public final Locale getLanguage() {
            return this.language;
        }

        @Nullable
        public final String getIntent() {
            return this.intent;
        }

        @Nullable
        public final Double getIntentProbability() {
            return this.intentProbability;
        }

        @Nullable
        public final Double getEntitiesProbability() {
            return this.entitiesProbability;
        }

        @NotNull
        public final Instant getLastUsage() {
            return this.lastUsage;
        }

        public final long getCount() {
            return this.count;
        }

        public final boolean getValidated() {
            return this.validated;
        }

        /*
         * WARNING - void declaration
         */
        public ParseRequestLogStatCol(@NotNull ParseRequestLog request) {
            String string;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            ParseRequestLogStatCol parseRequestLogStatCol = this;
            Object object = request.getResult();
            if ((object == null || (object = object.getRetainedQuery()) == null) && (object = (String)CollectionsKt.firstOrNull((List)request.getQuery().getQueries())) == null) {
                object = "";
            }
            String string2 = MongoHelpersKt.textKey((String)object);
            Id id = request.getApplicationId();
            Locale locale = request.getQuery().getContext().getLanguage();
            Object object2 = request.getResult();
            if (object2 != null && (object2 = object2.getIntentNamespace()) != null) {
                void namespace;
                Object object3 = object2;
                Locale locale2 = locale;
                Id id2 = id;
                String string3 = string2;
                ParseRequestLogStatCol parseRequestLogStatCol2 = parseRequestLogStatCol;
                boolean bl = false;
                Object object4 = request.getResult();
                String string4 = object4 != null && (object4 = object4.getIntent()) != null ? ai.tock.shared.StringsKt.withNamespace((String)object4, (String)namespace) : null;
                parseRequestLogStatCol = parseRequestLogStatCol2;
                string2 = string3;
                id = id2;
                locale = locale2;
                string = string4;
            } else {
                string = null;
            }
            ParseResult parseResult = request.getResult();
            ParseResult parseResult2 = request.getResult();
            parseRequestLogStatCol(string2, id, locale, string, parseResult != null ? Double.valueOf(parseResult.getIntentProbability()) : null, parseResult2 != null ? Double.valueOf(parseResult2.getEntitiesProbability()) : null, request.getDate(), 0L, false, 384, null);
        }

        @NotNull
        public final ParseRequestLogCount toRequestLogStat() {
            return new ParseRequestLogCount(this.text, this.intent, this.intentProbability, this.entitiesProbability, this.lastUsage, this.count, this.validated);
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final Id<ApplicationDefinition> component2() {
            return this.applicationId;
        }

        @NotNull
        public final Locale component3() {
            return this.language;
        }

        @Nullable
        public final String component4() {
            return this.intent;
        }

        @Nullable
        public final Double component5() {
            return this.intentProbability;
        }

        @Nullable
        public final Double component6() {
            return this.entitiesProbability;
        }

        @NotNull
        public final Instant component7() {
            return this.lastUsage;
        }

        public final long component8() {
            return this.count;
        }

        public final boolean component9() {
            return this.validated;
        }

        @NotNull
        public final ParseRequestLogStatCol copy(@NotNull String text, @NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language, @Nullable String intent, @Nullable Double intentProbability, @Nullable Double entitiesProbability, @NotNull Instant lastUsage, long count, boolean validated) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)lastUsage, (String)"lastUsage");
            return new ParseRequestLogStatCol(text, applicationId, language, intent, intentProbability, entitiesProbability, lastUsage, count, validated);
        }

        public static /* synthetic */ ParseRequestLogStatCol copy$default(ParseRequestLogStatCol parseRequestLogStatCol, String string, Id id, Locale locale, String string2, Double d, Double d2, Instant instant, long l, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = parseRequestLogStatCol.text;
            }
            if ((n & 2) != 0) {
                id = parseRequestLogStatCol.applicationId;
            }
            if ((n & 4) != 0) {
                locale = parseRequestLogStatCol.language;
            }
            if ((n & 8) != 0) {
                string2 = parseRequestLogStatCol.intent;
            }
            if ((n & 0x10) != 0) {
                d = parseRequestLogStatCol.intentProbability;
            }
            if ((n & 0x20) != 0) {
                d2 = parseRequestLogStatCol.entitiesProbability;
            }
            if ((n & 0x40) != 0) {
                instant = parseRequestLogStatCol.lastUsage;
            }
            if ((n & 0x80) != 0) {
                l = parseRequestLogStatCol.count;
            }
            if ((n & 0x100) != 0) {
                bl = parseRequestLogStatCol.validated;
            }
            return parseRequestLogStatCol.copy(string, id, locale, string2, d, d2, instant, l, bl);
        }

        @NotNull
        public String toString() {
            return "ParseRequestLogStatCol(text=" + this.text + ", applicationId=" + this.applicationId + ", language=" + this.language + ", intent=" + this.intent + ", intentProbability=" + this.intentProbability + ", entitiesProbability=" + this.entitiesProbability + ", lastUsage=" + this.lastUsage + ", count=" + this.count + ", validated=" + this.validated + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + this.applicationId.hashCode();
            result2 = result2 * 31 + this.language.hashCode();
            result2 = result2 * 31 + (this.intent == null ? 0 : this.intent.hashCode());
            result2 = result2 * 31 + (this.intentProbability == null ? 0 : ((Object)this.intentProbability).hashCode());
            result2 = result2 * 31 + (this.entitiesProbability == null ? 0 : ((Object)this.entitiesProbability).hashCode());
            result2 = result2 * 31 + this.lastUsage.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.count);
            result2 = result2 * 31 + Boolean.hashCode(this.validated);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParseRequestLogStatCol)) {
                return false;
            }
            ParseRequestLogStatCol parseRequestLogStatCol = (ParseRequestLogStatCol)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)parseRequestLogStatCol.text)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.applicationId, parseRequestLogStatCol.applicationId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.language, (Object)parseRequestLogStatCol.language)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.intent, (Object)parseRequestLogStatCol.intent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.intentProbability, (Object)parseRequestLogStatCol.intentProbability)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.entitiesProbability, (Object)parseRequestLogStatCol.entitiesProbability)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastUsage, (Object)parseRequestLogStatCol.lastUsage)) {
                return false;
            }
            if (this.count != parseRequestLogStatCol.count) {
                return false;
            }
            return this.validated == parseRequestLogStatCol.validated;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0016\u001a\u00020\u0017J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00c6\u0003JE\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006%"}, d2={"Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$ParseRequestLogStatResult;", "", "_id", "Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$DayAndYear;", "error", "", "count", "duration", "", "intentProbability", "entitiesProbability", "<init>", "(Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$DayAndYear;IIDDD)V", "get_id", "()Lai/tock/nlp/front/storage/mongo/ParseRequestLogMongoDAO$DayAndYear;", "getError", "()I", "getCount", "getDuration", "()D", "getIntentProbability", "getEntitiesProbability", "toStat", "Lai/tock/nlp/front/shared/monitoring/ParseRequestLogStat;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "", "tock-nlp-front-storage-mongo"})
    public static final class ParseRequestLogStatResult {
        @NotNull
        private final DayAndYear _id;
        private final int error;
        private final int count;
        private final double duration;
        private final double intentProbability;
        private final double entitiesProbability;

        public ParseRequestLogStatResult(@NotNull DayAndYear _id2, int error, int count, double duration, double intentProbability, double entitiesProbability) {
            Intrinsics.checkNotNullParameter((Object)_id2, (String)"_id");
            this._id = _id2;
            this.error = error;
            this.count = count;
            this.duration = duration;
            this.intentProbability = intentProbability;
            this.entitiesProbability = entitiesProbability;
        }

        @NotNull
        public final DayAndYear get_id() {
            return this._id;
        }

        public final int getError() {
            return this.error;
        }

        public final int getCount() {
            return this.count;
        }

        public final double getDuration() {
            return this.duration;
        }

        public final double getIntentProbability() {
            return this.intentProbability;
        }

        public final double getEntitiesProbability() {
            return this.entitiesProbability;
        }

        @NotNull
        public final ParseRequestLogStat toStat() {
            LocalDate localDate = LocalDate.ofYearDay(this._id.getYear(), this._id.getDayOfYear());
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"ofYearDay(...)");
            return new ParseRequestLogStat(localDate, this.error, this.count, this.duration, this.intentProbability, this.entitiesProbability);
        }

        @NotNull
        public final DayAndYear component1() {
            return this._id;
        }

        public final int component2() {
            return this.error;
        }

        public final int component3() {
            return this.count;
        }

        public final double component4() {
            return this.duration;
        }

        public final double component5() {
            return this.intentProbability;
        }

        public final double component6() {
            return this.entitiesProbability;
        }

        @NotNull
        public final ParseRequestLogStatResult copy(@NotNull DayAndYear _id2, int error, int count, double duration, double intentProbability, double entitiesProbability) {
            Intrinsics.checkNotNullParameter((Object)_id2, (String)"_id");
            return new ParseRequestLogStatResult(_id2, error, count, duration, intentProbability, entitiesProbability);
        }

        public static /* synthetic */ ParseRequestLogStatResult copy$default(ParseRequestLogStatResult parseRequestLogStatResult, DayAndYear dayAndYear, int n, int n2, double d, double d2, double d3, int n3, Object object) {
            if ((n3 & 1) != 0) {
                dayAndYear = parseRequestLogStatResult._id;
            }
            if ((n3 & 2) != 0) {
                n = parseRequestLogStatResult.error;
            }
            if ((n3 & 4) != 0) {
                n2 = parseRequestLogStatResult.count;
            }
            if ((n3 & 8) != 0) {
                d = parseRequestLogStatResult.duration;
            }
            if ((n3 & 0x10) != 0) {
                d2 = parseRequestLogStatResult.intentProbability;
            }
            if ((n3 & 0x20) != 0) {
                d3 = parseRequestLogStatResult.entitiesProbability;
            }
            return parseRequestLogStatResult.copy(dayAndYear, n, n2, d, d2, d3);
        }

        @NotNull
        public String toString() {
            return "ParseRequestLogStatResult(_id=" + this._id + ", error=" + this.error + ", count=" + this.count + ", duration=" + this.duration + ", intentProbability=" + this.intentProbability + ", entitiesProbability=" + this.entitiesProbability + ")";
        }

        public int hashCode() {
            int result2 = this._id.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.error);
            result2 = result2 * 31 + Integer.hashCode(this.count);
            result2 = result2 * 31 + Double.hashCode(this.duration);
            result2 = result2 * 31 + Double.hashCode(this.intentProbability);
            result2 = result2 * 31 + Double.hashCode(this.entitiesProbability);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParseRequestLogStatResult)) {
                return false;
            }
            ParseRequestLogStatResult parseRequestLogStatResult = (ParseRequestLogStatResult)other;
            if (!Intrinsics.areEqual((Object)this._id, (Object)parseRequestLogStatResult._id)) {
                return false;
            }
            if (this.error != parseRequestLogStatResult.error) {
                return false;
            }
            if (this.count != parseRequestLogStatResult.count) {
                return false;
            }
            if (Double.compare(this.duration, parseRequestLogStatResult.duration) != 0) {
                return false;
            }
            if (Double.compare(this.intentProbability, parseRequestLogStatResult.intentProbability) != 0) {
                return false;
            }
            return Double.compare(this.entitiesProbability, parseRequestLogStatResult.entitiesProbability) == 0;
        }
    }
}

