/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.front.storage.mongo;

import ai.tock.nlp.front.service.storage.TestModelDAO;
import ai.tock.nlp.front.shared.config.ApplicationDefinition;
import ai.tock.nlp.front.shared.config.IntentDefinition;
import ai.tock.nlp.front.shared.test.EntityTestError;
import ai.tock.nlp.front.shared.test.EntityTestErrorQueryResult;
import ai.tock.nlp.front.shared.test.EntityTestError_;
import ai.tock.nlp.front.shared.test.IntentTestError;
import ai.tock.nlp.front.shared.test.IntentTestErrorQueryResult;
import ai.tock.nlp.front.shared.test.IntentTestError_;
import ai.tock.nlp.front.shared.test.TestBuild;
import ai.tock.nlp.front.shared.test.TestBuild_;
import ai.tock.nlp.front.shared.test.TestErrorQuery;
import ai.tock.nlp.front.storage.mongo.IntentDefinitionMongoDAO;
import ai.tock.nlp.front.storage.mongo.MongoFrontConfiguration;
import ai.tock.nlp.front.storage.mongo.MongoHelpersKt;
import ai.tock.shared.MongosKt;
import ai.tock.shared.StringsKt;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.KMongoIterableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.FindIterablesKt;
import org.litote.kmongo.Id;
import org.litote.kmongo.MongoCollectionsKt;
import org.litote.kmongo.util.KMongoUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\fH\u0016J&\u0010\u001e\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u0010H\u0016J&\u0010*\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\n\u001a\u0004\b\r\u0010\bR!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\n\u001a\u0004\b\u0011\u0010\b\u00a8\u0006+"}, d2={"Lai/tock/nlp/front/storage/mongo/TestModelMongoDAO;", "Lai/tock/nlp/front/service/storage/TestModelDAO;", "<init>", "()V", "buildCol", "Lcom/mongodb/client/MongoCollection;", "Lai/tock/nlp/front/shared/test/TestBuild;", "getBuildCol", "()Lcom/mongodb/client/MongoCollection;", "buildCol$delegate", "Lkotlin/Lazy;", "intentErrorCol", "Lai/tock/nlp/front/shared/test/IntentTestError;", "getIntentErrorCol", "intentErrorCol$delegate", "entityErrorCol", "Lai/tock/nlp/front/shared/test/EntityTestError;", "getEntityErrorCol", "entityErrorCol$delegate", "getTestBuilds", "", "query", "Lai/tock/nlp/front/shared/test/TestErrorQuery;", "saveTestBuild", "", "build", "searchTestIntentErrors", "Lai/tock/nlp/front/shared/test/IntentTestErrorQueryResult;", "addTestIntentError", "intentError", "deleteTestIntentError", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "language", "Ljava/util/Locale;", "text", "", "searchTestEntityErrors", "Lai/tock/nlp/front/shared/test/EntityTestErrorQueryResult;", "addTestEntityError", "entityError", "deleteTestEntityError", "tock-nlp-front-storage-mongo"})
@SourceDebugExtension(value={"SMAP\nTestModelMongoDAO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestModelMongoDAO.kt\nai/tock/nlp/front/storage/mongo/TestModelMongoDAO\n+ 2 KMongoIterable.kt\nkotlin/collections/KMongoIterableKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 MongoDatabases.kt\norg/litote/kmongo/MongoDatabasesKt\n*L\n1#1,223:1\n725#2:224\n1#3:225\n61#4:226\n61#4:227\n61#4:228\n*S KotlinDebug\n*F\n+ 1 TestModelMongoDAO.kt\nai/tock/nlp/front/storage/mongo/TestModelMongoDAO\n*L\n87#1:224\n57#1:226\n64#1:227\n71#1:228\n*E\n"})
public final class TestModelMongoDAO
implements TestModelDAO {
    @NotNull
    public static final TestModelMongoDAO INSTANCE = new TestModelMongoDAO();
    @NotNull
    private static final Lazy buildCol$delegate = LazyKt.lazy(TestModelMongoDAO::buildCol_delegate$lambda$0);
    @NotNull
    private static final Lazy intentErrorCol$delegate = LazyKt.lazy(TestModelMongoDAO::intentErrorCol_delegate$lambda$1);
    @NotNull
    private static final Lazy entityErrorCol$delegate = LazyKt.lazy(TestModelMongoDAO::entityErrorCol_delegate$lambda$2);

    private TestModelMongoDAO() {
    }

    private final MongoCollection<TestBuild> getBuildCol() {
        Lazy lazy = buildCol$delegate;
        return (MongoCollection)lazy.getValue();
    }

    private final MongoCollection<IntentTestError> getIntentErrorCol() {
        Lazy lazy = intentErrorCol$delegate;
        return (MongoCollection)lazy.getValue();
    }

    private final MongoCollection<EntityTestError> getEntityErrorCol() {
        Lazy lazy = entityErrorCol$delegate;
        return (MongoCollection)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<TestBuild> getTestBuilds(@NotNull TestErrorQuery query2) {
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        TestErrorQuery $this$getTestBuilds_u24lambda_u244 = query2;
        boolean bl = false;
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getLanguage()), (Object)$this$getTestBuilds_u24lambda_u244.getLanguage()), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getApplicationId()), (Object)$this$getTestBuilds_u24lambda_u244.getApplicationId()), $this$getTestBuilds_u24lambda_u244.getAfter() != null ? FiltersKt.gte((KProperty)((KProperty)TestBuild_.Companion.getStartDate()), (Object)$this$getTestBuilds_u24lambda_u244.getAfter()) : null};
        FindIterable findIterable = INSTANCE.getBuildCol().find(FiltersKt.and((Bson[])bsonArray));
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"find(...)");
        MongoIterable mongoIterable = new MongoIterable[]{TestBuild_.Companion.getStartDate()};
        mongoIterable = (MongoIterable)FindIterablesKt.descendingSort((FindIterable)findIterable, (KProperty[])mongoIterable);
        boolean $i$f$mapNotNull = false;
        return CollectionsKt.toList((Iterable)((List)KMongoIterableKt.useCursor((MongoIterable)$this$mapNotNull$iv, (Function1)((Function1)new Function1<Iterable<? extends TestBuild>, List<? extends TestBuild>>($this$getTestBuilds_u24lambda_u244){
            final /* synthetic */ TestErrorQuery $this_with$inlined;
            {
                this.$this_with$inlined = testErrorQuery;
            }

            /*
             * WARNING - void declaration
             */
            public final List<TestBuild> invoke(Iterable<? extends TestBuild> it) {
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Iterable<? extends TestBuild> $this$mapNotNull$iv = it;
                boolean $i$f$mapNotNull = false;
                Iterable<? extends TestBuild> iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    TestBuild testBuild;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    TestBuild it2 = (TestBuild)element$iv$iv;
                    boolean bl2 = false;
                    String intent = this.$this_with$inlined.getIntentName();
                    if (intent == null) {
                        testBuild = it2;
                    } else {
                        Integer n = (Integer)it2.getIntentErrorsByIntent().get(intent);
                        int intentErrors = n != null ? n : 0;
                        Integer n2 = (Integer)it2.getEntityErrorsByIntent().get(intent);
                        int entityErrors = n2 != null ? n2 : 0;
                        Integer n3 = (Integer)it2.getNbSentencesTestedByIntent().get(intent);
                        testBuild = TestBuild.copy$default((TestBuild)it2, null, null, null, null, null, (int)0, (int)(n3 != null ? n3 : 0), (int)(intentErrors + entityErrors), (int)intentErrors, (int)entityErrors, null, null, null, (int)7231, null);
                    }
                    if (testBuild == null) continue;
                    TestBuild it$iv$iv = testBuild;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }))));
    }

    public void saveTestBuild(@NotNull TestBuild build) {
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        this.getBuildCol().insertOne((Object)build);
    }

    @NotNull
    public IntentTestErrorQueryResult searchTestIntentErrors(@NotNull TestErrorQuery query2) {
        IntentTestErrorQueryResult intentTestErrorQueryResult;
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getLanguage()), (Object)query2.getLanguage()), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getApplicationId()), (Object)query2.getApplicationId()), query2.getIntentName() == null ? null : FiltersKt.eq((KProperty)((KProperty)IntentTestError_.Companion.getCurrentIntent()), (Object)query2.getIntentName())};
        Bson filter = FiltersKt.and((Bson[])bsonArray);
        int count = (int)this.getIntentErrorCol().countDocuments(filter);
        if (count == 0) {
            intentTestErrorQueryResult = new IntentTestErrorQueryResult(0, CollectionsKt.emptyList());
        } else {
            FindIterable findIterable = this.getIntentErrorCol().find(filter);
            Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"find(...)");
            KProperty[] kPropertyArray = new KProperty[]{IntentTestError_.Companion.getCount()};
            FindIterable findIterable2 = FindIterablesKt.descendingSort((FindIterable)findIterable, (KProperty[])kPropertyArray).skip((int)query2.getStart()).limit(query2.getSize());
            Intrinsics.checkNotNullExpressionValue((Object)findIterable2, (String)"limit(...)");
            IntentTestErrorQueryResult intentTestErrorQueryResult2 = new IntentTestErrorQueryResult(count, KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable2)));
            intentTestErrorQueryResult = intentTestErrorQueryResult2;
        }
        return intentTestErrorQueryResult;
    }

    public void addTestIntentError(@NotNull IntentTestError intentError) {
        Intrinsics.checkNotNullParameter((Object)intentError, (String)"intentError");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)IntentTestError_.Companion.getText()), (Object)MongoHelpersKt.textKey(intentError.getText())), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getLanguage()), (Object)intentError.getLanguage()), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getApplicationId()), (Object)intentError.getApplicationId())};
        Bson filter = FiltersKt.and((Bson[])bsonArray);
        boolean newError = intentError.getCount() != 0;
        IntentTestError intentTestError = (IntentTestError)MongoCollectionsKt.findOne(this.getIntentErrorCol(), (Bson)filter);
        if (intentTestError != null) {
            IntentTestError intentTestError2;
            IntentTestError $this$addTestIntentError_u24lambda_u245 = intentTestError2 = intentTestError;
            boolean bl = false;
            int n = $this$addTestIntentError_u24lambda_u245.getCount() + intentError.getCount();
            String string = newError ? intentError.getCurrentIntent() : $this$addTestIntentError_u24lambda_u245.getCurrentIntent();
            String string2 = newError ? intentError.getWrongIntent() : $this$addTestIntentError_u24lambda_u245.getWrongIntent();
            double d = newError ? ($this$addTestIntentError_u24lambda_u245.getAverageErrorProbability() * (double)$this$addTestIntentError_u24lambda_u245.getTotal() + intentError.getAverageErrorProbability()) / (double)($this$addTestIntentError_u24lambda_u245.getTotal() + 1) : $this$addTestIntentError_u24lambda_u245.getAverageErrorProbability();
            int n2 = $this$addTestIntentError_u24lambda_u245.getTotal() + 1;
            INSTANCE.getIntentErrorCol().replaceOne(filter, (Object)IntentTestError.copy$default((IntentTestError)$this$addTestIntentError_u24lambda_u245, null, null, null, (String)string, (String)string2, (double)d, (int)n, (int)n2, null, (int)263, null));
        } else if (newError) {
            MongoCollectionsKt.save(this.getIntentErrorCol(), (Object)IntentTestError.copy$default((IntentTestError)intentError, null, null, (String)MongoHelpersKt.textKey(intentError.getText()), null, null, (double)0.0, (int)0, (int)0, null, (int)507, null));
        }
    }

    public void deleteTestIntentError(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language, @NotNull String text) {
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)IntentTestError_.Companion.getText()), (Object)MongoHelpersKt.textKey(text)), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getLanguage()), (Object)language), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getApplicationId()), applicationId)};
        this.getIntentErrorCol().deleteOne(FiltersKt.and((Bson[])bsonArray));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public EntityTestErrorQueryResult searchTestEntityErrors(@NotNull TestErrorQuery query2) {
        EntityTestErrorQueryResult entityTestErrorQueryResult;
        Bson bson;
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        Bson[] bsonArray = new Bson[3];
        bsonArray[0] = FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getLanguage()), (Object)query2.getLanguage());
        bsonArray[1] = FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getApplicationId()), (Object)query2.getApplicationId());
        Bson[] bsonArray2 = bsonArray;
        int n = 2;
        String string = query2.getIntentName();
        if (string != null) {
            Bson bson2;
            void intentName;
            String string2 = string;
            int n2 = n;
            Bson[] bsonArray3 = bsonArray2;
            boolean bl = false;
            IntentDefinition intentDefinition = IntentDefinitionMongoDAO.INSTANCE.getIntentByNamespaceAndName(StringsKt.namespace((String)intentName), StringsKt.name((String)intentName));
            if (intentDefinition != null) {
                IntentDefinition it = intentDefinition;
                boolean bl2 = false;
                bson2 = FiltersKt.eq((KProperty)((KProperty)EntityTestError_.Companion.getIntentId()), (Object)it.get_id());
            } else {
                bson2 = null;
            }
            Bson bson3 = bson2;
            bsonArray2 = bsonArray3;
            n = n2;
            bson = bson3;
        } else {
            bson = null;
        }
        bsonArray2[n] = bson;
        Bson filter = FiltersKt.and((Bson[])bsonArray);
        int count = (int)this.getEntityErrorCol().countDocuments(filter);
        if (count == 0) {
            entityTestErrorQueryResult = new EntityTestErrorQueryResult(0, CollectionsKt.emptyList());
        } else {
            FindIterable findIterable = this.getEntityErrorCol().find(filter);
            Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"find(...)");
            KProperty[] kPropertyArray = new KProperty[]{IntentTestError_.Companion.getCount()};
            FindIterable findIterable2 = FindIterablesKt.descendingSort((FindIterable)findIterable, (KProperty[])kPropertyArray).skip((int)query2.getStart()).limit(query2.getSize());
            Intrinsics.checkNotNullExpressionValue((Object)findIterable2, (String)"limit(...)");
            EntityTestErrorQueryResult entityTestErrorQueryResult2 = new EntityTestErrorQueryResult(count, KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable2)));
            entityTestErrorQueryResult = entityTestErrorQueryResult2;
        }
        return entityTestErrorQueryResult;
    }

    public void addTestEntityError(@NotNull EntityTestError entityError) {
        Intrinsics.checkNotNullParameter((Object)entityError, (String)"entityError");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)IntentTestError_.Companion.getText()), (Object)MongoHelpersKt.textKey(entityError.getText())), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getLanguage()), (Object)entityError.getLanguage()), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getApplicationId()), (Object)entityError.getApplicationId())};
        Bson filter = FiltersKt.and((Bson[])bsonArray);
        boolean newError = entityError.getCount() != 0;
        EntityTestError entityTestError = (EntityTestError)MongoCollectionsKt.findOne(this.getEntityErrorCol(), (Bson)filter);
        if (entityTestError != null) {
            EntityTestError entityTestError2;
            EntityTestError $this$addTestEntityError_u24lambda_u248 = entityTestError2 = entityTestError;
            boolean bl = false;
            int n = $this$addTestEntityError_u24lambda_u248.getCount() + entityError.getCount();
            Id id = entityError.getIntentId();
            List list = newError ? entityError.getLastAnalyse() : $this$addTestEntityError_u24lambda_u248.getLastAnalyse();
            double d = newError ? ($this$addTestEntityError_u24lambda_u248.getAverageErrorProbability() * (double)$this$addTestEntityError_u24lambda_u248.getTotal() + entityError.getAverageErrorProbability()) / (double)($this$addTestEntityError_u24lambda_u248.getTotal() + 1) : $this$addTestEntityError_u24lambda_u248.getAverageErrorProbability();
            int n2 = $this$addTestEntityError_u24lambda_u248.getTotal() + 1;
            INSTANCE.getEntityErrorCol().replaceOne(filter, (Object)EntityTestError.copy$default((EntityTestError)$this$addTestEntityError_u24lambda_u248, null, null, null, (Id)id, (List)list, (double)d, (int)n, (int)n2, null, (int)263, null));
        } else if (newError) {
            MongoCollectionsKt.save(this.getEntityErrorCol(), (Object)EntityTestError.copy$default((EntityTestError)entityError, null, null, (String)MongoHelpersKt.textKey(entityError.getText()), null, null, (double)0.0, (int)0, (int)0, null, (int)507, null));
        }
    }

    public void deleteTestEntityError(@NotNull Id<ApplicationDefinition> applicationId, @NotNull Locale language, @NotNull String text) {
        Intrinsics.checkNotNullParameter(applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)IntentTestError_.Companion.getText()), (Object)MongoHelpersKt.textKey(text)), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getLanguage()), (Object)language), FiltersKt.eq((KProperty)((KProperty)TestBuild_.Companion.getApplicationId()), applicationId)};
        this.getEntityErrorCol().deleteOne(FiltersKt.and((Bson[])bsonArray));
    }

    private static final MongoCollection buildCol_delegate$lambda$0() {
        MongoDatabase $this$getCollection$iv = MongoFrontConfiguration.INSTANCE.getDatabase();
        boolean $i$f$getCollection = false;
        MongoCollection mongoCollection = $this$getCollection$iv.getCollection(KMongoUtil.INSTANCE.defaultCollectionName(Reflection.getOrCreateKotlinClass(TestBuild.class)), TestBuild.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        MongoCollection c2 = mongoCollection;
        KProperty[] kPropertyArray = new KProperty[]{TestBuild_.Companion.getApplicationId(), TestBuild_.Companion.getLanguage()};
        MongosKt.ensureIndex$default((MongoCollection)c2, (KProperty[])kPropertyArray, null, (int)2, null);
        kPropertyArray = new KProperty[]{TestBuild_.Companion.getStartDate()};
        MongosKt.ensureIndex$default((MongoCollection)c2, (KProperty[])kPropertyArray, null, (int)2, null);
        return c2;
    }

    private static final MongoCollection intentErrorCol_delegate$lambda$1() {
        MongoDatabase $this$getCollection$iv = MongoFrontConfiguration.INSTANCE.getDatabase();
        boolean $i$f$getCollection = false;
        MongoCollection mongoCollection = $this$getCollection$iv.getCollection(KMongoUtil.INSTANCE.defaultCollectionName(Reflection.getOrCreateKotlinClass(IntentTestError.class)), IntentTestError.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        MongoCollection c2 = mongoCollection;
        KProperty[] kPropertyArray = new KProperty[]{IntentTestError_.Companion.getApplicationId(), IntentTestError_.Companion.getLanguage(), IntentTestError_.Companion.getCount()};
        MongosKt.ensureIndex$default((MongoCollection)c2, (KProperty[])kPropertyArray, null, (int)2, null);
        kPropertyArray = new KProperty[]{IntentTestError_.Companion.getApplicationId(), IntentTestError_.Companion.getLanguage(), IntentTestError_.Companion.getText()};
        MongosKt.ensureUniqueIndex$default((MongoCollection)c2, (KProperty[])kPropertyArray, null, (int)2, null);
        return c2;
    }

    private static final MongoCollection entityErrorCol_delegate$lambda$2() {
        MongoDatabase $this$getCollection$iv = MongoFrontConfiguration.INSTANCE.getDatabase();
        boolean $i$f$getCollection = false;
        MongoCollection mongoCollection = $this$getCollection$iv.getCollection(KMongoUtil.INSTANCE.defaultCollectionName(Reflection.getOrCreateKotlinClass(EntityTestError.class)), EntityTestError.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        MongoCollection c2 = mongoCollection;
        KProperty[] kPropertyArray = new KProperty[]{EntityTestError_.Companion.getApplicationId(), EntityTestError_.Companion.getLanguage(), EntityTestError_.Companion.getCount()};
        MongosKt.ensureIndex$default((MongoCollection)c2, (KProperty[])kPropertyArray, null, (int)2, null);
        kPropertyArray = new KProperty[]{EntityTestError_.Companion.getApplicationId(), EntityTestError_.Companion.getLanguage(), EntityTestError_.Companion.getText()};
        MongosKt.ensureUniqueIndex$default((MongoCollection)c2, (KProperty[])kPropertyArray, null, (int)2, null);
        return c2;
    }
}

