/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.front.storage.mongo;

import ai.tock.nlp.front.service.storage.UserActionLogDAO;
import ai.tock.nlp.front.shared.config.ApplicationDefinition;
import ai.tock.nlp.front.shared.monitoring.UserActionLog;
import ai.tock.nlp.front.shared.monitoring.UserActionLogQuery;
import ai.tock.nlp.front.shared.monitoring.UserActionLogQueryResult;
import ai.tock.nlp.front.storage.mongo.MongoFrontConfiguration;
import ai.tock.nlp.front.storage.mongo.UserActionLogCol_;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.MongosKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.jackson.AnyValueWrapper;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.IndexOptions;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.KMongoIterableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.FindIterablesKt;
import org.litote.kmongo.Id;
import org.litote.kmongo.MongoCollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lai/tock/nlp/front/storage/mongo/UserActionLogMongoDAO;", "Lai/tock/nlp/front/service/storage/UserActionLogDAO;", "<init>", "()V", "logger", "Lmu/KLogger;", "col", "Lcom/mongodb/client/MongoCollection;", "Lai/tock/nlp/front/storage/mongo/UserActionLogMongoDAO$UserActionLogCol;", "getCol", "()Lcom/mongodb/client/MongoCollection;", "col$delegate", "Lkotlin/Lazy;", "save", "", "log", "Lai/tock/nlp/front/shared/monitoring/UserActionLog;", "search", "Lai/tock/nlp/front/shared/monitoring/UserActionLogQueryResult;", "query", "Lai/tock/nlp/front/shared/monitoring/UserActionLogQuery;", "UserActionLogCol", "tock-nlp-front-storage-mongo"})
@SourceDebugExtension(value={"SMAP\nUserActionLogMongoDAO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserActionLogMongoDAO.kt\nai/tock/nlp/front/storage/mongo/UserActionLogMongoDAO\n+ 2 MongoDatabases.kt\norg/litote/kmongo/MongoDatabasesKt\n*L\n1#1,133:1\n40#2,11:134\n*S KotlinDebug\n*F\n+ 1 UserActionLogMongoDAO.kt\nai/tock/nlp/front/storage/mongo/UserActionLogMongoDAO\n*L\n96#1:134,11\n*E\n"})
public final class UserActionLogMongoDAO
implements UserActionLogDAO {
    @NotNull
    public static final UserActionLogMongoDAO INSTANCE = new UserActionLogMongoDAO();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(UserActionLogMongoDAO::logger$lambda$0);
    @NotNull
    private static final Lazy col$delegate = LazyKt.lazy(UserActionLogMongoDAO::col_delegate$lambda$1);

    private UserActionLogMongoDAO() {
    }

    private final MongoCollection<UserActionLogCol> getCol() {
        Lazy lazy = col$delegate;
        return (MongoCollection)lazy.getValue();
    }

    public void save(@NotNull UserActionLog log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.getCol().insertOne((Object)new UserActionLogCol(log));
    }

    @NotNull
    public UserActionLogQueryResult search(@NotNull UserActionLogQuery query2) {
        UserActionLogQueryResult userActionLogQueryResult;
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        UserActionLogQuery $this$search_u24lambda_u243 = query2;
        boolean bl = false;
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)UserActionLogCol_.Companion.getNamespace()), (Object)$this$search_u24lambda_u243.getNamespace())};
        Bson baseFilter = FiltersKt.and((Bson[])bsonArray);
        long count = INSTANCE.getCol().countDocuments(baseFilter, MongosKt.getDefaultCountOptions());
        if (count > $this$search_u24lambda_u243.getStart()) {
            FindIterable findIterable = INSTANCE.getCol().find(baseFilter);
            Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"find(...)");
            KProperty[] kPropertyArray = new KProperty[]{UserActionLogCol_.Companion.getDate()};
            FindIterable list = FindIterablesKt.descendingSort((FindIterable)findIterable, (KProperty[])kPropertyArray).skip((int)$this$search_u24lambda_u243.getStart()).limit($this$search_u24lambda_u243.getSize());
            MongoIterable mongoIterable = list.map(UserActionLogMongoDAO::search$lambda$3$lambda$2);
            Intrinsics.checkNotNullExpressionValue((Object)mongoIterable, (String)"map(...)");
            userActionLogQueryResult = new UserActionLogQueryResult(count, KMongoIterableKt.toList((MongoIterable)mongoIterable));
        } else {
            userActionLogQueryResult = new UserActionLogQueryResult(0L, CollectionsKt.emptyList());
        }
        return userActionLogQueryResult;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final MongoCollection col_delegate$lambda$1() {
        void $this$getCollection$iv;
        KProperty[] kPropertyArray = MongoFrontConfiguration.INSTANCE.getDatabase();
        String collectionName$iv = "user_action_log";
        boolean $i$f$getCollection = false;
        void $this$getCollectionOfName$iv$iv = $this$getCollection$iv;
        boolean $i$f$getCollectionOfName = false;
        MongoCollection mongoCollection = $this$getCollectionOfName$iv$iv.getCollection(collectionName$iv, UserActionLogCol.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        MongoCollection c2 = mongoCollection;
        try {
            kPropertyArray = new KProperty[]{UserActionLogCol_.Companion.getNamespace(), UserActionLogCol_.Companion.getDate()};
            MongoCollectionsKt.ensureIndex$default((MongoCollection)c2, (KProperty[])kPropertyArray, null, (int)2, null);
            kPropertyArray = new KProperty[]{UserActionLogCol_.Companion.getDate()};
            IndexOptions indexOptions = new IndexOptions().expireAfter(Long.valueOf(PropertiesKt.longProperty((String)"tock_user_log_index_ttl_days", (long)365L)), TimeUnit.DAYS);
            Intrinsics.checkNotNullExpressionValue((Object)indexOptions, (String)"expireAfter(...)");
            MongoCollectionsKt.ensureIndex((MongoCollection)c2, (KProperty[])kPropertyArray, (IndexOptions)indexOptions);
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
        }
        return c2;
    }

    private static final UserActionLog search$lambda$3$lambda$2(UserActionLogCol it) {
        return it.toLog();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010B\u0011\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u000f\u0010\u0013J\u0006\u0010 \u001a\u00020\u0012J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u0010&\u001a\u00020\fH\u00c6\u0003J\t\u0010'\u001a\u00020\u000eH\u00c6\u0003JY\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010)\u001a\u00020\f2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006."}, d2={"Lai/tock/nlp/front/storage/mongo/UserActionLogMongoDAO$UserActionLogCol;", "", "namespace", "", "applicationId", "Lorg/litote/kmongo/Id;", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "login", "actionType", "newData", "Lai/tock/shared/jackson/AnyValueWrapper;", "error", "", "date", "Ljava/time/Instant;", "<init>", "(Ljava/lang/String;Lorg/litote/kmongo/Id;Ljava/lang/String;Ljava/lang/String;Lai/tock/shared/jackson/AnyValueWrapper;ZLjava/time/Instant;)V", "log", "Lai/tock/nlp/front/shared/monitoring/UserActionLog;", "(Lai/tock/nlp/front/shared/monitoring/UserActionLog;)V", "getNamespace", "()Ljava/lang/String;", "getApplicationId", "()Lorg/litote/kmongo/Id;", "getLogin", "getActionType", "getNewData", "()Lai/tock/shared/jackson/AnyValueWrapper;", "getError", "()Z", "getDate", "()Ljava/time/Instant;", "toLog", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "", "toString", "tock-nlp-front-storage-mongo"})
    @SourceDebugExtension(value={"SMAP\nUserActionLogMongoDAO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserActionLogMongoDAO.kt\nai/tock/nlp/front/storage/mongo/UserActionLogMongoDAO$UserActionLogCol\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1#2:134\n*E\n"})
    public static final class UserActionLogCol {
        @NotNull
        private final String namespace;
        @Nullable
        private final Id<ApplicationDefinition> applicationId;
        @NotNull
        private final String login;
        @NotNull
        private final String actionType;
        @Nullable
        private final AnyValueWrapper newData;
        private final boolean error;
        @NotNull
        private final Instant date;

        public UserActionLogCol(@NotNull String namespace, @Nullable Id<ApplicationDefinition> applicationId, @NotNull String login, @NotNull String actionType, @Nullable AnyValueWrapper newData, boolean error, @NotNull Instant date) {
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter((Object)login, (String)"login");
            Intrinsics.checkNotNullParameter((Object)actionType, (String)"actionType");
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            this.namespace = namespace;
            this.applicationId = applicationId;
            this.login = login;
            this.actionType = actionType;
            this.newData = newData;
            this.error = error;
            this.date = date;
        }

        public /* synthetic */ UserActionLogCol(String string, Id id, String string2, String string3, AnyValueWrapper anyValueWrapper, boolean bl, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                bl = false;
            }
            if ((n & 0x40) != 0) {
                instant = Instant.now();
            }
            this(string, (Id<ApplicationDefinition>)id, string2, string3, anyValueWrapper, bl, instant);
        }

        @NotNull
        public final String getNamespace() {
            return this.namespace;
        }

        @Nullable
        public final Id<ApplicationDefinition> getApplicationId() {
            return this.applicationId;
        }

        @NotNull
        public final String getLogin() {
            return this.login;
        }

        @NotNull
        public final String getActionType() {
            return this.actionType;
        }

        @Nullable
        public final AnyValueWrapper getNewData() {
            return this.newData;
        }

        public final boolean getError() {
            return this.error;
        }

        @NotNull
        public final Instant getDate() {
            return this.date;
        }

        /*
         * WARNING - void declaration
         */
        public UserActionLogCol(@NotNull UserActionLog log) {
            AnyValueWrapper anyValueWrapper;
            Intrinsics.checkNotNullParameter((Object)log, (String)"log");
            UserActionLogCol userActionLogCol = this;
            String string = log.getNamespace();
            Id id = log.getApplicationId();
            String string2 = log.getLogin();
            String string3 = log.getActionType();
            Object object = log.getNewData();
            if (object != null) {
                void it;
                Object object2 = object;
                String string4 = string3;
                String string5 = string2;
                Id id2 = id;
                String string6 = string;
                UserActionLogCol userActionLogCol2 = userActionLogCol;
                boolean bl = false;
                AnyValueWrapper anyValueWrapper2 = new AnyValueWrapper((Object)it);
                userActionLogCol = userActionLogCol2;
                string = string6;
                id = id2;
                string2 = string5;
                string3 = string4;
                anyValueWrapper = anyValueWrapper2;
            } else {
                anyValueWrapper = null;
            }
            userActionLogCol(string, (Id<ApplicationDefinition>)id, string2, string3, anyValueWrapper, log.getError(), log.getDate());
        }

        @NotNull
        public final UserActionLog toLog() {
            AnyValueWrapper anyValueWrapper = this.newData;
            return new UserActionLog(this.namespace, this.applicationId, this.login, this.actionType, anyValueWrapper != null ? anyValueWrapper.getValue() : null, this.error, this.date);
        }

        @NotNull
        public final String component1() {
            return this.namespace;
        }

        @Nullable
        public final Id<ApplicationDefinition> component2() {
            return this.applicationId;
        }

        @NotNull
        public final String component3() {
            return this.login;
        }

        @NotNull
        public final String component4() {
            return this.actionType;
        }

        @Nullable
        public final AnyValueWrapper component5() {
            return this.newData;
        }

        public final boolean component6() {
            return this.error;
        }

        @NotNull
        public final Instant component7() {
            return this.date;
        }

        @NotNull
        public final UserActionLogCol copy(@NotNull String namespace, @Nullable Id<ApplicationDefinition> applicationId, @NotNull String login, @NotNull String actionType, @Nullable AnyValueWrapper newData, boolean error, @NotNull Instant date) {
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter((Object)login, (String)"login");
            Intrinsics.checkNotNullParameter((Object)actionType, (String)"actionType");
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            return new UserActionLogCol(namespace, applicationId, login, actionType, newData, error, date);
        }

        public static /* synthetic */ UserActionLogCol copy$default(UserActionLogCol userActionLogCol, String string, Id id, String string2, String string3, AnyValueWrapper anyValueWrapper, boolean bl, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                string = userActionLogCol.namespace;
            }
            if ((n & 2) != 0) {
                id = userActionLogCol.applicationId;
            }
            if ((n & 4) != 0) {
                string2 = userActionLogCol.login;
            }
            if ((n & 8) != 0) {
                string3 = userActionLogCol.actionType;
            }
            if ((n & 0x10) != 0) {
                anyValueWrapper = userActionLogCol.newData;
            }
            if ((n & 0x20) != 0) {
                bl = userActionLogCol.error;
            }
            if ((n & 0x40) != 0) {
                instant = userActionLogCol.date;
            }
            return userActionLogCol.copy(string, id, string2, string3, anyValueWrapper, bl, instant);
        }

        @NotNull
        public String toString() {
            return "UserActionLogCol(namespace=" + this.namespace + ", applicationId=" + this.applicationId + ", login=" + this.login + ", actionType=" + this.actionType + ", newData=" + this.newData + ", error=" + this.error + ", date=" + this.date + ")";
        }

        public int hashCode() {
            int result2 = this.namespace.hashCode();
            result2 = result2 * 31 + (this.applicationId == null ? 0 : this.applicationId.hashCode());
            result2 = result2 * 31 + this.login.hashCode();
            result2 = result2 * 31 + this.actionType.hashCode();
            result2 = result2 * 31 + (this.newData == null ? 0 : this.newData.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.error);
            result2 = result2 * 31 + this.date.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UserActionLogCol)) {
                return false;
            }
            UserActionLogCol userActionLogCol = (UserActionLogCol)other;
            if (!Intrinsics.areEqual((Object)this.namespace, (Object)userActionLogCol.namespace)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.applicationId, userActionLogCol.applicationId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.login, (Object)userActionLogCol.login)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.actionType, (Object)userActionLogCol.actionType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.newData, (Object)userActionLogCol.newData)) {
                return false;
            }
            if (this.error != userActionLogCol.error) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.date, (Object)userActionLogCol.date);
        }
    }
}

