/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.front.storage.mongo;

import ai.tock.nlp.front.service.storage.UserNamespaceDAO;
import ai.tock.nlp.front.shared.user.UserNamespace;
import ai.tock.nlp.front.shared.user.UserNamespace_;
import ai.tock.nlp.front.storage.mongo.MongoFrontConfiguration;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.ReplaceOptions;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.KMongoIterableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.MongoCollectionsKt;
import org.litote.kmongo.UpdatesKt;
import org.litote.kmongo.util.KMongoUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001d"}, d2={"Lai/tock/nlp/front/storage/mongo/UserNamespaceMongoDAO;", "Lai/tock/nlp/front/service/storage/UserNamespaceDAO;", "<init>", "()V", "col", "Lcom/mongodb/client/MongoCollection;", "Lai/tock/nlp/front/shared/user/UserNamespace;", "getCol", "()Lcom/mongodb/client/MongoCollection;", "col$delegate", "Lkotlin/Lazy;", "getNamespaces", "", "user", "", "getUsers", "namespace", "saveNamespace", "", "deleteNamespace", "hasNamespace", "", "setCurrentNamespace", "isNamespaceOwner", "isExistingNamespace", "getCaseInsensitiveBsonFilter", "Lorg/bson/conversions/Bson;", "field", "input", "tock-nlp-front-storage-mongo"})
@SourceDebugExtension(value={"SMAP\nUserNamespaceMongoDAO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserNamespaceMongoDAO.kt\nai/tock/nlp/front/storage/mongo/UserNamespaceMongoDAO\n+ 2 MongoDatabases.kt\norg/litote/kmongo/MongoDatabasesKt\n*L\n1#1,87:1\n61#2:88\n*S KotlinDebug\n*F\n+ 1 UserNamespaceMongoDAO.kt\nai/tock/nlp/front/storage/mongo/UserNamespaceMongoDAO\n*L\n40#1:88\n*E\n"})
public final class UserNamespaceMongoDAO
implements UserNamespaceDAO {
    @NotNull
    public static final UserNamespaceMongoDAO INSTANCE = new UserNamespaceMongoDAO();
    @NotNull
    private static final Lazy col$delegate = LazyKt.lazy(UserNamespaceMongoDAO::col_delegate$lambda$0);

    private UserNamespaceMongoDAO() {
    }

    private final MongoCollection<UserNamespace> getCol() {
        Lazy lazy = col$delegate;
        return (MongoCollection)lazy.getValue();
    }

    @NotNull
    public List<UserNamespace> getNamespaces(@NotNull String user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        FindIterable findIterable = this.getCol().find(FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getLogin()), (Object)user));
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"find(...)");
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable));
    }

    @NotNull
    public List<UserNamespace> getUsers(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        FindIterable findIterable = this.getCol().find(this.getCaseInsensitiveBsonFilter(UserNamespace_.Companion.getNamespace().getName(), namespace));
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"find(...)");
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable));
    }

    public void saveNamespace(@NotNull UserNamespace namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getLogin()), (Object)namespace.getLogin()), FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getNamespace()), (Object)namespace.getNamespace())};
        this.getCol().replaceOne(FiltersKt.and((Bson[])bsonArray), (Object)namespace, new ReplaceOptions().upsert(true));
    }

    public void deleteNamespace(@NotNull String user, @NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getLogin()), (Object)user), FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getNamespace()), (Object)namespace)};
        this.getCol().deleteOne(FiltersKt.and((Bson[])bsonArray));
    }

    public boolean hasNamespace(@NotNull String user, @NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getLogin()), (Object)user), FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getNamespace()), (Object)namespace)};
        return this.getCol().countDocuments(FiltersKt.and((Bson[])bsonArray)) == 1L;
    }

    public void setCurrentNamespace(@NotNull String user, @NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        this.getCol().updateMany(FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getLogin()), (Object)user), UpdatesKt.setValue((KProperty)((KProperty)UserNamespace_.Companion.getCurrent()), (Object)false));
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getLogin()), (Object)user), FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getNamespace()), (Object)namespace)};
        this.getCol().updateOne(FiltersKt.and((Bson[])bsonArray), UpdatesKt.setValue((KProperty)((KProperty)UserNamespace_.Companion.getCurrent()), (Object)true));
    }

    public boolean isNamespaceOwner(@NotNull String user, @NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getLogin()), (Object)user), FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getNamespace()), (Object)namespace), FiltersKt.eq((KProperty)((KProperty)UserNamespace_.Companion.getOwner()), (Object)true)};
        return this.getCol().countDocuments(FiltersKt.and((Bson[])bsonArray)) == 1L;
    }

    public boolean isExistingNamespace(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        return this.getCol().countDocuments(this.getCaseInsensitiveBsonFilter(UserNamespace_.Companion.getNamespace().getName(), namespace)) != 0L;
    }

    private final Bson getCaseInsensitiveBsonFilter(String field, String input) {
        String escapedNamespace = Pattern.quote(input);
        Bson bson = Filters.regex((String)UserNamespace_.Companion.getNamespace().getName(), (String)("^" + escapedNamespace + "$"), (String)"i");
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"regex(...)");
        return bson;
    }

    private static final MongoCollection col_delegate$lambda$0() {
        MongoDatabase $this$getCollection$iv = MongoFrontConfiguration.INSTANCE.getDatabase();
        boolean $i$f$getCollection = false;
        MongoCollection mongoCollection = $this$getCollection$iv.getCollection(KMongoUtil.INSTANCE.defaultCollectionName(Reflection.getOrCreateKotlinClass(UserNamespace.class)), UserNamespace.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        MongoCollection c2 = mongoCollection;
        KProperty[] kPropertyArray = new KProperty[]{UserNamespace_.Companion.getLogin(), UserNamespace_.Companion.getNamespace()};
        MongoCollectionsKt.ensureUniqueIndex$default((MongoCollection)c2, (KProperty[])kPropertyArray, null, (int)2, null);
        kPropertyArray = new KProperty[]{UserNamespace_.Companion.getLogin()};
        MongoCollectionsKt.ensureIndex$default((MongoCollection)c2, (KProperty[])kPropertyArray, null, (int)2, null);
        kPropertyArray = new KProperty[]{UserNamespace_.Companion.getNamespace()};
        MongoCollectionsKt.ensureIndex$default((MongoCollection)c2, (KProperty[])kPropertyArray, null, (int)2, null);
        return c2;
    }
}

