/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.front.storage.mongo;

import ai.tock.nlp.front.service.storage.FaqSettingsDAO;
import ai.tock.nlp.front.shared.config.ApplicationDefinition;
import ai.tock.nlp.front.shared.config.FaqSettings;
import ai.tock.nlp.front.storage.mongo.FaqSettingsMongoDAO;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.ReplaceOptions;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.Id;
import org.litote.kmongo.MongoCollectionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u0016J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000f0\rH\u0016J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lai/tock/nlp/front/storage/mongo/FaqSettingsMongoDAO;", "Lai/tock/nlp/front/service/storage/FaqSettingsDAO;", "()V", "col", "Lcom/mongodb/client/MongoCollection;", "Lai/tock/nlp/front/shared/config/FaqSettings;", "getCol$tock_nlp_front_storage_mongo", "()Lcom/mongodb/client/MongoCollection;", "col$delegate", "Lkotlin/Lazy;", "deleteFaqSettingsById", "", "id", "Lorg/litote/kmongo/Id;", "getFaqSettingsByApplicationId", "Lai/tock/nlp/front/shared/config/ApplicationDefinition;", "getFaqSettingsById", "save", "faqSettings", "tock-nlp-front-storage-mongo"})
public final class FaqSettingsMongoDAO
implements FaqSettingsDAO {
    @NotNull
    public static final FaqSettingsMongoDAO INSTANCE = new FaqSettingsMongoDAO();
    @NotNull
    private static final Lazy col$delegate = LazyKt.lazy((Function0)col.2.INSTANCE);

    private FaqSettingsMongoDAO() {
    }

    @NotNull
    public final MongoCollection<FaqSettings> getCol$tock_nlp_front_storage_mongo() {
        Lazy lazy = col$delegate;
        return (MongoCollection)lazy.getValue();
    }

    @Nullable
    public FaqSettings getFaqSettingsById(@NotNull Id<FaqSettings> id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        return (FaqSettings)MongoCollectionsKt.findOneById(this.getCol$tock_nlp_front_storage_mongo(), id);
    }

    public void deleteFaqSettingsById(@NotNull Id<FaqSettings> id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        MongoCollectionsKt.deleteOneById(this.getCol$tock_nlp_front_storage_mongo(), id);
    }

    public void save(@NotNull FaqSettings faqSettings) {
        Intrinsics.checkNotNullParameter((Object)faqSettings, (String)"faqSettings");
        MongoCollection<FaqSettings> mongoCollection = this.getCol$tock_nlp_front_storage_mongo();
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)save.1.INSTANCE), (Object)faqSettings.getApplicationId())};
        Bson bson = FiltersKt.and((Bson[])bsonArray);
        ReplaceOptions replaceOptions = new ReplaceOptions().upsert(true);
        Intrinsics.checkNotNullExpressionValue((Object)replaceOptions, (String)"upsert(...)");
        MongoCollectionsKt.replaceOneWithFilter(mongoCollection, (Bson)bson, (Object)faqSettings, (ReplaceOptions)replaceOptions);
    }

    @Nullable
    public FaqSettings getFaqSettingsByApplicationId(@NotNull Id<ApplicationDefinition> id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        return (FaqSettings)MongoCollectionsKt.findOne(this.getCol$tock_nlp_front_storage_mongo(), (Bson)FiltersKt.eq((KProperty)((KProperty)getFaqSettingsByApplicationId.1.INSTANCE), id));
    }
}

