/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.opennlp;

import ai.tock.nlp.core.Application;
import ai.tock.nlp.core.configuration.NlpApplicationConfiguration;
import ai.tock.nlp.core.configuration.NlpModelConfiguration;
import ai.tock.nlp.core.sample.SampleEntity;
import ai.tock.nlp.core.sample.SampleExpression;
import ai.tock.nlp.model.EntityBuildContext;
import ai.tock.nlp.model.EntityContext;
import ai.tock.nlp.model.IntentContext;
import ai.tock.nlp.model.TokenizerContext;
import ai.tock.nlp.model.service.engine.EntityModelHolder;
import ai.tock.nlp.model.service.engine.IntentModelHolder;
import ai.tock.nlp.model.service.engine.NlpEngineModelBuilder;
import ai.tock.nlp.model.service.engine.TokenizerModelHolder;
import ai.tock.nlp.opennlp.OpenNlpModelBuilder;
import ai.tock.nlp.opennlp.OpenNlpNameFinderME;
import ai.tock.nlp.opennlp.OpenNlpTokenizer;
import ai.tock.shared.PropertiesKt;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import opennlp.tools.ml.maxent.GISModel;
import opennlp.tools.ml.maxent.GISTrainer;
import opennlp.tools.ml.model.AbstractDataIndexer;
import opennlp.tools.ml.model.Context;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.OnePassRealValueDataIndexer;
import opennlp.tools.ml.model.TwoPassDataIndexer;
import opennlp.tools.namefind.BilouCodec;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.TokenNameFinderFactory;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.ObjectStreamUtils;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.Span;
import opennlp.tools.util.TrainingParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lai/tock/nlp/opennlp/OpenNlpModelBuilder;", "Lai/tock/nlp/model/service/engine/NlpEngineModelBuilder;", "()V", "MIN_BUILD_SIZE", "", "defaultEntityClassifierConfiguration", "Lai/tock/nlp/core/configuration/NlpModelConfiguration;", "getDefaultEntityClassifierConfiguration", "()Lai/tock/nlp/core/configuration/NlpModelConfiguration;", "defaultIntentClassifierConfiguration", "getDefaultIntentClassifierConfiguration", "logger", "Lmu/KLogger;", "buildEntityModel", "Lai/tock/nlp/model/service/engine/EntityModelHolder;", "context", "Lai/tock/nlp/model/EntityBuildContext;", "configuration", "Lai/tock/nlp/core/configuration/NlpApplicationConfiguration;", "expressions", "", "Lai/tock/nlp/core/sample/SampleExpression;", "buildIntentModel", "Lai/tock/nlp/model/service/engine/IntentModelHolder;", "Lai/tock/nlp/model/IntentContext;", "defaultNlpApplicationConfiguration", "tock-nlp-model-opennlp"})
public final class OpenNlpModelBuilder
implements NlpEngineModelBuilder {
    private static final KLogger logger;
    private static final int MIN_BUILD_SIZE = 2;
    @NotNull
    private static final NlpModelConfiguration defaultIntentClassifierConfiguration;
    @NotNull
    private static final NlpModelConfiguration defaultEntityClassifierConfiguration;
    @NotNull
    public static final OpenNlpModelBuilder INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IntentModelHolder buildIntentModel(@NotNull IntentContext context, @NotNull NlpApplicationConfiguration configuration, @NotNull List<SampleExpression> expressions) {
        GISModel gISModel;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        OpenNlpTokenizer tokenizer = new OpenNlpTokenizer(new TokenizerModelHolder(context.getLanguage(), configuration));
        TokenizerContext tokenizerContext = new TokenizerContext(context);
        if (expressions.size() < 2) {
            gISModel = new GISModel(new Context[0], new String[0], new String[0]);
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = expressions;
            boolean $i$f$map = false;
            void var10_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SampleExpression sampleExpression = (SampleExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Event event = new Event(it.getIntent().getName(), tokenizer.tokenize(tokenizerContext, it.getText()));
                collection.add(event);
            }
            ObjectStream events = ObjectStreamUtils.createObjectStream((Collection)((List)destination$iv$iv));
            AbstractDataIndexer dataIndexer = expressions.size() < 100 ? (AbstractDataIndexer)new OnePassRealValueDataIndexer() : (AbstractDataIndexer)new TwoPassDataIndexer();
            TrainingParameters param = new TrainingParameters();
            if (expressions.size() < 1000) {
                param.put("Cutoff", 1);
            }
            Map $this$forEach$iv = configuration.getIntentConfiguration().getProperties();
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl2 = false;
                Object v = it.getValue();
                param.put(it.getKey().toString(), v != null ? v.toString() : null);
            }
            dataIndexer.init(param, null);
            dataIndexer.index(events);
            gISModel = new GISTrainer().trainModel(1000, (DataIndexer)dataIndexer);
        }
        GISModel model2 = gISModel;
        Application application = context.getApplication();
        GISModel gISModel2 = model2;
        Intrinsics.checkNotNullExpressionValue((Object)gISModel2, (String)"model");
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"Instant.now()");
        return new IntentModelHolder(application, (Object)gISModel2, configuration, instant);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public EntityModelHolder buildEntityModel(@NotNull EntityBuildContext context, @NotNull NlpApplicationConfiguration configuration, @NotNull List<SampleExpression> expressions) {
        EntityModelHolder entityModelHolder;
        TokenNameFinderModel model2;
        TokenNameFinderModel tokenNameFinderModel;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        if (expressions.size() < 2) {
            tokenNameFinderModel = null;
        } else {
            void $this$mapNotNullTo$iv$iv;
            OpenNlpTokenizer tokenizer = new OpenNlpTokenizer(new TokenizerModelHolder(context.getLanguage(), configuration));
            TokenizerContext tokenizerContext = new TokenizerContext((EntityContext)context);
            boolean bl = false;
            Map spanEntityMap = new LinkedHashMap();
            int entityCount = 0;
            Iterable $this$mapNotNull$iv = expressions;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                NameSample nameSample;
                void $this$toTypedArray$iv;
                void $this$mapNotNullTo$iv$iv2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                SampleExpression expression = (SampleExpression)element$iv$iv;
                boolean bl3 = false;
                String text = expression.getText();
                String[] tokens = tokenizer.tokenize(tokenizerContext, text);
                Iterable $this$mapNotNull$iv2 = expression.getEntities();
                boolean $i$f$mapNotNull2 = false;
                Iterable iterable2 = $this$mapNotNull$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
                while (iterator2.hasNext()) {
                    Span span;
                    int n;
                    int n2;
                    int n3;
                    Object element$iv$iv$iv2;
                    Object element$iv$iv2 = element$iv$iv$iv2 = iterator2.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    SampleEntity e = (SampleEntity)element$iv$iv2;
                    boolean bl4 = false;
                    if (e.getStart() == 0) {
                        n3 = 0;
                    } else {
                        String string = text;
                        int n4 = 0;
                        n2 = e.getStart();
                        n = 0;
                        String string2 = string;
                        if (string2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string3 = string2.substring(n4, n2);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        n3 = tokenizer.tokenize(tokenizerContext, string3).length;
                    }
                    int start = n3;
                    String string = text;
                    n2 = e.getStart();
                    n = e.getEnd();
                    boolean bl5 = false;
                    String string4 = string;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n2, n);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    int end = start + tokenizer.tokenize(tokenizerContext, string5).length;
                    if (start >= tokens.length || end > tokens.length) {
                        span = null;
                    } else {
                        int n5 = entityCount;
                        entityCount = n5 + 1;
                        Span roleSpan = new Span(start, end, e.getDefinition().getRole());
                        spanEntityMap.put(roleSpan, e);
                        span = roleSpan;
                    }
                    if (span == null) continue;
                    Span span2 = span;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    Span it$iv$iv = span2;
                    boolean bl8 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                $this$mapNotNull$iv2 = (List)destination$iv$iv2;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                Span[] spanArray = thisCollection$iv.toArray(new Span[0]);
                if (spanArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                Span[] spans = (Span[])ArraysKt.sortedArray((Comparable[])((Comparable[])spanArray));
                if (spans.length == expression.getEntities().size()) {
                    NameSample nameSample2;
                    try {
                        nameSample2 = new NameSample(tokens, spans, false);
                    }
                    catch (Exception e) {
                        logger.warn("error with " + text + " when reunify entities", (Throwable)e);
                        nameSample2 = null;
                    }
                    nameSample = nameSample2;
                } else {
                    logger.warn((Function0)new Function0<Object>(text){
                        final /* synthetic */ String $text;

                        @Nullable
                        public final Object invoke() {
                            return "error with " + this.$text + " when reunify entities";
                        }
                        {
                            this.$text = string;
                            super(0);
                        }
                    });
                    nameSample = null;
                }
                if (nameSample == null) continue;
                NameSample nameSample3 = nameSample;
                boolean bl9 = false;
                boolean bl10 = false;
                NameSample it$iv$iv = nameSample3;
                boolean bl11 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List trainingEvents2 = (List)destination$iv$iv;
            if (entityCount < 2) {
                tokenNameFinderModel = null;
            } else {
                TrainingParameters params = new TrainingParameters();
                Map $this$forEach$iv = configuration.getEntityConfiguration().getProperties();
                boolean $i$f$forEach3 = false;
                Map map = $this$forEach$iv;
                boolean bl12 = false;
                Iterator iterator3 = map.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator3.next();
                    boolean bl13 = false;
                    Object v = it.getValue();
                    params.put(it.getKey().toString(), v != null ? v.toString() : null);
                }
                tokenNameFinderModel = model2 = NameFinderME.train((String)context.getLanguage().getLanguage(), null, (ObjectStream)ObjectStreamUtils.createObjectStream((Collection)trainingEvents2), (TrainingParameters)params, (TokenNameFinderFactory)new TokenNameFinderFactory(null, null, (SequenceCodec)new BilouCodec()));
            }
        }
        if (model2 == null) {
            entityModelHolder = null;
        } else {
            OpenNlpNameFinderME openNlpNameFinderME = new OpenNlpNameFinderME(model2);
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"Instant.now()");
            entityModelHolder = new EntityModelHolder((Object)openNlpNameFinderME, configuration, instant);
        }
        return entityModelHolder;
    }

    @NotNull
    public NlpModelConfiguration getDefaultIntentClassifierConfiguration() {
        return defaultIntentClassifierConfiguration;
    }

    @NotNull
    public NlpModelConfiguration getDefaultEntityClassifierConfiguration() {
        return defaultEntityClassifierConfiguration;
    }

    @NotNull
    public NlpApplicationConfiguration defaultNlpApplicationConfiguration() {
        return new NlpApplicationConfiguration(null, this.getDefaultIntentClassifierConfiguration(), this.getDefaultEntityClassifierConfiguration(), null, false, false, false, false, 233, null);
    }

    private OpenNlpModelBuilder() {
    }

    static {
        OpenNlpModelBuilder openNlpModelBuilder;
        INSTANCE = openNlpModelBuilder = new OpenNlpModelBuilder();
        logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        defaultIntentClassifierConfiguration = new NlpModelConfiguration(PropertiesKt.loadProperties((String)"/opennlp/defaultIntentClassifier.properties"), null, false, false, 14, null);
        defaultEntityClassifierConfiguration = new NlpModelConfiguration(PropertiesKt.loadProperties((String)"/opennlp/defaultEntityClassifier.properties"), null, false, false, 14, null);
    }

    @NotNull
    public NlpModelConfiguration getDefaultTokenizerConfiguration() {
        return NlpEngineModelBuilder.DefaultImpls.getDefaultTokenizerConfiguration((NlpEngineModelBuilder)this);
    }

    @NotNull
    public TokenizerModelHolder buildTokenizerModel(@NotNull TokenizerContext context, @NotNull NlpApplicationConfiguration configuration, @NotNull List<SampleExpression> expressions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        return NlpEngineModelBuilder.DefaultImpls.buildTokenizerModel((NlpEngineModelBuilder)this, (TokenizerContext)context, (NlpApplicationConfiguration)configuration, expressions);
    }
}

