/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.opennlp;

import ai.tock.nlp.core.Entity;
import ai.tock.nlp.core.EntityRecognition;
import ai.tock.nlp.core.EntityValue;
import ai.tock.nlp.model.EntityCallContext;
import ai.tock.nlp.model.EntityCallContextForEntity;
import ai.tock.nlp.model.EntityCallContextForIntent;
import ai.tock.nlp.model.EntityCallContextForSubEntities;
import ai.tock.nlp.model.service.engine.EntityModelHolder;
import ai.tock.nlp.model.service.engine.NlpEntityClassifier;
import ai.tock.nlp.opennlp.OpenNlpEntityClassifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.util.Span;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J1\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J1\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002\u00a2\u0006\u0002\u0010\u0012J?\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0002\u00a2\u0006\u0002\u0010\u0016J1\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0016\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lai/tock/nlp/opennlp/OpenNlpEntityClassifier;", "Lai/tock/nlp/model/service/engine/NlpEntityClassifier;", "model", "Lai/tock/nlp/model/service/engine/EntityModelHolder;", "(Lai/tock/nlp/model/service/engine/EntityModelHolder;)V", "logger", "Lmu/KLogger;", "classify", "", "Lai/tock/nlp/core/EntityRecognition;", "context", "Lai/tock/nlp/model/EntityCallContextForIntent;", "text", "", "tokens", "", "(Lai/tock/nlp/model/EntityCallContextForIntent;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "Lai/tock/nlp/model/EntityCallContextForSubEntities;", "(Lai/tock/nlp/model/EntityCallContextForSubEntities;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "entityFinder", "Lkotlin/Function1;", "Lai/tock/nlp/core/Entity;", "(Ljava/lang/String;[Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "classifyEntities", "Lai/tock/nlp/model/EntityCallContext;", "(Lai/tock/nlp/model/EntityCallContext;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "tock-nlp-model-opennlp"})
public final class OpenNlpEntityClassifier
extends NlpEntityClassifier {
    @NotNull
    private final KLogger logger;

    public OpenNlpEntityClassifier(@NotNull EntityModelHolder model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        super(model2);
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    }

    @NotNull
    public List<EntityRecognition> classifyEntities(@NotNull EntityCallContext context, @NotNull String text, @NotNull String[] tokens) {
        List<EntityRecognition> list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        EntityCallContext entityCallContext = context;
        if (entityCallContext instanceof EntityCallContextForIntent) {
            list = this.classify((EntityCallContextForIntent)context, text, tokens);
        } else {
            if (entityCallContext instanceof EntityCallContextForEntity) {
                throw new IllegalStateException("EntityCallContextForEntity is not supported".toString());
            }
            if (entityCallContext instanceof EntityCallContextForSubEntities) {
                list = this.classify((EntityCallContextForSubEntities)context, text, tokens);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    private final List<EntityRecognition> classify(EntityCallContextForSubEntities context, String text, String[] tokens) {
        return this.classify(text, tokens, (Function1<? super String, Entity>)((Function1)new Function1<String, Entity>(context){
            final /* synthetic */ EntityCallContextForSubEntities $context;
            {
                this.$context = $context;
                super(1);
            }

            @Nullable
            public final Entity invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$context.getEntityType().findSubEntity(it);
            }
        }));
    }

    private final List<EntityRecognition> classify(EntityCallContextForIntent context, String text, String[] tokens) {
        return this.classify(text, tokens, (Function1<? super String, Entity>)((Function1)new Function1<String, Entity>(context){
            final /* synthetic */ EntityCallContextForIntent $context;
            {
                this.$context = $context;
                super(1);
            }

            @Nullable
            public final Entity invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$context.getIntent().getEntity(it);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final List<EntityRecognition> classify(String text, String[] tokens, Function1<? super String, Entity> entityFinder) {
        void $this$mapIndexedNotNullTo$iv$iv;
        EntityModelHolder $this$classify_u24lambda_u242 = this.getModel();
        boolean bl = false;
        Object object = $this$classify_u24lambda_u242.getNativeModel();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type opennlp.tools.namefind.NameFinderME");
        NameFinderME finder = (NameFinderME)object;
        Span[] spans = finder.find(tokens);
        double entityProbability = 0.0;
        int nbEntitySpans = 0;
        Intrinsics.checkNotNullExpressionValue((Object)spans, (String)"spans");
        Span[] $this$mapIndexedNotNull$iv = spans;
        boolean $i$f$mapIndexedNotNull = false;
        Span[] spanArray = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (void item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            EntityRecognition entityRecognition;
            void span;
            void element$iv$iv;
            int n = index$iv$iv$iv++;
            void var20_21 = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl2 = false;
            void var23_24 = element$iv$iv;
            int index = index$iv$iv;
            boolean bl3 = false;
            entityProbability += span.getProb();
            ++nbEntitySpans;
            int nextIndex = index + 1;
            if (nextIndex < spans.length && Intrinsics.areEqual((Object)spans[nextIndex].getType(), (Object)span.getType()) && span.getEnd() == spans[nextIndex].getStart()) {
                entityRecognition = null;
            } else {
                int n2;
                String t = text;
                int start = 0;
                Iterable iterable = (Iterable)RangesKt.until((int)0, (int)(nbEntitySpans - 1));
                int n3 = span.getStart();
                int n4 = 0;
                Iterator iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int n5;
                    int n6 = n5 = ((IntIterator)iterator).nextInt();
                    n2 = n4;
                    boolean bl4 = false;
                    int n7 = spans[index - it - 1].length();
                    n4 = n2 + n7;
                }
                n2 = n4;
                int tokenStart = n3 - n2;
                for (int i = 0; i < tokenStart; ++i) {
                    int nextTokenIndex = tokens[i].length() + StringsKt.indexOf$default((CharSequence)t, (String)tokens[i], (int)0, (boolean)false, (int)6, null);
                    start += nextTokenIndex;
                    Intrinsics.checkNotNullExpressionValue((Object)t.substring(nextTokenIndex), (String)"this as java.lang.String).substring(startIndex)");
                }
                int end = start;
                start += StringsKt.indexOf$default((CharSequence)t, (String)tokens[tokenStart], (int)0, (boolean)false, (int)6, null);
                int n8 = span.getEnd();
                for (int i = tokenStart; i < n8; ++i) {
                    int nextTokenIndex = tokens[i].length() + StringsKt.indexOf$default((CharSequence)t, (String)tokens[i], (int)0, (boolean)false, (int)6, null);
                    end += nextTokenIndex;
                    Intrinsics.checkNotNullExpressionValue((Object)t.substring(nextTokenIndex), (String)"this as java.lang.String).substring(startIndex)");
                }
                if (end > text.length()) {
                    throw new IllegalStateException("Parsing error".toString());
                }
                double entityProba = entityProbability / (double)nbEntitySpans;
                entityProbability = 0.0;
                nbEntitySpans = 0;
                String string = span.getType();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"span.type");
                Entity entity = (Entity)entityFinder.invoke((Object)string);
                if (entity == null) {
                    this.logger.warn((Function0)new Function0<Object>((Span)span){
                        final /* synthetic */ Span $span;
                        {
                            this.$span = $span;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "unknown entity role " + this.$span.getType();
                        }
                    });
                    entityRecognition = null;
                } else {
                    entityRecognition = new EntityRecognition(new EntityValue(start, end, entity, null, null, false, 48, null), entityProba);
                }
            }
            if (entityRecognition == null) continue;
            EntityRecognition it$iv$iv = entityRecognition;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }
}

