/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.opennlp;

import ai.tock.nlp.core.NlpEngineType;
import ai.tock.nlp.model.service.engine.EntityClassifier;
import ai.tock.nlp.model.service.engine.EntityModelHolder;
import ai.tock.nlp.model.service.engine.IntentClassifier;
import ai.tock.nlp.model.service.engine.IntentModelHolder;
import ai.tock.nlp.model.service.engine.NlpEngineModelBuilder;
import ai.tock.nlp.model.service.engine.NlpEngineModelIo;
import ai.tock.nlp.model.service.engine.NlpEngineProvider;
import ai.tock.nlp.model.service.engine.Tokenizer;
import ai.tock.nlp.model.service.engine.TokenizerModelHolder;
import ai.tock.nlp.opennlp.OpenNlpEntityClassifier;
import ai.tock.nlp.opennlp.OpenNlpIntentClassifier;
import ai.tock.nlp.opennlp.OpenNlpModelBuilder;
import ai.tock.nlp.opennlp.OpenNlpModelIo;
import ai.tock.nlp.opennlp.OpenNlpTokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lai/tock/nlp/opennlp/OpenNlpEngineProvider;", "Lai/tock/nlp/model/service/engine/NlpEngineProvider;", "<init>", "()V", "type", "Lai/tock/nlp/core/NlpEngineType;", "getType", "()Lai/tock/nlp/core/NlpEngineType;", "getIntentClassifier", "Lai/tock/nlp/model/service/engine/IntentClassifier;", "model", "Lai/tock/nlp/model/service/engine/IntentModelHolder;", "getEntityClassifier", "Lai/tock/nlp/model/service/engine/EntityClassifier;", "Lai/tock/nlp/model/service/engine/EntityModelHolder;", "getTokenizer", "Lai/tock/nlp/model/service/engine/Tokenizer;", "Lai/tock/nlp/model/service/engine/TokenizerModelHolder;", "modelBuilder", "Lai/tock/nlp/model/service/engine/NlpEngineModelBuilder;", "getModelBuilder", "()Lai/tock/nlp/model/service/engine/NlpEngineModelBuilder;", "modelIo", "Lai/tock/nlp/model/service/engine/NlpEngineModelIo;", "getModelIo", "()Lai/tock/nlp/model/service/engine/NlpEngineModelIo;", "tock-nlp-model-opennlp"})
public final class OpenNlpEngineProvider
implements NlpEngineProvider {
    @NotNull
    private final NlpEngineType type = NlpEngineType.Companion.getOpennlp();
    @NotNull
    private final NlpEngineModelBuilder modelBuilder = OpenNlpModelBuilder.INSTANCE;
    @NotNull
    private final NlpEngineModelIo modelIo = OpenNlpModelIo.INSTANCE;

    @NotNull
    public NlpEngineType getType() {
        return this.type;
    }

    @NotNull
    public IntentClassifier getIntentClassifier(@NotNull IntentModelHolder model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return (IntentClassifier)new OpenNlpIntentClassifier(model);
    }

    @NotNull
    public EntityClassifier getEntityClassifier(@NotNull EntityModelHolder model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return (EntityClassifier)new OpenNlpEntityClassifier(model);
    }

    @NotNull
    public Tokenizer getTokenizer(@NotNull TokenizerModelHolder model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return (Tokenizer)new OpenNlpTokenizer(model);
    }

    @NotNull
    public NlpEngineModelBuilder getModelBuilder() {
        return this.modelBuilder;
    }

    @NotNull
    public NlpEngineModelIo getModelIo() {
        return this.modelIo;
    }
}

