/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.opennlp;

import ai.tock.nlp.model.service.engine.NlpEngineModelIo;
import ai.tock.nlp.model.service.storage.NlpModelStream;
import ai.tock.nlp.opennlp.OpenNlpNameFinderME;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import opennlp.tools.ml.maxent.io.BinaryGISModelReader;
import opennlp.tools.ml.maxent.io.BinaryGISModelWriter;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinderModel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lai/tock/nlp/opennlp/OpenNlpModelIo;", "Lai/tock/nlp/model/service/engine/NlpEngineModelIo;", "<init>", "()V", "loadTokenizerModel", "", "input", "Lai/tock/nlp/model/service/storage/NlpModelStream;", "loadIntentModel", "loadEntityModel", "copyTokenizerModel", "", "model", "output", "Ljava/io/OutputStream;", "copyIntentModel", "copyEntityModel", "tock-nlp-model-opennlp"})
public final class OpenNlpModelIo
implements NlpEngineModelIo {
    @NotNull
    public static final OpenNlpModelIo INSTANCE = new OpenNlpModelIo();

    private OpenNlpModelIo() {
    }

    @NotNull
    public Object loadTokenizerModel(@NotNull NlpModelStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        throw new IllegalStateException("loading tokenizer model is not supported".toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Object loadIntentModel(@NotNull NlpModelStream input) {
        AbstractModel abstractModel;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Closeable closeable = input.getInputStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            AbstractModel abstractModel2 = new BinaryGISModelReader(new DataInputStream(it)).getModel();
            abstractModel = abstractModel2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)abstractModel, (String)"use(...)");
        return abstractModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Object loadEntityModel(@NotNull NlpModelStream input) {
        NameFinderME nameFinderME;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Closeable closeable = input.getInputStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            nameFinderME = new NameFinderME(new TokenNameFinderModel(it));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return nameFinderME;
    }

    public void copyTokenizerModel(@NotNull Object model, @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        throw new IllegalStateException("copying tokenizer model is not supported".toString());
    }

    public void copyIntentModel(@NotNull Object model, @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        new BinaryGISModelWriter((AbstractModel)model, new DataOutputStream(output)).persist();
    }

    public void copyEntityModel(@NotNull Object model, @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        ((OpenNlpNameFinderME)((Object)model)).getTokenNameFinderModel().serialize(output);
    }
}

