/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.opennlp;

import ai.tock.nlp.core.Application;
import ai.tock.nlp.core.configuration.NlpApplicationConfiguration;
import ai.tock.nlp.core.configuration.NlpModelConfiguration;
import ai.tock.nlp.core.sample.SampleEntity;
import ai.tock.nlp.core.sample.SampleExpression;
import ai.tock.nlp.model.EntityBuildContext;
import ai.tock.nlp.model.EntityContext;
import ai.tock.nlp.model.IntentContext;
import ai.tock.nlp.model.TokenizerContext;
import ai.tock.nlp.model.service.engine.EntityModelHolder;
import ai.tock.nlp.model.service.engine.IntentModelHolder;
import ai.tock.nlp.model.service.engine.NlpEngineModelBuilder;
import ai.tock.nlp.model.service.engine.TokenizerModelHolder;
import ai.tock.nlp.opennlp.OpenNlpModelBuilder;
import ai.tock.nlp.opennlp.OpenNlpNameFinderME;
import ai.tock.nlp.opennlp.OpenNlpTokenizer;
import ai.tock.shared.PropertiesKt;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import opennlp.tools.ml.maxent.GISModel;
import opennlp.tools.ml.maxent.GISTrainer;
import opennlp.tools.ml.model.AbstractDataIndexer;
import opennlp.tools.ml.model.Context;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.OnePassRealValueDataIndexer;
import opennlp.tools.ml.model.TwoPassDataIndexer;
import opennlp.tools.namefind.BilouCodec;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.TokenNameFinderFactory;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.ObjectStreamUtils;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.Span;
import opennlp.tools.util.TrainingParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lai/tock/nlp/opennlp/OpenNlpModelBuilder;", "Lai/tock/nlp/model/service/engine/NlpEngineModelBuilder;", "()V", "MIN_BUILD_SIZE", "", "defaultEntityClassifierConfiguration", "Lai/tock/nlp/core/configuration/NlpModelConfiguration;", "getDefaultEntityClassifierConfiguration", "()Lai/tock/nlp/core/configuration/NlpModelConfiguration;", "defaultIntentClassifierConfiguration", "getDefaultIntentClassifierConfiguration", "logger", "Lmu/KLogger;", "buildEntityModel", "Lai/tock/nlp/model/service/engine/EntityModelHolder;", "context", "Lai/tock/nlp/model/EntityBuildContext;", "configuration", "Lai/tock/nlp/core/configuration/NlpApplicationConfiguration;", "expressions", "", "Lai/tock/nlp/core/sample/SampleExpression;", "buildIntentModel", "Lai/tock/nlp/model/service/engine/IntentModelHolder;", "Lai/tock/nlp/model/IntentContext;", "defaultNlpApplicationConfiguration", "tock-nlp-model-opennlp"})
@SourceDebugExtension(value={"SMAP\nOpenNlpModelBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenNlpModelBuilder.kt\nai/tock/nlp/opennlp/OpenNlpModelBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,177:1\n1557#2:178\n1628#2,3:179\n1611#2,9:184\n1863#2:193\n1611#2,9:194\n1863#2:203\n1864#2:205\n1620#2:206\n1864#2:212\n1620#2:213\n216#3,2:182\n216#3,2:214\n1#4:204\n1#4:211\n37#5:207\n36#5,3:208\n*S KotlinDebug\n*F\n+ 1 OpenNlpModelBuilder.kt\nai/tock/nlp/opennlp/OpenNlpModelBuilder\n*L\n68#1:178\n68#1:179,3\n103#1:184,9\n103#1:193\n106#1:194,9\n106#1:203\n106#1:205\n106#1:206\n103#1:212\n103#1:213\n77#1:182,2\n141#1:214,2\n106#1:204\n103#1:211\n118#1:207\n118#1:208,3\n*E\n"})
public final class OpenNlpModelBuilder
implements NlpEngineModelBuilder {
    @NotNull
    public static final OpenNlpModelBuilder INSTANCE = new OpenNlpModelBuilder();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    private static final int MIN_BUILD_SIZE = 2;
    @NotNull
    private static final NlpModelConfiguration defaultIntentClassifierConfiguration = new NlpModelConfiguration(PropertiesKt.loadProperties((String)"/opennlp/defaultIntentClassifier.properties"), null, false, false, 14, null);
    @NotNull
    private static final NlpModelConfiguration defaultEntityClassifierConfiguration = new NlpModelConfiguration(PropertiesKt.loadProperties((String)"/opennlp/defaultEntityClassifier.properties"), null, false, false, 14, null);

    private OpenNlpModelBuilder() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IntentModelHolder buildIntentModel(@NotNull IntentContext context, @NotNull NlpApplicationConfiguration configuration, @NotNull List<SampleExpression> expressions) {
        GISModel gISModel;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        OpenNlpTokenizer tokenizer = new OpenNlpTokenizer(new TokenizerModelHolder(context.getLanguage(), configuration));
        TokenizerContext tokenizerContext = new TokenizerContext(context);
        if (expressions.size() < 2) {
            gISModel = new GISModel(new Context[0], new String[0], new String[0]);
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = expressions;
            boolean $i$f$map = false;
            void var10_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SampleExpression sampleExpression = (SampleExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Event(it.getIntent().getName(), (CharSequence[])tokenizer.tokenize(tokenizerContext, it.getText())));
            }
            ObjectStream events = ObjectStreamUtils.createObjectStream((Collection)((List)destination$iv$iv));
            AbstractDataIndexer dataIndexer = expressions.size() < 100 ? (AbstractDataIndexer)new OnePassRealValueDataIndexer() : (AbstractDataIndexer)new TwoPassDataIndexer();
            TrainingParameters param = new TrainingParameters();
            if (expressions.size() < 1000) {
                param.put("Cutoff", 1);
            }
            Map $this$forEach$iv = configuration.getIntentConfiguration().getProperties();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl = false;
                Object v = it.getValue();
                param.put(it.getKey().toString(), v != null ? v.toString() : null);
            }
            dataIndexer.init(param, null);
            dataIndexer.index(events);
            gISModel = new GISTrainer().trainModel(1000, (DataIndexer)dataIndexer);
        }
        GISModel model2 = gISModel;
        Application application = context.getApplication();
        Intrinsics.checkNotNull((Object)model2);
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        return new IntentModelHolder(application, (Object)model2, configuration, instant);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public EntityModelHolder buildEntityModel(@NotNull EntityBuildContext context, @NotNull NlpApplicationConfiguration configuration, @NotNull List<SampleExpression> expressions) {
        EntityModelHolder entityModelHolder;
        TokenNameFinderModel model2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        if (expressions.size() < 2) {
            v0 = null;
        } else {
            void $this$mapNotNullTo$iv$iv;
            OpenNlpTokenizer tokenizer = new OpenNlpTokenizer(new TokenizerModelHolder(context.getLanguage(), configuration));
            TokenizerContext tokenizerContext = new TokenizerContext((EntityContext)context);
            Map spanEntityMap = new LinkedHashMap();
            int entityCount = 0;
            Iterable $this$mapNotNull$iv = expressions;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                NameSample nameSample;
                void $this$toTypedArray$iv;
                void $this$mapNotNullTo$iv$iv2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                SampleExpression expression = (SampleExpression)element$iv$iv;
                boolean bl2 = false;
                String text = expression.getText();
                String[] tokens = tokenizer.tokenize(tokenizerContext, text);
                Iterable $this$mapNotNull$iv2 = expression.getEntities();
                boolean $i$f$mapNotNull2 = false;
                Iterable iterable2 = $this$mapNotNull$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
                while (iterator2.hasNext()) {
                    Span span;
                    int n;
                    Object element$iv$iv$iv2;
                    Object element$iv$iv2 = element$iv$iv$iv2 = iterator2.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    SampleEntity e = (SampleEntity)element$iv$iv2;
                    boolean bl3 = false;
                    if (e.getStart() == 0) {
                        n = 0;
                    } else {
                        String string = text.substring(0, e.getStart());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        n = tokenizer.tokenize(tokenizerContext, string).length;
                    }
                    int start = n;
                    String string = text.substring(e.getStart(), e.getEnd());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    int end = start + tokenizer.tokenize(tokenizerContext, string).length;
                    if (start >= tokens.length || end > tokens.length) {
                        span = null;
                    } else {
                        ++entityCount;
                        Span roleSpan = new Span(start, end, e.getDefinition().getRole());
                        spanEntityMap.put(roleSpan, e);
                        span = roleSpan;
                    }
                    if (span == null) continue;
                    Span it$iv$iv = span;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                $this$mapNotNull$iv2 = (List)destination$iv$iv2;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                Span[] spans = (Span[])ArraysKt.sortedArray((Comparable[])((Comparable[])thisCollection$iv.toArray(new Span[0])));
                if (spans.length == expression.getEntities().size()) {
                    NameSample nameSample2;
                    try {
                        nameSample2 = new NameSample(tokens, spans, false);
                    }
                    catch (Exception e) {
                        logger.warn("error with " + text + " when reunify entities", (Throwable)e);
                        nameSample2 = null;
                    }
                    nameSample = nameSample2;
                } else {
                    logger.warn((Function0)new Function0<Object>(text){
                        final /* synthetic */ String $text;
                        {
                            this.$text = $text;
                            super(0);
                        }

                        public final Object invoke() {
                            return "error with " + this.$text + " when reunify entities";
                        }
                    });
                    nameSample = null;
                }
                if (nameSample == null) continue;
                NameSample it$iv$iv = nameSample;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List trainingEvents2 = (List)destination$iv$iv;
            if (entityCount < 2) {
                v0 = null;
            } else {
                TrainingParameters params = new TrainingParameters();
                Map $this$forEach$iv = configuration.getEntityConfiguration().getProperties();
                boolean $i$f$forEach3 = false;
                Iterator iterator3 = $this$forEach$iv.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator3.next();
                    boolean bl = false;
                    Object v = it.getValue();
                    params.put(it.getKey().toString(), v != null ? v.toString() : null);
                }
                v0 = model2 = NameFinderME.train((String)context.getLanguage().getLanguage(), null, (ObjectStream)ObjectStreamUtils.createObjectStream((Collection)trainingEvents2), (TrainingParameters)params, (TokenNameFinderFactory)new TokenNameFinderFactory(null, null, (SequenceCodec)new BilouCodec()));
            }
        }
        if (model2 == null) {
            entityModelHolder = null;
        } else {
            OpenNlpNameFinderME openNlpNameFinderME = new OpenNlpNameFinderME(model2);
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            entityModelHolder = new EntityModelHolder((Object)openNlpNameFinderME, configuration, instant);
        }
        return entityModelHolder;
    }

    @NotNull
    public NlpModelConfiguration getDefaultIntentClassifierConfiguration() {
        return defaultIntentClassifierConfiguration;
    }

    @NotNull
    public NlpModelConfiguration getDefaultEntityClassifierConfiguration() {
        return defaultEntityClassifierConfiguration;
    }

    @NotNull
    public NlpApplicationConfiguration defaultNlpApplicationConfiguration() {
        return new NlpApplicationConfiguration(null, this.getDefaultIntentClassifierConfiguration(), this.getDefaultEntityClassifierConfiguration(), null, false, false, false, false, 233, null);
    }

    @NotNull
    public NlpModelConfiguration getDefaultTokenizerConfiguration() {
        return NlpEngineModelBuilder.DefaultImpls.getDefaultTokenizerConfiguration((NlpEngineModelBuilder)this);
    }

    @NotNull
    public TokenizerModelHolder buildTokenizerModel(@NotNull TokenizerContext context, @NotNull NlpApplicationConfiguration configuration, @NotNull List<SampleExpression> expressions) {
        return NlpEngineModelBuilder.DefaultImpls.buildTokenizerModel((NlpEngineModelBuilder)this, (TokenizerContext)context, (NlpApplicationConfiguration)configuration, expressions);
    }
}

