/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.model.service.engine;

import ai.tock.nlp.core.Application;
import ai.tock.nlp.core.configuration.NlpApplicationConfiguration;
import ai.tock.nlp.model.EntityBuildContext;
import ai.tock.nlp.model.EntityContext;
import ai.tock.nlp.model.EntityContextKey;
import ai.tock.nlp.model.IntentContext;
import ai.tock.nlp.model.ModelNotInitializedException;
import ai.tock.nlp.model.TokenizerContext;
import ai.tock.nlp.model.service.engine.EntityModelHolder;
import ai.tock.nlp.model.service.engine.IntentModelHolder;
import ai.tock.nlp.model.service.engine.NlpEngineModelIo;
import ai.tock.nlp.model.service.engine.NlpEngineProvider;
import ai.tock.nlp.model.service.engine.NlpModelRepository;
import ai.tock.nlp.model.service.engine.TokenizerModelHolder;
import ai.tock.nlp.model.service.storage.NlpEngineModelDAO;
import ai.tock.nlp.model.service.storage.NlpModelStream;
import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import com.github.salomonbrys.kodein.InjectedProperty;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001@B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0017J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020'J\u000e\u0010(\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u001cJ\u0018\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010+\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050/J\u0014\u00100\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000e0/J\u001e\u00101\u001a\u00020-2\u0006\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u000205J\u001e\u00106\u001a\u00020-2\u0006\u00107\u001a\u00020\u000e2\u0006\u00103\u001a\u00020 2\u0006\u00104\u001a\u000205J:\u00108\u001a\u00020-2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020-0:2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020-0:2\b\b\u0002\u0010>\u001a\u00020&H\u0002J\u0018\u0010?\u001a\u00020\u0017*\u00020\u001b2\n\b\u0002\u0010?\u001a\u0004\u0018\u00010\u0017H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\f\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006A"}, d2={"Lai/tock/nlp/model/service/engine/NlpModelRepository;", "", "()V", "entityModelsCache", "Lcom/google/common/cache/Cache;", "Lai/tock/nlp/model/EntityContextKey;", "Lai/tock/nlp/model/service/engine/NlpModelRepository$ConfiguredModel;", "executor", "Lai/tock/shared/Executor;", "getExecutor", "()Lai/tock/shared/Executor;", "executor$delegate", "Lcom/github/salomonbrys/kodein/InjectedProperty;", "intentModelsCache", "Lai/tock/nlp/model/IntentContext$IntentContextKey;", "logger", "Lmu/KLogger;", "modelDAO", "Lai/tock/nlp/model/service/storage/NlpEngineModelDAO;", "getModelDAO", "()Lai/tock/nlp/model/service/storage/NlpEngineModelDAO;", "modelDAO$delegate", "getConfiguration", "Lai/tock/nlp/core/configuration/NlpApplicationConfiguration;", "context", "Lai/tock/nlp/model/EntityContext;", "provider", "Lai/tock/nlp/model/service/engine/NlpEngineProvider;", "Lai/tock/nlp/model/IntentContext;", "getEntityModelHolder", "Lai/tock/nlp/model/service/engine/EntityModelHolder;", "getIntentModelHolder", "Lai/tock/nlp/model/service/engine/IntentModelHolder;", "getTokenizerModelHolder", "Lai/tock/nlp/model/service/engine/TokenizerModelHolder;", "Lai/tock/nlp/model/TokenizerContext;", "conf", "isEntityModelExist", "", "Lai/tock/nlp/model/EntityBuildContext;", "isIntentModelExist", "loadEntityModel", "contextKey", "loadIntentModel", "removeEntityModelsNotIn", "", "keys", "", "removeIntentModelsNotIn", "saveEntityModel", "entityContextKey", "model", "modelIo", "Lai/tock/nlp/model/service/engine/NlpEngineModelIo;", "saveIntentModel", "intentContextKey", "saveModel", "copy", "Lkotlin/Function1;", "Ljava/io/OutputStream;", "save", "Ljava/io/InputStream;", "retry", "configuration", "ConfiguredModel", "tock-nlp-model-service"})
public final class NlpModelRepository {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final KLogger logger;
    private static final InjectedProperty modelDAO$delegate;
    private static final InjectedProperty executor$delegate;
    private static final Cache<IntentContext.IntentContextKey, ConfiguredModel> intentModelsCache;
    private static final Cache<EntityContextKey, ConfiguredModel> entityModelsCache;
    public static final NlpModelRepository INSTANCE;

    static {
        NlpModelRepository nlpModelRepository;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(NlpModelRepository.class), "modelDAO", "getModelDAO()Lai/tock/nlp/model/service/storage/NlpEngineModelDAO;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(NlpModelRepository.class), "executor", "getExecutor()Lai/tock/shared/Executor;"))};
        INSTANCE = nlpModelRepository = new NlpModelRepository();
        logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        KodeinInjectedBase $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        Object tag$iv = null;
        KodeinInjector kodeinInjector = $receiver$iv.getInjector();
        TypeToken typeToken = (TypeToken)new TypeReference<NlpEngineModelDAO>(){};
        modelDAO$delegate = kodeinInjector.Instance(typeToken, tag$iv);
        $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        tag$iv = null;
        kodeinInjector = $receiver$iv.getInjector();
        typeToken = (TypeToken)new TypeReference<Executor>(){};
        executor$delegate = kodeinInjector.Instance(typeToken, tag$iv);
        Cache cache = CacheBuilder.newBuilder().softValues().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)cache, (String)"CacheBuilder.newBuilder().softValues().build()");
        intentModelsCache = cache;
        Cache cache2 = CacheBuilder.newBuilder().softValues().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)cache2, (String)"CacheBuilder.newBuilder().softValues().build()");
        entityModelsCache = cache2;
        if (PropertiesKt.booleanProperty((String)"tock_nlp_model_refresh", (boolean)true)) {
            nlpModelRepository.getModelDAO().listenIntentModelChanges((Function1<? super String, Unit>)((Function1)1.INSTANCE));
            nlpModelRepository.getModelDAO().listenEntityModelChanges((Function1<? super String, Unit>)((Function1)2.INSTANCE));
        } else {
            logger.info((Function0)3.INSTANCE);
        }
    }

    private final NlpEngineModelDAO getModelDAO() {
        return (NlpEngineModelDAO)modelDAO$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final Executor getExecutor() {
        return (Executor)executor$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @NotNull
    public final TokenizerModelHolder getTokenizerModelHolder(@NotNull TokenizerContext context, @NotNull NlpApplicationConfiguration conf) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)conf, (String)"conf");
        return new TokenizerModelHolder(context.getLanguage(), conf);
    }

    @NotNull
    public final NlpApplicationConfiguration getConfiguration(@NotNull IntentContext context, @NotNull NlpEngineProvider provider2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)provider2, (String)"provider");
        return this.getIntentModelHolder(context, provider2).getConfiguration();
    }

    @NotNull
    public final IntentModelHolder getIntentModelHolder(@NotNull IntentContext context, @NotNull NlpEngineProvider provider2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)provider2, (String)"provider");
        Object object = context.key();
        boolean bl = false;
        boolean bl2 = false;
        IntentContext.IntentContextKey key = object;
        boolean bl3 = false;
        object = (ConfiguredModel)intentModelsCache.get((Object)key, (Callable)new Callable<ConfiguredModel>(key, provider2){
            final /* synthetic */ IntentContext.IntentContextKey $key;
            final /* synthetic */ NlpEngineProvider $provider$inlined;
            {
                this.$key = intentContextKey;
                this.$provider$inlined = nlpEngineProvider;
            }

            @NotNull
            public final ConfiguredModel call() {
                return NlpModelRepository.access$loadIntentModel(NlpModelRepository.INSTANCE, this.$key, this.$provider$inlined);
            }
        });
        bl = false;
        bl2 = false;
        Object it = object;
        boolean bl4 = false;
        Application application = context.getApplication();
        Object object2 = ((ConfiguredModel)it).getNativeModel();
        if (object2 == null) {
            Intrinsics.throwNpe();
        }
        return new IntentModelHolder(application, object2, ((ConfiguredModel)it).getConfiguration(), ((ConfiguredModel)it).getLastUpdate());
    }

    private final NlpApplicationConfiguration configuration(@NotNull NlpEngineProvider $this$configuration, NlpApplicationConfiguration configuration) {
        NlpApplicationConfiguration nlpApplicationConfiguration = configuration;
        if (nlpApplicationConfiguration == null) {
            nlpApplicationConfiguration = $this$configuration.getModelBuilder().defaultNlpApplicationConfiguration();
        }
        return nlpApplicationConfiguration;
    }

    static /* synthetic */ NlpApplicationConfiguration configuration$default(NlpModelRepository nlpModelRepository, NlpEngineProvider nlpEngineProvider, NlpApplicationConfiguration nlpApplicationConfiguration, int n, Object object) {
        if ((n & 1) != 0) {
            nlpApplicationConfiguration = null;
        }
        return nlpModelRepository.configuration(nlpEngineProvider, nlpApplicationConfiguration);
    }

    private final ConfiguredModel loadIntentModel(IntentContext.IntentContextKey contextKey, NlpEngineProvider provider2) {
        NlpModelStream inputStream = this.getModelDAO().getIntentModelInputStream(contextKey);
        if (inputStream != null) {
            logger.debug((Function0)new Function0<String>(contextKey){
                final /* synthetic */ IntentContext.IntentContextKey $contextKey;

                @NotNull
                public final String invoke() {
                    return "load intent model for " + this.$contextKey;
                }
                {
                    this.$contextKey = intentContextKey;
                    super(0);
                }
            });
            Object model = provider2.getModelIo().loadIntentModel(inputStream);
            return new ConfiguredModel(model, inputStream.getUpdatedDate(), this.configuration(provider2, inputStream.getConfiguration()));
        }
        throw (Throwable)new ModelNotInitializedException("no intent model found for " + contextKey);
    }

    @NotNull
    public final NlpApplicationConfiguration getConfiguration(@NotNull EntityContext context, @NotNull NlpEngineProvider provider2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)provider2, (String)"provider");
        EntityModelHolder entityModelHolder = this.getEntityModelHolder(context, provider2);
        if (entityModelHolder == null || (entityModelHolder = entityModelHolder.getConfiguration()) == null) {
            entityModelHolder = provider2.getModelBuilder().defaultNlpApplicationConfiguration();
        }
        return entityModelHolder;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final EntityModelHolder getEntityModelHolder(@NotNull EntityContext context, @NotNull NlpEngineProvider provider2) {
        void lastUpdate;
        void nativeModel;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)provider2, (String)"provider");
        Object object = context.key();
        boolean bl = false;
        boolean bl2 = false;
        EntityContextKey it = (EntityContextKey)object;
        boolean bl3 = false;
        object = (ConfiguredModel)entityModelsCache.get((Object)it, (Callable)new Callable<ConfiguredModel>(it, provider2){
            final /* synthetic */ EntityContextKey $it;
            final /* synthetic */ NlpEngineProvider $provider$inlined;
            {
                this.$it = entityContextKey;
                this.$provider$inlined = nlpEngineProvider;
            }

            @NotNull
            public final ConfiguredModel call() {
                return NlpModelRepository.access$loadEntityModel(NlpModelRepository.INSTANCE, this.$it, this.$provider$inlined);
            }
        });
        bl = false;
        bl2 = false;
        Object $dstr$nativeModel$lastUpdate$conf = object;
        boolean bl4 = false;
        Object object2 = ((ConfiguredModel)$dstr$nativeModel$lastUpdate$conf).component1();
        Instant instant = ((ConfiguredModel)$dstr$nativeModel$lastUpdate$conf).component2();
        NlpApplicationConfiguration conf = ((ConfiguredModel)$dstr$nativeModel$lastUpdate$conf).component3();
        return nativeModel == null ? null : new EntityModelHolder(nativeModel, conf, (Instant)lastUpdate);
    }

    private final ConfiguredModel loadEntityModel(EntityContextKey contextKey, NlpEngineProvider provider2) {
        NlpModelStream nlpModelStream = this.getModelDAO().getEntityModelInputStream(contextKey);
        if (nlpModelStream != null) {
            NlpModelStream nlpModelStream2 = nlpModelStream;
            boolean bl = false;
            boolean bl2 = false;
            NlpModelStream inputStream = nlpModelStream2;
            boolean bl3 = false;
            logger.debug((Function0)new Function0<String>(contextKey, provider2){
                final /* synthetic */ EntityContextKey $contextKey$inlined;
                final /* synthetic */ NlpEngineProvider $provider$inlined;
                {
                    this.$contextKey$inlined = entityContextKey;
                    this.$provider$inlined = nlpEngineProvider;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "load entity model for " + this.$contextKey$inlined;
                }
            });
            Object model = provider2.getModelIo().loadEntityModel(inputStream);
            return new ConfiguredModel(model, inputStream.getUpdatedDate(), INSTANCE.configuration(provider2, inputStream.getConfiguration()));
        }
        Instant instant = Instant.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"now()");
        return new ConfiguredModel(null, instant, NlpModelRepository.configuration$default(this, provider2, null, 1, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveModel(Function1<? super OutputStream, Unit> copy, Function1<? super InputStream, Unit> save, boolean retry) {
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
        CountDownLatch latch = new CountDownLatch(1);
        this.getExecutor().executeBlocking((Function0)new Function0<Unit>(pipedOutputStream, copy, latch){
            final /* synthetic */ PipedOutputStream $pipedOutputStream;
            final /* synthetic */ Function1 $copy;
            final /* synthetic */ CountDownLatch $latch;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Closeable closeable = this.$pipedOutputStream;
                boolean bl = false;
                Throwable throwable = null;
                try {
                    PipedOutputStream it = (PipedOutputStream)closeable;
                    boolean bl2 = false;
                    try {
                        NlpModelRepository.access$getLogger$p(NlpModelRepository.INSTANCE).debug((Function0)saveModel.1.1.INSTANCE);
                        this.$copy.invoke((Object)it);
                    }
                    catch (Throwable t) {
                        if (this.$latch.getCount() == 0L) {
                            LoggersKt.debug((KLogger)NlpModelRepository.access$getLogger$p(NlpModelRepository.INSTANCE), (Throwable)t);
                        } else {
                            LoggersKt.error((KLogger)NlpModelRepository.access$getLogger$p(NlpModelRepository.INSTANCE), (Throwable)t);
                        }
                    }
                    finally {
                        NlpModelRepository.access$getLogger$p(NlpModelRepository.INSTANCE).debug((Function0)saveModel.1.2.INSTANCE);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                this.$latch.await(1L, TimeUnit.MINUTES);
                NlpModelRepository.access$getLogger$p(NlpModelRepository.INSTANCE).debug((Function0)saveModel.2.INSTANCE);
            }
            {
                this.$pipedOutputStream = pipedOutputStream;
                this.$copy = function1;
                this.$latch = countDownLatch;
                super(0);
            }
        });
        Closeable closeable = pipedInputStream;
        boolean bl = false;
        Throwable throwable = null;
        try {
            block11: {
                PipedInputStream it = (PipedInputStream)closeable;
                boolean bl2 = false;
                try {
                    logger.debug((Function0)saveModel.2.1.INSTANCE);
                    save.invoke((Object)it);
                }
                catch (Exception e) {
                    LoggersKt.debug((KLogger)logger, (Throwable)e);
                    if (retry) {
                        INSTANCE.saveModel(copy, save, false);
                        break block11;
                    }
                    throw (Throwable)e;
                }
                finally {
                    logger.debug((Function0)saveModel.2.2.INSTANCE);
                    latch.countDown();
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static /* synthetic */ void saveModel$default(NlpModelRepository nlpModelRepository, Function1 function1, Function1 function12, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        nlpModelRepository.saveModel((Function1<? super OutputStream, Unit>)function1, (Function1<? super InputStream, Unit>)function12, bl);
    }

    public final void saveIntentModel(@NotNull IntentContext.IntentContextKey intentContextKey, @NotNull IntentModelHolder model, @NotNull NlpEngineModelIo modelIo) {
        Intrinsics.checkParameterIsNotNull((Object)intentContextKey, (String)"intentContextKey");
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)modelIo, (String)"modelIo");
        NlpModelRepository.saveModel$default(this, (Function1)new Function1<OutputStream, Unit>(modelIo, model){
            final /* synthetic */ NlpEngineModelIo $modelIo;
            final /* synthetic */ IntentModelHolder $model;

            public final void invoke(@NotNull OutputStream it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$modelIo.copyIntentModel(this.$model.getNativeModel(), it);
            }
            {
                this.$modelIo = nlpEngineModelIo;
                this.$model = intentModelHolder;
                super(1);
            }
        }, (Function1)new Function1<InputStream, Unit>(intentContextKey){
            final /* synthetic */ IntentContext.IntentContextKey $intentContextKey;

            public final void invoke(@NotNull InputStream it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                NlpModelRepository.access$getModelDAO$p(NlpModelRepository.INSTANCE).saveIntentModel(this.$intentContextKey, it);
            }
            {
                this.$intentContextKey = intentContextKey;
                super(1);
            }
        }, false, 4, null);
    }

    public final void saveEntityModel(@NotNull EntityContextKey entityContextKey, @NotNull EntityModelHolder model, @NotNull NlpEngineModelIo modelIo) {
        Intrinsics.checkParameterIsNotNull((Object)entityContextKey, (String)"entityContextKey");
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)modelIo, (String)"modelIo");
        NlpModelRepository.saveModel$default(this, (Function1)new Function1<OutputStream, Unit>(modelIo, model){
            final /* synthetic */ NlpEngineModelIo $modelIo;
            final /* synthetic */ EntityModelHolder $model;

            public final void invoke(@NotNull OutputStream it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$modelIo.copyEntityModel(this.$model.getNativeModel(), it);
            }
            {
                this.$modelIo = nlpEngineModelIo;
                this.$model = entityModelHolder;
                super(1);
            }
        }, (Function1)new Function1<InputStream, Unit>(entityContextKey){
            final /* synthetic */ EntityContextKey $entityContextKey;

            public final void invoke(@NotNull InputStream it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                NlpModelRepository.access$getModelDAO$p(NlpModelRepository.INSTANCE).saveEntityModel(this.$entityContextKey, it);
            }
            {
                this.$entityContextKey = entityContextKey;
                super(1);
            }
        }, false, 4, null);
    }

    public final boolean isIntentModelExist(@NotNull IntentContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.getModelDAO().getIntentModelLastUpdate(context.key()) != null;
    }

    public final boolean isEntityModelExist(@NotNull EntityBuildContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.getModelDAO().getEntityModelLastUpdate((EntityContextKey)context.key()) != null;
    }

    public final void removeEntityModelsNotIn(@NotNull List<EntityContextKey> keys) {
        Intrinsics.checkParameterIsNotNull(keys, (String)"keys");
        this.getModelDAO().deleteEntityModelsNotIn(keys);
    }

    public final void removeIntentModelsNotIn(@NotNull List<IntentContext.IntentContextKey> keys) {
        Intrinsics.checkParameterIsNotNull(keys, (String)"keys");
        this.getModelDAO().deleteIntentModelsNotIn(keys);
    }

    private NlpModelRepository() {
    }

    public static final /* synthetic */ KLogger access$getLogger$p(NlpModelRepository $this) {
        NlpModelRepository nlpModelRepository = $this;
        return logger;
    }

    public static final /* synthetic */ NlpEngineModelDAO access$getModelDAO$p(NlpModelRepository $this) {
        return $this.getModelDAO();
    }

    public static final /* synthetic */ Cache access$getIntentModelsCache$p(NlpModelRepository $this) {
        NlpModelRepository nlpModelRepository = $this;
        return intentModelsCache;
    }

    public static final /* synthetic */ Cache access$getEntityModelsCache$p(NlpModelRepository $this) {
        NlpModelRepository nlpModelRepository = $this;
        return entityModelsCache;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J)\u0010\u0011\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lai/tock/nlp/model/service/engine/NlpModelRepository$ConfiguredModel;", "", "nativeModel", "lastUpdate", "Ljava/time/Instant;", "configuration", "Lai/tock/nlp/core/configuration/NlpApplicationConfiguration;", "(Ljava/lang/Object;Ljava/time/Instant;Lai/tock/nlp/core/configuration/NlpApplicationConfiguration;)V", "getConfiguration", "()Lai/tock/nlp/core/configuration/NlpApplicationConfiguration;", "getLastUpdate", "()Ljava/time/Instant;", "getNativeModel", "()Ljava/lang/Object;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "tock-nlp-model-service"})
    private static final class ConfiguredModel {
        @Nullable
        private final Object nativeModel;
        @NotNull
        private final Instant lastUpdate;
        @NotNull
        private final NlpApplicationConfiguration configuration;

        @Nullable
        public final Object getNativeModel() {
            return this.nativeModel;
        }

        @NotNull
        public final Instant getLastUpdate() {
            return this.lastUpdate;
        }

        @NotNull
        public final NlpApplicationConfiguration getConfiguration() {
            return this.configuration;
        }

        public ConfiguredModel(@Nullable Object nativeModel, @NotNull Instant lastUpdate, @NotNull NlpApplicationConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull((Object)lastUpdate, (String)"lastUpdate");
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            this.nativeModel = nativeModel;
            this.lastUpdate = lastUpdate;
            this.configuration = configuration;
        }

        @Nullable
        public final Object component1() {
            return this.nativeModel;
        }

        @NotNull
        public final Instant component2() {
            return this.lastUpdate;
        }

        @NotNull
        public final NlpApplicationConfiguration component3() {
            return this.configuration;
        }

        @NotNull
        public final ConfiguredModel copy(@Nullable Object nativeModel, @NotNull Instant lastUpdate, @NotNull NlpApplicationConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull((Object)lastUpdate, (String)"lastUpdate");
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            return new ConfiguredModel(nativeModel, lastUpdate, configuration);
        }

        public static /* synthetic */ ConfiguredModel copy$default(ConfiguredModel configuredModel, Object object, Instant instant, NlpApplicationConfiguration nlpApplicationConfiguration, int n, Object object2) {
            if ((n & 1) != 0) {
                object = configuredModel.nativeModel;
            }
            if ((n & 2) != 0) {
                instant = configuredModel.lastUpdate;
            }
            if ((n & 4) != 0) {
                nlpApplicationConfiguration = configuredModel.configuration;
            }
            return configuredModel.copy(object, instant, nlpApplicationConfiguration);
        }

        @NotNull
        public String toString() {
            return "ConfiguredModel(nativeModel=" + this.nativeModel + ", lastUpdate=" + this.lastUpdate + ", configuration=" + this.configuration + ")";
        }

        public int hashCode() {
            Object object = this.nativeModel;
            Instant instant = this.lastUpdate;
            NlpApplicationConfiguration nlpApplicationConfiguration = this.configuration;
            return ((object != null ? object.hashCode() : 0) * 31 + (instant != null ? ((Object)instant).hashCode() : 0)) * 31 + (nlpApplicationConfiguration != null ? nlpApplicationConfiguration.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ConfiguredModel)) break block3;
                    ConfiguredModel configuredModel = (ConfiguredModel)object;
                    if (!Intrinsics.areEqual((Object)this.nativeModel, (Object)configuredModel.nativeModel) || !Intrinsics.areEqual((Object)this.lastUpdate, (Object)configuredModel.lastUpdate) || !Intrinsics.areEqual((Object)this.configuration, (Object)configuredModel.configuration)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

