/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.model.service.engine;

import ai.tock.nlp.core.NlpEngineType;
import ai.tock.nlp.model.ClassifierContext;
import ai.tock.nlp.model.ClassifierContextKey;
import ai.tock.nlp.model.EntityCallContext;
import ai.tock.nlp.model.EntityContext;
import ai.tock.nlp.model.IntentContext;
import ai.tock.nlp.model.TokenizerContext;
import ai.tock.nlp.model.service.engine.EntityClassifier;
import ai.tock.nlp.model.service.engine.EntityModelHolder;
import ai.tock.nlp.model.service.engine.IntentClassifier;
import ai.tock.nlp.model.service.engine.IntentModelHolder;
import ai.tock.nlp.model.service.engine.NlpEngineModelBuilder;
import ai.tock.nlp.model.service.engine.NlpEngineModelIo;
import ai.tock.nlp.model.service.engine.NlpEngineProvider;
import ai.tock.nlp.model.service.engine.NlpModelRepository;
import ai.tock.nlp.model.service.engine.SupportedNlpEnginesProvider;
import ai.tock.nlp.model.service.engine.Tokenizer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u000fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\u0012\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015J\u001e\u0010\u0016\u001a\u00020\u0017\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015J\u0015\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\u001dJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\u000fJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u001fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lai/tock/nlp/model/service/engine/NlpEngineRepository;", "", "()V", "repository", "", "Lai/tock/nlp/core/NlpEngineType;", "Lai/tock/nlp/model/service/engine/NlpEngineProvider;", "getEntityClassifier", "Lai/tock/nlp/model/service/engine/EntityClassifier;", "context", "Lai/tock/nlp/model/EntityCallContext;", "modelHolder", "Lai/tock/nlp/model/service/engine/EntityModelHolder;", "getIntentClassifier", "Lai/tock/nlp/model/service/engine/IntentClassifier;", "Lai/tock/nlp/model/IntentContext;", "Lai/tock/nlp/model/service/engine/IntentModelHolder;", "getModelBuilder", "Lai/tock/nlp/model/service/engine/NlpEngineModelBuilder;", "T", "Lai/tock/nlp/model/ClassifierContextKey;", "Lai/tock/nlp/model/ClassifierContext;", "getModelIo", "Lai/tock/nlp/model/service/engine/NlpEngineModelIo;", "getProvider", "nlpEngineType", "getProvider$tock_nlp_model_service", "getTokenizer", "Lai/tock/nlp/model/service/engine/Tokenizer;", "Lai/tock/nlp/model/EntityContext;", "registeredNlpEngineTypes", "", "tock-nlp-model-service"})
@SourceDebugExtension(value={"SMAP\nNlpEngineRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NlpEngineRepository.kt\nai/tock/nlp/model/service/engine/NlpEngineRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1194#2,2:102\n1222#2,4:104\n*S KotlinDebug\n*F\n+ 1 NlpEngineRepository.kt\nai/tock/nlp/model/service/engine/NlpEngineRepository\n*L\n35#1:102,2\n35#1:104,4\n*E\n"})
public final class NlpEngineRepository {
    @NotNull
    public static final NlpEngineRepository INSTANCE;
    @NotNull
    private static final Map<NlpEngineType, NlpEngineProvider> repository;

    private NlpEngineRepository() {
    }

    @NotNull
    public final Set<NlpEngineType> registeredNlpEngineTypes() {
        return repository.keySet();
    }

    @NotNull
    public final NlpEngineProvider getProvider$tock_nlp_model_service(@NotNull NlpEngineType nlpEngineType) {
        Intrinsics.checkNotNullParameter((Object)nlpEngineType, (String)"nlpEngineType");
        NlpEngineProvider nlpEngineProvider = repository.get(nlpEngineType);
        if (nlpEngineProvider == null) {
            throw new IllegalStateException(("Unknown nlp engine type : " + nlpEngineType).toString());
        }
        return nlpEngineProvider;
    }

    @NotNull
    public final Tokenizer getTokenizer(@NotNull IntentContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        NlpEngineProvider it = this.getProvider$tock_nlp_model_service(context.getEngineType());
        boolean bl = false;
        return it.getTokenizer(NlpModelRepository.INSTANCE.getTokenizerModelHolder(new TokenizerContext(context), NlpModelRepository.INSTANCE.getConfiguration(context, it)));
    }

    @NotNull
    public final Tokenizer getTokenizer(@NotNull EntityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        NlpEngineProvider it = this.getProvider$tock_nlp_model_service(context.getEngineType());
        boolean bl = false;
        return it.getTokenizer(NlpModelRepository.INSTANCE.getTokenizerModelHolder(new TokenizerContext(context), NlpModelRepository.INSTANCE.getConfiguration(context, it)));
    }

    @NotNull
    public final IntentClassifier getIntentClassifier(@NotNull IntentContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        NlpEngineProvider it = this.getProvider$tock_nlp_model_service(context.getEngineType());
        boolean bl = false;
        return it.getIntentClassifier(NlpModelRepository.INSTANCE.getIntentModelHolder(context, it));
    }

    @NotNull
    public final IntentClassifier getIntentClassifier(@NotNull IntentContext context, @NotNull IntentModelHolder modelHolder) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelHolder, (String)"modelHolder");
        return this.getProvider$tock_nlp_model_service(context.getEngineType()).getIntentClassifier(modelHolder);
    }

    @Nullable
    public final EntityClassifier getEntityClassifier(@NotNull EntityCallContext context) {
        EntityClassifier entityClassifier;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        NlpEngineProvider provider2 = this.getProvider$tock_nlp_model_service(context.getEngineType());
        boolean bl = false;
        EntityModelHolder entityModelHolder = NlpModelRepository.INSTANCE.getEntityModelHolder((EntityContext)context, provider2);
        if (entityModelHolder != null) {
            EntityModelHolder model = entityModelHolder;
            boolean bl2 = false;
            entityClassifier = provider2.getEntityClassifier(model);
        } else {
            entityClassifier = null;
        }
        return entityClassifier;
    }

    @Nullable
    public final EntityClassifier getEntityClassifier(@NotNull EntityCallContext context, @Nullable EntityModelHolder modelHolder) {
        EntityClassifier entityClassifier;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        NlpEngineProvider provider2 = this.getProvider$tock_nlp_model_service(context.getEngineType());
        boolean bl = false;
        EntityModelHolder entityModelHolder = modelHolder;
        if (entityModelHolder != null) {
            EntityModelHolder model = entityModelHolder;
            boolean bl2 = false;
            entityClassifier = provider2.getEntityClassifier(model);
        } else {
            entityClassifier = null;
        }
        return entityClassifier;
    }

    @NotNull
    public final <T extends ClassifierContextKey> NlpEngineModelBuilder getModelBuilder(@NotNull ClassifierContext<? extends T> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        return this.getProvider$tock_nlp_model_service(context.getEngineType()).getModelBuilder();
    }

    @NotNull
    public final <T extends ClassifierContextKey> NlpEngineModelIo getModelIo(@NotNull ClassifierContext<? extends T> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        return this.getProvider$tock_nlp_model_service(context.getEngineType()).getModelIo();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        INSTANCE = new NlpEngineRepository();
        Iterable $this$associateBy$iv = SupportedNlpEnginesProvider.INSTANCE.engines();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            NlpEngineProvider nlpEngineProvider = (NlpEngineProvider)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getType(), element$iv$iv);
        }
        repository = destination$iv$iv;
    }
}

