/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.model;

import ai.tock.nlp.core.CallContext;
import ai.tock.nlp.core.NlpEngineType;
import ai.tock.nlp.model.ClassifierContext;
import ai.tock.nlp.model.ClassifierContextKey;
import ai.tock.nlp.model.EntityContext;
import ai.tock.nlp.model.IntentContext;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u001d\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\t\u0010\u0019\u001a\u00020\rH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u000fH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0011H\u00c6\u0003J'\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\b\u0010#\u001a\u00020\u0011H\u0016J\b\u0010$\u001a\u00020\u0000H\u0016J\t\u0010%\u001a\u00020\u0011H\u00d6\u0001R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lai/tock/nlp/model/TokenizerContext;", "Lai/tock/nlp/model/ClassifierContext;", "Lai/tock/nlp/model/ClassifierContextKey;", "callContext", "Lai/tock/nlp/core/CallContext;", "(Lai/tock/nlp/core/CallContext;)V", "intentContext", "Lai/tock/nlp/model/IntentContext;", "(Lai/tock/nlp/model/IntentContext;)V", "entityContext", "Lai/tock/nlp/model/EntityContext;", "(Lai/tock/nlp/model/EntityContext;)V", "language", "Ljava/util/Locale;", "engineType", "Lai/tock/nlp/core/NlpEngineType;", "applicationName", "", "(Ljava/util/Locale;Lai/tock/nlp/core/NlpEngineType;Ljava/lang/String;)V", "getApplicationName", "()Ljava/lang/String;", "getEngineType", "()Lai/tock/nlp/core/NlpEngineType;", "getLanguage", "()Ljava/util/Locale;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "id", "key", "toString", "tock-nlp-model-shared"})
public final class TokenizerContext
implements ClassifierContext<TokenizerContext>,
ClassifierContextKey {
    @NotNull
    private final Locale language;
    @NotNull
    private final NlpEngineType engineType;
    @NotNull
    private final String applicationName;

    public TokenizerContext(@NotNull Locale language, @NotNull NlpEngineType engineType, @NotNull String applicationName) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)engineType, (String)"engineType");
        Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
        this.language = language;
        this.engineType = engineType;
        this.applicationName = applicationName;
    }

    @Override
    @NotNull
    public Locale getLanguage() {
        return this.language;
    }

    @Override
    @NotNull
    public NlpEngineType getEngineType() {
        return this.engineType;
    }

    @Override
    @NotNull
    public String getApplicationName() {
        return this.applicationName;
    }

    public TokenizerContext(@NotNull CallContext callContext) {
        Intrinsics.checkNotNullParameter((Object)callContext, (String)"callContext");
        this(callContext.getLanguage(), callContext.getEngineType(), callContext.getApplication().getName());
    }

    public TokenizerContext(@NotNull IntentContext intentContext) {
        Intrinsics.checkNotNullParameter((Object)intentContext, (String)"intentContext");
        this(intentContext.getLanguage(), intentContext.getEngineType(), intentContext.getApplication().getName());
    }

    public TokenizerContext(@NotNull EntityContext entityContext) {
        Intrinsics.checkNotNullParameter((Object)entityContext, (String)"entityContext");
        this(entityContext.getLanguage(), entityContext.getEngineType(), entityContext.getApplicationName());
    }

    @Override
    @NotNull
    public TokenizerContext key() {
        return this;
    }

    @Override
    @NotNull
    public String id() {
        return this.getLanguage() + "-" + this.getEngineType().getName();
    }

    @NotNull
    public final Locale component1() {
        return this.language;
    }

    @NotNull
    public final NlpEngineType component2() {
        return this.engineType;
    }

    @NotNull
    public final String component3() {
        return this.applicationName;
    }

    @NotNull
    public final TokenizerContext copy(@NotNull Locale language, @NotNull NlpEngineType engineType, @NotNull String applicationName) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)engineType, (String)"engineType");
        Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
        return new TokenizerContext(language, engineType, applicationName);
    }

    public static /* synthetic */ TokenizerContext copy$default(TokenizerContext tokenizerContext, Locale locale, NlpEngineType nlpEngineType, String string, int n, Object object) {
        if ((n & 1) != 0) {
            locale = tokenizerContext.language;
        }
        if ((n & 2) != 0) {
            nlpEngineType = tokenizerContext.engineType;
        }
        if ((n & 4) != 0) {
            string = tokenizerContext.applicationName;
        }
        return tokenizerContext.copy(locale, nlpEngineType, string);
    }

    @NotNull
    public String toString() {
        return "TokenizerContext(language=" + this.language + ", engineType=" + this.engineType + ", applicationName=" + this.applicationName + ")";
    }

    public int hashCode() {
        int result = this.language.hashCode();
        result = result * 31 + this.engineType.hashCode();
        result = result * 31 + this.applicationName.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TokenizerContext)) {
            return false;
        }
        TokenizerContext tokenizerContext = (TokenizerContext)other;
        if (!Intrinsics.areEqual((Object)this.language, (Object)tokenizerContext.language)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.engineType, (Object)tokenizerContext.engineType)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.applicationName, (Object)tokenizerContext.applicationName);
    }
}

